/*
 * dviops.h --
 *
 *	DVI machine opcodes and definitions.
 *
 * Copyright  1999 Anselm Lingnau <lingnau@tm.informatik.uni-frankfurt.de>
 * See file COPYING for conditions on use and distribution.
 *
 * $Id: dviOps.h,v 1.1.1.1 1999/06/10 12:36:50 lingnau Exp $
 */
 
#if !DVIOPS_H

#define D_ID		2	/* Format ID byte */
#define D_PAD		223	/* Padding at end of DVI file */

#define D_SETCHAR0	0	/* Typeset character numbers 0 ... 127 */
#define D_SET1		128	/* Typeset character */
#define D_SET2		129
#define D_SET3		130
#define D_SET4		131
#define D_SETRULE	132	/* Typeset rule */
#define D_PUT1		133	/* Typeset character, don't move */
#define D_PUT2		134
#define D_PUT3		135
#define D_PUT4		136
#define D_PUTRULE	137	/* Typeset rule, don't move */
#define D_NOP		138	/* No operation */
#define D_BOP		139	/* Beginning of page */
#define D_EOP		140	/* End of page */
#define D_PUSH		141	/* Push current position, movements and font */
#define D_POP		142	/* Pop current position, movements and font */
#define D_RIGHT1	143	/* Move sideways */
#define D_RIGHT2	144
#define D_RIGHT3	145
#define D_RIGHT4	146
#define D_W0		147	/* Move sideways by content of W register */
#define D_W1		148	/* Move sideways and set W register */
#define D_W2		149
#define D_W3		150
#define D_W4		151
#define D_X0		152	/* Move sideways by content of X register */
#define D_X1		153	/* Move sideways and set X register */
#define D_X2		154
#define D_X3		155
#define D_X4		156
#define D_DOWN1		157	/* Move vertically */
#define D_DOWN2		158
#define D_DOWN3		159
#define D_DOWN4		160
#define	D_Y0		161	/* Move vertically by content of Y register */
#define D_Y1		162	/* Move vertically and set Y register */
#define D_Y2		163
#define D_Y3		164
#define D_Y4		165
#define D_Z0		166	/* Move vertically by content of Z register */
#define D_Z1		167	/* Move vertically and set Z register */
#define D_Z2		168
#define D_Z3		169
#define D_Z4		170
#define D_FNTNUM0	171	/* Set current font to one of 0 ... 64 */
#define D_FNT1		235	/* Set current font to argument */
#define D_FNT2		236
#define D_FNT3		237
#define D_FNT4		238
#define D_XXX1		239	/* Special command */
#define D_XXX2		240
#define D_XXX3		241
#define D_XXX4		242
#define D_FNTDEF1	243	/* Define font */
#define D_FNTDEF2	244
#define D_FNTDEF3	245
#define D_FNTDEF4	246
#define D_PRE		247	/* Start of preamble */
#define D_POST		248	/* Start of postamble */
#define D_POSTPOST	249	/* End of postamble */

#define DVIOPS_H 1
#endif
