# menu.tcl -- Make TkDVI menu bars.
# Copyright  1999 Anselm Lingnau.
# See file COPYING for conditions on use and distribution.
# $Id: menu.tcl,v 1.10 2001/08/10 11:35:00 anselm Exp $
#
# This code borrows heavily from Brent Welch's book. Thanks Brent!

package provide tkdvi::menu 1.0

# Read message catalogs just once for all TkDVI subpackages
package require msgcat
namespace eval ::tkdvi {
    if {![info exists msgCatsLoaded]} {
	::msgcat::mcload [file join [file dirname [info script]] msgs]
	set msgCatsLoaded 1
    }
}

namespace eval tkdvi::menu {
    proc menubar {name menuName {top {}}} {
	variable Menu
	set m [menu $menuName]
	foreach b [option get $m menulist {}] {
	    if [catch {menu $m.$b}] {
		menu $m.$b -font fixed
	    }
	    set label [::msgcat::mc [option get $m.$b text {}]]
	    set ul [string first & $label]
	    regsub {&} $label {} label
	    set cmd [list $m add cascade -label $label -menu $m.$b]
	    if [catch $cmd t] {
		eval $cmd {-font fixed}
	    }
	    if {$ul >= 0} {
		$m entryconfigure end -underline $ul
	    }
	    define $name $m.$b $top
	}
    }
    proc define {name menu {top {}}} {
	variable Menu
	variable Extra

	# Generate list of entries for this menu, including user-defined
	# ones.
	set entries [option get $menu entrylist {}]
	set exname [string range $menu [expr {[string last . $menu]+1}] end]
	if {[info exists Extra($exname)]} {
	    set i [lsearch -exact $entries {+}]
	    if {$i == -1} {
		set entries [concat $entries - $Extra($exname)]
	    } else {
		set entries \
			[eval [list lreplace $entries $i $i] - $Extra($exname)]
	    }
	} else {
	    set i [lsearch -exact $entries +]
	    set entries [lreplace $entries $i $i]
	}
	foreach e $entries {
	    if {$e == "-"} {
		$menu add separator
		continue
	    }
	    set onv 1
	    set offv 0
	    set l [::msgcat::mc [option get $menu l_$e {}]]
	    set ul [string first & $l]
	    regsub {&} $l {} l
	    set c [option get $menu c_$e {}]
	    set v [option get $menu v_$e {}]
	    set onv [option get $menu onv_$e {}]
	    set offv [option get $menu offv_$e {}]
	    set accel [option get $menu a_$e {}]
	    regsub -all {%T} $c $top c
	    regsub -all {%M} $c $menu c
	    regsub -all {%T} $v $top v
	    regsub -all {%M} $v $menu v
	    switch -- [option get $menu t_$e {}] {
		check {
		    $menu add checkbutton -label $l -variable $v
		    if {$c != {}} {
			$menu entryconfigure end -command $c
		    }
		    if {$onv != {}} {
			$menu entryconfigure end -onvalue $onv
		    }
		    if {$offv != {}} {
			$menu entryconfigure end -offvalue $offv
		    }
		}
		radio {
		    $menu add radiobutton -label $l -variable $v -value $e
		}
		cascade {
		    set sub [option get $menu m_$e {}]
		    set post [option get $menu p_$e {}]
		    if {$post != {}} {
			regsub -all {%T} $post $top post
			regsub -all {%S} $post $menu.$sub post
			set submenu [menu $menu.$sub -postcommand $post]
			$menu add cascade -label $l -menu $submenu
		    } elseif {[string length $sub] != 0} {
			set submenu [menu $menu.$sub]
			regsub -all {%S} $c $submenu c
			$menu add cascade -label $l -command $c -menu $submenu
			define $name $submenu $top
		    }
		}
		default {
		    $menu add command -label $l -command $c
		}
	    }
	    if {$ul >= 0} {
		$menu entryconfigure end -underline $ul
	    }
	    if {[string length $accel] > 0} {
		$menu entryconfigure end -accelerator $accel
	    }
	    set Menu($name,$l) [list $menu [$menu index end]]
	}
    }
    proc finditem {name title} {
	variable Menu
	set result {}
	foreach i [array names Menu $name,$title] {
	    set result [concat $result $Menu($i)]
	}
	return $result
    }
    proc accelerators {w menu} {
	set last [$menu index last]
	for {set i 0} {$i <= $last} {incr i} {
	    set type [$menu type $i]
	    if {[string compare $type cascade] == 0} {
		accelerators $w [$menu entrycget $i -menu]
	    } elseif {$type != "separator" && $type != "tearoff"} {
		set accel [$menu entrycget $i -accel]
		if {[string length $accel] > 0} {
		    regsub -all {\+} $accel {-} accel
		    regsub -all {Ctrl} $accel Control accel
		    bind $w <$accel> [list $menu invoke $i]
		    regsub -all -- {-(\w)$} $accel {-[string tolower \1]} accel
		    set accel [subst -nobackslashes -novariables $accel]
		    bind $w <$accel> [list $menu invoke $i]
		}
	    }
	}
    }
    proc extra {menu item} {
	variable Extra
	if {![info exists Extra($menu)]} {
	    set Extra($menu) $item
	} else {
	    lappend Extra($menu) $item
	}
    }
}
