/* basename.c -- return the part of the filename after the last slash
   Copyright (C) 1990, 91, 92, 93, 94 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#if defined(HAVE_STRING_H)
#include <string.h>
#else
#include <strings.h>
#ifndef strrchr
#define strrchr rindex
#endif
#endif

/* Return the last component of pathname FNAME, with leading slashes
   compressed into one slash. */

char *
basename (fname)
     char *fname;
{
  char *p;

  /* For "/", "//", etc., return "/". */
  for (p = fname; *p == '/'; ++p)
    /* Do nothing. */ ;
  if (*p == '\0')
    return p - 1;
  p = strrchr (fname, '/');
  return (p == NULL ? fname : p + 1);
}
