// -*- C++ -*-

//
//  Xdvips frontend to dvips
//
//  Copyright (C) 1996 Christoph Neerfeld
//  email:  Christoph.Neerfeld@mail.bonn.netsurf.de
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//


extern "C" {
#include <forms.h>
#include "xdvips.h"
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <sys/time.h>
}

#include <iostream.h>
#include <fstream.h>
#include <String.h>


FD_fr1 *fr1;

const char DEF_X_RES[] = "360"; // change this if you want another default x-resolution
const char DEF_Y_RES[] = "360"; // change this if you want another default y-resolution

void f_dummy (FL_OBJECT *ob, long user_data)
{
}

void f_open (FL_OBJECT *ob, long user_data)
{
  String name, path, s_name;
  name = (String) fl_get_input(fr1->file_in);
  name.at("/", -1) = "*";
  path = name.before("*");
  if (path == "" ) 
    {
      path = ".";
      s_name = name;
    }
  else
    {
      s_name = name.after("*");
    }
  name = (String) fl_show_fselector("Choose a file",(const char*) path, "*.dvi",\
				    (const char *) s_name);
  if( name != "")
    fl_set_input(fr1->file_in, (const char *) name);
}

void f_pages (FL_OBJECT *ob, long user_data)
{

}

void f_create (FL_OBJECT *ob, long user_data)
{
  String progname;
  progname = "dvips ";
  if( !fl_get_button(fr1->all_button))
    {
      if( fl_get_button(fr1->odd_button))
	progname += "-A ";
      else
	progname += "-B ";
    }
  if( (String) fl_get_input(fr1->first_in) != "*")
    progname += "-p " + (String) fl_get_input(fr1->first_in) + " ";
  if( (String) fl_get_input(fr1->last_in) != "*")
    progname += "-l " + (String) fl_get_input(fr1->last_in) + " ";
  if( fl_get_button(fr1->rev_button) )
    progname += "-r ";
  if( fl_get_button(fr1->x_res_but) )
    progname += "-X " + (String) fl_get_input(fr1->x_res_in) + " ";
  if( fl_get_button(fr1->y_res_but) )
    progname += "-Y " + (String) fl_get_input(fr1->y_res_in) + " ";
  if( fl_get_button(fr1->printer_but) )
    progname += "-P " + (String) fl_get_choice_text(fr1->printer_ch) + " ";
  String o_name = fl_get_input(fr1->file_in);
  o_name.at(".dvi", -1) = ".ps";
  progname += "-t " + (String) fl_get_choice_text(fr1->paper_ch) + \
    " -O " + (String) fl_get_input(fr1->x_off_in) + "," + (String) fl_get_input(fr1->y_off_in) + \
    " -o " + o_name + " " + \
    (String) fl_get_input(fr1->file_in);
  system(progname);
}

void f_print (FL_OBJECT *ob, long user_data)
{
  String progname;
  progname = "dvips ";
  if( !fl_get_button(fr1->all_button))
    {
      if( fl_get_button(fr1->odd_button))
	progname += "-A ";
      else
	progname += "-B ";
    }
  if( (String) fl_get_input(fr1->first_in) != "*")
    progname += "-p " + (String) fl_get_input(fr1->first_in) + " ";
  if( (String) fl_get_input(fr1->last_in) != "*")
    progname += "-l " + (String) fl_get_input(fr1->last_in) + " ";
  if( fl_get_button(fr1->rev_button) )
    progname += "-r ";
  if( fl_get_button(fr1->x_res_but) )
    progname += "-X " + (String) fl_get_input(fr1->x_res_in) + " ";
  if( fl_get_button(fr1->y_res_but) )
    progname += "-Y " + (String) fl_get_input(fr1->y_res_in) + " ";
  if( fl_get_button(fr1->printer_but) )
    progname += "-P " + (String) fl_get_choice_text(fr1->printer_ch) + " ";
  String o_name = fl_get_input(fr1->file_in);
  progname += "-t " + (String) fl_get_choice_text(fr1->paper_ch) + \
    " -O " + (String) fl_get_input(fr1->x_off_in) + "," + (String) fl_get_input(fr1->y_off_in) + \
    " " + (String) fl_get_input(fr1->file_in);
  system(progname);
}

void f_quit (FL_OBJECT *ob, long user_data)
{
  fl_finish();
  exit(0);
}

void f_version (FL_OBJECT *ob, long user_data)
{
  fl_show_message("This is Xdvips Version 1.0.1 by Christoph Neerfeld",\
		  "This program is copyrighted, but you may distribute it",\
		  "under the terms of the GNU General Public Licence.");
}

main (int argc, char **argv)
{
  String progname, choice, temp;
  choice = (String) getenv("PRINTER");

  char *xforms_argv[argc];
  int xforms_argc;
  char *prog_argv[argc];
  int prog_argc;
  xforms_argv[0] = argv[0];
  prog_argv[0]   = argv[0];
  int j = 1;
  int g = 1;
  for (int i = 1; i < argc; i++)
    {
      temp = (String) argv[i];
      if ( temp == "-display" ||
	   temp == "-bw"  ||
	   temp == "-visual"  ||
	   temp == "-depth"  ||
	   temp == "-debug"  ||
	   temp == "-name" ) 
	{
	  xforms_argv[j] = argv[i];
	  j++, i++;
	  xforms_argv[j] = argv[i];
	  j++;
	}
      else if ( temp == "-sync" ||
		temp == "-private" ||
		temp == "-shared" ||
		temp == "-stdcmap")
	{
	  xforms_argv[j] = argv[i];
	  j++;
	}
      else
	{
	  prog_argv[g] = argv[i];
	  g++;
	}
    }
  xforms_argc = j;
  prog_argc   = g;

  argv = prog_argv;
  argc = prog_argc;

  int c;
  short rev = 0;
  String first_in;
  String last_in;
  short all_button = 0;
  String offset;
  String paper;
  String x_res;
  String y_res;
  String file_name;
  short printer_name = 0;
  while ( ( c = getopt (argc, argv, "rABhO:t:X:Y:l:P:p:")) != -1)
    {
      switch (c)
	{
	case 'h':
	  cout << "usage: xdvips [ [-P printername] file ]" << endl;
	  exit(1);
	case 'r':
	  rev = 1;
	  break;
	case 'p':
	  first_in = (String) optarg;
	  break;
	case 'l':
	  last_in = (String) optarg;
	  break;
	case 'A':
	  all_button = 1;
	  break;
	case 'B':
	  all_button = 2;
	  break;
	case 'O':
	  offset = (String) optarg;
	  break;
	case 't':
	  paper = (String) optarg;
	  break;
	case 'X':
	  x_res = (String) optarg;
	  break;
	case 'Y':
	  y_res = (String) optarg;
	  break;
	case 'P':
	  choice = (String) optarg;
	  printer_name = 1;
	  break;
	case '?':
	  break;
	default:
	  exit (1);
	}
    }
  if ( optind < argc )
    file_name = (String) argv[optind];

  fl_initialize(&xforms_argc, xforms_argv, "Xdvips", 0, 0);
  fr1 = create_form_fr1();

  fl_set_input(fr1->first_in, (const char *) "*");
  fl_set_input(fr1->last_in, (const char *) "*");
  fl_set_input(fr1->x_res_in, (const char *) DEF_X_RES);
  fl_set_input(fr1->y_res_in, (const char *) DEF_Y_RES);
  fl_set_input(fr1->x_off_in, (const char *) "0mm");
  fl_set_input(fr1->y_off_in, (const char *) "0mm");
  fl_addto_choice(fr1->paper_ch, (const char*) "a4");
  fl_addto_choice(fr1->paper_ch, (const char*) "landscape");
  fl_addto_choice(fr1->paper_ch, (const char*) "a3");
  fl_addto_choice(fr1->paper_ch, (const char*) "letter");
  fl_addto_choice(fr1->paper_ch, (const char*) "11x17");
  fl_addto_choice(fr1->paper_ch, (const char*) "b5");
  fl_addto_choice(fr1->paper_ch, (const char*) "ledger");
  fl_addto_choice(fr1->paper_ch, (const char*) "legal");
  fl_addto_choice(fr1->paper_ch, (const char*) "tabloid");
  fl_set_button(fr1->all_button, 1);
  fl_show_form(fr1->fr1, FL_PLACE_MOUSE, FL_FULLBORDER, "Xdvips");

  if(paper != "")
    fl_set_choice_text(fr1->paper_ch, (const char*) paper);

  if( offset != "" )
    {
      String temp1 = offset.before(",");
      String temp2 = offset.after(",");
      fl_set_input(fr1->x_off_in, (const char *) temp1);
      fl_set_input(fr1->y_off_in, (const char *) temp2);
    }
  if( rev )
    {
      fl_set_button(fr1->rev_button, 1);
    }
  if( first_in != "" )
    {
      fl_set_input(fr1->first_in, (const char*) first_in);
    }
  if( last_in != "" )
    {
      fl_set_input(fr1->last_in, (const char *) last_in);
    }
  if( all_button == 1 ) 
    {
      fl_set_button(fr1->odd_button, 1);
      fl_set_button(fr1->all_button, 0);
      fl_set_button(fr1->even_button, 0);
    }
  if( all_button == 2 )
    {
      fl_set_button(fr1->odd_button, 0);
      fl_set_button(fr1->all_button, 0);
      fl_set_button(fr1->even_button, 1);
    }
  if( x_res != "")
    {
      fl_set_input(fr1->x_res_in, (const char *) x_res);
      fl_set_button(fr1->x_res_but, 1);
    }
  if ( y_res != "" )
    {
      fl_set_input(fr1->y_res_in, (const char *) y_res);
      fl_set_button(fr1->y_res_but, 1);
    }
  if( file_name != "" )
    {
      fl_set_input(fr1->file_in, (const char *) file_name);
    }

  if( access(fl_get_input(fr1->file_in), R_OK))
    f_open((FL_OBJECT *) 0, 0);

  char inbuf[512];
  String name;
  temp = "";
  short empty_printcap = 1;
  ifstream printcap("/etc/printcap", ios::in);
  if( !printcap)
    {
      cout << "Sorry, can't open your printcap file." << endl;
      exit(1);
    }
  while (printcap.getline(inbuf, 512, '\n'))
    {
      if( inbuf[0] == '#' || inbuf[0] == 0) continue;
      temp = inbuf;
      name = temp.before(":");
      if( name.length() == 0 ) continue;
      if( name.contains("|") )
	name = name.before("|");
      while( name.length() != 0 && name[0] == ' ' )
	{
	  name.del(" ");
	}
      if(name.length() == 0) continue;
      while ( temp[temp.length()-1] == '\\')
	{
	  printcap.getline(inbuf, 512, '\n');
	  if( inbuf[0] == '#')
	    temp = "\\";
	  else
	    temp = inbuf;
	}
      if( name.length() != 0 )
	empty_printcap = 0;
      fl_addto_choice(fr1->printer_ch, (const char*) name);
      if( name == choice)
	{
	  fl_set_choice_text(fr1->printer_ch, (const char*) name);
	  if(printer_name) 
	    fl_set_button(fr1->printer_but, 1);
	}
    }
  printcap.close();
  if( empty_printcap )
    {
      cout << "Sorry, unable to parse your printcap." << endl;
      cout << "Please email your printcap to Christoph.Neerfeld@mail.bonn.netsurf.de" << endl;
      exit(1);
    }
  //  fl_show_form(fr1->fr1, FL_PLACE_MOUSE, FL_FULLBORDER, "Xdvips");
  fl_set_object_bw(fr1->gr_all, -3);
  fl_do_forms();
}  

