<?xml version="1.0"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html" indent="no"/>

<xsl:variable name="dante">ftp://ftp.dante.de/tex-archive</xsl:variable>
<xsl:variable name="web-search">http://theory.uwinnipeg.ca/scripts/CTAN</xsl:variable>
<xsl:variable name="web-home">http://datamining.csiro.au/Graham.Williams</xsl:variable>
<!--xsl:variable name="web-tex">$web-home/tex</xsl:variable-->

<xsl:template name="header">
  <head>
	<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1"/>
	<META HTTP-EQUIV="Content-Style-Type" CONTENT="text/css"/>
    <title>The TeX Catalogue OnLine, <xsl:value-of select="$edition"/></title>
    <LINK REL="stylesheet"
          TYPE="text/css"
          HREF="http://togaware.com/texcatalogue.css">
  </head>
</xsl:template>

<xsl:template name="title">
<H1><A name="top"></A>The TeX Catalogue Online</H1>
<DIV style="text-align:center">
    <a href="{$base-locale}/catalogue.html">
      <img src="{$web-images}/title.png" 
           alt="The TeX Catalogue Online" border="0"/>
<!-- IMG WIDTH and HEIGHT missing -->
    </a>
</DIV>

<P/>
<DIV style="text-align:center">
  <a href="http://www.ctan.org/find.html">Search</a> |
  <a href="{$base-locale}/catalogue.html">Home</a> |
  <a href="{$base-locale}/alpha.html">Alpha</a> |
  <a href="{$base-locale}/brief.html">Brief</a> |
  <a href="{$base-locale}/bytopic.html">Topical</a> |
  <a href="{$base-locale}/hier.html">Hierarchical</a> |
  <a href="{$base-locale}/full.html">Full</a>
</DIV>

<P/>
<HR/><!-- End of Navigation -->
</xsl:template>

<xsl:template name="author">
<P class="names">
       <I>This TeX Catalogue (<xsl:value-of select="$edition"/>)</I>
      <a href="http://www.togaware.com"> by </a>
      <a href="{$web-home}">Graham Williams</a>
</P>

<P class="names">
</P>

<P/>
<HR/><!-- End of Header -->

</xsl:template>

<xsl:template name="alphalist">
  <h3 align="center">
    <a href="#A">A</a> | 
    <a href="#B">B</a> | 
    <a href="#C">C</a> | 
    <a href="#D">D</a> | 
    <a href="#E">E</a> | 
    <a href="#F">F</a> | 
    <a href="#G">G</a> | 
    <a href="#H">H</a> | 
    <a href="#I">I</a> | 
    <a href="#J">J</a> | 
    <a href="#K">K</a> | 
    <a href="#L">L</a> | 
    <a href="#M">M</a> | 
    <a href="#N">N</a> | 
    <a href="#O">O</a> | 
    <a href="#P">P</a> | 
    <a href="#Q">Q</a> | 
    <a href="#R">R</a> | 
    <a href="#S">S</a> | 
    <a href="#T">T</a> | 
    <a href="#U">U</a> | 
    <a href="#V">V</a> | 
    <a href="#W">W</a> | 
    <a href="#X">X</a> | 
    <a href="#Y">Y</a> | 
    <a href="#Z">Z</a> | 
  </h3>
  <hr/>
</xsl:template>

<xsl:template name="welcome">
<P>Welcome to the XML-based and XSLT generated version of The TeX
 Catalogue Online, <xsl:text> </xsl:text><xsl:value-of
 select="$edition"/>.  This is a listing of entries in the TeX
 Catalogue and may take a little time to load, but is hopefully worth
 it.  Have a look at the <A HREF="catalogue.html">Catalogue
 Preface</A> for alternative ways of accessing the catalogue.</P>
</xsl:template>

<xsl:template name="alternatives">
<P>The TeX Catalogue Online is also available from any CTAN node or
 mirror, including the following.  Pick one that is close to you.
 (The "search" link attempts to find a CTAN node that may be close to
 you, courtesy of Randy Kobes.  Multiple clicks may find
 alternatives.)</P>

<P/>

<TABLE WIDTH="100%">
  <TR>
    <TD ALIGN="center">
      <A HREF="{$web-search}/help/Catalogue/catalogue.html">
        <IMG BORDER="0" SRC="{$web-images}/search.png" ALT="Search"/>
      </A><BR/><B>search</B>
    </TD>
    <TD ALIGN="center">
      <A HREF="http://mirror.aarnet.edu.au/pub/CTAN/help/Catalogue/catalogue.html">
        <IMG WIDTH="30" HEIGHT="15" ALT="au"
	     SRC="{$web-images}/au.png"/>
      </A><BR/><B>aarnet</B>
    </TD>
    <TD ALIGN="center">
      <A HREF="ftp://sunsite.cnlab-switch.ch/mirror/tex/help/Catalogue/catalogue.html">
        <IMG WIDTH="20" HEIGHT="15"  ALT="ch"
	     SRC="{$web-images}/ch.png"/>
      </A><BR/><B>switch</B>
    </TD>
    <TD ALIGN="center">
      <A HREF="ftp://ftp.cstug.cz/pub/tex/CTAN/help/Catalogue/catalogue.html">
        <IMG WIDTH="30" HEIGHT="15" ALT="cz"
	     SRC="{$web-images}/cz.png"/>
      </A><BR/><B>cstug</B>
    </TD>
    <TD ALIGN="center">
      <A HREF="ftp://ftp.dante.de/tex-archive/help/Catalogue/catalogue.html">
        <IMG WIDTH="30" HEIGHT="15" ALT="de"
	     SRC="{$web-images}/de.png"/>
      </A><BR/><B>dante</B>
    </TD>

    <TD ALIGN="center">
      <A HREF="ftp://ftp.loria.fr/pub/unix/tex/ctan/help/Catalogue/catalogue.html">
        <IMG WIDTH="30" HEIGHT="15" ALT="fr"
	     SRC="{$web-images}/fr.png"/>
      </A><BR/><B>loria</B>
    </TD>

    <TD ALIGN="center">
      <A HREF="http://www.tex.ac.uk/tex-archive/help/Catalogue/catalogue.html">
        <IMG WIDTH="30" HEIGHT="15" ALT="gb"
	     SRC="{$web-images}/gb.png"/>
      </A><BR/><B>tex</B>
    </TD>

    <TD ALIGN="center">
      <A HREF="ftp://cis.uniRoma2.it/TeX/help/Catalogue/catalogue.html">
        <IMG WIDTH="30" HEIGHT="15" ALT="it"
	     SRC="{$web-images}/it.png"/>
      </A><BR/><B>roma</B>
    </TD>

    <TD ALIGN="center">
      <A HREF="ftp://ftp.riken.go.jp/pub/tex-archive/help/Catalogue/catalogue.html">
        <IMG WIDTH="30" HEIGHT="15" ALT="jp"
	     SRC="{$web-images}/jp.png"/>
      </A><BR/><B>riken</B>
    </TD>

    <TD ALIGN="center">
      <A HREF="ftp://sunsite.icm.edu.pl/pub/CTAN/help/Catalogue/catalogue.html">
        <IMG WIDTH="30" HEIGHT="15" ALT="pl"
	     SRC="{$web-images}/pl.png"/>
      </A><BR/><B>gust</B>
    </TD>

    <TD ALIGN="center">
      <A HREF="ftp://ftp.rge.com/pub/tex/help/Catalogue/catalogue.html">
        <IMG WIDTH="30" HEIGHT="15" ALT="us"
	     SRC="{$web-images}/us.png"/>
      </A><BR/><B>rge</B>
    </TD>

    <TD ALIGN="center">
      <A HREF="http://www.ctan.org/tex-archive/help/Catalogue/catalogue.html">
        <IMG WIDTH="30" HEIGHT="15" ALT="us"
	     SRC="{$web-images}/us.png"/>
      </A><BR/><B>ctan</B>
    </TD>

  </TR>
</TABLE>
</xsl:template>

<xsl:template name="icons">
<P>Icons associated with entries in the catalogue allow you to:</P>

<UL>
  <LI><IMG ALT="CTAN" SRC="{$web-images}/dir.png" WIDTH="20" HEIGHT="20"/>
      view the directory on CTAN</LI>
  <LI><IMG SRC="{$web-images}/doc.png" WIDTH="20" HEIGHT="20"
           ALT="Documentation"/>
      view documentation (possibly many)</LI>
  <LI><IMG SRC="{$web-images}/acroread.png" WIDTH="20" HEIGHT="20"
           ALT="PDF"/>
      view documentation in PDF format (requires the <A HREF="http://www.adobe.com/prodindex/acrobat/readstep.html">acroread</A> plugin)</LI>
  <LI><IMG ALT="Home" SRC="{$web-images}/home.png" WIDTH="20" HEIGHT="20"/>
      jump to the package's home page</LI>
  <LI><IMG ALT="Download from somewhere nearby (Search)" SRC="{$web-images}/search.png"            WIDTH="20" HEIGHT="20"/>
      download a gzip'd tar file from a nearby CTAN node (not supported by all nodes)</LI>
  <LI><IMG ALT="Download from Dante" SRC="{$web-images}/tar.png"            WIDTH="20" HEIGHT="20"/>
      download a gzip'd tar file from ftp.dante.de</LI>
</UL>


<P>Other icons simply provide further information about the package:</P>

<UL>

<LI><IMG SRC="{$web-images}/tetex.png" ALT="Included in the teTeX distribution"/>
part of the <A HREF="http://tug.cs.umb.edu/tetex/">
teTeX distribution</A></LI>

<LI><IMG SRC="{$web-images}/texlive.png" ALT="Included in the TeXLive distribution"
         WIDTH="18" HEIGHT="18"/>
available on the <A HREF="http://www.tug.org/texlive/index.html">
TeX Live CD ROM</A>
</LI>
</UL>

<P>The license type, version (if known), and the date of the last
 change made to each particular Catalogue entry are also provided.</P>
</xsl:template>

<xsl:template name="copyright">
  <address>
  <p> 
  <xsl:text>Copyright (c) </xsl:text>
  <a href="http://datamining.csiro.au/Graham.Williams">Graham J. Williams.</a>
  <xsl:text> Last modified dateANDtimeNOW.</xsl:text>
  </p>
  </address>
</xsl:template>

<xsl:template match="catalogue">
  <xsl:comment>
    This file is automatically generated. Do not edit!
  </xsl:comment>
  <HTML>
  <xsl:call-template name="header"/>
    <BODY>
      <xsl:call-template name="title"/>
      <xsl:call-template name="author"/>
      <xsl:call-template name="welcome"/>
      <xsl:call-template name="alternatives"/>
      <xsl:call-template name="icons"/>
      <xsl:call-template name="copyright"/>
      <HR/>
      <xsl:apply-templates select="entry">
        <xsl:sort select="about/name"/>
      </xsl:apply-templates>
      <HR/>
    </BODY>
  </HTML>
</xsl:template>

<xsl:template match="xref">
  <A HREF="#{@refid}"> <xsl:apply-templates/></A>
</xsl:template>

<xsl:template match="a">
  <A HREF="{@href}"> <xsl:apply-templates/></A>
</xsl:template>

<xsl:template match="about/version/number">
  <xsl:text> Version: </xsl:text>
  <STRONG><xsl:apply-templates/></STRONG>
</xsl:template>

<xsl:template match="about/version/released">
  <xsl:text>  Released: </xsl:text>
  <STRONG><xsl:apply-templates/></STRONG>
</xsl:template>

<xsl:template name="buttons">
    <TD ALIGN="left" WIDTH="30%">

    <!-- CTAN -->

    <!-- I should test for what looks like a file name, and if it is
    not a file name, but looks like a directory then I should add the
    trailing slash if it is not already present. -->

    <xsl:if test="distribution/ctan">
      <!--A HREF="{$base-location}/{distribution/ctan}/"-->
      <A HREF="{$base-location}/{$ctandist}/">
        <IMG SRC="{$web-images}/dir.png" 
	     BORDER="0" WIDTH="20" HEIGHT="20" 
             ALT="Visit CTAN:{$ctandist}/"/>
      </A>
    </xsl:if>

    <!-- HOME -->

    <xsl:if test="about/home">
      <A HREF="{$homepage}">
        <IMG SRC="{$web-images}/home.png"
	     BORDER="0" WIDTH="20" HEIGHT="20" ALT="Visit the Package's Home Page"/> 
      </A>
    </xsl:if>

    <!-- DOCUMENTATION -->

    <xsl:if test="description/documentation">
      <xsl:apply-templates select="description/documentation"/>
    </xsl:if>

    <!-- Do each of the documentation entries here -->

    <!-- DOWNLOAD FROM CTAN -->

    <xsl:if test="distribution/ctan">

      <!-- DOWNLOAD SEARCH -->

      <A HREF="{$web-search}/{$ctandist}.tar.gz">
        <IMG SRC="{$web-images}/search.png"
	     BORDER="0" ALT="Download from somewhere nearby (Search)"/>
      </A>

      <!-- DOWNLOAD DANTE -->

      <A HREF="{$dante}/{$ctandist}.tar.gz">
        <IMG SRC="{$web-images}/tar.png"
	     BORDER="0" ALT="Download from Dante"/>
      </A>

    </xsl:if>

    <!-- TEXLIVE -->

    <xsl:if test="distribution/texlive">
      <IMG SRC="{$web-images}/texlive.png"
	   ALT="Included in TeXLive distribution in {$texlivedist}" 
	   BORDER="0" WIDTH="18" HEIGHT="18"/>
    </xsl:if>

  </TD>
</xsl:template>

<xsl:template match='description/documentation[@location="http"]'>
  <A HREF="{.}">
    <IMG SRC="{$web-images}/doc.png"
	 BORDER="0" WIDTH="20" HEIGHT="20" ALT="Read Documentation On-Line"/>
  </A>
</xsl:template>

<xsl:template match='description/documentation[@location="ctan"]'>
  <A HREF="{$base-location}/{../../distribution/ctan}/{.}">
    <IMG SRC="{$web-images}/doc.png"
	 BORDER="0" WIDTH="20" HEIGHT="20" ALT="Read Documentation On-Line"/>
  </A>
</xsl:template>

</xsl:stylesheet>

