## -*-Tcl-*- (install)
 # ###################################################################
 #  Vince's Additions - an extension package for Alpha
 # 
 #  FILE: "latexBbToViewport.tcl"
 #                                    created: 05/26/1999 {14:02:44 PM} 
 #                                last update: 05/26/1999 {16:25:07 PM} 
 #  Author: Vince Darley
 #  E-mail: vince@biosgroup.com
 #    mail: Bios Group
 #          317 Paseo de Peralta, Santa Fe, NM 87501
 #     www: http://www.biosgroup.com/
 #  
 # Copyright (c) 1999 Vince Darley
 # 
 # All rights reserved.
 #  
 # ###################################################################
 ##

alpha::feature latexBbToViewport 0.1 {TeX} {
    alpha::package require TeX 4.2
    menu::insert {LaTeX Utilities} items 5 {Convert Bb To Viewport}
} "" "" maintainer {
    {Vince Darley} vince@santafe.edu 
} help {
    Converts \\includegraphics bb= to viewport= so your file will
    work ok with both latex and pdflatex (provided you have both
    .eps and .pdf versions of all your figures).
    
    The cursor must be on the line of the includegraphics for this
    to work.
} uninstall this-file

namespace eval TeX {}

proc TeX::ConvertBbToViewport {} {
    set line [getText [lineStart [getPos]] [nextLineStart [getPos]]]
    if {![regexp {\\includegraphics(\[[^]]*\])?\{([\w-]+)\}} $line "" arg name]} {
	message "Sorry, I can't find a valid \\includegraphics statement!"
	return
    }
    if {![regexp {bb=([0-9\. ]+)} $arg all bbox]} {
	message "Sorry, I can't find a valid bounding box statement in: $arg"
	return
    }
    if {[set file [TeX::findGraphicsFile $name]] == ""} {
	message "Sorry, I can't find the file $name"
	return
    }
    if {[set actualBbox [texfs_getEpsBoxFromFile $file]] == ""} {
	message "Sorry, file $file contains no %%BoundingBox."
	return
    }
    scan $actualBbox "%d %d %d %d" b1 b2 b3 b4
    scan $bbox "%d %d %d %d" a1 a2 a3 a4
    set viewPort "viewport=[expr {$a1 - $b1}] [expr {$a2 - $b2}]\
      [expr {$a3-$a1}] [expr {$a4-$a2}]"
    regsub -- [quote::Regfind $all] $line [quote::Regsub $viewPort] newline
    replaceText [lineStart [getPos]] [nextLineStart [getPos]] $newline
    message "Replaced 'bb=$bbox' with '$viewPort'"
}

proc TeX::findGraphicsFile {text} {
    if {[file extension $text] == ""} {
	foreach ext {.eps .ps .epsf} {
	    if {[set f [findTeXFile $text$ext]] != ""} {
		return $f
	    }
	}
    } else {
	return [findTeXFile $text]
    }
    return ""
}
