/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.html.HtmlTag;
import com.dickimawbooks.texparserlib.html.L2HConverter;
import com.dickimawbooks.texparserlib.primitives.Undefined;
import java.io.File;
import java.io.IOException;

public class L2HTableOfContents
extends ControlSequence {
    public L2HTableOfContents() {
        this("tableofcontents");
    }

    public L2HTableOfContents(String string) {
        super(string);
    }

    @Override
    public Object clone() {
        return new L2HTableOfContents(this.getName());
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        ControlSequence controlSequence = teXParser.getControlSequence("chapter");
        if (controlSequence == null || controlSequence instanceof Undefined) {
            controlSequence = l2HConverter.getControlSequence("section");
        }
        teXObjectList.push(new HtmlTag("</div>"));
        File file = l2HConverter.getAuxFile("toc");
        if (file.exists()) {
            teXObjectList.push(l2HConverter.createGroup(file.getName()));
            teXObjectList.push(l2HConverter.getControlSequence("input"));
        }
        teXObjectList.push(l2HConverter.createGroup("toc"));
        teXObjectList.push(new TeXCsRef("label"));
        teXObjectList.push(new TeXCsRef("contentsname"));
        teXObjectList.push(l2HConverter.getOther(42));
        teXObjectList.push(controlSequence);
        teXObjectList.push(new HtmlTag("<div class=\"toc\">"));
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        ControlSequence controlSequence = teXParser.getControlSequence("chapter");
        if (controlSequence == null || controlSequence instanceof Undefined) {
            controlSequence = l2HConverter.getControlSequence("section");
        }
        teXParser.push(new HtmlTag("</div>"));
        File file = l2HConverter.getAuxFile("toc");
        if (file.exists()) {
            teXParser.push(l2HConverter.createGroup(file.getName()));
            teXParser.push(l2HConverter.getControlSequence("input"));
        }
        teXParser.push(l2HConverter.createGroup("toc"));
        teXParser.push(new TeXCsRef("label"));
        teXParser.push(new TeXCsRef("contentsname"));
        teXParser.push(l2HConverter.getOther(42));
        teXParser.push(controlSequence);
        teXParser.push(new HtmlTag("<div class=\"toc\">"));
    }
}

