/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.korio.lang;

import com.soywiz.kmem.ByteArrayBuilder;
import com.soywiz.kmem.ByteArrayReadWriteKt;
import com.soywiz.korio.lang.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J(\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lcom/soywiz/korio/lang/UTF16Charset;", "Lcom/soywiz/korio/lang/Charset;", "le", "", "(Z)V", "getLe", "()Z", "decode", "", "out", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "src", "", "start", "", "end", "encode", "Lcom/soywiz/kmem/ByteArrayBuilder;", "", "estimateNumberOfBytesForCharacters", "nchars", "estimateNumberOfCharactersForBytes", "nbytes", "korio"})
public final class UTF16Charset
extends Charset {
    private final boolean le;

    public UTF16Charset(boolean le) {
        super(Intrinsics.stringPlus("UTF-16-", le ? "LE" : "BE"));
        this.le = le;
    }

    public final boolean getLe() {
        return this.le;
    }

    @Override
    public int estimateNumberOfCharactersForBytes(int nbytes) {
        return nbytes * 2;
    }

    @Override
    public int estimateNumberOfBytesForCharacters(int nchars) {
        return nchars * 2;
    }

    @Override
    public void decode(@NotNull StringBuilder out2, @NotNull byte[] src, int start, int end2) {
        IntProgression intProgression = RangesKt.step(RangesKt.until(start, end2), 2);
        int n = intProgression.getFirst();
        int n2 = intProgression.getLast();
        int n3 = intProgression.getStep();
        if (n3 > 0 && n <= n2 || n3 < 0 && n2 <= n) {
            int n4;
            do {
                n4 = n;
                n += n3;
                char c = (char)ByteArrayReadWriteKt.readS16(src, n4, this.le);
                out2.append(c);
            } while (n4 != n2);
        }
    }

    @Override
    public void encode(@NotNull ByteArrayBuilder out2, @NotNull CharSequence src, int start, int end2) {
        byte[] temp = new byte[2];
        int n = start;
        while (n < end2) {
            int n2 = n++;
            ByteArrayReadWriteKt.write16(temp, 0, src.charAt(n2), this.le);
            ByteArrayBuilder.append$default(out2, temp, 0, 0, 6, null);
        }
    }
}

