/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.Bib2GlsException;
import com.dickimawbooks.bib2gls.FieldCaseChange;
import com.dickimawbooks.bib2gls.FieldValueElement;
import com.dickimawbooks.bib2gls.GlsResource;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.bib.BibUserString;
import com.dickimawbooks.texparserlib.bib.BibValue;
import java.io.IOException;

public class FieldValueCase
implements FieldValueElement {
    private FieldValueElement fieldValueElem;
    private FieldCaseChange caseChange;

    public FieldValueCase(FieldValueElement fieldValueElement, FieldCaseChange fieldCaseChange) {
        this.fieldValueElem = fieldValueElement;
        this.caseChange = fieldCaseChange;
    }

    @Override
    public BibValue getValue(Bib2GlsEntry bib2GlsEntry) throws Bib2GlsException, IOException {
        Bib2Gls bib2Gls = bib2GlsEntry.getBib2Gls();
        BibValue bibValue = this.fieldValueElem.getValue(bib2GlsEntry);
        if (bibValue == null || this.caseChange == FieldCaseChange.NO_CHANGE) {
            return bibValue;
        }
        GlsResource glsResource = bib2GlsEntry.getResource();
        TeXParser teXParser = glsResource.getParser();
        TeXObjectList teXObjectList = (TeXObjectList)bibValue.expand(teXParser).clone();
        if (!teXObjectList.isEmpty()) {
            switch (this.caseChange) {
                case UC: {
                    glsResource.toUpperCase(teXObjectList, teXParser.getListener());
                    break;
                }
                case LC: {
                    glsResource.toLowerCase(teXObjectList, teXParser.getListener());
                    break;
                }
                case FIRST_UC: {
                    glsResource.toSentenceCase(teXObjectList, teXParser.getListener());
                    break;
                }
                case FIRST_LC: {
                    glsResource.toNonSentenceCase(teXObjectList, teXParser.getListener());
                    break;
                }
                case TITLE: {
                    glsResource.toTitleCase(teXObjectList, teXParser.getListener());
                }
            }
        }
        return new BibUserString(teXObjectList);
    }

    @Override
    public String getStringValue(Bib2GlsEntry bib2GlsEntry) throws IOException, Bib2GlsException {
        Bib2Gls bib2Gls = bib2GlsEntry.getBib2Gls();
        String string = this.fieldValueElem.getStringValue(bib2GlsEntry);
        if (string == null) {
            return null;
        }
        GlsResource glsResource = bib2GlsEntry.getResource();
        if (!string.isEmpty()) {
            switch (this.caseChange) {
                case UC: {
                    string = glsResource.toUpperCase(string).toString();
                    break;
                }
                case LC: {
                    string = glsResource.toLowerCase(string).toString();
                    break;
                }
                case FIRST_UC: {
                    string = glsResource.toSentenceCase(string).toString();
                    break;
                }
                case FIRST_LC: {
                    string = glsResource.toNonSentenceCase(string).toString();
                    break;
                }
                case TITLE: {
                    string = glsResource.toTitleCase(string).toString();
                }
            }
        }
        return string;
    }

    public String toString() {
        return String.format("\\%s{%s}", new Object[]{this.caseChange, this.fieldValueElem});
    }
}

