/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.introspector;

import java.beans.PropertyDescriptor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.Property;

public class MethodProperty
extends Property {
    private final PropertyDescriptor property;

    public MethodProperty(PropertyDescriptor property) {
        super(property.getName(), property.getPropertyType());
        this.property = property;
    }

    public void set(Object object, Object value) throws Exception {
        this.property.getWriteMethod().invoke(object, value);
    }

    public Type[] getActualTypeArguments() {
        if (List.class.isAssignableFrom(this.property.getPropertyType()) || Set.class.isAssignableFrom(this.property.getPropertyType()) || Map.class.isAssignableFrom(this.property.getPropertyType())) {
            if (this.property.getReadMethod().getGenericReturnType() instanceof ParameterizedType) {
                ParameterizedType grt = (ParameterizedType)this.property.getReadMethod().getGenericReturnType();
                return grt.getActualTypeArguments();
            }
            return null;
        }
        return null;
    }

    public Object get(Object object) {
        try {
            return this.property.getReadMethod().invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new YAMLException("Unable to find getter for property '" + this.property.getName() + "' on object " + object + ":" + e);
        }
    }
}

