/*
 * Decompiled with CFR 0.152.
 */
package com.github.andrewoma.dexx.collection.internal.hashmap;

import com.github.andrewoma.dexx.collection.KeyFunction;
import com.github.andrewoma.dexx.collection.Pair;
import com.github.andrewoma.dexx.collection.internal.hashmap.HashMapCollision1;
import com.github.andrewoma.dexx.collection.internal.hashmap.HashTrieMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;

class CompactHashMapIterator<K, V>
implements Iterator<Pair<K, V>> {
    private final KeyFunction<K, V> keyFunction;
    private final Stack<Pointer> stack = new Stack();
    private Iterator<Pair<K, V>> subIterator;
    private Pointer current;
    private Pair<K, V> next;

    CompactHashMapIterator(Object[] elems, KeyFunction<K, V> keyFunction) {
        this.current = new Pointer(elems, 0);
        this.keyFunction = keyFunction;
        this.computeNext();
    }

    private void computeNext() {
        this.next = null;
        if (this.subIterator != null) {
            if (this.subIterator.hasNext()) {
                this.next = this.subIterator.next();
                return;
            }
            this.subIterator = null;
        }
        while (this.next == null) {
            Object object;
            if (this.current.pos == this.current.objects.length) {
                if (this.stack.isEmpty()) {
                    return;
                }
                this.current = this.stack.pop();
                continue;
            }
            if ((object = this.current.objects[this.current.pos++]) instanceof HashTrieMap) {
                this.stack.push(this.current);
                this.current = new Pointer(((HashTrieMap)object).getElems(), 0);
                continue;
            }
            if (object instanceof HashMapCollision1) {
                this.subIterator = ((HashMapCollision1)object).iterator(this.keyFunction);
                this.next = this.subIterator.next();
                continue;
            }
            Object leaf = object;
            this.next = new Pair<K, Object>(this.keyFunction.key(leaf), leaf);
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Pair<K, V> next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        Pair<K, V> result = this.next;
        this.computeNext();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    static class Pointer {
        final Object[] objects;
        int pos;

        Pointer(Object[] objects, int pos) {
            this.objects = objects;
            this.pos = pos;
        }
    }
}

