
/*
 * Nautilus
 *
 * Copyright (C) 2000 Eazel, Inc.
 *
 * Nautilus is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * Nautilus is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; see the file COPYING.  If not,
 * see <http://www.gnu.org/licenses/>.
 *
 * Author: Maciej Stachowiak <mjs@eazel.com>
 *         Ettore Perazzoli <ettore@gnu.org>
 */

#ifndef NAUTILUS_LOCATION_ENTRY_H
#define NAUTILUS_LOCATION_ENTRY_H

#include <gtk/gtk.h>

#define NAUTILUS_TYPE_LOCATION_ENTRY nautilus_location_entry_get_type()
G_DECLARE_DERIVABLE_TYPE (NautilusLocationEntry, nautilus_location_entry,
                          NAUTILUS, LOCATION_ENTRY,
                          GtkEntry)

typedef struct _NautilusLocationEntryClass {
	GtkEntryClass parent_class;
	/* for GtkBindingSet */
	void         (* cancel)           (NautilusLocationEntry *entry);
} NautilusLocationEntryClass;

typedef enum {
	NAUTILUS_LOCATION_ENTRY_ACTION_GOTO,
	NAUTILUS_LOCATION_ENTRY_ACTION_CLEAR
} NautilusLocationEntryAction;

GtkWidget* nautilus_location_entry_new          	(void);
void       nautilus_location_entry_set_special_text     (NautilusLocationEntry *entry,
							 const char            *special_text);
void       nautilus_location_entry_set_secondary_action (NautilusLocationEntry *entry,
							 NautilusLocationEntryAction secondary_action);
void       nautilus_location_entry_set_location         (NautilusLocationEntry *entry,
							 GFile                 *location);

#endif /* NAUTILUS_LOCATION_ENTRY_H */
