--TEST--
Testing stream_get_meta_data() "eof" field on a udp socket
--FILE--
<?php

/* Setup socket server */
$server = stream_socket_server('tcp://127.0.0.1:31334');

/* Connect to it */
$client = fsockopen('tcp://127.0.0.1:31334');
if (!$client) {
    die("Unable to create socket");
}

/* Accept that connection */
$socket = stream_socket_accept($server);

echo "Write some data:\n";
fwrite($socket, "abcdefg\n1234567\nxyzxyz\n");
var_dump(stream_get_meta_data($client));

echo "\n\nRead a line from the client:\n";
fgets($client);
var_dump(stream_get_meta_data($client));

echo "\n\nClose the server side socket and read the remaining data from the client:\n";
fclose($socket);
fclose($server);
while(!feof($client)) {
    fread($client, 1);
}
var_dump(stream_get_meta_data($client));

fclose($client);

?>
--EXPECTF--
Write some data:
array(8) {
  ["timed_out"]=>
  bool(false)
  ["blocked"]=>
  bool(true)
  ["eof"]=>
  bool(false)
  ["stream_type"]=>
  string(%d) "tcp_socke%s"
  ["mode"]=>
  string(2) "r+"
  ["unread_bytes"]=>
  int(%i)
  ["seekable"]=>
  bool(false)
  ["uri"]=>
  string(21) "tcp://127.0.0.1:31334"
}


Read a line from the client:
array(8) {
  ["timed_out"]=>
  bool(false)
  ["blocked"]=>
  bool(true)
  ["eof"]=>
  bool(false)
  ["stream_type"]=>
  string(%d) "tcp_socke%s"
  ["mode"]=>
  string(2) "r+"
  ["unread_bytes"]=>
  int(%i)
  ["seekable"]=>
  bool(false)
  ["uri"]=>
  string(21) "tcp://127.0.0.1:31334"
}


Close the server side socket and read the remaining data from the client:
array(8) {
  ["timed_out"]=>
  bool(false)
  ["blocked"]=>
  bool(true)
  ["eof"]=>
  bool(true)
  ["stream_type"]=>
  string(%d) "tcp_socke%s"
  ["mode"]=>
  string(2) "r+"
  ["unread_bytes"]=>
  int(%i)
  ["seekable"]=>
  bool(false)
  ["uri"]=>
  string(21) "tcp://127.0.0.1:31334"
}
