/* A Bison parser, made by GNU Bison 3.0.4.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.0.4"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1


/* Substitute the variable and function names.  */
#define yyparse         base_yyparse
#define yylex           base_yylex
#define yyerror         base_yyerror
#define yydebug         base_yydebug
#define yynerrs         base_yynerrs

#define yylval          base_yylval
#define yychar          base_yychar
#define yylloc          base_yylloc

/* Copy the first part of user declarations.  */
#line 5 "preproc.y" /* yacc.c:339  */

#include "postgres_fe.h"

#include "extern.h"
#include "ecpg_config.h"
#include <unistd.h>

/* Location tracking support --- simpler than bison's default */
#define YYLLOC_DEFAULT(Current, Rhs, N) \
	do { \
		if (N)						\
			(Current) = (Rhs)[1];	\
		else						\
			(Current) = (Rhs)[0];	\
	} while (0)

/*
 * The %name-prefix option below will make bison call base_yylex, but we
 * really want it to call filtered_base_yylex (see parser.c).
 */
#define base_yylex filtered_base_yylex

/*
 * This is only here so the string gets into the POT.  Bison uses it
 * internally.
 */
#define bison_gettext_dummy gettext_noop("syntax error")

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
char *current_function;
int ecpg_internal_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	FoundInto = 0;
static int	initializer = 0;
static int	pacounter = 1;
static char	pacounter_buffer[sizeof(int) * CHAR_BIT * 10 / 3]; /* a rough guess at the size we need */
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];
static int	varchar_counter = 1;

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, NULL, NULL, NULL, {NULL}, 0};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, NULL, NULL, NULL, {NULL}, 0};

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, const char *error, ...)
{
	va_list ap;

	/* internationalize the error message string */
	error = _(error);

	fprintf(stderr, "%s:%d: ", input_filename, base_yylineno);

	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, _("WARNING: "));
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, _("ERROR: "));
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);

	fprintf(stderr, "\n");

	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			if (base_yyin)
				fclose(base_yyin);
			if (base_yyout)
				fclose(base_yyout);

			if (strcmp(output_filename, "-") != 0 && unlink(output_filename) != 0)
				fprintf(stderr, _("could not remove output file \"%s\"\n"), output_filename);
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	if (strlen(str1) != 0 && strlen(str2) != 0)
		strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	return mm_strdup(base_yytext);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct
	 * An array is only allowed together with an element argument
	 * This is essentially only used for inserts, but using a struct as input parameter is an error anywhere else
	 * so we don't have to worry here. */

	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
	{
		sprintf(pacounter_buffer, "$%d", pacounter++);
		result = cat_str(3, result, mm_strdup(pacounter_buffer), mm_strdup(" , "));
	}

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_outofscope_cursor_vars(struct cursor *cur)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
	 * For instance you can DECLARE a cursor in one function, and OPEN/FETCH/CLOSE
	 * it in another functions. This is very useful for e.g. event-driver programming,
	 * but may also lead to dangerous programming. The limitation when this is allowed
	 * and doesn't cause problems have to be documented, like the allocated variables
	 * must not be realloc()'ed.
	 *
	 * We have to change the variables to our own struct and just store the pointer
	 * instead of the variable. Do it only for local variables, not for globals.
	 */

	char *result = EMPTY;
	int insert;

	for (insert = 1; insert >= 0; insert--)
	{
		struct arguments *list;
		struct arguments *ptr;
		struct arguments *newlist = NULL;
		struct variable *newvar, *newind;

		list = (insert ? cur->argsinsert : cur->argsresult);

		for (ptr = list; ptr != NULL; ptr = ptr->next)
		{
			char var_text[20];
			char *original_var;
			bool skip_set_var = false;
			bool var_ptr = false;

			/* change variable name to "ECPGget_var(<counter>)" */
			original_var = ptr->variable->name;
			sprintf(var_text, "%d))", ecpg_internal_var);

			/* Don't emit ECPGset_var() calls for global variables */
			if (ptr->variable->brace_level == 0)
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type == ECPGt_char_variable)
					 && (strncmp(ptr->variable->name, "ECPGprepared_statement", strlen("ECPGprepared_statement")) == 0))
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type != ECPGt_varchar
					  && ptr->variable->type->type != ECPGt_char
					  && ptr->variable->type->type != ECPGt_unsigned_char
					  && ptr->variable->type->type != ECPGt_string)
					 && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, mm_strdup("("),
											  mm_strdup(ecpg_type_name(ptr->variable->type->u.element->type)),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text)),
									  ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type,
																			   mm_strdup("1"),
																			   ptr->variable->type->u.element->counter),
														  ptr->variable->type->size),
									  0);
			}
			else if ((ptr->variable->type->type == ECPGt_varchar
					  || ptr->variable->type->type == ECPGt_char
					  || ptr->variable->type->type == ECPGt_unsigned_char
					  || ptr->variable->type->type == ECPGt_string)
					 && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, mm_strdup("("),
											  mm_strdup(ecpg_type_name(ptr->variable->type->type)),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text)),
									  ECPGmake_simple_type(ptr->variable->type->type,
														   ptr->variable->type->size,
														   ptr->variable->type->counter),
									  0);
				if (ptr->variable->type->type == ECPGt_varchar)
					var_ptr = true;
			}
			else if (ptr->variable->type->type == ECPGt_struct
					 || ptr->variable->type->type == ECPGt_union)
			{
				newvar = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->variable->type->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
									  ECPGmake_struct_type(ptr->variable->type->u.members,
														   ptr->variable->type->type,
														   ptr->variable->type->type_name,
														   ptr->variable->type->struct_sizeof),
									  0);
				var_ptr = true;
			}
			else if (ptr->variable->type->type == ECPGt_array)
			{
				if (ptr->variable->type->u.element->type == ECPGt_struct
					|| ptr->variable->type->u.element->type == ECPGt_union)
				{
					newvar = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->variable->type->u.element->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
										  ECPGmake_struct_type(ptr->variable->type->u.element->u.members,
															   ptr->variable->type->u.element->type,
															   ptr->variable->type->u.element->type_name,
															   ptr->variable->type->u.element->struct_sizeof),
										  0);
				}
				else
				{
					newvar = new_variable(cat_str(4, mm_strdup("("),
												  mm_strdup(ecpg_type_name(ptr->variable->type->u.element->type)),
												  mm_strdup(" *)(ECPGget_var("),
												  mm_strdup(var_text)),
										  ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type,
																				   ptr->variable->type->u.element->size,
																				   ptr->variable->type->u.element->counter),
															  ptr->variable->type->size),
										  0);
					var_ptr = true;
				}
			}
			else
			{
				newvar = new_variable(cat_str(4, mm_strdup("*("),
											  mm_strdup(ecpg_type_name(ptr->variable->type->type)),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text)),
									  ECPGmake_simple_type(ptr->variable->type->type,
														   ptr->variable->type->size,
														   ptr->variable->type->counter),
									  0);
				var_ptr = true;
			}

			/* create call to "ECPGset_var(<counter>, <connection>, <pointer>. <line number>)" */
			if (!skip_set_var)
			{
				sprintf(var_text, "%d, %s", ecpg_internal_var++, var_ptr ? "&(" : "(");
				result = cat_str(5, result, mm_strdup("ECPGset_var("),
								 mm_strdup(var_text), mm_strdup(original_var),
								 mm_strdup("), __LINE__);\n"));
			}

			/* now the indicator if there is one and it's not a global variable */
			if ((ptr->indicator->type->type == ECPGt_NO_INDICATOR) || (ptr->indicator->brace_level == 0))
			{
				newind = ptr->indicator;
			}
			else
			{
				/* change variable name to "ECPGget_var(<counter>)" */
				original_var = ptr->indicator->name;
				sprintf(var_text, "%d))", ecpg_internal_var);
				var_ptr = false;

				if (ptr->indicator->type->type == ECPGt_struct
					|| ptr->indicator->type->type == ECPGt_union)
				{
					newind = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->indicator->type->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
										  ECPGmake_struct_type(ptr->indicator->type->u.members,
															   ptr->indicator->type->type,
															   ptr->indicator->type->type_name,
															   ptr->indicator->type->struct_sizeof),
										  0);
					var_ptr = true;
				}
				else if (ptr->indicator->type->type == ECPGt_array)
				{
					if (ptr->indicator->type->u.element->type == ECPGt_struct
						|| ptr->indicator->type->u.element->type == ECPGt_union)
					{
						newind = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->indicator->type->u.element->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
											  ECPGmake_struct_type(ptr->indicator->type->u.element->u.members,
																   ptr->indicator->type->u.element->type,
																   ptr->indicator->type->u.element->type_name,
																   ptr->indicator->type->u.element->struct_sizeof),
											  0);
					}
					else
					{
						newind = new_variable(cat_str(4, mm_strdup("("),
													  mm_strdup(ecpg_type_name(ptr->indicator->type->u.element->type)),
													  mm_strdup(" *)(ECPGget_var("), mm_strdup(var_text)),
											  ECPGmake_array_type(ECPGmake_simple_type(ptr->indicator->type->u.element->type,
																					   ptr->indicator->type->u.element->size,
																					   ptr->indicator->type->u.element->counter),
																  ptr->indicator->type->size),
											  0);
						var_ptr = true;
					}
				}
				else if (atoi(ptr->indicator->type->size) > 1)
				{
					newind = new_variable(cat_str(4, mm_strdup("("),
												  mm_strdup(ecpg_type_name(ptr->indicator->type->type)),
												  mm_strdup(" *)(ECPGget_var("),
												  mm_strdup(var_text)),
										  ECPGmake_simple_type(ptr->indicator->type->type,
															   ptr->indicator->type->size,
															   ptr->variable->type->counter),
										  0);
				}
				else
				{
					newind = new_variable(cat_str(4, mm_strdup("*("),
												  mm_strdup(ecpg_type_name(ptr->indicator->type->type)),
												  mm_strdup(" *)(ECPGget_var("),
												  mm_strdup(var_text)),
										  ECPGmake_simple_type(ptr->indicator->type->type,
															   ptr->indicator->type->size,
															   ptr->variable->type->counter),
										  0);
					var_ptr = true;
				}

				/* create call to "ECPGset_var(<counter>, <pointer>. <line number>)" */
				sprintf(var_text, "%d, %s", ecpg_internal_var++, var_ptr ? "&(" : "(");
				result = cat_str(5, result, mm_strdup("ECPGset_var("),
								 mm_strdup(var_text), mm_strdup(original_var),
								 mm_strdup("), __LINE__);\n"));
			}

			add_variable_to_tail(&newlist, newvar, newind);
		}

		if (insert)
			cur->argsinsert_oos = newlist;
		else
			cur->argsresult_oos = newlist;
	}

	return result;
}

/* This tests whether the cursor was declared and opened in the same function. */
#define SAMEFUNC(cur)	\
	((cur->function == NULL) ||		\
	 (cur->function != NULL && strcmp(cur->function, current_function) == 0))

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;
	int (* strcmp_fn)(const char *, const char *) = ((name[0] == ':' || name[0] == '"') ? strcmp : pg_strcasecmp);

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp_fn(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "cursor \"%s\" does not exist", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier
		 * note that we have to append here but have to keep the existing order */
		for (p = (SAMEFUNC(ptr) ? ptr->argsinsert : ptr->argsinsert_oos); p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = (SAMEFUNC(ptr) ? ptr->argsresult : ptr->argsresult_oos); p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);

	return ptr;
}

static void
add_typedef(char *name, char *dimension, char *length, enum ECPGttype type_enum,
			char *type_dimension, char *type_index, int initializer, int array)
{
	/* add entry to list */
	struct typedefs *ptr, *this;

	if ((type_enum == ECPGt_struct ||
		 type_enum == ECPGt_union) &&
		initializer == 1)
		mmerror(PARSE_ERROR, ET_ERROR, "initializer not allowed in type definition");
	else if (INFORMIX_MODE && strcmp(name, "string") == 0)
		mmerror(PARSE_ERROR, ET_ERROR, "type name \"string\" is reserved in Informix mode");
	else
	{
		for (ptr = types; ptr != NULL; ptr = ptr->next)
		{
			if (strcmp(name, ptr->name) == 0)
				/* re-definition is a bug */
				mmerror(PARSE_ERROR, ET_ERROR, "type \"%s\" is already defined", name);
		}
		adjust_array(type_enum, &dimension, &length, type_dimension, type_index, array, true);

		this = (struct typedefs *) mm_alloc(sizeof(struct typedefs));

		/* initial definition */
		this->next = types;
		this->name = name;
		this->brace_level = braces_open;
		this->type = (struct this_type *) mm_alloc(sizeof(struct this_type));
		this->type->type_enum = type_enum;
		this->type->type_str = mm_strdup(name);
		this->type->type_dimension = dimension; /* dimension of array */
		this->type->type_index = length;	/* length of string */
		this->type->type_sizeof = ECPGstruct_sizeof;
		this->struct_member_list = (type_enum == ECPGt_struct || type_enum == ECPGt_union) ?
		ECPGstruct_member_dup(struct_member_list[struct_level]) : NULL;

		if (type_enum != ECPGt_varchar &&
			type_enum != ECPGt_char &&
			type_enum != ECPGt_unsigned_char &&
			type_enum != ECPGt_string &&
			atoi(this->type->type_index) >= 0)
			mmerror(PARSE_ERROR, ET_ERROR, "multidimensional arrays for simple data types are not supported");

		types = this;
	}
}

#line 630 "preproc.c" /* yacc.c:339  */

# ifndef YY_NULLPTR
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULLPTR nullptr
#  else
#   define YY_NULLPTR 0
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* In a future release of Bison, this section will be replaced
   by #include "preproc.h".  */
#ifndef YY_BASE_YY_PREPROC_H_INCLUDED
# define YY_BASE_YY_PREPROC_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int base_yydebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    SQL_ALLOCATE = 258,
    SQL_AUTOCOMMIT = 259,
    SQL_BOOL = 260,
    SQL_BREAK = 261,
    SQL_CALL = 262,
    SQL_CARDINALITY = 263,
    SQL_CONNECT = 264,
    SQL_COUNT = 265,
    SQL_DATETIME_INTERVAL_CODE = 266,
    SQL_DATETIME_INTERVAL_PRECISION = 267,
    SQL_DESCRIBE = 268,
    SQL_DESCRIPTOR = 269,
    SQL_DISCONNECT = 270,
    SQL_FOUND = 271,
    SQL_FREE = 272,
    SQL_GET = 273,
    SQL_GO = 274,
    SQL_GOTO = 275,
    SQL_IDENTIFIED = 276,
    SQL_INDICATOR = 277,
    SQL_KEY_MEMBER = 278,
    SQL_LENGTH = 279,
    SQL_LONG = 280,
    SQL_NULLABLE = 281,
    SQL_OCTET_LENGTH = 282,
    SQL_OPEN = 283,
    SQL_OUTPUT = 284,
    SQL_REFERENCE = 285,
    SQL_RETURNED_LENGTH = 286,
    SQL_RETURNED_OCTET_LENGTH = 287,
    SQL_SCALE = 288,
    SQL_SECTION = 289,
    SQL_SHORT = 290,
    SQL_SIGNED = 291,
    SQL_SQL = 292,
    SQL_SQLERROR = 293,
    SQL_SQLPRINT = 294,
    SQL_SQLWARNING = 295,
    SQL_START = 296,
    SQL_STOP = 297,
    SQL_STRUCT = 298,
    SQL_UNSIGNED = 299,
    SQL_VAR = 300,
    SQL_WHENEVER = 301,
    S_ADD = 302,
    S_AND = 303,
    S_ANYTHING = 304,
    S_AUTO = 305,
    S_CONST = 306,
    S_DEC = 307,
    S_DIV = 308,
    S_DOTPOINT = 309,
    S_EQUAL = 310,
    S_EXTERN = 311,
    S_INC = 312,
    S_LSHIFT = 313,
    S_MEMPOINT = 314,
    S_MEMBER = 315,
    S_MOD = 316,
    S_MUL = 317,
    S_NEQUAL = 318,
    S_OR = 319,
    S_REGISTER = 320,
    S_RSHIFT = 321,
    S_STATIC = 322,
    S_SUB = 323,
    S_VOLATILE = 324,
    S_TYPEDEF = 325,
    CSTRING = 326,
    CVARIABLE = 327,
    CPP_LINE = 328,
    IP = 329,
    DOLCONST = 330,
    ECONST = 331,
    NCONST = 332,
    UCONST = 333,
    UIDENT = 334,
    IDENT = 335,
    FCONST = 336,
    SCONST = 337,
    BCONST = 338,
    XCONST = 339,
    Op = 340,
    ICONST = 341,
    PARAM = 342,
    TYPECAST = 343,
    DOT_DOT = 344,
    COLON_EQUALS = 345,
    ABORT_P = 346,
    ABSOLUTE_P = 347,
    ACCESS = 348,
    ACTION = 349,
    ADD_P = 350,
    ADMIN = 351,
    AFTER = 352,
    AGGREGATE = 353,
    ALL = 354,
    ALSO = 355,
    ALTER = 356,
    ALWAYS = 357,
    ANALYSE = 358,
    ANALYZE = 359,
    AND = 360,
    ANY = 361,
    ARRAY = 362,
    AS = 363,
    ASC = 364,
    ASSERTION = 365,
    ASSIGNMENT = 366,
    ASYMMETRIC = 367,
    AT = 368,
    ATTRIBUTE = 369,
    AUTHORIZATION = 370,
    BACKWARD = 371,
    BEFORE = 372,
    BEGIN_P = 373,
    BETWEEN = 374,
    BIGINT = 375,
    BINARY = 376,
    BIT = 377,
    BOOLEAN_P = 378,
    BOTH = 379,
    BY = 380,
    CACHE = 381,
    CALLED = 382,
    CASCADE = 383,
    CASCADED = 384,
    CASE = 385,
    CAST = 386,
    CATALOG_P = 387,
    CHAIN = 388,
    CHAR_P = 389,
    CHARACTER = 390,
    CHARACTERISTICS = 391,
    CHECK = 392,
    CHECKPOINT = 393,
    CLASS = 394,
    CLOSE = 395,
    CLUSTER = 396,
    COALESCE = 397,
    COLLATE = 398,
    COLLATION = 399,
    COLUMN = 400,
    COMMENT = 401,
    COMMENTS = 402,
    COMMIT = 403,
    COMMITTED = 404,
    CONCURRENTLY = 405,
    CONFIGURATION = 406,
    CONNECTION = 407,
    CONSTRAINT = 408,
    CONSTRAINTS = 409,
    CONTENT_P = 410,
    CONTINUE_P = 411,
    CONVERSION_P = 412,
    COPY = 413,
    COST = 414,
    CREATE = 415,
    CROSS = 416,
    CSV = 417,
    CURRENT_P = 418,
    CURRENT_CATALOG = 419,
    CURRENT_DATE = 420,
    CURRENT_ROLE = 421,
    CURRENT_SCHEMA = 422,
    CURRENT_TIME = 423,
    CURRENT_TIMESTAMP = 424,
    CURRENT_USER = 425,
    CURSOR = 426,
    CYCLE = 427,
    DATA_P = 428,
    DATABASE = 429,
    DAY_P = 430,
    DEALLOCATE = 431,
    DEC = 432,
    DECIMAL_P = 433,
    DECLARE = 434,
    DEFAULT = 435,
    DEFAULTS = 436,
    DEFERRABLE = 437,
    DEFERRED = 438,
    DEFINER = 439,
    DELETE_P = 440,
    DELIMITER = 441,
    DELIMITERS = 442,
    DESC = 443,
    DICTIONARY = 444,
    DISABLE_P = 445,
    DISCARD = 446,
    DISTINCT = 447,
    DO = 448,
    DOCUMENT_P = 449,
    DOMAIN_P = 450,
    DOUBLE_P = 451,
    DROP = 452,
    EACH = 453,
    ELSE = 454,
    ENABLE_P = 455,
    ENCODING = 456,
    ENCRYPTED = 457,
    END_P = 458,
    ENUM_P = 459,
    ESCAPE = 460,
    EVENT = 461,
    EXCEPT = 462,
    EXCLUDE = 463,
    EXCLUDING = 464,
    EXCLUSIVE = 465,
    EXECUTE = 466,
    EXISTS = 467,
    EXPLAIN = 468,
    EXTENSION = 469,
    EXTERNAL = 470,
    EXTRACT = 471,
    FALSE_P = 472,
    FAMILY = 473,
    FETCH = 474,
    FIRST_P = 475,
    FLOAT_P = 476,
    FOLLOWING = 477,
    FOR = 478,
    FORCE = 479,
    FOREIGN = 480,
    FORWARD = 481,
    FREEZE = 482,
    FROM = 483,
    FULL = 484,
    FUNCTION = 485,
    FUNCTIONS = 486,
    GLOBAL = 487,
    GRANT = 488,
    GRANTED = 489,
    GREATEST = 490,
    GROUP_P = 491,
    HANDLER = 492,
    HAVING = 493,
    HEADER_P = 494,
    HOLD = 495,
    HOUR_P = 496,
    IDENTITY_P = 497,
    IF_P = 498,
    ILIKE = 499,
    IMMEDIATE = 500,
    IMMUTABLE = 501,
    IMPLICIT_P = 502,
    IN_P = 503,
    INCLUDING = 504,
    INCREMENT = 505,
    INDEX = 506,
    INDEXES = 507,
    INHERIT = 508,
    INHERITS = 509,
    INITIALLY = 510,
    INLINE_P = 511,
    INNER_P = 512,
    INOUT = 513,
    INPUT_P = 514,
    INSENSITIVE = 515,
    INSERT = 516,
    INSTEAD = 517,
    INT_P = 518,
    INTEGER = 519,
    INTERSECT = 520,
    INTERVAL = 521,
    INTO = 522,
    INVOKER = 523,
    IS = 524,
    ISNULL = 525,
    ISOLATION = 526,
    JOIN = 527,
    KEY = 528,
    LABEL = 529,
    LANGUAGE = 530,
    LARGE_P = 531,
    LAST_P = 532,
    LATERAL_P = 533,
    LC_COLLATE_P = 534,
    LC_CTYPE_P = 535,
    LEADING = 536,
    LEAKPROOF = 537,
    LEAST = 538,
    LEFT = 539,
    LEVEL = 540,
    LIKE = 541,
    LIMIT = 542,
    LISTEN = 543,
    LOAD = 544,
    LOCAL = 545,
    LOCALTIME = 546,
    LOCALTIMESTAMP = 547,
    LOCATION = 548,
    LOCK_P = 549,
    MAPPING = 550,
    MATCH = 551,
    MATERIALIZED = 552,
    MAXVALUE = 553,
    MINUTE_P = 554,
    MINVALUE = 555,
    MODE = 556,
    MONTH_P = 557,
    MOVE = 558,
    NAME_P = 559,
    NAMES = 560,
    NATIONAL = 561,
    NATURAL = 562,
    NCHAR = 563,
    NEXT = 564,
    NO = 565,
    NONE = 566,
    NOT = 567,
    NOTHING = 568,
    NOTIFY = 569,
    NOTNULL = 570,
    NOWAIT = 571,
    NULL_P = 572,
    NULLIF = 573,
    NULLS_P = 574,
    NUMERIC = 575,
    OBJECT_P = 576,
    OF = 577,
    OFF = 578,
    OFFSET = 579,
    OIDS = 580,
    ON = 581,
    ONLY = 582,
    OPERATOR = 583,
    OPTION = 584,
    OPTIONS = 585,
    OR = 586,
    ORDER = 587,
    OUT_P = 588,
    OUTER_P = 589,
    OVER = 590,
    OVERLAPS = 591,
    OVERLAY = 592,
    OWNED = 593,
    OWNER = 594,
    PARSER = 595,
    PARTIAL = 596,
    PARTITION = 597,
    PASSING = 598,
    PASSWORD = 599,
    PLACING = 600,
    PLANS = 601,
    POSITION = 602,
    PRECEDING = 603,
    PRECISION = 604,
    PRESERVE = 605,
    PREPARE = 606,
    PREPARED = 607,
    PRIMARY = 608,
    PRIOR = 609,
    PRIVILEGES = 610,
    PROCEDURAL = 611,
    PROCEDURE = 612,
    PROGRAM = 613,
    QUOTE = 614,
    RANGE = 615,
    READ = 616,
    REAL = 617,
    REASSIGN = 618,
    RECHECK = 619,
    RECURSIVE = 620,
    REF = 621,
    REFERENCES = 622,
    REFRESH = 623,
    REINDEX = 624,
    RELATIVE_P = 625,
    RELEASE = 626,
    RENAME = 627,
    REPEATABLE = 628,
    REPLACE = 629,
    REPLICA = 630,
    RESET = 631,
    RESTART = 632,
    RESTRICT = 633,
    RETURNING = 634,
    RETURNS = 635,
    REVOKE = 636,
    RIGHT = 637,
    ROLE = 638,
    ROLLBACK = 639,
    ROW = 640,
    ROWS = 641,
    RULE = 642,
    SAVEPOINT = 643,
    SCHEMA = 644,
    SCROLL = 645,
    SEARCH = 646,
    SECOND_P = 647,
    SECURITY = 648,
    SELECT = 649,
    SEQUENCE = 650,
    SEQUENCES = 651,
    SERIALIZABLE = 652,
    SERVER = 653,
    SESSION = 654,
    SESSION_USER = 655,
    SET = 656,
    SETOF = 657,
    SHARE = 658,
    SHOW = 659,
    SIMILAR = 660,
    SIMPLE = 661,
    SMALLINT = 662,
    SNAPSHOT = 663,
    SOME = 664,
    STABLE = 665,
    STANDALONE_P = 666,
    START = 667,
    STATEMENT = 668,
    STATISTICS = 669,
    STDIN = 670,
    STDOUT = 671,
    STORAGE = 672,
    STRICT_P = 673,
    STRIP_P = 674,
    SUBSTRING = 675,
    SYMMETRIC = 676,
    SYSID = 677,
    SYSTEM_P = 678,
    TABLE = 679,
    TABLES = 680,
    TABLESPACE = 681,
    TEMP = 682,
    TEMPLATE = 683,
    TEMPORARY = 684,
    TEXT_P = 685,
    THEN = 686,
    TIME = 687,
    TIMESTAMP = 688,
    TO = 689,
    TRAILING = 690,
    TRANSACTION = 691,
    TREAT = 692,
    TRIGGER = 693,
    TRIM = 694,
    TRUE_P = 695,
    TRUNCATE = 696,
    TRUSTED = 697,
    TYPE_P = 698,
    TYPES_P = 699,
    UNBOUNDED = 700,
    UNCOMMITTED = 701,
    UNENCRYPTED = 702,
    UNION = 703,
    UNIQUE = 704,
    UNKNOWN = 705,
    UNLISTEN = 706,
    UNLOGGED = 707,
    UNTIL = 708,
    UPDATE = 709,
    USER = 710,
    USING = 711,
    VACUUM = 712,
    VALID = 713,
    VALIDATE = 714,
    VALIDATOR = 715,
    VALUE_P = 716,
    VALUES = 717,
    VARCHAR = 718,
    VARIADIC = 719,
    VARYING = 720,
    VERBOSE = 721,
    VERSION_P = 722,
    VIEW = 723,
    VOLATILE = 724,
    WHEN = 725,
    WHERE = 726,
    WHITESPACE_P = 727,
    WINDOW = 728,
    WITH = 729,
    WITHOUT = 730,
    WORK = 731,
    WRAPPER = 732,
    WRITE = 733,
    XML_P = 734,
    XMLATTRIBUTES = 735,
    XMLCONCAT = 736,
    XMLELEMENT = 737,
    XMLEXISTS = 738,
    XMLFOREST = 739,
    XMLPARSE = 740,
    XMLPI = 741,
    XMLROOT = 742,
    XMLSERIALIZE = 743,
    YEAR_P = 744,
    YES_P = 745,
    ZONE = 746,
    NULLS_FIRST = 747,
    NULLS_LAST = 748,
    WITH_TIME = 749,
    POSTFIXOP = 750,
    UMINUS = 751
  };
#endif

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED

union YYSTYPE
{
#line 564 "preproc.y" /* yacc.c:355  */

	double	dval;
	char	*str;
	int		ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
	struct	prep		prep;

#line 1182 "preproc.c" /* yacc.c:355  */
};

typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif

/* Location type.  */
#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE YYLTYPE;
struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
};
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


extern YYSTYPE base_yylval;
extern YYLTYPE base_yylloc;
int base_yyparse (void);

#endif /* !YY_BASE_YY_PREPROC_H_INCLUDED  */

/* Copy the second part of user declarations.  */

#line 1213 "preproc.c" /* yacc.c:358  */

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE
# if (defined __GNUC__                                               \
      && (2 < __GNUC__ || (__GNUC__ == 2 && 96 <= __GNUC_MINOR__)))  \
     || defined __SUNPRO_C && 0x5110 <= __SUNPRO_C
#  define YY_ATTRIBUTE(Spec) __attribute__(Spec)
# else
#  define YY_ATTRIBUTE(Spec) /* empty */
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# define YY_ATTRIBUTE_PURE   YY_ATTRIBUTE ((__pure__))
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# define YY_ATTRIBUTE_UNUSED YY_ATTRIBUTE ((__unused__))
#endif

#if !defined _Noreturn \
     && (!defined __STDC_VERSION__ || __STDC_VERSION__ < 201112)
# if defined _MSC_VER && 1200 <= _MSC_VER
#  define _Noreturn __declspec (noreturn)
# else
#  define _Noreturn YY_ATTRIBUTE ((__noreturn__))
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif


#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
             && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE) + sizeof (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYSIZE_T yynewbytes;                                            \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / sizeof (*yyptr);                          \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   110209

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  516
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  701
/* YYNRULES -- Number of rules.  */
#define YYNRULES  2798
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  5125

/* YYTRANSLATE[YYX] -- Symbol number corresponding to YYX as returned
   by yylex, with out-of-bounds checking.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   751

#define YYTRANSLATE(YYX)                                                \
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, without out-of-bounds checking.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   503,     2,     2,
     508,   509,   501,   499,   511,   500,   510,   502,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   513,   512,
     496,   495,   497,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   506,     2,   507,   504,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   514,     2,   515,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     498,   505
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1479,  1479,  1482,  1484,  1486,  1488,  1490,  1492,  1494,
    1496,  1498,  1500,  1502,  1504,  1506,  1508,  1510,  1512,  1514,
    1516,  1518,  1520,  1522,  1524,  1526,  1528,  1530,  1532,  1534,
    1536,  1554,  1556,  1558,  1560,  1562,  1564,  1566,  1568,  1570,
    1572,  1574,  1576,  1578,  1580,  1582,  1584,  1586,  1588,  1590,
    1592,  1594,  1596,  1598,  1600,  1602,  1604,  1606,  1608,  1610,
    1612,  1614,  1618,  1620,  1622,  1624,  1626,  1628,  1630,  1632,
    1634,  1636,  1638,  1640,  1642,  1644,  1646,  1648,  1650,  1652,
    1654,  1656,  1658,  1660,  1662,  1664,  1666,  1668,  1670,  1672,
    1674,  1676,  1678,  1680,  1682,  1684,  1686,  1693,  1695,  1697,
    1699,  1701,  1703,  1705,  1707,  1709,  1711,  1713,  1715,  1721,
    1723,  1725,  1727,  1729,  1731,  1733,  1735,  1737,  1743,  1753,
    1757,  1763,  1767,  1777,  1787,  1788,  1802,  1809,  1815,  1826,
    1832,  1841,  1848,  1854,  1863,  1870,  1878,  1883,  1891,  1896,
    1902,  1907,  1913,  1918,  1924,  1928,  1932,  1936,  1940,  1944,
    1948,  1952,  1956,  1964,  1968,  1972,  1976,  1980,  1984,  1992,
    2000,  2009,  2011,  2019,  2023,  2031,  2039,  2043,  2051,  2055,
    2063,  2067,  2075,  2083,  2091,  2095,  2103,  2107,  2115,  2119,
    2123,  2128,  2137,  2142,  2148,  2153,  2159,  2163,  2167,  2171,
    2175,  2179,  2187,  2191,  2195,  2203,  2207,  2211,  2219,  2223,
    2227,  2231,  2235,  2239,  2243,  2248,  2252,  2256,  2260,  2264,
    2268,  2272,  2280,  2284,  2292,  2296,  2304,  2308,  2322,  2326,
    2330,  2334,  2342,  2346,  2350,  2354,  2362,  2366,  2370,  2374,
    2378,  2382,  2386,  2394,  2398,  2403,  2409,  2413,  2421,  2425,
    2429,  2433,  2437,  2445,  2449,  2457,  2461,  2469,  2473,  2477,
    2481,  2485,  2494,  2502,  2506,  2514,  2518,  2526,  2534,  2538,
    2542,  2546,  2554,  2558,  2562,  2566,  2570,  2574,  2578,  2582,
    2586,  2590,  2598,  2602,  2610,  2614,  2618,  2622,  2626,  2630,
    2634,  2638,  2642,  2646,  2650,  2654,  2658,  2662,  2666,  2670,
    2674,  2678,  2682,  2686,  2690,  2694,  2698,  2702,  2706,  2710,
    2714,  2718,  2722,  2726,  2730,  2734,  2738,  2742,  2746,  2750,
    2754,  2758,  2762,  2766,  2770,  2774,  2782,  2786,  2794,  2798,
    2803,  2809,  2814,  2820,  2825,  2831,  2839,  2844,  2850,  2854,
    2862,  2866,  2870,  2874,  2882,  2890,  2894,  2902,  2906,  2910,
    2914,  2922,  2927,  2935,  2943,  2951,  2955,  2963,  2968,  2974,
    2978,  2982,  2990,  2994,  3002,  3007,  3013,  3017,  3021,  3025,
    3029,  3033,  3037,  3041,  3045,  3049,  3053,  3057,  3061,  3069,
    3074,  3080,  3085,  3091,  3096,  3102,  3107,  3113,  3117,  3125,
    3133,  3137,  3141,  3145,  3150,  3156,  3160,  3168,  3176,  3180,
    3184,  3188,  3196,  3200,  3204,  3208,  3212,  3216,  3220,  3225,
    3231,  3236,  3242,  3247,  3253,  3257,  3265,  3269,  3277,  3281,
    3285,  3293,  3297,  3305,  3313,  3321,  3326,  3332,  3336,  3340,
    3344,  3352,  3356,  3360,  3364,  3368,  3372,  3376,  3384,  3388,
    3392,  3396,  3404,  3412,  3416,  3421,  3427,  3431,  3435,  3439,
    3443,  3447,  3455,  3459,  3467,  3471,  3475,  3479,  3483,  3487,
    3491,  3499,  3504,  3510,  3515,  3521,  3525,  3533,  3541,  3545,
    3550,  3555,  3561,  3565,  3573,  3577,  3585,  3590,  3596,  3600,
    3604,  3608,  3613,  3619,  3627,  3635,  3639,  3643,  3647,  3651,
    3659,  3664,  3670,  3674,  3678,  3683,  3689,  3693,  3697,  3702,
    3708,  3713,  3719,  3724,  3730,  3738,  3746,  3750,  3755,  3761,
    3769,  3777,  3782,  3788,  3796,  3804,  3808,  3816,  3821,  3827,
    3831,  3839,  3843,  3847,  3851,  3855,  3859,  3863,  3867,  3871,
    3875,  3879,  3883,  3891,  3896,  3902,  3906,  3910,  3914,  3922,
    3926,  3934,  3938,  3946,  3951,  3957,  3961,  3969,  3974,  3980,
    3984,  3992,  3997,  4003,  4007,  4015,  4020,  4026,  4034,  4039,
    4045,  4049,  4057,  4061,  4069,  4074,  4080,  4084,  4088,  4096,
    4104,  4109,  4115,  4123,  4127,  4131,  4135,  4139,  4143,  4147,
    4151,  4155,  4159,  4163,  4167,  4171,  4175,  4179,  4183,  4187,
    4191,  4195,  4199,  4203,  4207,  4211,  4215,  4223,  4231,  4235,
    4239,  4243,  4251,  4255,  4263,  4268,  4274,  4278,  4286,  4290,
    4298,  4303,  4309,  4313,  4321,  4329,  4333,  4341,  4345,  4349,
    4353,  4361,  4369,  4377,  4385,  4393,  4398,  4404,  4408,  4416,
    4421,  4427,  4431,  4439,  4443,  4447,  4455,  4459,  4467,  4471,
    4479,  4487,  4491,  4495,  4503,  4507,  4515,  4523,  4527,  4535,
    4539,  4543,  4551,  4555,  4563,  4567,  4571,  4575,  4579,  4587,
    4592,  4598,  4603,  4609,  4613,  4621,  4626,  4632,  4636,  4641,
    4647,  4651,  4655,  4659,  4667,  4672,  4679,  4681,  4689,  4693,
    4697,  4701,  4705,  4709,  4717,  4721,  4729,  4733,  4741,  4745,
    4753,  4761,  4765,  4773,  4781,  4785,  4789,  4793,  4801,  4810,
    4819,  4823,  4827,  4831,  4835,  4839,  4843,  4847,  4851,  4855,
    4859,  4863,  4867,  4871,  4879,  4887,  4891,  4899,  4903,  4911,
    4915,  4919,  4923,  4927,  4935,  4939,  4947,  4955,  4959,  4967,
    4975,  4980,  4986,  4990,  4998,  5002,  5006,  5014,  5019,  5025,
    5033,  5037,  5045,  5049,  5053,  5057,  5061,  5069,  5074,  5080,
    5085,  5091,  5095,  5100,  5106,  5112,  5118,  5126,  5130,  5138,
    5142,  5150,  5154,  5162,  5166,  5174,  5178,  5186,  5194,  5202,
    5206,  5210,  5214,  5222,  5226,  5230,  5234,  5238,  5242,  5246,
    5250,  5254,  5258,  5262,  5266,  5270,  5274,  5278,  5282,  5286,
    5294,  5298,  5306,  5310,  5318,  5322,  5330,  5338,  5342,  5347,
    5353,  5357,  5361,  5365,  5369,  5373,  5377,  5381,  5385,  5389,
    5393,  5397,  5401,  5409,  5413,  5417,  5421,  5425,  5429,  5433,
    5437,  5441,  5445,  5449,  5453,  5457,  5461,  5465,  5469,  5473,
    5477,  5481,  5485,  5489,  5493,  5497,  5505,  5509,  5517,  5521,
    5525,  5529,  5533,  5541,  5546,  5552,  5556,  5560,  5564,  5568,
    5572,  5576,  5580,  5584,  5588,  5592,  5596,  5600,  5608,  5612,
    5620,  5624,  5628,  5632,  5638,  5644,  5650,  5656,  5662,  5668,
    5674,  5684,  5695,  5706,  5717,  5728,  5739,  5750,  5766,  5782,
    5798,  5809,  5825,  5836,  5852,  5867,  5871,  5879,  5884,  5890,
    5898,  5902,  5910,  5914,  5918,  5922,  5926,  5934,  5938,  5946,
    5950,  5954,  5958,  5966,  5970,  5974,  5978,  5982,  5986,  5990,
    5994,  5998,  6002,  6006,  6010,  6014,  6018,  6022,  6026,  6034,
    6038,  6046,  6050,  6058,  6063,  6069,  6073,  6081,  6089,  6097,
    6101,  6109,  6114,  6120,  6125,  6131,  6139,  6144,  6150,  6154,
    6158,  6166,  6170,  6174,  6182,  6186,  6190,  6194,  6202,  6210,
    6215,  6221,  6226,  6232,  6237,  6243,  6248,  6254,  6258,  6266,
    6270,  6274,  6282,  6287,  6293,  6297,  6302,  6308,  6312,  6317,
    6323,  6327,  6332,  6338,  6342,  6346,  6354,  6359,  6365,  6369,
    6377,  6381,  6389,  6393,  6401,  6405,  6413,  6417,  6421,  6425,
    6429,  6437,  6441,  6445,  6449,  6453,  6461,  6469,  6477,  6481,
    6485,  6493,  6497,  6501,  6509,  6513,  6521,  6525,  6529,  6533,
    6537,  6541,  6545,  6549,  6553,  6557,  6561,  6565,  6569,  6573,
    6577,  6585,  6589,  6593,  6597,  6605,  6609,  6617,  6622,  6628,
    6636,  6640,  6648,  6656,  6660,  6668,  6673,  6679,  6683,  6691,
    6695,  6703,  6707,  6715,  6719,  6723,  6727,  6735,  6739,  6747,
    6755,  6759,  6767,  6771,  6779,  6783,  6787,  6795,  6799,  6804,
    6810,  6818,  6823,  6829,  6833,  6837,  6845,  6849,  6857,  6862,
    6868,  6872,  6876,  6880,  6884,  6888,  6892,  6896,  6900,  6904,
    6908,  6912,  6916,  6920,  6924,  6928,  6932,  6936,  6940,  6944,
    6948,  6952,  6956,  6960,  6964,  6968,  6972,  6976,  6980,  6984,
    6988,  6992,  6996,  7000,  7004,  7008,  7012,  7016,  7020,  7024,
    7028,  7032,  7036,  7040,  7044,  7048,  7052,  7060,  7065,  7071,
    7076,  7082,  7086,  7090,  7094,  7098,  7102,  7106,  7110,  7114,
    7118,  7122,  7126,  7130,  7134,  7138,  7142,  7146,  7150,  7154,
    7158,  7162,  7166,  7170,  7174,  7182,  7186,  7190,  7194,  7198,
    7202,  7206,  7210,  7214,  7218,  7222,  7226,  7230,  7234,  7238,
    7242,  7246,  7250,  7254,  7262,  7270,  7274,  7278,  7286,  7290,
    7298,  7302,  7306,  7310,  7314,  7322,  7327,  7333,  7337,  7341,
    7345,  7353,  7357,  7362,  7368,  7372,  7380,  7388,  7393,  7399,
    7407,  7411,  7419,  7423,  7427,  7431,  7435,  7439,  7443,  7447,
    7451,  7455,  7459,  7463,  7467,  7471,  7479,  7483,  7488,  7494,
    7498,  7502,  7506,  7510,  7518,  7522,  7526,  7534,  7539,  7545,
    7549,  7553,  7557,  7565,  7570,  7575,  7581,  7587,  7595,  7603,
    7608,  7614,  7618,  7622,  7626,  7630,  7634,  7638,  7642,  7646,
    7650,  7654,  7658,  7662,  7666,  7670,  7674,  7682,  7687,  7693,
    7697,  7705,  7713,  7718,  7724,  7732,  7736,  7744,  7752,  7756,
    7760,  7764,  7768,  7772,  7776,  7784,  7789,  7795,  7803,  7807,
    7811,  7815,  7819,  7823,  7831,  7839,  7843,  7847,  7855,  7860,
    7866,  7870,  7874,  7878,  7882,  7890,  7894,  7902,  7906,  7910,
    7914,  7922,  7926,  7934,  7938,  7946,  7951,  7957,  7962,  7968,
    7973,  7979,  7984,  7990,  7994,  7998,  8002,  8010,  8014,  8018,
    8022,  8026,  8030,  8034,  8038,  8042,  8050,  8054,  8062,  8070,
    8074,  8082,  8086,  8091,  8097,  8103,  8113,  8118,  8124,  8128,
    8132,  8136,  8144,  8146,  8154,  8159,  8165,  8173,  8177,  8181,
    8189,  8193,  8201,  8209,  8214,  8220,  8228,  8233,  8239,  8247,
    8252,  8258,  8262,  8266,  8270,  8274,  8278,  8282,  8286,  8294,
    8299,  8305,  8313,  8317,  8325,  8329,  8337,  8345,  8353,  8361,
    8365,  8373,  8426,  8430,  8443,  8445,  8449,  8453,  8457,  8466,
    8472,  8476,  8484,  8488,  8496,  8500,  8508,  8512,  8516,  8520,
    8524,  8528,  8532,  8536,  8544,  8548,  8556,  8560,  8564,  8568,
    8572,  8576,  8584,  8588,  8596,  8600,  8608,  8616,  8621,  8627,
    8632,  8634,  8640,  8644,  8648,  8652,  8656,  8660,  8664,  8668,
    8672,  8680,  8685,  8691,  8695,  8700,  8706,  8710,  8714,  8719,
    8725,  8730,  8736,  8744,  8748,  8756,  8760,  8768,  8772,  8776,
    8780,  8788,  8793,  8799,  8803,  8808,  8812,  8820,  8824,  8832,
    8836,  8844,  8852,  8856,  8860,  8868,  8872,  8880,  8884,  8892,
    8896,  8904,  8909,  8915,  8920,  8926,  8930,  8938,  8943,  8949,
    8953,  8961,  8969,  8973,  8977,  8981,  8989,  8994,  9000,  9004,
    9012,  9017,  9023,  9027,  9035,  9039,  9043,  9047,  9054,  9061,
    9065,  9073,  9077,  9081,  9085,  9089,  9093,  9101,  9105,  9109,
    9113,  9121,  9126,  9132,  9136,  9140,  9144,  9149,  9155,  9159,
    9163,  9167,  9175,  9180,  9186,  9190,  9198,  9202,  9206,  9210,
    9218,  9222,  9230,  9234,  9238,  9246,  9254,  9259,  9265,  9269,
    9275,  9281,  9286,  9292,  9296,  9304,  9312,  9314,  9316,  9320,
    9324,  9328,  9336,  9346,  9357,  9366,  9370,  9374,  9378,  9382,
    9386,  9390,  9398,  9402,  9406,  9410,  9418,  9422,  9430,  9435,
    9441,  9445,  9449,  9453,  9457,  9461,  9465,  9469,  9473,  9477,
    9481,  9489,  9494,  9500,  9504,  9512,  9516,  9524,  9532,  9540,
    9544,  9552,  9556,  9564,  9572,  9580,  9584,  9588,  9592,  9596,
    9600,  9608,  9613,  9619,  9624,  9630,  9634,  9638,  9642,  9650,
    9658,  9662,  9667,  9673,  9677,  9681,  9685,  9689,  9693,  9697,
    9701,  9705,  9709,  9713,  9717,  9721,  9726,  9732,  9736,  9744,
    9748,  9752,  9756,  9760,  9764,  9768,  9772,  9776,  9780,  9784,
    9788,  9792,  9796,  9800,  9804,  9808,  9812,  9816,  9820,  9824,
    9828,  9832,  9836,  9840,  9844,  9848,  9852,  9856,  9860,  9864,
    9868,  9872,  9876,  9880,  9884,  9888,  9892,  9896,  9900,  9904,
    9908,  9912,  9916,  9920,  9924,  9928,  9932,  9936,  9940,  9944,
    9948,  9952,  9956,  9960,  9964,  9968,  9973,  9977,  9985,  9989,
    9993,  9997, 10001, 10005, 10009, 10013, 10017, 10021, 10025, 10029,
   10033, 10037, 10041, 10045, 10049, 10053, 10057, 10061, 10065, 10069,
   10077, 10081, 10085, 10089, 10093, 10097, 10101, 10105, 10109, 10113,
   10117, 10121, 10129, 10133, 10137, 10141, 10145, 10149, 10153, 10157,
   10161, 10165, 10169, 10173, 10177, 10181, 10185, 10189, 10193, 10197,
   10201, 10205, 10209, 10213, 10217, 10221, 10225, 10229, 10233, 10237,
   10241, 10245, 10249, 10253, 10257, 10261, 10265, 10269, 10273, 10277,
   10281, 10285, 10289, 10293, 10297, 10301, 10305, 10309, 10313, 10317,
   10321, 10325, 10333, 10337, 10345, 10349, 10353, 10358, 10364, 10372,
   10376, 10384, 10388, 10396, 10400, 10408, 10412, 10417, 10423, 10427,
   10431, 10435, 10443, 10448, 10454, 10458, 10466, 10474, 10478, 10483,
   10489, 10497, 10501, 10508, 10513, 10519, 10524, 10529, 10535, 10539,
   10547, 10551, 10555, 10559, 10563, 10571, 10575, 10579, 10587, 10591,
   10595, 10603, 10607, 10615, 10619, 10623, 10627, 10631, 10635, 10639,
   10643, 10647, 10655, 10659, 10667, 10671, 10679, 10683, 10687, 10691,
   10695, 10699, 10707, 10711, 10719, 10723, 10731, 10735, 10743, 10747,
   10755, 10759, 10763, 10771, 10775, 10783, 10788, 10794, 10798, 10802,
   10806, 10810, 10814, 10818, 10822, 10830, 10834, 10842, 10850, 10855,
   10861, 10865, 10869, 10873, 10877, 10882, 10888, 10896, 10904, 10908,
   10912, 10920, 10924, 10932, 10940, 10944, 10952, 10960, 10965, 10971,
   10976, 10982, 10986, 10994, 10998, 11002, 11006, 11014, 11018, 11027,
   11029, 11037, 11042, 11048, 11052, 11060, 11064, 11072, 11080, 11084,
   11092, 11096, 11100, 11104, 11112, 11116, 11124, 11128, 11136, 11140,
   11148, 11156, 11164, 11172, 11180, 11188, 11196, 11200, 11208, 11212,
   11216, 11220, 11224, 11228, 11232, 11236, 11240, 11244, 11248, 11252,
   11256, 11260, 11261, 11266, 11272, 11280, 11284, 11292, 11296, 11297,
   11301, 11309, 11313, 11317, 11321, 11329, 11333, 11337, 11341, 11345,
   11349, 11353, 11357, 11361, 11365, 11369, 11373, 11377, 11381, 11385,
   11389, 11393, 11397, 11401, 11405, 11409, 11413, 11417, 11421, 11425,
   11429, 11433, 11437, 11441, 11445, 11449, 11453, 11457, 11461, 11465,
   11469, 11473, 11477, 11481, 11485, 11489, 11493, 11497, 11501, 11505,
   11509, 11513, 11517, 11521, 11525, 11529, 11533, 11537, 11541, 11545,
   11549, 11553, 11557, 11561, 11565, 11569, 11573, 11577, 11581, 11585,
   11589, 11593, 11597, 11601, 11605, 11609, 11613, 11617, 11621, 11625,
   11629, 11633, 11637, 11641, 11645, 11649, 11653, 11657, 11661, 11665,
   11669, 11673, 11677, 11681, 11685, 11689, 11693, 11697, 11701, 11705,
   11709, 11713, 11717, 11721, 11725, 11729, 11733, 11737, 11741, 11745,
   11749, 11753, 11757, 11761, 11765, 11769, 11773, 11777, 11781, 11785,
   11789, 11793, 11797, 11801, 11805, 11809, 11813, 11817, 11821, 11825,
   11829, 11833, 11837, 11841, 11845, 11849, 11853, 11857, 11861, 11865,
   11869, 11873, 11877, 11881, 11885, 11889, 11893, 11897, 11901, 11905,
   11909, 11913, 11917, 11921, 11925, 11929, 11933, 11937, 11941, 11945,
   11949, 11953, 11957, 11961, 11965, 11969, 11973, 11977, 11981, 11985,
   11989, 11993, 11997, 12001, 12005, 12009, 12013, 12017, 12021, 12025,
   12029, 12033, 12037, 12041, 12045, 12049, 12053, 12057, 12061, 12065,
   12069, 12073, 12077, 12081, 12085, 12089, 12093, 12097, 12101, 12105,
   12109, 12113, 12117, 12121, 12125, 12129, 12133, 12137, 12141, 12145,
   12149, 12153, 12157, 12161, 12165, 12169, 12173, 12177, 12181, 12185,
   12189, 12193, 12197, 12201, 12205, 12209, 12213, 12217, 12221, 12225,
   12229, 12233, 12237, 12241, 12245, 12249, 12253, 12257, 12261, 12265,
   12269, 12273, 12277, 12281, 12285, 12289, 12293, 12297, 12301, 12305,
   12313, 12317, 12321, 12325, 12329, 12333, 12337, 12341, 12345, 12349,
   12353, 12357, 12361, 12365, 12369, 12373, 12377, 12381, 12385, 12389,
   12393, 12397, 12401, 12405, 12409, 12413, 12417, 12421, 12425, 12429,
   12433, 12437, 12441, 12445, 12449, 12453, 12457, 12461, 12465, 12469,
   12473, 12477, 12481, 12485, 12493, 12497, 12501, 12505, 12509, 12513,
   12517, 12521, 12525, 12529, 12533, 12537, 12541, 12545, 12549, 12553,
   12557, 12561, 12565, 12569, 12573, 12577, 12581, 12589, 12593, 12597,
   12601, 12605, 12609, 12613, 12617, 12621, 12625, 12629, 12633, 12637,
   12641, 12645, 12649, 12653, 12657, 12661, 12665, 12669, 12673, 12677,
   12681, 12685, 12689, 12693, 12697, 12701, 12705, 12709, 12713, 12717,
   12721, 12725, 12729, 12733, 12737, 12741, 12745, 12749, 12753, 12757,
   12761, 12765, 12769, 12773, 12777, 12781, 12785, 12789, 12793, 12797,
   12801, 12805, 12809, 12813, 12817, 12821, 12825, 12829, 12833, 12837,
   12841, 12845, 12849, 12853, 12857, 12861, 12865, 12869, 12873, 12877,
   12881, 12885, 12895, 12896, 12899, 12900, 12901, 12907, 12908, 12909,
   12910, 12911, 12924, 12924, 12933, 12948, 12950, 12953, 12955, 12959,
   12971, 12987, 12991, 13002, 13003, 13006, 13018, 13027, 13028, 13031,
   13032, 13033, 13036, 13037, 13040, 13041, 13044, 13045, 13048, 13050,
   13052, 13054, 13058, 13065, 13072, 13088, 13122, 13132, 13135, 13139,
   13152, 13153, 13155, 13157, 13161, 13175, 13182, 13243, 13252, 13254,
   13255, 13258, 13260, 13261, 13264, 13265, 13266, 13267, 13268, 13275,
   13274, 13284, 13286, 13288, 13289, 13292, 13293, 13294, 13295, 13298,
   13299, 13303, 13302, 13319, 13317, 13333, 13332, 13346, 13352, 13353,
   13356, 13358, 13359, 13362, 13363, 13364, 13365, 13368, 13369, 13372,
   13380, 13397, 13405, 13428, 13534, 13568, 13570, 13572, 13576, 13580,
   13579, 13630, 13632, 13631, 13646, 13652, 13659, 13664, 13670, 13671,
   13674, 13675, 13676, 13677, 13678, 13679, 13680, 13688, 13696, 13699,
   13700, 13701, 13702, 13703, 13704, 13712, 13720, 13721, 13722, 13725,
   13726, 13729, 13731, 13740, 13828, 13829, 13836, 13837, 13838, 13844,
   13853, 13856, 13857, 13858, 13859, 13862, 13863, 13864, 13867, 13869,
   13877, 13878, 13884, 13892, 13893, 13896, 13897, 13900, 13905, 13912,
   13917, 13924, 13931, 13931, 13933, 13940, 13941, 13944, 13945, 13946,
   13947, 13948, 13949, 13950, 13951, 13952, 13958, 13965, 13977, 13983,
   13990, 13998, 13999, 14011, 14022, 14033, 14037, 14038, 14041, 14046,
   14050, 14051, 14054, 14060, 14068, 14074, 14081, 14085, 14086, 14089,
   14092, 14096, 14097, 14100, 14106, 14115, 14120, 14130, 14140, 14152,
   14153, 14154, 14155, 14156, 14157, 14158, 14159, 14160, 14161, 14162,
   14163, 14164, 14165, 14166, 14173, 14174, 14177, 14178, 14185, 14186,
   14187, 14194, 14193, 14210, 14211, 14218, 14217, 14287, 14293, 14299,
   14307, 14313, 14319, 14325, 14331, 14337, 14343, 14349, 14355, 14366,
   14367, 14370, 14371, 14372, 14373, 14374, 14375, 14376, 14377, 14378,
   14379, 14380, 14381, 14382, 14383, 14384, 14385, 14386, 14387, 14388,
   14389, 14390, 14391, 14392, 14393, 14396, 14397, 14398, 14399, 14400,
   14401, 14405, 14406, 14407, 14408, 14409, 14410, 14411, 14414, 14417,
   14418, 14419, 14420, 14421, 14422, 14423, 14424, 14437, 14438, 14439,
   14440, 14441, 14442, 14443, 14448, 14449, 14450, 14451, 14452, 14453,
   14459, 14460, 14461, 14462, 14463, 14464, 14465, 14466, 14467, 14468,
   14469, 14472, 14473, 14474, 14475, 14476, 14479, 14480, 14481, 14482,
   14485, 14486, 14487, 14488, 14489, 14490, 14491, 14508, 14509, 14510,
   14513, 14514, 14515, 14516, 14517, 14518, 14522, 14522, 14525, 14531,
   14532, 14535, 14537, 14542, 14552, 14563, 14570, 14571, 14572, 14575,
   14608, 14610, 14612, 14615, 14625, 14635, 14645, 14646, 14649, 14651,
   14652, 14653, 14656, 14658, 14666, 14667, 14668, 14672, 14673, 14677,
   14678, 14681, 14682, 14685, 14686, 14687, 14688, 14689, 14692, 14693,
   14694, 14695, 14696, 14697, 14698, 14699, 14700, 14701, 14702, 14703,
   14704, 14705, 14706, 14707, 14708, 14709, 14710, 14711, 14712, 14713,
   14714, 14715, 14716, 14717, 14718, 14719, 14720, 14721, 14722, 14723,
   14724, 14725, 14726, 14727, 14728, 14729, 14730, 14731, 14732, 14733,
   14734, 14735, 14736, 14737, 14738, 14739, 14740, 14741, 14742, 14743,
   14744, 14745, 14746, 14747, 14750, 14751, 14752, 14753, 14756, 14757,
   14758, 14759, 14760, 14761, 14762, 14763, 14764, 14767, 14768, 14769,
   14770, 14773, 14774, 14777, 14778, 14781, 14782, 14793, 14794
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 0
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT",
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT",
  "SQL_COUNT", "SQL_DATETIME_INTERVAL_CODE",
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR",
  "SQL_DISCONNECT", "SQL_FOUND", "SQL_FREE", "SQL_GET", "SQL_GO",
  "SQL_GOTO", "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER",
  "SQL_LENGTH", "SQL_LONG", "SQL_NULLABLE", "SQL_OCTET_LENGTH", "SQL_OPEN",
  "SQL_OUTPUT", "SQL_REFERENCE", "SQL_RETURNED_LENGTH",
  "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", "SQL_SECTION", "SQL_SHORT",
  "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", "SQL_SQLPRINT",
  "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED",
  "SQL_VAR", "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO",
  "S_CONST", "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN",
  "S_INC", "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL",
  "S_NEQUAL", "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB",
  "S_VOLATILE", "S_TYPEDEF", "CSTRING", "CVARIABLE", "CPP_LINE", "IP",
  "DOLCONST", "ECONST", "NCONST", "UCONST", "UIDENT", "IDENT", "FCONST",
  "SCONST", "BCONST", "XCONST", "Op", "ICONST", "PARAM", "TYPECAST",
  "DOT_DOT", "COLON_EQUALS", "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION",
  "ADD_P", "ADMIN", "AFTER", "AGGREGATE", "ALL", "ALSO", "ALTER", "ALWAYS",
  "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERTION",
  "ASSIGNMENT", "ASYMMETRIC", "AT", "ATTRIBUTE", "AUTHORIZATION",
  "BACKWARD", "BEFORE", "BEGIN_P", "BETWEEN", "BIGINT", "BINARY", "BIT",
  "BOOLEAN_P", "BOTH", "BY", "CACHE", "CALLED", "CASCADE", "CASCADED",
  "CASE", "CAST", "CATALOG_P", "CHAIN", "CHAR_P", "CHARACTER",
  "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS", "CLOSE", "CLUSTER",
  "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMENT", "COMMENTS",
  "COMMIT", "COMMITTED", "CONCURRENTLY", "CONFIGURATION", "CONNECTION",
  "CONSTRAINT", "CONSTRAINTS", "CONTENT_P", "CONTINUE_P", "CONVERSION_P",
  "COPY", "COST", "CREATE", "CROSS", "CSV", "CURRENT_P", "CURRENT_CATALOG",
  "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_SCHEMA", "CURRENT_TIME",
  "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CYCLE", "DATA_P",
  "DATABASE", "DAY_P", "DEALLOCATE", "DEC", "DECIMAL_P", "DECLARE",
  "DEFAULT", "DEFAULTS", "DEFERRABLE", "DEFERRED", "DEFINER", "DELETE_P",
  "DELIMITER", "DELIMITERS", "DESC", "DICTIONARY", "DISABLE_P", "DISCARD",
  "DISTINCT", "DO", "DOCUMENT_P", "DOMAIN_P", "DOUBLE_P", "DROP", "EACH",
  "ELSE", "ENABLE_P", "ENCODING", "ENCRYPTED", "END_P", "ENUM_P", "ESCAPE",
  "EVENT", "EXCEPT", "EXCLUDE", "EXCLUDING", "EXCLUSIVE", "EXECUTE",
  "EXISTS", "EXPLAIN", "EXTENSION", "EXTERNAL", "EXTRACT", "FALSE_P",
  "FAMILY", "FETCH", "FIRST_P", "FLOAT_P", "FOLLOWING", "FOR", "FORCE",
  "FOREIGN", "FORWARD", "FREEZE", "FROM", "FULL", "FUNCTION", "FUNCTIONS",
  "GLOBAL", "GRANT", "GRANTED", "GREATEST", "GROUP_P", "HANDLER", "HAVING",
  "HEADER_P", "HOLD", "HOUR_P", "IDENTITY_P", "IF_P", "ILIKE", "IMMEDIATE",
  "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING", "INCREMENT", "INDEX",
  "INDEXES", "INHERIT", "INHERITS", "INITIALLY", "INLINE_P", "INNER_P",
  "INOUT", "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", "INT_P",
  "INTEGER", "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", "ISNULL",
  "ISOLATION", "JOIN", "KEY", "LABEL", "LANGUAGE", "LARGE_P", "LAST_P",
  "LATERAL_P", "LC_COLLATE_P", "LC_CTYPE_P", "LEADING", "LEAKPROOF",
  "LEAST", "LEFT", "LEVEL", "LIKE", "LIMIT", "LISTEN", "LOAD", "LOCAL",
  "LOCALTIME", "LOCALTIMESTAMP", "LOCATION", "LOCK_P", "MAPPING", "MATCH",
  "MATERIALIZED", "MAXVALUE", "MINUTE_P", "MINVALUE", "MODE", "MONTH_P",
  "MOVE", "NAME_P", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO",
  "NONE", "NOT", "NOTHING", "NOTIFY", "NOTNULL", "NOWAIT", "NULL_P",
  "NULLIF", "NULLS_P", "NUMERIC", "OBJECT_P", "OF", "OFF", "OFFSET",
  "OIDS", "ON", "ONLY", "OPERATOR", "OPTION", "OPTIONS", "OR", "ORDER",
  "OUT_P", "OUTER_P", "OVER", "OVERLAPS", "OVERLAY", "OWNED", "OWNER",
  "PARSER", "PARTIAL", "PARTITION", "PASSING", "PASSWORD", "PLACING",
  "PLANS", "POSITION", "PRECEDING", "PRECISION", "PRESERVE", "PREPARE",
  "PREPARED", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURAL", "PROCEDURE",
  "PROGRAM", "QUOTE", "RANGE", "READ", "REAL", "REASSIGN", "RECHECK",
  "RECURSIVE", "REF", "REFERENCES", "REFRESH", "REINDEX", "RELATIVE_P",
  "RELEASE", "RENAME", "REPEATABLE", "REPLACE", "REPLICA", "RESET",
  "RESTART", "RESTRICT", "RETURNING", "RETURNS", "REVOKE", "RIGHT", "ROLE",
  "ROLLBACK", "ROW", "ROWS", "RULE", "SAVEPOINT", "SCHEMA", "SCROLL",
  "SEARCH", "SECOND_P", "SECURITY", "SELECT", "SEQUENCE", "SEQUENCES",
  "SERIALIZABLE", "SERVER", "SESSION", "SESSION_USER", "SET", "SETOF",
  "SHARE", "SHOW", "SIMILAR", "SIMPLE", "SMALLINT", "SNAPSHOT", "SOME",
  "STABLE", "STANDALONE_P", "START", "STATEMENT", "STATISTICS", "STDIN",
  "STDOUT", "STORAGE", "STRICT_P", "STRIP_P", "SUBSTRING", "SYMMETRIC",
  "SYSID", "SYSTEM_P", "TABLE", "TABLES", "TABLESPACE", "TEMP", "TEMPLATE",
  "TEMPORARY", "TEXT_P", "THEN", "TIME", "TIMESTAMP", "TO", "TRAILING",
  "TRANSACTION", "TREAT", "TRIGGER", "TRIM", "TRUE_P", "TRUNCATE",
  "TRUSTED", "TYPE_P", "TYPES_P", "UNBOUNDED", "UNCOMMITTED",
  "UNENCRYPTED", "UNION", "UNIQUE", "UNKNOWN", "UNLISTEN", "UNLOGGED",
  "UNTIL", "UPDATE", "USER", "USING", "VACUUM", "VALID", "VALIDATE",
  "VALIDATOR", "VALUE_P", "VALUES", "VARCHAR", "VARIADIC", "VARYING",
  "VERBOSE", "VERSION_P", "VIEW", "VOLATILE", "WHEN", "WHERE",
  "WHITESPACE_P", "WINDOW", "WITH", "WITHOUT", "WORK", "WRAPPER", "WRITE",
  "XML_P", "XMLATTRIBUTES", "XMLCONCAT", "XMLELEMENT", "XMLEXISTS",
  "XMLFOREST", "XMLPARSE", "XMLPI", "XMLROOT", "XMLSERIALIZE", "YEAR_P",
  "YES_P", "ZONE", "NULLS_FIRST", "NULLS_LAST", "WITH_TIME", "'='", "'<'",
  "'>'", "POSTFIXOP", "'+'", "'-'", "'*'", "'/'", "'%'", "'^'", "UMINUS",
  "'['", "']'", "'('", "')'", "'.'", "','", "';'", "':'", "'{'", "'}'",
  "$accept", "prog", "stmt", "CreateRoleStmt", "opt_with", "OptRoleList",
  "AlterOptRoleList", "AlterOptRoleElem", "CreateOptRoleElem",
  "CreateUserStmt", "AlterRoleStmt", "opt_in_database", "AlterRoleSetStmt",
  "AlterUserStmt", "AlterUserSetStmt", "DropRoleStmt", "DropUserStmt",
  "CreateGroupStmt", "AlterGroupStmt", "add_drop", "DropGroupStmt",
  "CreateSchemaStmt", "OptSchemaName", "OptSchemaEltList", "schema_stmt",
  "VariableSetStmt", "set_rest", "set_rest_more", "var_name", "var_list",
  "var_value", "iso_level", "opt_boolean_or_string", "zone_value",
  "opt_encoding", "NonReservedWord_or_Sconst", "VariableResetStmt",
  "SetResetClause", "FunctionSetResetClause", "VariableShowStmt",
  "ConstraintsSetStmt", "constraints_set_list", "constraints_set_mode",
  "CheckPointStmt", "DiscardStmt", "AlterTableStmt", "alter_table_cmds",
  "alter_table_cmd", "alter_column_default", "opt_drop_behavior",
  "opt_collate_clause", "alter_using", "reloptions", "opt_reloptions",
  "reloption_list", "reloption_elem", "AlterCompositeTypeStmt",
  "alter_type_cmds", "alter_type_cmd", "ClosePortalStmt", "CopyStmt",
  "copy_from", "opt_program", "copy_file_name", "copy_options",
  "copy_opt_list", "copy_opt_item", "opt_binary", "opt_oids",
  "copy_delimiter", "opt_using", "copy_generic_opt_list",
  "copy_generic_opt_elem", "copy_generic_opt_arg",
  "copy_generic_opt_arg_list", "copy_generic_opt_arg_list_item",
  "CreateStmt", "OptTemp", "OptTableElementList",
  "OptTypedTableElementList", "TableElementList", "TypedTableElementList",
  "TableElement", "TypedTableElement", "columnDef", "columnOptions",
  "ColQualList", "ColConstraint", "ColConstraintElem", "ConstraintAttr",
  "TableLikeClause", "TableLikeOptionList", "TableLikeOption",
  "TableConstraint", "ConstraintElem", "opt_no_inherit", "opt_column_list",
  "columnList", "columnElem", "key_match", "ExclusionConstraintList",
  "ExclusionConstraintElem", "ExclusionWhereClause", "key_actions",
  "key_update", "key_delete", "key_action", "OptInherit", "OptWith",
  "OnCommitOption", "OptTableSpace", "OptConsTableSpace", "ExistingIndex",
  "create_as_target", "opt_with_data", "CreateMatViewStmt",
  "create_mv_target", "OptNoLog", "RefreshMatViewStmt", "CreateSeqStmt",
  "AlterSeqStmt", "OptSeqOptList", "SeqOptList", "SeqOptElem", "opt_by",
  "NumericOnly", "NumericOnly_list", "CreatePLangStmt", "opt_trusted",
  "handler_name", "opt_inline_handler", "validator_clause",
  "opt_validator", "DropPLangStmt", "opt_procedural",
  "CreateTableSpaceStmt", "OptTableSpaceOwner", "DropTableSpaceStmt",
  "CreateExtensionStmt", "create_extension_opt_list",
  "create_extension_opt_item", "AlterExtensionStmt",
  "alter_extension_opt_list", "alter_extension_opt_item",
  "AlterExtensionContentsStmt", "CreateFdwStmt", "fdw_option",
  "fdw_options", "opt_fdw_options", "DropFdwStmt", "AlterFdwStmt",
  "create_generic_options", "generic_option_list", "alter_generic_options",
  "alter_generic_option_list", "alter_generic_option_elem",
  "generic_option_elem", "generic_option_name", "generic_option_arg",
  "CreateForeignServerStmt", "opt_type", "foreign_server_version",
  "opt_foreign_server_version", "DropForeignServerStmt",
  "AlterForeignServerStmt", "CreateForeignTableStmt",
  "AlterForeignTableStmt", "CreateUserMappingStmt", "auth_ident",
  "DropUserMappingStmt", "AlterUserMappingStmt", "CreateTrigStmt",
  "TriggerActionTime", "TriggerEvents", "TriggerOneEvent",
  "TriggerForSpec", "TriggerForOptEach", "TriggerForType", "TriggerWhen",
  "TriggerFuncArgs", "TriggerFuncArg", "OptConstrFromTable",
  "ConstraintAttributeSpec", "ConstraintAttributeElem", "DropTrigStmt",
  "CreateEventTrigStmt", "event_trigger_when_list",
  "event_trigger_when_item", "event_trigger_value_list",
  "AlterEventTrigStmt", "enable_trigger", "CreateAssertStmt",
  "DropAssertStmt", "DefineStmt", "definition", "def_list", "def_elem",
  "def_arg", "aggr_args", "old_aggr_definition", "old_aggr_list",
  "old_aggr_elem", "opt_enum_val_list", "enum_val_list", "AlterEnumStmt",
  "opt_if_not_exists", "CreateOpClassStmt", "opclass_item_list",
  "opclass_item", "opt_default", "opt_opfamily", "opclass_purpose",
  "opt_recheck", "CreateOpFamilyStmt", "AlterOpFamilyStmt",
  "opclass_drop_list", "opclass_drop", "DropOpClassStmt",
  "DropOpFamilyStmt", "DropOwnedStmt", "ReassignOwnedStmt", "DropStmt",
  "drop_type", "any_name_list", "any_name", "attrs", "TruncateStmt",
  "opt_restart_seqs", "CommentStmt", "comment_type", "comment_text",
  "SecLabelStmt", "opt_provider", "security_label_type", "security_label",
  "FetchStmt", "fetch_args", "from_in", "opt_from_in", "GrantStmt",
  "RevokeStmt", "privileges", "privilege_list", "privilege",
  "privilege_target", "grantee_list", "grantee", "opt_grant_grant_option",
  "function_with_argtypes_list", "function_with_argtypes", "GrantRoleStmt",
  "RevokeRoleStmt", "opt_grant_admin_option", "opt_granted_by",
  "AlterDefaultPrivilegesStmt", "DefACLOptionList", "DefACLOption",
  "DefACLAction", "defacl_privilege_target", "IndexStmt", "opt_unique",
  "opt_concurrently", "opt_index_name", "access_method_clause",
  "index_params", "index_elem", "opt_collate", "opt_class", "opt_asc_desc",
  "opt_nulls_order", "CreateFunctionStmt", "opt_or_replace", "func_args",
  "func_args_list", "func_args_with_defaults",
  "func_args_with_defaults_list", "func_arg", "arg_class", "param_name",
  "func_return", "func_type", "func_arg_with_default",
  "createfunc_opt_list", "common_func_opt_item", "createfunc_opt_item",
  "func_as", "opt_definition", "table_func_column",
  "table_func_column_list", "AlterFunctionStmt", "alterfunc_opt_list",
  "opt_restrict", "RemoveFuncStmt", "RemoveAggrStmt", "RemoveOperStmt",
  "oper_argtypes", "any_operator", "DoStmt", "dostmt_opt_list",
  "dostmt_opt_item", "CreateCastStmt", "cast_context", "DropCastStmt",
  "opt_if_exists", "ReindexStmt", "reindex_type", "opt_force",
  "RenameStmt", "opt_column", "opt_set_data", "AlterObjectSchemaStmt",
  "AlterOwnerStmt", "RuleStmt", "RuleActionList", "RuleActionMulti",
  "RuleActionStmt", "RuleActionStmtOrEmpty", "event", "opt_instead",
  "DropRuleStmt", "NotifyStmt", "notify_payload", "ListenStmt",
  "UnlistenStmt", "TransactionStmt", "opt_transaction",
  "transaction_mode_item", "transaction_mode_list",
  "transaction_mode_list_or_empty", "ViewStmt", "opt_check_option",
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item",
  "opt_equal", "AlterDatabaseStmt", "AlterDatabaseSetStmt",
  "alterdb_opt_list", "alterdb_opt_item", "DropdbStmt", "CreateDomainStmt",
  "AlterDomainStmt", "opt_as", "AlterTSDictionaryStmt",
  "AlterTSConfigurationStmt", "CreateConversionStmt", "ClusterStmt",
  "cluster_index_specification", "VacuumStmt", "vacuum_option_list",
  "vacuum_option_elem", "AnalyzeStmt", "analyze_keyword", "opt_verbose",
  "opt_full", "opt_freeze", "opt_name_list", "ExplainStmt",
  "ExplainableStmt", "explain_option_list", "explain_option_elem",
  "explain_option_name", "explain_option_arg", "PrepareStmt",
  "prep_type_clause", "PreparableStmt", "ExecuteStmt",
  "execute_param_clause", "InsertStmt", "insert_rest",
  "insert_column_list", "insert_column_item", "returning_clause",
  "DeleteStmt", "using_clause", "LockStmt", "opt_lock", "lock_type",
  "opt_nowait", "UpdateStmt", "set_clause_list", "set_clause",
  "single_set_clause", "multiple_set_clause", "set_target",
  "set_target_list", "DeclareCursorStmt", "cursor_name", "cursor_options",
  "opt_hold", "SelectStmt", "select_with_parens", "select_no_parens",
  "select_clause", "simple_select", "with_clause", "cte_list",
  "common_table_expr", "opt_with_clause", "into_clause",
  "OptTempTableName", "opt_table", "opt_all", "opt_distinct",
  "opt_sort_clause", "sort_clause", "sortby_list", "sortby",
  "select_limit", "opt_select_limit", "limit_clause", "offset_clause",
  "select_limit_value", "select_offset_value", "select_fetch_first_value",
  "I_or_F_const", "row_or_rows", "first_or_next", "group_clause",
  "having_clause", "for_locking_clause", "opt_for_locking_clause",
  "for_locking_items", "for_locking_item", "for_locking_strength",
  "locked_rels_list", "values_clause", "from_clause", "from_list",
  "table_ref", "joined_table", "alias_clause", "opt_alias_clause",
  "func_alias_clause", "join_type", "join_outer", "join_qual",
  "relation_expr", "relation_expr_list", "relation_expr_opt_alias",
  "func_table", "where_clause", "where_or_current_clause",
  "OptTableFuncElementList", "TableFuncElementList", "TableFuncElement",
  "Typename", "opt_array_bounds", "SimpleTypename", "ConstTypename",
  "GenericType", "opt_type_modifiers", "Numeric", "opt_float", "Bit",
  "ConstBit", "BitWithLength", "BitWithoutLength", "Character",
  "ConstCharacter", "CharacterWithLength", "CharacterWithoutLength",
  "character", "opt_varying", "opt_charset", "ConstDatetime",
  "ConstInterval", "opt_timezone", "opt_interval", "interval_second",
  "a_expr", "b_expr", "c_expr", "func_expr", "xml_root_version",
  "opt_xml_root_standalone", "xml_attributes", "xml_attribute_list",
  "xml_attribute_el", "document_or_content", "xml_whitespace_option",
  "xmlexists_argument", "window_clause", "window_definition_list",
  "window_definition", "over_clause", "window_specification",
  "opt_existing_window_name", "opt_partition_clause", "opt_frame_clause",
  "frame_extent", "frame_bound", "row", "sub_type", "all_Op", "MathOp",
  "qual_Op", "qual_all_Op", "subquery_Op", "expr_list", "func_arg_list",
  "func_arg_expr", "type_list", "array_expr", "array_expr_list",
  "extract_list", "extract_arg", "overlay_list", "overlay_placing",
  "position_list", "substr_list", "substr_from", "substr_for", "trim_list",
  "in_expr", "case_expr", "when_clause_list", "when_clause",
  "case_default", "case_arg", "columnref", "indirection_el", "indirection",
  "opt_indirection", "opt_asymmetric", "ctext_expr", "ctext_expr_list",
  "ctext_row", "target_list", "target_el", "qualified_name_list",
  "qualified_name", "name_list", "name", "database_name", "access_method",
  "attr_name", "index_name", "file_name", "func_name", "AexprConst",
  "Iconst", "RoleId", "role_list", "SignedIconst", "NonReservedWord",
  "unreserved_keyword", "col_name_keyword", "type_func_name_keyword",
  "reserved_keyword", "statements", "statement", "CreateAsStmt", "$@1",
  "at", "ECPGConnect", "connection_target", "opt_database_name",
  "db_prefix", "server", "opt_server", "server_name", "opt_port",
  "opt_connection_name", "opt_user", "ora_user", "user_name",
  "char_variable", "opt_options", "connect_options", "opt_opt_value",
  "prepared_name", "ECPGCursorStmt", "ECPGExecuteImmediateStmt",
  "ECPGVarDeclaration", "single_vt_declaration", "precision", "opt_scale",
  "ecpg_interval", "ECPGDeclaration", "$@2", "sql_startdeclare",
  "sql_enddeclare", "var_type_declarations", "vt_declarations",
  "variable_declarations", "type_declaration", "$@3", "var_declaration",
  "$@4", "$@5", "opt_bit_field", "storage_declaration", "storage_clause",
  "storage_modifier", "var_type", "enum_type", "enum_definition",
  "struct_union_type_with_symbol", "$@6", "struct_union_type", "$@7",
  "s_struct_union_symbol", "s_struct_union", "simple_type",
  "unsigned_type", "signed_type", "opt_signed", "variable_list",
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare",
  "ECPGDisconnect", "dis_name", "connection_object", "execstring",
  "ECPGFree", "ECPGOpen", "opt_ecpg_using", "ecpg_using",
  "using_descriptor", "into_descriptor", "into_sqlda", "using_list",
  "UsingValue", "UsingConst", "ECPGDescribe", "opt_output",
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader",
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem",
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems",
  "ECPGSetDescHeaderItem", "IntConstVar", "desc_header_item",
  "ECPGGetDescriptor", "ECPGGetDescItems", "ECPGGetDescItem",
  "ECPGSetDescriptor", "ECPGSetDescItems", "ECPGSetDescItem",
  "AllConstVar", "descriptor_item", "ECPGSetAutocommit", "on_off",
  "ECPGSetConnection", "ECPGTypedef", "$@8", "opt_reference", "ECPGVar",
  "$@9", "ECPGWhenever", "action", "ECPGKeywords", "ECPGKeywords_vanames",
  "ECPGKeywords_rest", "ECPGTypeName", "symbol", "ECPGColId", "ColId",
  "type_function_name", "ColLabel", "ECPGColLabel", "ECPGColLabelCommon",
  "ECPGCKeywords", "all_unreserved_keyword", "ECPGunreserved_interval",
  "into_list", "ecpgstart", "c_args", "coutputvariable", "civarind",
  "char_civar", "civar", "indicator", "cvariable", "ecpg_param",
  "ecpg_bconst", "ecpg_fconst", "ecpg_sconst", "ecpg_xconst", "ecpg_ident",
  "quoted_ident_stringvar", "c_stuff_item", "c_stuff", "c_list", "c_term",
  "c_thing", "c_anything", "DeallocateStmt", "Iresult", "execute_rest",
  "ecpg_into", "opt_ecpg_into", "ecpg_fetch_into", "opt_ecpg_fetch_into", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,    61,    60,    62,   750,    43,
      45,    42,    47,    37,    94,   751,    91,    93,    40,    41,
      46,    44,    59,    58,   123,   125
};
# endif

#define YYPACT_NINF -4452

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-4452)))

#define YYTABLE_NINF -2639

#define yytable_value_is_error(Yytable_value) \
  (!!((Yytable_value) == (-2639)))

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const int yypact[] =
{
   -4452,   386, 14273, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, 25834, -4452,
   -4452, -4452, -4452, -4452, 98975,   922, -4452, -4452, -4452,103863,
   -4452, -4452, -4452,   453, 67385, -4452, 70301,  1155, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, 73703, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, 56681,  1298, -4452,
     855, -4452, -4452, -4452, -4452, -4452, -4452, -4452,   447, 14213,
   -4452, -4452, 70787, -4452,    81, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, 71273,   492, -4452, -4452,   856,  1215, -4452,   100,
   13656, -4452, -4452, 63983, 68357, -4452, -4452, 74189,   303,  2209,
   13145,   447, 25345, 74675, -4452,  2356, -4452, 53237, -4452, -4452,
   -4452, 67871, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, 81479,  2560,  1038, 53732, -4452, -4452,
   -4452, -4452, 81479, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, 75161, -4452,  1140,  1225,   954, 81965, 82451,
   65441, -4452,  1257, -4452, 81479,  1275,  1094, 55707, -4452, 82937,
   -4452, -4452,  1102, -4452, 75647, -4452, -4452, -4452, -4452,  1038,
   -4452, 56681, 52263,     7,  1149, -4452, -4452, 83423, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452,  1285,  1098, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452,   492, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452,   512, -4452,  1337,  1120,  1685,   631,  1371, -4452,
   -4452, -4452, 12235, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
  100424,  2033, -4452, -4452, -4452,  1412, -4452,  1352, -4452, -4452,
   -4452,  1648, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,   602,
   -4452, -4452, -4452, -4452,  1867, 99458, 73703, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, 63497, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
     181, -4452, -4452, -4452, -4452, -4452, 73703, 73703, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, 73703,  1516, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452,   824,  1717, -4452, -4452,
   56681,  2096,  2096,  1980,100424, -4452, -4452, -4452, 57655, 81479,
   81479, 81479,  1681, 81479,  1617, 81479,   504, 57655,108046, 83909,
    1757,  1660, 47795, -4452,106792, 81479, 81479, 84395, 81479, 76133,
   81479,  1805, 81479, 81479,107210, 84881,  1907, -4452,  2114,  1433,
   -4452, -4452, -4452, 81479, 11009,  2560, -4452, -4452, 81479,  1770,
   57655, 81479,  1808, 81479,  1777, 81479, -4452, 81479,  1819, 85367,
     579,  1920,108046,  1957, 48294,  1986,108046, 85853, 81479, 81479,
   -4452, -4452,  1966, 81479, 81479, -4452,  2086,108464,  1497,  2109,
    2236,  2124,   876, -4452, -4452,  2325,  1887, -4452, -4452,  2342,
   73703, -4452, 71759, -4452, -4452, -4452,  2159, -4452, -4452, -4452,
   -4452, -4452,105120,  2209, -4452, -4452, 58142, 81479,  2175, -4452,
   -4452, 86339, -4452,  1996, -4452,   616, 58629,108882,  2317,  2005,
   48793,  2362,109300, 86825, -4452, -4452, 87311, -4452, 87797,  2091,
   88283, -4452,109718, -4452,  2233, 88769, -4452, 21601, -4452,  1979,
    2034,  2032,  1693, 73703, 73703,  1879,101743, -4452, -4452,   492,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,   257,  1873,
   54227,   827, 54722, -4452, -4452,   835,   895,   907,   257,  2427,
    2427,    40, 73703, -4452, -4452,  1873, -4452,   701,   -43,  2035,
    2035,  2035,  2199,   737, -4452,  2035, -4452, -4452, -4452, -4452,
   75647, 54227, 54722, -4452,  2048,  2560,   180,  2421,  2094, 81479,
   -4452, 81479, -4452, 81479, 81479, -4452, -4452, -4452,  2464,  2100,
    2313, -4452,  2077, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
    2266,  2280,  2293,    -9,  2560,  2194, -4452,  2409, -4452,  2332,
   30887,   -67, 73703,  2560, 55217, 76619, 96545,   275,105120,  2560,
   89255,  2173,  1605,  2312, -4452, -4452,   446, -4452,  2554,  2183,
    2407,   496,  1433, 45336, -4452,  2206,  1221, 75647,100907, -4452,
   -4452, -4452, -4452,   315,  2476, 31391, -4452, 81479,  2211, -4452,
    2220,  2229,  2245,  1685, -4452, 81479,  1289,  1289,  2585,  1289,
    1918,  2132, -4452,  2331, -4452,  2547,  2514, 75647,  1149,   447,
    2279, -4452, -4452, -4452,  2305, -4452,  2271,  2299, -4452,   844,
    2551, -4452, -4452, -4452, -4452,  2383,  2389,  2400,  2401,  2345,
    2422,   222, -4452, -4452, -4452, -4452,  2658, -4452, -4452, -4452,
   -4452, -4452, -4452,  2754,  2744,104284,104284,   481,   705,   140,
     239, -4452, -4452, -4452,  2607, -4452, -4452,  2615, 81479,  2441,
   81479, -4452, -4452, -4452, 89741, -4452, -4452,  2096,  2305,  2368,
   -4452,   190, -4452,  1221, -4452,   286,   307,   348,  1395,  2379,
    1666,  1898, -4452,   184, 81479,  2479,   116,   -42,  2416, 77105,
    5353,  2392,   175,  2693,  3549,   222, 90227, -4452, 81479, 81479,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,  2405,
   -4452, -4452,  2406,  2674,  1400,  2600,  1597,  2719,  8065,  1614,
    2720,  4577,  1929,   641,  2620,   780,  2674,  2722,  1488,  2737,
    5284, 81479,  2444, -4452,  2677,  2813,   754, -4452,   188, -4452,
    2579,  2690,   961, 57655,  2495, -4452, -4452, 81479, -4452, -4452,
   -4452,  2625, -4452,   622, 57655, -4452,  2723,  2635, 49292, -4452,
   81479, -4452, -4452, -4452, -4452, -4452,  2681, 81479, -4452, -4452,
    2793, 81479, -4452,  2035,  2721,  2580,  2967, 61064,   228, 81479,
    2650,  3019, 81479,  2822,  2650,  2660, 90713, -4452, -4452,  2650,
   -4452, -4452, 81479, 81479,  2632,  1620,  2650,  2829,  3027,  3028,
    2701,  2806,   818,  1533,    98,  2923,  2650,  2679, 81479, 91199,
   81479,  2680, 81479,  2999, 57655, 81479, -4452,  2794, 77591, -4452,
    2638,  2325, -4452, -4452, -4452, -4452, -4452,  1035, -4452, -4452,
   -4452, -4452,  2940,  2368,   153,  2941,  2646,  2943, -4452, -4452,
    2682, -4452,  2946,  2392,  2948, -4452,  2652, 91685, -4452, 92171,
   92657,  2953,  2405,108046,  2954,  2652,  2955,  2838,  2956,   153,
    2958, -4452,   893,  2960,  2847,  2962,  1884,  2652,105538,  2964,
      82, -4452, 22558, 21601, -4452, 26874,  1739, -4452, -4452, -4452,
   -4452, -4452, -4452, 34919,   823,  2755, -4452, -4452, -4452,  1926,
   -4452,103016, -4452,  1879,  1873, -4452, 73703,  1873, 73703,    40,
    1873, 73703,  1873, 73703,    40,  1873, 73703, 73703, 73703,  1873,
   -4452, -4452,  1990,  2038, -4452, -4452, -4452, -4452, -4452, 73703,
    2676, 81479, 81479, -4452, -4452, -4452, 68843,108046, 69329, -4452,
   -4452,    30, 73703, -4452, 73703, -4452,  2560, -4452, -4452,  2034,
   61064,  3077,108046, 81479,  2966,  2966,  2966, -4452, -4452, -4452,
    2903, 81479,  2968,  2969, 68843,108046, -4452, 93143,105120,  2868,
    2687, -4452, -4452, -4452, -4452,  1941,  2606,   358,  2773, 34919,
    2689,   174,   174,  2691,  2975, -4452, -4452, -4452,   376,  2698,
    2699, -4452,   443,   443,  2859,  2703,  2707, -4452,   451,  2708,
   -4452,  2810,   489,  2710,  2711,  2712,  2319,   174, 34919, -4452,
    2716,   443,  2717,  2724,  2725,  2852,  2726, -4452,  2866,  2727,
     211,   318,  2728,  2729, -4452,  2703, -4452,   434,  2732,  2735,
    2736,  2738,  2739,  2741,  2748,  2756, 34919, 34919, -4452, 29879,
    1221,  2560, -4452, -4452, -4452, -4452, -4452, -4452, -4452,    78,
   -4452,   505,  6010, -4452, -4452,  2873, 34919, -4452, -4452,   411,
   -4452,   522, -4452, -4452,  1221, -4452, -4452,  1370, -4452, -4452,
   -4452, -4452,  1999,  1999,   193, -4452, 70787, 70787, -4452, -4452,
    1503,  2715, -4452,  1766, -4452, -4452, -4452, -4452, -4452, -4452,
  104702,  3120, -4452,  2526,  2560,   188,  1535,  3066,102164,102590,
    2978,  2978,  2980, -4452, -4452, 81479, -4452, -4452, 34919, 51289,
   -4452,  1221,    84,  2983, -4452, -4452, -4452,  1961, -4452, -4452,
   -4452,   492, -4452, 12705, -4452,  1992,  2211, 81479, 81479,  3155,
   -4452, -4452,  2220, -4452, -4452,  1685,  1685, 34919,  1685,  1078,
    1749, 31895, 35423,  3043,  2947,  1156,  1527,  3047, -4452,  2951,
    1918,  2132, 75647, 81479, 93629,  2874, -4452, -4452,  2305,  2775,
    2017, -4452, 63011, 99941, 99941,  3011, -4452, -4452,   901,  1099,
    2885,  2976,  2427,  1378,  2093,  2093, -4452, -4452,  2768, -4452,
    3104, 70787,  2830,104284, -4452, -4452, 81479, -4452, -4452, 78077,
   -4452, -4452, -4452,  2085,  2776, -4452,  2789, 81479,  3272, -4452,
    2093,  2093, -4452, -4452,  2777, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452,100424,  2781, 81479, -4452,  2783,  2785, -4452,
  100907, 51776,  1724,  1221,  2862,  2863,  2909, 56681,  2796,  2865,
    2869,  2915,  2875,  2876, 97031, -4452, -4452, -4452, -4452,  1507,
     124,  1031,  2877,   177,   836,  3154, -4452,  1478,  2919, -4452,
   -4452, -4452,  2780, 81479,  3100,  5652,  2987,   222,  2925, -4452,
   -4452,  3034,  2887,  2888,  3002,   222,  1439, 97517, -4452, -4452,
   -4452, -4452, -4452, -4452,  4377, 28393, -4452,  2892,  2872, 81479,
   64469,  3183,  3003,  1017,  1201,   341, 81479,  3079,  3008, 81479,
    2825,  2901,  2902,  2831,  2031,  3185,  2832, -4452, -4452,  3005,
    3130,  6382,  2890,  2891, 60090,   801, 49791,  3174,  1723,  2916,
   -4452,  1723, 81479,  2917,  2924, 81479,   222, -4452,  3224,   222,
     222,  2064,  3234,  2926,   161,  1771,  2650,  2832,  2283, -4452,
    2927,  2928,  1754, -4452,  3033, 75647,   191,  2003,  2832,  2930,
    2935,  2831,  2831, 81479, 81479, 81479, 81479, 81479,   141,  3260,
    3261,  2942,   114,  2988,  2870, -4452,  1723,105956,  2949, -4452,
    1723, 81479,  2961,  2006,  2832,  1689, -4452,  1788, -4452, -4452,
   -4452,  1433, -4452, 81479, -4452, 81479,  2368, 61064,  3054, -4452,
    2912, -4452,  2392,   222, -4452, 81479, 81479,  2405,    85,   944,
    3060, 81479,  3121,  2922, -4452,   843, 51776,  2632, -4452,  2893,
   -4452,  2934, -4452,  2934,  2934,  2896,  2896,  2898, -4452, -4452,
    2319,  2934,  2896, -4452, 62038, -4452,  1579,  1844, -4452,  3292,
    3301, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
     990, -4452,  2012, -4452, -4452, -4452, 81479, 56681, -4452,  3312,
   -4452, -4452, 61064,  3084,  3199, -4452, 81479,  3103,  2904, -4452,
    3236,  2963, -4452, -4452,  1008, -4452,  3205,108046,  1096,  2560,
    2957, 81479,  3133, 81479, 81479, 81479, 81479, -4452, -4452,  3108,
     538,    54, -4452,105956, -4452, 81479,  2283,  3119,  3324,   -32,
    2035, 81479,  3214, -4452, 81479,  2931,  3330,  3165, -4452, -4452,
    2950,  2427, -4452,  2638, -4452,  2078, -4452,  3051, -4452, 57655,
     153, -4452, -4452, -4452, -4452, 61064, 81479, 94115, 57655,   153,
  108046,108046,  3233,    82,  3238,  3009,  3246,  3010, 49791,   153,
     110,108046, 81479, 81479, 81479, -4452, 81479, -4452, -4452, -4452,
   -4452, 81479, 81479,108046,105956,  3247,  3249,   153, 81479, 81479,
   -4452, -4452, 26786,  1863, -4452, 21601, -4452, 12705,  2023,  2978,
   -4452,  1516, 81479,  1276,  1879,106374, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, 73703, -4452, 73703,    40, -4452, -4452,
   73703, -4452, 73703,    40, -4452, 73703, -4452, -4452, -4452, 73703,
   81479,  3450,  2965, -4452,  1370, -4452, 81479,  2104, -4452, -4452,
    2150,   791, 81479, 81479,   531, 57655, 81479,  3146, 81479, 81479,
   81479, 81479, 81479,  3037,  2715,   696, -4452,   524, 75647,  3156,
   -4452, -4452, -4452, -4452, -4452,  2161,  1285,   875,  3000, -4452,
   -4452, -4452, -4452, -4452, -4452, 69329, 67871,  3245,    94, 81479,
   -4452, -4452,  3994, 34919, 30383, -4452, -4452, -4452,  2971, 12705,
    3012, 34919, -4452, -4452, 34919,  2973,  2427,  2427, 34919, -4452,
   -4452, -4452, -4452,  1870,  2427, -4452, 34919, 34919,  2427,  2427,
    2934,  2934, -4452,  4998, 34919, -4452, 49791, 34919, 36935, 27888,
   34919,  3052,  2984,  2427, -4452,  2427, -4452, 34919, 29375, -4452,
   34919,  3179, 38447, 34919,  1535,  3181, 34919,  1535,  3398,  3398,
    1149,  2120,  6433,  2979,  1221, -4452,  3088,  2427, -4452,  2427,
    1003,   225, 61064, 34919, 56681,  3059,   147, 81479, 34919,  2985,
    1801, -4452, 34919,  1355, -4452,  2986, 34919,  3058, 34919, 34919,
   34919, 34919, 34919, 34919, 34919, 34919, 34919, -4452, 39427,   311,
   -4452,   454,   984, 69815, 30887,  3267, -4452, 27383, -4452,   263,
   73703, -4452, -4452,  1221, -4452, -4452, -4452, -4452, -4452,  2085,
    2990, -4452,  3001, -4452, -4452, -4452, -4452, -4452, 81479,  3120,
   -4452, -4452,  3062, -4452, -4452, -4452, -4452,   551, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452,  2991, -4452, -4452, -4452,
   -4452,  2991, -4452, -4452,  2978,  2994,  5454, -4452, -4452, -4452,
   -4452,  3257,  3263,   153,100424, 81479,   315, 72245, -4452, 31391,
   -4452,  2202, -4452,  2998, -4452,  3243, -4452,  3004, -4452,  8829,
    3243, -4452, -4452, 37439,  3106,  3237,  3184, -4452, -4452, -4452,
    3006, 12705, 34919, 34919, -4452,  2187, 12705,  2300, -4452, -4452,
   -4452, -4452, -4452, -4452,   987, -4452, 81479,  3156,  3043,  1527,
    3057,   251, 81479, -4452, 45826,  2141, -4452,  2305, -4452, -4452,
   24474, -4452, 26317, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452,  3013, -4452, -4452, -4452, -4452, -4452,   222,  3014,
    3484, -4452,104284, -4452, -4452, -4452,  3450, -4452,  2342, -4452,
    2342,  3510, -4452, 73703, -4452, -4452, -4452, -4452,   871, -4452,
   21601, -4452, 21601, -4452,  3015,  2261,  3087,  3091,  3138,108046,
   81479, 81479, -4452, 56681,108046, 81479, 81479,108046, 81479, 81479,
   -4452,  3376,   448, 67871,  3141, 65927, -4452, -4452,  3025, 81479,
    3080,  3265,  3268,  1401, -4452, -4452, 94601, -4452,  3225,108046,
   81479, 81479, 34919,  3241, 81479, 81479, -4452,   256,  3125,  3126,
   -4452, 81479,  3127, 57655,  3045, 81479, 81479, 81479,  3117,   646,
   57655,  3095, 50290, 81479, 81479, 81479, 81479,  3175, 81479, 81479,
    3290,  1304, 75647,   109,  2049,  2832,  3250, -4452,  1452, -4452,
  108046, 81479,  3242, -4452, -4452, -4452, 66413,  3455,  3163, -4452,
   -4452, 98003, -4452, -4452,  3239, -4452, -4452, 62038, -4452, -4452,
    2267, -4452, 61551, 59116, -4452, -4452,   760,108046,108046,  6694,
   81479,  1435, -4452, -4452, 61064, -4452, 81479, 81479, 81479, 72731,
   95087, 95573,  1128,  1362, 81479, 73217, -4452, 81479, -4452, -4452,
   57168,108046, 81479, 56681, -4452, 81479,  3251,   948, -4452, 81479,
    4257,  3140, 81479,   119,  2148,  2832, 81479, 81479,  3067,  2273,
    3145,  3191, -4452, 81479, 96545, -4452,108046,  1468, -4452,  3210,
  108046, 81479,  9324, -4452, -4452,   222, -4452, -4452, -4452, -4452,
   -4452, 81479, 81479,   222, 81479,   222,  1396, -4452,108046, 81479,
   -4452, -4452, -4452,  6808, 81479, 81479, 81479, 81479,108046, 81479,
   -4452, -4452,  1050,  1266,     3,  1131,  3211, 81479,  3341, 81479,
   96059,108046, 81479, 81479, 81479,   781, -4452, -4452, -4452,  3187,
   -4452,108046,  1468, -4452,  7299, 81479, 81479,  3152,  3157,   146,
    3227, -4452, -4452, -4452, -4452, -4452, -4452,  3320,  3485, 81479,
   -4452,  3325,  3327,  3143,  3148,  3328,  1823, 81479, -4452, -4452,
   -4452, -4452, 81479,  3336,  1823,  3281,    56, -4452, -4452,  2650,
   -4452,  2288, -4452,  3113, -4452, 34919,  3504, 61064,  3109,  3111,
    3178, -4452,  3180,  2427, -4452,  2039, -4452, -4452,  2296, -4452,
    3123,   538,  1850, -4452, 56681, 81479,   743,   660,  3410, 64955,
    2192,  3400, 81479,  3158, 81479,  2192, 81479, -4452,  1420, 67871,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,  3399,
   -4452,  2560,  2632,  2632,  2632,  2632, -4452, -4452, -4452, -4452,
    3303,  1982, -4452,  3122,  2632, 81479,  3229,  2192,  3124, -4452,
    2283,  3416,  3422, 81479, 64955,  2219,  3161,  3529,  2035,  2560,
    3314, -4452, 28884,  4616,  3319,105120, 77591, -4452,  3144,  3407,
    3408,  3426, -4452,  2368, -4452,  3543, -4452,  3440,   153,  2392,
   -4452,  2652, -4452, 81479, -4452, 81479, 81479, 81479, 81479,  2405,
   -4452, -4452,  2652,  3329,   153,   153, -4452,  3333,   153,  2652,
    3255,  3431,105120, -4452,    82, -4452, -4452, -4452, -4452, -4452,
   34919, -4452, -4452, -4452,  2035,  2078, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, 73703,  2342, -4452,
    2315, -4452, 81479, -4452,  3413,  3417,  3418,  3153,  3159,  3190,
   81479,  3160, -4452,  3153,   222,  3153,  2715,  2715,  3153,  3159,
  107628,  3572,  3439,    59, -4452,   598,  1252,  3375, -4452, -4452,
   -4452, -4452, 61064, -4452, -4452, -4452, -4452, -4452, 81479,  1165,
   -4452,   107,  3351,  3167,107628,  3554,   153, -4452, 57655, -4452,
   -4452, -4452,  3244,  3256, 57655,  3360,  3215, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452,  3414, 81479,  2322, -4452,  1791, -4452,
    1892, 34919, 34919,   273, -4452, 10566,  2343, 34919,  3182,  3186,
    2357, -4452, -4452, -4452, -4452, -4452, -4452,  3192,  3460, -4452,
   -4452,  3193,  2370,  2385,  3195,  3196, -4452, -4452,  6271,  3197,
   11235,  3200, 36935, 36935,  1056, -4452, -4452, 36935,  3201, -4452,
    2390,  9454,  3204,  3202,  3203, -4452,  3207,  3208, 10576, 32399,
   34919, 32399, 32399, 11262,  3204,  3209,  2395, 56681,  3350, 11528,
    2403, -4452, 34919, 56681,  6465, 34919, -4452, 34919, 81479,  3212,
    3216, -4452, -4452,  4998, -4452,  3221, -4452, 36935, 36935, -4452,
    2497, 29879, -4452, -4452,  3468, -4452, -4452,  1511, -4452,  3218,
   -4452, -4452,  5046,   215, 34919,  2985, 34919,  3285, 49791,  4060,
   34919,  4302,  2952,  2952,   409,   409,   149,   149,   149,  1760,
     984, -4452, -4452, -4452,  3220,  2726, 34919, -4452,  2490,  2511,
   81479,  5838, 10429, 11730, -4452, -4452, -4452, 40925,  3253, 34919,
   34919, 34919,  3223,  3385,  3643, 12705,   703, -4452,  3645, -4452,
   -4452, -4452,  1485,  3510,  2085, -4452,  1433,  2427,  1003,103016,
   -4452, -4452, -4452, 34919, -4452, -4452, -4452, -4452,  2220, -4452,
   -4452, -4452, -4452, -4452, 81479,  1285, 34919, -4452, -4452,  1024,
    2205,    28,  3415,  2093,  2093,  2187,  3421, -4452, -4452,  3286,
   -4452, 34919, -4452,  2333,  2358, -4452, -4452, -4452, -4452,  2715,
   -4452, -4452, -4452, 40925,  3274,  3289, 44846,  3364, -4452, -4452,
   81479,   199, -4452, -4452, -4452,  3258, -4452, -4452, -4452,  1297,
   -4452, -4452, -4452, -4452, -4452, -4452,  3240, -4452,  3254, -4452,
    3262, -4452, -4452, -4452, -4452,   170,  3264,  3259,  3266,  1644,
   -4452, -4452,108046, 81479, 81479, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452,  3469, -4452,108046,108046,  3429,
   81479,  3435,  3434, 34919,   305, 81479,  3270,  3271,  1504,  3511,
   81479, -4452,  3555,   153, -4452, -4452,  3335, -4452, 12705, -4452,
   -4452, -4452, -4452, -4452,108046, 81479, -4452,105120, -4452,  2368,
   61064, -4452, -4452, -4452, 81479,  3294, 81479, -4452, 81479, 81479,
   81479,  2405, -4452, -4452, -4452, -4452,  1264, -4452, -4452, 81479,
   81479,   576,  3338,  3340, 81479, -4452,   549,  3033,  7393, 81479,
   81479, 81479,  3517, -4452, -4452, -4452, -4452,  3463, -4452, -4452,
    2012, -4452, 59116, 61551, -4452, 61551, -4452,  2012,  1756, -4452,
    2652,  3347,  2832, -4452,  3453,  1707, -4452, -4452, -4452, -4452,
   -4452,  3573,   153,  3574,   153, 81479, 81479, 81479, 81479, -4452,
   -4452, -4452, -4452, -4452, 56681, 56681, 56681,  2454, -4452, -4452,
    2560, -4452, -4452, -4452,  2457, -4452,  1427, -4452, -4452, -4452,
   -4452, -4452, -4452,108046,  8426, 81479, 81479, 81479,  1787, -4452,
    1436, 61064, -4452, 60577,108046, 81479, -4452, -4452,  3497,  3443,
   -4452,  1856,  3445,108046,  3337, -4452, -4452,  3357, -4452, -4452,
    3361,  2191,  2832,  2283, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452,   126,  2201,  2832,  3362, -4452,  3366, -4452, -4452,
   -4452,  3499,  3506,  3508,  3370,  3374,  3430,  3386,  3388,  3436,
   -4452,  3390,  3437,  3393,  3444,  3394,   153, 61064,  3523,  2560,
    3428,  3624,   153, -4452,  3405, -4452, -4452,  3728, -4452, 81479,
   -4452,  3409,  2265,  2832, -4452, -4452,108046, 81479, -4452, -4452,
   -4452,  1823, 61064,  3575,  1823,  1823, 81479, 81479,  1823, -4452,
   -4452, -4452,  3576,  3579,  1823, -4452, -4452, -4452, -4452,  2721,
    3343, -4452,  2159, 47296,  6726,  3346,  3111,  3344,  2427, 43376,
     976,  3552,  3348, -4452, -4452, 56681, 47296,  2050,  3569,  3363,
    3363,  3363,  3363,  3363,  3363,  3363, -4452,  1601,   201,  2650,
  105120, 81479,105120, -4452,   660,  3453, 81479, 81479,  3353,  3349,
   -4452, -4452, -4452, -4452,108046,    63,108046,  2427, -4452, -4452,
    3420, -4452, 81479,  2035,  3750,  3028,  1096,  3492,  1912,  3697,
   -4452, -4452, -4452, -4452, -4452, 81479, 81479,   538,  2560, -4452,
    3365,  3367, -4452, 81479, 81479, 81479, 81479,  1285,  3368,  3371,
   61064,   664,  3548,  3551,  2831,  3773,  1285,  3161,  3448, 81479,
   -4452,  2458,    93, -4452,  2560,105120, 59603, -4452,  3454, -4452,
   -4452,   940,  3646, -4452, 81479, -4452, -4452, 44356,   153, 61064,
   81479, -4452,   153,    82,  3438,   153,  3441,   153,   153, 81479,
   -4452, -4452, 81479, -4452, 81479,105956,   153, -4452, 12705,  3661,
   -4452, -4452, -4452, -4452,  3498,  3500,  3501, 81479,  3153, 57655,
   -4452,  3381,108046,  1490, -4452, -4452,  3557, -4452, -4452, -4452,
   -4452, -4452,  3683,  3688, -4452, -4452, -4452, -4452,  3726,108046,
   68843,   173,108046, -4452,  2368, -4452, -4452,  2392,   222, -4452,
   81479,  3633, -4452, -4452, -4452,  3397,  2461, 11665, 34919, -4452,
    3701, 61064, -4452,  6971, -4452, -4452, -4452, -4452, 34919, -4452,
   -4452, -4452, -4452, -4452, 34919, -4452, 34919,  3680, -4452,  3821,
    3821, 61064, 36935,  1028,  2717, 36935, 36935, 36935, 36935, 36935,
   36935, 36935, 36935, 36935, 39931,  1323, -4452, -4452, 34919, 34919,
    3687,  3680, -4452, -4452,  -102,  -102, 61064,  3402,  3204,  3403,
    3404, 34919, -4452, -4452,  2462, 38937,  3411, 56681, -4452, 34919,
    9986,  2467,  3447, 12661,  1221,  7006, -4452,  3781,  2560, 34919,
    1075,  2230, 34919,  2468, 34919,  3689, -4452, -4452, -4452,  3423,
   -4452, -4452, 61064, 34919, 36935, 36935,  5373, -4452,  7374, 34919,
    3424,  7640, 29879, -4452,  1038,  1038,  1038,  1038, -4452, 81479,
   81479, 81479, 41415, 40435, 78563,  3419,  1710, -4452, 78563, 79049,
   -4452,  3427,  1221, 34919,  3686,   741,   741,  3432,  3385, 46316,
   -4452, 34919,  1505, 32903,  3442, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
    3449, -4452,  3451, -4452, -4452,   188,  3452, -4452, -4452,  8952,
     170, -4452, -4452,  3456, -4452,  3446, -4452,  2205, -4452, -4452,
   -4452, -4452, -4452,  3599, -4452, -4452, -4452,  3419, 33407,  3364,
   -4452,  2472, -4452, -4452, 30887, -4452, -4452,  2473, 45826,  3274,
   31391,  1221,  2427,  3458, -4452,  2342,  1485, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452,  3363,  2652,  2652,  1367,  3153,
    3706,  1367,  7047, -4452, -4452, 41905, 81479, 81479, -4452, 81479,
    2481,  1429, 81479, -4452, 81479, -4452, -4452, -4452, -4452,  3826,
   -4452, 81479, -4452, -4452,  3480,  3481, -4452, 81479, 81479, 81479,
   81479, -4452, -4452,  2379, -4452, -4452,108046, 81479, -4452, -4452,
   -4452,   277,  2278,  2832, -4452,  3509, -4452, -4452,  3681,  1923,
   -4452, -4452, -4452,  3505, 81479,  3459, -4452,   988,  2831,   759,
   -4452, -4452,  3516, 81479, -4452, 81479, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, 57168, -4452, -4452, -4452, 56681,
   47296, 56681, -4452,   319,  2282,  2832, -4452,  3513, -4452,  3515,
    3530,  3577,   809,  1007,  3534,  3536,  3582,  3464,  3466,  3474,
   -4452, -4452,   257,  2560, -4452, -4452,  2560,  2652,  2560, 81479,
   81479, 81479, 81479, 81479, 81479, 81479, 81479,  3721,   908,  1891,
  108046, 81479, 81479,108046, 81479, 81479, 81479, 81479, 81479, 81479,
   81479, -4452,  3820,  3760,  2036,  3811,  3542, 81479, -4452, 81479,
    3033, 81479, 81479, -4452, -4452, -4452,  3477,  1823, -4452, -4452,
    3718,  3719, -4452,  1823,  1823, -4452,   843, 56681, -4452,  3433,
   -4452,  3113,  3446,  2093,  2093, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452,  2427,  2284,  3482, -4452, 43866, -4452, -4452, -4452,
    2262,  1003, -4452, -4452, 81479,  3363, -4452,  2291,  2218,  2639,
    2718, 79535, 80021, 80507,  3483, 81479, 81479, 36935, -4452,  1570,
     128, -4452,  3717, 81479,  3518, -4452, -4452, -4452,  3636, 81479,
   -4452, -4452, -4452, -4452, -4452,  3486, -4452,  3598, 64955,  2652,
  108046,108046,  2652, -4452, 61064,  3489,  3161,108046,  1096,  1357,
   91199,  3521,  3488,  3777, -4452,  3496,  3490, -4452, -4452, 81479,
    3453,  2482,   511,  2032,  3000, 66899,  2219,  3752, -4452, -4452,
   -4452,  3861,  3584, -4452,  1285,  3000,  3584,  2560,  3080, -4452,
   59116, 34919, 34919, -4452,  3502, -4452,  3503,  4797, -4452,  2632,
   -4452, -4452, -4452, -4452, -4452, -4452,  3580, 81479,  3932, -4452,
   -4452, -4452,  3522,   153, -4452, -4452, 81479, -4452, 81479, -4452,
   -4452,   153,   153, -4452,  3620, -4452,  1285, 81479, 81479, 81479,
    3153, -4452,   222, -4452,  3786,107628, -4452, -4452, -4452, -4452,
   -4452,    94,  3792, -4452, -4452,  3753,  3756,  3758,  3763,  1948,
   -4452, -4452, 34919, 12705, -4452,  3524, -4452, 12705,  7476, 12705,
    3687, -4452,   739,  3808, -4452,   994,  3527,   739,   695,   695,
     302,   302,   120,   120,   120,  3821,  1323, 12705, 12705, -4452,
   -4452, -4452, -4452,  3528, -4452, -4452, -4452,  3204, -4452, 35927,
    3673,  3918, -4452, -4452, -4452,  3578,  3586,  3535, -4452, 34919,
   36431,  3537, 62038, -4452, -4452,  1003,  1670, 36935, 36935,  4381,
   -4452,  1213, 34919, 61064,  2493,  4381,  2546,  2758, 34919, 34919,
    9034,   338, 34919,  7676, 81479, 81479, 81479, 81479, -4452, -4452,
   -4452, 78563, 79049, 42885,  1710,  3538, 81479, -4452, -4452,  3544,
   40925,  3774,  3720, -4452, 40925,  3720,  1417,  3720,  3779, -4452,
   46806, -4452, -4452,  3553, 27383,  2138, 12705,  3935,  3824, 34919,
    3559, -4452,  3561,  3385, -4452, 98489, -4452, -4452, 12705, -4452,
   -4452, 34919, -4452,  3385,  1485,  1040,  2560, -4452, -4452, -4452,
   49791, -4452, -4452,  3742, 12705, -4452,  1285, 81479,  1221,   515,
    3571, 81479, -4452,  3364, -4452, -4452, 21601, -4452, -4452, -4452,
     257, -4452, -4452, -4452, -4452,  3638, 67871,  3845, -4452, 34919,
    2503, -4452,  3600,  3939,   103,  2506,  2510,  1429, -4452,  3518,
   -4452,  1662,  3825,   221, -4452,   153, -4452, 61064, -4452, 81479,
   81479, -4452, -4452, -4452, -4452,  2796, -4452, -4452, 81479, 81479,
   81479, 81479, -4452,  3640, -4452, -4452, 56681,  1601,  3767, -4452,
   -4452,  3768,   257, 81479, -4452, 61064,   153,   153, -4452, -4452,
   -4452,  3591, 81479, 81479, 81479, 81479,108046, 81479, 81479,  2427,
    2427, 61064,  3587, -4452,  2427,  2427,  3588, -4452,108046, 81479,
   81479, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452,  3655, -4452, -4452, -4452, 81479, 81479, 81479, 81479,
    3879, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, 81479, -4452, -4452,  2560,  2560, 61064,   153,   153,
   -4452, -4452, -4452,  3828, -4452,  1823,  1823, -4452, -4452,    76,
    2519, -4452,101325, -4452, -4452,  3019,  2560,  3019,  1183, -4452,
   -4452,  3019, -4452,  3019, -4452,  1429,  3595,  1638,  3873, -4452,
    2338, 43866, 43866, 43866, 43866, 43866, -4452, -4452,  3876,   257,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, 34919, -4452,   681,   739, -4452,
   -4452, -4452, -4452,  3518,  2035,  3652, 57655,   755, -4452,  3863,
     743, 64955,  1410, 81479, -4452,  2652,  2652,  3653, 81479,  4004,
   -4452,   566, 81479,  3915,  3647, -4452,  2560, -4452, -4452,  3161,
   81479, 64955,  3000, -4452,  2522, -4452, -4452, -4452,  3641,  3551,
    3608,  2219,   729, 81479, -4452,  3649, -4452, -4452,  3891,  3612,
   -4452, 12705, 12705,  2560, 62525,  3454, -4452, 81479,  3868, 81479,
   -4452,   153, -4452,   153,   153, -4452, -4452, 81479,  3153,  3153,
    3153, -4452,  3796, -4452,   153,107628,  1948,  1948,  1948,  1948,
   -4452, -4452, -4452, 12705, -4452, -4452, -4452, 36935,  3898, -4452,
    3619, 61064, -4452,  3621,  2525,  2543, 38447,  3764, -4452, -4452,
   -4452,  7778,  3672, 12705,  3723,  3627,  3628, -4452,   811,   811,
    1213,  2544, -4452, 36935, 36935,  4381,  4381, 34919,  4381, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, 78563,  3630, 81479,  1710,
   40925, -4452, -4452,  1983, -4452, 40925,  3869, -4452, 40925, 81479,
    3632, 81479,   929, 34919, 34919,  3670,  3385,  3385, -4452,  3802,
   -4452,  3637, -4452, -4452,  2093, -4452, -4452, -4452, -4452,  1003,
    3642, 73703, -4452, -4452, -4452,  1149, -4452, -4452, -4452, -4452,
  107628,  3827,107628,  1429,  8104,  3518, 41905, 50789, 81479, 80993,
   80993,  3783,  3518,  3652, -4452, -4452, -4452, -4452, -4452, -4452,
    3648, -4452, -4452, -4452,  3722, -4452, -4452, -4452,  2549, -4452,
   -4452, -4452, -4452, -4452,  3820, -4452, -4452, 47296, -4452,  3724,
   -4452, -4452, -4452, -4452, -4452, 42395, 49791, -4452,   809,  3644,
    3654,  1007, -4452, -4452, -4452, 81479,  1496,  1090,  3692,  3153,
    3931, -4452, -4452, -4452,  3820, -4452, -4452,  1823, -4452, -4452,
   -4452,  2650,  3968, -4452, 56681, -4452,103442, -4452, -4452, -4452,
    2560, -4452,  2560,  3843, 52750,  2560,  2560, -4452, 57655,  4053,
    4053, -4452,  1779,  1779, -4452, -4452, -4452, 81479, -4452, -4452,
    8224,  3846, -4452,  3652,  3871,  3919, -4452,  3663, 81479,  3817,
    3667,  3668,   957,   957,  3453, 81479,  2550,  1285,  1096, 64955,
    3453, -4452,  1602,  3674,  3967, -4452,  4072,  3368,  3677, -4452,
   -4452, 66899,  3860,  3584, 81479,  3551,  3805, -4452,  3809, -4452,
    1159, -4452, 81479, 41905, -4452, 61551, -4452,  2553, -4452, -4452,
    3253, 81479,   674, -4452,  3698, -4452, -4452, -4452, -4452, -4452,
   -4452,   173, -4452, -4452, -4452, -4452,  1474, 36935, 61064,  2564,
   34919, -4452, 34919, -4452,  4073, -4452, -4452, -4452,    16, -4452,
   -4452, -4452,   811,   811,  4381, -4452, 81479,  2567, -4452, 34919,
    3691, -4452, -4452, 40925,  1983,  2573, 81479,  2574, 61064,  3385,
    3204, 12705, 81479, -4452, -4452, -4452,  4077,  3872,  3385, -4452,
   -4452, -4452, -4452, -4452, -4452,  1490,  1367,   173,  3939,  3652,
   -4452,  3699, -4452, -4452, 81479, -4452,   260,   260, 81479,  3652,
   -4452, -4452, 81479, -4452, 56681,  3749, -4452, 81479, 61064,  2392,
     143, -4452, 61064, 61064, -4452, -4452, 81479, 81479, 81479, 81479,
   81479,   153, -4452,  3343,  2560, -4452, -4452,  2578, -4452, -4452,
   -4452, 81479, -4452,  3488, -4452, -4452,  4053,   223, -4452, -4452,
   -4452,  1704,  3896, -4452,  1243,  3882,  3784,  3702, -4452, 57655,
    4130,  3815, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452,  3996,  3161,  3649, -4452, -4452, -4452, -4452, 34919,  3859,
    1285,  2219,  3752, -4452, -4452, -4452,  2582,  3584, -4452, -4452,
    4081,  3892,  4086, -4452,  2583, -4452, -4452,  4797, 62525,  4032,
   -4452,  3766, 81479, -4452, -4452,  2484,  4142, -4452,  1474,  2587,
   -4452,  2588,  2591,  3862,  3769, -4452,  2598, -4452, 12705, 81479,
   -4452, -4452, -4452,  2601, -4452,  3725, -4452,  4121, 34919,  1375,
   -4452, -4452,  4003, -4452, 80993,  3761, 49791, -4452,  2205,  2205,
    2035, -4452,  1429, -4452, -4452, 34919, -4452, -4452,  2604, -4452,
     516,  3874,  4010,  2605,  2608,  3159,  3765,  3159, -4452,  3153,
   -4452, -4452, -4452, -4452,103442,  3488, -4452, -4452, -4452,  4037,
    3984, -4452, -4452, -4452, -4452,   320, -4452,  3914,  3916, 81479,
   -4452,  3733, -4452,  2611, 81479, 81479,  4136,  4137, -4452,  8342,
   57655, -4452,  3551,  2219,  1601, -4452, -4452,  3917, -4452,  3920,
    3161, 41905,  3454, -4452,   205, -4452, -4452, -4452, -4452, -4452,
   81479, -4452, -4452, -4452, -4452, -4452, -4452,  2614, -4452, 81479,
    3739,  3204, 33911, 33911,  3741,107628,   260,  3740, -4452,  3743,
   -4452, -4452,  3871,  1429, 12705, 57655,  4126, -4452, -4452, -4452,
    3874, -4452, -4452, 81479, -4452,  3870, -4452,   788,   788,  4068,
   -4452,  3803, -4452, -4452,  3747, -4452,  4176,  3453, -4452,   809,
    1285, -4452,  3754,  3584,  3551, -4452, -4452,  3584, -4452, -4452,
   -4452, -4452,  2103, -4452, -4452, -4452, -4452, 37943,  3875,   955,
    9975, -4452, -4452, -4452, -4452,   173,  2205, 34919,  1429, -4452,
    3882,  2392, 81479, -4452, -4452,  3647, -4452,  4167, -4452,  1152,
   -4452, -4452, -4452, -4452, -4452,  3587, -4452, 56194, -4452,  3584,
    3253, -4452,  1934, -4452, -4452, -4452, -4452, -4452, -4452, -4452,
    4158, -4452, -4452, -4452, -4452, -4452, -4452, -4452,  8864, -4452,
   -4452, -4452,  4054, -4452, -4452, -4452,  2619, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452,  1822, -4452, -4452,  1828,  2245, 34415,
   -4452,  1429,  3907, -4452, 56194, -4452,  1934, -4452, 57655, -4452,
   -4452,  3759, 56194,  2622, -4452
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
    2322,     0,     2,     1,  2752,  2756,  2760,  2761,  2678,  2762,
    2763,  2728,  2729,  2730,  2731,  2732,  2733,  2734,  2735,  2736,
    2737,  2738,  2739,  2741,  2740,  2742,  2743,  2744,  2745,  2746,
    2747,  2748,  2749,  2751,  2750,  2700,  2329,  2697,  2694,  2695,
    2696,  2701,  2699,  2692,  2693,  1923,  2765,  2753,  2766,  2754,
    2755,  2757,  2758,  2727,  2759,  2767,  2768,  2769,  2764,  2772,
    2723,  2724,  2722,  2725,  2726,  2770,  2771,  2714,  2715,  2716,
    2717,  2773,  2330,  2331,  2719,  2323,  2327,  2389,  2460,  2720,
    2721,  2718,  2328,  2713,  2460,     0,  2581,  2582,  2583,     0,
    2584,  2585,  2586,  2512,  2474,  2587,     0,     0,  2588,  2589,
    2590,  2591,  2592,  2593,  2594,  2595,     0,  2596,  2597,  2598,
    2599,  2459,  2600,  2601,  2602,  2603,  2604,  2436,  2442,  2565,
       0,  2416,  2417,  2413,  2415,  2414,  2418,  2401,  1198,   546,
    1284,  1283,     0,  2224,  1198,  2180,  2181,  2225,  2182,  2183,
    2184,   257,     0,  1286,  2185,  2226,     0,  1198,  2227,   370,
     967,  2228,  2229,  2344,     0,  2186,  2187,     0,     0,     0,
     546,  1198,     0,     0,  2188,  1398,  2189,     0,  2190,  2230,
    2231,     0,  2191,  2232,  2233,  2192,  2193,  2194,  2234,  2235,
    2236,  2195,  2237,  2238,     0,     0,  1412,     0,  2196,  2239,
    2197,  2198,     0,  2240,  2199,  2200,  2201,  2241,  2242,  2243,
    2202,  2203,  2204,     0,  2205,     0,     0,     0,     0,     0,
       0,  2244,  1198,  2206,     0,     0,  1419,     0,  2207,     0,
    2245,  2208,     0,  2209,     0,  2210,  2211,  2212,  2213,  1412,
    2561,  2437,     0,  1288,     0,  2214,  2246,     0,  2215,  2216,
    2217,  2218,  2219,  2220,  2221,  2222,  2223,     0,     0,    57,
      58,    22,    21,    27,    26,    80,    81,    45,    15,    71,
      51,   114,   113,   115,    33,    29,    65,    19,    20,    30,
      34,    53,    46,    92,    52,    18,    50,    75,    54,    78,
      40,     9,    10,    41,    69,    11,    42,    70,    12,    43,
      13,    59,    82,    25,    55,    79,    56,     3,    36,    67,
      63,     8,    47,    48,    49,    72,    73,    74,    97,    77,
     109,    32,   106,    86,    87,   103,    88,   104,     6,    89,
      44,    14,   100,    99,   101,    66,    37,    68,    98,   102,
      16,    17,   105,    76,    95,    91,   110,   108,   116,    93,
      60,     4,     5,    83,    39,     7,    24,    23,    38,    31,
     112,    28,  1286,    85,    96,    84,    90,    64,    94,   111,
      62,   107,  1385,  1372,  1421,  1384,  1397,     0,  1387,  2657,
    2658,    35,  1398,   118,   119,   124,  2326,  2378,  2379,  2380,
    2460,  2411,  2412,  2405,  2421,  2431,  2420,  2424,  2432,  2419,
    2438,     0,   121,   123,   125,   128,   122,   117,   120,   127,
     132,   126,   131,   129,   130,   133,   134,   135,  2659,  1606,
    2656,    61,  2396,  2395,     0,  2460,     0,  2689,  1935,  1936,
    1937,  1938,  1939,  1940,  1941,  1942,  1943,  1944,  1945,  1946,
    1947,  1948,  1949,  1950,  1951,  1952,  1953,  1954,  1955,  1956,
    1957,  1958,  1959,  1960,  1961,  1962,  1963,  1964,  1965,  1966,
    1967,  1968,  1969,  1970,  1971,  1972,  1973,  1974,  1975,  1976,
    1977,  1978,  1979,  1980,  1981,  1982,  1983,  1984,  1985,  1986,
    1987,  1988,  1989,  1990,  1991,  1992,  1993,  1994,  1995,  1996,
    1997,  1998,  1999,  2000,  2001,  2002,  2003,  2004,  2005,  2006,
    2007,  2008,  2009,  2010,  2011,  2012,  2013,  2014,  2015,  2016,
    2017,  2018,  2019,  2020,  2021,  2022,  2023,  2024,  2025,  2026,
    2027,  2028,  2029,  2030,  2031,  2032,  2033,  2034,  2035,  2036,
    2037,  2038,  2039,  2040,  2041,  2042,  2043,  2044,  2045,  2046,
    2047,  2048,  2049,  2050,  2051,  2052,  2053,  2054,  2055,  2056,
    2057,  2058,  2059,  2060,  2061,  2062,  2063,  2064,  2065,  2066,
    2067,  2068,  2069,  2070,  2071,  2072,  2073,  2074,  2075,  2076,
    2077,  2078,  2079,  2080,  2081,  2082,  2083,  2086,  2084,  2085,
    2087,  2088,  2089,  2090,  2091,  2092,  2093,  2094,  2095,  2096,
    2097,  2098,  2099,  2100,  2101,  2102,  2103,  2104,  2105,  2106,
    2107,  2108,  2109,  2110,  2111,  2112,  2113,  2114,  2115,  2116,
    2117,  2118,  2119,  2120,  2121,  2122,  2123,  2124,  2125,  2126,
    2127,  2128,  2129,  2130,  2131,  2132,  2133,  2134,  2135,  2136,
    2137,  2138,  2139,  2140,  2141,  2142,  2143,  2144,  2145,  2146,
    2147,  2148,  2344,  2149,  2150,  2151,  2152,  2153,  2154,  2155,
    2156,  2157,  2158,  2159,  2160,  2161,  2162,  2163,  2164,  2165,
    2166,  2167,  2168,  2169,  2170,  2171,  2172,  2173,  2174,  2175,
    2176,  2177,  2178,  2179,  2362,  1924,  1932,  1933,  1934,  2337,
    2358,  2364,  2685,  2363,  1931,  2511,     0,     0,  2605,  2606,
    2607,  2608,  2609,  2610,  2660,  2661,  2662,  2663,  2664,  2666,
    2665,  2473,  2632,  2669,  2472,  2670,  2476,  2671,  2672,  2673,
    2674,  2633,  2675,  2475,  2667,  2629,  2477,  2470,  2471,  2630,
    2579,  2580,  1901,  2631,  2628,  2668,  2365,  2627,  2481,  2480,
    1362,  2684,  1900,  1363,     0,  2483,  2611,  2612,  2613,  2614,
    2616,  2615,  2617,  2247,  2248,  2249,  2250,  2251,  2252,  2253,
    2254,  2255,  2256,  2257,  2258,  2642,  2259,  2260,  2261,  2655,
    2262,  2263,  2643,  2264,  2265,  2266,  2267,  2268,  2269,  2270,
    2271,  2272,  2273,  2274,  2275,  2276,  2277,  2278,  2279,  2280,
    2281,  2282,  2283,  2284,  2285,  2286,  2287,  2644,  2645,  2288,
    2289,  2290,  2291,  2292,  2293,  2294,  2295,  2296,  2297,  2298,
    2299,  2300,  2301,  2302,  2303,  2304,  2305,  2306,  2307,  2308,
    2309,  2310,  2311,  2646,  2312,  2313,  2647,  2314,  2315,  2316,
    2648,  2317,  2318,  2319,  2320,  2321,  2652,  2653,  2654,  2641,
    2434,  2618,  2640,  2651,  2649,  2650,  2444,  2440,  2448,  2443,
       0,     0,     0,     0,  2460,  1197,  1196,  1182,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   545,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2334,     0,  1208,
     342,   341,  1285,  1266,   546,     0,  1185,   369,     0,     0,
       0,     0,     0,     0,     0,     0,   737,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   183,     0,     0,
     393,   392,     0,     0,     0,   939,   398,     0,     0,     0,
       0,     0,   534,  2343,  2338,  2348,     0,  2341,  2342,  2627,
       0,  2776,  2084,  2374,  2375,  2774,  2134,  1364,   258,   261,
     259,   260,     0,  1039,  1040,  1042,     0,     0,  1052,   772,
     773,     0,   771,     0,   775,     0,     0,     0,   767,     0,
       0,     0,     0,     0,   774,   764,     0,   763,     0,     0,
       0,   770,     0,   765,     0,     0,  1186,     0,  2426,  2427,
    2024,  1325,   399,     0,     0,  1398,     0,  1303,  1304,  1286,
    1293,  1305,  1298,  1300,  1299,  1301,  1297,  1302,  1936,   878,
    1950,   878,  2014,   875,   876,   878,   878,   878,  2101,     0,
       0,   850,     0,   861,  1927,   878,  1928,  2685,   883,   454,
     454,   454,     0,   882,   887,   454,  1179,  1217,  1905,  1411,
       0,  1950,  2014,   851,  1178,  2149,  1317,     0,     0,     0,
    1056,     0,  1057,     0,  2116,  1190,   242,  2625,  2125,  2210,
    2149,  2626,   238,  2620,  2621,  2623,   212,  2624,  2622,  2619,
    1940,     0,     0,   882,     0,  1187,  1188,   834,  1418,  1416,
       0,     0,     0,  1958,     0,  1970,  2050,   235,  2112,  2117,
    2125,  2210,  2149,  2177,   192,   197,     0,   251,  2125,  2210,
    2149,     0,  1208,     0,  1388,  1506,  1896,     0,     0,  2435,
    1181,  1180,  1287,     0,  1290,     0,  1468,  2097,  1392,  1394,
    1292,  1385,     0,     0,  2325,  1281,  1415,  1415,     0,  1415,
       0,  1377,  1385,  1380,  1384,     0,     0,     0,     0,  1198,
       0,  2403,  2431,  2410,  2466,  2407,     0,     0,  2456,  2452,
    2449,  2457,  2458,  2451,  2439,  1595,  1596,  1597,  1594,  1607,
    1593,     0,  2384,  1598,  2423,  2390,     0,  2398,  2397,  2702,
    2703,  2513,  2336,  2355,     0,     0,     0,     0,     0,     0,
       0,  2482,  2484,  2486,  2446,  2445,  2441,     0,     0,     0,
       0,  2571,  2572,  2570,     0,  2567,  2569,     0,  2466,     0,
    2636,  2630,  2639,     0,  1906,  2631,  2628,  2627,     0,   782,
       0,   139,   927,     0,     0,     0,     0,  1900,     0,     0,
       0,     0,     0,  2023,     0,     0,     0,  1801,  1962,  2010,
    1811,  1809,  1810,  1803,  1804,  1805,  1806,  1807,  1808,     0,
    1037,  1802,     0,   161,   139,     0,     0,  2023,     0,     0,
    2023,     0,     0,     0,     0,     0,   161,  2053,   139,  2023,
       0,     0,     0,  1202,     0,     0,     0,  1204,  1207,  1183,
    1269,     0,  1896,     0,     0,   813,   803,     0,   814,   804,
     809,     0,   816,     0,     0,   806,     0,     0,     0,   817,
       0,   805,   807,   819,   808,   815,     0,     0,   810,   811,
       0,     0,  1194,   454,   348,     0,     0,     0,     0,     0,
     139,  1256,     0,  2023,   139,     0,     0,   397,   396,   139,
     395,   394,  1962,  2010,     0,   966,   139,  2023,     0,   185,
     616,   549,     0,     0,   694,  2053,   139,     0,     0,     0,
       0,     0,     0,   942,     0,     0,   533,   546,     0,  2347,
    2353,     0,  2345,  2514,  2777,  2775,  2469,     0,  1043,   236,
     237,  1041,  2023,     0,   320,     0,     0,  2023,  1245,   769,
       0,   768,  2023,     0,  2023,  1925,   176,     0,   766,  1962,
    2010,  2023,     0,     0,  2023,   168,  2023,     0,  2023,   320,
    2023,   550,     0,  2023,     0,  2023,  2053,   170,     0,  2023,
     320,   780,     0,     0,  2707,  2711,     0,  2709,  2704,  2425,
    2479,  2478,  2377,     0,  2787,     0,  1364,  1295,  1310,     0,
    1306,  1313,  1309,  1398,   878,   877,     0,   878,     0,  2797,
     878,     0,   878,     0,  2797,   878,     0,     0,     0,   878,
    1929,  1930,     0,     0,  2796,  2792,  2795,   852,   862,     0,
     884,     0,     0,   891,   890,   889,     0,     0,     0,   892,
    1510,  1340,     0,   859,     0,   857,     0,  1176,  1193,     0,
       0,     0,     0,     0,  1059,  1059,  1059,  1189,   241,   239,
       0,     0,     0,     0,     0,     0,  1195,     0,     0,     0,
       0,  2691,  1912,  1812,  2690,     0,  2181,  2182,  2183,  1870,
       0,  2632,  2184,  2185,  2226,  1724,  1711,  1720,  1725,  1712,
    1714,  1721,  2186,  2187,  1994,  2188,  2189,  1919,  2190,  2191,
    1550,  2193,  2194,  2195,  1716,  1718,  2196,  2197,     0,  1920,
    2199,  2200,  2072,  2202,  2203,  2205,  2206,  1722,  2208,  2209,
    2210,  2211,  2212,  2213,  1918,     0,  1723,  2214,  2216,  2217,
    2218,  2219,  2220,  2221,  2222,  2223,     0,     0,  1893,     0,
    1696,     0,  1542,  1543,  1565,  1566,  1544,  1571,  1572,  1584,
    1545,     0,  1892,  1609,  1695,  1701,     0,  1694,  1690,  1401,
    1888,     0,  1691,  1908,  1871,  1922,  1921,  2685,  1879,  1911,
    1909,  1910,     0,     0,     0,   204,     0,     0,  2560,   253,
       0,   254,  1894,  2125,   193,   234,   206,   233,   207,   205,
       0,  1960,   194,     0,     0,   195,     0,     0,     0,     0,
       0,     0,     0,   247,  1184,     0,  1508,  1507,     0,     0,
    1877,  1897,   789,     0,  1279,  1280,  1278,     0,  1275,  1277,
    1289,  1286,  1884,  1883,  1885,     0,  1393,     0,     0,     0,
    1375,  1374,  1292,  1413,  1414,     0,     0,     0,     0,     0,
       0,     0,     0,  1458,  1429,  1430,  1432,  1455,  1459,  1467,
       0,  1381,     0,     0,  1512,     0,  1469,  2324,  2466,  2467,
       0,  2461,     0,  2460,  2460,  2454,  2453,  2450,     0,     0,
       0,     0,     0,     0,     0,     0,  2381,   528,  2383,   525,
       0,     0,  2357,     0,  2361,  2359,     0,  2506,  2509,     0,
    2507,  2508,  2510,     0,  2515,  2516,     0,     0,     0,  2698,
       0,     0,  2497,  2485,  2492,  2494,  2496,  2495,  2504,  2500,
    2503,  2505,  2447,  2460,  2578,     0,  2573,  2576,     0,  2568,
       0,     0,     0,  1907,     0,     0,     0,     0,   783,     0,
       0,     0,     0,     0,     0,   138,  1243,   244,  1241,     0,
       0,     0,     0,     0,     0,     0,  1248,     0,     0,   174,
     175,   561,   546,     0,  2023,     0,     0,     0,     0,   999,
    1006,     0,     0,     0,     0,     0,     0,     0,  1000,   998,
    1001,   246,  1010,  1023,  1026,     0,   917,     0,     0,     0,
       0,  1108,     0,     0,  1108,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   264,   272,   315,     0,
    2023,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     143,     0,     0,     0,     0,     0,     0,   512,   524,     0,
       0,     0,     0,     0,   521,     0,   139,   266,   505,   509,
       0,     0,     0,   625,   624,     0,  1108,     0,   262,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   334,   335,     0,     0,     0,   143,
       0,     0,     0,     0,   268,     0,  2391,     0,  1203,  1200,
    1201,     0,  1206,     0,  1265,     0,     0,     0,     0,   821,
       0,   818,     0,     0,   812,  1962,  2010,     0,     0,     0,
       0,     0,     0,   372,   347,     0,     0,     0,   691,     0,
    1553,  1582,  1560,  1582,  1582,  1549,  1549,  1562,  1551,  1589,
       0,  1582,  1549,  1554,     0,  1552,  1592,  1592,  1577,     0,
    1534,  1535,  1536,  1537,  1563,  1564,  1538,  1569,  1570,  1539,
    1606,  2637,  1549,  2638,  2635,  2634,     0,     0,   702,     0,
    1220,  1255,     0,     0,     0,   555,     0,  2023,     0,   141,
     738,     0,   692,   398,     0,   141,     0,     0,   179,     0,
     620,     0,     0,     0,     0,     0,     0,   640,   639,     0,
       0,     0,   693,     0,   141,     0,   508,  2023,     0,   454,
     454,     0,     0,   941,   944,     0,     0,     0,  2351,  2346,
    2349,     0,  2339,  2353,  1367,  1369,  1368,     0,  1366,     0,
     320,   318,   319,   689,  1051,     0,     0,     0,     0,   320,
       0,     0,  2023,   320,  2023,     0,  2023,     0,     0,   320,
     320,     0,     0,     0,     0,   621,     0,   779,   777,   776,
     778,     0,     0,     0,     0,     0,  2023,   320,     0,     0,
     760,  2705,     0,     0,  2708,     0,  2428,  1822,     0,  2793,
    1322,  2790,     0,     0,  1398,     0,   223,   224,   222,  1311,
     225,  1312,  1308,  1294,     0,   870,     0,  2797,  2798,   855,
       0,   865,     0,  2797,   853,     0,   866,   863,   864,     0,
       0,     0,  2791,  2676,  2682,   869,     0,     0,   455,   457,
       0,     0,  1980,  1993,     0,  2015,  2041,  2042,  2117,  2121,
       0,  2144,  2153,     0,   893,   922,   888,     0,     0,  1350,
     860,   858,  1177,  1315,  1828,     0,  1398,     0,   498,  1058,
    1055,  1054,  1053,   240,   213,     0,     0,     0,   924,  2116,
    1192,   833,   546,     0,     0,  1699,  1700,  1581,  1568,  1869,
       0,     0,  1576,  1575,     0,     0,     0,     0,     0,  1558,
    1557,  1556,  1698,  1836,     0,  1555,     0,     0,     0,     0,
    1582,  1582,  1580,  1629,     0,  1559,     0,     0,  1849,     0,
    1855,     0,     0,     0,  1588,     0,  1586,     0,     0,  1665,
       0,     0,     0,     0,     0,     0,     0,     0,  1613,  1614,
    2633,  1696,  1822,     0,  1697,  1915,     0,     0,  1574,     0,
    1606,  1812,     0,     0,     0,     0,  1882,     0,  1820,     0,
       0,  1643,  1818,     0,  1645,     0,     0,     0,  1811,  1809,
    1810,  1803,  1804,  1805,  1806,  1807,  1808,  1816,  1626,     0,
    1891,     0,  1625,     0,     0,  1471,  1400,     0,  1913,  1872,
       0,  2683,  2686,  1692,  2557,  2556,  2555,  2554,  2525,     0,
    2519,  2520,     0,  2558,  2559,   255,   256,   252,     0,     0,
     209,   208,     0,   231,   232,   203,   230,     0,   226,   227,
     211,  1764,  1763,   210,   202,   200,   198,   214,   216,   217,
     201,   199,   250,   248,     0,     0,     0,  1874,  1873,  1903,
    1878,     0,     0,   320,  2460,  1273,     0,  1270,  1887,     0,
    1395,     0,  1898,     0,  1282,  1391,  1390,  1422,  1423,   959,
    1389,  1449,  1450,     0,     0,     0,     0,  1464,  1462,  1440,
    1433,  1439,     0,     0,  1437,     0,  1441,  1609,  1457,  1379,
    1427,  1428,  1431,  1378,     0,  1460,     0,  1350,  1458,  1432,
    1337,     0,     0,  1513,     0,     0,  2468,  2466,  2406,  1534,
    2460,  2399,  2460,  2455,  2387,  1600,  1601,  1602,  1603,  1604,
    1605,  2388,     0,  2385,  1599,  2386,   526,   527,     0,     0,
       0,  2354,     0,  2335,  2360,  2491,  2600,  2523,     0,  2524,
       0,     0,  2488,     0,  2498,  2501,  2499,  2502,     0,  1534,
    2679,  2574,  2679,  1534,     0,     0,     0,     0,     0,     0,
       0,     0,   784,     0,     0,     0,     0,     0,     0,  2144,
     243,  1239,     0,     0,     0,     0,   926,   925,     0,     0,
     946,     0,     0,     0,  1251,   443,     0,   317,     0,     0,
       0,     0,     0,     0,     0,     0,   687,   684,     0,     0,
     683,     0,   559,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   595,     0,  1108,     0,   628,     0,  1008,     0,  1007,
       0,     0,     0,  1009,  1004,  1005,  2117,  2125,  2149,   245,
    1025,     0,  1024,  1022,   981,   983,   982,     0,   985,   969,
       0,   970,     0,     0,   980,   988,   986,     0,     0,     0,
       0,  2003,   274,   287,     0,  1107,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   307,     0,   310,   309,
       0,     0,     0,     0,   314,     0,     0,     0,   313,     0,
       0,     0,     0,  1108,     0,   270,     0,     0,     0,     0,
       0,     0,  1038,     0,     0,   164,     0,   160,   163,     0,
       0,     0,     0,   511,   523,     0,   515,   516,   513,   517,
     518,     0,     0,     0,     0,     0,     0,   510,     0,     0,
     618,   617,   623,     0,     0,     0,     0,     0,     0,     0,
    1100,  1099,     0,     0,     0,     0,     0,     0,   728,     0,
       0,     0,     0,     0,     0,     0,   167,   631,   632,     0,
     633,     0,   165,   166,     0,     0,     0,     0,     0,     0,
       0,   221,  1199,  1205,  1268,  1904,  1267,     0,     0,     0,
     820,     0,     0,     0,     0,     0,     0,     0,   822,   823,
     824,   825,     0,     0,     0,     0,     0,   350,   351,   139,
     349,     0,   717,  2634,   690,     0,  1534,     0,  1530,  1526,
    1595,  1594,  1593,     0,  1540,  1549,  1546,   703,     0,   705,
     708,     0,  1218,   416,     0,     0,   552,   595,     0,   401,
     172,     0,     0,     0,     0,   137,   183,   185,   399,     0,
     184,   186,   188,   189,   190,   187,   191,   615,   619,     0,
     548,     0,     0,     0,     0,     0,   641,   645,   644,   648,
     646,     0,   642,     0,     0,  1522,     0,   159,     0,   504,
     507,     0,  2332,     0,   401,   485,   327,     0,   454,     0,
       0,   943,     0,     0,     0,     0,     0,  2352,     0,     0,
       0,     0,  1365,     0,  1029,     0,  1246,  2023,   320,     0,
    1027,   177,  1926,     0,   761,     0,     0,     0,     0,     0,
    1031,   757,   169,     0,   320,   320,   551,     0,   320,   171,
       0,     0,     0,   543,   320,   781,  2706,  2712,  2710,  1324,
       0,  2794,  2788,  2789,   454,  1369,  1296,  1307,   867,   874,
     856,   873,   872,   854,   871,   868,  2490,     0,     0,  2681,
       0,   885,     0,   453,     0,     0,     0,   899,   900,     0,
       0,   898,   915,   901,     0,   903,   895,   894,   904,   905,
       0,     0,   924,     0,  1347,     0,  1345,     0,  1511,  1349,
    1338,  1316,     0,  1314,  1319,  1321,  1320,  1318,     0,     0,
     503,     0,     0,   882,     0,     0,   320,  1191,     0,   835,
     836,   842,     0,     0,     0,     0,     0,   843,   839,   840,
     841,   844,   845,   846,     0,     0,     0,  1832,     0,  1833,
       0,     0,     0,  1868,  1864,     0,     0,     0,     0,     0,
       0,  1840,  1841,  1842,  1839,  1843,  1838,     0,     0,  1844,
    1837,     0,     0,     0,     0,     0,  1579,  1578,     0,     0,
       0,     0,     0,     0,     0,  1668,  1701,     0,     0,  1796,
       0,  1822,  1854,     0,     0,  1590,     0,     0,     0,     0,
       0,     0,     0,  1822,  1860,     0,     0,     0,     0,  1762,
       0,  1759,     0,     0,     0,     0,  1879,     0,     0,     0,
       0,  1916,  1610,  1627,  1890,     0,  1881,     0,     0,  1611,
    1634,     0,  1861,  1661,     0,  1666,  1649,     0,  1642,     0,
    1647,  1651,  1630,  1882,  1821,     0,  1819,     0,     0,  1628,
       0,  1623,  1621,  1622,  1615,  1616,  1617,  1618,  1619,  1620,
    1624,  1800,  1798,  1799,     0,     0,     0,  1646,  2017,  2050,
       0,  1412,  1412,  1412,  1399,  1410,  1889,     0,  1517,     0,
       0,     0,     0,  1779,     0,  1826,     0,  1824,  1906,  2688,
    2687,  1880,     0,     0,     0,  1895,     0,     0,  1606,     0,
     249,  1509,  1875,     0,   787,   788,   786,  1534,  1292,  1276,
    1272,  1271,  1886,  1291,     0,  1398,     0,   957,   958,     0,
     962,  2206,  2114,     0,     0,     0,     0,  1442,  1465,     0,
    1456,     0,  1443,  1908,  1909,  1444,  1447,  1448,  1438,  1466,
    1461,  1383,  1382,     0,  1520,     0,     0,  1334,  1327,  1514,
       0,  1471,  1352,  1354,  1355,     0,  1879,  2404,  2462,  2409,
    2430,  2400,  2433,  1608,  2382,  2422,     0,  2356,  2526,  2527,
       0,  2517,  2518,  2487,  2493,  2564,     0,  2680,     0,     0,
     715,   714,     0,     0,     0,  1136,  1061,  1112,   785,  1137,
    1062,  1113,  1138,  1063,  1240,     0,  1242,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   666,  2023,   320,  1249,  1139,     0,  1064,   316,  1250,
    1114,  1254,   686,   685,     0,     0,  1115,     0,   560,     0,
       0,   565,   566,   567,     0,     0,     0,   568,     0,  1962,
    2010,     0,   573,   580,   585,   575,     0,   586,   581,     0,
       0,     0,     0,     0,     0,   592,   594,     0,     0,     0,
       0,     0,     0,  1002,  1003,  1140,  1067,     0,  1116,   984,
    1549,   968,     0,     0,   979,     0,   978,  1549,  1549,  1068,
     173,     0,   265,   275,   601,  1110,   293,   306,   301,   302,
     300,  2023,   320,  2023,   320,     0,     0,     0,     0,   303,
     298,   299,   295,   308,  1939,  1995,  2126,     0,   605,   607,
       0,   612,   311,  1082,     0,   328,   331,   312,   291,   294,
     292,   288,   273,     0,     0,     0,     0,     0,     0,  1902,
       0,     0,  1033,     0,     0,     0,   162,  1096,     0,     0,
     148,     0,     0,     0,     0,   142,   152,     0,  1146,  1072,
       0,     0,   267,   506,   514,   519,  1076,   522,  1126,   520,
    1152,  1073,  1108,     0,   263,     0,  1074,     0,  1120,  1148,
    1098,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1257,     0,     0,     0,     0,     0,   320,     0,     0,     0,
    1110,  2023,   320,  1147,     0,  1105,  1134,     0,   336,     0,
    1097,     0,     0,   269,  1078,  1128,     0,     0,   219,   218,
     220,     0,     0,     0,     0,     0,     0,     0,     0,   827,
     796,   826,     0,     0,     0,   790,   371,   345,   346,   348,
     355,   716,     0,     0,     0,  1531,  1527,     0,     0,     0,
       0,     0,     0,  1547,   704,     0,     0,     0,     0,  1238,
    1238,  1238,  1238,  1238,  1238,  1238,  1219,  1247,     0,   139,
       0,     0,     0,   554,   594,   601,     0,     0,     0,   400,
     404,   408,   409,   410,     0,     0,     0,     0,   153,   140,
       0,   746,     0,   454,     0,   185,   178,     0,     0,     0,
     547,   701,   699,   698,   700,     0,     0,     0,   721,   697,
       0,  1521,  1523,     0,     0,     0,     0,     0,   403,     0,
     457,     0,     0,   489,     0,     0,     0,   327,     0,     0,
     973,     0,   991,   974,     0,     0,     0,  1013,  1018,  1014,
     994,     0,   531,  2350,  2344,  1370,  1371,     0,   320,     0,
       0,   596,   320,   320,     0,   320,     0,   320,   320,     0,
    1174,   622,     0,   674,     0,     0,   320,   759,  1823,     0,
    2489,  2677,   886,   456,     0,     0,     0,     0,   897,     0,
     529,   902,     0,   914,   909,   911,     0,   918,  1348,  1341,
    1343,  1342,     0,     0,  1339,  1829,   758,   496,     0,     0,
       0,   320,     0,   919,     0,   837,   838,     0,     0,   847,
       0,     0,  1417,  1830,  1831,     0,     0,     0,     0,  1865,
       0,     0,  1737,     0,  1713,  1715,  1548,  1727,     0,  1561,
    1738,  1739,  1717,  1719,     0,  1813,     0,     0,  1728,  1670,
    1671,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1683,  1682,  1729,  1795,     0,     0,
    1852,  1853,  1730,  1591,  1592,  1592,     0,     0,  1859,     0,
       0,     0,  1735,  1740,     0,     0,     0,     0,  1746,     0,
    1767,     0,     0,     0,  1693,  1823,  1583,  1584,     0,     0,
       0,     0,     0,     0,     0,     0,  1667,  1650,  1644,     0,
    1648,  1652,     0,     0,     0,     0,  1636,  1662,  1632,     0,
       0,  1638,     0,  1663,  1412,  1412,  1412,  1412,  1409,     0,
       0,     0,     0,     0,  1492,  1470,  1472,  1479,  1492,  1497,
    1515,     0,  1896,     0,  1452,  1421,  1421,     0,  1779,     0,
    1702,     0,  1779,     0,     0,  2539,  2541,  2542,  2543,  2544,
    2545,  2547,  2548,  2550,  2551,  2552,  2540,  2546,  2549,  2553,
    2530,  2531,     0,  2521,  2522,   196,     0,   228,   215,     0,
    2564,  1274,  1899,     0,  1424,     0,  1814,   962,   960,   961,
    1426,  1445,  1446,     0,  1436,  1463,  1434,  1336,     0,  1334,
    1329,     0,  1330,  1879,     0,  1326,  1359,     0,     0,  1520,
       0,  1358,     0,  2464,  2392,     0,     0,  2563,  2566,  2577,
    2575,  2402,  1135,  1060,  1111,  1238,   929,   930,     0,   928,
       0,     0,     0,   442,   945,     0,     0,     0,   666,     0,
       0,   446,     0,  1252,     0,  1153,  1095,   562,   563,     0,
     574,     0,   583,   582,     0,     0,   570,     0,     0,     0,
       0,   569,   588,   535,   589,   591,     0,     0,   590,   593,
     598,  1108,     0,   629,  1084,     0,  1132,   996,     0,  1549,
     971,   976,   977,     0,     0,     0,   416,     0,     0,     0,
     276,   286,     0,     0,   290,     0,   284,   304,   296,   305,
     297,   609,   610,   608,   604,     0,   611,   613,   325,     0,
       0,     0,  1142,  1108,     0,   271,  1080,     0,  1130,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1143,  1117,     0,     0,   145,   144,     0,   151,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   337,   322,     0,   724,     0,     0,     0,   339,     0,
       0,     0,     0,  1141,  1069,   791,     0,     0,   792,   800,
       0,     0,   793,     0,     0,   802,     0,     0,   344,   352,
     718,     0,  2072,  1803,  1804,   712,   719,   709,   711,   710,
     713,   666,     0,     0,     0,  1532,     0,  2778,  2786,  2785,
       0,  1606,   706,   707,     0,  1238,  1237,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   428,     0,
       0,   422,     0,     0,  1018,   415,   418,   419,     0,     0,
     555,   558,   556,   557,   587,     0,   435,     0,     0,   155,
       0,     0,   156,   154,     0,     0,   327,     0,   181,   399,
       0,     0,   647,   650,   643,     0,   720,   722,   695,     0,
     601,     0,     0,  1325,   498,     0,   485,   481,   483,   482,
     484,     0,   491,   326,     0,   498,   491,     0,   946,   972,
       0,     0,     0,  1011,  1015,  1012,     0,     0,   987,     0,
     995,   965,  1169,  1170,  1167,  1168,     0,     0,  2367,  1361,
    2376,  1030,     0,   320,  1028,   762,     0,   753,     0,   755,
    1032,   320,   320,   634,     0,   544,     0,     0,     0,     0,
     896,   916,     0,   912,     0,     0,   879,   921,  1346,  1344,
     497,   924,     0,   880,   923,     0,     0,     0,     0,     0,
    1834,  1567,     0,  1867,  1863,     0,  1710,  1835,     0,  1847,
    1846,  1669,  1848,     0,  1688,     0,     0,  1680,  1678,  1679,
    1672,  1673,  1674,  1675,  1676,  1677,  1681,  1857,  1856,  1850,
    1851,  1587,  1585,     0,  1732,  1733,  1734,  1858,  1741,     0,
    1953,  1768,  1745,  1761,  1760,     0,     0,     0,  1748,     0,
       0,  1757,     0,  1797,  1573,  1606,  1612,     0,     0,  1635,
    1862,  1653,     0,     0,     0,  1631,     0,     0,     0,     0,
    1640,  1813,     0,     0,     0,     0,     0,     0,  1403,  1402,
    1408,  1492,  1497,  1385,     0,  1479,     0,  1491,  1477,  1490,
       0,     0,  1503,  1501,     0,  1503,     0,  1503,     0,  1474,
       0,  1493,  1475,  1490,     0,  1897,  1516,     0,  1454,     0,
       0,  1420,     0,  1779,  1709,  1782,  1777,  1778,  1827,  1703,
    1914,     0,  1825,  1779,     0,     0,     0,  1876,  2562,  1396,
       0,  1425,  1435,     0,  1518,  1335,     0,     0,  1332,  2793,
       0,     0,  1353,  1334,  1356,  2408,     0,  2463,  2528,  2529,
       0,   935,   936,   934,   937,     0,     0,     0,   666,     0,
       0,   462,     0,   953,   953,     0,     0,   448,   494,  1018,
     669,     0,     0,     0,   667,   320,  1065,     0,   584,     0,
       0,   579,   577,   576,   578,   536,  1151,  1066,     0,     0,
       0,     0,   997,     0,   989,  1083,     0,   413,     0,   281,
    1109,     0,     0,     0,   280,     0,   320,   320,   606,   329,
     330,   333,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   747,   730,     0,     0,   748,   749,     0,     0,
       0,  1035,  1036,  1034,   149,   146,   147,   150,  1093,  1077,
    1127,  1075,     0,  1121,  1090,  1086,     0,     0,     0,     0,
       0,  1150,  1104,  1125,  1149,  1102,  1123,  1101,  1122,  1103,
    1124,  1094,     0,  1525,   727,     0,     0,     0,   320,   320,
     636,  1079,  1129,     0,   794,     0,     0,   795,   797,   374,
       0,   377,   384,   356,   361,  1256,     0,  1256,     0,   358,
     362,  1256,   357,  1256,   354,   688,     0,     0,     0,  1528,
       0,     0,     0,     0,     0,     0,  1533,  1541,   665,     0,
    1229,  1228,  1227,  1231,  1230,  1233,  1232,  1224,  1223,  1236,
    1235,  1222,  1221,  1226,  1225,     0,   420,     0,   426,   430,
     431,   429,   421,  1018,   454,   493,     0,     0,   678,     0,
     553,   401,   432,     0,   405,   158,   157,     0,     0,     0,
     185,     0,     0,   652,   656,   696,     0,  1524,   630,   327,
       0,   401,   498,  2333,     0,   406,   411,   412,     0,   489,
       0,   485,     0,     0,   495,  1216,   499,   500,     0,     0,
     975,   992,   993,     0,     0,  1018,  1017,     0,   538,     0,
    2340,   320,   597,   320,   320,  1175,   675,     0,   908,   907,
     906,   530,     0,   910,   320,     0,     0,     0,     0,     0,
     849,   828,   848,  1866,  1726,  1736,  1845,     0,     0,  1689,
       0,     0,  1731,  2215,     0,     0,     0,     0,  1765,  1766,
    1747,     0,  2063,  1752,     0,     0,     0,  1917,  1659,  1657,
    1654,     0,  1655,     0,     0,  1637,  1633,     0,  1639,  1664,
    1407,  1406,  1405,  1404,  1478,  1476,  1481,  1488,     0,  1473,
       0,  1502,  1498,     0,  1499,     0,     0,  1500,     0,     0,
    1488,     0,     0,     0,     0,  1773,  1779,  1779,  1704,  1784,
    1781,     0,  1706,  2532,     0,  2535,  2533,  2534,  2538,  1606,
       0,     0,  1328,  1331,  1333,     0,  1360,  1351,  2465,  1244,
       0,     0,     0,   444,     0,  1018,     0,     0,     0,   956,
     956,     0,  1018,   493,   671,   670,   673,   668,   672,  1253,
       0,   571,   572,  1085,     0,  1133,  1091,   990,     0,   602,
     277,   278,   279,   282,   322,   289,   283,     0,  1081,     0,
    1131,  1088,  1144,  1070,  1118,     0,     0,   736,     0,     0,
       0,     0,  1145,  1071,  1119,     0,     0,     0,     0,  1262,
       0,   321,   726,   725,   322,   338,  1106,     0,   798,   799,
     375,   139,     0,   353,     0,   382,     0,   380,   379,   381,
       0,   368,     0,     0,     0,     0,     0,  1529,     0,  1049,
    1049,  2779,  2780,  2781,  2782,  2783,  2784,     0,   666,  1234,
       0,     0,   417,   493,   461,     0,   423,     0,     0,     0,
       0,     0,     0,     0,   601,     0,     0,     0,   180,   401,
     601,   651,     0,     0,     0,   723,     0,   403,     0,  1323,
     402,     0,     0,   491,     0,   489,     0,   486,     0,   490,
       0,  1209,     0,     0,  1016,     0,  1020,     0,   986,   963,
    1517,     0,   542,  2366,  2370,  1050,   754,   756,   635,   913,
     920,   320,   829,   830,   831,   832,  1684,     0,     0,     0,
       0,  1742,     0,  1743,  1770,  1769,  1749,  1753,     0,  1750,
    1751,  1656,  1660,  1658,  1641,  1480,     0,     0,  1482,     0,
       0,  1484,  1486,     0,     0,     0,     0,     0,  1900,  1779,
    1451,  1453,     0,  1386,  1707,  1708,     0,  1421,  1779,  2537,
    2536,   229,  1815,  1519,  1357,   914,     0,   320,   953,   493,
     463,  2072,   464,   952,     0,   954,   959,   959,     0,   493,
     666,   564,     0,   600,     0,   324,   332,     0,     0,     0,
     743,   731,     0,     0,   750,  1087,     0,     0,     0,     0,
       0,   320,   801,   355,     0,   378,   387,     0,   385,   359,
     364,     0,   366,   365,   360,   363,  1049,     0,  1046,  1045,
     664,     0,   452,   424,     0,   472,     0,     0,   679,     0,
       0,     0,   441,   440,   437,   436,   438,   439,   434,   433,
     626,   740,   327,  1216,   614,   653,   654,   649,     0,     0,
       0,   485,   481,   407,   416,   390,     0,   491,   487,   488,
       0,     0,     0,  1264,     0,   947,  1019,     0,     0,     0,
     537,     0,     0,   541,   532,     0,  2368,   881,  1685,     0,
    1686,     0,     0,     0,  1755,  1754,     0,  1489,  1505,     0,
    1485,  1483,  1494,     0,  1496,  1772,  1774,     0,     0,  1787,
    1705,   931,     0,   932,   956,   467,     0,   955,   962,   962,
     454,   666,   445,  1092,   603,     0,   285,  1089,     0,   734,
       0,   745,   743,     0,     0,  1258,     0,  1259,  1260,  1263,
     340,   343,   373,   383,     0,   367,  1044,  1048,  1047,     0,
       0,   425,   458,   459,   460,     0,   427,   468,   469,     0,
     676,     0,   681,     0,     0,     0,     0,     0,  1210,     0,
       0,  1211,   489,   485,   414,   480,   388,     0,  1213,     0,
     327,     0,  1018,  1021,  1173,   540,   539,  2371,  2373,  2372,
       0,  1687,  1758,  1744,  1771,  1756,  1487,     0,  1495,     0,
       0,  1783,     0,     0,     0,     0,   959,     0,   666,     0,
     950,   949,   461,   447,   323,     0,     0,   741,   744,   732,
     745,   752,   751,     0,   386,     0,   451,     0,     0,     0,
     470,     0,   471,   492,     0,   680,     0,   601,   739,     0,
       0,   655,     0,   491,   489,  1214,  1215,   491,   948,   964,
    1172,  1171,  1398,  2369,  1504,  1775,  1776,  2180,     0,  2155,
       0,  1785,  1788,  1786,  1780,   320,   962,     0,   449,   465,
     472,     0,     0,   733,  1261,   656,   477,     0,   476,     0,
     474,   473,   677,   682,   627,   729,  1212,   659,   391,   491,
    1517,  1155,  1398,  1154,  1156,  1164,  1161,  1163,  1162,  1160,
       0,  1792,  1791,  1790,  1794,  1793,   933,   951,     0,   666,
     735,   742,     0,   475,   479,   478,     0,   657,   660,   663,
     661,   662,   389,   938,     0,  1165,  1159,  1385,  1372,     0,
     466,   450,     0,   637,     0,  1157,  1398,  1789,     0,   658,
    1158,     0,   659,     0,   638
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -4452, -4452,  3897, -4452, -1182,   203,  2412,  -686, -4452, -4452,
   -4452,  1118, -4452, -4452, -4452, -4452, -4452, -4452, -4452,  3070,
   -4452, -4452,  1598, -2586, -4452, -4452,   -52, -1595,  1989,  2678,
    1267, -4452, -1389, -4452, -4452,  -884,    27,   450, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452, -1139,  1745,  1083,  2056,
   -2962, -4452, -1722, -3352, -4452,   482, -4452, -4452,  1687, -4452,
   -4452, -4452,   945,   407,  -508, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452,  -328, -4452, -4452,  -637,   240,  -107, -2604,  -379,
   -4452, -4452,   352,  -377, -1611, -4452, -3620, -4452,   -71, -4452,
   -4452, -4452,  -361, -1716,  1181, -4452,  -981, -1394,  1509,  -695,
   -4452,  -247, -4452,  -748,  -635,  -631,  -701,  -533, -3804, -4226,
   -3819, -4278,  1194, -4452, -3732,   268, -4452, -4452,   269,   278,
   -4452, -4452, -1791, -1730, -4452, -1119, -4452, -4452, -4452, -3091,
   -4452, -4452, -4452, -4452,   -98, -4452, -4452, -4452, -4452,   383,
   -4452, -4452, -4452, -4452, -4452, -4452, -2345,  1647,  1649, -4452,
   -4452, -3275, -4452, -1211, -4452,   520, -3086,  1103, -4452, -4452,
   -4452,  2359, -4452, -4452, -4452, -4452, -4452, -4452, -1870, -4452,
   -4452,   331, -4452,  1661,   916, -4452, -4452, -4452,  -731,  -797,
    -788, -4452, -3595, -4452, -4452, -4452, -4452,  -321, -4452, -4452,
   -4452, -4452, -4452, -4452, -1234, -4452,   973, -3210, -1244, -4452,
   -4452,   989, -4452, -4452, -4452, -4452, -4452,  -685,  -255,  2386,
   -4452,  -577,  -663, -4452, -4452, -4452,  -252, -4452, -4452, -4452,
   -4452, -4452, -4452, -1342, 19373, -1839, -4452, -4452, -4452, -4452,
   -2537, -4452, -4452, -4452, -1700, -4452,  4154,   -17,  -590,   342,
   -4452,  -184,   -92,  2910, -1414, -2790,   326,  -402, -4452, -2059,
   -4452, -4452, -4452, -2669, -4452, -4452, -4452, -4452, -3566,   343,
   -4452, -4452, -4452,   377, -4452, -4426, -4018, -4336, -3714, -3541,
   -4452, -4452, -1337, -4452, -4452, -4452, -1668,  1861, -1737, -4452,
   -2441,   379, -3824, -1012, -3317, -4452, -3777,  -502, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -1353,  -889, -4452, -4452,  3461,
   -4452, -4282, -4452, -4452, -4452, -4452,  1354, -4452, -1726,  1057,
   -4452, -4452, -4452, -4452, -4452,  -672,  -752, -4452, -4452, -4452,
     361, -4452, -4452, -4452, -4452,  1718, -1215, -1015,  3283,   363,
    -467, -4452, -4452, -4452, -4452, -3138, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -1833, -4452, -4452, -4452, -4452, -4452, -4452,
   -4452,  2071,  2072,   -97,  -221, -4452, -4452, -1518, -4452,  -827,
   -4452,  2316, -4452, -4452, -4452, -4452,  1343,   369,   410,   -74,
   -4452, -4452,   202, -3490,   -72, -4452, -4452, -4452, -4452,  2041,
     -68, -4452,   672, -4452, -4452, -2916, -4452,   400,    10,  2989,
    1606,   -12,   688,  -245,  -226,  -205,   -75,  3279,  2753, -4452,
   -4452, -4452,  -194,  1899, -4452, -1105,  -363, -4452,  1356,  -923,
    2045,  2747,  2742, -4452,  1358,  2082, -2147, -2150, -4452, -4452,
   -4452,  -921,  2058, -4452,  2750, -4452, -4452, -4452,  1339,  1348,
   -3443,   779, -3458, -3427,   281,   270, -1115,  -330,  -179,  3318,
    2757,   785, -4451,   709, -4452, -3460, -2458,  -440, -2159, -1867,
   -4452, -4452, -1398,  9580, -4452, -4452, -4452, 13085, 13939, -4452,
   -4452, 15622, 18788, -4452, -1289,   825, 19522,  5029, -1467, -1909,
   -1543,  6478,   264,  2340, -2915, -4452, -4452, -4452,  -300,   832,
     241, -4452, -4452, -4452, -4452,  -566, -2889,  -564, -4452, -4452,
   -4452,  -569, -3695,  1750, -4452,  -839, -4452, 20346,  1388, -4452,
   -1056, -2836, -2842, -1391, -2011, -4452, -4452, -4452, -4452, -4452,
   -4452, -4452, -2206, -3355,  -447,  1464, -4452, -4452,  1560, -4452,
   -4452, -4452, -1584, -1166, -2760,  1471, -2190, -4452, -1107,   731,
    2193, -1058, 12777, -1597, 16521,  -139, -2463, -1548, -1810, -4452,
    -778, -4452,  2302,  3425,  -874,  -148,  -909,  6501,  3807,  5016,
   -3211, -4452, -4452,   406, -4452, -4452, -4452,  3794,   985, -4452,
    3097, -4452,  1705,  2439, -4452, -4452,  2061,  -959,    41, -4452,
    -536, -4452,  -122, -4452, -4452, -4452,   164, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452, -4452, -4452,  2771, -4452, -4452, -1482,
   -4452, -4452, -4452, -4452, -4452,  4055,  -296, -4452,  3470,  -284,
   -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452, -4452,  2782,
    2097, -4452,  3273, -4452, -4452, -4452,   -47,  2992, -4452, -4452,
   -4452, -1217,  -583,  3288,  3295,  2062, -4452, -4452, -4452, -4452,
   -4452, -4452, -4452, -4452,  2083, -4452, -4452,  1449, -2166,  2087,
   -4452, -4452,   753, -4452, -4452,   306, -4452,   761, -4452,  2899,
   -4452, -4452, -4452,   803, -4452, -4452, -4452,  -616, 14395,   157,
     814,   865,  1538, -4452,  8956,  5569,   -40,  2809,   -38, 11981,
   18870,   254, -4452,  4062,  2088,  1686, -1023, -4452,  5033,  2394,
   18478, -4452, -1019,    23,  1804, -4452,    -2,  -675, -1207,  3101,
    -736, -1992, -4452,  4477, -4452, -3676, -4452, -1061,   308,  3487,
   -1216
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     1,   248,   249,  1736,  2670,  2547,  3388,  3389,   250,
     251,  1808,   252,   253,   254,   255,   256,   257,   258,  1752,
     259,   260,  1308,  1958,  2680,   261,  2410,  1075,  1076,  2276,
    2277,  2612,  2278,  2265,  1586,  2060,  1771,  1738,  1772,   263,
     264,  1580,  2257,   265,   266,   267,  1796,  1797,  1746,  2003,
    4303,  4906,  2528,  3425,  3224,  3225,   268,  1854,  1855,   269,
     270,  3339,  1895,  2639,  3878,  3879,  4334,   878,  2636,  4611,
    4612,  4320,  4321,  4618,  4797,  4798,  2681,  1954,  3419,  3966,
    3379,  4404,  3380,  4405,  3381,  4406,  3367,  3925,  3926,  3927,
    3382,  4382,  4828,  3383,  2425,  4931,  2715,  2090,  2088,  4815,
    4200,  4201,  4988,  4936,  4937,  4938,  5060,  4411,  3423,  3972,
    4414,  4646,  3121,  1978,  2830,   977,  2717,   909,   978,  2682,
     275,  2709,  1828,  1829,  2555,  3885,  3481,   276,  1327,  3752,
    4692,  4863,  4864,   277,   866,   278,  1962,   279,   280,  2666,
    3373,   281,  2442,  3138,   282,   283,  3165,  3166,  3167,   284,
     285,  3776,  4568,  1798,  3217,  3218,  3219,  3220,  3796,   286,
    1960,  1834,  2689,   287,   288,   289,   290,   291,  2599,   292,
     293,  2683,  1970,  2701,  2702,  4394,  4662,  4837,  4664,  5096,
    5097,  4638,  3731,  4214,   295,   296,  4377,  4378,  4943,   297,
    2440,   298,   299,   300,  1938,  2658,  2659,  3886,  1722,  1898,
    2641,  2642,  3955,  3956,   301,  3299,   302,  4262,  4263,   910,
    4946,  4911,  4999,   303,   304,  4266,  4267,   305,   306,   307,
     308,   309,   965,  1380,  1381,  1728,   310,  2293,   311,  1281,
    3330,   312,  1469,  2855,  4451,   313,  1001,  1405,  1406,  2684,
     315,  1012,  2833,  1014,  2103,  3483,  3484,  4026,  2801,  1200,
     316,   317,  2812,  2836,   318,  1739,  2416,  2417,  4195,  2685,
     911,  1984,  2720,  3116,  4854,  4202,  4549,  4766,  3030,  3680,
     320,   912,  1776,  2490,  2723,  3431,  3432,  2492,  2994,  3987,
    2494,  3433,  3438,  3439,  3440,  3983,  3991,  4686,  4687,   321,
    1774,  2483,   322,   323,   324,  1805,  1219,   325,   933,   934,
     326,  4808,   327,  1346,   328,  1033,  2120,   329,  2506,  3782,
     330,   331,   332,  5073,  5104,  5105,  5106,  3996,  5032,   333,
    5075,  1447,   335,   336,   337,   869,  1247,  1248,  1249,  2686,
    4681,   339,   340,  2662,  3366,  3907,   341,   342,  2411,  3106,
     343,   344,   345,  1942,   346,   347,   348,   349,  1874,   350,
    1617,  1618,   351,   352,   873,  1094,  1621,  1629,   353,   980,
    1399,  1400,  1401,  2062,   354,  1451,  2823,   981,  1394,   982,
    3057,  3691,  3692,  3695,   983,  3054,   358,  2109,  2817,  2820,
     984,  3061,  3062,  3063,  3064,  3065,  3697,   985,  1003,  1337,
    2731,   986,  1540,   363,   364,   365,  1103,  1098,  1099,   367,
    2235,  2984,  1020,  1635,  1060,  1110,  4151,  2307,  2308,  2332,
    2333,  1644,  1645,  2320,  2324,  2325,  3042,  3036,  2313,  4148,
    4515,  2328,  2329,  1647,  1648,  1649,  2337,   368,  2988,  3625,
    3626,  3627,  4127,  4128,  4142,  4138,  4502,  4731,  3628,  1441,
    1655,  3629,  3634,  3689,  3410,  3411,  3412,  2495,  2649,  1920,
    1541,  1921,  2656,  1542,  2155,  1923,  1543,  1544,  1545,  1926,
    1546,  1547,  1548,  1549,  2138,  2198,  1550,  1551,  2174,  1142,
    1143,  2047,  2894,  1553,  1554,  4091,  4475,  4464,  2920,  2921,
    2273,  4087,  3576,  4743,  4885,  4886,  4159,  4156,  4519,  4747,
    4984,  5041,  5042,  1555,  2974,  2227,  1221,  1556,  3888,  2229,
    2914,  2996,  2997,  2395,  2136,  2860,  2877,  2878,  2891,  3537,
    2898,  2903,  3560,  3561,  2915,  2943,  1557,  2863,  2864,  3520,
    2140,  1558,  1610,  1611,  2243,  2938,  1624,  1625,  1096,  1559,
    1560,  2104,  1085,  4727,   720,   703,  3238,  2288,  1251,  1017,
    1561,  1562,  1563,  1355,  1356,  1677,   665,   704,   705,  1180,
     817,     2,    75,   987,  3417,   372,   373,   914,   915,   916,
    1329,  1330,  1989,  1992,  1682,  2373,   669,   670,   721,  4430,
    4693,  4866,   971,   374,   375,   376,   377,  1678,  2369,  1144,
      76,    84,    77,  1145,   414,   415,  2350,   378,   834,   379,
    1658,  1124,  3703,   380,   381,   382,   383,   384,   968,   385,
    1126,   386,  1127,   387,   388,   389,   390,  1134,   391,  1660,
    1661,  4187,  1662,   392,   393,   707,   708,  1392,   394,   395,
    1161,  1162,  1424,  1425,  1688,  1703,  1704,  1705,   396,   677,
     397,   398,   399,  1694,  1695,   400,  2250,  2251,  2378,  2252,
     401,  3078,  3079,   402,  3660,  3661,  4526,  3662,   403,  2246,
     404,   405,  1088,  3708,   406,   830,   407,  1175,   709,   710,
     711,  1182,   820,  1046,   722,  1184,  3221,   822,   823,   713,
     714,   715,  2082,    78,  3086,  2083,  1565,   723,  1566,  2241,
    1567,  1568,  1569,  1570,  1571,  1711,   717,  1151,  1384,  1385,
    3087,  1387,    82,  1388,   411,  3900,  2050,  1426,  2772,  2068,
    2069
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      81,  1111,  1102,   366,   356,  1304,   357,  1581,  1650,  2019,
     359,  1656,  2059,  1220,   913,  2013,  2009,  1723,  1833,  1005,
    1603,  2654,  1676,  1339,  2424,    79,  1052,  2290,  1433,  1434,
    1435,  2301,   925,  1872,  1439,  1087,  2802,  2087,  2493,  1005,
     409,  1897,  1810,   908,  3501,  1084,   409,  2646,  1338,  1159,
    2127,  3184,  3186,  2768,  2176,  1220,  1859,  1595,  2511,  2115,
    1179,  1362,   964,  2614,  2503,  3378,   361,  1402,   979,  1201,
    1952,  2524,  3630,  3758,  3240,  3976,   410,   821,  1365,  1013,
    1972,  1026,   410,  3002,  1121,   867,  1799,   674,  1377,  1827,
     366,  3396,  1838,  2655,  2149,  2150,  1122,  3335,  2567,  2000,
    3934,  1864,  1285,  2706,  3640,   262,   719,  2491,  1940,  3022,
    2576,  1220,  1945,  2165,  2304,   410,   725,  1949,  1053,  2580,
    2581,  3990,   821,  2859,  1955,  2357,  2359,  2360,  3791,  3296,
    3793,  1105,  3889,  4207,  1974,   706,  4171,  1706,  3630,  2290,
    1113,  1708,  1163,  3487,  3696,  3889,  3903,  4375,  1397,  3637,
    1002,   919,   871,  3635,  3636,  4197,  4237,  4417,  1343,  1339,
     410,  1114,  4409,  4425,  2760,  1074,  3584,   927,  1353,  2502,
    1002,  4141,  2479,   706,  2721,  3048,  3045,  2049,  2044,  2402,
    4124,  2351,  2351,  4673,  1588,  2710,  4550,  1643,  1773,  1646,
    3069,   821,  2142,  2143,   917,   924,  1684,  1685,  2074,  4175,
    3707,  4139,  1154,  2248,   924,  4069,  1971,  1049,  3541,  3391,
    2001,  1749,   417,  2196,  4767,  1049,  1176,  1049,  2162,  1465,
    4340,   877,  3908,  3909,  3910,  3911,  3912,  3913,  2592,   410,
    3085,  1386,  4403,  -139,  3089,   408,  1092,  2202,  2001,  4859,
    2291,   408,  -139,  4416,   924,  1333,  4548,  -139,   413, -1582,
   -1582, -1582, -1582,  1697,  2505,  2587, -1582,  4855,  2703,  2936,
     868,  2418,  2205,  -376,  2505, -2637, -2637, -2637, -2637,  3488,
    1749,  2505, -2637,  3981,   408,  4770,  1698,  2419,  2107,  1740,
   -2637,  2001,  2061,  3455,  3337,  3457, -1592, -1592, -1592, -1592,
    2713,  2931,  2207, -1592,   417,  3318,  4335,   366,   356,  3940,
     357,  2001,  1893,    43,   359,  5030,  3701,  1422,    45, -1582,
    4371,   417,  1430,  1750,    37,    38,    39,    40,   271,   408,
      43,    44,  1471,  1699, -1801,    45,  4874,  2936,  2835,   417,
    2430, -1801,  2420,  2051,  4927,  3499,  2505,  2048, -1907, -1907,
   -1907, -1907,   409,    45,  2574, -1907,   272,   273,  4809,  2421,
      37,    38,    39,    40,  2626, -1447,   274,    44,  3132,  -782,
     361, -2638, -2638, -2638, -2638,  4813,  4910,  1572, -2638,  3027,
    1243,   825,  1750,  2171,  2194,  3291, -2638,   409,   410,  1887,
    1872,  1741, -2635, -2635, -2635, -2635,     3,  1574,   408, -2635,
    3541,  3147,  2172, -1592, -1592, -1592, -1592, -2635,  2239,   262,
   -1592,  1411,   928,  4557,  3292,  1416,  1417,  1418,  1449,   294,
    2971,  2627,  3928,   410,  2704,  1429,   825,  2972,   130,   131,
     314,   319,  2505, -2634, -2634, -2634, -2634,  2987,  1573,  1220,
   -2634,  3055,  4553, -1582, -1582, -1582, -1582, -1817, -2634,   334,
   -1582,   338,  2418,  2512, -1817,  4372,  3941,   355,  3028,  4847,
    2176, -2229, -2229, -2229, -2229,  1585,  1936,  1150, -2229,  1244,
    2002,  2292,  3489,  1048,  2505,  1431, -2229,  5031,  1727,  1339,
    4928,  1048,  3518,  1048,  2266,  1876,  2714,  2422,   360,  2279,
    2279,  4895,   675,  2193,   371,   825,  1882,  3346,  2002,  2020,
    3338,  4901,  1339,   913,  2037,  2797,  1423,  2202,  2236,  2803,
    1245,  2805,  1438, -2061,  2808,  5007,  4875,  2149,  2150, -1577,
   -1577, -1577, -1577,  2420,  2165,  1093, -1577,   835, -1549, -1549,
   -1549, -1549,  2205,  1742,  4926, -1549, -1562, -1562, -1562, -1562,
    2421,  2002,  4610, -1562,  2625,  5028,  2169,   408,  1178,  2282,
    2283,  2108,  1614,  3169,  1615,  2621,  1985,  1777,  2593,  1246,
    1122,  2002,  2207,  3235,  1157,  1158,  1743,   836,  4986,  1339,
    3832,  1719,  2705,  2105, -1589, -1589, -1589, -1589,  2937, -1577,
    1751, -1589,   408,  2423,  1687,  1690,  2063,  4190,  2117,  1148,
      37,    38,    39,    40,  2131,  1744,  2197,    44,  3982,  3889,
    4250,  2128,  3319,  2039,  4389,  2108,  4643,    37,    38,    39,
      40,  1693,  2588,  4543,    44,  2011,  1937,  4675,   247,  1608,
    2290,  2431,   271,  1609,  2142,  2143,  2465,  2813,  1438,  5103,
    2646,  2011,  2162,  2572,  3553,  2575,    37,    38,    39,    40,
     919,  3133,  2617,    44, -1801,  1735,  3604,  1155,  2467,  2137,
     272,   273,  2563,  1745,  2565,   216,  2473,  2043,  4689,   929,
     274,  1804,  3724,  2226,  2249,  2290,  2613,  3188,  2422,  3001,
    -139,  -139,  2535,  2644,  4141,  4632,  4633,  4634,  4635,  4636,
    4669,  3929, -1373,   917,  1597,   224,  3349,  1198,  2233,  4558,
    1231,  1339, -1582,  1156,  4025,  4398,  2171,  4499,  1450,  1339,
    1339,  4503,  2790,  4537,  4494,  4456,  2764,  2553, -2637,  1871,
    2556,  2557,  1191,   294,  2799,  2172,  2261,  3630,  3630, -2061,
    3698,  4228,   676,   234,   314,   319,  2513,   924,   924,  2173,
    2973,  1674,  1675,  2697,  2374,   237,  5023,  2338,  2514,  2339,
     930,  1102,   931,   334,  2814,   338,  1937,  3170,  1700,  1701,
    4894,   355,  3771,  2862,  3772, -1373,  1290, -1817,  1686,  4154,
    1651,  2798,  1295,  4252,  2423,  3183,   999,  1000,  1403,  3056,
    2809,  3263,  2482,  1422,  2622,  1150,   362,  4349,  4759,  1608,
   -2061, -1907,   360,  1609,  5008,  4769,  1280,  1135,   371,  2515,
    1473,  1616,  1422,  3541,  3865, -2061,  3160,  3868,  3869,  1350,
    1167,  3872,  1843,  2171, -2638,  1880,   409,  3875,  5069,  2698,
    1335,  4162,  1348,  3550,  3551,  3552,  3553,  3236,  3490,  3948,
    4203,  1163,  2172,  3754,  2064, -2635,  1115,  2066,  3914,  3145,
    2070,  3759,  2072,  2137,  1473,  2075,  2175,  3541,   410,  2079,
    1844,  3107,   410,  4400,  2773,  2044,  1187,   879,  3664,  2975,
    1404,  1440,  1410,  1136,  1415,  1187,   674,  1919,  4996,  1164,
    1419,  2780,   674,   362,  4845,  3098, -2634,  2783,  3670,  3161,
    4648,  3917,   674,  3870,  3871,  1395, -1582, -1549,  3071,  1665,
    3071,  2886,  2887,  1410,  1415,  1848,  3307,  1113,  1187,  1398,
    1598,  1849,  1849,   835, -2229,  3683,  2479,  3045,  2713,  3193,
     674, -1373,  1116,   831,   674,   832,  1473,  3160,  1114,  3541,
     366,  1137,  3887,  3108,  1138,   674,  4428,  4997,  1440,  2815,
    2223,  2224,  2225,  2226,  4676,  3887,  5056,  2542,    37,    38,
      39,    40,  2234,   836,  1336,    44,  4677,  2816,  1199,  2800,
     674,   818,  4240,  4178,  1187,  1101,   416,  1423,  1654,  2432,
   -1549,  1599, -1577,   417,  1187,   674,    37,    38,    39,    40,
     674,  2148,    43,    44,  1471,  1699,  1461,    45,   872,  2154,
     674,  1150,  2976,   924,  3543,    81,  4649,  1220, -2365,  1963,
    3161,  3370,  1689,  1408,   674,  1413,   818,  1850,  1850,  2699,
    2567,  1845,   819,  1396,  4861,  2493, -1373,   408,  2771,  3968,
      79,   408,  2700,  4641,  1139,  3988,  1619, -1589,  3921,  2716,
    1409,  3491,  1414,  1296,  1442,  1444,  1461,  1964,  3543,  3164,
    2114,  1391,  1428,  2199,  1584,   924,  2432,  1578,  1592,  4401,
    1755, -1373,  2794,  3544, -1373,  2194,  2234,   819,  4956,  3759,
    2237,  1443,  1445,  4962,  3922,  1108,  3755,  4952,  4725,  4259,
    1351,  2806,  2807,  4811,  2027,   818,  1881,  4666,  3923,  4735,
    1613,  4737,  4898,  4899,  1112,   993,  4822,  4728,  1187,  3007,
     362,  -599,  4732,   993,  1049,  4734,   674,  3544,  1049,  1846,
    3146,  4241,  2202,  1108,  4659,   994,  2354,  2856,  2858,  4678,
    3543,  1869,  2028,   994,   825,  1117,   410,  1165,  2866,  3229,
    1422,  1140,  2870,  1187, -2011,  2628,   819,  2205,  5057,  3667,
    2882,  2883, -2043,  1150,  4823,   706,  1324,  1666,  3990,  1207,
    1141,  4824,   417,  2900,  2902,    37,    38,    39,    40,  1851,
    3164,    43,    44,   993,  2916,  3992,    45,  2207,  1029,  2749,
    3924,  4287,  3371,  2629,  4862,   993,  2741,  4260,  4825,  3544,
    2540,  1473,  2355,   994,  3541,  3281,  1402,  2752,  2433,  5024,
    4569,  3282,  1852,   674,   674,   994,  1994, -2365,  1965,  2759,
    1473,  1423, -2062,  3541,  1679,  2650,  5058,   833,  2427,   724,
    2811,  1437,  2523,  4242, -2087,  4902,  4243,  5082,  2650,  1220,
    4097,  1853,   874,  1709,  2426,  5029,  4458,  2795,  4459,  5059,
    4892, -2639, -2639,  1058,  3548,  3549,  3550,  3551,  3552,  3553,
    2356,  3993,  2541,  3478,  5068,  1030,  1995,  2011,  5070,  4826,
    3372,  2427,  3642, -2365,  3643,  3630,  2796,  2355,  1737,  3630,
    4053,  2733,  4054,  3010,  4954,  2434,  4261,  2776,  1679,  1987,
    2739,  1136,  1870,  2029,  3545,  3546,  3547,  4264,  3548,  3549,
    3550,  3551,  3552,  3553,  1136,   408,  1966,  3283,  1438,  3074,
    5102,  1187,  4149,  2210,  2211, -1549,  2678,  3353,  2637,  2638,
    2314,  1108,  1187,  1325,  4518,  4536, -1549,  2523,  2148, -1549,
    1727, -1549,  5046,  3230,  4522,  2356,  4883,  2889,  3049,  1160,
   -1376,  2114,  4288, -2011,  2630,  1935,  1059, -1904,  4850,  1137,
    4880, -2043,  2651,  1139,  1102,  1996,  4851,  2315,  2311,  2214,
    4238,  2202,  1137,  5083,  3542,  2651,  4993,  4162,  4512,  2828,
    3548,  3549,  3550,  3551,  3552,  3553,  4460,  1201,  1326,  4521,
    1048,  2030,  1187,   826,  1048,  3543,  2205,  1220,   366,  2679,
    4314,  4050,  5094,   827,  3994,  4265,  4317,  4318,  3497, -2011,
    4055,  3769,  5080,  2428,  3543,  1997,  2505, -2043,  3188,  3290,
    4056, -2062,  3675, -1376,  2510,  4070,  2207,  4990,  4991,  3887,
    3192,   674,  4444, -2087,  2539,  1706,  3889,  4776,  1139,  1708,
    1700,  1701,  2631,  2673,  4827,  1639,   674,  1031,  1032,  4830,
      81,    81,  1139,    81,  3544,  4834,  2011,  2312,  1633,  3284,
    2317,  1187,  2240,  5048,  3995,  1139,  3458,  1994,  2358,   674,
    2297,  3453,  3452,  3544,  2508,    79,    79, -2062,    79,  2305,
    2306,  3541,  2310,  3262,  5117,  3747,  2065,  2389,  2067, -2087,
    4021,  2071,  3285,  2073,  1679,  1998,  2076,  2077,  2078,  1122,
    1114,  1114,   828,  1114,  3274,   674,  3264,  2618,  4739,  2085,
    3643,  2318,   417,  1641,  3267,  2493,  3269,  2775,  1935,  4852,
     674,  3286,  2110,  3748,  2111,  2509,  2114,  3340,  3401,  3402,
    3403,  3404,  1019,   674,  4787,  3313,   674,  1608,  1163,  5095,
    3409,  1609,  4932,  1654,  2953,  3498,  2674,  1187,  1027,  2652,
    4947,  1634, -2639,  2221,  2222,  2223,  2224,  2225,  2226,  3448,
    1391,  1139,  2652,  3645,  5111,  4623,  3646,  3647,  2653, -1376,
    3671,  4397,  2663,  3293,  4040,  5087,  1187,  3648,  3649,  3650,
    4184,  3651,  3652,  3719,  3770,  3205,  3653,  3654,  3655,  1210,
    1211,  1212,  1028,  1213,  1214,  1215,  1216,  1217,  1218,  2253,
    2254,  3812,  3294,  2567,  1187,  1187,  1996,  1187,  1082,    35,
    4524,  3160,  4624,  4433,  1106,  4434,  3833,    41,    42,  1057,
    2230,  3545,  3546,  3547,  1187,  3548,  3549,  3550,  3551,  3552,
    3553,   829,  3541,  3151,  4788,  2735,  3206,   875,  2558,  2289,
    3545,  3546,  3547,   884,  3548,  3549,  3550,  3551,  3552,  3553,
      37,    38,    39,    40,  4933,  3630,  1997,    44,   674,   891,
    3630,  2269,  3543,  3630, -1376,  4014,   674,   674,  4191,  2954,
    4860,  3024,  1107,  2955,  3749,  3287,  1187,   410,  5027,  1054,
    1104,  4210,  4775,  1220,  3161,  1243,  1679,   706,   706,  4652,
    3248,  1679,  1679,  2474,  3190,   409,   409,  4744,  4745, -1376,
    1967,  4203, -1376,  3813,  2371,  1187,  3173,  3492,  3288,  1187,
    1187,  2956,  4791,  3162,   818,  3990,  4132,   893,  1807,  4934,
    1968,   835,   891,  1128,  2460,  4701,  2573,  1095,  3656,  4653,
     410,   410,   410,   362,  1101,  3139,  1998,  3289,  2436,  1108,
    3249,  -940,  1201,  1129,  4133,   409,  3163,  2363,  2437,   216,
    2364,   674,  2393,  1130,  4211,  3480,  2255,  2289,  4904,  4505,
    2271,   836,  3750,   835,  2559,   819,  2560,  2366,  2367,  3969,
     969,  4135,  3973,  3595,  1244,  3596,  3493,  2475,  3083,   224,
     893,   410,  2221,  2222,  2223,  2224,  2225,  2226,   410,  1935,
    3174,  3250,   706,  2385,  2387,   410,  3730,  1608,  3597,  2272,
    2412,  1609,  1049,   836,  1724,  4982,  1807,  3427,  3914,  4212,
    2413,  4213,  5064, -2639,  3915,  1245,  1639,   234,  2256,  3207,
    4755,  3397,  4757,  4369,  3916,  2414,  4561,  4562,  2202,   237,
    2957,  4983,  2932,  4192,  3164,  1049,   408,  1725,  4203,  1089,
    2365,  4966,  1809,  1935,  1937,  3814,  -161,  4651,  4608,  4609,
    1679,  3917,  1131,  3918,   900,  1109,   901,  1243,  1679,  3657,
    3353,  1112,  4193,   247,  1246,  1969,  1726,  4668,  3746,  4137,
    3208,  -161,  1935,  3349,  4658,  3516,    80,  2357,  3815,  1953,
    3702,  4194,  3251,  2207,  1641,  4370,  1339,  2438,  3630,   408,
     408,   408,  3548,  3549,  3550,  3551,  3552,  3553,  3598,    37,
      38,    39,    40,  3599,  3658,  1737,    44,  3816,  1737,  1679,
    3639,  3442,  1679,  1679,  1132,  4554,   837,   900,  2202,   901,
    2439,  1642,   891,  1339,  3568,   674,  3919,  3119,   903,  4890,
    1858,  3255,  1317,   825,  -161,   876, -2429,  2736,  4628,   905,
     408,  4131,  1953,  2205,  1735,  1935,  1244,   408,  3466,   966,
    4020,  1590,  1118,  1737,   408,  3593,  4210,  1737,  2415,  -161,
    2279,  3115,  1318,   673,  2643,  3738,  4629,  2660,    37,    38,
      39,    40,  2259,  2207,  3777,    44,  1679,  4555,     8,  3120,
     893,  1133,  1935,  3920,  4225,  3252,  3255,  1245,  3921,  4208,
    2193,  1319,  3800,  3253,  1125,   891,  3254,  4929,  3659,  2818,
    1055,    37,    38,    39,    40,   410,  1813,  3801,    44,  4132,
    1935,    35,  2832,  -946,  1790,    37,    38,    39,    40,    41,
      42,  3600,    44,  1830,  3922,   674,  3760,   918,  1398,  4211,
    3119,  3601,  1735,   935,  4024,  1320,  1246,  4133,  3923,  1814,
    4786,   674,  1160,  3548,  3549,  3550,  3551,  3552,  3553,   366,
    1166,   825,  4134,   893,  3781,  -399,  1831,  4835,  1048,  1018,
    -502,  3665,  4347,  2944,  4135,  2945,  1177,  1187,  3017,  4525,
    3001,  4025,  3358,  1935,  2080,  1729,  1187,  3024,   674,   674,
    1122,  3952,  3727,  1594,  4212,  4836,  4213,  4136,  2946,   674,
    3961,  1048,  2314,    37,    38,    39,    40,  2081,  2607,  3763,
      44,   674,   674,  2831,  2854,  4229,  1192,  1790,  1730,   972,
      81,   366,  2824,    81,  2825,  2871,  4203,   900,  2826,   901,
    3924,  3359,  1697,   674,  2171,  1194,  4239,  4244,   973,  2315,
    3504,  2608,   417,  2396,  3194,    79,  3507,  1731,    79,  3610,
    4792,  2570,  1953,  2172,  2778,  1698,  2779,  4253,  1205,   216,
    2781,  1832,  2782,  3778,   122,  2784,  4032,  2173,  -399,  2785,
     974,   362,  4137,  1187,   408,  3805,  2397,  4071,  4072,   209,
    1339,   993,   126,  1168,  2827,  1390,   417,  2034,  3779,   224,
    2316,  2872,  3470,  2947,  4289,  1169,  1170,  3001,  2948,  1220,
     900,   994,   901,  2949,  2544,  2398,  3809,  2035,  1206,  3360,
    3361,  1187,  1187,  4305,  4290,  1171,  3887,  1639,  1172,  1187,
    3329,  1640,  1187,  3362,  4131,   906,  1187,   234,  1242,  2609,
    3349,  2880,  2317,  4306,  1187,  1187,  3711,   417,  2675,  3810,
    2564,  2610,  1187,  2135,  2934,  1187,  1187,  1187,  1187,  2873,
    4036,    45,  2874,  3824,    43,  1187,  1187,  2707,  1187,    45,
    1187,  1187,  1241,  2152,  1187,  2611,  4477,  3930,  3811,  3363,
    3676,   825,  4831,   247,  4538,  5045,  1233,  2525,  1042,  1619,
    1935,  1187,   410,  2318,  1284,  1641,  1187,  3347,  1081,  3631,
    1187,  4104,  4132,  2179,  1187,  1289,  1187,  1187,  1187,  1187,
    1187,  1187,  1187,  1187,  1187,  4476,  1187,  2191,  1339,  3109,
      35,  3112,  1187,  3716,  3717,  1187,  2558,  1732,    41,    42,
    4133,  2950,  1642,  2493,  4856,  2526,  2527,   206,   192,  4407,
    2045,  2951,  1173,  3737,  2046,  4134,   409,  1292,  2545,  3773,
    4035,  2548,  2875,    35,  2148,  4450,  2403,  4135,  1839,  3103,
    1733,    41,    42,   216,   209,  3631,  3364,  1317,  3365,  2523,
    4343,  4344,  4345,  3168,    37,    38,    39,    40,  3384,  1174,
    4136,    44,   410,    37,    38,    39,    40,  1187,  3513,  1734,
      44,  1840,  2770,   224,    74,  1841,  2596,  1318,  3406,  4729,
    2603,  1187,   409,  3407,   409,  1473,  1287,  2517,  3541,  2171,
    1187,  1187,  2244,  1112,  1112,  2245,  1112, -1385,   216,  3058,
    1842,  5115,  4205,  4206,  5116,  4098,  3950,  1630,  2172, -1385,
   -1373,   234,  1811, -1385,  3248,  3044,  3044,  1297,   410,  1298,
     410, -1420,  2175,   237,  1856, -1420,  1860,  1312,   224,  2876,
    1305,   408,  2559,  2289,  2560,  4137,    37,    38,    39,    40,
     674,  3353,  1735,    44,  2045,  1323,  3904,    45,  2767,  3827,
    1320,  3407,  3495,  -501,  1300, -1385,  1301,   247,    81,  4037,
      81,  1679,  2577,  1322,  3249,  2606,   234,   674,  4353,  3514,
    1331,   410,   674,  3515,  3246,   674,  1321, -1385,   237,  1816,
    1328,  1709,  3946,    79,   417,    79,  5071,   192,  1345, -1420,
    4438,  4439,  4440,   818,  1150,  2922,  4233,   674,  2925,  2525,
    1187,  2148,  2525,  2403,  1349,  2054,   918,  2055,  3171,  4730,
    3385,  1187,   247, -1166, -1385,  3250, -1166,  2134,  1187,   247,
    1872,   408, -1385,  2160,  2161,  1817, -1420,  2525,   825,   130,
     131,  1339,  3567,  1339,  3569,  3570,  4145,  1357,   674,  1004,
    2295,  4350,  2296,  1358,   819,  2525,   818,  2526,  2527,  1049,
    2526,  2527,  1372,  3226,   932,  1935,  3931,  1363,  3933,  1004,
    1935,  1935,  4620,   967,  4622,   674,   674,   216,  4625,  3543,
    4626,  2298,  1935,  2299,  3676,  2526,  2527,   408,  1378,   408,
    3939,  2523,  3942,    45,  2523,  4077,   972,  3676,   410,   674,
    2148,   410,  1727,  2526,  2527,  1436,  1339,   224,  2347,  2348,
    4150,  4152,  2769,  1818,  2770,   973,  3251,  3237,  1106,  2523,
    1393,   818,  1049,  1432,   674,  3256,  1452,  2148,   674,  2403,
   -1421,  3985,  2729,  2730, -1421,    35,   417,  2523,  3544,  1446,
     408,  2290,  1453,    41,    42,   234,   674,   974, -1385,  4806,
      45,  3398,  3046,  3047,  2525,  3386,   674,   237,  1679,  1458,
    3831,  1819,  2201,  1820,  1460,  2202,  1679,  1461,  1679,   674,
    3834,  1459,   819,  2566,  3001,  1462,  1107,    35,   417,   674,
    3256,    37,    38,    39,    40,    41,    42,    43,    44,  1463,
    2205,  5072,    45,  2791,  3387,  2792,  2206,  2525, -1421,  1464,
    4751,  1822,  2526,  2527,  3368,  4031,  1608,  2525,  1467,  1630,
    1609,  1473,  1468,  3644,  3541,    37,    38,    39,    40,  3252,
    2207,  1596,    44,  1187,  1608,  1935, -1907,  3253,  1609,  4310,
    3254,  4483,  2347,  3067,  3862, -1421,  2523,   825,  1470,  2793,
    1824,  2792,   410,  1108,  1593,  2526,  2527,  4230,  3256,  1600,
    2821,  4254,  2822,  3256,  1601,  2526,  2527,   408,  1602,  1282,
     408, -1553, -1553, -1553, -1553, -1442, -1442,  4685, -1553,  4596,
    4597,  2525,  4599,  3421,  3422,  1826,  1102,  3678,  3679,  2523,
    3739,  1201,  3592,  1620,  2525,  3256,  2263,  1607,  2525,  2523,
    1637,  3023,  4481,  3024,    37,    38,    39,    40, -1445, -1445,
    1935,    44,  1627,   674,   206,  3545,  3546,  3547,  1628,  3548,
    3549,  3550,  3551,  3552,  3553,  1048,  1340,   935,  1630,  2526,
    2527, -2639,   362, -1446, -1446,  2209,  4702,  4703,  4704,  4705,
     216,   818,  2526,  2527,  1631,  4426,  2526,  2527,  4337,  4338,
     674,  4341,  4342,  4343,  4344,  4345,  2210,  2211,  1187,  4346,
    3091,    80,  2822,  2523,   825,  1652,  3181,   825,  3182,  1109,
     224,  1653,  3242, -2639,  3243,  1663,  2523,  3619,  3620,  3621,
    2523,  1657,  1909,    37,    38,    39,    40,  3341,  1048,  3342,
      44,  3817,   819,  3819,   362,  3354,  1659,  3355,   674,  2121,
    2122,  1102,  2214,  1664,  1667,  3543,  2264,  1668,   234,  4355,
    1935,   408,   975,  1669,  3472,  2215,  2792,  1679,  1150,  1448,
     237,  3512,   674,  2770,  1670,  1671,  1187,  4341,  4342,  4343,
    4344,  4345,  1187,  1473,  3631,  3631,  3541,  4631, -1560, -1560,
   -1560, -1560,  3522,  1672,  2770, -1560,  1673,  3852,  1466,  1187,
    1187,  1680,  1681,  4484,   976,  1187,  3526,  1575,  2770,  1683,
    1712,  1587,  1340,  1589,  3544,  1715,  1721,  3574,  2443,  3530,
    1748,  2770,  3866,  3581,  1713, -1551, -1551, -1551, -1551,  1727,
    1187,  1187, -1551,  1753,  3531,  1187,  2770,  2942,  4357,  3557,
    1775,  2770, -2639,  4441,  3573,  1779,  2770,  1187,  1187,  1187,
    1187,  2444,  3578,  1804,  3579,   410,  1806,  3614,   825,  3615,
    1187,   410,  1807,  1187,  2445,  1187,  1812, -1554, -1554, -1554,
   -1554,  1815,  1835,  4617, -1554,  1187,  1187,  2446,  3616,  1187,
    3617, -1552, -1552, -1552, -1552,  1857,  1847,  3631, -1552,  1861,
     366,  2824,  1187,  2825,  1187,  4407,  1866,  2826,  1187,   673,
     673,  3676,  1867,  3794,  1710,  3795,  3798,  3979,  3799,  3980,
    4041,  4078,  2770,  4079,  1187,  2447,  4088,  4100,  4089,  2770,
    3194,  4176,  4180,  4177,  4181,  1187,  2448,  1187,  1187,  1187,
    4209,  4399,  2792,  2792,  4656,  1868,  2221,  2222,  2223,  2224,
    2225,  2226,  4482,  1877,  2822,  2449,  1636,   674,  1638,  4002,
    2450,  1187,  4545,  2827,  4546,  4551,  1875,  2792,   818,  4552,
    4504,  2792,  4507,  4465,  1187,  1674,  1675,  3543,  4613,   362,
    4614,  4670,  1679,  4671,  4711,  1873,  4712,  2201,  1723,  1187,
    2202,  3545,  3546,  3547,  1883,  3548,  3549,  3550,  3551,  3552,
    3553,  1187,  4713,  4721,  2770,  2822,  3682,  3682,  4773,  4832,
    4774,  2792,  4857,  1879,  4858,  2205,  4385,  4386,  1891,   819,
    4709,  2206,  1889,  4870,   408,  2822,  4877,  2451,  3024,  1894,
     408,  4045,  4882,  4884,  3959,  3959,  3544,  4923,  1896,  4924,
     674,  4955,  4960,  2258,  4961,  2207,  4971,  4972,  2822,  3579,
    4973,  4051,  2770,  1884,  1899,   674,   674,  4976,  2452,  3024,
    4978,  1187,  3959,  4995,  5001,  2822,  2822,  5002,  2771,  2822,
    5015,  4685,  5016,  5034,  1735,  3024,  4073,  1941,  5113,  4876,
    5114,  5124,   674,  5114,  1944,   674,   853,  1946,  1935,  4876,
    1937,  1956,  1957,  -182,  1959,  1961,  1973,  1975,  1981,  1983,
     853,  1991,  1999,  2004,  2005,  2006,  3539,  3540,  2008,  2007,
    2010,  3555,  2114,  2011,  2023,  2018,  2021,  2022,  2024,  2453,
    2026,   825,  2031,  2032,  2033,  2454,  2038,   825,  2455,  2052,
    1935,  1935,  1340,  1935,  2086,  2116,    80,    80,  2123,    80,
    2119,  2125,  2126,  4919,  2132,  2133,  2208,  2141,  2145,  2144,
    2209,  3590,  3591,  4619,  2456,  1340,  2146,  2147,  2151,  2231,
    2457,   247,   410,   410,   410,  2153,  2156,   818,  2157,  2158,
    2159,  2210,  2211,  2458,  2164,  2166,  2258,  4796,  2262,  2274,
    4803,   674,  2167,  2168,  2169,  2170,  2177,  2178,  2212,  1935,
    2180,  1935,   674,  2181,  2182,  1422,  2183,  2184,  2459,  2185,
    2112,   674,  2294,  3545,  3546,  3547,  2186,  3548,  3549,  3550,
    3551,  3552,  3553,  2303,  2187,  2284,  1640,  2214,   819,    74,
    2334,  1642,  1340,  2336,  2353,  2344,  2346,  1139,  2361,  2368,
    2215,  4530,  4977,  2370,  2381,  2372,  2383,  2380,  2388,  2390,
    1004, -2581,  1004,  2392,  1004,  1935,  2399,  2400,  2401,  2404,
    1004,  1420,  1421,  2405,  2406,   913,  2403,  2435,  2441,  2407,
    2408,  2429,  2462,  2466,   674,  2660,  2469,  4869,  2468,  2472,
    1935,  2470,  2471,  1004,  1004,  4000,  2497,  2498,  2505,  2507,
    2518,  1220,  2517,  2520,   818,  2521,  2522,   818,  2529,  2523,
    3881,  1935,  2532,  2530,  2531,  2195,  2536,  2537,  2543,  2554,
    2546,  2550,  3631,   410,  1935,  2200,  3631,  2217,  2551,  2561,
    2562,  2568,  2569,  1790,  2578,  2238,  1679,  1102,   674,  2579,
     674,   408,   408,   408,  2589,  2590,  2591,  2594,  1102,  1679,
    2619,  2595,   674,  2601,   674,   819,  2632,  4908,   819,  2620,
    2634,  4913,  4914,  4644,  1340,  2605,  2635,  2268,  2270,  2137,
    2647,  2645,  1340,  1340,  2148,  3964,  2154,  4925,  2648,  2661,
    2664,  2665,  2669,  1339,  3975,  2668,   886,  2676,  1935,  2672,
    4114,  4115,  4116,  4117,  1832,  2025,  2691,  4912,  4754,  4793,
    2696,  2711,  2712,   674,  1935,  3999,  2040,  2719,  2724,  2722,
    2725,  2732,  4909,  1004,  4915,  2743,  4917,  1935, -2639, -2639,
    2745,  2221,  2222,  2223,  2224,  2225,  2226,  4740,  2747,  2761,
    2726,  2762,  1702,   674,  2787,  2746,  2748,  2804,   825,   825,
     825,  2810,  2819,  2834,  2829,  2905,  2788,  1187,   818,  2861,
     674,  2867,  2862,  2917,  2904,  2923,  2202,   673,   924,  2928,
    2927,  2935,  2960,  2941,  2958,  2987,  3004,   674,  3006,  3014,
     674,  3003,  3009,  3011,  4387,  3015,  3025,  1004,  1107,  3038,
    3039,  3040,   408,  3053,   664,  3026,  1187,  3041,  3076,  1935,
    2248,  3092,  3073,  3075,  3090,  3093,  1187,  3094,  3105,   819,
    3110,  1679,  1187,  3113,  1187,  4796,  3115,  4083,  3117,  1935,
    1187,  3118,  3124,  1187,  1187,  1187,  1187,  1187,  1187,  1187,
    1187,  1187,  1187,  3140,  4323,  3144,  1187,  1187,  3129,  3134,
    3135,  3137,  3434,  3148,  1935,  3159,  3156,  3172,  3177,  1187,
    1590,  1594,  3179,  1187,  3233,   410,  3228,  1187,  3241,  3244,
    3245,  1756,  3257,  3295,  3298,  3309,  3316,  1187,  3320,  3321,
    1187,  3317,  1187,  3322,  3324,  4324,  3325,  3328,  4647,  3326,
    1935,  1187,  1187,  1187,  3327,  3334,  3336,  1187,  3343,   825,
    1187,  3345,  3350,  1757,  3351,  3348,  4846,  3349,  3356,  4325,
    1187,  1187,  3376,  3390,  3399,  3405,  3392,  3413,  3415,  2191,
    3408,  1187,  3414,  3416,  4326,  3424,  2571,  3426,  4327,  1187,
    3429,  1187,  4889,  2942,  1780,  3441,  3444,  3445,  3446,  3447,
    1781,  3449,  3450,  3464,  3465,  3459,  4872,  4328,  4762,  3462,
    4329,  3474,  3613,  2114,  3024,  3475,  3476,  3477,  3486,  1758,
    2039,  3479,  4330,  2835,  4274,  3624,  3494,  3500,  1438,  3502,
    3506,  3508,  3505,  3509,    74,    74,  1187,    74,  3528,  3510,
    1782,  3524,  1187,  3575,  3563,  3525,  3594,  4780,  1187,  2640,
    1759,  3527,  3529,  1004,  3532,  3533,  3535,  1339,  1220,  3538,
    3556,  3562,  3589,   362,  5090,  2770,  3564,  3565,  3572,  3609,
    3639,  3587,  3631,  1187,  3633,  3588,  3602,  3631,  3612,  3435,
    3631,   818,  3638,  3641,   408,  -986,  1760,   818,  3676,  1783,
    3685,  3624, -1448,  3694,  1101,  3688,  1784,  1220,  3684,  1785,
    4331,  3690,  3704,  3700,   674,  3718,  3715,  3706,  4332,  3226,
    3721,  4251,  3729,  2687,  3720,  3705,  1761,  3732,  3631,  3734,
    2045,  3741,  3756,  3709,  3757,  3710,  3767,  4560,  3725,  3726,
    3768,  3774,   819,  3775,  3822,  3783,  3785,  3823,   819,  3826,
    3828,  3829,  4333,   410,  3837,  3830,  3835,   410,  1935,   410,
    3836,  3838,  1786,  3839,  3840,  4574,  4052,  4779,  3841,  4057,
    4058,  4059,  4060,  4061,  4062,  4063,  4064,  4065,  4066,  3842,
    3843,  4587,  3844,  1679,  3846,  3845,  3847,  3848,  3850,  3855,
     209,   825,  4981,  3849,  1764,  3853,  3857,  4322,   674,  3859,
    1765,   674,  2587,  3861,  3867,  3873,    80,  1766,  3874,    80,
    1201,  3877,  3892,  3893,  2364,  2481,  3905,  3901,  3906,  1787,
    3938,  1788,  3937,  3944,  1768,  3947,  3949,  4604,  4106,  4107,
    3951,  1789,  1769,  3970,  3958,   410,  3965,  3971,  3959,  1790,
    3967,  3974,  3977,  3997,  4016,   369,  4027,  4017,  1791,  4018,
    4019,   369,  4022,  4028,  4006,  1004,   667,  4008,  4029,  4030,
    1004,  1004,  4039,  2134,  4044,  3631,  2366,  2367,  3559,  3541,
    3558,  4074,  4075,  4076,  4090,  1187,  2196,  4102,  2896,  4992,
    4082,  1792,  4147,  1770,   369,  1793,  4172,  3437,  3989,  4196,
    4130,  4103,  2896,  4111,  4217,  4144,  4219,  4220,   674,   674,
    4232,  4153,  1935,  4231,  4286,   674,  4165,  4255,  4234,  4256,
    1794,  4163,   408,  4186,  4170,  3631,   408,  2879,   408,  4245,
    4164,  4166,  4415,  4302,  4257,  4169,  4258,  4236,  4268,   369,
    4269,  4270,  4304,  4271,  2362,  4272,  1420,  1421,  1935,  1187,
    1187,  2977,  2327,  4273,  4240,  4307,  4313,  4315,  4316,  4339,
    4373,  4365,  3989,  4376,  4381,  2377,  4383,  4388,  4392,  2792,
    4393,  4396,  2384,  2386,  3999,  4395,  4410,  4989,  1795,  4412,
    4413,  4424,  4541,  4423,  4427,  1339,  1044,  4429,  4437,  4442,
    4445,  2114,  4446,   674,  1044,  4447,  1044,  4448,   818,   818,
     818,  4431,  4449,  4454,   408,  4461,  4457,  4462,   369,  4466,
    1187,  4941,  4539,  4467,  4470,  1679,  4500,  4496,  4474,   825,
    4468,  4508,  4498,   825,  4501,   825,  2734,  1220,  4469,  1004,
    4513,  4511,  4514,  2896,  4531,  2740,  4535,  1004,  4516,  2744,
    4517,  3008,  4540,  4542,  4547,  2750,  2751,  1187,  4556,   819,
     819,   819,  4548,  4567,  4570,  4571,  4577,  1187,  1187,  4595,
    1935,  4600,  2838,  2763,  4572,  1187,  1187,  4607,  4588,  4591,
    1187,  1935,  4627,  4630,  4637,   362,  1187,  1187,  4645,  4655,
    1187,  4650,  4657,  4661,   362,  4672,  4674,  4663,  1004,  4682,
    4683,  1004,  1004,  4680,  4691,  4699,  4707,  4708,  1187,  4710,
    4715,   825,  1187,  4717,  4718,   362,  4719,  4720,  4726,  2839,
    4736,  4733,  1187,  4742,  4746,  2201,  4748,  1187,  2202,  3644,
    4768,  4752,  4782,  4756,  4790,  4794,  4772,  4771,  4777,  1187,
    4801,  4807,  4783,  4372,  4532,  2203,  4789,  4814,  2840,   818,
    4816,  4817,  5022,  2205,  4819,  4820,   673,  4821,  4839,  2206,
    4840,  4368,  4838,  3631,    81,  1004,  4842,   369,  4527,  2841,
    4844,  4848,  1710,  4865,    80,  4849,    80,  1187,  4873,  4879,
    2842,  4639,  4888,  2207,  1108,  4905,  4930,  4896,  4935,    79,
    4939,  4940,  4942,  4944,  4945,  1935,  4950,  5051,  4957,  2843,
     819,  4958,   369,  4959,  2844,  4964,  4965,  4970,  4974,  4980,
    4975,  4985,  4987,  4910,   410,  5005,  4979,  5006,  4998,  5003,
    5009,  5014,  5011,  1935,  5019,  5020,  5025,  4155,  5047,  5026,
    5044,  5052,  5049,  5007,   674,  5055,  5062,  5008,  5063,  1935,
    5081,  5093,  5067,  5109,  5118,  5112,   674,  5122,  2114,  1120,
    2845,  2602,  1778,  1202,  3394,  3232,  3668,  2281,  3780,  1224,
    1589,  4249,  3308,  4319,  3876,  4921,  4795,  5004,  4841,  1238,
    4384,  2846,  4829,  2727,  4843,  3723,  4642,  5050,  3852,  4760,
    2191,  3473,  5089,  5012,  2208,  1935,  5010,  5061,  2209,  4953,
    4121,  4123,  3728,  4380,  3374,  4248,  3375,  1299,  3792,  2688,
     674,  1306,  3357,  3954,  5092,  5123,  5119,  4818,  3902,  2210,
    2211,  3880,  1316,  4781,  5065,  5000,  2671,  5053,  2114,  4784,
    5121,  1023,  2114,  2114,    74,  1679,  2212,    74,  2106,  3016,
     853,  4443,  1780,  4891,  3185,  4419,  4963,  3856,  1781,  4420,
    5074,  4478,  4479,  1187,  5120,  1604,  4948,  3019,  3673,  3020,
    4182,  2777,  2213,  4402,  1187,  2214,  1626,  2847,  3050,  4533,
    2300,  3469,  3674,  2848,  3052,  2053,  2330,  2201,  2215,  2849,
    2202,   818,  2331,   408,  1341,  3035,  3051,  2335,  1782,  3686,
    3699,  3687,  4125,  4495,  4881,  1612,  4506,  4122,  4183,  2340,
    4871,  4084,  4094,  5035,  5043,  2205,  5036,  3677,  2850,  3607,
    2851,  2206,  1935,  3519,  3605,  4179,  1153,  2986,  1993,  3998,
    3331,  3443,  2728,  3077,  5033,  2352,  1123,  2852,  3331,  1389,
    2345,  2113,   819,   674,  3068,  2207,  1691,  1783,  2868,  2869,
    3084,  1720,  3663,  1692,  1784,  1187,  2881,  1785,  4188,  1935,
    2884,  2885,  2853,  3081,  1187,  2217,  2201,  4189,  3082,  2202,
    4523,  2349,  2247,  4168,  3471,  2906,  1146,  2907,  2789,    83,
    3088,  1187,  1187,  2042,     0,  1187,     0,  4534,  1427,     0,
     825,     0,     0,     0,  2205,  3400,     0,     0,  1187,  2929,
    2206,  2930,     0,  1187,  1756,     0,  1187,     0,  2895,     0,
    1786,  1187,  1187,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2918,  3428,  2207,     0,     0,     0,     0,  1340,
       0,     0,     0,     0,     0,     0,  1757,     0,   674,     0,
     674,  4753,     0,     0,  1187,     0,  2208,  4750,     0,     0,
    2209,  2377,     0,     0,     0,  2218,  2219,  2220,     0,  2221,
    2222,  2223,  2224,  2225,  2226,     0,  1340,  1787,     0,  1788,
       0,  2210,  2211,     0,  4322,  1935,     0,     0,     0,  1789,
     664,   664,     0,  1187,     0,     0,     0,  1790,  2212,     0,
       0,     0,  1758,     0,     0,     0,  1791,     0,     0,     0,
    1679,     0,     0,     0,     0,     0,     0,     0,     0,   818,
       0,     0,   410,   818,   674,   818,     0,  2214,     0,     0,
       0,     0,     0,  1759,  3043,  3043,  1187,     0,     0,  2209,
    2215,     0,     0,  1793,     0,     0,     0,   369,     0,     0,
       0,   369,  2896,  2896,     0,  4833,     0,  2896,     0,     0,
    2210,  2211,     0,  3037,     0,   667,     0,     0,  1794,  1760,
     819,   667,   362,     0,   819,     0,   819,     0,     0,     0,
    1004,   667,  1780,     0,     0,     0,     0,     0,  1781,     0,
       0,  1187,     0,  1935,     0,     0,     0,  2896,  2896,  1761,
    1702,   818,    74,     0,    74,     0,  2214,     0,     0,   667,
       0,     0,     0,   667,   362,  1187,  1935,  2217,  1187,  2215,
    1187,     0,     0,     0,   667,     0,  1795,     0,  1782,     0,
       0,  4706,     0,     0,  3434,     0,     0,  1187,     0,     0,
       0,  1187,     0,     0,     0,     0,  1935,     0,     0,   667,
       0,     0,   819,  1756,     0,     0,     0,  4722,  4723,     0,
       0,     0,     0,   209,   667,  2480,     0,  1764,     0,   667,
       0,     0,     0,  1765,     0,     0,     0,  1783,     0,   667,
    1766,   408,   410,     0,  1784,  1757,  1935,  1785,  2481,     0,
    1935,  1935,     0,   667,     0,     0,     0,  1768,     0,     0,
       0,     0,     0,     0,  3451,  1769,     0,  2218,  2219,  2220,
       0,  2221,  2222,  2223,  2224,  2225,  2226,     0,     0,     0,
    3460,  3461,     0,  1340,  3463,     0,     0,  1187,  3624,     0,
    3467,     0,  3624,     0,     0,     0,     0,  5108,  4951,     0,
    1786,  1758,     0,     0,     0,     0,  1187,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1770,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1935,  1004,     0,     0,
       0,     0,  1759,  4969,   362,  1004,     0,  1004,   825,     0,
       0,     0,     0,  1044,     0,   667,     0,  1044,     0,     0,
    2221,  2222,  2223,  2224,  2225,  2226,  1187,  1787,     0,  1788,
       0,  3435,  3503,     0,     0,   369,     0,     0,  1760,  1789,
       0,     0,     0,  1187,     0,  3434,     0,  1790,     0,     0,
       0,     0,     0,     0,     0,     0,  1791,     0,     0,     0,
       0,     0,   674,     0,  1756,     0,     0,     0,  1761,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1340,     0,     0,     0,     0,     0,     0,  1187,  1836,
       0,     0,     0,  1793,     0,  3352,  1757,   366,  5076,  1187,
    5077,     0,   667,   667,  5078,     0,     0,     0,     0,     0,
       0,  4868,     0,     0,     0,     0,     0,     0,  1837,     0,
    1187,  1187,     0,   674,     0,     0,     0,     0,     0,     0,
       0,     0,   209,  1187,     0,     0,  3436,   366,  5076,     0,
    5077,     0,  1765,     0,  5078,     0,     0,     0,  5066,  1766,
       0,     0,  1758,     0,     0,     0,     0,  2481,     0,     0,
    5079,     0,     0,     0,  3797,     0,  1768,  5099,   825,     0,
       0,     0,     0,     0,  1769,  1187,  1795,     0,     0,     0,
       0,   366,  5076,  1759,  5077,  1187,     0,     0,  5078,     0,
     818,     0,     0,     0,     0,  3825,     0,     0,     0,     0,
    5079,     0,     0,     0,     0,   410,     0,     0,     0,     0,
       0,     0,  3435,     0,  5099,     0,     0,     0,     0,  1760,
       0,     0,  5099,  2201,     0,  1770,  2202,     0,     0,  3437,
    5100,     0,     0,     0,   370,     0,     0,     0,     0,     0,
     370,   819,     0,  3854,  5079,   668,  1004,  1187,   664,  1761,
       0,  2205,   410,     0,     0,     0,  1187,  2206,     0,     0,
     410,     0,   671,     0,     0,  3331,     0,     0,  3331,  3331,
       0,  2201,  3331,   370,  2202,     0,     0,  5100,  3331,     0,
       0,  2207,     0,     0,     0,  5100,     0,  3890,     0,     0,
       0,     0,     0,  3899,     0,     0,     0,     0,     0,  2205,
    3890,     0,     0,     0,     0,  2206,     0,     0,     0,     0,
     667,     0,     0,   209,  1340,     0,  1340,  1764,   370,  3733,
       0,     0,     0,  1765,     0,   667,     0,     0,  3624,  2207,
    1766,     0,     0,  3624,     0,     0,  3624,     0,  2481,     0,
    1006,     0,     0,     0,     0,     0,     0,  1768,   667,     0,
       0,     0,  3957,     0,     0,  1769,     0,     0,     0,     0,
    1006,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,  2895,  2895,     0,     0,     0,  2895,  3984,  1340,
       0,     0,  2208,     0,   667,     0,  2209,   370,     0,     0,
       0,  3603,     0,     0,     0,     0,     0,     0,  3784,   667,
    3786,     0,     0,     0,     0,     0,  1770,  2210,  2211,     0,
    3437,   408,   667,     0,     0,   667,     0,  2895,  2895,   408,
       0,     0,  2600,     0,  2212,     0,     0,     0,     0,     0,
   -2639,     0,  2896,     0,  2209,  2896,  2896,  2896,  2896,  2896,
    2896,  2896,  2896,  2896,  2896,     0,  2377,     0,     0,  3666,
    2213,  1004,     0,  2214,     0,  2210,  2211,     0,     0,     0,
       0,   825,     0,     0,     0,  2896,  2215,     0,     0,     0,
       0,     0, -2639,     0,     0,  3681,  3681,     0,     0,     0,
       0,     0,     0,     0,     0,   362,     0,     0,     0,     0,
       0,     0,  3851,     0,  2896,  2896,     0,     0,  3858,     0,
       0,  2214,     0,     0,     0,     0,     0,     0,   825,     0,
       0,     0,     0,     0,  2215,     0,   825,     0,     0,  1780,
       0,     0,  2677,     0,     0,  1781,     0,     0,     0,     0,
       0,     0,  4095,     0,     0,     0,   370,   667,  2600,     0,
       0,     0,     0,  2217,     0,   667,   667,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   369,     0,     0,     0,
       0,  3624,     0,     0,     0,  1782,     0,     0,   818,     0,
       0,   370,     0,     0,     0,     0,  2742,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4160,     0,     0,     0,
       0, -2639,     0,     0,     0,     0,     0,     0,  2201,  2600,
       0,  2202,     0,     0,     0,     0,     0,     0,     0,   369,
     369,   369,     0,     0,  1783,     0,     0,     0,     0,   819,
    1756,  1784,     0,     0,  1785,     0,  2205,     0,     0,     0,
     667,     0,  2206,  2218,  2219,  2220,     0,  2221,  2222,  2223,
    2224,  2225,  2226,     0,  4001,     0,     0,     0,  4004,  4005,
       0,  4007,  1757,  4009,  4010,     0,  2207,     0,     0,     0,
     369,     0,  4015,     0,     0,     0,     0,   369,   362,     0,
       0,     0,     0,     0,   369,     0,     0,  1786,     0,  2201,
       0,  1044,  2202,     0,     0,  2221,  2222,  2223,  2224,  2225,
    2226,     0,     0,     0,     0,     0,     0,  4033,     0,  2203,
       0,     0,     0,     0,     0,     0,     0,  2205,  1758,     0,
       0,     0,     0,  2206,  1044,     0,     0,     0,  4108,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   818,     0,
       0,     0,     0,     0,  1787,     0,  1788,  2207,     0,  1759,
       0,     0,     0,     0,  3890,     0,  1789,     0,     0,     0,
       0,     0,     0,     0,  1790,     0,     0, -2639,     0,     0,
       0,  2209,     0,  1791,     0,     0,     0,  4275,     0,     0,
    4276,     0,  4277,     0,     0,  1760,     0,     0,     0,   819,
       0,     0,  2210,  2211,     0,  1004,     0,     0,     0,     0,
    3894,  3897,     0,     0,     0,     0,  1862,     0,  1004, -2639,
    1793,     0,     0,     0,   667,  1761,     0,  2896,     0,     0,
       0,  3331,     0,     0,     0,     0,     0,  3331,  3331,     0,
    2640,     0,     0,     0,     0,  1863,     0,     0,  2214,  3943,
       0,     0,  1762,     0,     0,     0,     0,     0,  2208,     0,
    3899,  2215,  2209,     0,     0,     0,     0,     0,   362,     0,
       0,  4352,  4354,  4356,  4358,     0,     0,     0,     0,     0,
     362,     0,     0,  2210,  2211,  1763,     0,     0,     0,   209,
       0,     0,     0,  1764,     0,     0,     0,     0,     0,  1765,
    2212,     0,     0,  1795,   369,     0,  1766,  1780,     0,     0,
       0,     0,     0,  1781,  1767,     0,     0,     0,     0,     0,
    5107,     0,     0,  1768,   667,     0,  2213,     0,     0,  2214,
       0,  1769,     0,     0,     0,     0,     0,     0, -2639,     0,
     667,  4418,  2215,     0,     0,  2216,     0,     0,     0,     0,
       0,     0,     0,  1782,     0,     0,     0,   664,     0,     0,
       0,     0,     0,     0,   362,     0,     0,     0,     0,     0,
    1004,     0,     0,     0,     0,     0,     0,   667,   667,     0,
       0,     0,  1770,     0,  3095,     0,     0,     0,   667,  3099,
       0,     0,  3102,     0,     0,     0,     0,     0,     0,     0,
     667,   667,  1783,  4452,     0,     0,   370,  2896,  2896,  1784,
     370,     0,  1785,     0,  3125,     0,     0,     0,     0,  2217,
       0,     0,   667,     0,   668,     0,     0,     0,     0,     0,
     668,     0,  2221,  2222,  2223,  2224,  2225,  2226,     0,     0,
     668,   818,  2895,     0,     0,  2895,  2895,  2895,  2895,  2895,
    2895,  2895,  2895,  2895,  2895,  3175,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1786,     0,     0,   668,     0,
       0,     0,   668,     0,     0,  4081,     0,     0,     0,     0,
       0,     0,  3189,   668,     0,     0,     0,     0,   818,     0,
       0,     0,   819,     0,     0,     0,   818,     0,     0,     0,
       0,     0,     0,     0,  2895,  2895,  3222,     0,   668,  2218,
    2219,  2220,     0,  2221,  2222,  2223,  2224,  2225,  2226,     0,
       0,  3012,  1787,   668,  1788,     0,     0,  3013,   668,  4528,
    4529,  3247,     0,     0,  1789,  3258,     0,     0,   668,   819,
       0,     0,  1790,     0,     0,     0,     0,   819,     0,     0,
      80,  1791,   668,  3270,     0,     0,     0,     0, -2145,     0,
       0,     0,     0,  3279,  4185,     0,     0,     0,     0,     0,
       0,   369,     0,     0,     0,     0,  3303,     0,     0,     0,
       0,  1006,     0,  1006,  2463,  1006,  3310,     0,  1793,     0,
       0,  1006,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -2145,     0,     0,     0,     0,
       0,     0,     0,  2464,  1006,  1006,     0, -2145,     0,  4432,
       0, -2145,     0,     0,     0,     0, -2145,  4435,  4436,     0,
       0, -2145,     0,     0, -2145,     0, -2145,     0,     0,     0,
       0,    35,     0,     0,   668,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,  2201,     0,     0,  2202,     0,
       0,   369,  1004, -2145,   370,     0,     0,     0,     0,  4602,
    4603,  1795,     0,     0,     0,  2203,     0,     0,  2204,  3331,
    3331,     0,     0,  2205,  1004, -2145,  1340,     0,     0,  2206,
    4621,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3899,  3899,  3899,  3899,  3899,
       0,     0,     0,  2207,     0,     0,     0,   369,     0,   369,
       0,     0, -2145,     0,     0,     0,     0,     0,     0,     0,
   -2145,   668,   668,     0,  1006,     0,     0,     0,     0,   667,
       0,     0,     0,     0,     0,  1420,  1421,     0,   671,   671,
       0,     0,     0,  1707,  4336,     0,     0,     0,  3897,     0,
    4665,     0,     0,     0,     0,     0,   667,  2896,     0,  4351,
     369,   667,     0,     0,   667,     0,  2896, -2145,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4684,     0,     0,
       0,     0,     0,  2896,  2896,  3485,   667,     0,  1006,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4452,  4452,  4452,  4452,  2208,     0,     0,  2895,  2209,  3485,
       0,     0,  1019,     0,     0,     0,     0,     0,     0,     0,
       0,  4559,     0,     0,     0,     0,     0,   667,     0,  2210,
    2211,     0,     0,     0,     0,     0, -2145,     0,  1044,     0,
       0,     0,     0,     0,     0,     0,  2212,     0,     0,     0,
       0,     0,  4575,  4576,   667,   667,     0,     0,     0, -2145,
       0, -2145, -2145,     0,     0,     0,  1930,     0,     0,     0,
       0,     0,  2213,     0,  1004,  2214,     0,   369,   667,     0,
     369,     0,     0,     0,     0,     0,     0,     0,  2215,     0,
       0,  2216,     0,     0, -2145,     0,     0, -2145, -2145,     0,
   -2145,  1044,     0,   667,     0,     0,  2201,   667,     0,  2202,
       0,     0,     0,     0,  4605,  4606,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   667,  2203,     0,     0,   668,
       0,  3890,     0,     0,  2205,   667,     0,     0,     0,     0,
    2206,     0,     0,     0,   668,     0,     0,     0,   667,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   667,     0,
       0,  3331,     0,     0,  2207,  2217,     0,   668,     0,     0,
    1340,     0,     0,     0,  4799,     0,  4800,     0,     0,  4804,
    4805,     0,     0,     0,  1006,     0,     0,  2895,  2895,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   668,     0,     0,     0,  2896,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2377,   668,     0,
       0,   369,     0,     0,     0,     0,     0,  1780,     0,  1930,
       0,   668,     0,  1781,   668,     0,     0,  4695,    74,  4696,
    4697,     0,  1004,     0,     0,     0,     0,     0,     0,     0,
    4700,     0,     0,     0,     0,  2218,  2219,  2220,     0,  2221,
    2222,  2223,  2224,  2225,  2226,  2208,     0,  3712,  2201,  2209,
       0,  2202,     0,  1782,     0,     0,     0,     0,     0,     0,
       0,     0,   667,     0,     0,     0,     0,     0,  2203,     0,
    2210,  2211,     0,     0,  1004,     0,  2205,     0,     0,     0,
    2201,     0,  2206,  2202,     0,     0,     0,  2212,     0,  3735,
       0,  4585,  4586,     0,     0,     0,  4589,  4590,     0,   667,
    2203,     0,  1783,     0,     0,     0,  2207,     0,  2205,  1784,
       0,     0,  1785,  2213,  2206,     0,  2214,     0,     0,     0,
     666,     0,     0,     0,     0,     0,     0,     0,  4922,  2215,
       0,     0,  2216,     0,     0,     0,   668,     0,  2207,     0,
       0,     0,     0,     0,   668,   668,     0,   667,   816,     0,
       0,     0,  2267,     0,  1004,   370,  1006,     0,     0,     0,
       0,  1006,  1006,     0,     0,  1786,     0,     0,     0,     0,
       0,   667,     0,  3897,  3897,  3897,  3897,  3897,     0,     0,
       0,  1004,     0,     0,     0,     0,     0,     0,  3802,     0,
       0,     0,     0,   816,     0,     0,     0,     0,     0,  3820,
       0,     0,     0,     0,     0,     0,  2217,  2208,   370,   370,
     370,  2209,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1787,     0,  1788,     0,     0,     0,     0,   668,
       0,     0,  2210,  2211,  1789,     0,     0,     0,     0,  2208,
    1043,     0,  1790,  2209,     0,     0,   671,     0,  1043,  2212,
    1043,  1791,     0,     0,   369,     0,     0,     0,  1340,   370,
     369,     0,   816,     0,  2210,  2211,   370,     0,     0,     0,
       0,  3863,     0,   370,     0,  2213,     0,     0,  2214,     0,
    1930,  2212,     0,     0,  2533,     0,     0,  4867,  1793,     0,
       0,  2215,     0,     0,  2216,     0,  2218,  2219,  2220,     0,
    2221,  2222,  2223,  2224,  2225,  2226,     0,  2213,     0,     0,
    2214,     0,  3534,  2534,     0,     0,     0,     0,     0,  1780,
    1006,     0,     0,  2215,     0,  1781,  2216,  2895,  1006,     0,
       0,     0,     0,     0,  1930,     0,  4714,     0,     0,     0,
       0,  2201,     0,  4893,  2202,     0,   667,     0,     0,     0,
       0,     0,     0,  2895,  2895,     0,  4749,     0,     0,     0,
       0,  2203,     0,  1930,     0,  1782,     0,     0,  2217,  2205,
       0,  1795,     0,     0,     0,  2206,     0,  4920,     0,  1006,
       0,     0,  1006,  1006,     0,     0,  1932,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2207,
    2217,  5101,     0,   668,     0,     0,     0,     0,     0,  1004,
       0,     0,     0,     0,  1783,     0,     0,     0,     0,     0,
    2600,  1784,     0,     0,  1785,     0,     0,     0,     0,   667,
       0,     0,     0,  1780,     0,     0,  1930,  4023,     0,  1781,
       0,     0,     0,     0,   667,   667,  1006,     0,  5101,     0,
       0,     0,     0,     0,     0,  1930,  5101,  4034,  2218,  2219,
    2220,     0,  2221,  2222,  2223,  2224,  2225,  2226,     0,     0,
       0,   667,  2926,  1930,   667,     0,     0,  1786,     0,  1782,
       0,     0,     0,   370,     0,     0,     0,     0,     0,     0,
    2218,  2219,  2220,     0,  2221,  2222,  2223,  2224,  2225,  2226,
    2208,  1930,     0,   668,  2209,     0,  3582,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   668,
       0,     0,     0,     0,     0,  2210,  2211,     0,  1783,     0,
       0,     0,     0,     0,  1787,  1784,  1788,     0,  1785,     0,
       0,     0,  2212,     0,     0,     0,  1789,     0,     0,  1932,
       0,   369,   369,   369,  1790,     0,   668,   668,     0,     0,
       0,     0,     0,  1791,  1930,     0,     0,   668,  2213,     0,
     667,  2214,     0,     0,     0,     0,     0,  2895,     0,   668,
     668,   667,     0,     0,  2215,     0,  2201,  2216,     0,  2202,
     667,  1786,     0,     0,     0,     0,  3191,     0,     0,     0,
    1793,   668,     0,     0,     0,     0,  2203,     0,     0,     0,
       0,     0,     0,     0,  2205,     0,     0,     0,     0,     0,
    2206,  2201,     0,     0,  2202,  1794,     0,     0,     0,     0,
       0,  5086,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2203,     0,     0,  2207,     0,     0,     0,  1787,  2205,
    1788,     0,     0,   667,     0,  2206,     0,     0,     0,     0,
    1789,  2217,  2201,     0,     0,  2202,     0,     0,  1790,     0,
       0,     0,     0,     0,     0,     0,     0,  1791,     0,  2207,
       0,     0,  2203,  1795,     0,     0,     0,     0,     0,     0,
    2205,     0,   369,     0,     0,     0,  2206,  4967,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   667,     0,   667,
    3272,  4226,     0,     0,  1793,     0,     0,     0,     0,     0,
    2207,   667,     0,   667,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3273,
       0,     0,     0,     0,     0,  2208,     0,     0,     0,  2209,
     370,  2218,  2219,  2220,     0,  2221,  2222,  2223,  2224,  2225,
    2226,  1930,     0,     0,     0,  3891,     0,     0,     0,     0,
    2210,  2211,   667,     0,     0,     0,     0,     0,     0,     0,
    2208,     0,     0,     0,  2209,     0,     0,  2212,     0,     0,
       0,     0,     0,     0,     0,  4291,     0,  1795,  4294,     0,
       0,     0,   667,     0,     0,  2210,  2211,     0,     0,     0,
       0,     0,     0,  2213,     0,     0,  2214,     0,     0,   667,
    1932,  2208,  2212,     0,     0,  2209,     0,     0,     0,  2215,
       0,     0,  2216,     0,     0,     0,   667,     0,     0,   667,
     370,     0,     0,     0,     0,     0,  2210,  2211,  2213,     0,
       0,  2214,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   816,     0,  2212,  2215,     0,     0,  2216,     0,     0,
       0,     0,     0,     0,  2496,     0,     0,     0,     0,   666,
       0,     0,     0,     0,     0,   666,     0,     0,     0,  2213,
       0,     0,  2214,     0,     0,   666,   370,     0,   370,  5098,
       0,     0,  4390,  1932,     0,  2215,  2217,     0,  2216,     0,
       0,     0,     0,     0,   369,     0,     0,     0,   668,     0,
       0,     0,     0,   666,  1780,     0,     0,   666,     0,     0,
    1781,  1006,     0,     0,     0,   671,     0,     0,   666,     0,
       0,  2217,     0,     0,     0,   668,  5098,     0,     0,   370,
     668,  1707,     0,   668,  5098,     0,     0,     0,     0,     0,
       0,     0,     0,   666,     0,     0,     0,     0,     0,     0,
    1782,     0,     0,     0,     0,   668,  1932,     0,   666,     0,
    3485,     0,  2217,   666,     0,     0,     0,     0,     0,  2201,
       0,     0,  2202,   666,     0,  1932,  2218,  2219,  2220,     0,
    2221,  2222,  2223,  2224,  2225,  2226,     0,   666,     0,     0,
    4046,     0,     0,  1932,     0,     0,   668,  2205,  1780,  1783,
       0,     0,     0,  2206,  1781,     0,  1784,     0,     0,  1785,
       0,  2218,  2219,  2220,     0,  2221,  2222,  2223,  2224,  2225,
    2226,  1932,     0,   668,   668,  4093,  1930,  2207,     0,     0,
       0,  1930,  1930,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1930,  1782,     0,   370,   668,  1552,   370,
       0,     0,  2218,  2219,  2220,     0,  2221,  2222,  2223,  2224,
    2225,  2226,  1786,     0,     0,     0,  4198,     0,     0,     0,
       0,  2201,   668,   667,  2202,     0,   668,  1043,     0,   666,
       0,  1043,     0,  1623,  1932,     0,     0,     0,     0,  4109,
       0,  2203,     0,  1783,   668,     0,     0,     0,  1006,  2205,
    1784,     0,     0,  1785,   668,  2206,  1006,     0,  1006,     0,
       0,     0,   369,     0,     0,     0,   369,   668,   369,  1787,
       0,  1788,     0,     0,     0,     0,     0,   668, -2639,  2207,
       0,  1789,  2209,     0,     0,     0,     0,     0,     0,  1790,
       0,     0,     0,     0,     0,     0,     0,     0,  1791,     0,
       0,     0,     0,  2210,  2211,     0,  1786,   667,     0,     0,
     667,     0,     0,     0,     0,     0,   666,   666,     0,     0,
   -2639,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3311,     0,     0,     0,  1793,  1930,     0,     0,     0,
     370,  4582,     0,     0,   369,     0,     0,     0,     0,  2214,
       0,     0,     0,  4592,     0,     0,     0,     0,     0,     0,
    3312,     0,  2215,  1787,     0,  1788,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1789,     0,     0,     0,     0,
    2208,     0,     0,  1790,  2209,  2201,     0,     0,  2202,     0,
       0,     0,  1791,     0,     0,     0,     0,     0,     0,     0,
       0,   668,     0,     0,     0,  2210,  2211,   667,   667,     0,
       0,  1930,     0,  2205,   667,     0,     0,     0,  1795,  2206,
       0,  2201,  2212,     0,  2202,  3761,     0,     0,     0,  1793,
       0,  1932,     0,     0,     0,     0,     0,     0,   668, -2639,
       0,  2203,     0,  2207,     0,     0,     0,     0,  2213,  2205,
       0,  2214,     0,     0,  3762,  2206,     0,     0,     0,     0,
       0,     0,     0,     0,  2215,     0,  2998,  2216,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2207,
       0,     0,     0,     0,     0,     0,   668,     0,     0,     0,
       0,     0,   667,     0,     0,     0,     0,  1006,     0,     0,
       0,     0,     0,     0,     0,  4112,     0,     0,     0,     0,
     668,  1930,  1795,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2201,   666,     0,  2202,     0,     0,     0,
    3485,     0,     0,  2221,  2222,  2223,  2224,  2225,  2226,   666,
       0,  2217,     0,  2203, -2639,     0,     0,     0,  2209,     0,
       0,  2205,     0,     0,     0,     0,     0,  2206,     0,     0,
       0,     0,   666,     0,     0,     0,     0,     0,     0,  2210,
    2211,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2208,  2207,     0,     0,  2209,     0, -2639,     0,     0,     0,
       0,     0,     0,   370,     0,     0,     0,     0,   666,   370,
       0,     0,     0,     0,     0,  2210,  2211,     0,     0,     0,
       0,     0,     0,   666,     0,  2214,     0,  2139,     0,     0,
       0,     0,  2212,     0,     0,  3485,   666,  3485,  2215,   666,
       0,  2218,  2219,  2220,     0,  2221,  2222,  2223,  2224,  2225,
    2226,     0,     0,     0,     0,  4455,  2163,     0,  2213,     0,
       0,  2214,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2215,     0,     0,  2216,     0,     0,
       0,     0,     0,     0,  2188,  2189,     0,  2192,     0,     0,
       0,     0,  2208,     0,     0,   668,  2209,     0,     0,     0,
       0,     0,     0,     0,  2232,     0,     0,     0,     0,     0,
       0,     0,  1006,   369,     0, -2639,     0,  2210,  2211,     0,
       0,     0,     0,     0,     0,     0,  3180,     0,     0,     0,
       0,  2496,  3187,   667,  2212,     0,     0,     0,     0,     0,
       0,     0,     0,  1932,     0,   667,     0,     0,     0,     0,
       0,  2217,     0,     0,     0,     0,  2286,     0,     0,     0,
    2213,   666,     0,  2214,     0,     0,     0,     0,     0,   666,
     666,     0,     0,     0,     0,     0,  2215,     0,   668,  2216,
     816,     0,     0,     0,     0,  2309,     0,     0,     0,  2321,
    2326,     0,     0,   668,   668,     0,     0,     0,     0,   667,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2221,
    2222,  2223,  2224,  2225,  2226,     0,     0,     0,     0,     0,
     668,     0,     0,   668,     0,     0,     0,     0,     0,     0,
    1780,     0,     0,   816,     0,     0,  1781,     0,     0,  1930,
       0,  2218,  2219,  2220,     0,  2221,  2222,  2223,  2224,  2225,
    2226,     0,     0,  2217,   666,  4489,     0,     0,     0,  2201,
       0,  1816,  2202,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1782,     0,     0,  2203,
       0,  1930,  1930,     0,  1930,     0,  1932,  2205,     0,     0,
       0,     0,     0,  2206,     0,     0,     0,     0,   816,     0,
     370,   370,   370,     0,     0,  1043,     0,  1817,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2207,     0,   668,
       0,     0,   667,     0,     0,  1783,     0,     0,     0,     0,
     668,     0,  1784,     0,     0,  1785,     0,     0,  1043,   668,
    1930,     0,  1930,  2218,  2219,  2220,     0,  2221,  2222,  2223,
    2224,  2225,  2226,     0,     0,     0,     0,  4716,     0,     0,
       0,  2496,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2201,
       0,     0,  2202,     0,     0,  1818,     0,     0,  1786,     0,
       0,     0,     0,     0,     0,     0,  1930,     0,     0,  2203,
       0,     0,   668,     0,     0,     0,     0,  2205,     0,     0,
       0,     0,     0,  2206,     0,     0,     0,   667,  2208,   667,
       0,  1930,  2209,     0,     0,     0,     0,     0,   666,     0,
       0,     0,     0,  1819,     0,  1820,     0,  2207,     0,     0,
       0,   370,  1930,  2210,  2211,  1821,  1006,  1788,     0,     0,
       0,     0,     0,     0,     0,  1930,   668,  1789,   668,  1006,
    2212,  1932,     0,     0,     0,  1790,     0,     0,     0,     0,
     668,     0,   668,  1822,  1791,     0,     0,     0,     0,     0,
    3485,     0,     0,     0,     0,     0,  2213,     0,     0,  2214,
       0,   369,     0,   667,     0,     0,     0,  2201,     0,     0,
    2202,     0,  2215,     0,     0,  2216,     0,  1823,   816,     0,
       0,  1793,  1824,     0,     0,     0,     0,  2203,     0,  1930,
       0,   668,     0,     0,     0,  2205,     0,     0,   666,     0,
       0,  2206,     0,     0,     0,  1930,  1825,     0,  2208,     0,
       0,     0,  2209,     0,   666,     0,     0,  1826,  1930,     0,
       0,   668,     0,     0,     0,  2207,     0,     0,     0,     0,
       0,     0,     0,  2210,  2211,     0,     0,     0,   668,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2217,
    2212,   666,   666,     0,     0,   668,     0,     0,   668,     0,
       0,  1780,   666,     0,  1795,     0,     0,  1781,     0,     0,
       0,     0,     0,     0,   666,   666,  2213,     0,     0,  2214,
       0,  1006,     0,     0,     0,     0,     0,     0,     0,     0,
    1930,     0,  2215,     0,     0,  2216,   666,     0,  2998,  2998,
    2998,     0,     0,     0,     0,     0,     0,  1782,     0,     0,
    1930,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   369,     0,     0,     0,     0,  2208,     0,     0,     0,
    2209,     0,     0,   370,     0,  1930,     0,     0,     0,  2218,
    2219,  2220,     0,  2221,  2222,  2223,  2224,  2225,  2226,     0,
       0,  2210,  2211,  4758,     0,     0,  1783,     0,     0,  2865,
       0,     0,     0,  1784,     0,     0,  1785,     0,  2212,  2217,
       0,  1930,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2888,     0,     0,  2890,     0,     0,  2901,     0,
       0,     0,     0,     0,  2213,  2908,  2913,  2214,     0,     0,
       0,  2919,     0,     0,  2924,     0,     0,     0,     0,     0,
    2215,     0,     0,  2216,     0,     0,     0,     0,     0,  1786,
       0,  2933,     0,     0,     0,     0,  2940,     0,     0,     0,
    2952,     0,     0,     0,  2959,     0,  2961,  2962,  2963,  2964,
    2965,  2966,  2967,  2968,  2969,   816,  2970,     0,     0,  1932,
       0,     0,  1552,     0,     0,  2995,     0,     0,     0,  2218,
    2219,  2220,     0,  2221,  2222,  2223,  2224,  2225,  2226,     0,
       0,   667,     0,  4812,     0,     0,  1787,     0,  1788,     0,
       0,     0,     0,     0,     0,     0,     0,  2217,  1789,     0,
       0,  2496,  3187,     0,  3187,     0,  1790,     0,     0,     0,
       0,     0,     0,     0,     0,  1791,     0,     0,     0,     0,
       0,     0,   668,     0,     0,     0,     0,  1623,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   667,     0,     0,     0,     0,     0,  3803,     0,
    2188,  2189,  1793,     0,     0,     0,     0,     0,     0,     0,
    1932,   370,  1932,     0,     0,   370,     0,   370,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3804,     0,  1930,
       0,     0,     0,  1006,     0,     0,     0,  2218,  2219,  2220,
       0,  2221,  2222,  2223,  2224,  2225,  2226,     0,     0,     0,
       0,  5021,     0,     0,     0,  1006,   668,     0,     0,   668,
       0,     0,     0,     0,     0,     0,  1932,     0,     0,     0,
       0,     0,     0,   666,   369,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1795,     0,     0,     0,     0,
       0,  1932,     0,   370,     0,     0,     0,     0,     0,     0,
     666,     0,     0,     0,   816,   666,     0,     0,   666,     0,
    3128,     0,  3187,     0,  2201,     0,     0,  2202,     0,     0,
       0,   369,     0,     0,     0,  3187,     0,     0,     0,   369,
     666,     0,     0,     0,  2203,     0,     0,     0,  3027,     0,
       0,     0,  2205,     0,     0,     0,     0,     0,  2206,  2201,
       0,     0,  2202,     0,     0,     0,   668,   668,     0,     0,
       0,     0,     0,   668,     0,     0,     0,     0,     0,  2203,
       0,   666,  2207,  1930,     0,     0,     0,  2205,     0,     0,
       0,     0,  1043,  2206,     0,     0,     0,     0,     0,  1932,
       0,     0,     0,     0,     0,     0,     0,     0,   666,   666,
       0,     0,     0,     0,     0,  3187,     0,  2207,     0,  1930,
       0,     0,     0,     0,     0,     0,     0,  3028,  1932,     0,
       0,   816,   666,     0,   816,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2201,     0,     0,
    2202,   668,     0,     0,     0,  1043,     0,   666,     0,     0,
     712,   666,     0,     0,     0,  1006,     0,  2203,     0,     0,
       0,     0,     0,     0,     0,  2205,     0,     0,     0,   666,
       0,  2206,     0,  2208,     0,     0,     0,  2209,     0,   666,
       0,     0,     0,     0,     0,     0,     0,     0,   712,     0,
    1932,     0,   666,     0,     0,  2207,     0,     0,  2210,  2211,
       0,     0,   666,     0,     0,     0,     0,     0,  2208,   712,
    1932,     0,  2209,     0,     0,  2212,     0,     0,     0,  2201,
       0,  1930,  2202,  3344,     0,     0,     0,  1015,     0,     0,
       0,     0,  1930,  2210,  2211,  1932,     0,     0,     0,     0,
    1016,  2213,     0,     0,  2214,     0,     0,  2205,  1024,     0,
    2212,     0,     0,  2206,     0,     0,     0,  2215,     0,     0,
    2216,     0,     0,     0,  1035,   816,  1015,     0,     0,     0,
    1056,  1932,     0,     0,     0,     0,  2213,  2207,     0,  2214,
    1086,     0,     0,     0,     0,     0,     0,     0,  1091,     0,
       0,     0,  2215,     0,     0,  2216,  2208,     0,     0,     0,
    2209,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2998,     0,     0,     0,     0,     0,     0,     0,
       0,  2210,  2211,  1006,     0,     0,   666,     0,     0,     0,
       0,     0,     0,     0,  2217,     0,     0,     0,  2212,  4487,
       0,     0,     0,     0,     0,     0,  1930,     0,  3468,     0,
       0,     0,   370,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   666,  2213,     0,     0,  2214,     0,  2217,
       0,     0,   668,     0,  1930,  1006,     0,     0, -2639,     0,
    2215,     0,  2209,  2216,   668,  3029,     0,     0,     0,     0,
    1930,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2210,  2211,     0,     0,     0,     0,     0,
       0,   666,     0,     0,     0,     0,     0,     0,     0,     0,
   -2639,     0,     0,     0,  2218,  2219,  2220,     0,  2221,  2222,
    2223,  2224,  2225,  2226,     0,   666,  1930,     0,   668,     0,
    3517,     0,     0,     0,     0,  3523,     0,     0,     0,  2214,
       0,     0,     0,     0,     0,  1006,     0,  2217,     0,  2218,
    2219,  2220,  2215,  2221,  2222,  2223,  2224,  2225,  2226,  3187,
       0,     0,     0,  5110,     0,     0,     0,     0,     0,     0,
       0,     0,  1006,     0,     0,     0,     0,  2913,     0,  2913,
    2913,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3580,     0,     0,  3583,     0,  3585,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   816,  1780,
       0,     0,     0,     0,   816,  1781,     0,     0,     0,     0,
       0,     0,  3606,     0,  3608,     0,     0,     0,  3611, -2639,
       0,     0,     0,     0,     0,     0,     0,  2218,  2219,  2220,
    1816,  2221,  2222,  2223,  2224,  2225,  2226,     0,     0,  4167,
       0,   668,     0,     0,     0,  1782,     0,  2995,  2995,  2995,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1930,  3669,     0,     0,     0,     0,  1817,     0,     0,     0,
       0,     0,     0,     0,  2309,     0,     0,     0,     0,     0,
     666,     0,     0,  1932,  1783,     0,     0,     0,     0,  2326,
       0,  1784,     0,     0,  1785,     0,     0,     0,     0,     0,
       0,     0,     0,  2221,  2222,  2223,  2224,  2225,  2226,  2201,
       0,     0,  2202,     0,     0,     0,     0,     0,     0,  2496,
       0,     0,     0,     0,     0,     0,   668,     0,   668,  2203,
       0,     0,     0,     0,     0,     0,     0,  2205,     0,     0,
       0,     0,     0,  2206,  1818,     0,     0,  1786,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   712,     0,
       0,  3722,     0,   666,     0,     0,     0,  2207,     0,     0,
       0,     0,     0,     0,     0,     0,  1930,     0,   666,   666,
    1006,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1819,     0,  1820,     0,     0,     0,     0,     0,
     370,     0,   668,     0,  1821,   666,  1788,     0,   666,     0,
       0,     0,     0,     0,     0,     0,  1789,     0,     0,     0,
       0,     0,     0,     0,  1790,     0,     0,     0,     0,     0,
       0,  1932,  1822,  1791,     0,     0,     0,     0,     0,     0,
       0,     0,  1932,     0,     0,     0,     0,  3558,     0,     0,
       0,     0,  3559,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3260,     0,  2208,     0,
    1793,  1824,  2209,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2998,  1930,   816,   816,   816,  2998,     0,
       0,     0,     0,  2210,  2211,  3261,     0,     0,     0,     0,
    2998,     0,     0,     0,   666,     0,  1826,  1930,     0,     0,
    2212,     0,     0,     0,     0,   666,     0,     0,     0,     0,
       0,     0,     0,     0,   666,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2213,  1930,     0,  2214,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2215,  1795,     0,  2216,  1932,     0,     0,     0,
     370,     0,     0,     0,  1183,  1189,  1189,   712,     0,  1189,
       0,  1197,     0,  1183,     0,  1086,     0,  1930,  1222,     0,
       0,  1930,  1930,  1086,  1932,  1086,     0,   666,     0,  1189,
       0,  1086,     0,     0,     0,     0,     0,     0,     0,  1252,
    1932,     0,     0,     0,  1086,     0,  1183,     0,     0,  1189,
       0,   712,     0,  1189,     0,     0,     0,     0,     0,     0,
    1222,     0,     0,  1309,     0,     0,   816,     0,     0,  2217,
    1189,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   666,     0,   666,     0,     0,  1932,     0,     0,     0,
       0,     0,     0,     0,     0,   666,     0,   666,     0,     0,
       0,     0,  1183,     0,     0,     0,     0,   712,  4968,     0,
       0,     0,  1183,     0,     0,     0,  1222,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1189,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   666,     0,     0,     0,
     668,     0,     0,     0,     0,     0,     0,     0,     0,  2218,
    2219,  2220,     0,  2221,  2222,  2223,  2224,  2225,  2226,     0,
       0,     0,     0,     0,     0,     0,   666,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1086,     0,     0,     0,
       0,     0,     0,   666,     0,     0,     0,     0,     0,  1086,
    1457,     0,     0,  4688,     0,     0,  4043,     0,     0,     0,
     666,   668,     0,   666,     0,     0,  4047,     0,     0,     0,
       0,     0,  4048,     0,  4049,     0,  1564,     0,     0,     0,
     712,  1086,     0,     0,     0,     0,     0,     0,     0,     0,
    1932,     0,     0,     0,     0,     0,  4067,  4068,     0,  1086,
       0,     0,     0,  1086,     0,     0,     0,     0,     0,     0,
       0,  1564,     0,     0,     0,     0,     0,  2919,     0,     0,
    2201,  1086,     0,  2202,     0,     0,     0,  4096,     0,     0,
    4099,  2201,  4101,  1086,  2202,     0,     0,     0,   816,     0,
    2203,  4105,     0,   370,     0,     0,     0,  4110,  2205,     0,
    4113,  2203,     0,     0,  2206,     0,     0,     0,     0,  2205,
       0,     0,     0,     0,     0,  2206,     0,     0,     0,     0,
       0,  4146,     0,     0,     0,     0,     0,     0,  2207,  4158,
       0,  2995,     0,     0,     0,     0,     0,     0,     0,  2207,
     370,     0,     0,     0,     0,     0,     0,     0,   370,     0,
       0,     0,     0,     0,     0,     0,  3187,     0,     0,     0,
       0,     0,     0,     0,     0,  1086,     0,     0,     0,     0,
       0,     0,  1086,     0,  1189,  1189,  4174,     0,     0,     0,
       0,     0,  1552,     0,     0,     0,     0,     0,  1623,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  5084,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1183,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2208,
    1183,     0,     0,  2209,  1222,     0,     0,     0,     0,     0,
    2208,     0,     0,     0,  2209,     0,     0,  1189,     0,     0,
       0,     0,     0,     0,  2210,  2211,     0,     0,     0,     0,
       0,     0,  1086,     0,  3187,  2210,  2211,   666,  1189,  1189,
       0,  2212,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2212,     0,  1086,  1086,  1086,  1932,  1189,     0,
    1183,     0,     0,     0,  1990,     0,     0,  2213,     0,     0,
    2214,     0,     0,     0,     0,     0,   816,     0,  2213,     0,
     816,  2214,   816,  2215,     0,     0,  2216,  1932,     0,     0,
       0,     0,     0,  1189,  2215,  1189,  1189,  2216,     0,     0,
       0,     0,     0,  5085,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4085,     0,     0,     0,
       0,   666,     0,     0,   666,     0,     0,  1932,     0,  1564,
       0,  1932,  1932,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   816,     0,
    2217,     0,     0,     0,     0,     0,     0,  2089,  2089,     0,
       0,  2217,  1086,     0,  1015,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4086,     0,     0,     0,  1086,
       0,     0,     0,     0,     0,     0,     0,  2124,     0,     0,
    1086,     0,     0,  2130,     0,     0,     0,  4688,     0,     0,
       0,     0,     0,     0,     0,  1564,     0,     0,     0,     0,
       0,   666,   666,     0,     0,     0,     0,     0,   666,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4421,
    4422,     0,     0,     0,  1564,     0,     0,     0,     0,     0,
    2218,  2219,  2220,     0,  2221,  2222,  2223,  2224,  2225,  2226,
       0,  2218,  2219,  2220,     0,  2221,  2222,  2223,  2224,  2225,
    2226,     0,  1564,  1564,     0,  1564,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1564,     0,     0,     0,     0,     0,     0,     0,
    4453,     0,     0,     0,     0,     0,   666,     0,     0,     0,
       0,     0,   712,   712,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1086,     0,     0,  1564,     0,     0,  4471,  4473,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4480,     0,     0,     0,     0,     0,  4485,  4486,     0, -2147,
    4488,     0,     0,  1564,     0,     0,     0,  1564,  1564,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1086,  1086,
    2343,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2995,     0,     0,     0,     0,  2995,     0,     0,
       0,     0,     0,     0,     0,     0, -2147,   712,     0,  2995,
       0,     0,     0,     0,     0,     0,     0,     0, -2147,     0,
       0,  2201, -2147,     0,  2202,     0,     0, -2147,     0,     0,
       0,  2201, -2147,     0,  2202, -2147,     0, -2147,     0,     0,
       0,  2203,     0,     0,  3521,     0,     0,  4544,     0,  2205,
       0,  2203,     0,     0,  3566,  2206,     0,     0,     0,  2205,
       0,     0,     0,     0, -2147,  2206,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2207,
       0,     0,     0,     0,     0,     0, -2147,     0,     0,  2207,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1086,  2504,   816,     0,     0,
       0,     0,  1086,     0,     0,  1189,     0,     0,     0,     0,
       0,     0,     0, -2147,     0,     0,     0,   666,     0,     0,
       0, -2147,  1222,     0,     0,     0,     0,     0,  1086,   666,
       0,  1086,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1086,     0,     0,     0,     0,     0,     0,     0,  1189,
    1189,  1189,  1189,  1086,     0,     0,     0,     0, -2147,     0,
    2208,     0,     0,     0,  2209,     0,     0,  1086,     0,     0,
    2208,     0,     0,   666,  2209,     0,     0,     0,     0,  2615,
       0,  1086,     0,     0,     0,  2210,  2211,     0,     0,     0,
       0,  1189,  1189,  4640,     0,  2210,  2211,  1189,     0,     0,
       0,     0,  2212,  1019,     0,     0,     0,     0,     0,     0,
       0,     0,  2212,     0,     0,     0,     0,  1922,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2147,  2213,     0,
       0,  2214,     0,     0,     0,     0,     0,     0,  2213,     0,
       0,  2214,  1189,     0,  2215,     0,     0,  2216,     0,     0,
   -2147,     0, -2147, -2147,  2215,     0,     0,  2216,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1189,
    1189,  1189,  1189,     0,     0,     0,     0,     0,     0,     0,
       0,  1086,     0,     0,     0, -2147,     0,  1086, -2147, -2147,
    2615, -2147,     0,     0,     0,     0,   666,     0,     0,     0,
       0,     0,     0,     0,     0,  1183,     0,     0,     0,     0,
       0,     0,   712,     0,  1183,  4724,     0,     0,     0,     0,
       0,  2217,     0,     0,  1222,     0,     0,     0,     0,  1189,
       0,  2217,     0,     0,     0,     0,     0,     0,  1189,     0,
       0,     0,  4741,     0,  1189,  1189,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1086,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1922,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   666,  2089,   666,     0,     0,     0,     0,     0,  1189,
       0,  1183,     0,     0,     0,  1086,  1086,     0,  1189,     0,
       0,  2218,  2219,  2220,  1086,  2221,  2222,  2223,  2224,  2225,
    2226,  2218,  2219,  2220,     0,  2221,  2222,  2223,  2224,  2225,
    2226,  1015,  1015,     0,     0,  2837,     0,     0,     0,  1564,
    1564,     0,     0,     0,     0,     0,     0,  1564,     0,     0,
    1564,     0,     0,     0,  1564,     0,     0,  1253,     0,     0,
       0,     0,  1564,  1564,     0,   816,     0,   666,     0,     0,
    1564,     0,  1222,  1564,  1564,  1564,  1564,     0,     0,     0,
       0,     0,     0,  1564,  1564,     0,  1564,     0,  1564,  1564,
    1254,     0,  1564,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1255,  1256,     0,     0,     0,     0,  1564,
       0,     0,  1257,  1189,  1564,     0,  1258,     0,  1564,     0,
       0,     0,  1564,     0,  1564,  1564,  1564,  1564,  1564,  1564,
    1564,  1564,  1564,  1259,  1564,     0,     0,     0,  2919,  1086,
    1564,     0,     0,  1564,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1260,     0,     0,  4878,     0,     0,
       0,     0,     0,     0,  1086,  1261,     0,     0,     0,     0,
       0,     0,     0,  1262,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1263,     0,     0,     0,     0,  1264,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1086,     0,  1086,     0,  1564,     0,     0,     0,     0,
    1265,     0,     0,     0,     0,     0,     0,     0,     0,  1564,
       0,     0,     0,     0,     0,   816,     0,     0,  1564,  1564,
       0,     0,     0,     0,     0,  1266,     0,     0,     0,     0,
       0,     0,  1086,     0,     0,     0,     0,     0,  3059,     0,
    3066,  1922,     0,     0,     0,     0,  1267,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4949,     0,     0,     0,
    2201,     0,     0,  2202,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1268,     0,     0,
    2203,     0,     0,     0,     0,     0,     0,  2201,  2205,     0,
    2202,     0,     0,     0,  2206,  1922,     0,     0,     0,     0,
       0,     0,     0,     0,   712,   853,     0,  2203,     0,  1015,
       0,  1015,     0,     0,     0,  2205,     0,     0,  2207,     0,
       0,  2206,     0,  4994,  1922,     0,     0,     0,  1564,     0,
       0,     0,  1269,     0,     0,     0,  1270,     0,  1271,  1183,
       0,  1189,  1189,  1189,  1272,  2207,  1183,  1273,  1222,     0,
    1189,     0,  1189,     0,  1189,  1189,     0,     0,  1086,     0,
       0,     0,     0,     0,     0,   666,     0,     0,     0,     0,
       0,     0,     0,  1274,     0,  1275,     0,     0,     0,  1276,
       0,     0,     0,     0,     0,     0,     0,  1277,     0,     0,
       0,     0,  1278,     0,     0,     0,  2504,  1922,     0,     0,
    5040,  5040,  3195,     0,     0,     0,     0,  3204,     0,     0,
       0,     0,     0,  1086,     0,     0,  1922,  1279,     0,  2208,
       0,     0,     0,  2209,     0,     0,   666,     0,  1086,     0,
    3571,     0,  3239,  3239,  1922,     0,     0,     0,     0,   712,
       0,     0,     0,     0,  2210,  2211,  2208,     0,     0,     0,
    2209,     0,     0,     0,     0,  5040,     0,  1189,     0,     0,
       0,  2212,  1922,     0,     0,  5088,     0,     0,     0,     0,
       0,  2210,  2211,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3297,     0,  3300,  3302,  2213,  2212,     0,
    2214,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2215,     0,     0,  2216,     0,   816,     0,
       0,     0,     0,     0,  2213,  1189,     0,  2214,     0,     0,
    3536,     0,     0,  1189,     0,  1922,     0,  5040,  1189,     0,
    2215,     0,     0,  2216,     0,     0,     0,     0,     0,     0,
       0,  1564,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2201,     0,   816,  2202,     0,     0,     0,
       0,     0,     0,   816,     0,  2504,     0,     0,  3239,     0,
    1086,     0,  3395,  2203,     0,  1015,  3577,     0,     0,     0,
    2217,  2205,     0,     0,     0,     0,     0,  2206,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3297,     0,     0,     0,     0,     0,  2217,     0,  1189,
    3420,  2207,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1990,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1189,
       0,  1189,  3239,  1189,  3239,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1564,     0,     0,     0,
    2218,  2219,  2220,     0,  2221,  2222,  2223,  2224,  2225,  2226,
       0,     0,     0,     0,     0,     0,     0,     0,  2089,     0,
    2201,     0,     0,  2202,     0,     0,     0,  2218,  2219,  2220,
       0,  2221,  2222,  2223,  2224,  2225,  2226,     0,     0,     0,
    2203,     0,  2208,     0,     0,     0,  2209,     0,  2205,     0,
       0,     0,  1922,     0,  2206,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1183,     0,     0,  2210,  2211,     0,
    1183,     0,     0,     0,     0,     0,     0,     0,  2207,     0,
       0,  1189,     0,     0,  2212,     0,     0,  1564,  1564,     0,
       0,     0,     0,  1564,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2213,     0,     0,  2214,     0,     0,     0,     0,  1564,  1564,
       0,     0,     0,  1564,     0,     0,  2215,     0,     0,  2216,
       0,     0,     0,     0,     0,  1564,  1564,  1564,  1564,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1564,     0,
       0,  1564,     0,  1564,  3586,     0,     0,     0,     0,     0,
   -2160,     0,     0,  1564,  1564,     0,     0,  1564,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2208,
    1564,     0,  1564,  2209,  1222,     0,  1564,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1564,  2217,  2210,  2211,  1086, -2160,     0,     0,
       0,     0,     0,  3632,     0,  1564,  1564,  1564,     0, -2160,
       0,  2212,     0, -2160,     0,     0,     0,     0, -2160,     0,
       0,     0,     0, -2160,     0,     0, -2160,     0, -2160,  1564,
       0,     0,     0,     0,     0,     0,     0,  2213,     0,     0,
    2214,     0,  1564,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2215,     0, -2160,  2216,  1564,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3632,
       0,     0,  3693,     0,     0,     0,  3066, -2160,     0,     0,
       0,     0,     0,  2218,  2219,  2220,     0,  2221,  2222,  2223,
    2224,  2225,  2226,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2160,     0,     0,     0,     0,     0,
       0,     0, -2160,     0,     0,     0,     0,  1922,     0,  1564,
    2217,  3239,  1922,  1922,     0,     0,  2089,     0,     0,     0,
       0,     0,     0,     0,  1922,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4042,     0,   824,     0,
       0,     0,  1189,     0,  1189,  1189,  1189,     0,     0, -2160,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   824,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1019,     0,     0,     0,     0,     0,
    2218,  2219,  2220,     0,  2221,  2222,  2223,  2224,  2225,  2226,
       0,     0,     0,     0,     0,     0,     0,     0, -2160,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1047,     0,     0,     0,     0,     0,     0,     0,  1047,     0,
    1047, -2160,     0, -2160, -2160,     0,     0,     0,     0,     0,
       0,     0,   824,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1922,     0,     0,
       0,     0,     0,     0,     0,     0, -2160,     0,    85, -2160,
   -2160,     0, -2160,     0,    89,     0,     0,     0,    93,     0,
      94,     0,    96,    97,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   106,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     119,   120,  3239,  3239,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1922,     0,     0,  3898,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,  1086,  1086,     0,     0,   129,     0,   130,   131,
       0,     0,     0,     0,     0,     0,     0,     0,  1086,     0,
       0,     0,     0,  1119,     0,     0,     0,     0,     0,     0,
       0,  2089,  1086,     0,     0,     0,     0,     0,     0,     0,
    2089,  1086,     0,   141,     0,   142,   143,     0,     0,     0,
       0,   146,     0,   147,     0,  1086,     0,     0,     0,     0,
       0,     0,     0,   149,     0,   150,     0,     0,     0,     0,
     712,     0,  1922,     0,     0,     0,     0,     0,     0,   153,
       0,   154,     0,     0,   157,  1189,     0,     0,  1189,     0,
       0,     0,     0,     0,     0,     0,   158,     0,   159,     0,
       0,     0,   160,     0,     0,  1183,     0,     0,   161,     0,
       0,     0,     0,     0,     0,     0,   163,     0,   165,     0,
       0,     0,     0,     0,   167,     0,  1086,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1189,     0,   171,     0,
       0,     0,     0,     0,  1564,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1564,     0,     0,     0,     0,     0,
    1564,     0,  1564,     0,     0,     0,     0,     0,  1564,     0,
       0,  1564,  1564,  1564,  1564,  1564,  1564,  1564,  1564,  1564,
    1564,     0,     0,     0,  1564,  1564,     0,     0,     0,     0,
       0,     0,     0,   184,   185,     0,     0,  1564,     0,   186,
       0,  1564,     0,     0,     0,  1564,     0,     0,   187,     0,
       0,     0,     0,     0,     0,  1564,     0,     0,  1564,   192,
    1564,     0,     0,     0,     0,     0,     0,     0,     0,  1564,
    1564,  1564,     0,     0,     0,  1564,     0,     0,  1564,     0,
       0,     0,     0,     0,     0,  1086,  1086,  1086,  1183,  3632,
    4129,     0,     0,     0,  4129,  4143,   203,     0,     0,  1564,
       0,     0,     0,     0,     0,  4157,     0,  1564,   205,  1564,
       0,     0,     0,   206,   207,     0,   208,     0,     0,     0,
       0,   209,     0,     0,     0,     0,   210,     0,     0,   212,
       0,     0,     0,   214,     0,     0,     0,     0,   215,   216,
       0,     0,     0,     0,     0,     0,   217,     0,     0,   219,
       0,     0,     0,     0,  1564,     0,     0,   222,     0,     0,
    1564,     0,     0,     0,  3066,     0,  1564,     0,     0,   224,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,  4204,  2089,  2089,     0,  2615,   232,     0,     0,     0,
       0,     0,   233,     0,     0,     0,     0,   234,     0,     0,
       0,     0,     0,  1189,  1189,  1189,  1189,     0,     0,   237,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1922,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4247,     0,   247,     0,     0,  2201,  -136,     0,  2202,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1922,  1922,     0,  1922,  2203,     0,     0,  4092,
       0,     0,     0,     0,  2205,     0,     0,     0,     0,     0,
    2206,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2201,     0,     0,  2202,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2207,     0,     0,     0,     0,     0,
    2203,   824,     0,  4308,     0,     0,     0,     0,  2205,  1185,
       0,  1922,     0,  1922,  2206,     0,     0,     0,  1185,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2207,     0,
       0,     0,  3898,     0,     0,     0,     0,     0,     0,     0,
    1086,  1185,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1189,     0,  1564,     0,     0,     0,  1922,     0,  1086,
       0,     0,     0,     0,     0,  4379,     0,     0,     0,     0,
       0,     0,     0,     0,  2504,     0,     0,     0,     0,     0,
       0,     0,  1922,     0,     0,  2208,  1086,     0,     0,  2209,
       0,     0,     0,     0,     0,  3297,     0,  1185,     0,     0,
       0,  4408,     0,  1922,     0,     0,     0,  1185,     0,     0,
    2210,  2211,     0,     0,     0,     0,  1922,  1564,  1564,     0,
       0,     0,     0,     0,     0,     0,     0,  2212,     0,  2208,
       0,     0,     0,  2209,     0,     0,     0,     0,     0,     0,
       0,     0,  3239,     0,  3239,     0,     0,     0,     0,     0,
       0,     0,     0,  2213,  2210,  2211,  2214,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2215,
       0,  2212,  2216,     0,     0,     0,     0,     0,  1564,     0,
    1922,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1922,  2213,     0,     0,
    2214,     0,     0,     0,     0,     0,     0,     0,     0,  1922,
       0,     0,     0,  2215,     0,  1564,  2216,     0,     0,     0,
       0,  1185,     0,     0,     0,  1564,  1564,  1047,     0,     0,
       0,  1047,     0,  1564,  1564,     0,     0,     0,  1564,     0,
       0,     0,     0,     0,  1564,  1564,  2217,     0,  1564,     0,
    1086,  1086,  1086,  1086,     0,     0,  1185,  4129,  4143,  4129,
       0,     0,  4497,     0,     0,     0,  3632,     0,     0,     0,
    3632,     0,     0,     0,     0,     0,  4510,     0,     0,     0,
    1564,  1922,     0,     0,     0,  1564,     0,     0,     0,     0,
    2217,  4520,     0,     0,     0,     0,     0,  1564,     0,     0,
       0,  1922,     0,     0,     0,     0,  1222,     0,     0,     0,
       0,     0,     0,  3693,     0,     0,     0,  3066,     0,     0,
       0,     0,     0,     0,     0,     0,  1922,     0,     0,     0,
       0,     0,  1015,     0,     0,  1564,  2218,  2219,  2220,     0,
    2221,  2222,  2223,  2224,  2225,  2226,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3239,  3239,     0,     0,     0,
       0,     0,  1922,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4573,
    2218,  2219,  2220,     0,  2221,  2222,  2223,  2224,  2225,  2226,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1185,     0,     0,     0,     0,     0,
       0,     0,     0,   936,  1189,  1185,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   937,     0,     0,  1189,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1933,     0,
       0,     0,     0,     0,     0,     0,   938,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   939,
       0,     0,     0,     0,     0,     0,     0,  3898,  3898,  3898,
    3898,  3898,   940,     0,     0,  1185,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   941,
       0,  1564,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1183,     0,     0,     0,     0,  2504,     0,     0,
     942,     0,     0,     0,  2089,     0,     0,     0,     0,     0,
       0,   943,     0,     0,     0,     0,  1189,  2504,     0,   944,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     945,     0,     0,     0,  1185,   946,     0,     0,     0,     0,
    1922,   947,     0,  1086,     0,  4694,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   948,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1564,     0,     0,     0,     0,     0,     0,
       0,     0,  1564,     0,     0,     0,     0,     0,     0,     0,
       0,  1933,     0,     0,     0,     0,     0,     0,     0,  1564,
    1564,     0,   949,  1564,     0,     0,     0,     0,     0,     0,
       0,     0,  4129,     0,     0,     0,  3632,     0,     0,     0,
    1185,  3632,     0,     0,  3632,  3297,     0,  4738,     0,  1564,
    1564,     0,     0,   950,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   951,     0,     0,     0,     0,     0,  1185,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   853,  4204,  1222,  1189,  1189,  1189,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1185,  1185,     0,
    1185,     0,     0,     0,  1922,     0,     0,     0,   952,     0,
       0,     0,   953,     0,   954,     0,     0,  1185,     0,     0,
     955,  1183,  1222,   956,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1922,     0,     0,     0,     0,     0,     0,     0,     0,   957,
       0,   958,     0,     0,     0,   959,     0,     0,     0,     0,
    2089,     0,     0,   960,  1183,     0,     0,     0,   961,  1185,
     824,     0,     0,  1086,     0,     0,     0,     0,     0,     0,
     962,     0,     0,     0,  4379,     0,     0,     0,     0,     0,
       0,  3239,     0,   963,     0,  2504,     0,     0,  1185,     0,
       0,     0,  1185,  1185,     0,     0,  1204,  4408,     0,     0,
    1086,     0,     0,     0,  1228,     0,     0,     0,  1189,  4204,
       0,     0,  1240,     0,     0,     0,     0,     0,     0,     0,
    1250,     0,     0,     0,     0,  1283,     0,     0,     0,     0,
       0,     0,     0,  1564,     0,     0,  1564,     0,  1564,     0,
       0,     0,  1922,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1922,     0,  1564,     0,     0,     0,  3632,
       0,     0,  4738,     0,     0,     0,     0,     0,  4887,     0,
       0,     0,  1933,     0,     0,     0,     0,     0,   824,     0,
       0,     0,     0,     0,     0,  1047,     0,     0,     0,     0,
    1189,     0,     0,     0,  1086,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1189,  1189,  1189,  1189,     0,     0,  1047,     0,
       0,     0,     0,     0,   880,     0,  1933,  2089,     0,     0,
       0,     0,     0,     0,     0,     0,   881,     0,     0,     0,
       0,     0,     0,     0,     0,  1183,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1933,     0,   882,     0,     0,
       0,     0,     0,     0,  1564,     0,     0,  1922,     0,     0,
     883,     0,     0,     0,     0,     0,     0,     0,     0,   884,
    1456,     0,     0,  -738,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1922,     0,     0,     0,     0,
     885,     0,     0,     0,     0,     0,   886,     0,     0,     0,
       0,  1922,  1582,     0,  1564,     0,     0,     0,     0,     0,
    1189,   887,  1222,     0,     0,     0,     0,     0,  1933,     0,
    1606,  1564,   888,     0,     0,     0,     0,     0,     0,     0,
     889,     0,     0,     0,     0,     0,     0,  1933,     0,     0,
       0,   890,  1632,     0,     0,     0,     0,  1922,   891,     0,
       0,     0,   892,     0,     0,  1933,     0,     0,     0,     0,
       0,  1189,     0,     0,     0,     0,  1183,  -940,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4204,   824,     0,
       0,     0,     0,  1933,     0,     0,  4694,     0,     0,     0,
       0,     0,     0,     0,     0,  4887,     0,     0,  1564,  1564,
       0,     0,     0,     0,     0,     0,   893,     0,     0,     0,
       0,  1183,     0,  -502,     0,     0,     0,     0,     0,  1189,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1185,     0,     0,  1801,   894,     0,  1933,   895,     0,  1185,
       0,     0,     0,  1564,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1564,     0,     0,     0,     0,  1189,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -399,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   896,
       0,  1922,     0,     0,     0,   897,     0,     0,     0,     0,
       0,  -399,     0,     0,   898,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1564,     0,     0,     0,     0,
       0,     0,     0,  1948,  1183,     0,  1185,     0,     0,     0,
    -399,     0,   899,   900,     0,   901,   902,     0,     0,     0,
       0,     0,     0,     0,   903,  1976,  1979,  1980,     0,   904,
       0,     0,     0,     0,     0,   905,     0,     0,   906,     0,
       0,   907,     0,     0,  1185,  1185,     0,     0,     0,     0,
       0,     0,  1185,     0,  -399,  1185,     0,     0,     0,  1185,
       0,     0,     0,     0,     0,     0,     0,  1185,  1185,     0,
       0,     0,     0,     0,     0,  1185,     0,     0,  1185,  1185,
    1185,  1185,     0,     0,     0,     0,     0,  1922,  1185,  1185,
       0,  1185,     0,  1185,  1185,     0,     0,  1185,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1933,  1185,   824,     0,     0,     0,  1185,
       0,     0,     0,  1185,     0,     0,     0,  1185,     0,  1185,
    1185,  1185,  1185,  1185,  1185,  1185,  1185,  1185,     0,  1185,
       0,     0,     0,  1582,     0,  1185,     0,     0,  1185,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2118,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1582,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1922,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     4,     0,
    1185,     0,     0,     0,     0,     0,     0,     0,  1922,     0,
       0,     0,     0,     0,  1185,     0,     0,     0,     5,     0,
       0,     0,     0,  1185,  1185,     0,     0,     0,     6,     7,
       0,   838,     0,     0,     8,     0,     9,    10,  1922,     0,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,     0,    36,     0,    37,    38,
      39,    40,    41,    42,    43,    44,     0,   839,  1922,    45,
       0,     0,  1922,  1922,     0,     0,     0,     0,     0,     0,
     840,     0,  1924,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2285,     0,   824,     0,     0,   841,     0,     0,
       0,     0,     0,   842,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    46,   843,     0,
       0,     0,     0,  1185,     0,     0,     0,     0,     0,   844,
       0,     0,     0,     0,  1185,     0,     0,   845,     0,     0,
    2341,  1185,     0,     0,     0,     0,     0,     0,   846,     0,
       0,     0,     0,   847,     0,     0,     0,     0,     0,   848,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1047,     0,   849,     0,     0,     0,  1933,     0,
       0,     0,     0,  1933,  1933,     0,     0,    47,     0,     0,
       0,     0,     0,     0,     0,  1933,     0,     0,     0,   850,
       0,     0,     0,     0,    48,     0,     0,     0,     0,     0,
       0,   824,     0,     0,   824,     0,     0,     0,     0,     0,
     851,     0,     0,     0,    49,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1047,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1924,    50,     0,     0,     0,
       0,   852,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2499,     0,     0,     0,
       0,     0,     0,  2516,     0,     0,     0,     0,     0,   853,
       0,     0,    51,     0,     0,    52,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2549,
      53,     0,  2552,     0,     0,     0,   854,     0,     0,     0,
     855,     0,   856,     0,  1045,     0,     0,     0,   857,     0,
       0,   858,  1045,     0,  1045,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2586,     0,  1185,     0,  1933,     0,
       0,     0,     0,     0,     0,     0,     0,   859,  2604,   860,
       0,     0,     0,   861,     0,   824,     0,     0,     0,     0,
       0,   862,  2616,     0,     0,     0,   863,     0,     0,     0,
       0,     0,     0,     0,     0,    54,     0,     0,   864,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   865,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1933,     0,     0,     0,    55,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    56,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    57,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1185,  2708,     0,     0,     0,     0,     0,  2718,     0,
       0,     0,    58,     0,     0,     0,     0,     0,    59,     0,
       0,     0,    60,    61,    62,    63,    64,     0,     0,    65,
      66,    67,    68,     0,    69,    70,    71,    72,    73,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1933,     0,     0,  1924,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1185,
       0,     0,     0,     0,     0,  1185,     0,     0,     0,  2774,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1185,  1185,     0,     0,     0,     0,  1185,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1924,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1185,  1185,     0,  1582,  1582,  1185,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1924,
    1185,  1185,  1185,  1185,     0,     0,     0,     0,   824,     0,
       0,     0,     0,  1185,   824,     0,  1185,     0,  1185,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1185,  1185,
       0,     0,  1185,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1185,     0,  1185,     0,     0,
       0,  1185,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1185,     0,     0,
       0,     0,  1924,     0,     0,     0,     0,     0,  1185,     0,
    1185,  1185,  1185,     0,     0,     0,     0,     0,     0,     0,
       0,  1924,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1185,     0,     0,     0,     0,  1924,
       0,     0,     0,     0,     0,     0,     0,  1185,     0,     0,
    2985,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1185,     0,     0,     0,     0,  1924,     0,     0,
       0,     0,     0,     0,  1185,  3005,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3018,     0,  3021,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1924,     0,     0,     0,  1185,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1582,     0,     0,     0,     0,     0,     0,
       0,  1933,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1933,  1933,     0,  1933,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   824,   824,   824,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1933,     0,  1933,     0,  1925,     0,     0,     0,
       0,     0,     0,  1181,     0,     0,     0,     0,     0,     0,
       0,     0,  1181,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1181,     0,     0,  1933,     0,
       0,     0,     0,     0,     0,     0,     0,  1924,     0,     0,
       0,     0,     0,     0,  3213,     0,     0,     0,     0,     0,
       0,     0,     0,  1933,     0,     0,     0,     0,     0,  3234,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1933,     0,     0,     0,     0,     0,
       0,  1181,     0,     0,     0,     0,   824,  1933,     0,     0,
       0,  1181,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1925,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1933,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1933,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1933,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3393,     0,     0,     0,  1181,     0,     0,     0,     0,
    1185,  1045,     0,     0,     0,  1045,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1181,     0,     0,     0,     0,     0,     0,     0,     0,  1185,
       0,     0,  1933,     0,     0,     0,     0,     0,     0,  1185,
       0,     0,     0,     0,     0,  1185,     0,  1185,     0,     0,
       0,     0,  1933,  1185,     0,     0,  1185,  1185,  1185,  1185,
    1185,  1185,  1185,  1185,  1185,  1185,     0,     0,     0,  1185,
    1185,     0,     0,     0,     0,     0,     0,  1933,     0,     0,
       0,     0,  1185,     0,     0,     0,  1185,     0,   824,     0,
    1185,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1185,     0,  1924,  1185,     0,  1185,     0,  1924,  1924,     0,
       0,     0,     0,  1933,  1185,  1185,  1185,     0,     0,  1924,
    1185,     0,     0,  1185,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1185,  1185,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1185,     0,     0,     0,     0,     0,
       0,     0,  1185,     0,  1185,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1181,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1181,
    1925,     0,     0,     0,     0,     0,     0,     0,     0,  1185,
       0,     0,     0,     0,     0,  1185,     0,     0,     0,     0,
       0,  1185,  1931,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1185,     0,     0,     0,
       0,     0,     0,     0,  1925,     0,     0,     0,     0,  1181,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1924,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1925,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3618,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   824,     0,     0,     0,
     824,  1933,   824,     0,     0,     0,     0,     0,  1181,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1924,     0,     0,
       0,     0,     0,     0,     0,     0,  1925,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1925,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1931,     0,     0,     0,     0,
       0,     0,     0,  1925,     0,     0,     0,     0,   824,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1181,     0,     0,     0,     0,     0,
       0,  1925,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1185,     0,
       0,     0,     0,  1181,     0,     0,     0,  1924,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1933,     0,     0,     0,     0,
       0,  1181,  1181,     0,  1181,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1925,     0,     0,     0,     0,     0,
       0,  1181,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1933,  1185,  1185,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1181,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1185,     0,     0,     0,     0,     0,     0,
       0,     0,  1181,     0,     0,     0,  1181,  1181,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1185,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1185,  1185,     0,  1933,     0,     0,     0,     0,  1185,  1185,
       0,     0,     0,  1185,  1933,     0,     0,     0,     0,  1185,
    1185,     0,     0,  1185,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1185,     0,     0,     0,  1185,  1931,     0,     0,     0,
       0,     0,     0,     0,     0,  1185,     0,     0,     0,  1045,
    1185,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1925,  1185,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3935,  3936,     0,     0,     0,     0,     0,
       0,     0,  1045,     0,     0,     0,     0,     0,     0,  3945,
    1931,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1185,     0,     0,  3953,     0,     0,     0,     0,     0,     0,
       0,     0,  3962,     0,     0,     0,     0,     0,  1933,  1931,
       0,     0,     0,     0,     0,     0,  3978,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   824,     0,     0,
       0,     0,     0,     0,     0,  1924,  1933,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1933,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1924,  1924,     0,
    1924,     0,  1931,     0,     0,     0,     0,  1582,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1933,     0,
       0,  1931,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1931,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1924,     0,  1924,     0,
       0,     0,     0,     0,     0,     0,     0,  1931,     0,     0,
       0,     0,     0,     0,     0,     0,  1185,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1185,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1924,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1181,     0,  4118,  4119,  4120,     0,
    1931,     0,     0,  1181,     0,  1933,     0,  1924,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1925,     0,  1924,     0,
       0,  1925,  1925,     0,     0,     0,     0,     0,  1185,     0,
       0,  1924,  1933,  1925,     0,     0,     0,  1185,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1185,  1185,     0,     0,  1185,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1185,     0,     0,     0,     0,  1185,     0,     0,  1185,
    1181,     0,     0,     0,  1185,  1185,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1924,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1924,     0,     0,     0,     0,     0,  1185,  1181,  1181,
       0,     0,     0,     0,  1924,     0,  1181,     0,     0,  1181,
       0,     0,     0,  1181,     0,     0,     0,     0,     0,     0,
       0,  1181,  1181,     0,     0,     0,     0,     0,  1933,  1181,
       0,     0,  1181,  1181,  1181,  1181,  1185,     0,     0,     0,
       0,     0,  1181,  1181,     0,  1181,     0,  1181,  1181,     0,
       0,  1181,     0,     0,     0,     0,  1925,     0,     0,     0,
       0,     0,     0,     0,     0,   824,     0,  1931,  1181,     0,
       0,     0,     0,  1181,     0,     0,  1924,  1181,     0,  1185,
       0,  1181,     0,  1181,  1181,  1181,  1181,  1181,  1181,  1181,
    1181,  1181,     0,  1181,     0,     0,  1924,     0,     0,  1181,
       0,     0,  1181,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1924,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1925,     0,     0,  1185,     0,  1933,     0,     0,     0,
       0,     0,     0,     0,     0,   923,     0,     0,     0,     0,
       0,  4348,     0,     0,   923,     0,     0,  1924,  1185,  1933,
       0,  1185,     0,  1185,  1181,     0,     0,     0,     0,     0,
    4374,     0,     0,     0,     0,     0,     0,     0,  1181,     0,
    1185,     0,     0,     0,  1185,     0,     0,  1181,  1181,  1933,
       0,     0,     0,     0,   923,     0,     0,  4391,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   824,     0,     0,  1100,  1933,
       0,  1925,     0,  1933,  1933,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1185,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1185,
       0,     0,     0,     0,     0,     0,     0,  1181,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1181,  1933,
       0,     0,     0,     0,     0,  1181,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1185,
       0,     0,     0,     0,     0,     0,  1045,     0,     0,     0,
       0,     0,  1931,     0,     0,  1924,  1185,  1931,  1931,     0,
       0,  4490,  4491,  4492,  4493,     0,     0,     0,     0,  1931,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1927,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1185,     0,     0,     0,     0,     0,  1149,     0,  1045,
       0,     0,  1185,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1185,  1185,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1185,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1185,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1185,  1924,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1181,     0,  1931,     0,     0,     0,     0,     0,   824,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1924,     0,     0,     0,     0,
       0,     0,  1927,     0,     0,     0,     0,     0,     0,  1925,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1185,     0,     0,     0,     0,   824,     0,     0,     0,  1185,
       0,     0,     0,   824,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1931,     0,     0,
       0,  1925,  1925,     0,  1925,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1181,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1924,     0,     0,
    1925,     0,  1925,     0,     0,     0,     0,     0,  1924,     0,
       0,     0,     0,     0,     0,     0,     0,   923,   923,     0,
       0,     0,     0,     0,  4690,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1931,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1181,     0,     0,  1925,     0,     0,  1181,
       0,     0,     0,     0,     0,  1149,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1181,  1181,     0,     0,
       0,  1925,  1181,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1925,     0,     0,     0,     0,  1181,  1181,     0,
       0,     0,  1181,     0,     0,  1925,     0,     0,     0,     0,
       0,     0,  1924,     0,  1181,  1181,  1181,  1181,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1181,     0,     0,
    1181,     0,  1181,     0,     0,     0,     0,     0,     0,     0,
    1924,     0,  1181,  1181,     0,     0,  1181,     0,     0,     0,
       0,     0,     0,  1927,     0,     0,  1924,     0,     0,  1181,
       0,  1181,     0,     0,     0,  1181,     0,     0,     0,  1925,
       0,     0,     0,     0,     0,     0,  1196,     0,     0,     0,
       0,  1181,     0,     0,     0,  1925,  1225,  1226,     0,  1229,
       0,  1232,  1181,  1234,  1181,  1181,  1181,     0,  1925,     0,
       0,     0,  1924,     0,     0,     0,     0,  1927,     0,     0,
       0,     0,  1286,     0,     0,     0,     0,     0,  1181,     0,
    1294,     0,     0,     0,  4810,     0,     0,     0,     0,  1310,
    1311,  1181,     0,     0,  1313,     0,  1927,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1181,     0,     0,     0,
       0,  1149,     0,   923,     0,     0,     0,     0,  1181,     0,
       0,  1582,     0,     0,     0,     0,     0,     0,  1344,     0,
    1925,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1367,     0,     0,  1369,     0,  1371,
    1925,  1374,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   923,     0,     0,     0,  1927,
       0,     0,     0,     0,     0,  1925,     0,     0,  1181,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1927,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1931,  1927,     0,     0,     0,
       0,  1925,     0,     0,     0,  4900,  1924,     0,     0,     0,
    1454,     0,  1455,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1927,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1931,  1931,     0,
    1931,     0,     0,  1149,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1100,     0,
       0,     0,     0,     0,     0,     0,     0,  1927,     0,     0,
       0,     0,     0,     0,     0,     0,  1931,     0,  1931,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1924,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1714,
       0,  1716,  1931,     0,     0,  1718,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1747,     0,  1931,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1931,  1925,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1931,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1865,     0,     0,     0,     0,     0,     0,     0,
    1924,     0,     0,     0,     0,     0,     0,     0,  1878,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1888,     0,  1924,     0,     0,     0,     0,  1890,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1939,     0,     0,  1943,     0,  1931,     0,     0,     0,     0,
       0,     0,     0,  1924,  1927,     0,     0,     0,     0,     0,
       0,  1931,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1931,     0,  1986,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1924,     0,     0,     0,  1924,  1924,     0,
       0,     0,     0,     0,  1181,     0,     0,     0,     0,     0,
       0,     0,     0,  1925,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1181,     0,     0,  1931,     0,     0,  1925,
       0,     0,     0,  1181,     0,     0,     0,     0,     0,  1181,
       0,  1181,     0,     0,     0,     0,  1931,  1181,     0,     0,
    1181,  1181,  1181,  1181,  1181,  1181,  1181,  1181,  1181,  1181,
       0,     0,     0,  1181,  1181,     0,     0,     0,     0,     0,
       0,  1931,     0,     0,     0,     0,  1181,     0,     0,     0,
    1181,     0,     0,     0,  1181,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1181,     0,     0,  1181,     0,  1181,
       0,     0,     0,     0,     0,     0,     0,  1931,  1181,  1181,
    1181,     0,     0,     0,  1181,     0,     0,  1181,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1181,  1181,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1181,     0,
       0,  1925,     0,     0,     0,     0,  1181,     0,  1181,     0,
       0,     0,  1925,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1181,     0,     0,     0,     0,     0,  1181,
       0,     0,     0,     0,     0,  1181,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1927,
       0,     0,     0,     0,  1927,  1927,     0,     0,     0,     0,
    1181,     0,     0,     0,     0,     0,  1927,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1100,  2302,
       0,     0,     0,     0,     0,     0,  1925,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1925,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1931,     0,     0,     0,     0,
    1925,     0,     0,     0,     0,     0,     0,  2375,     0,     0,
    2375,     0,     0,     0,     0,     0,     0,     0,  2382,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2391,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1925,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1927,
       0,     0,     0,     0,  2461,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1181,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1931,
       0,     0,     0,     0,  1927,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1931,  1181,  1181,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1925,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1181,     0,     0,
       0,     0,     0,     0,  1927,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2667,     0,     0,
       0,     0,     0,     0,  1181,     0,     0,     0,     0,     0,
       0,     0,  2690,     0,  1181,  1181,     0,  1931,     0,     0,
       0,     0,  1181,  1181,     0,     0,     0,  1181,  1931,     0,
       0,     0,     0,  1181,  1181,     0,     0,  1181,     0,     0,
       0,     0,     0,     0,     0,     0,  1925,     0,     0,     0,
       0,     0,     0,     0,     0,  1181,     0,     0,  2738,  1181,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1181,
       0,     0,     0,  2753,  1181,  2755,     0,  2756,     0,     0,
       0,     0,  2757,     0,     0,     0,  1181,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   672,     0,     0,
       0,     0,   716,     0,   716,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   716,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1181,     0,     0,     0,     0,     0,
       0,  2786,     0,     0,     0,     0,     0,     0,     0,     0,
     716,     0,  1931,  2302,     0,     0,     0,  2302,     0,  2302,
     716,     0,  2302,     0,  1925,     0,     0,     0,     0,     0,
       0,   716,   716,     0,     0,   716,     0,     0,     0,     0,
    1931,   716,     0,     0,     0,  1007,     0,  1925,     0,     0,
       0,     0,     0,     0,     0,     0,  1931,     0,     0,     0,
       0,     0,     0,     0,     0,  1007,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1925,     0,     0,
       0,   716,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1931,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1925,     0,     0,
       0,  1925,  1925,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1181,  2999,  1927,     0,     0,     0,     0,     0,     0,     0,
       0,  1181,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1927,  1927,     0,  1927,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1931,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1181,     0,     0,     0,  1931,     0,     0,     0,
       0,  1181,     0,  1927,     0,  1927,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1181,  1181,
       0,     0,  1181,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   716,  1181,     0,     0,     0,     0,
    1181,     0,     0,  1181,  1149,     0,     0,     0,  1181,  1181,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1927,
       0,  3096,  3097,     0,     0,     0,  3100,  3101,     0,     0,
    3104,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3114,  1181,     0,     0,  1927,     0,     0,  3123,     0,     0,
       0,  3126,  3127,     0,     0,  3130,  3131,     0,     0,     0,
       0,     0,  3136,     0,     0,  1927,     0,     0,     0,     0,
       0,     0,  1931,     0,  3152,     0,  3154,     0,  1927,     0,
    1181,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3176,     0,     0,     0,     0,  3178,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1181,     0,     0,     0,     0,  3196,  3197,
    3200,  3202,     0,     0,     0,  3209,  3212,     0,     0,     0,
       0,     0,  1927,  3223,     0,     0,  3227,     0,     0,     0,
    3231,     0,     0,     0,     0,     0,     0,     0,  1927,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1927,  3259,     0,     0,     0,     0,     0,  1181,     0,
    1931,     0,     0,  3266,     0,  3268,     0,     0,     0,     0,
    3271,     0,     0,     0,     0,  3275,  3276,  3277,  3278,     0,
    3280,     0,  1181,  1931,     0,  1181,     0,  1181,     0,     0,
     716,     0,     0,  3304,  3305,  3306,     0,     0,     0,     0,
       0,     0,     0,     0,  1181,     0,  3314,  3315,  1181,     0,
       0,     0,     0,  1931,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1927,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   716,   716,     0,     0,     0,     0,
       0,     0,     0,  1927,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1931,     0,     0,     0,  1931,  1931,     0,
       0,     0,     0,     0,     0,     0,  3369,     0,  1927,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   716,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1181,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1927,     0,     0,     0,     0,     0,
       0,     0,     0,  1181,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1931,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1181,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1181,     0,     0,     0,     0,     0,     0,     0,  1149,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2302,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1181,     0,     0,     0,  3496,
       0,     0,     0,     0,     0,     0,  1181,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1181,  1181,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1181,     0,     0,     0,     0,     0,     0,  1332,   716,     0,
     716,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1927,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1181,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1181,     0,     0,     0,     0,     0,   716,     0,
       0,   716,   716,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   672,     0,  1007,     0,
    1007,     0,     0,     0,     0,     0,   672,     0,     0,     0,
     716,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1007,
    1007,     0,     0,     0,  1181,     0,     0,     0,     0,     0,
       0,     0,     0,  1181,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     716,     0,   716,     0,     0,  3672,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1927,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1927,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3713,  3714,     0,     0,     0,   672,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2302,     0,   672,   672,     0,     0,  1696,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3736,     0,     0,     0,
       0,     0,     0,     0,     0,  3740,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3751,  3753,     0,   672,     0,  3753,     0,     0,     0,     0,
    3764,  3765,  3766,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1186,     0,
       0,     0,     0,     0,  1927,     0,     0,  1186,     0,     0,
       0,     0,     0,     0,     0,  1927,  3787,  3788,  3789,  3790,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1186,     0,     0,     0,     0,     0,  3806,  3807,  3808,     0,
       0,     0,     0,     0,     0,     0,  3821,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1186,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1186,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3860,     0,     0,     0,     0,     0,     0,     0,  3864,  1927,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1927,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   672,
       0,     0,     0,  1927,   716,     0,   716,     0,     0,   716,
       0,   716,  3932,     0,   716,   716,   716,     0,     0,     0,
    2084,     0,     0,     0,     0,     0,     0,   716,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     716,     0,   716,     0,     0,     0,     0,   716,     0,  1927,
    1186,     0,     0,     0,  3960,     0,     0,  3963,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1186,     0,     0,   923,     0,
       0,  4003,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4013,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2302,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2242,     0,     0,     0,     0,
       0,     0,     0,     0,   716,   716,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   672,     0,     0,     0,  1928,   672,   672,     0,     0,
       0,     0,     0,  1927,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1186,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1186,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1934,     0,   716,
       0,   672,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2379,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1186,     0,     0,     0,     0,  1927,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1188,  1190,     0,     0,  1193,     0,  1195,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   672,  1235,     0,  1928,     0,
       0,     0,     0,   672,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4215,     0,  4216,  1288,     0,     0,     0,
    1291,     0,  4218,  1186,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1314,  4227,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   672,  4235,     0,   672,   672,     0,
       0,     0,     0,     0,  4246,     0,     0,  1927,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1934,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1927,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1186,
    4278,  4279,  4280,  4281,  4282,  4283,  4284,  4285,     0,     0,
    1927,   672,  4292,  4293,     0,  4295,  4296,  4297,  4298,  4299,
    4300,  4301,     0,     0,     0,     0,     0,     0,  1186,     0,
    4309,     0,  4311,  4312,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1927,     0,     0,     0,  1927,  1927,  1186,  1186,     0,  1186,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1186,     0,     0,     0,
       0,     0,  4360,  4362,  4364,     0,     0,  4367,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1186,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1186,     0,  1928,
       0,  1186,  1186,     0,     0,     0,     0,     0,  3753,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2302,  2302,
    2302,     0,   716,     0,   716,     0,     0,     0,   716,     0,
     716,     0,     0,   716,     0,     0,     0,   716,     0,     0,
       0,     0,  2242,  1928,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1802,  1803,     0,     0,     0,     0,     0,     0,     0,
       0,  1934,  1928,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1934,     0,     0,     0,     0,
       0,     0,     0,     0,  1892,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1928,     0,     0,     0,     0,
       0,     0,     0,     0,  1934,  1950,  1951,     0,     0,     0,
       0,     0,     0,     0,  1928,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1982,     0,     0,     0,     0,
       0,     0,  1928,     0,     0,     0,     0,     0,     0,     0,
       0,  2084,     0,     0,     0,     0,     0,     0,  3000,     0,
       0,     0,     0,     0,     0,     0,     0,  2379,     0,     0,
    1928,     0,  2015,  2017,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1934,     0,  4563,
    4564,  4565,  4566,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1934,     0,     0,     0,
       0,     0,     0,  4578,  4579,  4580,  4581,     0,  4583,  4584,
       0,     0,     0,     0,  1934,     0,     0,     0,     0,     0,
    4593,  4594,     0,  1928,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2302,  2302,  1929,
    2302,     0,  1934,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   672,     0,     0,     0,
     672,     0,     0,     0,     0,     0,  3080,     0,  1696,     0,
       0,   716,     0,     0,     0,     0,     0,     0,     0,  1186,
       0,     0,     0,     0,     0,  1934,     0,     0,  1186,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4654,     0,     0,     0,     0,     0,
       0,     0,     0,  4660,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4679,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4698,     0,
       0,     0,     0,     0,     0,  1186,     0,     0,     0,     0,
       0,     0,  1929,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1928,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1186,  1186,     0,     0,     0,     0,     0,
       0,  1186,     0,     0,  1186,     0,     0,     0,  1186,  2302,
       0,     0,     0,     0,     0,     0,  1186,  1186,     0,     0,
       0,     0,  2302,   672,  1186,     0,     0,  1186,  1186,  1186,
    1186,   672,     0,   672,     0,     0,     0,  1186,  1186,     0,
    1186,     0,  1186,  1186,     0,     0,  1186,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1934,  1186,     0,     0,     0,     0,  1186,     0,
       0,     0,  1186,     0,     0,     0,  1186,     0,  1186,  1186,
    1186,  1186,  1186,  1186,  1186,  1186,  1186,     0,  1186,     0,
       0,     0,     0,     0,  1186,     0,     0,  1186,     0,     0,
       0,     0,     0,     0,     0,     0,  4785,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2519,     0,     0,     0,     0,     0,     0,  1186,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1186,     0,     0,     0,     0,     0,     0,
       0,     0,  1186,  1186,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3753,     0,     0,     0,  2582,  2583,  2584,  2585,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1929,     0,     0,     0,  2302,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2302,  2623,  2624,
       0,     0,     0,     0,  2633,   716,  2084,     0,     0,     0,
       0,     0,     0,     0,     0,  1928,     0,     0,     0,     0,
    1928,  1928,   672,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1928,  4903,     0,     0,     0,  1929,  4907,     0,
       0,     0,  1186,     0,     0,     0,     0,     0,     0,  2657,
       0,  2302,     0,  1186,     0,     0,     0,     0,     0,     0,
    1186,     0,     0,     0,     0,     0,  1929,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2692,  2693,  2694,  2695,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1934,     0,     0,
       0,     0,  1934,  1934,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1934,     0,     0,     0,     0,     0,
       0,     0,     0,  3753,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2754,     0,     0,  1929,
    2302,     0,     0,     0,     0,  2758,     0,     0,     0,     0,
       0,     0,  2765,     0,     0,     0,     0,     0,  1929,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1928,  1929,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    5013,     0,     0,     0,  1929,  5017,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2379,     0,     0,     0,     0,   672,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1928,     0,     0,     0,     0,  1186,     0,  1934,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1929,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2939,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1934,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     4,     0,     0,     0,
    1928,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     5,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     6,     7,     0,     0,
    1186,     0,     0,     0,     9,    10,     0,     0,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,     0,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,     0,     0,     0,    45,     0,     0,
       0,     0,  1934,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1186,     0,
       0,     0,     0,     0,  1186,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1929,     0,     0,     0,     0,     0,
       0,  1186,  1186,     0,     0,    46,     0,  1186,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1186,  1186,     0,     0,     0,  1186,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1186,
    1186,  1186,  1186,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1186,     0,     0,  1186,     0,  1186,     0,     0,
       0,     0,     0,     0,     0,    47,     0,  1186,  1186,     0,
       0,  1186,     0,     0,     0,     0,     0,     0,  3141,  3142,
    3143,   672,    48,     0,  1186,     0,  1186,  3153,     0,  3155,
    1186,  3157,  3158,     0,   672,     0,     0,     0,     0,     0,
       0,     0,    49,     0,     0,     0,  1186,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1186,     0,  1186,
    1186,  1186,     0,     0,    50,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1186,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1186,     0,  2228,     0,
      51,     0,     0,    52,     0,     0,     0,     0,     0,     0,
       0,  1186,     0,     0,     0,     0,     0,     0,    53,     0,
       0,     0,     0,  1186,     0,   716,     0,     0,  1928,     0,
       0,     0,     0,     0,  3265,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2228,
    1928,  1928,     0,  1928,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1186,     0,     0,   672,     0,     0,     0,
       0,     0,  3323,    54,     0,     0,     0,     0,     0,     0,
    3332,     0,     0,     0,     0,  3333,     0,     0,     0,  1929,
    1934,     0,     0,     0,  1929,  1929,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1929,     0,     0,  1928,
       0,  1928,     0,     0,     0,    55,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    56,
       0,     0,  1934,  1934,     0,  1934,     0,     0,     0,     0,
       0,     0,     0,     0,    57,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1928,  3418,     0,     0,     0,
      58,     0,     0,     0,     0,     0,    59,     0,     0,     0,
      60,    61,    62,    63,    64,     0,     0,    65,    66,  1382,
    1928,  1934,     0,  1934,    71,  1383,     0,     0,  3454,     0,
    3456,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1928,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1928,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1934,     0,  1929,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3080,     0,     0,     0,     0,     0,     0,
       0,     0,  1934,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1928,     0,
       0,     0,     0,  1934,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1928,     0,  1934,     0,  3511,     0,
       0,     0,     0,     0,     0,     0,     0,  1928,     0,     0,
       0,     0,     0,     0,  1929,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   672,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1934,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     672,     0,     0,     0,     0,     0,  1934,     0,     0,  1928,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1934,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1928,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1929,     0,     0,     0,     0,  1186,
       0,     0,     0,     0,  1928,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1186,     0,
    1928,  1934,     0,  2228,     0,     0,     0,     0,  1186,     0,
       0,     0,     0,     0,  1186,     0,  1186,     0,     0,     0,
       0,  1934,  1186,     0,     0,  1186,  1186,  1186,  1186,  1186,
    1186,  1186,  1186,  1186,  1186,     0,     0,     0,  1186,  1186,
       0,     0,     0,     0,     0,     0,  1934,     0,     0,     0,
       0,  1186,     0,     0,     0,  1186,     0,     0,     0,  1186,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1186,
       0,     0,  1186,     0,  1186,     0,     0,     0,     0,     0,
       0,     0,  1934,  1186,  1186,  1186,     0,     0,     0,  1186,
       0,     0,  1186,     0,     0,  2228,     0,     0,     0,     0,
       0,     0,  1186,  1186,     0,     0,     0,     0,     0,     0,
     672,     0,     0,  1186,     0,     0,     0,     0,     0,  2228,
       0,  1186,     0,  1186,  2897,     0,     0,     0,     0,  3742,
       0,  3743,  3744,  3745,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2228,  2228,     0,     0,  2228,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1186,     0,
       0,     0,     0,     4,  1186,     0,     0,     0,     0,     0,
    1186,     0,     0,     0,     0,     0,     0,     0,  2228,     0,
       0,     0,     0,     5,     0,     0,     0,     0,  1928,     0,
       0,     0,     0,     6,     7,  1186,     0,     0,     0,     0,
       0,     9,    10,     0,     0,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
       0,     0,  2228,    37,    38,    39,    40,    41,    42,    43,
      44,     0,     0,  2379,    45,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2228,     0,     0,     0,     0,
       0,     0,  1929,     0,     0,     0,     0,  2228,   672,     0,
    1934,     0,  2228,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    46,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1929,  1929,     0,  1929,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     672,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1928,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,  1929,     0,  1929,     0,     0,  1928,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    48,
       0,     0,     0,     0,     0,     0,     0,  1186,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    49,
     672,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1934,     0,     0,     0,     0,  1929,
       0,    50,     0,     0,     0,     0,     0,   672,     0,     0,
       0,     0,  4011,     0,     0,  4012,     0,     0,     0,     0,
       0,     0,     0,     0,  1929,     0,     0,     0,     0,     0,
    1934,  1186,  1186,     0,     0,     0,     0,    51,     0,     0,
      52,     0,     0,     0,     0,  1929,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    53,     0,     0,  1929,     0,
    1928,     0,     0,  4038,     0,     0,     0,     0,     0,     0,
       0,  1928,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1186,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1929,     0,     0,     0,     0,     0,     0,  1186,
      54,     0,     0,     0,     0,     0,     0,     0,  1929,  1186,
    1186,     0,  1934,     0,     0,     0,     0,  1186,  1186,     0,
       0,  1929,  1186,  1934,     0,     0,     0,     0,  1186,  1186,
       0,     0,  1186,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    55,     0,     0,     0,     0,     0,     0,     0,
    1186,     0,     0,     0,  1186,  1928,    56,     0,     0,   716,
       0,     0,     0,     0,  1186,     0,     0,     0,     0,  1186,
       0,    57,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1186,     0,  1928,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1929,     0,     0,     0,    58,     0,  1928,
       0,     0,     0,    59,     0,   672,     0,    60,    61,    62,
      63,    64,     0,  1929,    65,    66,  1382,  2041,     0,  1186,
       0,    71,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1934,  1929,     0,
       0,     0,     0,     0,     0,  1928,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1934,     0,     0,     0,     0,
    4221,  4222,  4223,  4224,  1929,     0,     0,     0,     0,     0,
       0,  1934,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1934,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2228,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2228,  1186,  2228,     0,  2897,  2897,
    3554,     0,     0,  2897,     0,     0,  1186,  2228,     0,  1928,
       0,     0,     0,     0,  2228,     0,     0,     0,     0,  2228,
       0,     0,     0,     0,     0,  2228,     0,     0,     0,     0,
    2228,     0,     0,     0,     0,     0,     0,     0,     0,  2228,
       0,     0,     0,  2897,  2897,     0,  2228,     0,  4366,     0,
       0,     0,     0,     0,  1934,     0,     0,     0,  2228,     0,
       0,     0,     0,     0,     0,  2228,     0,  2228,  2228,  2228,
    2228,  2228,  2228,  2228,  2228,  2228,  2228,     0,     0,     0,
       0,     0,  1929,     0,     0,     0,     0,  1186,     0,     0,
       0,  1934,     0,     0,     0,     0,  1186,     0,     0,     0,
       0,  2228,     0,   672,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1186,  1186,     0,     0,  1186,     0,     0,
       0,     0,     0,     0,     0,  1928,     0,     0,     0,     0,
    1186,     0,     0,     0,     0,  1186,     0,     0,  1186,     0,
       0,     0,     0,  1186,  1186,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1186,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1934,     0,     0,
       0,     0,     0,     0,     0,  1186,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1929,     0,     0,     0,
       0,     0,     0,  1928,  2228,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1928,     0,  1186,     0,
       0,     0,  1929,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1928,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1186,     0,  1934,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1928,     0,     0,     0,
    1928,  1928,     0,     0,     0,     0,     0,  1186,  1934,     0,
    1186,     0,  1186,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1186,
       0,     0,     0,  1186,     0,     0,     0,     0,  1934,     0,
       0,     0,     0,     0,  1929,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1929,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1934,     0,
       0,     0,  1934,  1934,     0,     0,     0,     0,     0,     0,
       0,  4598,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4601,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1186,
    2228,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1186,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1934,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1929,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1186,     0,
       0,     0,     0,     0,     0,     0,     0,  1929,     0,     0,
       0,     0,     0,  4667,     0,  1186,     0,     0,     0,     0,
       0,     0,     0,  1929,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2228,     0,     0,     0,     0,     0,
    1186,     0,     0,     0,     0,     0,     0,     0,     0,  1929,
       0,  1186,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1186,  1186,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2228,     0,  1186,     0,     0,     0,  2228,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3554,  3554,     0,  2897,     0,
       0,  2897,  2897,  2897,  2897,  2897,  2897,  2897,  2897,  2897,
    2897,  3554,     0,     0,     0,     0,     0,  1186,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1186,     0,     0,
       0,  4763,  4765,  4765,     0,     0,  2228,     0,     0,  2228,
       0,  2228,     0,     0,     0,     0,  3554,  3554,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2897,  2897,  2228,     0,  2228,     0,     0,  2228,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1186,
       0,     0,     0,  1929,     0,     0,     0,     0,  1186,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2228,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4853,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2228,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1929,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4897,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4916,     0,  4918,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1929,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1929,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1929,     0,     0,  2897,     0,     0,     0,  4765,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1929,     0,     0,     0,  1929,  1929,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  5018,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  5054,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2228,
       0,     0,     0,  2228,  2228,  2228,     0,     0,  3554,     0,
       0,     0,     0,  3554,  3554,  3554,  3554,  3554,  3554,  3554,
    3554,  3554,  3554,  2228,  2228,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  5091,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2228,  2897,  2897,  2228,     0,  2228,     0,     0,
       0,  2228,  3554,  3554,     0,     0,  2228,     0,     0,  2228,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      86,    87,    88,     0,    90,    91,    92,     0,     0,     0,
      95,     0,  2228,    98,    99,   100,   101,   102,   103,     0,
     104,   105,     0,     0,  2228,   107,   108,   109,   110,     0,
     111,   112,   113,   114,   115,     0,   116,   117,   118,     0,
    2228,     0,     0,     0,   121,   122,     0,     0,     0,     0,
     123,     0,     0,     0,     0,     0,     0,     0,     0,   124,
       0,   125,     0,   126,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   133,
       0,     0,     0,   135,   136,   137,   138,   139,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   140,
       0,     0,     0,     0,     0,     0,   144,     0,   145,     0,
       0,     0,     0,     0,   148,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   151,     0,     0,     0,     0,
       0,   152,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   155,   156,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   162,     0,
       0,     0,     0,     0,     0,     0,   164,     0,     0,     0,
     166,     0,     0,     0,     0,   168,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,     0,     0,     0,   172,
       0,     0,     0,     0,  3554,     0,     0,     0,   173,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   174,   175,     0,     0,     0,     0,     0,   176,     0,
     177,     0,     0,   178,   179,     0,   180,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   181,   182,     0,
     183,     0,     0,     0,     0,     0,     0,  2228,  2228,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     188,   189,   190,     0,     0,   191,     0,     0,     0,   193,
       0,     0,   194,     0,   195,     0,     0,     0,     0,  2228,
       0,     0,     0,  2897,     0,     0,     0,   196,   197,   198,
     199,   200,     0,     0,     0,     0,     0,  2228,     0,  2228,
       0,   201,     0,   202,  3554,  3554,  2228,     0,     0,  2897,
    2897,  2228,  2228,     0,  2228,     0,   204,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   211,     0,     0,   213,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   218,     0,     0,   220,
       0,   221,     0,     0,     0,     0,     0,     0,     0,     0,
    2228,     0,     0,     0,   223,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   225,   226,     0,     0,
       0,   227,     0,   228,     0,     0,     0,     0,     0,     0,
       0,     0,   231,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   235,     0,     0,
     236,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   238,   239,   240,   241,   242,   243,
     244,   245,   246,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2228,     0,     0,  3070,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3554,  2897,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3554,  3554,
    2228,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2228,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3554,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2228,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2228,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2228,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     726,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     727,   104,   105,   681,   728,     0,   107,   108,   109,   110,
     729,   730,   112,   113,   114,   115,  2228,   116,   731,   732,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,  2228,     0,   418,   419,   420,   421,
     422,   423,   424,   425,   733,   426,   427,   428,   734,   735,
     736,   737,   738,   739,   740,   429,   430,   741,   431,   432,
     133,   433,   434,   435,   135,   136,   137,   138,   139,   742,
     436,   437,   438,   439,   440,   743,   744,   441,   442,   745,
     140,   443,   746,   444,   445,   446,   447,   144,   747,   145,
     748,   448,   449,   450,   451,   148,   452,   749,   750,   453,
     454,   455,   456,   457,   458,   751,   151,   459,   752,   753,
     754,   755,   152,   756,   757,   758,   460,   461,   462,   463,
     695,   464,   155,   156,   465,   759,   466,   760,   467,   468,
     469,   470,   471,   761,   472,   473,   474,   762,   763,   475,
     476,   477,   478,   479,   764,   480,   481,   482,   765,   483,
     484,   485,   766,   486,   487,   488,   489,   164,   490,   491,
     492,   166,   767,   493,   768,   494,   168,   495,   769,   496,
     770,   497,   169,   771,   170,   498,   499,   500,   772,   501,
     172,   773,   502,   774,   503,   504,   697,   505,   506,   173,
     507,   508,   509,   775,   510,   511,   512,   513,   514,   515,
     776,   516,   174,   175,   777,   517,   518,   519,   778,   176,
     779,   177,   780,   520,   178,   179,   521,   180,   522,   523,
     524,   525,   526,   781,   527,   528,   782,   529,   181,   182,
     530,   183,   783,   531,   532,   533,   784,   785,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,   189,   190,   545,   546,   191,   786,   547,   548,
     193,   549,   787,   194,   550,   195,   551,   552,   553,   788,
     554,   789,   790,   555,   556,   557,   791,   792,   196,   197,
     198,   199,   200,   558,   559,   560,   561,   562,   563,   564,
     793,   565,   201,   566,   202,   567,   568,   569,   794,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,   795,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,   796,   593,   594,   211,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,   797,
     604,   605,   606,   607,   608,   798,   609,   218,   610,   611,
     220,   612,   221,   613,   799,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,   800,   624,   625,   801,
     626,   627,   628,   629,   630,   631,   802,   225,   226,   803,
     804,   633,   227,   634,   228,   805,   635,   636,   637,   638,
     639,   640,   641,   806,   807,   642,   643,   644,   645,   646,
     808,   809,   647,   648,   649,   650,   651,   810,   235,   811,
     652,   236,   653,   654,   655,   812,   813,   656,   814,   815,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,    85,     0,     0,
      86,    87,    88,    89,    90,    91,    92,    93,     0,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   967,
     104,   105,   106,     0,     0,   107,   108,   109,   110,     0,
     111,   112,   113,   114,   115,     0,   116,   117,   118,   119,
     120,     0,     0,     0,   121,   122,     0,     0,     0,     0,
     123,     0,     0,     0,     0,     0,     0,     0,     0,   124,
       0,   125,     0,   126,   127,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   128,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   129,     0,   130,   131,     0,
       0,     0,     0,     0,     0,     0,     0,   132,     0,   133,
       0,     0,   134,   135,   136,   137,   138,   139,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   140,
       0,     0,   141,     0,   142,   143,   144,     0,   145,     0,
     146,     0,   147,     0,   148,     0,     0,     0,     0,     0,
       0,     0,   149,     0,   150,   151,     0,     0,     0,     0,
       0,   152,     0,     0,     0,     0,     0,     0,   153,     0,
     154,   155,   156,   157,     0,     0,     0,     0,     0, -1398,
       0,     0,     0,     0,     0,   158,     0,   159,     0,     0,
       0,   160,     0,     0,     0,     0,     0,   161,   162,     0,
       0,     0,     0,     0,     0,   163,   164,   165,     0,     0,
     166,     0,     0,   167,     0,   168,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,     0,   171,     0,   172,
       0,     0,     0,     0,     0,     0,     0,     0,   173,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   174,   175,     0,     0, -1398,     0,     0,   176,     0,
     177,     0,     0,   178,   179,     0,   180,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   181,   182,     0,
     183,     0,   184,   185,     0,     0,     0,     0,   186,     0,
       0,     0,     0,     0,     0,     0,     0,   187,     0,     0,
     188,   189,   190,     0,     0,   191,     0,     0,   192,   193,
       0,     0,   194,     0,   195,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   196,   197,   198,
     199,   200,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   201,     0,   202,     0,   203,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   204,   205,     0,     0,
       0,     0,   206,   207,     0,   208,     0,     0,     0,     0,
     209,     0,     0,     0,     0,   210,   211,     0,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,     0,     0,   217,   218,     0,   219,   220,
       0,   221,     0,     0,     0,     0,   222,     0,     0,     0,
       0,     0,     0,     0,   223,     0,     0,     0,   224,     0,
       0,     0,     0,     0,     0,     0,   225,   226,     0,     0,
       0,   227,     0,   228,     0,   229,     0,   230,     0,     0,
       0,     0,   231,     0,     0,   232,     0,     0, -1398,     0,
       0,   233,     0,     0,     0,     0,   234,   235,     0,     0,
     236,     0,     0,     0,     0,     0,     0,     0,   237,     0,
       0,     0,     0,     0,   238,   239,   240,   241,   242,   243,
     244,   245,   246,    86,    87,    88,     0,    90,    91,    92,
       0,     0,     0,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   247,   104,   105,     0,  -136,     0,   107,   108,
     109,   110,     0,   111,   112,   113,   114,   115,     0,   116,
     117,   118,     0,     0,     0,     0,     0,   121,   122,     0,
       0,     0,     0,   123,     0,     0,     0,     0,     0,     0,
       0,     0,   124,     0,   125,     0,   126,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   133,     0,     0,     0,   135,   136,   137,   138,
     139,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   140,     0,     0,     0,     0,     0,     0,   144,
       0,   145,     0,     0,     0,     0,     0,   148,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   151,     0,
       0,     0,     0,     0,   152,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   155,   156,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   162,     0,     0,     0,     0,     0,     0,     0,   164,
       0,     0,     0,   166,     0,     0,     0,     0,   168,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   172,     0,     0,     0,     0,     0,     0,     0,
       0,   173,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   174,   175,     0,     0,     0,     0,
       0,   176,     0,   177,     0,     0,   178,   179,     0,   180,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     181,   182,     0,   183,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   188,   189,   190,     0,     0,   191,     0,
       0,     0,   193,     0,     0,   194,     0,   195,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     196,   197,   198,   199,   200,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   201,     0,   202,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   204,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   211,
       0,     0,   213,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   218,
       0,     0,   220,     0,   221,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   223,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   225,
     226,     0,     0,     0,   227,     0,   228,     0,     0,     0,
       0,     0,     0,     0,     0,   231,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     235,     0,     0,   236,     0,     0,     0,     0,     0,     0,
       0,     4,     0,     0,     0,     0,     0,   238,   239,   240,
     241,   242,   243,   244,   245,   246,     0,     0,     0,     0,
       0,     5,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     6,     7,     0,     0,     0,     0,     0,     0,     9,
      10,     0,  3072,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,     0,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,     0,
       0,     0,    45,     0,     0,     0,     0,     0,     0,     4,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     5,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     6,
       7,     0,     0,     0,     0,     0,     0,     9,    10,     0,
      46,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,     0,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,     0,     0,     0,
      45,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    48,    46,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    49,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    50,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    47,     0,
       0,     0,     0,     0,     0,    51,     0,     0,    52,     0,
       0,     0,     0,     0,     0,    48,     0,     0,     0,     0,
       0,     0,     0,    53,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    49,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    50,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    51,     0,     0,    52,     0,    54,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    53,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      55,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    56,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    57,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    54,     0,     0,     0,
       0,     0,     0,     0,     0,    58,     0,     0,     0,     0,
       0,    59,     0,     0,     0,    60,    61,    62,    63,    64,
       0,     0,    65,    66,  1382,  2766,     0,     0,     0,    71,
       0,     0,     0,     0,     0,     0,     0,     0,    55,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    56,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    57,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    58,     0,     0,     0,     0,     0,    59,
       0,     0,     0,    60,    61,    62,    63,    64,     0,     0,
      65,    66,  1382,     0,     0,     0,     0,    71,   726,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   727,   104,
     105,   681,   728,     0,   107,   108,   109,   110,   729,   730,
     112,   113,   114,   115,     0,   116,   731,   732,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,   417,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,  1471,  1472,  1473,    45,
    1474,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,  2989,   426,   427,   428,     0,     0,     0,     0,
    1475,     0,     0,   429,   430,     0,   431,   432,   133,   433,
     434,   435,   135,  1476,   137,  1477,  1478,     0,   436,   437,
     438,   439,   440,  1479,  1480,   441,   442,  1481,  1482,   443,
       0,   444,   445,   446,   447,  1483,     0,  1484,     0,   448,
     449,   450,   451,   148,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,   151,   459,     0,  1485,  1486,  1487,
    1488,  1489,  1490,  1491,   460,   461,   462,   463,   695,   464,
    1492,  1493,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,  2990,     0,   475,   476,  1494,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,  1495,   490,   491,   492,  1496,
    1497,   493,     0,   494,  1498,   495,     0,   496,     0,   497,
     169,     0,   170,   498,   499,   500,     0,   501,  1499,     0,
     502,     0,   503,   504,   697,   505,   506,   173,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
     174,   175,     0,   517,   518,   519,  1500,  1501,     0,  1502,
       0,   520,   178,   179,   521,   180,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,  1503,   182,   530,   183,
       0,   531,   532,   533,  1504,  1505,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,  1506,
     189,  1507,   545,   546,   191,  1508,   547,   548,   193,   549,
    1509,  1510,   550,  1511,   551,   552,   553,     0,   554,     0,
       0,  1512,   556,   557,     0,     0,   196,   197,   198,   199,
    1513,   558,   559,   560,   561,   562,   563,   564,     0,   565,
    1514,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,  1515,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,   211,   595,   596,  1516,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,  1517,   609,   218,   610,   611,   220,   612,
    1518,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,  1519,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,  1520,  1521,     0,     0,   633,
    1522,   634,  1523,  1524,   635,   636,   637,   638,   639,   640,
     641,     0,  1525,   642,   643,   644,   645,   646,  1526,     0,
     647,   648,   649,   650,   651,   701,  1527,  2991,   652,   236,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,  1528,  1529,  1530,  1531,  1532,  1533,
    1534,  1535,   702,   662,   663,     0,     0,     0,     0,     0,
       0,     0,  1536,  1537,  2992,     0,     0,     0,     0,     0,
       0,  1539,  2993,   726,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   727,   104,   105,   681,   728,     0,   107,
     108,   109,   110,   729,   730,   112,   113,   114,   115,     0,
     116,   731,   732,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
     417,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1471,  1472,  1473,    45,  1474,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,  1475,     0,     0,   429,   430,
       0,   431,   432,   133,   433,   434,   435,   135,  1476,   137,
    1477,  1478,     0,   436,   437,   438,   439,   440,  1479,  1480,
     441,   442,  1481,  1482,   443,     0,   444,   445,   446,   447,
    1483,     0,  1484,     0,   448,   449,   450,   451,   148,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,   151,
     459,     0,  1485,  1486,  1487,  1488,  1489,  1490,  1491,   460,
     461,   462,   463,   695,   464,  1492,  1493,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,  1494,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
    1495,   490,   491,   492,  1496,  1497,   493,     0,   494,  1498,
     495,     0,   496,     0,   497,   169,     0,   170,   498,   499,
     500,     0,   501,  1499,     0,   502,     0,   503,   504,   697,
     505,   506,   173,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,   174,   175,     0,   517,   518,
     519,  1500,  1501,     0,  1502,     0,   520,   178,   179,   521,
     180,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,  1503,   182,   530,   183,     0,   531,   532,   533,  1504,
    1505,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,  1506,   189,  1507,   545,   546,   191,
    1508,   547,   548,   193,   549,  1509,  1510,   550,  1511,   551,
     552,   553,     0,   554,     0,     0,  1512,   556,   557,     0,
       0,   196,   197,   198,   199,  1513,   558,   559,   560,   561,
     562,   563,   564,     0,   565,  1514,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
    1515,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
     211,   595,   596,  1516,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,  1517,   609,
     218,   610,   611,   220,   612,  1518,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,  1519,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
    1520,  1521,     0,     0,   633,  1522,   634,  1523,  1524,   635,
     636,   637,   638,   639,   640,   641,     0,  1525,   642,   643,
     644,   645,   646,  1526,     0,   647,   648,   649,   650,   651,
     701,  1527,     0,   652,   236,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,  1528,
    1529,  1530,  1531,  1532,  1533,  1534,  1535,   702,   662,   663,
       0,     0,     0,     0,     0,     0,     0,  1536,  1537,     0,
       0,     0,     0,     0,     0,     0,  1539,  2899,   726,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   727,   104,
     105,   681,   728,     0,   107,   108,   109,   110,   729,   730,
     112,   113,   114,   115,     0,   116,   731,   732,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,   133,   433,
     434,   435,     0,  1900,   137,  1901,  1902,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,  1903,  1904,   443,
       0,   444,   445,   446,   447,     0,     0,   145,     0,   448,
     449,   450,   451,   148,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,   151,   459,     0,     0,     0,     0,
     152,     0,     0,     0,   460,   461,   462,   463,   695,   464,
    1905,  1906,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,  1494,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,     0,   490,   491,   492,     0,
       0,   493,     0,   494,  1907,   495,     0,   496,     0,   497,
     169,     0,   170,   498,   499,   500,     0,   501,     0,     0,
     502,     0,   503,   504,   697,   505,   506,   173,   507,   508,
     509,  2484,   510,   511,   512,   513,   514,   515,     0,   516,
     174,  2485,     0,   517,   518,   519,  1500,  1908,     0,  1909,
       0,   520,   178,   179,   521,   180,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,     0,   182,   530,   183,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,  1910,
     189,  1911,   545,   546,     0,     0,   547,   548,   193,   549,
       0,     0,   550,  1912,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,  2486,   197,   198,   199,
       0,   558,   559,   560,   561,   562,   563,   564,     0,   565,
       0,   566,     0,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,  1913,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,   211,   595,   596,     0,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,  2487,   610,   611,   220,   612,
    1915,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,     0,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,  1916,  1917,     0,     0,   633,
       0,   634,     0,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,     0,  1918,  2488,   652,   236,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   702,   662,   663,     0,     0,     0,     0,   726,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,  2489,    98,    99,   100,   101,   102,   103,   727,
     104,   105,   681,   728,     0,   107,   108,   109,   110,   729,
     730,   112,   113,   114,   115,     0,   116,   731,   732,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,   133,
     433,   434,   435,     0,  1900,   137,  1901,  1902,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,  1903,  1904,
     443,     0,   444,   445,   446,   447,     0,     0,   145,     0,
     448,   449,   450,   451,   148,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,   151,   459,     0,     0,     0,
       0,   152,     0,     0,     0,   460,   461,   462,   463,   695,
     464,  1905,  1906,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
    1494,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,     0,   490,   491,   492,
       0,     0,   493,     0,   494,  1907,   495,     0,   496,     0,
     497,   169,     0,   170,   498,   499,   500,     0,   501,     0,
       0,   502,     0,   503,   504,   697,   505,   506,   173,   507,
     508,   509,  2484,   510,   511,   512,   513,   514,   515,     0,
     516,   174,  2485,     0,   517,   518,   519,  1500,  1908,     0,
    1909,     0,   520,   178,   179,   521,   180,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,     0,   182,   530,
     183,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
    1910,   189,  1911,   545,   546,     0,     0,   547,   548,   193,
     549,     0,     0,   550,  1912,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,  2486,   197,   198,
     199,     0,   558,   559,   560,   561,   562,   563,   564,     0,
     565,     0,   566,     0,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,  1913,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,   211,   595,   596,     0,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,   609,  2487,   610,   611,   220,
     612,  1915,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,     0,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,  1916,  1917,     0,     0,
     633,     0,   634,     0,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,     0,  1918,  2488,   652,
     236,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   702,   662,   663,     0,     0,     0,     0,
     726,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,  3430,    98,    99,   100,   101,   102,   103,
     727,   104,   105,   681,   728,     0,   107,   108,   109,   110,
     729,   730,   112,   113,   114,   115,     0,   116,   731,   732,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,   417,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1471,  1472,
    1473,    45,  1474,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,  1475,     0,     0,   429,   430,     0,   431,   432,
     133,   433,   434,   435,   135,  1476,   137,  1477,  1478,  2909,
     436,   437,   438,   439,   440,  1479,  1480,   441,   442,  1481,
    1482,   443,     0,   444,   445,   446,   447,  1483,     0,  1484,
       0,   448,   449,   450,   451,   148,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,   151,   459,     0,  1485,
    1486,  1487,  1488,  1489,  1490,  1491,   460,   461,   462,   463,
     695,   464,  1492,  1493,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,  1494,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,  1495,   490,   491,
     492,  1496,  1497,   493,     0,   494,  1498,   495,     0,   496,
       0,   497,   169,  2910,   170,   498,   499,   500,     0,   501,
    1499,     0,   502,     0,   503,   504,   697,   505,   506,   173,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,   174,   175,     0,   517,   518,   519,  1500,  1501,
       0,  1502,     0,   520,   178,   179,   521,   180,   522,   523,
     524,   525,   526,     0,   527,   528,  2911,   529,  1503,   182,
     530,   183,     0,   531,   532,   533,  1504,  1505,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,  1506,   189,  1507,   545,   546,   191,  1508,   547,   548,
     193,   549,  1509,  1510,   550,  1511,   551,   552,   553,     0,
     554,     0,     0,  1512,   556,   557,     0,     0,   196,   197,
     198,   199,  1513,   558,   559,   560,   561,   562,   563,   564,
       0,   565,  1514,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,  1515,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,   211,   595,   596,
    1516,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,  1517,   609,   218,   610,   611,
     220,   612,  1518,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,  1519,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,  1520,  1521,     0,
    2912,   633,  1522,   634,  1523,  1524,   635,   636,   637,   638,
     639,   640,   641,     0,  1525,   642,   643,   644,   645,   646,
    1526,     0,   647,   648,   649,   650,   651,   701,  1527,     0,
     652,   236,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,  1528,  1529,  1530,  1531,
    1532,  1533,  1534,  1535,   702,   662,   663,     0,     0,     0,
       0,     0,     0,     0,  1536,  1537,     0,     0,     0,     0,
       0,     0,     0,  1539,   726,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   727,   104,   105,   681,   728,     0,
     107,   108,   109,   110,   729,   730,   112,   113,   114,   115,
       0,   116,   731,   732,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,   417,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1471,  1472,  1473,    45,  1474,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,  1475,     0,     0,   429,
     430,     0,   431,   432,   133,   433,   434,   435,   135,  1476,
     137,  1477,  1478,     0,   436,   437,   438,   439,   440,  1479,
    1480,   441,   442,  1481,  1482,   443,     0,   444,   445,   446,
     447,  1483,     0,  1484,     0,   448,   449,   450,   451,   148,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
     151,   459,     0,  1485,  1486,  1487,  1488,  1489,  1490,  1491,
     460,   461,   462,   463,   695,   464,  1492,  1493,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,  1494,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,  1495,   490,   491,   492,  1496,  1497,   493,     0,   494,
    1498,   495,     0,   496,     0,   497,   169,     0,   170,   498,
     499,   500,     0,   501,  1499,     0,   502,     0,   503,   504,
     697,   505,   506,   173,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,   174,   175,     0,   517,
     518,   519,  1500,  1501,     0,  1502,     0,   520,   178,   179,
     521,   180,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,  1503,   182,   530,   183,     0,   531,   532,   533,
    1504,  1505,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,  1506,   189,  1507,   545,   546,
     191,  1508,   547,   548,   193,   549,  1509,  1510,   550,  1511,
     551,   552,   553,     0,   554,     0,     0,  1512,   556,   557,
       0,     0,   196,   197,   198,   199,  1513,   558,   559,   560,
     561,   562,   563,   564,     0,   565,  1514,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,  1515,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,   211,   595,   596,  1516,   597,   598,   599,   600,   601,
     602,   700,   603,   216,   604,   605,   606,   607,   608,  1517,
     609,   218,   610,   611,   220,   612,  1518,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,  1519,
       0,   624,   625,   224,   626,   627,   628,   629,   630,   631,
       0,  1520,  1521,     0,     0,   633,  1522,   634,  1523,  1524,
     635,   636,   637,   638,   639,   640,   641,     0,  1525,   642,
     643,   644,   645,   646,  1526,     0,   647,   648,   649,   650,
     651,  2190,  1527,     0,   652,   236,   653,   654,   655,     0,
       0,   656,     0,   237,   657,   658,   659,   660,   661,   238,
    1528,  1529,  1530,  1531,  1532,  1533,  1534,  1535,   702,   662,
     663,     0,     0,     0,     0,     0,     0,     0,  1536,  1537,
       0,     0,     0,     0,     0,     0,     0,  1539,   726,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   727,   104,
     105,   681,   728,     0,   107,   108,   109,   110,   729,   730,
     112,   113,   114,   115,     0,   116,   731,   732,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,   417,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,  1471,  1472,  1473,    45,
    1474,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
    1475,     0,     0,   429,   430,     0,   431,   432,   133,   433,
     434,   435,   135,  1476,   137,  1477,  1478,     0,   436,   437,
     438,   439,   440,  1479,  1480,   441,   442,  1481,  1482,   443,
       0,   444,   445,   446,   447,  1483,     0,  1484,     0,   448,
     449,   450,   451,   148,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,   151,   459,     0,  1485,  1486,  1487,
    1488,  1489,  1490,  1491,   460,   461,   462,   463,   695,   464,
    1492,  1493,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,  1494,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,  1495,   490,   491,   492,  1496,
    1497,   493,     0,   494,  1498,   495,     0,   496,     0,   497,
     169,     0,   170,   498,   499,   500,     0,   501,  1499,     0,
     502,     0,   503,   504,   697,   505,   506,   173,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
     174,   175,     0,   517,   518,   519,  1500,  1501,     0,  1502,
       0,   520,   178,   179,   521,   180,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,  1503,   182,   530,   183,
       0,   531,   532,   533,  1504,  1505,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,  1506,
     189,  1507,   545,   546,   191,  1508,   547,   548,   193,   549,
    1509,  1510,   550,  1511,   551,   552,   553,     0,   554,     0,
       0,  1512,   556,   557,     0,     0,   196,   197,   198,   199,
    1513,   558,   559,   560,   561,   562,   563,   564,     0,   565,
    1514,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,  1515,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,   211,   595,   596,  1516,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,  1517,   609,   218,   610,   611,   220,   612,
    1518,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,  1519,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,  1520,  1521,     0,     0,   633,
    1522,   634,  1523,  1524,   635,   636,   637,   638,   639,   640,
     641,     0,  1525,   642,   643,   644,   645,   646,  1526,     0,
     647,   648,   649,   650,   651,   701,  1527,     0,   652,   236,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,  1528,  1529,  1530,  1531,  1532,  1533,
    1534,  1535,   702,   662,   663,     0,     0,     0,     0,     0,
       0,     0,  1536,  1537,     0,     0,     0,     0,     0,  2134,
    2857,  1539,   726,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   727,   104,   105,   681,   728,     0,   107,   108,
     109,   110,   729,   730,   112,   113,   114,   115,     0,   116,
     731,   732,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,   417,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1471,  1472,  1473,    45,  1474,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,  1475,     0,     0,   429,   430,     0,
     431,   432,   133,   433,   434,   435,   135,  1476,   137,  1477,
    1478,     0,   436,   437,   438,   439,   440,  1479,  1480,   441,
     442,  1481,  1482,   443,     0,   444,   445,   446,   447,  1483,
       0,  1484,     0,   448,   449,   450,   451,   148,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,   151,   459,
       0,  1485,  1486,  1487,  1488,  1489,  1490,  1491,   460,   461,
     462,   463,   695,   464,  1492,  1493,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,  1494,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,  1495,
     490,   491,   492,  1496,  1497,   493,     0,   494,  1498,   495,
       0,   496,     0,   497,   169,     0,   170,   498,   499,   500,
       0,   501,  1499,     0,   502,     0,   503,   504,   697,   505,
     506,   173,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,   174,   175,     0,   517,   518,   519,
    1500,  1501,     0,  1502,     0,   520,   178,   179,   521,   180,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
    1503,   182,   530,   183,     0,   531,   532,   533,  1504,  1505,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,  1506,   189,  1507,   545,   546,   191,  1508,
     547,   548,   193,   549,  1509,  1510,   550,  1511,   551,   552,
     553,     0,   554,     0,     0,  1512,   556,   557,     0,     0,
     196,   197,   198,   199,  1513,   558,   559,   560,   561,   562,
     563,   564,     0,   565,  1514,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,  1515,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,   211,
     595,   596,  1516,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,  1517,   609,   218,
     610,   611,   220,   612,  1518,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,  1519,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,  1520,
    1521,     0,     0,   633,  1522,   634,  1523,  1524,   635,   636,
     637,   638,   639,   640,   641,     0,  1525,   642,   643,   644,
     645,   646,  1526,     0,   647,   648,   649,   650,   651,   701,
    1527,     0,   652,   236,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,  1528,  1529,
    1530,  1531,  1532,  1533,  1534,  1535,   702,   662,   663,     0,
       0,     0,     0,     0,     0,     0,  1536,  1537,  1538,     0,
       0,     0,     0,     0,     0,  1539,   726,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   727,   104,   105,   681,
     728,     0,   107,   108,   109,   110,   729,   730,   112,   113,
     114,   115,     0,   116,   731,   732,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,   417,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1471,  1472,  1473,    45,  1474,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,  1475,     0,
       0,   429,   430,     0,   431,   432,   133,   433,   434,   435,
     135,  1476,   137,  1477,  1478,     0,   436,   437,   438,   439,
     440,  1479,  1480,   441,   442,  1481,  1482,   443,     0,   444,
     445,   446,   447,  1483,     0,  1484,     0,   448,   449,   450,
     451,   148,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,   151,   459,     0,  1485,  1486,  1487,  1488,  1489,
    1490,  1491,   460,   461,   462,   463,   695,   464,  1492,  1493,
     465,  1622,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,  1494,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,  1495,   490,   491,   492,  1496,  1497,   493,
       0,   494,  1498,   495,     0,   496,     0,   497,   169,     0,
     170,   498,   499,   500,     0,   501,  1499,     0,   502,     0,
     503,   504,   697,   505,   506,   173,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,   174,   175,
       0,   517,   518,   519,  1500,  1501,     0,  1502,     0,   520,
     178,   179,   521,   180,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,  1503,   182,   530,   183,     0,   531,
     532,   533,  1504,  1505,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,  1506,   189,  1507,
     545,   546,   191,  1508,   547,   548,   193,   549,  1509,  1510,
     550,  1511,   551,   552,   553,     0,   554,     0,     0,  1512,
     556,   557,     0,     0,   196,   197,   198,   199,  1513,   558,
     559,   560,   561,   562,   563,   564,     0,   565,  1514,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,  1515,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,   211,   595,   596,  1516,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,  1517,   609,   218,   610,   611,   220,   612,  1518,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,  1519,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,  1520,  1521,     0,     0,   633,  1522,   634,
    1523,  1524,   635,   636,   637,   638,   639,   640,   641,     0,
    1525,   642,   643,   644,   645,   646,  1526,     0,   647,   648,
     649,   650,   651,   701,  1527,     0,   652,   236,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,  1528,  1529,  1530,  1531,  1532,  1533,  1534,  1535,
     702,   662,   663,     0,     0,     0,     0,     0,     0,     0,
    1536,  1537,     0,     0,     0,     0,     0,     0,     0,  1539,
     726,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     727,   104,   105,   681,   728,     0,   107,   108,   109,   110,
     729,   730,   112,   113,   114,   115,     0,   116,   731,   732,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,   417,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1471,  1472,
    1473,    45,  1474,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,  2319,   426,   427,   428,     0,     0,
       0,     0,  1475,     0,     0,   429,   430,     0,   431,   432,
     133,   433,   434,   435,   135,  1476,   137,  1477,  1478,     0,
     436,   437,   438,   439,   440,  1479,  1480,   441,   442,  1481,
    1482,   443,     0,   444,   445,   446,   447,  1483,     0,  1484,
       0,   448,   449,   450,   451,   148,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,   151,   459,     0,  1485,
    1486,  1487,  1488,  1489,  1490,  1491,   460,   461,   462,   463,
     695,   464,  1492,  1493,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,  1494,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,  1495,   490,   491,
     492,  1496,  1497,   493,     0,   494,  1498,   495,     0,   496,
       0,   497,   169,     0,   170,   498,   499,   500,     0,   501,
    1499,     0,   502,     0,   503,   504,   697,   505,   506,   173,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,   174,   175,     0,   517,   518,   519,  1500,  1501,
       0,  1502,     0,   520,   178,   179,   521,   180,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,  1503,   182,
     530,   183,     0,   531,   532,   533,  1504,  1505,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,  1506,   189,  1507,   545,   546,   191,  1508,   547,   548,
     193,   549,  1509,  1510,   550,  1511,   551,   552,   553,     0,
     554,     0,     0,  1512,   556,   557,     0,     0,   196,   197,
     198,   199,  1513,   558,   559,   560,   561,   562,   563,   564,
       0,   565,  1514,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,  1515,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,   211,   595,   596,
    1516,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,  1517,   609,   218,   610,   611,
     220,   612,  1518,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,  1519,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,  1520,  1521,     0,
       0,   633,  1522,   634,  1523,  1524,   635,   636,   637,   638,
     639,   640,   641,     0,  1525,   642,   643,   644,   645,   646,
    1526,     0,   647,   648,   649,   650,   651,   701,  1527,     0,
     652,   236,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,  1528,  1529,  1530,  1531,
    1532,  1533,  1534,  1535,   702,   662,   663,     0,     0,     0,
       0,     0,     0,     0,  1536,  1537,     0,     0,     0,     0,
       0,     0,     0,  1539,   726,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   727,   104,   105,   681,   728,     0,
     107,   108,   109,   110,   729,   730,   112,   113,   114,   115,
       0,   116,   731,   732,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,   417,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1471,  1472,  1473,    45,  1474,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,  1475,     0,     0,   429,
     430,     0,   431,   432,   133,   433,   434,   435,   135,  1476,
     137,  1477,  1478,     0,   436,   437,   438,   439,   440,  1479,
    1480,   441,   442,  1481,  1482,   443,     0,   444,   445,   446,
     447,  1483,     0,  1484,     0,   448,   449,   450,   451,   148,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
     151,   459,     0,  1485,  1486,  1487,  1488,  1489,  1490,  1491,
     460,   461,   462,   463,   695,   464,  1492,  1493,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,  1494,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,  1495,   490,   491,   492,  1496,  1497,   493,     0,   494,
    1498,   495,     0,   496,     0,   497,   169,  2910,   170,   498,
     499,   500,     0,   501,  1499,     0,   502,     0,   503,   504,
     697,   505,   506,   173,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,   174,   175,     0,   517,
     518,   519,  1500,  1501,     0,  1502,     0,   520,   178,   179,
     521,   180,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,  1503,   182,   530,   183,     0,   531,   532,   533,
    1504,  1505,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,  1506,   189,  1507,   545,   546,
     191,  1508,   547,   548,   193,   549,  1509,  1510,   550,  1511,
     551,   552,   553,     0,   554,     0,     0,  1512,   556,   557,
       0,     0,   196,   197,   198,   199,  1513,   558,   559,   560,
     561,   562,   563,   564,     0,   565,  1514,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,  1515,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,   211,   595,   596,  1516,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,  1517,
     609,   218,   610,   611,   220,   612,  1518,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,  1519,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,  1520,  1521,     0,     0,   633,  1522,   634,  1523,  1524,
     635,   636,   637,   638,   639,   640,   641,     0,  1525,   642,
     643,   644,   645,   646,  1526,     0,   647,   648,   649,   650,
     651,   701,  1527,     0,   652,   236,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
    1528,  1529,  1530,  1531,  1532,  1533,  1534,  1535,   702,   662,
     663,     0,     0,     0,     0,     0,     0,     0,  1536,  1537,
       0,     0,     0,     0,     0,     0,     0,  1539,   726,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   727,   104,
     105,   681,   728,     0,   107,   108,   109,   110,   729,   730,
     112,   113,   114,   115,     0,   116,   731,   732,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,   417,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,  1471,  1472,  1473,    45,
    1474,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
    1475,     0,     0,   429,   430,     0,   431,   432,   133,   433,
     434,   435,   135,  1476,   137,  1477,  1478,     0,   436,   437,
     438,   439,   440,  1479,  1480,   441,   442,  1481,  1482,   443,
       0,   444,   445,   446,   447,  1483,     0,  1484,     0,   448,
     449,   450,   451,   148,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,   151,   459,     0,  1485,  1486,  1487,
    1488,  1489,  1490,  1491,   460,   461,   462,   463,   695,   464,
    1492,  1493,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,  1494,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,  1495,   490,   491,   492,  1496,
    1497,   493,     0,   494,  1498,   495,     0,   496,     0,   497,
     169,     0,   170,   498,   499,   500,     0,   501,  1499,     0,
     502,     0,   503,   504,   697,   505,   506,   173,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
     174,   175,     0,   517,   518,   519,  1500,  1501,     0,  1502,
       0,   520,   178,   179,   521,   180,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,  1503,   182,   530,   183,
       0,   531,   532,   533,  1504,  1505,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,  1506,
     189,  1507,   545,   546,   191,  1508,   547,   548,   193,   549,
    1509,  1510,   550,  1511,   551,   552,   553,     0,   554,     0,
       0,  1512,   556,   557,     0,     0,   196,   197,   198,   199,
    1513,   558,   559,   560,   561,   562,   563,   564,     0,   565,
    1514,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,  1515,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,   211,   595,   596,  1516,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,  1517,   609,   218,   610,   611,   220,   612,
    1518,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,  1519,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,  1520,  1521,     0,     0,   633,
    1522,   634,  1523,  1524,   635,   636,   637,   638,   639,   640,
     641,     0,  1525,   642,   643,   644,   645,   646,  1526,     0,
     647,   648,   649,   650,   651,   701,  1527,  4161,   652,   236,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,  1528,  1529,  1530,  1531,  1532,  1533,
    1534,  1535,   702,   662,   663,     0,     0,     0,     0,     0,
       0,     0,  1536,  1537,     0,     0,     0,     0,     0,     0,
       0,  1539,   726,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   727,   104,   105,   681,   728,     0,   107,   108,
     109,   110,   729,   730,   112,   113,   114,   115,     0,   116,
     731,   732,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,   417,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1471,  1472,  1473,    45,  1474,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,  1475,     0,     0,   429,   430,     0,
     431,   432,   133,   433,   434,   435,   135,  1476,   137,  1477,
    1478,     0,   436,   437,   438,   439,   440,  1479,  1480,   441,
     442,  1481,  1482,   443,     0,   444,   445,   446,   447,  1483,
       0,  1484,     0,   448,   449,   450,   451,   148,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,   151,   459,
    4173,  1485,  1486,  1487,  1488,  1489,  1490,  1491,   460,   461,
     462,   463,   695,   464,  1492,  1493,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,  1494,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,  1495,
     490,   491,   492,  1496,  1497,   493,     0,   494,  1498,   495,
       0,   496,     0,   497,   169,     0,   170,   498,   499,   500,
       0,   501,  1499,     0,   502,     0,   503,   504,   697,   505,
     506,   173,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,   174,   175,     0,   517,   518,   519,
    1500,  1501,     0,  1502,     0,   520,   178,   179,   521,   180,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
    1503,   182,   530,   183,     0,   531,   532,   533,  1504,  1505,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,  1506,   189,  1507,   545,   546,   191,  1508,
     547,   548,   193,   549,  1509,  1510,   550,  1511,   551,   552,
     553,     0,   554,     0,     0,  1512,   556,   557,     0,     0,
     196,   197,   198,   199,  1513,   558,   559,   560,   561,   562,
     563,   564,     0,   565,  1514,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,  1515,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,   211,
     595,   596,  1516,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,  1517,   609,   218,
     610,   611,   220,   612,  1518,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,  1519,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,  1520,
    1521,     0,     0,   633,  1522,   634,  1523,  1524,   635,   636,
     637,   638,   639,   640,   641,     0,  1525,   642,   643,   644,
     645,   646,  1526,     0,   647,   648,   649,   650,   651,   701,
    1527,     0,   652,   236,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,  1528,  1529,
    1530,  1531,  1532,  1533,  1534,  1535,   702,   662,   663,     0,
       0,     0,     0,     0,     0,     0,  1536,  1537,     0,     0,
       0,     0,     0,     0,     0,  1539,   726,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   727,   104,   105,   681,
     728,     0,   107,   108,   109,   110,   729,   730,   112,   113,
     114,   115,     0,   116,   731,   732,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,   417,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1471,  1472,  1473,    45,  1474,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,  1475,     0,
       0,   429,   430,     0,   431,   432,   133,   433,   434,   435,
    5037,  1476,   137,  1477,  1478,     0,   436,   437,   438,   439,
     440,  1479,  1480,   441,   442,  1481,  1482,   443,     0,   444,
     445,   446,   447,  1483,     0,  1484,     0,   448,   449,   450,
     451,   148,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,   151,   459,  5038,  1485,  1486,  1487,  1488,  1489,
    1490,  1491,   460,   461,   462,   463,   695,   464,  1492,  1493,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,  1494,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,  1495,   490,   491,   492,  1496,  1497,   493,
       0,   494,  1498,   495,     0,   496,     0,   497,   169,     0,
     170,   498,   499,   500,     0,   501,  1499,     0,   502,     0,
     503,   504,   697,   505,   506,   173,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,   174,   175,
       0,   517,   518,   519,  1500,  1501,     0,  1502,     0,   520,
     178,   179,   521,   180,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,  1503,   182,   530,   183,     0,   531,
     532,   533,  1504,  1505,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,  1506,   189,  1507,
     545,   546,   191,  1508,   547,   548,   193,   549,  1509,  1510,
     550,  1511,   551,   552,   553,     0,   554,     0,     0,  1512,
     556,   557,     0,     0,   196,   197,   198,   199,  1513,   558,
     559,   560,   561,   562,   563,   564,     0,   565,  1514,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,  1515,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,   211,   595,   596,  1516,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,  1517,   609,   218,   610,   611,   220,   612,  1518,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,  1519,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,  1520,  1521,     0,     0,   633,  1522,   634,
    1523,  1524,   635,   636,   637,   638,  5039,   640,   641,     0,
    1525,   642,   643,   644,   645,   646,  1526,     0,   647,   648,
     649,   650,   651,   701,  1527,     0,   652,   236,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,  1528,  1529,  1530,  1531,  1532,  1533,  1534,  1535,
     702,   662,   663,     0,     0,     0,     0,     0,     0,     0,
    1536,  1537,     0,     0,     0,     0,     0,     0,     0,  1539,
     726,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     727,   104,   105,   681,   728,     0,   107,   108,   109,   110,
     729,   730,   112,   113,   114,   115,     0,   116,   731,   732,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,   417,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1471,  1472,
    1473,    45,  1474,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,  1475,     0,     0,   429,   430,     0,   431,   432,
     133,   433,   434,   435,   135,  1476,   137,  1477,  1478,     0,
     436,   437,   438,   439,   440,  1479,  1480,   441,   442,  1481,
    1482,   443,     0,   444,   445,   446,   447,  1483,     0,  1484,
       0,   448,   449,   450,   451,   148,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,   151,   459,  5038,  1485,
    1486,  1487,  1488,  1489,  1490,  1491,   460,   461,   462,   463,
     695,   464,  1492,  1493,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,  1494,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,  1495,   490,   491,
     492,  1496,  1497,   493,     0,   494,  1498,   495,     0,   496,
       0,   497,   169,     0,   170,   498,   499,   500,     0,   501,
    1499,     0,   502,     0,   503,   504,   697,   505,   506,   173,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,   174,   175,     0,   517,   518,   519,  1500,  1501,
       0,  1502,     0,   520,   178,   179,   521,   180,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,  1503,   182,
     530,   183,     0,   531,   532,   533,  1504,  1505,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,  1506,   189,  1507,   545,   546,   191,  1508,   547,   548,
     193,   549,  1509,  1510,   550,  1511,   551,   552,   553,     0,
     554,     0,     0,  1512,   556,   557,     0,     0,   196,   197,
     198,   199,  1513,   558,   559,   560,   561,   562,   563,   564,
       0,   565,  1514,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,  1515,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,   211,   595,   596,
    1516,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,  1517,   609,   218,   610,   611,
     220,   612,  1518,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,  1519,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,  1520,  1521,     0,
       0,   633,  1522,   634,  1523,  1524,   635,   636,   637,   638,
    5039,   640,   641,     0,  1525,   642,   643,   644,   645,   646,
    1526,     0,   647,   648,   649,   650,   651,   701,  1527,     0,
     652,   236,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,  1528,  1529,  1530,  1531,
    1532,  1533,  1534,  1535,   702,   662,   663,     0,     0,     0,
       0,     0,     0,     0,  1536,  1537,     0,     0,     0,     0,
       0,     0,     0,  1539,   726,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   727,   104,   105,   681,   728,     0,
     107,   108,   109,   110,   729,   730,   112,   113,   114,   115,
       0,   116,   731,   732,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,   417,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1471,  1472,  1473,    45,  1474,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,  1475,     0,     0,   429,
     430,     0,   431,   432,   133,   433,   434,   435,   135,  1476,
     137,  1477,  1478,     0,   436,   437,   438,   439,   440,  1479,
    1480,   441,   442,  1481,  1482,   443,     0,   444,   445,   446,
     447,  1483,     0,  1484,     0,   448,   449,   450,   451,   148,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
     151,   459,     0,  1485,  1486,  1487,  1488,  1489,  1490,  1491,
     460,   461,   462,   463,   695,   464,  1492,  1493,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,  1494,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,  1495,   490,   491,   492,  1496,  1497,   493,     0,   494,
    1498,   495,     0,   496,     0,   497,   169,     0,   170,   498,
     499,   500,     0,   501,  1499,     0,   502,     0,   503,   504,
     697,   505,   506,   173,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,   174,   175,     0,   517,
     518,   519,  1500,  1501,     0,  1502,     0,   520,   178,   179,
     521,   180,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,  1503,   182,   530,   183,     0,   531,   532,   533,
    1504,  1505,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,  1506,   189,  1507,   545,   546,
     191,  1508,   547,   548,   193,   549,  1509,  1510,   550,  1511,
     551,   552,   553,     0,   554,     0,     0,  1512,   556,   557,
       0,     0,   196,   197,   198,   199,  1513,   558,   559,   560,
     561,   562,   563,   564,     0,   565,  1514,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,  1515,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,   211,   595,   596,  1516,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,  1517,
     609,   218,   610,   611,   220,   612,  1518,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,  1519,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,  1520,  1521,     0,     0,   633,  1522,   634,  1523,  1524,
     635,   636,   637,   638,   639,   640,   641,     0,  1525,   642,
     643,   644,   645,   646,  1526,     0,   647,   648,   649,   650,
     651,   701,  1527,     0,   652,   236,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
    1528,  1529,  1530,  1531,  1532,  1533,  1534,  1535,   702,   662,
     663,     0,     0,     0,     0,     0,     0,     0,  1536,  1537,
       0,     0,     0,     0,     0,     0,     0,  1539,   726,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   727,   104,
     105,   681,   728,     0,   107,   108,   109,   110,   729,   730,
     112,   113,   114,   115,     0,   116,   731,   732,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,   417,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,  1471,  1472,  1473,    45,
    1474,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
    1475,     0,     0,   429,   430,     0,   431,   432,   133,   433,
     434,   435,   135,  1476,   137,  1477,  1478,     0,   436,   437,
     438,   439,   440,  1479,  1480,   441,   442,  1481,  1482,   443,
       0,   444,   445,   446,   447,  1483,     0,  1484,     0,   448,
     449,   450,   451,   148,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,   151,   459,     0,  1485,  1486,  1487,
    1488,  1489,  1490,  1491,   460,   461,   462,   463,   695,   464,
    1492,  1493,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,  1494,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,  1495,   490,   491,   492,  1496,
    1497,   493,     0,   494,  1498,   495,     0,   496,     0,   497,
     169,     0,   170,   498,   499,   500,     0,   501,  1499,     0,
     502,     0,   503,   504,   697,   505,   506,   173,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
     174,   175,     0,   517,   518,   519,  1500,  1501,     0,  1502,
       0,   520,   178,   179,   521,   180,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,  1503,   182,   530,   183,
       0,   531,   532,   533,  1504,  1505,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,  1506,
     189,  1507,   545,   546,   191,  1508,   547,   548,   193,   549,
    1509,  1510,   550,  1511,   551,   552,   553,     0,   554,     0,
       0,  1512,   556,   557,     0,     0,   196,   197,   198,   199,
    1513,   558,   559,   560,   561,   562,   563,   564,     0,   565,
    1514,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,  1515,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,   211,   595,   596,  1516,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,  1517,   609,   218,   610,   611,   220,   612,
    1518,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,  1519,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,  1520,  1521,     0,     0,   633,
    1522,   634,  1523,  1524,   635,   636,   637,   638,   639,   640,
     641,     0,  1525,   642,   643,   644,   645,   646,  1526,     0,
     647,   648,   649,   650,   651,   701,  1527,     0,   652,   236,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,  1528,  1529,  1530,  1531,  1532,  1533,
    1534,  1535,   702,   662,   663,     0,     0,     0,     0,     0,
       0,     0,  2322,  2323,     0,     0,     0,     0,     0,     0,
       0,  1539,   726,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   727,   104,   105,   681,   728,     0,   107,   108,
     109,   110,   729,   730,   112,   113,   114,   115,     0,   116,
     731,   732,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,   417,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1471,  1472,  1473,    45,  1474,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,  1475,     0,     0,   429,   430,     0,
     431,   432,   133,   433,   434,   435,   135,  1476,   137,  1477,
    1478,     0,   436,   437,   438,   439,   440,  1479,  1480,   441,
     442,  1481,  1482,   443,     0,   444,   445,   446,   447,  1483,
       0,  1484,     0,   448,   449,   450,   451,   148,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,   151,   459,
       0,  1485,  1486,  1487,  1488,  1489,  1490,  1491,   460,   461,
     462,   463,   695,   464,  1492,  1493,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,  1494,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,  1495,
     490,   491,   492,  1496,  1497,   493,     0,   494,  1498,   495,
       0,   496,     0,   497,   169,     0,   170,   498,   499,   500,
       0,   501,  1499,     0,   502,     0,   503,   504,   697,   505,
     506,   173,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,   174,   175,     0,   517,   518,   519,
    1500,  1501,     0,  1502,     0,   520,   178,   179,   521,   180,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
    1503,   182,   530,   183,     0,   531,   532,   533,  1504,  1505,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,  1506,   189,  1507,   545,   546,   191,  1508,
     547,   548,   193,   549,  1509,  1510,   550,  1511,   551,   552,
     553,     0,   554,     0,     0,  1512,   556,   557,     0,     0,
     196,   197,   198,   199,  1513,   558,   559,   560,   561,   562,
     563,   564,     0,   565,  1514,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,  1515,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,   211,
     595,   596,  1516,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,  1517,   609,   218,
     610,   611,   220,   612,  1518,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,  1519,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,  1520,
    1521,     0,     0,   633,  1522,   634,  1523,  1524,   635,   636,
     637,   638,   639,   640,   641,     0,  1525,   642,   643,   644,
     645,   646,  1526,     0,   647,   648,   649,   650,   651,   701,
    1527,     0,   652,   236,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,  4463,  1528,  1529,
    1530,  1531,  1532,  1533,  1534,  1535,   702,   662,   663,     0,
       0,     0,     0,     0,     0,     0,  1536,  1537,     0,     0,
       0,     0,     0,     0,     0,  1539,   726,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   727,   104,   105,   681,
     728,     0,   107,   108,   109,   110,   729,   730,   112,   113,
     114,   115,     0,   116,   731,   732,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,   417,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1471,  1472,  1473,    45,  1474,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,  1475,     0,
       0,   429,   430,     0,   431,   432,   133,   433,   434,   435,
     135,  1476,   137,  1477,  1478,     0,   436,   437,   438,   439,
     440,  1479,  1480,   441,   442,  1481,  1482,   443,     0,   444,
     445,   446,   447,  1483,     0,  1484,     0,   448,   449,   450,
     451,   148,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,   151,   459,     0,  1485,  1486,  1487,  1488,  1489,
    1490,  1491,   460,   461,   462,   463,   695,   464,  1492,  1493,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,  1494,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,  1495,   490,   491,   492,  1496,  1497,   493,
       0,   494,  1498,   495,     0,   496,     0,   497,   169,     0,
     170,   498,   499,   500,     0,   501,  1499,     0,   502,     0,
     503,   504,   697,   505,   506,   173,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,   174,   175,
       0,   517,   518,   519,  1500,  1501,     0,  1502,     0,   520,
     178,   179,   521,   180,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,  1503,   182,   530,   183,     0,   531,
     532,   533,  1504,  1505,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,  1506,   189,  1507,
     545,  4472,   191,  1508,   547,   548,   193,   549,  1509,  1510,
     550,  1511,   551,   552,   553,     0,   554,     0,     0,  1512,
     556,   557,     0,     0,   196,   197,   198,   199,  1513,   558,
     559,   560,   561,   562,   563,   564,     0,   565,  1514,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,  1515,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,   211,   595,   596,  1516,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,  1517,   609,   218,   610,   611,   220,   612,  1518,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,  1519,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,  1520,  1521,     0,     0,   633,  1522,   634,
    1523,  1524,   635,   636,   637,   638,   639,   640,   641,     0,
    1525,   642,   643,   644,   645,   646,  1526,     0,   647,   648,
     649,   650,   651,   701,  1527,     0,   652,   236,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,  1528,  1529,  1530,  1531,  1532,  1533,  1534,  1535,
     702,   662,   663,     0,     0,     0,     0,     0,     0,     0,
    1536,  1537,     0,     0,     0,     0,     0,     0,     0,  1539,
     726,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     727,   104,   105,   681,   728,     0,   107,   108,   109,   110,
     729,   730,   112,   113,   114,   115,     0,   116,   731,   732,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,   417,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1471,  1472,
    1473,    45,  1474,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,  1475,     0,     0,   429,   430,     0,   431,   432,
     133,   433,   434,   435,   135,  1476,   137,  1477,  1478,     0,
     436,   437,   438,   439,   440,  1479,  1480,   441,   442,  1481,
    1482,   443,     0,   444,   445,   446,   447,  1483,     0,  1484,
       0,   448,   449,   450,   451,   148,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,   151,   459,     0,  1485,
    1486,  1487,  1488,  1489,  1490,  1491,   460,   461,   462,   463,
     695,   464,  1492,  1493,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,  1494,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,  1495,   490,   491,
     492,  1496,  1497,   493,     0,   494,  1498,   495,     0,   496,
       0,   497,   169,     0,   170,   498,   499,   500,     0,   501,
    1499,     0,   502,     0,   503,   504,   697,   505,   506,   173,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,   174,   175,     0,   517,   518,   519,  1500,  1501,
       0,  1502,     0,   520,   178,   179,   521,   180,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,  1503,   182,
     530,   183,     0,   531,   532,   533,  1504,  1505,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,  1506,   189,  1507,   545,   546,   191,     0,   547,   548,
     193,   549,  1509,  1510,   550,  1511,   551,   552,   553,     0,
     554,     0,     0,  1512,   556,   557,     0,     0,   196,   197,
     198,   199,  1513,   558,   559,   560,   561,   562,   563,   564,
       0,   565,  1514,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,  1515,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,   211,   595,   596,
    1516,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,  1517,   609,   218,   610,   611,
     220,   612,  1518,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,  1519,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,  1520,  1521,     0,
       0,   633,  1522,   634,  1523,  1524,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
    1526,     0,   647,   648,   649,   650,   651,   701,  1527,     0,
     652,   236,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,  1528,  1529,  1530,  1531,
    1532,  1533,  1534,  1535,   702,   662,   663,     0,     0,     0,
       0,     0,     0,     0,  2892,  2893,     0,     0,     0,     0,
       0,     0,     0,  1539,   726,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   727,   104,   105,   681,   728,     0,
     107,   108,   109,   110,   729,   730,   112,   113,   114,   115,
       0,   116,   731,   732,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,   417,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1471,  1472,     0,    45,  1474,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,  1475,     0,     0,   429,
     430,     0,   431,   432,   133,   433,   434,   435,   135,  1476,
     137,  1477,  1478,     0,   436,   437,   438,   439,   440,  1479,
    1480,   441,   442,  1481,  1482,   443,     0,   444,   445,   446,
     447,  1483,     0,  1484,     0,   448,   449,   450,   451,   148,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
     151,   459,     0,  1485,  1486,  1487,  1488,  1489,  1490,  1491,
     460,   461,   462,   463,   695,   464,  1492,  1493,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,  1494,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,  1495,   490,   491,   492,  1496,  1497,   493,     0,   494,
    1498,   495,     0,   496,     0,   497,   169,     0,   170,   498,
     499,   500,     0,   501,  1499,     0,   502,     0,   503,   504,
     697,   505,   506,   173,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,   174,   175,     0,   517,
     518,   519,  1500,  1501,     0,  1502,     0,   520,   178,   179,
     521,   180,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,  1503,   182,   530,   183,     0,   531,   532,   533,
    1504,  1505,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,  1506,   189,  1507,   545,   546,
     191,     0,   547,   548,   193,   549,  1509,  1510,   550,  1511,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,   197,   198,   199,  1513,   558,   559,   560,
     561,   562,   563,   564,     0,   565,  1514,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,  1515,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,   211,   595,   596,  3031,  3032,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,  1517,
     609,   218,   610,   611,   220,   612,  1518,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,  1519,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,  1520,  1521,     0,     0,   633,  1522,   634,  1523,  1524,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,  1526,     0,   647,   648,   649,   650,
     651,   701,  1527,     0,   652,   236,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
    1528,  1529,  1530,  1531,  1532,  1533,  1534,  1535,   702,   662,
     663,     0,     0,     0,     0,     0,     0,     0,  3033,  3034,
       0,     0,     0,     0,     0,     0,     0,  1539,   726,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   727,   104,
     105,   681,   728,     0,   107,   108,   109,   110,   729,   730,
     112,   113,   114,   115,     0,   116,   731,   732,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,   417,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,  1471,  1472,  1473,    45,
    1474,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
    1475,     0,     0,   429,   430,     0,   431,   432,   133,   433,
     434,   435, -2639,  1476,   137,  1477,  1478,     0,   436,   437,
     438,   439,   440,  1479,  1480,   441,   442,  1481,  1482,   443,
       0,   444,   445,   446,   447,  1483,     0,  1484,     0,   448,
     449,   450,   451,   148,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,   151,   459,  5038,  1485,  1486,  1487,
    1488,  1489,  1490,  1491,   460,   461,   462,   463,   695,   464,
    1492,  1493,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,  1494,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,  1495,   490,   491,   492,  1496,
    1497,   493,     0,   494,  1498,   495,     0,   496,     0,   497,
     169,     0,   170,   498,   499,   500,     0,   501,  1499,     0,
     502,     0,   503,   504,   697,   505,   506,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
     174,   175,     0,   517,   518,   519,  1500,  1501,     0,  1502,
       0,   520,   178,   179,   521,   180,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,  1503,   182,   530,     0,
       0,   531,   532,   533,  1504,  1505,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,  1506,
     189,  1507,   545,   546,   191,     0,   547,   548,   193,   549,
    1509,  1510,   550,  1511,   551,   552,   553,     0,   554,     0,
       0,  1512,   556,   557,     0,     0,   196,   197,   198,   199,
    1513,   558,   559,   560,   561,   562,   563,   564,     0,   565,
    1514,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,  1515,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,   211,   595,   596,  1516,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,  1517,   609,   218,   610,   611,     0,   612,
    1518,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,  1519,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,  1520,  1521,     0,     0,   633,
    1522,   634,  1523,  1524,   635,   636,   637,   638,  5039,   640,
     641,     0,  1525,   642,   643,   644,   645,   646,  1526,     0,
     647,   648,   649,   650,   651,   701,  1527,     0,   652,   236,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,  1528,  1529,  1530,  1531,  1532,  1533,
    1534,  1535,   702,   662,   663,     0,     0,     0,     0,     0,
       0,     0,  1536,  1537,     0,     0,     0,     0,     0,     0,
       0,  1539,   726,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   727,   104,   105,   681,   728,     0,   107,   108,
     109,   110,   729,   730,   112,   113,   114,   115,     0,   116,
     731,   732,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,   417,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1471,  1472,     0,    45,  1474,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,  1475,     0,     0,   429,   430,     0,
     431,   432,   133,   433,   434,   435,   135,  1476,   137,  1477,
    1478,     0,   436,   437,   438,   439,   440,  1479,  1480,   441,
     442,  1481,  1482,   443,     0,   444,   445,   446,   447,  1483,
       0,  1484,     0,   448,   449,   450,   451,   148,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,   151,   459,
       0,  1485,  1486,  1487,  1488,  1489,  1490,  1491,   460,   461,
     462,   463,   695,   464,  1492,  1493,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,  1494,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,  1495,
     490,   491,   492,  1496,  1497,   493,     0,   494,  1498,   495,
       0,   496,     0,   497,   169,     0,   170,   498,   499,   500,
       0,   501,  1499,     0,   502,     0,   503,   504,   697,   505,
     506,   173,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,   174,   175,     0,   517,   518,   519,
    1500,  1501,     0,  1502,     0,   520,   178,   179,   521,   180,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
    1503,   182,   530,   183,     0,   531,   532,   533,  1504,  1505,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,  1506,   189,  1507,   545,   546,   191,     0,
     547,   548,   193,   549,  1509,  1510,   550,  1511,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,   197,   198,   199,  1513,   558,   559,   560,   561,   562,
     563,   564,     0,   565,  1514,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,  1515,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,   211,
     595,   596,  1516,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,  1517,   609,   218,
     610,   611,   220,   612,  1518,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,  1519,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,  1520,
    1521,     0,     0,   633,  1522,   634,  1523,  1524,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,  1526,     0,   647,   648,   649,   650,   651,   701,
    1527,     0,   652,   236,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,  1528,  1529,
    1530,  1531,  1532,  1533,  1534,  1535,   702,   662,   663,     0,
       0,     0,   726,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,  1539,    98,    99,   100,   101,
     102,   103,   727,   104,   105,   681,   728,     0,   107,   108,
     109,   110,   729,   730,   112,   113,   114,   115,     0,   116,
     731,   732,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,   417,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1471,  1472,     0,    45,  1474,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,  1475,     0,     0,   429,   430,     0,
     431,   432,   133,   433,   434,   435,   135,  1476,   137,  1477,
    1478,     0,  4080,   437,   438,   439,   440,  1479,  1480,   441,
     442,  1481,  1482,   443,     0,   444,   445,   446,   447,  1483,
       0,  1484,     0,   448,   449,   450,   451,   148,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,   151,   459,
       0,  1485,  1486,  1487,  1488,  1489,  1490,  1491,   460,   461,
     462,   463,   695,   464,  1492,  1493,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,  1494,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,  1495,
     490,   491,   492,  1496,  1497,   493,     0,   494,  1498,   495,
       0,   496,     0,   497,   169,     0,   170,   498,   499,   500,
       0,   501,  1499,     0,   502,     0,   503,   504,   697,   505,
     506,   173,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,   174,   175,     0,   517,   518,   519,
    1500,  1501,     0,  1502,     0,   520,   178,   179,   521,   180,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
    1503,   182,   530,   183,     0,   531,   532,   533,  1504,  1505,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,  1506,   189,  1507,   545,   546,   191,     0,
     547,   548,   193,   549,  1509,  1510,   550,  1511,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,   197,   198,   199,  1513,   558,   559,   560,   561,   562,
     563,   564,     0,   565,  1514,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,  1515,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,   211,
     595,   596,  1516,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,  1517,   609,   218,
     610,   611,   220,   612,  1518,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,  1519,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,  1520,
    1521,     0,     0,   633,  1522,   634,  1523,  1524,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,  1526,     0,   647,   648,   649,   650,   651,   701,
    1527,     0,   652,   236,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,  1528,  1529,
    1530,  1531,  1532,  1533,  1534,  1535,   702,   662,   663,     0,
       0,     0,   726,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,  1539,    98,    99,   100,   101,
     102,   103,   727,   104,   105,   681,   728,     0,   107,   108,
     109,   110,   729,   730,   112,   113,   114,   115,     0,   116,
     731,   732,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,   417,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1471,  1472,  1473,    45,  1474,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,  1475,     0,     0,   429,   430,     0,
     431,   432,   133,   433,   434,   435,     0,  1476,   137,  1477,
    1478,     0,   436,   437,   438,   439,   440,  1479,  1480,   441,
     442,  1481,  1482,   443,     0,   444,   445,   446,   447,  1483,
       0,  1484,     0,   448,   449,   450,   451,   148,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,   151,   459,
       0,  1485,  1486,  1487,  1488,  1489,  1490,  1491,   460,   461,
     462,   463,   695,   464,  1492,  1493,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,  1494,   478,   479,     0,   480,   481,   482,
       0,   483,     0,   485,     0,   486,   487,   488,   489,  1495,
     490,   491,   492,  1496,  1497,   493,     0,   494,  1498,   495,
       0,   496,     0,   497,   169,     0,   170,   498,   499,   500,
       0,   501,  1499,     0,   502,     0,   503,   504,   697,   505,
     506,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,   174,   175,     0,   517,   518,   519,
    1500,  1501,     0,  1502,     0,   520,   178,   179,   521,   180,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
    1503,   182,   530,     0,     0,   531,   532,   533,  1504,  1505,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,  1506,   189,  1507,   545,   546,   191,     0,
     547,   548,   193,   549,  1509,  1510,   550,  1511,   551,   552,
     553,     0,   554,     0,     0,  1512,   556,   557,     0,     0,
     196,   197,   198,   199,  1513,   558,   559,   560,   561,   562,
     563,   564,     0,   565,  1514,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,  1515,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,   211,
     595,   596,  1516,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,  1517,   609,   218,
     610,   611,     0,   612,  1518,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,  1519,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,  1520,
    1521,     0,     0,   633,  1522,   634,  1523,  1524,   635,   636,
     637,   638,   639,   640,   641,     0,  1525,   642,   643,   644,
     645,   646,  1526,     0,   647,   648,   649,   650,   651,   701,
    1527,     0,   652,   236,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,  1528,  1529,
    1530,  1531,  1532,  1533,  1534,  1535,   702,   662,   663,     0,
       0,     0,     0,     0,     0,     0,  1536,  1537,     0,     0,
       0,     0,     0,     0,     0,  1539,   726,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   727,   104,   105,   681,
     728,     0,   107,   108,   109,   110,   729,   730,   112,   113,
     114,   115,     0,   116,   731,   732,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,   417,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1471,  1472,  1473,    45,  1474,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,  1475,     0,
       0,   429,   430,     0,   431,   432,   133,   433,   434,   435,
       0,  1476,   137,  1477,  1478,     0,   436,   437,   438,   439,
     440,  1479,  1480,   441,   442,  1481,  1482,   443,     0,   444,
     445,   446,   447,  1483,     0,  1484,     0,   448,   449,   450,
     451,   148,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,   151,   459,     0,  1485,  1486,  1487,  1488,  1489,
    1490,  1491,   460,   461,   462,   463,   695,   464,  1492,  1493,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,  1494,   478,   479,
       0,   480,   481,   482,     0,   483,     0,   485,     0,   486,
     487,   488,   489,  1495,   490,   491,   492,  1496,  1497,   493,
       0,   494,  1498,   495,     0,   496,     0,   497,   169,     0,
     170,   498,   499,   500,     0,   501,  1499,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,   174,   175,
       0,   517,   518,   519,  1500,  1501,     0,  1502,     0,   520,
     178,   179,   521,   180,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,  1503,   182,   530,     0,     0,   531,
     532,   533,  1504,  1505,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,  1506,   189,  1507,
     545,   546,   191,     0,   547,   548,   193,   549,  1509,  1510,
     550,  1511,   551,   552,   553,     0,   554,     0,     0,  1512,
     556,   557,     0,     0,   196,   197,   198,   199,  1513,   558,
     559,   560,   561,   562,   563,   564,     0,   565,  1514,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,  1515,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,   211,   595,   596,  1516,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,  1517,   609,   218,   610,   611,     0,   612,  1518,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,  1519,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,  1520,  1521,     0,     0,   633,  1522,   634,
    1523,  1524,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,  1526,     0,   647,   648,
     649,   650,   651,   701,  1527,     0,   652,   236,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,  1528,  1529,  1530,  1531,  1532,  1533,  1534,  1535,
     702,   662,   663,     0,     0,     0,     0,     0,     0,     0,
    2892,  2893,     0,     0,     0,     0,     0,     0,     0,  1539,
     726,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     727,   104,   105,   681,   728,     0,   107,   108,   109,   110,
     729,   730,   112,   113,   114,   115,     0,   116,   731,   732,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
     133,   433,   434,   435,   135,   136,   137,   138,   139,     0,
     436,   437,   438,   439,   440,     0,  1480,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,  1483,     0,  1484,
       0,   448,   449,   450,   451,   148,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,   151,   459,     0,  1485,
    1486,  1487,  1488,  1489,  1490,  1491,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,  1496,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,   169,     0,   170,   498,   499,   500,     0,   501,
    1499,     0,   502,     0,   503,   504,   697,   505,   506,   173,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,   174,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,   178,   179,   521,   180,   522,   523,
     524,   525,   526,  3622,   527,   528,     0,   529,  1503,   182,
     530,   183,     0,   531,   532,   533,  1504,  1505,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,   189,   190,   545,   546,   191,     0,   547,   548,
     193,   549,     0,  1510,   550,   195,   551,   552,   553,     0,
     554,     0,  1083,   555,   556,   557,     0,     0,   196,   197,
     198,   199,  1513,   558,   559,   560,   561,   562,   563,   564,
       0,   565,  1514,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,   211,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,   216,
     604,   605,   606,   607,   608,  1517,   609,   218,   610,   611,
     220,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,  1519,     0,   624,   625,   224,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,  1522,   634,  1523,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
    1526,     0,   647,   648,   649,   650,   651,  2190,   235,     0,
     652,   236,   653,   654,   655,     0,     0,   656,     0,   237,
     657,   658,   659,   660,   661,   238,  1528,  1529,  1530,  1531,
    1532,  1533,  1534,  1535,   702,   662,   663,     0,     0,     0,
     726,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,  3623,    98,    99,   100,   101,   102,   103,
     727,   104,   105,   681,   728,     0,   107,   108,   109,   110,
     729,   730,   112,   113,   114,   115,     0,   116,   731,   732,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
     133,   433,   434,   435,   135,   136,   137,   138,   139,     0,
     436,   437,   438,   439,   440,     0,  1480,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,  1483,     0,  1484,
       0,   448,   449,   450,   451,   148,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,   151,   459,     0,  1485,
    1486,  1487,  1488,  1489,  1490,  1491,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,  1496,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,   169,     0,   170,   498,   499,   500,     0,   501,
    1499,     0,   502,     0,   503,   504,   697,   505,   506,   173,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,   174,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,   178,   179,   521,   180,   522,   523,
     524,   525,   526,  3622,   527,   528,     0,   529,  1503,   182,
     530,   183,     0,   531,   532,   533,  1504,  1505,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,   189,   190,   545,   546,   191,     0,   547,   548,
     193,   549,     0,  1510,   550,   195,   551,   552,   553,     0,
     554,     0,  1083,   555,   556,   557,     0,     0,   196,   197,
     198,   199,  1513,   558,   559,   560,   561,   562,   563,   564,
       0,   565,  1514,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,   211,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,  1517,   609,   218,   610,   611,
     220,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,  1519,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,  1522,   634,  1523,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
    1526,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,   236,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,  1528,  1529,  1530,  1531,
    1532,  1533,  1534,  1535,   702,   662,   663,     0,     0,     0,
     726,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,  3623,    98,    99,   100,   101,   102,   103,
     727,   104,   105,   681,   728,     0,   107,   108,   109,   110,
     729,   730,   112,   113,   114,   115,     0,   116,   731,   732,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
     133,   433,   434,   435,   135,   136,   137,   138,   139,     0,
     436,   437,   438,   439,   440,     0,  1480,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,  1483,     0,  1484,
       0,   448,   449,   450,   451,   148,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,   151,   459,     0,  1485,
    1486,  1487,  1488,  1489,  1490,  1491,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,  1496,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,   169,     0,   170,   498,   499,   500,     0,   501,
    1499,     0,   502,     0,   503,   504,   697,   505,   506,   173,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,   174,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,   178,   179,   521,   180,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,  1503,   182,
     530,   183,     0,   531,   532,   533,  1504,  1505,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,   189,   190,   545,   546,   191,     0,   547,   548,
     193,   549,     0,  1510,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,   197,
     198,   199,  1513,   558,   559,   560,   561,   562,   563,   564,
       0,   565,  1514,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,   211,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,  1517,   609,   218,   610,   611,
     220,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,  1519,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,  1522,   634,  1523,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
    1526,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,   236,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,  1528,  1529,  1530,  1531,
    1532,  1533,  1534,  1535,   702,   662,   663,     0,     0,     0,
     726,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,   247,    98,    99,   100,   101,   102,   103,
     727,   104,   105,   681,   728,     0,   107,   108,   109,   110,
     729,   730,   112,   113,   114,   115,     0,   116,   731,   732,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
     133,   433,   434,   435,   135,   136,   137,   138,   139,     0,
     436,   437,   438,   439,   440,     0,  1480,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,  1483,     0,  1484,
       0,   448,   449,   450,   451,   148,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,   151,   459,     0,  1485,
    1486,  1487,  1488,  1489,  1490,  1491,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,  1496,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,   169,     0,   170,   498,   499,   500,     0,   501,
    1499,     0,   502,     0,   503,   504,   697,   505,   506,   173,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,   174,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,   178,   179,   521,   180,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,  1503,   182,
     530,   183,     0,   531,   532,   533,  1504,  1505,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,   189,   190,   545,   546,   191,     0,   547,   548,
     193,   549,     0,  1510,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,   197,
     198,   199,  1513,   558,   559,   560,   561,   562,   563,   564,
       0,   565,  1514,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,   211,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,  1517,   609,   218,   610,   611,
     220,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,  1519,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,  1522,   634,  1523,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
    1526,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,   236,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,  1528,  1529,  1530,  1531,
    1532,  1533,  1534,  1535,   702,   662,   663,     0,     0,     0,
     726,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,  4199,    98,    99,   100,   101,   102,   103,
     727,   104,   105,   681,   728,     0,   107,   108,   109,   110,
     729,   730,   112,   113,   114,   115,     0,   116,   731,   732,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
     133,   433,   434,   435,   135,   136,   137,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,   144,     0,   145,
       0,   448,   449,   450,   451,   148,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,   151,   459,     0,     0,
       0,     0,   152,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,   169,     0,   170,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,   506,   173,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,   174,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,   178,   179,   521,   180,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,   182,
     530,   183,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,   189,   190,   545,   546,   191,     0,   547,   548,
     193,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,   197,
     198,   199,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,   211,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
     220,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,   236,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,     0,     0,     0,
       0,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,  4778,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,  4126,     0,   429,   430,     0,   431,   432,
       0,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0, -1492,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,     0,     0, -1492,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,   506,     0,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516, -1492,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521, -1492,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181, -1492,
     530,     0,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188, -1492,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594, -1492,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,     0,     0,     0,
       0,     0,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,  1630,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,    37,    38,    39,    40,    41,    42,     0,    44,     0,
       0,     0,    45,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,   506,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,     0,     0,
       0,     0,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,  3895,  3896,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,    37,    38,    39,    40,    41,    42,     0,    44,     0,
       0,     0,    45,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,   506,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,     0,     0,
       0,     0,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,  3896,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,   417,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,   506,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
     216,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
     224,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,  2190,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
     237,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,     0,     0,
       0,     0,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,   247,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,   506,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
     216,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
     224,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,  2190,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
     237,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,     0,     0,
       0,     0,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,   247,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,   506,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,     0,     0,
       0,     0,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,  1605,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,   506,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,     0,     0,
       0,     0,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,  3060,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,   506,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,     0,     0,
       0,     0,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,  4155,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,   506,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,     0,     0,
       0,   726,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,  4509,    98,    99,   100,   101,   102,
     103,   727,   104,   105,   681,   728,     0,   107,   108,   109,
     110,   729,   730,   112,   113,   114,   115,     0,   116,   731,
     732,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,   417,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,     0,
       0,  1207,    45,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,   733,   426,   427,   428,   734,
     735,   736,   737,   738,   739,   740,   429,   430,   741,   431,
     432,   133,   433,   434,   435,     0,  1900,   137,  1901,  1902,
     742,   436,   437,   438,   439,   440,   743,   744,   441,   442,
    1903,  1904,   443,   746,   444,   445,   446,   447,     0,   747,
     145,   748,   448,   449,   450,   451,   148,   452,   693,   750,
     453,   454,   455,   456,   457,   458,   751,   151,   459,     0,
     753,   754,   755,   152,   756,   757,   758,   460,   461,   462,
     463,   695,   464,  1905,  1906,   465,   759,   466,   760,   467,
     468,   469,   470,   471,   761,   472,   473,   474,   762,   763,
     475,   476,  1494,   478,   479,   764,   480,   481,   482,   765,
     483,   484,   485,   766,   486,   487,   488,   489,     0,   490,
     491,   492,     0,   767,   493,   768,   494,  1907,   495,   769,
     496,   770,   497,   169,   771,   170,   498,   499,   500,   772,
     501,     0,   773,   502,   774,   503,   504,   697,   505,   506,
     173,   507,   508,   509,   775,   510,   511,   512,   513,   514,
     515,   776,   516,   174,     0,     0,   517,   518,   519,  1500,
    1908,   779,  1909,   780,   520,   178,   179,   521,   180,   522,
     523,   524,   525,   526,   781,   527,   528,   782,   529,     0,
     182,   530,   183,   783,   531,   532,   533,   784,   785,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,  1910,   189,  1911,   545,   546,     0,   786,   547,
     548,   193,   549,   787,     0,   550,  1912,   551,   552,   553,
     788,   554,   789,   790,  3882,   556,   557,   791,   792,     0,
     197,   198,   199,     0,   558,   559,   560,   561,   562,   563,
     564,   793,   565,     0,   566,     0,   567,   568,   569,   794,
     570,   571,   572,   573,   574,   575,   576,   577,  1913,   578,
     579,   580,   581,   795,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,   796,   593,   594,   211,   595,
     596,     0,   597,   598,   599,   600,   601,   602,   700,   603,
     797,   604,   605,   606,   607,   608,   798,   609,  2487,   610,
     611,   220,   612,  1915,   613,   799,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,     0,   800,   624,   625,
     801,   626,   627,   628,   629,   630,   631,   802,  1916,  1917,
       0,   804,   633,     0,   634,     0,   805,   635,   636,   637,
     638,   639,   640,   641,     0,   807,   642,   643,   644,   645,
     646,   808,   809,   647,   648,   649,   650,   651,     0,  1918,
     811,   652,   236,   653,   654,   655,   812,   813,   656,   814,
     815,   657,   658,   659,   660,   661,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   702,   662,   663,     0,     0,
       0,  1210,  1211,  1212,     0,  3883,  3884,  1215,  1216,  1217,
    1218,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
    1207,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
       0,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,  1208,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,  1209,     0,   494,   168,   495,     0,   496,
       0,   497,     0,     0,     0,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,   506,     0,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,     0,
     530,     0,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,     0,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,     0,     0,     0,
    1210,  1211,  1212,     0,  1213,  1214,  1215,  1216,  1217,  1218,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,  1207,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,     0,
     433,   434,   435,   135,   136,     0,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   692,   140,
     443,     0,   444,  1302,   446,   447,   144,     0,     0,     0,
     448,   449,   450,   451,     0,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   695,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,  1303,     0,   494,   168,   495,     0,   496,     0,
     497,     0,     0,     0,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,   697,   505,   506,     0,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,     0,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,     0,     0,   521,     0,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,     0,   530,
       0,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,     0,   190,   545,   546,   191,     0,   547,   548,     0,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,     0,     0,
       0,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,     0,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,     0,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,   701,   235,     0,   652,
       0,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,     0,     0,     0,  1210,
    1211,  1212,     0,  1213,  1214,  1215,  1216,  1217,  1218,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   681,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,  1207,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,     0,   433,
     434,   435,   135,   136,     0,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   692,   140,   443,
       0,   444,  1359,   446,   447,   144,     0,     0,     0,   448,
     449,   450,   451,     0,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,  1360,     0,   494,   168,   495,     0,   496,     0,   497,
       0,     0,     0,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,  1361,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
       0,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,     0,     0,   521,     0,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,     0,   530,     0,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
       0,   190,   545,   546,   191,     0,   547,   548,     0,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,     0,     0,     0,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,     0,   595,   596,   213,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,     0,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,   701,   235,     0,   652,     0,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,     0,     0,     0,  1210,  1211,
    1212,     0,  1213,  1214,  1215,  1216,  1217,  1218,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,  1207,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,     0,
     444,  1885,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
    1886,     0,   494,   168,   495,     0,   496,     0,   497,     0,
       0,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,   506,     0,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,     0,     0,     0,  1210,  1211,  1212,
       0,  1213,  1214,  1215,  1216,  1217,  1218,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,  1207,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,     0,     0,     0,  1210,  1211,  1212,     0,
    1213,  1214,  1215,  1216,  1217,  1218,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,  1207,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,  3149,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,  3150,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,     0,     0,     0,  1210,  1211,  1212,     0,  1213,
    1214,  1215,  1216,  1217,  1218,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,  1207,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,   506,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,  4761,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,     0,     0,     0,  1210,  1211,  1212,     0,  1213,  1214,
    1215,  1216,  1217,  1218,   726,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   727,   104,   105,   681,   728,     0,
     107,   108,   109,   110,   729,   730,   112,   113,   114,   115,
       0,   116,   731,   732,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,   733,   426,
     427,   428,   734,   735,   736,   737,   738,   739,   740,   429,
     430,   741,   431,   432,   133,   433,   434,   435,   135,   136,
     137,   138,   139,   742,   436,   437,   438,   439,   440,   743,
     744,   441,   442,   745,   140,   443,   746,   444,   445,   446,
     447,   144,   747,   145,   748,   448,   449,   450,   451,   148,
     452,   749,   750,   453,   454,   455,   456,   457,   458,   751,
     151,   459,   752,   753,   754,   755,   152,   756,   757,   758,
     460,   461,   462,   463,   695,   464,   155,   156,   465,   759,
     466,   760,   467,   468,   469,   470,   471,   761,   472,   473,
     474,   762,   763,   475,   476,   477,   478,   479,   764,   480,
     481,   482,   765,   483,   484,   485,   766,   486,   487,   488,
     489,   164,   490,   491,   492,   166,   767,   493,   768,   494,
     168,   495,   769,   496,   770,   497,   169,   771,   170,   498,
     499,   500,   772,   501,   172,   773,   502,   774,   503,   504,
     697,   505,   506,   173,   507,   508,   509,   775,   510,   511,
     512,   513,   514,   515,   776,   516,   174,   175,   777,   517,
     518,   519,   778,   176,   779,   177,   780,   520,   178,   179,
     521,   180,   522,   523,   524,   525,   526,   781,   527,   528,
     782,   529,   181,   182,   530,   183,   783,   531,   532,   533,
     784,   785,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,   189,   190,   545,   546,
     191,   786,   547,   548,   193,   549,   787,   194,   550,   195,
     551,   552,   553,   788,   554,   789,   790,   555,   556,   557,
     791,   792,   196,   197,   198,   199,   200,   558,   559,   560,
     561,   562,   563,   564,   793,   565,   201,   566,   202,   567,
     568,   569,   794,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,   795,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   796,   593,
     594,   211,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,   797,   604,   605,   606,   607,   608,   798,
     609,   218,   610,   611,   220,   612,   221,   613,   799,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
     800,   624,   625,   801,   626,   627,   628,   629,   630,   631,
     802,   225,   226,   803,   804,   633,   227,   634,   228,   805,
     635,   636,   637,   638,   639,   640,   641,   806,   807,   642,
     643,   644,   645,   646,   808,   809,   647,   648,   649,   650,
     651,   810,   235,   811,   652,   236,   653,   654,   655,   812,
     813,   656,   814,   815,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,   726,    86,    87,    88,   678,    90,    91,    92,   679,
    2287,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   727,   104,   105,   681,   728,     0,   107,   108,   109,
     110,   729,   730,   112,   113,   114,   115,     0,   116,   731,
     732,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,   133,   433,   434,   435,     0,  1900,   137,  1901,  1902,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
    1903,  1904,   443,     0,   444,   445,   446,   447,     0,     0,
     145,     0,   448,   449,   450,   451,   148,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,   151,   459,     0,
       0,     0,     0,   152,     0,     0,     0,   460,   461,   462,
     463,   695,   464,  1905,  1906,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,  1494,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,     0,   490,
     491,   492,     0,     0,   493,     0,   494,  1907,   495,     0,
     496,     0,   497,   169,     0,   170,   498,   499,   500,     0,
     501,     0,     0,   502,     0,   503,   504,   697,   505,   506,
     173,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,   174,     0,     0,   517,   518,   519,  1500,
    1908,     0,  1909,     0,   520,   178,   179,   521,   180,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,     0,
     182,   530,   183,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,  1910,   189,  1911,   545,   546,     0,     0,   547,
     548,   193,   549,     0,     0,   550,  1912,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,     0,
     197,   198,   199,     0,   558,   559,   560,   561,   562,   563,
     564,     0,   565,     0,   566,     0,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,  1913,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,   211,   595,
     596,     0,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,  1914,   610,
     611,   220,   612,  1915,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,     0,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,  1916,  1917,
       0,     0,   633,     0,   634,     0,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,     0,  1918,
       0,   652,   236,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   702,   662,   663,     0,    86,
      87,    88,   678,    90,    91,    92,   679,  2394,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   681,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,     0,   433,
     434,   435,   135,   136,     0,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   692,   140,   443,
       0,   444,   445,   446,   447,   144,     0,     0,     0,   448,
     449,   450,   451,     0,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
       0,     0,     0,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,   506,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
       0,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,     0,     0,   521,     0,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,     0,   530,     0,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
       0,   190,   545,   546,   191,     0,   547,   548,     0,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,     0,     0,     0,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,     0,   595,   596,   213,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,     0,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,   701,   235,     0,   652,     0,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,     0,    86,    87,    88,   678,
      90,    91,    92,   679,  1090,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,     0,    86,    87,    88,   678,    90,    91,    92,
     679,  4802,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,   417,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,    45,     0,     0,     0,     0,   418,   988,
     420,   421,   422,   423,   424,   425,   989,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   990,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   991,   168,   495,
       0,   496,     0,   992,     0,   993,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
     506,     0,   507,   508,   509,   994,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   995,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   996,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   997,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   998,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,     0,
       0,     0,     0,     0,     0,     0,   999,  1000,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,   417,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,    45,     0,
       0,     0,     0,   418,   988,   420,   421,   422,   423,   424,
     425,   989,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,  1021,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,     0,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   991,   168,   495,     0,   496,     0,  1022,     0,
     993,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,   506,     0,   507,   508,   509,
     994,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   995,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   996,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   997,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   998,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,     0,     0,     0,     0,     0,     0,
       0,   999,  1000,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,   417,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,    45,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,  1407,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,     0,   993,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
     506,     0,   507,   508,   509,   994,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,     0,
       0,     0,     0,     0,     0,     0,   999,  1000,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,   417,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,    45,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,  1412,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,     0,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,     0,
     993,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,   506,     0,   507,   508,   509,
     994,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,     0,     0,     0,     0,     0,     0,
       0,   999,  1000,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,   417,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,   696,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,     0,     0,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
     506,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,  1576,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,     0,
       0,  1061,  1577,    86,    87,    88,   678,    90,    91,    92,
     679,  1062,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,  1063,
     442,  1037,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,  1064,
       0,  1065,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,     0,     0,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
     506,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,  1066,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,  1067,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
    1068,   596,   213,   597,   598,   599,  1069,   601,   602,   700,
     603,     0,   604,   605,   606,   607,  1070,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,  1071,
     226,     0,     0,  1072,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,  1041,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,  1073,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,   726,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   727,
     104,   105,   681,   728,     0,   107,   108,   109,   110,   729,
     730,   112,   113,   114,   115,     0,   116,   731,   732,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,     0,     0,     0,
      45,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,   733,   426,   427,   428,   734,   735,   736,
     737,   738,   739,   740,   429,   430,   741,   431,   432,   133,
     433,   434,   435,   135,   136,   137,   138,   139,   742,   436,
     437,   438,   439,   440,   743,   744,   441,   442,   745,   140,
     443,   746,   444,   445,   446,   447,   144,   747,   145,   748,
     448,   449,   450,   451,   148,   452,   749,   750,   453,   454,
     455,   456,   457,   458,   751,   151,   459,   752,   753,   754,
     755,   152,   756,   757,   758,   460,   461,   462,   463,   695,
     464,   155,   156,   465,   759,   466,   760,   467,   468,   469,
     470,   471,   761,   472,   473,   474,   762,   763,   475,   476,
     477,   478,   479,   764,   480,   481,   482,   765,   483,   484,
     485,   766,   486,   487,   488,   489,   164,   490,   491,   492,
     166,   767,   493,   768,   494,   168,   495,   769,   496,   770,
     497,   169,   771,   170,   498,   499,   500,   772,   501,   172,
     773,   502,   774,   503,   504,   697,   505,   506,   173,   507,
     508,   509,   775,   510,   511,   512,   513,   514,   515,   776,
     516,   174,   175,   777,   517,   518,   519,   778,   176,   779,
     177,   780,   520,   178,   179,   521,   180,   522,   523,   524,
     525,   526,   781,   527,   528,   782,   529,   181,   182,   530,
     183,   783,   531,   532,   533,   784,   785,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,   189,   190,   545,   546,   191,   786,   547,   548,   193,
     549,   787,   194,   550,   195,   551,   552,   553,   788,   554,
     789,   790,   555,   556,   557,   791,   792,   196,   197,   198,
     199,   200,   558,   559,   560,   561,   562,   563,   564,   793,
     565,   201,   566,   202,   567,   568,   569,   794,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,   795,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,   796,   593,   594,   211,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,   797,   604,
     605,   606,   607,   608,   798,   609,   218,   610,   611,   220,
     612,   221,   613,   799,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,   800,   624,   625,   801,   626,
     627,   628,   629,   630,   631,   802,   225,   226,   803,   804,
     633,   227,   634,   228,   805,   635,   636,   637,   638,   639,
     640,   641,   806,   807,   642,   643,   644,   645,   646,   808,
     809,   647,   648,   649,   650,   651,   810,   235,   811,   652,
     236,   653,   654,   655,   812,   813,   656,   814,   815,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,   726,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   727,   104,   105,   681,
     728,     0,   107,   108,   109,   110,   729,   730,   112,   113,
     114,   115,     0,   116,   731,   732,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
     733,   426,   427,   428,   734,   735,   736,   737,   738,   739,
     740,   429,   430,   741,   431,   432,   133,   433,   434,   435,
     135,   136,   137,   138,   139,   742,   436,   437,   438,   439,
     440,   743,   744,   441,   442,   745,   140,   443,   746,   444,
     445,   446,   447,   144,   747,   145,   748,   448,   449,   450,
     451,   148,   452,   749,   750,   453,   454,   455,   456,   457,
     458,   751,   151,   459,   752,   753,   754,   755,   152,   756,
     757,   758,   460,   461,   462,   463,   695,   464,   155,   156,
     465,   759,   466,   760,   467,   468,   469,   470,   471,   761,
     472,   473,   474,   762,   763,   475,   476,   477,   478,   479,
     764,   480,   481,   482,   765,   483,   484,   485,   766,   486,
     487,   488,   489,   164,   490,   491,   492,   166,   767,   493,
     768,   494,   168,   495,   769,   496,   770,   497,   169,   771,
     170,   498,   499,   500,   772,   501,   172,   773,   502,   774,
     503,   504,   697,   505,   506,   173,   507,   508,   509,   775,
     510,   511,   512,   513,   514,   515,   776,   516,   174,   175,
     777,   517,   518,   519,   778,   176,   779,   177,   780,   520,
     178,   179,   521,   180,   522,   523,   524,   525,   526,   781,
     527,   528,   782,   529,   181,   182,   530,   183,   783,   531,
     532,   533,   784,   785,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,   189,   190,
     545,   546,   191,   786,   547,   548,   193,   549,   787,   194,
     550,   195,   551,   552,   553,   788,   554,   789,   790,   555,
     556,   557,   791,   792,   196,   197,   198,   199,   200,   558,
     559,   560,   561,   562,   563,   564,   793,   565,   201,   566,
     202,   567,   568,   569,   794,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,   795,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
     796,   593,   594,   211,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,   797,   604,   605,   606,   607,
     608,   798,   609,   218,   610,   611,   220,   612,   221,   613,
     799,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,   800,   624,   625,   801,   626,   627,   628,   629,
     630,   631,   802,   225,   226,   803,   804,   633,   227,   634,
     228,   805,   635,   636,   637,   638,   639,   640,   641,   806,
     807,   642,   643,   644,   645,   646,   808,   809,   647,   648,
     649,   650,   651,   810,   235,   811,   652,   236,   653,   654,
     655,   812,   813,   656,   814,   815,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,   726,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   727,   104,   105,   681,   728,     0,   107,
     108,   109,   110,   729,   730,   112,   113,   114,   115,     0,
     116,   731,   732,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,  3214,   423,   424,   425,   733,   426,   427,
     428,   734,   735,   736,   737,   738,   739,   740,   429,   430,
     741,   431,   432,   133,   433,   434,   435,   135,   136,   137,
     138,   139,   742,   436,   437,   438,   439,   440,   743,   744,
     441,   442,   745,   140,   443,   746,   444,   445,   446,   447,
     144,   747,   145,   748,   448,   449,   450,   451,   148,   452,
     749,   750,   453,   454,   455,   456,   457,   458,   751,   151,
     459,   752,   753,   754,   755,   152,   756,   757,   758,   460,
     461,   462,   463,   695,   464,   155,   156,   465,   759,   466,
     760,   467,   468,   469,   470,   471,   761,   472,   473,   474,
     762,   763,   475,   476,   477,  3215,   479,   764,   480,   481,
     482,   765,   483,   484,   485,   766,   486,   487,   488,   489,
     164,   490,   491,   492,   166,   767,   493,   768,   494,   168,
     495,   769,   496,   770,   497,   169,   771,   170,   498,   499,
     500,   772,   501,   172,   773,   502,   774,   503,   504,   697,
     505,   506,   173,   507,   508,   509,   775,   510,   511,   512,
     513,   514,   515,   776,   516,   174,   175,   777,   517,   518,
     519,   778,   176,   779,   177,   780,   520,   178,   179,   521,
     180,   522,   523,   524,   525,   526,   781,   527,   528,   782,
     529,   181,   182,   530,   183,   783,   531,   532,   533,   784,
     785,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,   189,   190,   545,   546,   191,
     786,   547,   548,   193,   549,   787,   194,   550,   195,   551,
     552,   553,   788,   554,   789,   790,   555,   556,   557,   791,
     792,   196,   197,   198,   199,   200,   558,   559,   560,   561,
     562,   563,   564,   793,   565,   201,   566,   202,   567,   568,
     569,   794,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,   795,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,   796,   593,   594,
     211,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,   797,   604,   605,   606,   607,   608,   798,  3216,
     218,   610,   611,   220,   612,   221,   613,   799,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,   800,
     624,   625,   801,   626,   627,   628,   629,   630,   631,   802,
     225,   226,   803,   804,   633,   227,   634,   228,   805,   635,
     636,   637,   638,   639,   640,   641,   806,   807,   642,   643,
     644,   645,   646,   808,   809,   647,   648,   649,   650,   651,
     810,   235,   811,   652,   236,   653,   654,   655,   812,   813,
     656,   814,   815,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
     726,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     727,   104,   105,   681,   728,     0,   107,   108,   109,   110,
     729,   730,   112,   113,   114,   115,     0,   116,   731,   732,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
     133,   433,   434,   435,   135,   136,   137,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,   144,     0,   145,
       0,   448,   449,   450,   451,   148,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,   151,   459,     0,     0,
       0,     0,   152,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,   169,     0,   170,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,   506,   173,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,   174,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,   178,   179,   521,   180,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,   182,
     530,   183,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,   189,   190,   545,   546,   191,     0,   547,   548,
     193,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,   197,
     198,   199,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,   211,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
     220,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,   236,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,   726,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   727,   104,   105,
     681,   728,     0,   107,   108,   109,   110,   729,   730,   112,
     113,   114,   115,     0,   116,   731,   732,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,   133,   433,   434,
     435,   135,   136,   137,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,     0,
     444,   445,   446,   447,   144,     0,   145,     0,   448,   449,
     450,   451,   148,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,   151,   459,     0,     0,     0,     0,   152,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,   169,
       0,   170,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,  1342,   173,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,   174,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,   178,   179,   521,   180,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,   182,   530,   183,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,   189,
     190,   545,   546,   191,     0,   547,   548,   193,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,   197,   198,   199,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,   211,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,   220,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,   236,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,   726,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   727,   104,   105,   681,   728,     0,
     107,   108,   109,   110,   729,   730,   112,   113,   114,   115,
       0,   116,   731,   732,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,   133,   433,   434,   435,   135,   136,
     137,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,   145,     0,   448,   449,   450,   451,   148,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
     151,   459,     0,     0,     0,     0,   152,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,   169,     0,   170,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,  1352,   173,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,   174,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,   178,   179,
     521,   180,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,   182,   530,   183,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,   189,   190,   545,   546,
     191,     0,   547,   548,   193,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,   197,   198,   199,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,   211,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,   220,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,   236,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,   726,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   727,   104,   105,   681,   728,     0,   107,   108,   109,
     110,   729,   730,   112,   113,   114,   115,     0,   116,   731,
     732,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,   133,   433,   434,   435,     0,  1900,   137,  1901,  1902,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
    1903,  1904,   443,     0,   444,   445,   446,   447,     0,     0,
     145,     0,   448,   449,   450,   451,   148,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,   151,   459,     0,
       0,     0,     0,   152,     0,     0,     0,   460,   461,   462,
     463,   695,   464,  1905,  1906,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,  1494,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,     0,   490,
     491,   492,     0,     0,   493,     0,   494,  1907,   495,     0,
     496,     0,   497,   169,     0,   170,   498,   499,   500,     0,
     501,     0,     0,   502,     0,   503,   504,   697,   505,   506,
     173,   507,   508,   509,  2484,   510,   511,   512,   513,   514,
     515,     0,   516,   174,  2485,     0,   517,   518,   519,  1500,
    1908,     0,  1909,     0,   520,   178,   179,   521,   180,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,     0,
     182,   530,   183,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,  1910,   189,  1911,   545,   546,     0,     0,   547,
     548,   193,   549,     0,     0,   550,  1912,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,  2486,
     197,   198,   199,     0,   558,   559,   560,   561,   562,   563,
     564,     0,   565,     0,   566,     0,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,  1913,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,   211,   595,
     596,     0,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,  2487,   610,
     611,   220,   612,  1915,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,     0,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,  1916,  1917,
       0,     0,   633,     0,   634,     0,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,     0,  1918,
    2488,   652,   236,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   702,   662,   663,   726,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   727,   104,
     105,   681,   728,     0,   107,   108,   109,   110,   729,   730,
     112,   113,   114,   115,     0,   116,   731,   732,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,   133,   433,
     434,   435,     0,  1900,   137,  1901,  1902,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,  1903,  1904,   443,
       0,   444,   445,   446,   447,     0,     0,   145,     0,   448,
     449,   450,   451,   148,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,   151,   459,     0,     0,     0,     0,
     152,     0,     0,     0,   460,   461,   462,   463,   695,   464,
    1905,  1906,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,  1494,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,     0,   490,   491,   492,     0,
       0,   493,     0,   494,  1907,   495,     0,   496,     0,   497,
     169,     0,   170,   498,   499,   500,     0,   501,     0,     0,
     502,     0,   503,   504,   697,   505,   506,   173,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
     174,     0,     0,   517,   518,   519,  1500,  1908,     0,  1909,
       0,   520,   178,   179,   521,   180,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,     0,   182,   530,   183,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,  1910,
     189,  1911,   545,   546,     0,     0,   547,   548,   193,   549,
    2472,     0,   550,  1912,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,     0,   197,   198,   199,
       0,   558,   559,   560,   561,   562,   563,   564,     0,   565,
       0,   566,     0,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,  1913,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,   211,   595,   596,     0,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,  2487,   610,   611,   220,   612,
    1915,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,     0,     0,   624,   625,  3986,   626,   627,
     628,   629,   630,   631,     0,  1916,  1917,     0,     0,   633,
       0,   634,     0,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,     0,  1918,     0,   652,   236,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   702,   662,   663,   726,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   727,   104,   105,   681,   728,
       0,   107,   108,   109,   110,   729,   730,   112,   113,   114,
     115,     0,   116,   731,   732,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,   133,   433,   434,   435,     0,
    1900,   137,  1901,  1902,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,  1903,  1904,   443,     0,   444,   445,
     446,   447,     0,     0,   145,     0,   448,   449,   450,   451,
     148,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,   151,   459,     0,     0,     0,     0,   152,     0,     0,
       0,   460,   461,   462,   463,   695,   464,  1905,  1906,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,  1494,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,     0,   490,   491,   492,     0,     0,   493,     0,
     494,  1907,   495,     0,   496,     0,   497,   169,     0,   170,
     498,   499,   500,     0,   501,     0,     0,   502,     0,   503,
     504,   697,   505,   506,   173,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,   174,     0,     0,
     517,   518,   519,  1500,  1908,     0,  1909,     0,   520,   178,
     179,   521,   180,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,     0,   182,   530,   183,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,  1910,   189,  1911,   545,
     546,  2538,     0,   547,   548,   193,   549,     0,     0,   550,
    1912,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,     0,   197,   198,   199,     0,   558,   559,
     560,   561,   562,   563,   564,     0,   565,     0,   566,     0,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,  1913,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,   211,   595,   596,     0,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,  1914,   610,   611,   220,   612,  1915,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
       0,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,  1916,  1917,     0,     0,   633,     0,   634,     0,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,     0,  1918,     0,   652,   236,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   702,
     662,   663,   726,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   727,   104,   105,   681,   728,     0,   107,   108,
     109,   110,   729,   730,   112,   113,   114,   115,     0,   116,
     731,   732,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,   133,   433,   434,   435,     0,  1900,   137,  1901,
    1902,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,  1903,  1904,   443,     0,   444,   445,   446,   447,     0,
       0,   145,     0,   448,   449,   450,   451,   148,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,   151,   459,
       0,     0,     0,     0,   152,     0,     0,     0,   460,   461,
     462,   463,   695,   464,  1905,  1906,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,  1494,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,     0,
     490,   491,   492,     0,     0,   493,     0,   494,  1907,   495,
       0,   496,     0,   497,   169,     0,   170,   498,   499,   500,
       0,   501,     0,     0,   502,     0,   503,   504,   697,   505,
     506,   173,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,   174,     0,     0,   517,   518,   519,
    1500,  1908,     0,  1909,     0,   520,   178,   179,   521,   180,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
       0,   182,   530,   183,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,  1910,   189,  1911,   545,   546,  3818,     0,
     547,   548,   193,   549,     0,     0,   550,  1912,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
       0,   197,   198,   199,     0,   558,   559,   560,   561,   562,
     563,   564,     0,   565,     0,   566,     0,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,  1913,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,   211,
     595,   596,     0,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,  1914,
     610,   611,   220,   612,  1915,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,     0,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,  1916,
    1917,     0,     0,   633,     0,   634,     0,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,     0,
    1918,     0,   652,   236,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   702,   662,   663,   726,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   727,
     104,   105,   681,   728,     0,   107,   108,   109,   110,   729,
     730,   112,   113,   114,   115,     0,   116,   731,   732,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,   133,
     433,   434,   435,     0,  1900,   137,  1901,  1902,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,  1903,  1904,
     443,     0,   444,   445,   446,   447,     0,     0,   145,     0,
     448,   449,   450,   451,   148,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,   151,   459,     0,     0,     0,
       0,   152,     0,     0,     0,   460,   461,   462,   463,   695,
     464,  1905,  1906,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
    1494,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,     0,   490,   491,   492,
       0,     0,   493,     0,   494,  1907,   495,     0,   496,     0,
     497,   169,     0,   170,   498,   499,   500,     0,   501,     0,
       0,   502,     0,   503,   504,   697,   505,   506,   173,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,   174,     0,     0,   517,   518,   519,  1500,  1908,     0,
    1909,     0,   520,   178,   179,   521,   180,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,     0,   182,   530,
     183,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
    1910,   189,  1911,   545,   546,     0,     0,   547,   548,   193,
     549,     0,     0,   550,  1912,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,     0,   197,   198,
     199,     0,   558,   559,   560,   561,   562,   563,   564,     0,
     565,     0,   566,     0,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,  1913,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,   211,   595,   596,     0,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,   609,  1914,   610,   611,   220,
     612,  1915,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,     0,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,  1916,  1917,     0,     0,
     633,     0,   634,     0,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,     0,  1918,     0,   652,
     236,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   702,   662,   663,   726,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   727,   104,   105,   681,
     728,     0,   107,   108,   109,   110,   729,   730,   112,   113,
     114,   115,     0,   116,   731,   732,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,   133,   433,   434,   435,
       0,  1900,   137,  1901,  1902,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,  1903,  1904,   443,     0,   444,
     445,   446,   447,     0,     0,   145,     0,   448,   449,   450,
     451,   148,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,   151,   459,     0,     0,     0,     0,   152,     0,
       0,     0,   460,   461,   462,   463,   695,   464,  1905,  1906,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,  1494,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,     0,   490,   491,   492,     0,     0,   493,
       0,   494,  1907,   495,     0,   496,     0,   497,   169,     0,
     170,   498,   499,   500,     0,   501,     0,     0,   502,     0,
     503,   504,   697,   505,   506,   173,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,   174,     0,
       0,   517,   518,   519,  1500,  1908,     0,  1909,     0,   520,
     178,   179,   521,   180,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,     0,   182,   530,   183,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,  1910,   189,  1911,
     545,   546,     0,     0,   547,   548,   193,   549,     0,     0,
     550,  1912,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,     0,   197,   198,   199,     0,   558,
     559,   560,   561,   562,   563,   564,     0,   565,     0,   566,
       0,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,  1913,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,   211,   595,   596,     0,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,  2487,   610,   611,   220,   612,  1915,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,     0,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,  1916,  1917,     0,     0,   633,     0,   634,
       0,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,     0,  1918,     0,   652,   236,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     702,   662,   663,   726,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   727,   104,   105,   681,   728,     0,   107,
     108,   109,   110,   729,   730,   112,   113,   114,   115,     0,
     116,   731,   732,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,   133,   433,   434,   435,     0,  1900,   137,
    1901,  1902,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,  1903,  1904,   443,     0,   444,   445,   446,   447,
       0,     0,   145,     0,   448,   449,   450,   451,   148,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,   151,
     459,     0,     0,     0,     0,   152,     0,     0,     0,   460,
     461,   462,   463,   695,   464,  1905,  1906,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,  1494,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
       0,   490,   491,   492,     0,     0,   493,     0,   494,  1907,
     495,     0,   496,     0,   497,   169,     0,   170,   498,   499,
     500,     0,   501,     0,     0,   502,     0,   503,   504,   697,
     505,   506,   173,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,   174,     0,     0,   517,   518,
     519,  1500,  1908,     0,  1909,     0,   520,   178,   179,   521,
     180,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,     0,   182,   530,   183,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,  1910,   189,  1911,   545,   546,     0,
       0,   547,   548,   193,   549,     0,     0,   550,  1912,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,     0,   197,   198,   199,     0,   558,   559,   560,   561,
     562,   563,   564,     0,   565,     0,   566,     0,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
    1913,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
     211,   595,   596,     0,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
       0,   610,   611,   220,   612,  1915,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,     0,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
    1916,  1917,     0,     0,   633,     0,   634,     0,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
       0,  1918,     0,   652,   236,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   702,   662,   663,
     726,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     727,   104,   105,   681,   728,     0,   107,   108,   109,   110,
     729,   730,   112,   113,   114,   115,     0,   116,   731,   732,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
     133,   433,   434,   435,     0,     0,   137,     0,     0,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,     0,
       0,   443,     0,   444,   445,   446,   447,     0,     0,   145,
       0,   448,   449,   450,   451,   148,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,   151,   459,     0,     0,
       0,     0,   152,     0,     0,     0,   460,   461,   462,   463,
     695,   464,     0,     0,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,     0,   490,   491,
     492,     0,     0,   493,     0,   494,     0,   495,     0,   496,
       0,   497,   169,     0,   170,   498,   499,   500,     0,   501,
       0,     0,   502,     0,   503,   504,   697,   505,   506,   173,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,   174,     0,     0,   517,   518,   519,     0,     0,
       0,     0,     0,   520,   178,   179,   521,   180,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,     0,   182,
     530,   183,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,     0,   189,     0,   545,   546,     0,     0,   547,   548,
     193,   549,     0,     0,   550,     0,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,     0,   197,
     198,   199,     0,   558,   559,   560,   561,   562,   563,   564,
       0,   565,     0,   566,     0,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,     0,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,   211,   595,   596,
       0,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,     0,   610,   611,
     220,   612,     0,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,     0,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,     0,     0,     0,
       0,   633,     0,   634,     0,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,     0,     0,     0,
     652,   236,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   702,   662,   663,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
     733,   426,   427,   428,   734,   735,   736,   737,   738,   739,
     740,   429,   430,   741,   431,   432,   133,   433,   434,   435,
     135,   136,   137,   138,   139,   742,   436,   437,   438,   439,
     440,   743,   744,   441,   442,     0,   140,   443,   746,   444,
     445,   446,   447,   144,   747,   145,   748,   448,   449,   450,
     451,   148,   452,   749,   750,   453,   454,   455,   456,   457,
     458,   751,   151,   459,     0,   753,   754,   755,   152,   756,
     757,   758,   460,   461,   462,   463,     0,   464,   155,   156,
     465,   759,   466,   760,   467,   468,   469,   470,   471,   761,
     472,   473,   474,   762,   763,   475,   476,   477,   478,   479,
     764,   480,   481,   482,   765,   483,   484,   485,   766,   486,
     487,   488,   489,   164,   490,   491,   492,   166,   767,   493,
     768,   494,   168,   495,   769,   496,   770,   497,   169,   771,
     170,   498,   499,   500,   772,   501,   172,   773,   502,   774,
     503,   504,     0,   505,   506,   173,   507,   508,   509,   775,
     510,   511,   512,   513,   514,   515,   776,   516,   174,   175,
       0,   517,   518,   519,     0,   176,   779,   177,   780,   520,
     178,   179,   521,   180,   522,   523,   524,   525,   526,   781,
     527,   528,   782,   529,   181,   182,   530,   183,   783,   531,
     532,   533,   784,   785,   534,   535,   536,   537,   538,   539,
       0,   540,   541,     0,   542,   543,   544,   188,   189,   190,
     545,   546,   191,   786,   547,   548,   193,   549,   787,   194,
     550,   195,   551,   552,   553,   788,   554,   789,   790,   555,
     556,   557,   791,   792,   196,   197,   198,   199,   200,   558,
     559,   560,   561,   562,   563,   564,   793,   565,   201,   566,
     202,   567,   568,   569,   794,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,   795,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
     796,   593,   594,   211,   595,   596,   213,   597,   598,   599,
     600,   601,   602,     0,   603,   797,   604,   605,   606,   607,
     608,   798,   609,   218,   610,   611,   220,   612,   221,   613,
     799,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,   800,   624,   625,   801,   626,   627,   628,   629,
     630,   631,   802,   225,   226,     0,   804,   633,   227,   634,
     228,   805,   635,   636,   637,   638,   639,   640,   641,     0,
     807,   642,   643,   644,   645,   646,   808,   809,   647,   648,
     649,   650,   651,     0,   235,   811,   652,   236,   653,   654,
     655,   812,   813,   656,   814,   815,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
       0,   662,   663,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,   417,
       0,     0,    37,    38,    39,    40,    41,    42,     0,    44,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,  1152,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,     0,     0,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
     506,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   681,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,   417,     0,     0,    37,    38,
      39,    40,    41,    42,     0,    44,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,     0,   433,
     434,   435,   135,   136,     0,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   692,   140,   443,
       0,   444,   445,   446,   447,   144,     0,     0,     0,   448,
     449,   450,   451,     0,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
       0,     0,     0,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,   506,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
       0,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,     0,     0,   521,     0,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,     0,   530,     0,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
       0,   190,   545,   546,   191,     0,   547,   548,     0,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,     0,     0,     0,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,     0,   595,   596,   213,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,     0,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,   701,   235,     0,   652,     0,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,  2418,   444,   445,   446,
     447,   144,     0,     0,  2500,   448,   449,   450,   451,     0,
     452,   693,  2419,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,  2501,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,  2421,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,   506,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,  2422,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,  2423,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
       0,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,  2418,   444,   445,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,   693,  2419,   453,
     454,   455,   456,   457,   458,     0,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,  2501,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
    2421,   497,     0,     0,     0,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,   506,     0,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,     0,
     530,  3377,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,     0,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,  2422,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,  2423,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,  1050,   424,   425,
    1008,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,  1009,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,  1051,   501,   172,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,  1010,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,  1011,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,  1008,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,  1009,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,     0,     0,     0,   498,   499,   500,
    3111,   501,   172,     0,   502,     0,   503,   504,   697,   505,
     506,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,  1010,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,  1011,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   681,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,    37,    38,
      39,    40,    41,    42,     0,    44,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,     0,   433,
     434,   435,   135,   136,     0,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   692,   140,   443,
       0,   444,   445,   446,   447,   144,     0,     0,     0,   448,
     449,   450,   451,     0,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
       0,     0,     0,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,   506,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
       0,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,     0,     0,   521,     0,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,     0,   530,     0,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
       0,   190,   545,   546,   191,     0,   547,   548,     0,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,     0,     0,     0,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,     0,   595,   596,   213,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,     0,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,   701,   235,     0,   652,     0,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,  2418,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,  2419,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,  2501,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,  2421,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,   506,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,  2422,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,  2423,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,   417,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,   691,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
       0,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,     0,   459,   694,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,   696,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,     0,     0,     0,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,   506,     0,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,     0,
     530,     0,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,     0,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
    1008,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,  1009,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,  1010,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,  1011,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,    86,    87,    88,   678,    90,    91,    92,
     679,   920,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,   417,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,   921,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,     0,     0,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
     506,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   922,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   681,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,  2091,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,     0,   433,
     434,   435,   135,   136,     0,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   692,   140,   443,
       0,   444,   445,   446,   447,   144,     0,     0,     0,   448,
     449,   450,   451,     0,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,  2092,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,  2093,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,  2094,   497,
       0,     0,     0,  2095,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,   506,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
       0,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,     0,     0,   521,     0,   522,   523,  2096,  2097,
     526,     0,   527,   528,     0,   529,   181,     0,   530,     0,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
       0,   190,   545,   546,   191,     0,   547,   548,     0,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,     0,     0,     0,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,     0,   595,   596,   213,   597,
     598,   599,  2098,   601,   602,   700,   603,     0,  2099,   605,
     606,   607,   608,     0,   609,   218,   610,   611,     0,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,  2100,   626,  2101,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,  2102,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,   701,   235,     0,   652,     0,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,  1009,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,   506,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,  1010,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,  1011,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,    86,    87,    88,   678,    90,    91,    92,   679,  2080,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,  2376,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,   417,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
       0,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,     0,     0,     0,   498,   499,  2978,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,   506,     0,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,     0,
     530,     0,     0,   531,   532,  2979,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,     0,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,  2980,
     626,   627,  2981,   629,  2982,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,  2983,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,   417,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
     718,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,   417,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,   696,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,     0,     0,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
     506,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   681,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,   417,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,   870,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,     0,   433,
     434,   435,   135,   136,     0,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   692,   140,   443,
       0,   444,   445,   446,   447,   144,     0,     0,     0,   448,
     449,   450,   451,     0,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
       0,     0,     0,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,   506,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
       0,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,     0,     0,   521,     0,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,     0,   530,     0,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
       0,   190,   545,   546,   191,     0,   547,   548,     0,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,     0,     0,     0,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,     0,   595,   596,   213,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,     0,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,   701,   235,     0,   652,     0,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,   417,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,  1334,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,   506,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,   130,   131,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
       0,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,     0,     0,     0,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,   506,     0,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,     0,
     530,     0,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,     0,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
    3198,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,  3199,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,  3210,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,     0,     0,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
     506,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,  3211,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   681,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,   417,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,     0,   433,
     434,   435,   135,   136,     0,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   692,   140,   443,
       0,   444,   445,   446,   447,   144,     0,     0,     0,   448,
     449,   450,   451,     0,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
       0,     0,     0,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,   506,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
       0,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,     0,     0,   521,     0,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,     0,   530,     0,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
       0,   190,   545,   546,   191,     0,   547,   548,     0,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,     0,     0,     0,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,     0,   595,   596,   213,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,     0,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,   701,   235,     0,   652,     0,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,   417,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,   506,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   926,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,   417,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
       0,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,     0,     0,     0,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,   506,     0,
     970,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,     0,
     530,     0,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,     0,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,   417,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,  1025,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,     0,     0,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
     506,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,  1083,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   681,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,     0,   433,
     434,   435,   135,   136,     0,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   692,   140,   443,
       0,   444,   445,   446,   447,   144,     0,     0,     0,   448,
     449,   450,   451,     0,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
       0,     0,     0,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,  1230,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
       0,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,     0,     0,   521,     0,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,     0,   530,     0,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
       0,   190,   545,   546,   191,     0,   547,   548,     0,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
    1083,   555,   556,   557,     0,     0,   196,     0,     0,     0,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,     0,   595,   596,   213,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,     0,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,   701,   235,     0,   652,     0,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,  1579,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,   506,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
       0,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,     0,     0,     0,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,  1754,     0,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,     0,
     530,     0,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,     0,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,  1083,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,  1988,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,    86,    87,    88,   678,    90,    91,    92,
     679,  2080,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,  2376,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,     0,     0,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
     506,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   681,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,  4126,     0,   429,   430,     0,   431,   432,     0,   433,
     434,   435,   135,   136,     0,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   692,   140,   443,
       0,   444,   445,   446,   447,   144,     0,     0,     0,   448,
     449,   450,   451,     0,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
       0,     0,     0,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,   506,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
       0,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,     0,     0,   521,     0,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,     0,   530,     0,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
       0,   190,   545,   546,   191,     0,   547,   548,     0,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,     0,     0,     0,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,     0,   595,   596,   213,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,     0,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,   701,   235,     0,   652,     0,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,  4140,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,   506,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
       0,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,  4359,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,     0,     0,     0,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,   506,     0,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,     0,
     530,     0,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,     0,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,  4361,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,  4363,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,     0,     0,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
     506,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   681,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,     0,   433,
     434,   435,   135,   136,     0,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   692,   140,   443,
       0,   444,   445,   446,   447,   144,     0,     0,     0,   448,
     449,   450,   451,     0,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
       0,     0,     0,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,   506,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
       0,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,     0,     0,   521,     0,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,     0,   530,     0,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
       0,   190,   545,   546,   191,     0,   547,   548,     0,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,     0,     0,     0,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,     0,   595,   596,   213,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,     0,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,  4764,
     647,   648,   649,   650,   651,   701,   235,     0,   652,     0,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,   506,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
       0,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,     0,     0,     0,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,   506,     0,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,     0,
     530,     0,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,     0,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,   595,   596,
     213,   597,   598,  1034,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
    1036,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,  1037,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,     0,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
    1038,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,  1039,   226,     0,     0,  1040,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,  1041,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,  1077,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,  1037,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,     0,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,     0,     0,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
     506,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,  1078,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,  1079,
     226,     0,     0,  1080,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,  1041,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   681,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,     0,   433,
     434,   435,   135,   136,     0,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   692,   140,   443,
       0,   444,   445,   446,   447,   144,     0,     0,     0,   448,
     449,   450,   451,     0,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
       0,     0,     0,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,   506,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
       0,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,     0,     0,   521,     0,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,     0,   530,     0,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
       0,   190,   545,   546,   191,     0,   547,   548,     0,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,     0,     0,     0,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,  1097,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,     0,   595,   596,   213,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,     0,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,   701,   235,     0,   652,     0,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,  1203,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
       0,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,     0,     0,     0,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,  1227,     0,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,     0,
     530,     0,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,     0,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,  1239,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,     0,     0,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
    1293,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   681,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,     0,   433,
     434,   435,   135,   136,     0,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   692,   140,   443,
       0,   444,   445,   446,   447,   144,     0,     0,     0,   448,
     449,   450,   451,     0,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
       0,     0,     0,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,  1307,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
       0,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,     0,     0,   521,     0,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,     0,   530,     0,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
       0,   190,   545,   546,   191,     0,   547,   548,     0,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,     0,     0,     0,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,     0,   595,   596,   213,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,     0,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,   701,   235,     0,   652,     0,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,  1347,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
       0,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,     0,     0,     0,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,  1366,     0,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,     0,
     530,     0,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,     0,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,  1368,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,     0,     0,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
    1370,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   681,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,     0,   433,
     434,   435,   135,   136,     0,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   692,   140,   443,
       0,   444,   445,   446,   447,   144,     0,     0,     0,   448,
     449,   450,   451,     0,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
       0,     0,     0,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,  1373,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
       0,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,     0,     0,   521,     0,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,     0,   530,     0,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
       0,   190,   545,   546,   191,     0,   547,   548,     0,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,     0,     0,     0,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,     0,   595,   596,   213,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,     0,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,   701,   235,     0,   652,     0,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,  1379,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
    1590,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,  1063,   442,  1037,
     140,  1591,     0,   444,   445,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,     0,     0,   453,
     454,   455,   456,   457,   458,     0,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,     0,     0,     0,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,   506,     0,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,     0,
     530,     0,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
    1067,   188,     0,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,  1068,   596,
     213,   597,   598,   599,  1069,   601,   602,   700,   603,     0,
     604,   605,   606,   607,  1583,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,  1071,   226,     0,
       0,  1072,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,  1041,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,  1073,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,  1717,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,     0,     0,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
    1800,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   681,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,     0,   433,
     434,   435,   135,   136,     0,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   692,   140,   443,
       0,   444,   445,   446,   447,   144,     0,     0,     0,   448,
     449,   450,   451,     0,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
       0,     0,     0,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,  1947,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
       0,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,     0,     0,   521,     0,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,     0,   530,     0,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
       0,   190,   545,   546,   191,     0,   547,   548,     0,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,     0,     0,     0,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,     0,   595,   596,   213,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,     0,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,   701,   235,     0,   652,     0,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,  1977,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
       0,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,     0,     0,     0,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,  2012,     0,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,     0,
     530,     0,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,     0,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,  2014,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,     0,     0,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
    2016,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   681,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,     0,   433,
     434,   435,   135,   136,     0,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   692,   140,   443,
       0,   444,   445,   446,   447,   144,     0,     0,     0,   448,
     449,   450,   451,     0,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
       0,     0,     0,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,   506,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
       0,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,     0,     0,   521,     0,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,     0,   530,     0,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
       0,   190,   545,   546,   191,     0,   547,   548,     0,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,     0,     0,     0,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,     0,   595,   596,   213,   597,
     598,  2129,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,     0,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,   701,   235,     0,   652,     0,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,  2342,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,   506,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
       0,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
       0,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,     0,     0,     0,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,  2737,     0,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,     0,
     530,     0,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,     0,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,  3122,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,     0,     0,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
    3201,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   681,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,     0,   433,
     434,   435,   135,   136,     0,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   692,   140,   443,
       0,   444,   445,   446,   447,   144,     0,     0,     0,   448,
     449,   450,   451,     0,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
       0,     0,     0,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,  3203,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
       0,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,     0,     0,   521,     0,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,     0,   530,     0,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
       0,   190,   545,   546,   191,     0,   547,   548,     0,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,     0,     0,     0,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,     0,   595,   596,   213,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,     0,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,   701,   235,     0,   652,     0,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,  3301,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
       0,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,  1063,   442,  1037,
     140,   443,     0,   444,   445,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,     0,     0,   453,
     454,   455,   456,   457,   458,     0,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,     0,     0,     0,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,   506,     0,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,     0,
     530,     0,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
    1067,   188,     0,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,  1068,   596,
     213,   597,   598,   599,  1069,   601,   602,   700,   603,     0,
     604,   605,   606,   607,  1583,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,  1071,   226,     0,
       0,  1072,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,  1041,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,  1073,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,  1063,   442,  1037,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,     0,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,  1067,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,  1068,   596,   213,   597,   598,   599,
    1069,   601,   602,   700,   603,     0,   604,   605,   606,   607,
    1583,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,  2409,   628,   629,
     630,   631,     0,  1071,   226,     0,     0,  1072,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,  1041,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
    1073,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,  1063,
     442,  1037,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,     0,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,     0,     0,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
     506,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,  1067,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
    1068,   596,   213,   597,   598,   599,  2476,   601,   602,   700,
     603,     0,   604,   605,   606,   607,  2477,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,  1071,
     226,     0,     0,  2478,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,  1041,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,  1073,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   681,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,     0,   433,
     434,   435,   135,   136,     0,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,  1063,   442,  1037,   140,   443,
       0,   444,   445,   446,   447,   144,     0,     0,     0,   448,
     449,   450,   451,     0,   452,     0,     0,   453,   454,   455,
     456,   457,   458,     0,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
       0,     0,     0,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,   506,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
       0,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,     0,     0,   521,     0,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,     0,   530,     0,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,  1067,   188,
       0,   190,   545,   546,   191,     0,   547,   548,     0,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,     0,     0,     0,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,     0,  1068,   596,   213,   597,
     598,   599,  1069,   601,   602,   700,   603,     0,   604,   605,
     606,   607,  2477,     0,   609,   218,   610,   611,     0,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,  1071,   226,     0,     0,  2478,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,  1041,   235,     0,   652,     0,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,  1073,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,   506,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,     0,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,     0,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,     0,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,    86,    87,    88,     0,    90,    91,    92,     0,     0,
       0,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,     0,     0,     0,   107,   108,   109,   110,
       0,   111,   112,   113,   114,   115, -2393,   116,   117,   118,
       0,     0,     0,     0,     0,   121,   122,     0,     0,     0,
       0,   123,     0,     0,     0,     0,     0,     0,     0,     0,
     124,     0,   125,     0,   126,   127,    35,     0,   412,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     133,     0,     0,     0,   135,   136,   137,   138,   139,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     140,     0,     0,     0,     0,     0,     0,   144,     0,   145,
       0,     0,     0,     0,     0,   148,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   151,     0,     0,     0,
       0,     0,   152,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   155,   156,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   162,
       0,     0,     0,     0,     0,     0,     0,   164,     0,     0,
       0,   166,     0,     0,     0,     0,   168,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
     172,     0,     0,     0,     0,     0,     0,     0,     0,   173,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   174,   175,     0,     0,     0,     0,     0,   176,
       0,   177,     0,     0,   178,   179,     0,   180,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   181,   182,
       0,   183,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   188,   189,   190,     0,     0,   191,     0,     0,     0,
     193,     0,     0,   194,     0,   195,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   196,   197,
     198,   199,   200,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   204,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   211,     0,     0,
     213,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   218,     0,     0,
     220,     0,   221,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   223,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   225,   226,     0,
       0,     0,   227,     0,   228,     0,     0,     0,     0,     0,
       0,     0,     0,   231,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   235,     0,
       0,   236,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   238,   239,   240,   241,   242,
     243,   244,   245,   246,    86,    87,    88,     0,    90,    91,
      92,     0,     0,     0,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,     0,     0,     0,   107,
     108,   109,   110,     0,   111,   112,   113,   114,   115, -2394,
     116,   117,   118,     0,     0,     0,     0,     0,   121,   122,
       0,     0,     0,     0,   123,     0,     0,     0,     0,     0,
       0,     0,     0,   124,     0,   125,     0,   126,   127,    35,
       0,  1147,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   133,     0,     0,     0,   135,   136,   137,
     138,   139,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   140,     0,     0,     0,     0,     0,     0,
     144,     0,   145,     0,     0,     0,     0,     0,   148,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   151,
       0,     0,     0,     0,     0,   152,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   155,   156,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   162,     0,     0,     0,     0,     0,     0,     0,
     164,     0,     0,     0,   166,     0,     0,     0,     0,   168,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   172,     0,     0,     0,     0,     0,     0,
       0,     0,   173,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   174,   175,     0,     0,     0,
       0,     0,   176,     0,   177,     0,     0,   178,   179,     0,
     180,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   181,   182,     0,   183,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   188,   189,   190,     0,     0,   191,
       0,     0,     0,   193,     0,     0,   194,     0,   195,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   196,   197,   198,   199,   200,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   201,     0,   202,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     204,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     211,     0,     0,   213,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     218,     0,     0,   220,     0,   221,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   223,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     225,   226,     0,     0,     0,   227,     0,   228,     0,     0,
       0,     0,     0,     0,     0,     0,   231,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   235,     0,     0,   236,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   238,   239,
     240,   241,   242,   243,   244,   245,   246,    86,    87,    88,
       0,    90,    91,    92,     0,     0,     0,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,     0,
       0,     0,   107,   108,   109,   110,     0,   111,   112,   113,
     114,   115,     0,   116,   117,   118,     0,     0,     0,     0,
       0,   121,   122,     0,     0,     0,     0,   123,     0,     0,
       0,     0,     0,     0,     0,     0,   124,     0,   125,     0,
     126,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   133,     0,     0,     0,
     135,   136,   137,   138,   139,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   140,     0,     0,     0,
       0,     0,     0,   144,     0,   145,     0,     0,     0,     0,
       0,   148,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   151,     0,     0,     0,     0,     0,   152,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   155,   156,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   162,     0,     0,     0,     0,
       0,     0,     0,   164,     0,     0,     0,   166,     0,     0,
       0,     0,   168,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   172,     0,     0,     0,
       0,     0,     0,     0,     0,   173,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   174,   175,
       0,     0,     0,     0,     0,   176,     0,   177,     0,     0,
     178,   179,     0,   180,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   181,   182,     0,   183,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   188,   189,   190,
       0,     0,   191,     0,     0,     0,   193,     0,     0,   194,
       0,   195,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   196,   197,   198,   199,   200,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   204,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   211,     0,     0,   213,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   218,     0,     0,   220,     0,   221,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   223,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   225,   226,     0,     0,     0,   227,     0,
     228,     0,     0,     0,     0,     0,     0,     0,     0,   231,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   235,     0,     0,   236,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   238,   239,   240,   241,   242,   243,   244,   245,   246,
      86,    87,    88,     0,    90,    91,    92,     0,     0,     0,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,     0,     0,     0,   107,   108,   109,   110,     0,
     111,   112,   113,   114,   115,     0,   116,   117,   118,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   133,
       0,     0,     0,   135,   136,   137,   138,   139,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   140,
       0,     0,     0,     0,     0,     0,   144,     0,   145,     0,
       0,     0,     0,     0,   148,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   151,     0,     0,     0,     0,
       0,   152,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   155,   156,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   162,     0,
       0,     0,     0,     0,     0,     0,   164,     0,     0,     0,
     166,     0,     0,     0,     0,   168,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,     0,     0,     0,   172,
       0,     0,     0,     0,     0,     0,     0,     0,   173,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   174,   175,     0,     0,     0,     0,     0,   176,     0,
     177,     0,     0,   178,   179,     0,   180,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   181,   182,     0,
     183,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     188,   189,   190,     0,     0,   191,     0,     0,     0,   193,
       0,     0,   194,     0,   195,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   196,   197,   198,
     199,   200,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   204,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   211,     0,     0,   213,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   218,     0,     0,   220,
       0,   221,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   223,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   225,   226,     0,     0,
       0,   227,     0,   228,     0,     0,     0,     0,     0,     0,
       0,     0,   231,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   235,     0,     0,
     236,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   238,   239,   240,   241,   242,   243,
     244,   245,   246,    86,    87,    88,     0,    90,    91,    92,
       0,     0,     0,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,     0,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   133,     0,     0,     0,   135,   136,   137,   138,
     139,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   140,     0,     0,     0,     0,     0,     0,   144,
       0,   145,     0,     0,     0,     0,     0,   148,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   151,     0,
       0,     0,     0,     0,   152,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   155,   156,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   164,
       0,     0,     0,   166,     0,     0,     0,     0,   168,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   172,     0,     0,     0,     0,     0,     0,     0,
       0,   173,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   174,   175,     0,     0,     0,     0,
       0,   176,     0,   177,     0,     0,   178,   179,     0,   180,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     181,   182,     0,   183,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   188,   189,   190,     0,     0,   191,     0,
       0,     0,   193,     0,     0,   194,     0,   195,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     196,   197,   198,   199,   200,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   201,     0,   202,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   204,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   211,
       0,     0,   213,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   218,
       0,     0,   220,     0,   221,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   223,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   225,
     226,     0,     0,     0,   227,     0,   228,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     235,     0,     0,   236,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   238,   239,   240,
     241,   242,   243,   244,   245,   246,    35,   417,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,     0,     0,
       0,    45,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
     133,   433,   434,   435,   135,   136,   137,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,     0,
     140,   443,     0,   444,   445,   446,   447,   144,     0,   145,
       0,   448,   449,   450,   451,   148,   452,     0,     0,   453,
     454,   455,   456,   457,   458,     0,   151,   459,     0,     0,
       0,     0,   152,     0,     0,     0,   460,   461,   462,   463,
       0,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,  2056,   493,     0,   494,   168,   495,     0,   496,
       0,   497,   169,     0,   170,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,     0,   505,   506,   173,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,   174,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,   178,   179,   521,   180,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,   182,
     530,   183,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,     0,   540,   541,     0,   542,   543,
     544,   188,   189,   190,   545,   546,   191,     0,   547,   548,
     193,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,  2057,     0,   555,   556,   557,     0,     0,   196,   197,
     198,   199,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,   211,   595,   596,
     213,   597,   598,   599,   600,   601,   602,     0,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
     220,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,  2058,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,     0,   235,     0,
     652,   236,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,    35,   662,   663,     0,     0,     0,
       0,     0,    41,    42,  1674,  1675,  4615,     0,     0,     0,
       0,     0,     0,  4616,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,   130,   131,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,   133,   433,
     434,   435,   135,   136,   137,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,     0,   140,   443,
       0,   444,   445,   446,   447,   144,     0,   145,     0,   448,
     449,   450,   451,   148,   452,     0,     0,   453,   454,   455,
     456,   457,   458,     0,   151,   459,     0,     0,     0,     0,
     152,     0,     0,     0,   460,   461,   462,   463,     0,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
     169,     0,   170,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,     0,   505,   506,   173,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
     174,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,   178,   179,   521,   180,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,   182,   530,   183,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,     0,   540,   541,     0,   542,   543,   544,   188,
     189,   190,   545,   546,   191,     0,   547,   548,   193,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,   197,   198,   199,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,   211,   595,   596,   213,   597,
     598,   599,   600,   601,   602,     0,   603,   216,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,   220,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,   224,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,   234,   235,     0,   652,   236,
     653,   654,   655,     0,     0,   656,     0,   237,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,     0,   662,   663,    35,   417,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,     0,     0,     0,
      45,   247,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,   133,
     433,   434,   435,   135,   136,   137,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,     0,   140,
     443,     0,   444,   445,   446,   447,   144,     0,   145,     0,
     448,   449,   450,   451,   148,   452,     0,     0,   453,   454,
     455,   456,   457,   458,     0,   151,   459,     0,     0,     0,
       0,   152,     0,     0,     0,   460,   461,   462,   463,     0,
     464,   155,   156,   465,  2275,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,  2056,   493,     0,   494,   168,   495,     0,   496,     0,
     497,   169,     0,   170,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,     0,   505,   506,   173,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,   174,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,   178,   179,   521,   180,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,   182,   530,
     183,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,     0,   540,   541,     0,   542,   543,   544,
     188,   189,   190,   545,   546,   191,     0,   547,   548,   193,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
    2057,     0,   555,   556,   557,     0,     0,   196,   197,   198,
     199,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,   211,   595,   596,   213,
     597,   598,   599,   600,   601,   602,     0,   603,     0,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,   220,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,  2058,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,     0,   235,     0,   652,
     236,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,     0,   662,   663,     0,     0,     0,     0,
       0,    35,   417,  1674,  1675,    37,    38,    39,    40,    41,
      42,    43,    44,     0,     0,     0,    45,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,   133,   433,   434,   435,   135,
     136,   137,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,     0,   140,   443,     0,   444,   445,
     446,   447,   144,     0,   145,     0,   448,   449,   450,   451,
     148,   452,     0,     0,   453,   454,   455,   456,   457,   458,
       0,   151,   459,     0,     0,     0,     0,   152,     0,     0,
       0,   460,   461,   462,   463,     0,   464,   155,   156,   465,
    2280,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,  2056,   493,     0,
     494,   168,   495,     0,   496,     0,   497,   169,     0,   170,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,     0,   505,   506,   173,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,   174,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,   178,
     179,   521,   180,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,   182,   530,   183,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,     0,
     540,   541,     0,   542,   543,   544,   188,   189,   190,   545,
     546,   191,     0,   547,   548,   193,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,  2057,     0,   555,   556,
     557,     0,     0,   196,   197,   198,   199,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,   211,   595,   596,   213,   597,   598,   599,   600,
     601,   602,     0,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,   220,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
    2058,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,     0,   235,     0,   652,   236,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,     0,
     662,   663,     0,     0,     0,     0,     0,    35,   417,  1674,
    1675,    37,    38,    39,    40,    41,    42,    43,    44,     0,
       0,     0,    45,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,   133,   433,   434,   435,   135,   136,   137,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
       0,   140,   443,     0,   444,   445,   446,   447,   144,     0,
     145,     0,   448,   449,   450,   451,   148,   452,     0,     0,
     453,   454,   455,   456,   457,   458,     0,   151,   459,     0,
       0,     0,     0,   152,     0,     0,     0,   460,   461,   462,
     463,     0,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,  2056,   493,     0,   494,   168,   495,     0,
     496,     0,   497,   169,     0,   170,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,     0,   505,   506,
     173,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,   174,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,   178,   179,   521,   180,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
     182,   530,   183,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,     0,   540,   541,     0,   542,
     543,   544,   188,   189,   190,   545,   546,   191,     0,   547,
     548,   193,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,  2057,     0,   555,   556,   557,     0,     0,   196,
     197,   198,   199,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,   211,   595,
     596,   213,   597,   598,   599,   600,   601,   602,     0,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,   220,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,  2058,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,     0,   235,
       0,   652,   236,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,     0,   662,   663,     0,     0,
       0,     0,     0,    35,     0,  1674,  1675,    37,    38,    39,
      40,    41,    42,     0,    44,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,   133,   433,   434,
     435,   135,   136,   137,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,     0,   140,   443,     0,
     444,   445,   446,   447,   144,     0,   145,     0,   448,   449,
     450,   451,   148,   452,     0,     0,   453,   454,   455,   456,
     457,   458,     0,   151,   459,     0,     0,     0,     0,   152,
       0,     0,     0,   460,   461,   462,   463,     0,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,  2056,
     493,     0,   494,   168,   495,     0,   496,     0,   497,   169,
       0,   170,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,     0,   505,   506,   173,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,   174,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,   178,   179,   521,   180,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,   182,   530,   183,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,     0,   540,   541,     0,   542,   543,   544,   188,   189,
     190,   545,   546,   191,     0,   547,   548,   193,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,  2057,     0,
     555,   556,   557,     0,     0,   196,   197,   198,   199,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,   211,   595,   596,   213,   597,   598,
     599,   600,   601,   602,     0,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,   220,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,  2058,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,     0,   235,     0,   652,   236,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,     0,   662,   663,    35,   417,     0,     0,    37,    38,
      39,    40,    41,    42,     0,    44,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,   133,   433,
     434,   435,   135,   136,   137,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,     0,   140,   443,
       0,   444,   445,   446,   447,   144,     0,   145,     0,   448,
     449,   450,   451,   148,   452,     0,     0,   453,   454,   455,
     456,   457,   458,     0,   151,   459,     0,     0,     0,     0,
     152,     0,     0,     0,   460,   461,   462,   463,     0,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
     169,     0,   170,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,     0,   505,   506,   173,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
     174,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,   178,   179,   521,   180,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,   182,   530,   183,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,     0,   540,   541,     0,   542,   543,   544,   188,
     189,   190,   545,   546,   191,     0,   547,   548,   193,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,   197,   198,   199,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,   211,   595,   596,   213,   597,
     598,   599,   600,   601,   602,     0,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,   220,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,   632,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,     0,   235,     0,   652,   236,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,     0,   662,   663,    35,   417,     0,     0,    37,
      38,    39,    40,    41,    42,     0,    44,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,   133,
     433,   434,   435,   135,   136,   137,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,     0,   140,
     443,     0,   444,   445,   446,   447,   144,     0,   145,     0,
     448,   449,   450,   451,   148,   452,     0,     0,   453,   454,
     455,   456,   457,   458,     0,   151,   459,     0,     0,     0,
       0,   152,     0,     0,     0,   460,   461,   462,   463,     0,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,     0,
     497,   169,     0,   170,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,     0,   505,   506,   173,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,   174,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,   178,   179,   521,   180,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,   182,   530,
     183,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,     0,   540,   541,     0,   542,   543,   544,
     188,   189,   190,   545,   546,   191,     0,   547,   548,   193,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,   197,   198,
     199,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,   211,   595,   596,   213,
     597,   598,   599,   600,   601,   602,     0,   603,     0,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,   220,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,     0,   235,     0,   652,
     236,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,    35,   662,   663,     0,    37,    38,    39,
      40,    41,    42,     0,    44,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,   133,   433,   434,
     435,   135,   136,   137,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,     0,   140,   443,     0,
     444,   445,   446,   447,   144,     0,   145,     0,   448,   449,
     450,   451,   148,   452,     0,     0,   453,   454,   455,   456,
     457,   458,     0,   151,   459,     0,     0,     0,     0,   152,
       0,     0,     0,   460,   461,   462,   463,     0,   464,   155,
     156,   465,  2260,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,   169,
       0,   170,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,     0,   505,   506,   173,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,   174,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,   178,   179,   521,   180,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,   182,   530,   183,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,     0,   540,   541,     0,   542,   543,   544,   188,   189,
     190,   545,   546,   191,     0,   547,   548,   193,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,   197,   198,   199,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,   211,   595,   596,   213,   597,   598,
     599,   600,   601,   602,     0,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,   220,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,     0,   235,     0,   652,   236,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,    35,   662,   663,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,   133,   433,   434,   435,   135,
     136,   137,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,     0,   140,   443,     0,   444,   445,
     446,   447,   144,     0,   145,     0,   448,   449,   450,   451,
     148,   452,     0,     0,   453,   454,   455,   456,   457,   458,
       0,   151,   459,     0,     0,     0,     0,   152,     0,     0,
       0,   460,   461,   462,   463,     0,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,   169,     0,   170,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,     0,   505,   506,   173,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,   174,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,   178,
     179,   521,   180,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,   182,   530,   183,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,     0,
     540,   541,     0,   542,   543,   544,   188,   189,   190,   545,
     546,   191,     0,   547,   548,   193,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,   197,   198,   199,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,   211,   595,   596,   213,   597,   598,   599,   600,
     601,   602,     0,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,   220,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,     0,   235,     0,   652,   236,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,    35,
     662,   663,     0,    37,    38,    39,    40,    41,    42,     0,
      44,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,   133,   433,   434,   435,   135,   136,   137,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,     0,   140,   443,     0,   444,   445,   446,   447,
     144,     0,   145,     0,   448,   449,   450,   451,   148,   452,
       0,     0,   453,   454,   455,   456,   457,   458,     0,   151,
     459,     0,     0,     0,     0,   152,     0,     0,     0,   460,
     461,   462,   463,     0,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,   169,     0,   170,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,     0,
     505,  2036,   173,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,   174,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,   178,   179,   521,
     180,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,   182,   530,   183,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,     0,   540,   541,
       0,   542,   543,   544,   188,   189,   190,   545,   546,   191,
       0,   547,   548,   193,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,   197,   198,   199,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
     211,   595,   596,   213,   597,   598,   599,   600,   601,   602,
       0,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,   220,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
       0,   235,     0,   652,   236,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,    35,   662,   663,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,   133,   433,   434,   435,   135,   136,   137,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
       0,   140,   443,     0,   444,   445,   446,   447,   144,     0,
     145,     0,   448,   449,   450,   451,   148,   452,     0,     0,
     453,   454,   455,   456,   457,   458,     0,   151,   459,     0,
       0,     0,     0,   152,     0,     0,  2597,   460,   461,   462,
     463,     0,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,   169,     0,   170,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,     0,   505,   506,
     173,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,   174,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,   178,   179,   521,   180,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
     182,   530,   183,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,     0,   540,   541,     0,   542,
     543,   544,   188,   189,   190,   545,   546,   191,     0,   547,
     548,   193,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
     197,   198,   199,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,   211,   595,
     596,   213,   597,   598,   599,   600,   601,   602,     0,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,   220,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,  2598,     0,   647,   648,   649,   650,   651,     0,   235,
       0,   652,   236,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,    35,   662,   663,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,   130,   131,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,   133,
     433,   434,   435,   135,   136,   137,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,     0,   140,
     443,     0,   444,   445,   446,   447,   144,     0,   145,     0,
     448,   449,   450,   451,   148,   452,     0,     0,   453,   454,
     455,   456,   457,   458,     0,   151,   459,     0,     0,     0,
       0,   152,     0,     0,     0,   460,   461,   462,   463,     0,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,     0,
     497,   169,     0,   170,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,     0,   505,   506,   173,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,   174,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,   178,   179,   521,   180,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,   182,   530,
     183,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,     0,   540,   541,     0,   542,   543,   544,
     188,   189,   190,   545,   546,   191,     0,   547,   548,   193,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,   197,   198,
     199,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,   211,   595,   596,   213,
     597,   598,   599,   600,   601,   602,     0,   603,     0,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,   220,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,     0,   235,     0,   652,
     236,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,    35,   662,   663,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,  1223,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,   133,   433,   434,
     435,   135,   136,   137,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,     0,   140,   443,     0,
     444,   445,   446,   447,   144,     0,   145,     0,   448,   449,
     450,   451,   148,   452,     0,     0,   453,   454,   455,   456,
     457,   458,     0,   151,   459,     0,     0,     0,     0,   152,
       0,     0,     0,   460,   461,   462,   463,     0,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,   169,
       0,   170,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,     0,   505,   506,   173,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,   174,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,   178,   179,   521,   180,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,   182,   530,   183,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,     0,   540,   541,     0,   542,   543,   544,   188,   189,
     190,   545,   546,   191,     0,   547,   548,   193,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,   197,   198,   199,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,   211,   595,   596,   213,   597,   598,
     599,   600,   601,   602,     0,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,   220,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,     0,   235,     0,   652,   236,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,    35,   662,   663,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,  1236,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,   133,   433,   434,   435,   135,
     136,   137,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,     0,   140,   443,     0,   444,   445,
     446,   447,   144,     0,   145,     0,   448,   449,   450,   451,
     148,   452,     0,     0,   453,   454,   455,   456,   457,   458,
       0,   151,   459,     0,     0,     0,     0,   152,     0,     0,
       0,   460,   461,   462,   463,     0,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,   169,     0,   170,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,     0,   505,   506,   173,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,   174,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,   178,
     179,   521,   180,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,   182,   530,   183,     0,   531,   532,
     533,     0,     0,   534,   535,  1237,   537,   538,   539,     0,
     540,   541,     0,   542,   543,   544,   188,   189,   190,   545,
     546,   191,     0,   547,   548,   193,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,   197,   198,   199,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,   211,   595,   596,   213,   597,   598,   599,   600,
     601,   602,     0,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,   220,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,     0,   235,     0,   652,   236,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,    35,
     662,   663,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,   133,   433,   434,   435,   135,   136,   137,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,     0,   140,   443,     0,   444,   445,   446,   447,
     144,     0,   145,     0,   448,   449,   450,   451,   148,   452,
       0,     0,   453,   454,   455,   456,   457,   458,     0,   151,
     459,     0,     0,     0,     0,   152,     0,     0,     0,   460,
     461,   462,   463,     0,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,   169,     0,   170,   498,   499,
     500,     0,   501,   172,  3482,   502,     0,   503,   504,     0,
     505,   506,   173,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,   174,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,   178,   179,   521,
     180,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,   182,   530,   183,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,     0,   540,   541,
       0,   542,   543,   544,   188,   189,   190,   545,   546,   191,
       0,   547,   548,   193,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,   197,   198,   199,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
     211,   595,   596,   213,   597,   598,   599,   600,   601,   602,
       0,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,   220,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
       0,   235,     0,   652,   236,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,    35,   662,   663,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,   133,   433,   434,   435,   135,   136,   137,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
       0,   140,   443,     0,   444,   445,   446,   447,   144,     0,
     145,     0,   448,   449,   450,   451,   148,   452,     0,     0,
     453,   454,   455,   456,   457,   458,     0,   151,   459,     0,
       0,     0,     0,   152,     0,     0,     0,   460,   461,   462,
     463,     0,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,   169,     0,   170,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,     0,   505,   506,
     173,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,   174,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,   178,   179,   521,   180,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
     182,   530,   183,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,     0,   540,   541,     0,   542,
     543,   544,   188,   189,   190,   545,   546,   191,     0,   547,
     548,   193,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
     197,   198,   199,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,   211,   595,
     596,   213,   597,   598,   599,   600,   601,   602,     0,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,   220,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,     0,   235,
       0,   652,   236,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,    35,   662,   663,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,   133,
     433,   434,   435,   135,   136,   137,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,     0,   140,
     443,     0,   444,   445,   446,   447,   144,     0,   145,     0,
     448,   449,   450,   451,   148,   452,     0,     0,   453,   454,
     455,   456,   457,   458,     0,   151,   459,     0,     0,     0,
       0,   152,     0,     0,     0,   460,   461,   462,   463,     0,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,     0,
     497,   169,     0,   170,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,     0,   505,   506,   173,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,   174,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,   178,   179,   521,   180,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,   182,   530,
     183,     0,   531,   532,   533,     0,     0,   534,   535,  1315,
     537,   538,   539,     0,   540,   541,     0,   542,   543,   544,
     188,   189,   190,   545,   546,   191,     0,   547,   548,   193,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,   197,   198,
     199,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,   211,   595,   596,   213,
     597,   598,   599,   600,   601,   602,     0,   603,     0,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,   220,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,     0,   235,     0,   652,
     236,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,    35,   662,   663,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,   133,   433,   434,
     435,   135,   136,   137,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,     0,   140,   443,     0,
     444,   445,   446,   447,   144,     0,   145,     0,   448,   449,
     450,   451,   148,   452,     0,     0,   453,   454,   455,   456,
     457,   458,     0,   151,   459,     0,     0,     0,     0,   152,
       0,     0,     0,   460,   461,   462,   463,     0,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,   169,
       0,   170,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,     0,   505,  1354,   173,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,   174,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,   178,   179,   521,   180,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,   182,   530,   183,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,     0,   540,   541,     0,   542,   543,   544,   188,   189,
     190,   545,   546,   191,     0,   547,   548,   193,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,   197,   198,   199,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,   211,   595,   596,   213,   597,   598,
     599,   600,   601,   602,     0,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,   220,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,     0,   235,     0,   652,   236,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,    35,   662,   663,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,   133,   433,   434,   435,   135,
     136,   137,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,     0,   140,   443,     0,   444,   445,
     446,   447,   144,     0,   145,     0,   448,   449,   450,   451,
     148,   452,     0,     0,   453,   454,   455,   456,   457,   458,
       0,   151,   459,     0,     0,     0,     0,   152,     0,     0,
       0,   460,   461,   462,   463,     0,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,   169,     0,   170,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,     0,   505,  1364,   173,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,   174,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,   178,
     179,   521,   180,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,   182,   530,   183,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,     0,
     540,   541,     0,   542,   543,   544,   188,   189,   190,   545,
     546,   191,     0,   547,   548,   193,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,   197,   198,   199,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,   211,   595,   596,   213,   597,   598,   599,   600,
     601,   602,     0,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,   220,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,     0,   235,     0,   652,   236,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,    35,
     662,   663,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,   133,   433,   434,   435,   135,   136,   137,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,     0,   140,   443,     0,   444,   445,   446,   447,
     144,     0,   145,     0,   448,   449,   450,   451,   148,   452,
       0,     0,   453,   454,   455,   456,   457,   458,     0,   151,
     459,     0,     0,     0,     0,   152,     0,     0,     0,   460,
     461,   462,   463,     0,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,   169,     0,   170,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,     0,
     505,  1375,   173,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,   174,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,   178,   179,   521,
     180,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,   182,   530,   183,     0,   531,   532,   533,     0,
       0,   534,   535,  1376,   537,   538,   539,     0,   540,   541,
       0,   542,   543,   544,   188,   189,   190,   545,   546,   191,
       0,   547,   548,   193,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,   197,   198,   199,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
     211,   595,   596,   213,   597,   598,   599,   600,   601,   602,
       0,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,   220,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
       0,   235,     0,   652,   236,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,     0,   662,   663
};

static const yytype_int16 yycheck[] =
{
       2,   364,   247,    78,    78,   894,    78,  1065,  1113,  1362,
      78,  1118,  1401,   852,   153,  1357,  1353,  1183,  1229,   167,
    1081,  1930,  1141,   932,  1740,     2,   210,  1611,  1009,  1010,
    1011,  1628,   154,  1248,  1015,   229,  2095,  1431,  1775,   187,
      78,  1285,  1224,   150,  2834,   224,    84,  1914,   932,   724,
    1464,  2492,  2493,  2045,  1521,   894,  1238,  1072,  1784,  1450,
     838,   950,   160,  1873,  1780,  2669,    78,   976,   165,   847,
    1304,  1793,  2987,  3164,  2537,  3427,    78,   117,   952,   171,
    1314,   203,    84,  2249,   380,   132,  1205,    89,   962,  1228,
     165,  2677,  1231,  1932,  1492,  1493,   380,  2634,  1828,  1343,
    3375,  1240,   880,  1973,  2993,    78,    96,  1775,  1290,  2299,
    1836,   950,  1294,  1511,  1632,   117,   106,  1299,   210,  1841,
    1842,  3438,   162,  2134,  1306,  1668,  1669,  1670,  3214,  2587,
    3216,   352,  3343,  3728,  1316,    94,  3677,  1160,  3053,  1723,
     366,  1160,   725,  2812,  3060,  3356,  3356,  3924,   975,  2991,
     167,   153,   142,  2989,  2990,  3721,  3776,  3976,   936,  1068,
     162,   366,  3966,  3987,  2034,   217,  2926,   157,   946,  1780,
     187,  3629,  1767,   132,  1984,  2325,  2323,  1394,  1385,  1727,
    3623,  1663,  1664,  4409,  1068,  1976,  4204,  1110,  1200,  1110,
    2349,   231,  1481,  1482,   153,   154,  1155,  1156,  1414,  3689,
      30,  3628,    21,    10,   163,  3560,   108,   209,    88,  2672,
     128,    95,    72,   135,  4550,   217,   832,   219,  1507,   228,
    3896,   121,  3360,  3361,  3362,  3363,  3364,  3365,   114,   231,
    2389,   967,  3964,    72,  2393,    78,   229,    88,   128,  4690,
     156,    84,    81,  3975,   203,   920,   143,    86,    84,    75,
      76,    77,    78,    14,   145,   114,    82,  4683,   204,   112,
     179,   137,   113,   187,   145,    75,    76,    77,    78,   210,
      95,   145,    82,   180,   117,  4553,    37,   153,   248,    95,
      90,   128,  1401,  2746,   228,  2748,    75,    76,    77,    78,
     322,  2200,   143,    82,    72,   149,  3891,   372,   372,   236,
     372,   128,  1283,    81,   372,   100,  3066,   267,    86,   135,
     182,    72,   355,   197,    75,    76,    77,    78,    78,   162,
      81,    82,    83,    84,    99,    86,   310,   112,   234,    72,
     153,   106,   208,  1394,   111,   228,   145,  1393,    75,    76,
      77,    78,   380,    86,   153,    82,    78,    78,  4630,   225,
      75,    76,    77,    78,   269,   327,    78,    82,   102,   401,
     372,    75,    76,    77,    78,  4643,   223,   434,    82,   109,
     182,   117,   197,   475,  1540,   372,    90,   415,   380,  1268,
    1595,   197,    75,    76,    77,    78,     0,  1062,   231,    82,
      88,  2450,   494,    75,    76,    77,    78,    90,  1564,   372,
      82,   991,    99,   182,   401,   995,   996,   997,   228,    78,
      99,   326,   211,   415,   360,  1005,   162,   106,   103,   104,
      78,    78,   145,    75,    76,    77,    78,   228,   495,  1268,
      82,   180,  4209,    75,    76,    77,    78,    99,    90,    78,
      82,    78,   137,   102,   106,   317,   383,    78,   188,  4675,
    1917,    75,    76,    77,    78,   180,   228,   416,    82,   271,
     378,   377,   403,   209,   145,   508,    90,   262,   510,  1378,
     247,   217,   199,   219,  1593,  1253,   508,   353,    78,  1598,
    1599,  4759,    29,  1539,    78,   231,  1264,  2646,   378,  1363,
     434,  4769,  1401,   632,  1378,  2092,   456,    88,  1559,  2096,
     312,  2098,   511,   228,  2101,   185,   490,  1905,  1906,    75,
      76,    77,    78,   208,  1912,   508,    82,   436,    75,    76,
      77,    78,   113,   339,  4806,    82,    75,    76,    77,    78,
     225,   378,   456,    82,  1887,  4961,   508,   380,   834,  1600,
    1601,   511,   227,   434,   229,  1882,  1324,   372,   434,   361,
     834,   378,   143,   434,   676,   677,   372,   476,  4894,  1468,
     434,  1177,   508,  1437,    75,    76,    77,    78,   421,   135,
     454,    82,   415,   449,  1157,  1158,  1403,  3715,  1452,   415,
      75,    76,    77,    78,  1468,   401,   508,    82,   495,  3800,
    3800,  1465,   446,   511,  3946,   511,  4373,    75,    76,    77,
      78,   461,   461,  4198,    82,   511,   508,  4411,   508,   506,
    2194,   434,   372,   510,  1903,  1904,  1755,    93,   511,  5070,
    2487,   511,  1911,  1834,   504,   434,    75,    76,    77,    78,
     632,   375,  1876,    82,   409,   474,   421,   456,  1757,   465,
     372,   372,  1824,   459,  1826,   394,  1765,  1383,  4425,   346,
     372,   508,  3115,   504,   461,  2239,  1871,  2496,   353,  2243,
     499,   500,  1801,  1897,  4122,  4341,  4342,  4343,  4344,  4345,
    4402,   470,   160,   632,   228,   424,   506,   173,   267,   458,
     859,  1590,   508,   502,   511,  3960,   475,  4130,   508,  1598,
    1599,  4134,  2086,  4183,  4121,  4050,  2038,  1816,   508,   511,
    1819,  1820,   841,   372,   173,   494,  1590,  3622,  3623,   434,
     511,   434,   259,   462,   372,   372,   375,   676,   677,   508,
     409,   499,   500,   185,  1683,   474,  4952,  1650,   387,  1650,
     427,   976,   429,   372,   210,   372,   508,  2463,   499,   500,
    4758,   372,  3183,   470,  3185,   233,   885,   409,   267,  3638,
    1113,  2093,   173,   434,   449,  2492,   499,   500,   979,   508,
    2102,  2552,  1774,   267,  1883,   724,    78,  3905,  4545,   506,
     495,   508,   372,   510,   454,  4552,   874,   175,   372,   438,
      85,   466,   267,    88,  3321,   510,   237,  3324,  3325,   173,
     830,  3328,   151,   475,   508,   173,   834,  3334,  5024,   261,
     922,  3643,   941,   501,   502,   503,   504,  2533,   210,  3395,
    3725,  1394,   494,   237,  1404,   508,   185,  1407,   137,   173,
    1410,  3166,  1412,   465,    85,  1415,   508,    88,   830,  1419,
     189,   383,   834,   322,  2051,  2042,   838,   149,  3004,   385,
     988,  1020,   990,   241,   992,   847,   848,  1287,   332,    25,
     998,  2067,   854,   165,  4673,  2403,   508,  2073,  3017,   310,
     105,   180,   864,  3326,  3327,   972,   508,   107,  2350,    25,
    2352,  2160,  2161,  1021,  1022,    95,    95,  1103,   880,   976,
     434,   101,   101,   436,   508,  3035,  2481,  3034,   322,  2500,
     892,   379,   261,    38,   896,    40,    85,   237,  1103,    88,
     975,   299,  3343,   455,   302,   907,  3997,   391,  1087,   385,
     501,   502,   503,   504,   185,  3356,   128,  1806,    75,    76,
      77,    78,   511,   476,   926,    82,   197,   403,   424,   398,
     932,   117,   173,  3693,   936,   247,    14,   456,  1117,   180,
     180,   495,   508,    72,   946,   947,    75,    76,    77,    78,
     952,   508,    81,    82,    83,    84,   510,    86,   466,   508,
     962,   920,   508,   922,   269,   967,   211,  1806,   267,   151,
     310,   228,   267,   990,   976,   992,   162,   197,   197,   441,
    2710,   340,   117,   973,   310,  2722,   474,   830,  2049,   325,
     967,   834,   454,   312,   392,  3436,  1093,   508,   317,  1980,
     990,   403,   992,   424,  1021,  1022,   510,   189,   269,   460,
    1450,   970,  1002,   508,  1066,   974,   180,  1064,  1070,   508,
    1199,   509,   231,   328,   512,  2191,   511,   162,  4847,  3374,
     508,  1021,  1022,  4857,   353,   332,   460,  4841,  4496,   230,
     424,  2099,  2100,  4638,   151,   231,   424,  4399,   367,  4509,
    1088,  4511,  4766,  4767,   366,   228,    99,  4500,  1060,   508,
     372,   512,  4505,   228,  1066,  4508,  1068,   328,  1070,   428,
     424,   312,    88,   332,   508,   248,   175,  2133,  2134,   350,
     269,   327,   189,   248,   830,   454,  1088,   263,  2144,   141,
     267,   489,  2148,  1095,   267,   151,   231,   113,   310,  3008,
    2156,  2157,   267,  1062,   147,  1064,   230,   263,  4425,    85,
     508,   154,    72,  2169,  2170,    75,    76,    77,    78,   339,
     460,    81,    82,   228,  2180,   185,    86,   143,   174,  2018,
     449,   223,   389,   189,   460,   228,  2010,   328,   181,   328,
     339,    85,   241,   248,    88,    95,  2055,  2021,   312,  4953,
    4236,   101,   372,  1155,  1156,   248,   121,   456,   340,  2033,
      85,   456,   267,    88,  1141,   175,   378,   312,   180,    14,
     474,   434,   508,   414,   267,  4770,   417,   222,   175,  2018,
     105,   401,   326,  1160,   153,  4962,   192,   396,   194,   401,
    4756,   496,   497,    99,   499,   500,   501,   502,   503,   504,
     299,   261,   401,  2800,  5023,   251,   171,   511,  5027,   252,
     467,   180,   509,   512,   511,  4130,   425,   241,  1191,  4134,
     192,  1999,   194,  2284,  4844,   389,   417,  2054,  1205,  1327,
    2008,   241,   478,   340,   495,   496,   497,   230,   499,   500,
     501,   502,   503,   504,   241,  1088,   428,   197,   511,  2368,
    5069,  1253,   511,   269,   270,   495,   160,  2655,   415,   416,
     273,   332,  1264,   387,  4153,  4181,   506,   508,   508,   509,
     510,   511,  4986,   325,  4163,   299,  4736,  2166,  2336,   456,
     160,  1721,   374,   456,   340,  1287,   192,   326,   129,   299,
    4733,   456,   302,   392,  1539,   260,   137,   310,   220,   315,
     312,    88,   299,   348,   248,   302,  4901,  4149,  4144,   434,
     499,   500,   501,   502,   503,   504,   322,  2095,   442,  4161,
    1066,   428,  1324,    25,  1070,   269,   113,  2166,  1403,   233,
    3867,  3537,   180,    35,   394,   328,  3873,  3874,   173,   512,
     312,  3180,  5037,   312,   269,   310,   145,   512,  3187,  2583,
     322,   456,   328,   233,   153,  3561,   143,  4898,  4899,  3800,
    2499,  1363,  4031,   456,  1804,  2388,  4577,  4577,   392,  2388,
     499,   500,   428,   365,   417,   219,  1378,   423,   424,  4654,
    1382,  1383,   392,  1385,   328,  4660,   511,   309,    99,   339,
     403,  1393,    22,  4988,   454,   392,  2749,   121,   299,  1401,
    1621,  2743,  2739,   328,   387,  1382,  1383,   512,  1385,  1635,
    1636,    88,  1638,  2552,  5109,   151,  1406,  1713,  1408,   512,
    3479,  1411,   372,  1413,  1401,   390,  1416,  1417,  1418,  1713,
    1635,  1636,   134,  1638,  2573,  1437,  2555,  1877,   509,  1429,
     511,   454,    72,   287,  2563,  3182,  2565,   171,  1450,   290,
    1452,   401,  1442,   189,  1444,   438,  1896,  2639,  2692,  2693,
    2694,  2695,   424,  1465,   374,  2604,  1468,   506,  2051,   317,
    2704,   510,   229,  1652,   119,   310,   468,  1479,   338,   489,
    4832,   192,   269,   499,   500,   501,   502,   503,   504,  2733,
    1449,   392,   489,     8,  5089,   312,    11,    12,   508,   379,
    3018,  3959,  1942,   372,  3515,  5046,  1508,    22,    23,    24,
    3700,    26,    27,  3110,  3182,   387,    31,    32,    33,   495,
     496,   497,   297,   499,   500,   501,   502,   503,   504,  1576,
    1577,    95,   401,  3263,  1536,  1537,   260,  1539,   436,    71,
     500,   237,   359,  4006,   207,  4008,  3272,    79,    80,   274,
    1552,   495,   496,   497,  1556,   499,   500,   501,   502,   503,
     504,   263,    88,  2452,   474,  2005,   438,   352,   172,  1609,
     495,   496,   497,   153,   499,   500,   501,   502,   503,   504,
      75,    76,    77,    78,   341,  4500,   310,    82,  1590,   232,
    4505,  1593,   269,  4508,   474,  3465,  1598,  1599,   231,   244,
    4691,   511,   265,   248,   340,   339,  1608,  1609,  4960,   352,
     512,   182,  4574,  2452,   310,   182,  1593,  1576,  1577,   209,
     152,  1598,  1599,   184,  2498,  1663,  1664,  4516,  4517,   509,
      97,  4546,   512,   197,  1681,  1637,   184,   385,   372,  1641,
    1642,   286,  4604,   339,   830,  4962,   229,   290,   248,   406,
     117,   436,   232,     5,  1752,  4445,  1835,   508,   173,   249,
    1662,  1663,  1664,   975,   976,  2443,   390,   401,   190,   332,
     202,   251,  2450,    25,   257,  1713,   372,   299,   200,   394,
     302,  1683,  1720,    35,   255,  2804,   183,  1727,  4774,   272,
     155,   476,   428,   436,   298,   830,   300,  1674,  1675,  3421,
     162,   284,  3424,   192,   271,   194,   454,   268,  2383,   424,
     290,  1713,   499,   500,   501,   502,   503,   504,  1720,  1721,
     268,   253,  1681,  1700,  1701,  1727,  3120,   506,   217,   194,
     223,   510,  1734,   476,   339,   360,   248,  2718,   137,   310,
     233,   312,  5017,   269,   143,   312,   219,   462,   245,   387,
    4540,   331,  4542,   183,   153,   248,  4219,  4220,    88,   474,
     405,   386,  2202,   396,   460,  1767,  1609,   372,  4683,   231,
     392,  4862,   372,  1775,   508,   339,   376,  4381,  4315,  4316,
    1757,   180,   134,   182,   427,   448,   429,   182,  1765,   304,
    3188,  1103,   425,   508,   361,   262,   401,  4401,  3151,   382,
     438,   401,  1804,   506,  4390,  2861,     2,  3350,   372,   452,
     513,   444,   344,   143,   287,   245,  2725,   339,  4733,  1662,
    1663,  1664,   499,   500,   501,   502,   503,   504,   317,    75,
      76,    77,    78,   322,   349,  1808,    82,   401,  1811,  1816,
     335,  2725,  1819,  1820,   196,   183,   128,   427,    88,   429,
     372,   324,   232,  2762,  2910,  1857,   255,   456,   438,  4748,
     372,  2547,   365,  1609,   376,   147,   514,  2006,   230,   449,
    1713,   161,   452,   113,   474,  1877,   271,  1720,  2762,   161,
    3477,   115,   511,  1856,  1727,  2941,   182,  1860,   381,   401,
    3009,   456,   395,    89,  1896,  3139,   258,  1937,    75,    76,
      77,    78,   136,   143,   197,    82,  1883,   245,    41,   508,
     290,   263,  1914,   312,  3753,   447,  2602,   312,   317,  3729,
    2976,   424,   495,   455,   512,   232,   458,   223,   443,  2108,
     212,    75,    76,    77,    78,  1937,   339,   510,    82,   229,
    1942,    71,  2126,   508,   330,    75,    76,    77,    78,    79,
      80,   440,    82,   339,   353,  1957,  3167,   153,  2055,   255,
     456,   450,   474,   159,   474,   468,   361,   257,   367,   372,
     474,  1973,   456,   499,   500,   501,   502,   503,   504,  2054,
     263,  1727,   272,   290,  3195,   365,   372,   385,  1734,   185,
     297,  3006,  3901,   192,   284,   194,    16,  1999,  2294,  4165,
    3584,   511,   152,  2005,    14,   339,  2008,   511,  2010,  2011,
    2294,  3405,   508,   408,   310,   413,   312,   307,   217,  2021,
    3414,  1767,   273,    75,    76,    77,    78,    37,   339,  3168,
      82,  2033,  2034,  2125,  2132,  3761,   355,   330,   372,   160,
    2042,  2116,  2116,  2045,  2116,   175,  4961,   427,  2116,   429,
     449,   201,    14,  2055,   475,   438,  3778,  3779,   179,   310,
    2838,   372,    72,   339,  2504,  2042,  2844,   401,  2045,  2958,
    4607,   317,   452,   494,  2064,    37,  2066,  3803,   321,   394,
    2070,   467,  2072,   376,    51,  2075,  3500,   508,   468,  2079,
     211,  1403,   382,  2095,  1937,  3234,   372,  3564,  3565,   376,
    3009,   228,    69,     7,  2116,    71,    72,   223,   401,   424,
     361,   241,  2787,   312,   223,    19,    20,  3701,   317,  2958,
     427,   248,   429,   322,   401,   401,   339,   243,   468,   279,
     280,  2133,  2134,    97,   243,    39,  4577,   219,    42,  2141,
     317,   223,  2144,   293,   161,   452,  2148,   462,    34,   361,
     506,  2153,   403,   117,  2156,  2157,   512,    72,  1955,   372,
     389,   373,  2164,  1475,  2204,  2167,  2168,  2169,  2170,   299,
    3507,    86,   302,   317,    81,  2177,  2178,  1974,  2180,    86,
    2182,  2183,   275,  1495,  2186,   397,  4095,  3369,   401,   339,
    3029,  1937,  4655,   508,  4186,  4985,   391,   426,   209,  2296,
    2202,  2203,  2204,   454,   434,   287,  2208,  2647,   219,  2987,
    2212,  3602,   229,  1525,  2216,   438,  2218,  2219,  2220,  2221,
    2222,  2223,  2224,  2225,  2226,  4092,  2228,  1539,  3137,  2413,
      71,  2415,  2234,  3107,  3108,  2237,   172,   339,    79,    80,
     257,   440,   324,  3980,  4685,   474,   475,   368,   314,  3965,
     511,   450,   156,  3137,   515,   272,  2294,   438,  1808,   503,
    3504,  1811,   392,    71,   508,   317,   510,   284,   339,  2408,
     372,    79,    80,   394,   376,  3053,   426,   365,   428,   508,
     501,   502,   503,  2462,    75,    76,    77,    78,    96,   193,
     307,    82,  2294,    75,    76,    77,    78,  2299,   507,   401,
      82,   372,   511,   424,     2,   376,  1856,   395,   326,   326,
    1860,  2313,  2350,   331,  2352,    85,   508,   253,    88,   475,
    2322,  2323,   323,  1635,  1636,   326,  1638,   207,   394,  2341,
     401,   509,  3726,  3727,   512,   105,   424,   509,   494,   219,
     512,   462,  1224,   223,   152,  2322,  2323,   427,  2350,   429,
    2352,   219,   508,   474,  1236,   223,  1238,   391,   424,   489,
     374,  2204,   298,  2403,   300,   382,    75,    76,    77,    78,
    2372,  3769,   474,    82,   511,   251,   326,    86,   515,  3253,
     468,   331,  2822,   297,   427,   265,   429,   508,  2390,  3508,
    2392,  2368,   389,   157,   202,   389,   462,  2399,   180,   507,
     513,  2403,  2404,   511,  2543,  2407,   297,   287,   474,   126,
      85,  2388,  3393,  2390,    72,  2392,   313,   314,   243,   287,
    4017,  4018,  4019,  1609,  2383,  2184,   503,  2429,  2187,   426,
    2432,   508,   426,   510,   438,   509,   632,   511,   389,   456,
     248,  2443,   508,   509,   324,   253,   512,   506,  2450,   508,
    3665,  2294,   332,   134,   135,   172,   324,   426,  2204,   103,
     104,  3370,  2909,  3372,  2911,  2912,  3632,   150,  2470,   167,
     509,   180,   511,   468,  1609,   426,  1662,   474,   475,  2481,
     474,   475,   391,  2523,   275,  2487,  3370,   125,  3372,   187,
    2492,  2493,  4325,   514,  4327,  2497,  2498,   394,  4331,   269,
    4333,   509,  2504,   511,  3343,   474,   475,  2350,   275,  2352,
    3384,   508,  3386,    86,   508,  3571,   160,  3356,  2520,  2521,
     508,  2523,   510,   474,   475,   326,  3435,   424,   511,   512,
    3635,  3636,   509,   250,   511,   179,   344,   389,   207,   508,
     508,  1727,  2544,   508,  2546,  2547,   125,   508,  2550,   510,
     219,  3435,   474,   475,   223,    71,    72,   508,   328,   511,
    2403,  4145,   468,    79,    80,   462,  2568,   211,   448,  4628,
      86,  2678,   385,   386,   426,   383,  2578,   474,  2555,   115,
     389,   298,    85,   300,   271,    88,  2563,   510,  2565,  2591,
     389,   491,  1727,   310,  4178,   329,   265,    71,    72,  2601,
    2602,    75,    76,    77,    78,    79,    80,    81,    82,   329,
     113,   508,    86,   509,   422,   511,   119,   426,   287,   326,
    4529,   338,   474,   475,  2664,  3499,   506,   426,   434,   509,
     510,    85,   223,  2996,    88,    75,    76,    77,    78,   447,
     143,   329,    82,  2645,   506,  2647,   508,   455,   510,  3860,
     458,   105,   511,   512,   389,   324,   508,  2403,   326,   509,
     377,   511,  2664,   332,   491,   474,   475,   389,  2670,   115,
     509,   389,   511,  2675,   491,   474,   475,  2520,   271,   875,
    2523,    75,    76,    77,    78,   385,   386,  4424,    82,  4286,
    4287,   426,  4289,   474,   475,   412,  2941,   492,   493,   508,
    3140,  3479,   205,   227,   426,  2707,   180,   501,   426,   508,
     125,   509,  4103,   511,    75,    76,    77,    78,   385,   386,
    2722,    82,   511,  2725,   368,   495,   496,   497,   508,   499,
     500,   501,   502,   503,   504,  2481,   932,   933,   509,   474,
     475,   244,  2054,   385,   386,   248,  4446,  4447,  4448,  4449,
     394,  1937,   474,   475,   509,  3989,   474,   475,   474,   475,
    2762,   499,   500,   501,   502,   503,   269,   270,  2770,   507,
     509,   967,   511,   508,  2520,   228,   509,  2523,   511,   448,
     424,   267,   509,   286,   511,   514,   508,  2981,  2982,  2983,
     508,   512,   266,    75,    76,    77,    78,   509,  2544,   511,
      82,  3241,  1937,  3243,  2116,   509,   501,   511,  2810,  1455,
    1456,  3056,   315,   514,   263,   269,   290,   434,   462,   180,
    2822,  2664,   466,   434,   509,   328,   511,  2804,  2787,  1025,
     474,   509,  2834,   511,   434,   434,  2838,   499,   500,   501,
     502,   503,  2844,    85,  3622,  3623,    88,   509,    75,    76,
      77,    78,   509,   508,   511,    82,   434,  3297,  1054,  2861,
    2862,   203,   108,   105,   508,  2867,   509,  1063,   511,   125,
     263,  1067,  1068,  1069,   328,   434,   508,  2917,    98,   509,
     401,   511,  3322,  2923,   269,    75,    76,    77,    78,   510,
    289