% SuiteSparseCollection: software for managing the SuiteSparse Matrix Collection
%
% To create the index:
%
%   ssindex    - create the index for the SuiteSparse Matrix Collection
%   ssstats    - compute matrix statistics for the SuiteSparse Matrix Collection
%
% To create the web pages:
%
%   ssgplot    - draw a plot of the graph of a sparse matrix
%   ssint      - print an integer to a string, adding commas every 3 digits
%   sslocation - local top-level directory of the SuiteSparse Matrix Collection
%   sspage     - create images for a matrix in SuiteSparse Matrix Collection
%   sspages    - create images for each matrix in SuiteSparse Matrix Collection
%   dsxy2figxy - Transform point or position from axis to figure coords
%
% To create the Matrix Market and Rutherford/Boeing versions of the collection:
%
%   ssexport     - export to Matrix Market and Rutherford/Boeing formats
%   ssread       - read a Problem in Matrix Market or Rutherford/Boeing format
%   sswrite      - write a Problem in Matrix Market or Rutherford/Boeing format
%   ssfull_read  - read a full matrix using a subset of Matrix Market format
%   ssfull_write - write a full matrix using a subset of Matrix Market format
%
% Other:
%
%   ss_install   - install the SuiteSparseCollection toolbox
%
% Requires ssget, CSparse, CHOLMOD, AMD, COLAMD, METIS.

% Copyright 2006-2019, Timothy A. Davis

