/*
 * Copyright (C) 2021 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include "CSSNumericValue.h"

namespace WebCore {

class CSSNumericArray : public RefCounted<CSSNumericArray> {
    WTF_MAKE_TZONE_OR_ISO_ALLOCATED(CSSNumericArray);
public:
    static Ref<CSSNumericArray> create(FixedVector<CSSNumberish>&&);
    static Ref<CSSNumericArray> create(Vector<Ref<CSSNumericValue>>&&);
    size_t length() const { return m_array.size(); };
    RefPtr<CSSNumericValue> item(size_t index);
    bool isSupportedPropertyIndex(unsigned index) const { return index < m_array.size(); }
    const Vector<Ref<CSSNumericValue>>& array() const { return m_array; }
    void forEach(Function<void(const CSSNumericValue&, bool first)>);

private:
    Vector<Ref<CSSNumericValue>> m_array;
    CSSNumericArray(Vector<Ref<CSSNumericValue>>&&);
};

} // namespace WebCore
