#!/bin/sh 

#	debug options are -vx
# If a two arguments are passed to the shell it should be a blocks database
# and a valid block name in the database
# It will be placed in the DB_query_block text box. 
# If only one argument is passed to the shell it should be a name of a file
# with correctly formatted block(s). The content of the file will be read into
# the User_query_block text area.
# 3/97 Pass name of blocks database (don't assume blocks.dat)

#	limit core dump size
ulimit -c 0
#	limit execution time to 1 hour = 3600 secs
#ulimit -t 3600

blocks=blocks

#	Get the query
query=""
#	$1 is always a file name, make sure it exists
if [ $# -gt 0 -a -f "$1" -a -r "$1" ]
then
   if [ $# -gt 1 ]
   then
     # There is a block number given
     query=`./blimps-bin/retblock $1 $2 -n`
   else
     # there is no block number given
       query=`cat $1`
    fi
fi

#####
##
##  Common HTML text
##
#####

cat << EOM
Content-type: text/html

<TITLE>LAMA Search</TITLE>
<H1><A HREF="/$blocks/help/LAMA/LAMA_YWK.html">
<IMG ALIGN=MIDDLE SRC="/$blocks/help/LAMA/llama.2.gif"></A>
Block vs Block Searcher using LAMA</H1>
<H3>(Local Alignment of Multiple Alignments) 
<A HREF="/$blocks/help/LAMA_help.html">?</A></H3>
<P>at the 
<A HREF="http://www.fhcrc.org/">Fred Hutchinson Cancer Research Center</A> Blocks WWW server.
<HR>
Search a block against a
<A HREF="/$blocks/help/about_blocks.html">database of blocks</A>
or compare pairs of blocks.

<FORM METHOD="POST" ACTION="/${blocks}-bin/LAMA_search">

<P>
A typical LAMA search against the Blocks or Prints Database will
take 15-20 minutes or more, depending on the number of query blocks.
If you choose not to receive the results via email,
please be patient.
<P>
Enter your email address if you want the results through email:<P>
<INPUT SIZE=50 NAME="address"><P>

<HR>
After filling in the rest of the form below you can 
<INPUT TYPE=submit VALUE="Perform the Search">. 
<INPUT TYPE=reset VALUE="Reset & Clear"> form.
<HR>

EOM

#####
##
##  User specified target data section
##
#####

if [ "$0" = "`pwd`/LAMA_search_userdb.sh" ]
then
#####
##  User target data HTML text
#####

  # This is the script that the user uses to input their own target data

  cat << EOM
<STRONG>Additional options</STRONG><BR>
<A HREF="/$blocks/help/LAMA_help.html#OUTPUT">Output Level</A>
<SELECT NAME="debug_level">
<OPTION SELECTED VALUE="0">Standard (default)
<OPTION VALUE="3"> and column contributions
<OPTION VALUE="6"> and block matrices
</SELECT>
<BR>
<A HREF="/$blocks/help/LAMA_help.html#CUTOFF">Score Cutoff Level</A>
(0 = default) <INPUT NAME="score_cutoff_level" SIZE=3 VALUE="0"></INPUT>
<HR>

Enter block(s) target data (use the 
<A HREF="/$blocks/blocks_format.html">BLOCK format</A>; 
reformat multiple sequence alignments 
<A HREF="/$blocks/process_blocks.html">here</A>)<BR>
or search the available <A HREF="LAMA_search.sh?$1+$2">databases of blocks</A>:
<BR>
<TEXTAREA NAME="User_target_block" ROWS=20 COLS=70></TEXTAREA>

<HR>
<INPUT NAME = "database" VALUE = "no-db" TYPE=hidden CHECKED>
EOM

else
#####
##  Database as target data HTML text
#####
  # This is the script that the user uses to use the given databases

cat << EOM

Select the database to search:<BR>
<A HREF="/$blocks/help/about_blocks.html#blocks">Blocks Database</A>
<INPUT NAME="database" VALUE="blplus-db" TYPE=radio CHECKED>  or
<A HREF="/$blocks/help/about_blocks.html#prints">Prints Database</A>
<INPUT NAME = "database" VALUE = "prints-db" TYPE=radio>
or Supply your own target data 
<A HREF="LAMA_search_userdb.sh?$1+$2"><STRONG>O</STRONG></A>.
<P>

EOM

fi




#####
##
##  Common HTML text
##
#####

cat << EOM

Enter block(s) query (use the  
<A HREF="/$blocks/blocks_format.html">BLOCK format</A>; 
reformat multiple sequence alignments 
<A HREF="/$blocks/block_formatter.html">here</A>):
<BR>
<TEXTAREA NAME="User_query_block" ROWS=20 COLS=70>$query</TEXTAREA>

<HR>

<INPUT TYPE=submit VALUE="Perform Search">
<INPUT TYPE=reset VALUE="Reset & Clear">
<P>
A search may take 15-20 minutes: Please be patient.
<HR>
</FORM>

<p>


<A HREF="/$blocks/help/LAMA_help.html">LAMA Searcher Help</A>
<P>
<A HREF="/blocks">[Blocks Home]</A> 
<A HREF="/blocks/blocks_search.html">[Block Searcher]</A>
<A HREF="/blocks/make_blocks.html">[Block Maker]</A>
<A HREF="/blocks-bin/getblock.sh">[Get Blocks]</A>
<BR>
<A HREF="/blocks/process_blocks.html">[Multiple Alignment Processor]</A>
<A HREF="/blocks/biassed_blocks.html">[Biassed Block Checker]</A>

<HR>
Page last modified <MODIFICATION_DATE>Jan 1999</MODIFICATION_DATE>
<Address>
<A HREF="/~pietro">Shmuel Pietrokovski</A>
</Address>

EOM
