/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module;

import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.AgentType;
import edu.harvard.hul.ois.jhove.ByteArrayXMPSource;
import edu.harvard.hul.ois.jhove.Checksum;
import edu.harvard.hul.ois.jhove.ChecksumInputStream;
import edu.harvard.hul.ois.jhove.ChecksumType;
import edu.harvard.hul.ois.jhove.Checksummer;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.DocumentType;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ExternalSignature;
import edu.harvard.hul.ois.jhove.Identifier;
import edu.harvard.hul.ois.jhove.IdentifierType;
import edu.harvard.hul.ois.jhove.InternalSignature;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.Signature;
import edu.harvard.hul.ois.jhove.SignatureType;
import edu.harvard.hul.ois.jhove.SignatureUseType;
import edu.harvard.hul.ois.jhove.XMPHandler;
import edu.harvard.hul.ois.jhove.module.gif.GifStrings;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class GifModule
extends ModuleBase {
    private static final boolean debug_appIdentCaseInsens = false;
    private static final String NAME = "GIF-hul";
    private static final String RELEASE = "1.3";
    private static final int[] DATE = new int[]{2006, 9, 5};
    private static final String[] FORMAT = new String[]{"GIF", "Graphics Interchange Format"};
    private static final String COVERAGE = "GIF87a, GIF89a";
    private static final String[] MIMETYPE = new String[]{"image/gif"};
    private static final String WELLFORMED = "A GIF file is well-formed if it has a header block; a sequence of properly formed control, graphic-rendering, and special purpose blocks; and a trailer block";
    private static final String VALIDITY = "A GIF file is valid if well-formed, has at most one global color map, and at most one graphic control extension preceding an image descriptor or a plain text extension";
    private static final String REPINFO = "Additional representation information includes: NISO Z39.87 Digital Still Image Technical Metadata, and block-specific metadata";
    private static final String NOTE = "'GIF' and 'Graphics Interchange Format' are trademarks of Compuserve Interactive Services Inc.";
    private static final String RIGHTS = "Copyright 2003-2007 by JSTOR and the President and Fellows of Harvard College. Released under the GNU Lesser General Public License.";
    private static final int EXT_BLOCK = 33;
    private static final int APPLICATION_EXT = 255;
    private static final int COMMENT_EXT = 254;
    private static final int GRAPHIC_CONTROL_EXT = 249;
    private static final int IMAGE_DESC = 44;
    private static final int PLAIN_TEXT_EXT = 1;
    private static final int TRAILER = 59;
    protected byte[] _sig;
    protected Checksummer _ckSummer;
    protected Property _xmpProp;
    protected ChecksumInputStream _cstream;
    protected DataInputStream _dstream;
    protected boolean _globalColorTableFlag;
    protected int _globalColorTableSize;
    protected int _gceCounter;
    protected Property _metadata;
    protected List _blocksList;
    protected int _numGraphicBlocks;

    public GifModule() {
        super(NAME, RELEASE, DATE, FORMAT, COVERAGE, MIMETYPE, WELLFORMED, VALIDITY, REPINFO, NOTE, RIGHTS, false);
        Agent agent = new Agent("Harvard University Library", AgentType.EDUCATIONAL);
        agent.setAddress("Office for Information Systems, 90 Mt. Auburn St., Cambridge, MA 02138");
        agent.setTelephone("+1 (617) 495-3724");
        agent.setEmail("jhove-support@hulmail.harvard.edu");
        this._vendor = agent;
        Document document = new Document("GIF (Graphics Interchange Format): A standard defining a mechanism for the storage and transmission of raster-based graphics information", DocumentType.REPORT);
        agent = new Agent("Compuserve Interactive Services Inc.", AgentType.COMMERCIAL);
        agent.setAddress("5000 Arlington Centre Blvd., Columbus, OS 43220");
        agent.setTelephone("(614) 457-8600");
        agent.setWeb("http://www.compuserve.com/");
        document.setAuthor(agent);
        document.setDate("1987-06-15");
        document.setIdentifier(new Identifier("http://www.w3.org/Graphics/GIF/spec-gif87.txt", IdentifierType.URL));
        this._specification.add(document);
        document = new Document("Graphics Interchange Format", DocumentType.REPORT);
        document.setEdition("Version 89a");
        document.setAuthor(agent);
        document.setDate("1987-06-15");
        document.setIdentifier(new Identifier("http://www.w3.org/Graphics/GIF/spec-gif89a.txt", IdentifierType.URL));
        this._specification.add(document);
        Signature signature = new InternalSignature("GIF", SignatureType.MAGIC, SignatureUseType.MANDATORY, 0);
        this._signature.add(signature);
        signature = new InternalSignature("87a", SignatureType.MAGIC, SignatureUseType.MANDATORY_IF_APPLICABLE, 3, "For version 87a");
        this._signature.add(signature);
        signature = new InternalSignature("89a", SignatureType.MAGIC, SignatureUseType.MANDATORY_IF_APPLICABLE, 3, "For version 89a");
        this._signature.add(signature);
        signature = new ExternalSignature(".gif", SignatureType.EXTENSION, SignatureUseType.OPTIONAL);
        this._signature.add(signature);
        this._bigEndian = false;
    }

    @Override
    public void checkSignatures(File file, InputStream inputStream, RepInfo repInfo) throws IOException {
        int[] nArray = new int[]{71, 73, 70, 56, 42, 97};
        try {
            int n;
            this._dstream = null;
            this._dstream = GifModule.getBufferedDataStream(inputStream, this._je != null ? this._je.getBufferSize() : 0);
            for (int i = 0; i < 4; ++i) {
                n = GifModule.readUnsignedByte(this._dstream, this);
                if (n == nArray[i]) continue;
                repInfo.setWellFormed(false);
                return;
            }
            n = GifModule.readUnsignedByte(this._dstream, this);
            if (n != 55 && n != 57) {
                repInfo.setWellFormed(false);
                return;
            }
            n = GifModule.readUnsignedByte(this._dstream, this);
            if (n != nArray[5]) {
                repInfo.setWellFormed(false);
                return;
            }
            repInfo.setModule(this);
            repInfo.setFormat(this._format[0]);
            repInfo.setMimeType(this._mimeType[0]);
            repInfo.setSigMatch(this._name);
        }
        catch (Exception exception) {
            repInfo.setWellFormed(false);
            return;
        }
    }

    @Override
    public int parse(InputStream inputStream, RepInfo repInfo, int n) throws IOException {
        Object object;
        this.initParse();
        repInfo.setModule(this);
        repInfo.setFormat(this._format[0]);
        repInfo.setMimeType(this._mimeType[0]);
        this._blocksList = new LinkedList();
        Property property = new Property("Blocks", PropertyType.PROPERTY, PropertyArity.LIST, this._blocksList);
        this._ckSummer = null;
        if (this._app != null && this._je.getChecksumFlag() && repInfo.getChecksum().size() == 0) {
            this._ckSummer = new Checksummer();
            this._cstream = new ChecksumInputStream(inputStream, this._ckSummer);
            this._dstream = GifModule.getBufferedDataStream(this._cstream, this._app != null ? this._je.getBufferSize() : 0);
        } else {
            this._dstream = GifModule.getBufferedDataStream(inputStream, this._app != null ? this._je.getBufferSize() : 0);
        }
        if (!this.readSig(repInfo)) {
            return 0;
        }
        repInfo.setSigMatch(this._name);
        if (!this.readLSD(repInfo)) {
            return 0;
        }
        boolean bl = true;
        while (bl) {
            bl = this.readBlock(repInfo);
            if (repInfo.getWellFormed() != 0) continue;
            return 0;
        }
        if (this._ckSummer != null) {
            try {
                int n2;
                while ((n2 = this.skipBytes(this._dstream, 2048, this)) != 0) {
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            repInfo.setSize(this._cstream.getNBytes());
            repInfo.setChecksum(new Checksum(this._ckSummer.getCRC32(), ChecksumType.CRC32));
            object = this._ckSummer.getMD5();
            if (object != null) {
                repInfo.setChecksum(new Checksum((String)object, ChecksumType.MD5));
            }
            if ((object = this._ckSummer.getSHA1()) != null) {
                repInfo.setChecksum(new Checksum((String)object, ChecksumType.SHA1));
            }
        }
        object = this._xmpProp != null ? new Property[3] : new Property[2];
        this._metadata = new Property("GIFMetadata", PropertyType.PROPERTY, PropertyArity.ARRAY, object);
        object[1] = property;
        object[0] = new Property("GraphicRenderingBlocks", PropertyType.INTEGER, new Integer(this._numGraphicBlocks));
        if (this._xmpProp != null) {
            object[2] = this._xmpProp;
        }
        repInfo.setProperty(this._metadata);
        return 0;
    }

    @Override
    protected void initParse() {
        super.initParse();
        this._sig = new byte[6];
        this._globalColorTableFlag = false;
        this._globalColorTableSize = 0;
        this._gceCounter = 0;
        this._numGraphicBlocks = 0;
    }

    protected boolean readSig(RepInfo repInfo) throws IOException {
        boolean bl = false;
        String string = "Invalid GIF header";
        for (int i = 0; i < 6; ++i) {
            try {
                int n = GifModule.readUnsignedByte(this._dstream, this);
                if (i >= 6) continue;
                this._sig[i] = (byte)n;
                continue;
            }
            catch (EOFException eOFException) {
                bl = true;
                repInfo.setMessage(new ErrorMessage(string, 0L));
                repInfo.setWellFormed(0);
                return false;
            }
        }
        String string2 = new String(this._sig);
        if ("GIF89a".equals(string2)) {
            repInfo.setVersion("89a");
            repInfo.setProfile("GIF 89a");
        } else if ("GIF87a".equals(string2)) {
            repInfo.setVersion("87a");
            repInfo.setProfile("GIF 87a");
        } else {
            repInfo.setMessage(new ErrorMessage(string, 0L));
            repInfo.setWellFormed(0);
            return false;
        }
        return true;
    }

    protected boolean readLSD(RepInfo repInfo) throws IOException {
        Vector<Property> vector = new Vector<Property>(8);
        int n = this.readUnsignedShort(this._dstream);
        vector.add(new Property("LogicalScreenWidth", PropertyType.INTEGER, new Integer(n)));
        int n2 = this.readUnsignedShort(this._dstream);
        vector.add(new Property("LogicalScreenHeight", PropertyType.INTEGER, new Integer(n2)));
        int n3 = GifModule.readUnsignedByte(this._dstream, this);
        this._globalColorTableFlag = (n3 & 0x80) != 0;
        int n4 = ((n3 & 0x70) >> 4) + 1;
        vector.add(new Property("ColorResolution", PropertyType.INTEGER, new Integer(n4)));
        boolean bl = (n3 & 8) != 0;
        int n5 = n3 & 7;
        if (this._globalColorTableFlag) {
            this._globalColorTableSize = 3 * (1 << n5 + 1);
        }
        int n6 = GifModule.readUnsignedByte(this._dstream, this);
        vector.add(new Property("BackgroundColorIndex", PropertyType.INTEGER, new Integer(n6)));
        int n7 = GifModule.readUnsignedByte(this._dstream, this);
        vector.add(new Property("PixelAspectRatio", PropertyType.SHORT, new Short((short)n7)));
        vector.add(this.addByteProperty("GlobalColorTableFlag", this._globalColorTableFlag ? 1 : 0, GifStrings.GLOBAL_COLOR_TABLE_FLAG));
        vector.add(this.addByteProperty("GlobalColorTableSortFlag", bl ? 1 : 0, GifStrings.COLOR_TABLE_SORT_FLAG));
        vector.add(new Property("GlobalColorTableSize", PropertyType.SHORT, new Short((short)n5)));
        Property property = new Property("LogicalScreenDescriptor", PropertyType.PROPERTY, PropertyArity.ARRAY, this.vectorToPropArray(vector));
        this._blocksList.add(property);
        if (this._globalColorTableFlag) {
            short[] sArray = new short[this._globalColorTableSize];
            for (int i = 0; i < this._globalColorTableSize; ++i) {
                sArray[i] = (short)this._dstream.readUnsignedByte();
            }
            this._blocksList.add(new Property("GlobalColorTable", PropertyType.SHORT, PropertyArity.ARRAY, sArray));
        }
        return true;
    }

    protected boolean readBlock(RepInfo repInfo) throws IOException {
        int n;
        try {
            n = GifModule.readUnsignedByte(this._dstream, this);
        }
        catch (EOFException eOFException) {
            repInfo.setWellFormed(0);
            repInfo.setMessage(new ErrorMessage("End of file reached without encountering Trailer block", this._nByte));
            return false;
        }
        try {
            switch (n) {
                case 33: {
                    return this.readExtBlock(repInfo);
                }
                case 44: {
                    return this.readImage(repInfo);
                }
                case 59: {
                    return false;
                }
            }
            repInfo.setWellFormed(0);
            repInfo.setMessage(new ErrorMessage("Unknown data block type", "Type = " + n, this._nByte));
            return false;
        }
        catch (EOFException eOFException) {
            repInfo.setWellFormed(0);
            repInfo.setMessage(new ErrorMessage("Unexpected end of file", this._nByte));
            return false;
        }
    }

    protected boolean readExtBlock(RepInfo repInfo) throws IOException {
        int n = GifModule.readUnsignedByte(this._dstream, this);
        switch (n) {
            case 255: {
                return this.readAppExtension(repInfo);
            }
            case 254: {
                return this.readCommentExtension(repInfo);
            }
            case 249: {
                return this.readGraphicsCtlBlock(repInfo);
            }
            case 1: {
                return this.readPlainTextExtension(repInfo);
            }
        }
        repInfo.setWellFormed(0);
        repInfo.setMessage(new ErrorMessage("Unknown extension block type", "Type = " + n, this._nByte));
        return false;
    }

    protected boolean readImage(RepInfo repInfo) throws IOException {
        int n;
        ++this._numGraphicBlocks;
        Vector<Property> vector = new Vector<Property>(7);
        NisoImageMetadata nisoImageMetadata = new NisoImageMetadata();
        Property property = new Property("NisoImageMetadata", PropertyType.NISOIMAGEMETADATA, nisoImageMetadata);
        nisoImageMetadata.setMimeType("image/gif");
        nisoImageMetadata.setByteOrder("little-endian");
        nisoImageMetadata.setCompressionScheme(5);
        nisoImageMetadata.setColorSpace(3);
        nisoImageMetadata.setOrientation(1);
        nisoImageMetadata.setBitsPerSample(new int[]{8});
        this._gceCounter = 0;
        int n2 = this.readUnsignedShort(this._dstream);
        vector.add(new Property("ImageLeftPosition", PropertyType.INTEGER, new Integer(n2)));
        int n3 = this.readUnsignedShort(this._dstream);
        vector.add(new Property("ImageTopPosition", PropertyType.INTEGER, new Integer(n3)));
        int n4 = this.readUnsignedShort(this._dstream);
        nisoImageMetadata.setImageWidth(n4);
        int n5 = this.readUnsignedShort(this._dstream);
        nisoImageMetadata.setImageLength(n5);
        int n6 = GifModule.readUnsignedByte(this._dstream, this);
        int n7 = (n6 & 0x40) >> 6;
        vector.add(this.addByteProperty("InterlaceFlag", n7, GifStrings.INTERLACE_FLAG));
        int n8 = (n6 & 0x80) >> 7;
        vector.add(this.addByteProperty("LocalColorTableFlag", n8, GifStrings.LOCAL_COLOR_TABLE_FLAG));
        int n9 = (n6 & 0x20) >> 5;
        vector.add(this.addByteProperty("LocalColorTableSortFlag", n9, GifStrings.COLOR_TABLE_SORT_FLAG));
        int n10 = 0;
        int n11 = n6 & 7;
        vector.add(new Property("LocalColorTableSize", PropertyType.SHORT, new Short((short)n11)));
        vector.add(property);
        if (n8 != 0) {
            n10 = 3 * (1 << n11 + 1);
            this.skipBytes(this._dstream, n10, this);
        }
        Property property2 = new Property("ImageDescriptor", PropertyType.PROPERTY, PropertyArity.ARRAY, this.vectorToPropArray(vector));
        this._blocksList.add(property2);
        int n12 = GifModule.readUnsignedByte(this._dstream, this);
        while ((n = GifModule.readUnsignedByte(this._dstream, this)) != 0) {
            this.skipBytes(this._dstream, n, this);
        }
        return true;
    }

    protected boolean readAppExtension(RepInfo repInfo) throws IOException {
        int n;
        int n2 = GifModule.readUnsignedByte(this._dstream, this);
        if (n2 != 11) {
            repInfo.setMessage(new ErrorMessage("Wrong application extension block size", this._nByte));
            repInfo.setWellFormed(0);
            return false;
        }
        Vector<Property> vector = new Vector<Property>(3);
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < 8; ++n) {
            stringBuffer.append((char)GifModule.readUnsignedByte(this._dstream, this));
        }
        vector.add(new Property("ApplicationIdentifier", PropertyType.STRING, stringBuffer.toString()));
        short[] sArray = new short[3];
        for (n = 0; n < 3; ++n) {
            sArray[n] = (short)GifModule.readUnsignedByte(this._dstream, this);
        }
        vector.add(new Property("ApplicationAuthenticationCode", PropertyType.SHORT, PropertyArity.ARRAY, sArray));
        int n3 = 0;
        if (stringBuffer.toString().equals("XMP Data") && sArray[0] == 88 && sArray[1] == 77 && sArray[2] == 80) {
            n3 = this.readXMP();
        } else {
            while (true) {
                int n4 = GifModule.readUnsignedByte(this._dstream, this);
                n3 += n4 + 1;
                if (n4 == 0) break;
                this.skipBytes(this._dstream, n4, this);
            }
        }
        vector.add(new Property("ApplicationDataSize", PropertyType.INTEGER, new Integer(n3)));
        Property property = new Property("ApplicationExtension", PropertyType.PROPERTY, PropertyArity.ARRAY, this.vectorToPropArray(vector));
        this._blocksList.add(property);
        return true;
    }

    protected boolean readCommentExtension(RepInfo repInfo) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = GifModule.readUnsignedByte(this._dstream, this)) != 0) {
            for (int i = 0; i < n; ++i) {
                int n2 = GifModule.readUnsignedByte(this._dstream, this);
                if (n2 == 0) continue;
                stringBuffer.append((char)n2);
            }
        }
        Property property = new Property("CommentExtension", PropertyType.STRING, stringBuffer.toString());
        return true;
    }

    protected boolean readPlainTextExtension(RepInfo repInfo) throws IOException {
        int n;
        ++this._numGraphicBlocks;
        this._gceCounter = 0;
        int n2 = GifModule.readUnsignedByte(this._dstream, this);
        if (n2 != 12) {
            repInfo.setMessage(new ErrorMessage("Wrong plain text extension block size", this._nByte));
            repInfo.setWellFormed(0);
            return false;
        }
        if (!this._globalColorTableFlag) {
            repInfo.setMessage(new ErrorMessage("Plain text extension requires global color table", this._nByte));
            repInfo.setValid(false);
        }
        Vector<Property> vector = new Vector<Property>(9);
        int n3 = this.readUnsignedShort(this._dstream);
        vector.add(new Property("TextGridLeftPosition", PropertyType.INTEGER, new Integer(n3)));
        int n4 = this.readUnsignedShort(this._dstream);
        vector.add(new Property("TextGridTopPosition", PropertyType.INTEGER, new Integer(n4)));
        int n5 = this.readUnsignedShort(this._dstream);
        vector.add(new Property("TextGridWidth", PropertyType.INTEGER, new Integer(n5)));
        int n6 = this.readUnsignedShort(this._dstream);
        vector.add(new Property("TextGridHeight", PropertyType.INTEGER, new Integer(n6)));
        int n7 = GifModule.readUnsignedByte(this._dstream, this);
        vector.add(new Property("CharacterCellWidth", PropertyType.SHORT, new Short((short)n7)));
        int n8 = GifModule.readUnsignedByte(this._dstream, this);
        vector.add(new Property("CharacterCellHeight", PropertyType.SHORT, new Short((short)n8)));
        int n9 = GifModule.readUnsignedByte(this._dstream, this);
        vector.add(new Property("TextForegroundColorIndex", PropertyType.SHORT, new Short((short)n9)));
        int n10 = GifModule.readUnsignedByte(this._dstream, this);
        vector.add(new Property("TextBackgroundColorIndex", PropertyType.SHORT, new Short((short)n10)));
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = GifModule.readUnsignedByte(this._dstream, this)) != 0) {
            for (int i = 0; i < n; ++i) {
                int n11 = GifModule.readUnsignedByte(this._dstream, this);
                if (n11 >= 32 || n11 <= 247) {
                    stringBuffer.append((char)n11);
                    continue;
                }
                stringBuffer.append(' ');
            }
        }
        vector.add(new Property("PlainTextData", PropertyType.STRING, stringBuffer.toString()));
        Property property = new Property("PlainTextExtension", PropertyType.PROPERTY, PropertyArity.ARRAY, this.vectorToPropArray(vector));
        this._blocksList.add(property);
        return true;
    }

    protected boolean readGraphicsCtlBlock(RepInfo repInfo) throws IOException {
        int n;
        Vector<Property> vector = new Vector<Property>(5);
        if (++this._gceCounter > 1) {
            repInfo.setMessage(new ErrorMessage("Multiple graphics control blocks for one image", this._nByte));
            repInfo.setWellFormed(0);
        }
        if ((n = GifModule.readUnsignedByte(this._dstream, this)) != 4) {
            repInfo.setMessage(new ErrorMessage("Wrong graphics control block size", this._nByte));
            repInfo.setWellFormed(0);
            return false;
        }
        int n2 = GifModule.readUnsignedByte(this._dstream, this);
        int n3 = (n2 & 0x1C) >> 3;
        vector.add(this.addByteProperty("DisposalMethod", n3, GifStrings.GCE_DISPOSAL_METHOD));
        int n4 = (n2 & 2) >> 1;
        vector.add(this.addByteProperty("UserInputFlag", n4, GifStrings.GCE_USER_INPUT_FLAG));
        int n5 = n2 & 1;
        vector.add(this.addByteProperty("TransparencyFlag", n5, GifStrings.GCE_TRANSPARENCY_FLAG));
        int n6 = this.readUnsignedShort(this._dstream);
        vector.add(new Property("DelayTime", PropertyType.INTEGER, new Integer(n6)));
        int n7 = GifModule.readUnsignedByte(this._dstream, this);
        vector.add(new Property("TransparentColorIndex", PropertyType.SHORT, new Short((short)n7)));
        GifModule.readUnsignedByte(this._dstream, this);
        Property property = new Property("GraphicControlExtension", PropertyType.PROPERTY, PropertyArity.ARRAY, this.vectorToPropArray(vector));
        this._blocksList.add(property);
        return true;
    }

    protected int readXMP() throws IOException {
        int n;
        int n2;
        LinkedList<byte[]> linkedList = new LinkedList<byte[]>();
        byte[] byArray = new byte[4096];
        int n3 = 0;
        while (true) {
            if ((n2 = GifModule.readUnsignedByte(this._dstream, this)) == 0) break;
            if (n3 == 4096) {
                linkedList.add(byArray);
                byArray = new byte[4096];
                n3 = 0;
            }
            byArray[n3++] = (byte)n2;
        }
        GifModule.readUnsignedByte(this._dstream, this);
        n2 = linkedList.size() * 4096 + n3 + 2;
        int n4 = n2 - 258;
        byte[] byArray2 = new byte[n4];
        int n5 = 0;
        ListIterator listIterator = linkedList.listIterator();
        block7: while (listIterator.hasNext()) {
            byte[] byArray3 = (byte[])listIterator.next();
            for (n = 0; n < 4096; ++n) {
                byArray2[n5++] = byArray3[n];
                if (n5 >= n4) break block7;
            }
        }
        for (n = 0; n < n3 && n5 < n4; ++n) {
            byArray2[n5++] = byArray[n];
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            ByteArrayXMPSource byteArrayXMPSource = new ByteArrayXMPSource(byteArrayInputStream, "UTF-8");
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
            XMPHandler xMPHandler = new XMPHandler();
            xMLReader.setContentHandler(xMPHandler);
            xMLReader.setErrorHandler(xMPHandler);
            try {
                xMLReader.parse(byteArrayXMPSource);
                this._xmpProp = byteArrayXMPSource.makeProperty();
                return n2;
            }
            catch (SAXException sAXException) {
                String string = sAXException.getMessage();
                if (string != null && string.startsWith("ENC=")) {
                    String string2 = string.substring(5);
                    try {
                        byteArrayXMPSource = new ByteArrayXMPSource(byteArrayInputStream, string2);
                        xMLReader.parse(byteArrayXMPSource);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        return n2;
                    }
                }
                this._xmpProp = byteArrayXMPSource.makeProperty();
                return n2;
            }
        }
        catch (Exception exception) {
            return n2;
        }
    }

    protected Property addByteProperty(String string, int n, String[] stringArray) {
        if (!this._je.getShowRawFlag()) {
            try {
                return new Property(string, PropertyType.STRING, stringArray[n]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new Property(string, PropertyType.BYTE, new Byte((byte)n));
    }

    protected int readUnsignedShort(DataInputStream dataInputStream) throws IOException {
        return GifModule.readUnsignedShort(dataInputStream, false, this);
    }
}

