/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.viewer;

import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.Identifier;
import edu.harvard.hul.ois.jhove.InternalSignature;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.OutputHandler;
import edu.harvard.hul.ois.jhove.Signature;
import edu.harvard.hul.ois.jhove.SignatureType;
import edu.harvard.hul.ois.jhove.viewer.InfoWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ModuleInfoWindow
extends InfoWindow {
    private JTextArea texta;
    private int _level;
    private Module _module;

    public ModuleInfoWindow(App app, JhoveBase jhoveBase, Module module) {
        super("Module Info", app, jhoveBase);
        this._module = module;
        this.setSaveActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModuleInfoWindow.this.saveInfo();
            }
        });
        this.texta = new JTextArea();
        this.texta.setColumns(72);
        JScrollPane jScrollPane = new JScrollPane(this.texta);
        this.texta.setFont(new Font("sansserif", 0, 10));
        this.texta.setLineWrap(true);
        this.texta.setWrapStyleWord(true);
        jScrollPane.setMinimumSize(new Dimension(240, 240));
        jScrollPane.setMaximumSize(new Dimension(600, 500));
        jScrollPane.setPreferredSize(new Dimension(600, 500));
        this.getContentPane().add((Component)jScrollPane, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setMinimumSize(new Dimension(8, 8));
        this.getContentPane().add((Component)jPanel, "South");
        this.showModule(module);
        this.pack();
    }

    public void showModule(Module module) {
        Object object;
        this._module = module;
        if (module == null) {
            this.texta.setText("(No module selected)");
        } else {
            Object object2;
            int n;
            String string;
            this._level = 0;
            this.texta.setText("");
            object = this.getIndent(++this._level);
            this.texta.append((String)object + "Module: " + module.getName() + eol);
            this.texta.append((String)object + "Release: " + module.getRelease() + eol);
            this.texta.append((String)object + "Date: " + this._dateFmt.format(module.getDate()) + eol);
            String[] stringArray = module.getFormat();
            if (stringArray.length > 0) {
                this.texta.append((String)object + "Format: " + stringArray[0]);
                for (int i = 1; i < stringArray.length; ++i) {
                    this.texta.append(", " + stringArray[i]);
                }
                this.texta.append(eol);
            }
            if ((string = module.getCoverage()) != null) {
                this.texta.append((String)object + "Coverage: " + string + eol);
            }
            if ((stringArray = module.getMimeType()).length > 0) {
                this.texta.append((String)object + "MIMEtype: " + stringArray[0]);
                for (int i = 1; i < stringArray.length; ++i) {
                    this.texta.append(", " + stringArray[i]);
                }
                this.texta.append(eol);
            }
            List list = module.getSignature();
            int n2 = list.size();
            for (n = 0; n < n2; ++n) {
                this.showSignature((Signature)list.get(n));
            }
            list = module.getSpecification();
            n2 = list.size();
            for (n = 0; n < n2; ++n) {
                this.showDocument((Document)list.get(n), "Specification");
            }
            this.texta.append((String)object + " Features:\n");
            List list2 = module.getFeatures();
            if (list2 != null) {
                object2 = list2.iterator();
                while (object2.hasNext()) {
                    string = (String)object2.next();
                    this.texta.append((String)object + "  " + string + "\n");
                }
            }
            this.texta.append((String)object + "Methodology:\n");
            string = module.getWellFormedNote();
            if (string != null) {
                this.texta.append((String)object + "Well-formed: " + string + eol);
            }
            if ((string = module.getValidityNote()) != null) {
                this.texta.append((String)object + "Validity: " + string + eol);
            }
            if ((string = module.getRepInfoNote()) != null) {
                this.texta.append((String)object + "RepresentationInformation: " + string + eol);
            }
            if ((object2 = module.getVendor()) != null) {
                this.showAgent((Agent)object2, "Vendor");
            }
            if ((string = module.getNote()) != null) {
                this.texta.append((String)object + "Note: " + string + eol);
            }
            if ((string = module.getRights()) != null) {
                this.texta.append((String)object + "Rights: " + string + eol);
            }
        }
        this.texta.setEditable(false);
        this.texta.select(0, 0);
        object = new Rectangle(0, 0, 1, 1);
        this.texta.scrollRectToVisible((Rectangle)object);
    }

    private void showSignature(Signature signature) {
        String string;
        String string2;
        String string3 = this.getIndent(++this._level);
        String string4 = signature.isStringValue() ? signature.getValueString() : signature.getValueHexString();
        this.texta.append(string3 + signature.getType().toString() + ": " + string4 + eol);
        if (signature.getType().equals(SignatureType.MAGIC) && ((InternalSignature)signature).hasFixedOffset()) {
            this.texta.append(string3 + "Offset: " + ((InternalSignature)signature).getOffset() + eol);
        }
        if ((string2 = signature.getNote()) != null) {
            this.texta.append(string3 + "Note: " + string2 + eol);
        }
        if ((string = signature.getUse().toString()) != null) {
            this.texta.append(string3 + "Use: " + string + eol);
        }
        --this._level;
    }

    private void showDocument(Document document, String string) {
        int n;
        String string2 = this.getIndent(++this._level);
        this.texta.append(string2 + string + ": " + document.getTitle() + eol);
        this.texta.append(string2 + "Type: " + document.getType() + eol);
        List list = document.getAuthor();
        int n2 = list.size();
        for (n = 0; n < n2; ++n) {
            this.showAgent((Agent)list.get(n), "Author");
        }
        list = document.getPublisher();
        n2 = list.size();
        for (n = 0; n < n2; ++n) {
            this.showAgent((Agent)list.get(n), "Publisher");
        }
        String string3 = document.getEdition();
        if (string3 != null) {
            this.texta.append(string2 + "Edition: " + string3 + eol);
        }
        if ((string3 = document.getDate()) != null) {
            this.texta.append(string2 + "Date: " + string3 + eol);
        }
        if ((string3 = document.getEnumeration()) != null) {
            this.texta.append(string2 + "Enumeration: " + string3 + eol);
        }
        if ((string3 = document.getPages()) != null) {
            this.texta.append(string2 + "Pages: " + string3 + eol);
        }
        list = document.getIdentifier();
        n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            this.showIdentifier((Identifier)list.get(i));
        }
        string3 = document.getNote();
        if (string3 != null) {
            this.texta.append(string2 + "Note: " + string3 + eol);
        }
        --this._level;
    }

    private void showAgent(Agent agent, String string) {
        String string2 = this.getIndent(++this._level);
        this.texta.append(string2 + string + ": " + agent.getName() + eol);
        this.texta.append(string2 + "Type: " + agent.getType().toString() + eol);
        String string3 = agent.getAddress();
        if (string3 != null) {
            this.texta.append(string2 + "Address: " + string3 + eol);
        }
        if ((string3 = agent.getTelephone()) != null) {
            this.texta.append(string2 + "Telephone: " + string3 + eol);
        }
        if ((string3 = agent.getFax()) != null) {
            this.texta.append(string2 + "Fax: " + string3 + eol);
        }
        if ((string3 = agent.getEmail()) != null) {
            this.texta.append(string2 + "Email: " + string3 + eol);
        }
        if ((string3 = agent.getWeb()) != null) {
            this.texta.append(string2 + "Web: " + string3 + eol);
        }
        --this._level;
    }

    private void showIdentifier(Identifier identifier) {
        String string = this.getIndent(++this._level);
        this.texta.append(string + "Identifier: " + identifier.getValue() + eol);
        this.texta.append(string + "Type: " + identifier.getType().toString() + eol);
        String string2 = identifier.getNote();
        if (string2 != null) {
            this.texta.append(string + "Note: " + string2 + eol);
        }
        --this._level;
    }

    private String getIndent(int n) {
        switch (n) {
            case 1: {
                return " ";
            }
            case 2: {
                return "  ";
            }
            case 3: {
                return "   ";
            }
            case 4: {
                return "    ";
            }
        }
        return "";
    }

    private void saveInfo() {
        if (this._module == null) {
            JOptionPane.showMessageDialog(this, "No module selected", "Can't save", 1);
            return;
        }
        PrintWriter printWriter = this.doSaveDialog();
        if (printWriter == null) {
            return;
        }
        OutputHandler outputHandler = this.selectHandler();
        try {
            outputHandler.setWriter(printWriter);
            outputHandler.show(this._module);
            printWriter.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.getMessage(), "Error writing file", 0);
        }
    }
}

