#!/bin/bash

################################################################################
# Linux Management Providers (LMP), DNS provider package
# Copyright (C) 2007 Ilsoo Byun <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################

if test "$3" = pegasus
then
	
	cimmof -aE -n $1 $6/mof/OpenDRIM_DNSElementSettingData.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_DNSElementSettingData provider module";
Name = "DNS_OpenDRIM_DNSElementSettingDataModule";
Location = "cmpiDNS_OpenDRIM_DNSElementSettingDataProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_DNSElementSettingData provider";
Name = "DNS_OpenDRIM_DNSElementSettingDataProvider";
ProviderModuleName = "DNS_OpenDRIM_DNSElementSettingDataModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_DNSElementSettingData provider capabilities";
ProviderModuleName = "DNS_OpenDRIM_DNSElementSettingDataModule";
ProviderName = "DNS_OpenDRIM_DNSElementSettingDataProvider";
ClassName = "OpenDRIM_DNSElementSettingData";
ProviderType = {2, 3};
Namespaces = {"$1"};
SupportedProperties = {"ManagedElement", "SettingData", "IsDefault", "IsCurrent", "IsNext"};
CapabilityID = "DNS_OpenDRIM_DNSElementSettingData";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_DNSElementSettingData.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_DNSElementSettingData]   
   provider: DNS_OpenDRIM_DNSElementSettingDataProvider
   location: cmpiDNS_OpenDRIM_DNSElementSettingDataProvider
   type: instance association
   namespace: $1
#
EOFC
	
	sfcbstage -r $OUTFILE -n $1 $6/mof/OpenDRIM_DNSElementSettingData.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_DNSElementSettingData-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_DNSElementSettingData.mof >> $OUTFILE
	owmofc -u http://localhost/$1 $OUTFILE
	
	rm -f $OUTFILE
	
fi
