/*###############################################################################
# Linux Management Providers (LMP), OpenDRIM_RecordLogPackage provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr, widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#include "cmpiOpenDRIM_RecordLog.h"

CMPIObjectPath* OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_RecordLog& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_RecordLog_classnames[0], OpenDRIM_RecordLog_NAMESPACE);

	if (!instance.InstanceID_isNULL)
		op.addKey("InstanceID", instance.InstanceID);

	_L_;
	return op.getHdl();
}

CMPIInstance* OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_RecordLog& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.Caption_isNULL)
		ci.setProperty("Caption", instance.Caption);

	if (!instance.Description_isNULL)
		ci.setProperty("Description", instance.Description);

	if (!instance.ElementName_isNULL)
		ci.setProperty("ElementName", instance.ElementName);

	if (!instance.InstallDate_isNULL)
		ci.setPropertyDatetime("InstallDate", instance.InstallDate);

	if (!instance.Name_isNULL)
		ci.setProperty("Name", instance.Name);

	if (!instance.OperationalStatus_isNULL)
		ci.setProperty("OperationalStatus", instance.OperationalStatus);

	if (!instance.StatusDescriptions_isNULL)
		ci.setProperty("StatusDescriptions", instance.StatusDescriptions);

	if (!instance.Status_isNULL)
		ci.setProperty("Status", instance.Status);

	if (!instance.HealthState_isNULL)
		ci.setProperty("HealthState", instance.HealthState);

	if (!instance.PrimaryStatus_isNULL)
		ci.setProperty("PrimaryStatus", instance.PrimaryStatus);

	if (!instance.DetailedStatus_isNULL)
		ci.setProperty("DetailedStatus", instance.DetailedStatus);

	if (!instance.OperatingStatus_isNULL)
		ci.setProperty("OperatingStatus", instance.OperatingStatus);

	if (!instance.CommunicationStatus_isNULL)
		ci.setProperty("CommunicationStatus", instance.CommunicationStatus);

	if (!instance.EnabledState_isNULL)
		ci.setProperty("EnabledState", instance.EnabledState);

	if (!instance.OtherEnabledState_isNULL)
		ci.setProperty("OtherEnabledState", instance.OtherEnabledState);

	if (!instance.RequestedState_isNULL)
		ci.setProperty("RequestedState", instance.RequestedState);

	if (!instance.EnabledDefault_isNULL)
		ci.setProperty("EnabledDefault", instance.EnabledDefault);

	if (!instance.TimeOfLastStateChange_isNULL)
		ci.setPropertyDatetime("TimeOfLastStateChange", instance.TimeOfLastStateChange);

	if (!instance.AvailableRequestedStates_isNULL)
		ci.setProperty("AvailableRequestedStates", instance.AvailableRequestedStates);

	if (!instance.TransitioningToState_isNULL)
		ci.setProperty("TransitioningToState", instance.TransitioningToState);

	if (!instance.MaxNumberOfRecords_isNULL)
		ci.setProperty("MaxNumberOfRecords", instance.MaxNumberOfRecords);

	if (!instance.CurrentNumberOfRecords_isNULL)
		ci.setProperty("CurrentNumberOfRecords", instance.CurrentNumberOfRecords);

	if (!instance.LogState_isNULL)
		ci.setProperty("LogState", instance.LogState);

	if (!instance.OverwritePolicy_isNULL)
		ci.setProperty("OverwritePolicy", instance.OverwritePolicy);

	if (!instance.Facility_isNULL)
		ci.setProperty("Facility", instance.Facility);

	if (!instance.Severity_isNULL)
		ci.setProperty("Severity", instance.Severity);

	_L_;
	return ci.getHdl();
}

void OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_RecordLog& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	_L_;
}

void OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_RecordLog& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("Caption", instance.Caption) == OK)
		instance.Caption_isNULL = false;

	if (inst.getProperty("Description", instance.Description) == OK)
		instance.Description_isNULL = false;

	if (inst.getProperty("ElementName", instance.ElementName) == OK)
		instance.ElementName_isNULL = false;

	if (inst.getPropertyDatetime("InstallDate", instance.InstallDate) == OK)
		instance.InstallDate_isNULL = false;

	if (inst.getProperty("Name", instance.Name) == OK)
		instance.Name_isNULL = false;

	if (inst.getProperty("OperationalStatus", instance.OperationalStatus) == OK)
		instance.OperationalStatus_isNULL = false;

	if (inst.getProperty("StatusDescriptions", instance.StatusDescriptions) == OK)
		instance.StatusDescriptions_isNULL = false;

	if (inst.getProperty("Status", instance.Status) == OK)
		instance.Status_isNULL = false;

	if (inst.getProperty("HealthState", instance.HealthState) == OK)
		instance.HealthState_isNULL = false;

	if (inst.getProperty("PrimaryStatus", instance.PrimaryStatus) == OK)
		instance.PrimaryStatus_isNULL = false;

	if (inst.getProperty("DetailedStatus", instance.DetailedStatus) == OK)
		instance.DetailedStatus_isNULL = false;

	if (inst.getProperty("OperatingStatus", instance.OperatingStatus) == OK)
		instance.OperatingStatus_isNULL = false;

	if (inst.getProperty("CommunicationStatus", instance.CommunicationStatus) == OK)
		instance.CommunicationStatus_isNULL = false;

	if (inst.getProperty("EnabledState", instance.EnabledState) == OK)
		instance.EnabledState_isNULL = false;

	if (inst.getProperty("OtherEnabledState", instance.OtherEnabledState) == OK)
		instance.OtherEnabledState_isNULL = false;

	if (inst.getProperty("RequestedState", instance.RequestedState) == OK)
		instance.RequestedState_isNULL = false;

	if (inst.getProperty("EnabledDefault", instance.EnabledDefault) == OK)
		instance.EnabledDefault_isNULL = false;

	if (inst.getPropertyDatetime("TimeOfLastStateChange", instance.TimeOfLastStateChange) == OK)
		instance.TimeOfLastStateChange_isNULL = false;

	if (inst.getProperty("AvailableRequestedStates", instance.AvailableRequestedStates) == OK)
		instance.AvailableRequestedStates_isNULL = false;

	if (inst.getProperty("TransitioningToState", instance.TransitioningToState) == OK)
		instance.TransitioningToState_isNULL = false;

	if (inst.getProperty("MaxNumberOfRecords", instance.MaxNumberOfRecords) == OK)
		instance.MaxNumberOfRecords_isNULL = false;

	if (inst.getProperty("CurrentNumberOfRecords", instance.CurrentNumberOfRecords) == OK)
		instance.CurrentNumberOfRecords_isNULL = false;

	if (inst.getProperty("LogState", instance.LogState) == OK)
		instance.LogState_isNULL = false;

	if (inst.getProperty("OverwritePolicy", instance.OverwritePolicy) == OK)
		instance.OverwritePolicy_isNULL = false;

	if (inst.getProperty("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	if (inst.getProperty("Facility", instance.Facility) == OK)
		instance.Facility_isNULL = false;

	if (inst.getProperty("Severity", instance.Severity) == OK)
		instance.Severity_isNULL = false;

	_L_;
}

void OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_RecordLog_RequestStateChange_In& args) {
	_E_;
	CMPIStatus rc;
	CMPIData data;

	unsigned short RequestedState;
	data = in->ft->getArg(in, "RequestedState", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, RequestedState);	
		args.setRequestedState(RequestedState);
	}			

	Objectpath Job;
	data = in->ft->getArg(in, "Job", &rc);
	if (rc.rc == OK) {
		CT_ToC(broker, data, Job);	
		args.setJob(Job);
	}			

	string TimeoutPeriod;
	data = in->ft->getArg(in, "TimeoutPeriod", &rc);
	if (rc.rc == OK) {
		CT_ToCDatetime(data, TimeoutPeriod);	
		args.setTimeoutPeriod(TimeoutPeriod);
	}			

	_L_;
}

void OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_toCMPIArg(const CMPIBroker* broker, CMPIArgs* out, const OpenDRIM_RecordLog_RequestStateChange_Out& args) {
	_E_;
	CMPIValue value;
	int errorMessage;

	Objectpath Job;
	errorMessage = args.getJob(Job);
	if (errorMessage == OK) {
		value = CT_toCMPI(Job);
		out->ft->addArg(out, "Job", &value, CMPI_ref);
	}

	_L_;
}
