#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# A Wish Upon a Star
# send your bug reports to contact@dotslashplay.it
###

script_version=20221030.2

GAME_ID='a-wish-upon-a-star'
GAME_NAME='A Wish Upon a Star'

UNITY3D_NAME='AWishUponAStar'

ARCHIVE_BASE_32BIT_0='AWishUponAStar_v1_2_0_WIN32.zip'
ARCHIVE_BASE_32BIT_0_MD5='6644015a399d7485f7c73491f9462854'
ARCHIVE_BASE_32BIT_0_SIZE='260000'
ARCHIVE_BASE_32BIT_0_VERSION='1.2.0-itch.2018.07.07'
ARCHIVE_BASE_32BIT_0_URL='https://fabiandenter.itch.io/wish-upon-a-star'

ARCHIVE_BASE_64BIT_0='AWishUponAStar_WIN_v1_2_0.zip'
ARCHIVE_BASE_64BIT_0_MD5='1c76b283aabf5d64bc05fbf489cf3a25'
ARCHIVE_BASE_64BIT_0_SIZE='260000'
ARCHIVE_BASE_64BIT_0_VERSION='1.2.0-itch.2018.07.07'
ARCHIVE_BASE_64BIT_0_URL='https://fabiandenter.itch.io/wish-upon-a-star'

CONTENT_PATH_DEFAULT_32BIT='AWishUponAStar_v1_2_0_WIN32'
CONTENT_PATH_DEFAULT_64BIT='AWishUponAStar_WIN_v1_2_0'
ARCHIVE_GAME_BIN_FILES="
${UNITY3D_NAME}.exe
${UNITY3D_NAME}_Data/Mono
UnityPlayer.dll"
ARCHIVE_GAME_DATA_FILES="
${UNITY3D_NAME}_Data"

APP_MAIN_TYPE='wine'
APP_MAIN_EXE="${UNITY3D_NAME}.exe"
APP_MAIN_ICON="$APP_MAIN_EXE"

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH_32BIT='32'
PKG_BIN_ARCH_64BIT='64'
PKG_BIN_DEPS="$PKG_DATA_ID"

# Use persistent storage for game progress and settings

WINE_REGEDIT_PERSISTENT_KEYS='
HKEY_CURRENT_USER\Software\Fabian Denter\A Wish Upon A Star'

# Load common functions

target_version='2.18'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build package

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
