## Introduction

This folder contains the files generated by the glad GL loader for the game.

## Instructions

Install glad via package manager or pip, for the latter create a venv if
necessary. Alternatively fetch the glad git repo as outlined below. On
Windows fetching the git repo is assumed.

Download glad v2:
```sh
git clone https://github.com/Dav1dde/glad.git -b glad2
```

Install the python dependencies
```sh
cd glad
pip install -r requirements.txt
```

Do not revert the WFG patch in include/glad/gl.h (around line 1765):
do not add the change reverting it after the generation of the file
Currently it's automatically applied by running the update-headers script.
On Windows you need to run it under Git Bash or with the `patch` program in PATH.

Build the source files for all four backends with their respective extensions
- GL
    ```sh
    python -m glad --api="gl:core=2.1" --extensions="../extensions/gl.txt" --out-path="../" c
    ```
- GLES2
    ```sh
    python -m glad --api="gles2=2.0" --extensions="../extensions/gles2.txt" --out-path="../" c
    ```
- GLX
    ```sh
    python -m glad --api="glx=1.4" --extensions="../extensions/glx.txt" --out-path="../" c
    ```
- WGL
    ```sh
    python -m glad --api="wgl=1.0" --extensions="../extensions/wgl.txt" --out-path="../" c
    ```
- EGL
    ```sh
    python -m glad --api="egl=1.5" --extensions="../extensions/egl.txt" --out-path="../" c
    ```
- Vulkan
    ```sh
    python -m glad --api="vulkan=1.1" --extensions="../extensions/vulkan.txt" --out-path="../" c
    ```

Rename all files to .cpp to prevent compilation warnings
