/*
 *  This file is part of ALTER.
 *
 *  ALTER is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  ALTER is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with ALTER.  If not, see <http://www.gnu.org/licenses/>.
 */

package gui;

import javax.swing.SwingUtilities;

/**
 * Help panel.
 * @author Daniel Gomez Blanco
 * @version 1.0
 */
public class HelpPanel extends javax.swing.JPanel {

    /** Creates new form HelpPanel */
    public HelpPanel() {
        initComponents();
    }

    public void scrollUp()
    {
        SwingUtilities.invokeLater(new Runnable()
        {
            public void run()
            {
                scrollPane.getVerticalScrollBar().setValue(0);
            }
        });
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        scrollPane = new javax.swing.JScrollPane();
        textPane = new javax.swing.JTextPane();

        textPane.setContentType("text/html");
        textPane.setEditable(false);
        textPane.setText("<html>\r\n  <head>\r\n\r\n  </head>\r\n  <body>\r\n    <h2>\n\tALTER (ALignment Transformation EnviRonment) v1.1</h2>\n<p>\n\tThe following document provides information on how to use the desktop version of ALTER, an evironment for alignment transformation. ALTER aims to solve the existing problem with different formats and different programs for multiple sequences alignments. It converts multiple sequences alignments between known formats so they can be processed by a set phylogenetic analyzers.</p>\n<p>\n\t&nbsp;</p>\n<h3>\n\tLoad sequences into ALTER</h3>\n<p>\n\tLoading sequences into the application can be achieved by following one of these two simple steps:</p>\n<ul>\n\t<li>\n\t\tClicking on the &quot;Load...&quot; button (or pressing CTRL + L) will display a file chooser. Select a file containing a multiple sequences alignment in one of the supported formats (scroll down for an explanation of the supported formats) and its sequences will be loaded into the input text area.</li>\n\t<li>\n\t\tSequences can also be pasted into the input text area.</li>\n</ul>\n<br/>\n<h3>\n\tSave input file</h3>\n<p>\n\tSaving the input file will copy the sequences contained in the input text area to a file in the system. There are two options in this step:</p>\n<ul>\n\t<li>\n\t\tBy clicking on the &quot;Save...&quot; button belonging to the input area (or by pressing CTRL &nbsp;+ I) the file used to load the sequences into ALTER will be overwritten with the text contained in the input text area. If no file was used to load the sequences, and the sequences have not been saved before, the action taken would be the same as using the &quot;Save As...&quot; button.</li>\n\t<li>\n\t\tBy clicking on the &quot;Save As...&quot; button belonging to the input area a file selector will be displayed. After selecting a name (or a file to overwrite) in the file system, the content of the input text area will be written to the selected file.</li>\n</ul>\n<p>\n\t&nbsp;</p>\n<h3>\n\tSave output file</h3>\n<p>\n\tSaving the output file will copy the sequences contained in the output text area to a file in the system. There are two options in this step:</p>\n<ul>\n\t<li>\n\t\tBy clicking on the &quot;Save...&quot; button belonging to the output area (or by pressing CTRL &nbsp;+ O) the file previously used to save the converted sequences will be overwritten with the text contained in the output text area. If the converted sequences have not been saved before, the action taken would be the same as using the &quot;Save As...&quot; button.</li>\n\t<li>\n\t\tBy clicking on the &quot;Save As...&quot; button belonging to the output area a file selector will be displayed. After selecting a name (or a file to overwrite) in the file system, the content of the output text area will be written to the selected file.</li>\n</ul>\n<p>\n\t&nbsp;</p>\n<h3>\n\tSave all files</h3>\n<p>\n\tBy clicking on &quot;File-&gt;Save All&quot; button (or pressing CTRL + A) both the input and the output files will be overwritten with the sequences contained in the text areas. If a file was not used for either input or output a file chooser will be displayed to select the file.</p>\n\n<br/>\n<br/>\n<br/>\n<h3>\n\tConvert sequences</h3>\n<p>\n\tIn order to convert the sequences loaded into one of the supported formats the &quot;Convert...&quot; button must be clicked. Once this button is clicked, a dialog will be displayed to select the options for conversion. These options are now explained:</p>\n<ul>\n\t<li>\n\t\t<strong>Input: </strong>Options for the input sequences\n\t\t<ul>\n\t\t\t<li>\n\t\t\t\t<em>OS</em>: Operating system used to create the input file (Linux, MacOS and Windows are supported).</li>\n\t\t\t<li>\n\t\t\t\t<em>Program</em>: The program used to create the input file (Clustal, MAFFT and TCoffee are supported).</li>\n\t\t\t<li>\n\t\t\t\t<em>Format</em>: The format in which the input file is (ALN, FASTA, GDE, MSF, NEXUS, PHYLIP and PIR are supported). Some restrictions can apply here due to the formats supported by the input programs.</li>\n\t\t\t<li>\n\t\t\t\t<em>Autodetect</em>: By selecting this option the input format will be detected automatically.</li>\n\t\t</ul>\n\t</li>\n\t<li>\n\t\t<strong>Collapse</strong>: Options for haplotype collapse (removing of redundant sequences)\n\t\t<ul>\n\t\t\t<li>\n\t\t\t\t<em>Collapse sequences to haplotypes</em>:&nbsp;This option enables the haplotype collapse feature. When checked, it activates the rest of the options to handle this process.</li>\n\t\t\t<li>\n\t\t\t\t<em>Limit</em>: Sets the limit to collapse the sequences. Only sequences differing in the same or less residues than the limit will be collapsed.</li>\n\t\t\t<li>\n\t\t\t\t<em>Treat gaps as missing data</em>: Gaps are treated as a fifth state by default. This option makes the collapse feature treat gaps as missing data.</li>\n\t\t\t<li>\n\t\t\t\t<em>Count missing data as differences</em>: Missing data can be ommited from the process is this option is not checked.</li>\n\t\t</ul>\n\t</li>\n\t<li>\n\t\t<strong>Output</strong>: Options for the output sequences\n\t\t<ul>\n\t\t\t<li>\n\t\t\t\t<em>OS</em>: Operating system used to processed the output file (Linux, MacOS and Windows are supported).</li>\n\t\t\t<li>\n\t\t\t\t<em>Program</em>: The program used to process the output file (jModelTest, MrBayes, PAML, PAUP, PhyML, PortTest, RAxML, TCS and CodABC are supported). If &quot;ANY&quot; is selected the sequences will be converted to an standard format.</li>\n\t\t\t<li>\n\t\t\t\t<em>Format</em>: The format in which the output file will be (ALN, FASTA, GDE, MSF, NEXUS, PHYLIP and PIR are supported). Some restrictions can apply here due to the formats supported by the input programs.</li>\n\t\t\t<li>\n\t\t\t\t<em>Lower case</em>:&nbsp;Outputs the sequences using lower case characters.</li>\n\t\t\t<li>\n\t\t\t\t<em>Match encoding</em>:&nbsp;Uses&nbsp;<i>match</i>&nbsp;characters (character &ldquo;.&rdquo;) to indicate that the same residue is located in the same position of the first sequence. This option is not available for MSF format since it prints gaps as &ldquo;.&rdquo; characters.</li>\n\t\t\t<li>\n\t\t\t\t<em>Residue numbers</em>:&nbsp;Outputs the sum of the number of residues to that point next to each line of each sequence. This option is only available for ALN format.</li>\n\t\t\t<li>\n\t\t\t\t<em>Sequential</em>:&nbsp;Outputs the sequences in sequential format. This option is only available for NEXUS and PHYLIP formats.</li>\n\t\t</ul>\n\t</li>\n</ul>\n<p>\n\tThank you for using ALTER, we hope you enjoy it!</p>\n\n  </body>\r\n</html>\r\n");
        scrollPane.setViewportView(textPane);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(scrollPane, javax.swing.GroupLayout.PREFERRED_SIZE, 594, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(scrollPane, javax.swing.GroupLayout.PREFERRED_SIZE, 484, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane scrollPane;
    private javax.swing.JTextPane textPane;
    // End of variables declaration//GEN-END:variables

}
