\documentclass{article}
\usepackage{../../../../../src/scripts/tex/axiom}
\begin{document}
\title{\$SPAD/lsp/ccl/src/axbase/compiler/lib axextend.lsp}
\author{Arthur Norman}
\maketitle
\begin{abstract}
\end{abstract}
\eject
\tableofcontents
\eject
\section{License}
<<license>>=
; Copyright (c) 1991-2002, The Numerical ALgorithms Group Ltd.
; All rights reserved.
;
; Redistribution and use in source and binary forms, with or without
; modification, are permitted provided that the following conditions are
; met:
;
;     - Redistributions of source code must retain the above copyright
;       notice, this list of conditions and the following disclaimer.
;
;     - Redistributions in binary form must reproduce the above copyright
;       notice, this list of conditions and the following disclaimer in
;       the documentation and/or other materials provided with the
;       distribution.
;
;     - Neither the name of The Numerical ALgorithms Group Ltd. nor the
;       names of its contributors may be used to endorse or promote products
;       derived from this software without specific prior written permission.
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
; IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
; TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
; PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
; OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
; EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
; PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
; LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
; NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
; SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

@
<<*>>=
<<license>>


;;;
;;; Lisp code generated by Aldor from file "axextend.as".
;;;

(in-package "FOAM-USER" :use '("FOAM" "LISP"))

(declare-prog (|C0-axextend-axextend|) ((|e1| |Env|)))

(declare-prog
  (|C1-axextend-addLevel0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C2-axextend-addLevel1| |Word|)
  ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))

(declare-prog
  (|C3-axextend-string| |Word|)
  ((|P0-l| |Word|) (|e1| |Env|)))

(declare-prog
  (|C4-axextend-extend0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C5-axextend-addLevel0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C6-axextend-addLevel1| |Word|)
  ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))

(declare-prog
  (|C7-axextend-integer| |Word|)
  ((|P0-l| |Word|) (|e1| |Env|)))

(declare-prog
  (|C8-axextend-+| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C9-axextend--| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C10-axextend-*| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C11-axextend-=| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C12-axextend-~=| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C13-axextend-<| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C14-axextend-<=| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C15-axextend->| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C16-axextend->=| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog (|C17-axextend-one| |Word|) ((|e1| |Env|)))

(declare-prog (|C18-axextend-zero| |Word|) ((|e1| |Env|)))

(declare-prog
  (|C19-axextend-zero?| |Word|)
  ((|P0-n| |Word|) (|e1| |Env|)))

(declare-prog
  (|C20-axextend-coerce| |Word|)
  ((|P0-n| |Word|) (|e1| |Env|)))

(declare-prog
  (|C21-axextend-extend0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C22-axextend-addLevel0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C23-axextend-addLevel1| |Word|)
  ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))

(declare-prog
  (|C24-axextend-integer| |Word|)
  ((|P0-l| |Word|) (|e1| |Env|)))

(declare-prog
  (|C25-axextend--| |Word|)
  ((|P0-a| |Word|) (|e1| |Env|)))

(declare-prog
  (|C26-axextend-+| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C27-axextend--| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C28-axextend-*| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C29-axextend-=| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C30-axextend-~=| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C31-axextend-<| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C32-axextend-<=| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C33-axextend->| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C34-axextend->=| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C35-axextend-coerce| |Word|)
  ((|P0-n| |Word|) (|e1| |Env|)))

(declare-prog
  (|C36-axextend-coerce| |Word|)
  ((|P0-i| |Word|) (|e1| |Env|)))

(declare-prog
  (|C37-axextend-coerce| |Word|)
  ((|P0-i| |Word|) (|e1| |Env|)))

(declare-prog
  (|C38-axextend-coerce| |Word|)
  ((|P0-i| |Word|) (|e1| |Env|)))

(declare-prog (|C39-axextend-one| |Word|) ((|e1| |Env|)))

(declare-prog (|C40-axextend-zero| |Word|) ((|e1| |Env|)))

(declare-prog
  (|C41-axextend-zero?| |Word|)
  ((|P0-x| |Word|) (|e1| |Env|)))

(declare-prog
  (|C42-axextend-quo| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C43-axextend-rem| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C44-axextend-extend0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C45-axextend-addLevel0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C46-axextend-addLevel1| |Word|)
  ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))

(declare-prog
  (|C47-axextend-coerce| |Word|)
  ((|P0-n| |Word|) (|e1| |Env|)))

(declare-prog
  (|C48-axextend-coerce| |Word|)
  ((|P0-n| |Word|) (|e1| |Env|)))

(declare-prog
  (|C49-axextend-coerce| |Word|)
  ((|P0-n| |Word|) (|e1| |Env|)))

(declare-prog
  (|C50-axextend-coerce| |Word|)
  ((|P0-i| |Word|) (|e1| |Env|)))

(declare-prog (|C51-axextend-one| |Word|) ((|e1| |Env|)))

(declare-prog (|C52-axextend-zero| |Word|) ((|e1| |Env|)))

(declare-prog
  (|C53-axextend-zero?| |Word|)
  ((|P0-n| |Word|) (|e1| |Env|)))

(declare-prog
  (|C54-axextend-+| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C55-axextend-*| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C56-axextend--| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C57-axextend-=| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C58-axextend-<| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C59-axextend->| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C60-axextend-<=| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C61-axextend->=| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C62-axextend-quo| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C63-axextend-rem| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C64-axextend-mod| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C65-axextend-extend0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C66-axextend-addLevel0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C67-axextend-addLevel1| |Word|)
  ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))

(declare-prog
  (|C68-axextend-coerce| |Word|)
  ((|P0-n| |Word|) (|e1| |Env|)))

(declare-prog
  (|C69-axextend-coerce| |Word|)
  ((|P0-n| |Word|) (|e1| |Env|)))

(declare-prog
  (|C70-axextend-coerce| |Word|)
  ((|P0-n| |Word|) (|e1| |Env|)))

(declare-prog
  (|C71-axextend-coerce| |Word|)
  ((|P0-i| |Word|) (|e1| |Env|)))

(declare-prog
  (|C72-axextend-coerce| |Word|)
  ((|P0-n| |Word|) (|e1| |Env|)))

(declare-prog
  (|C73-axextend-coerce| |Word|)
  ((|P0-i| |Word|) (|e1| |Env|)))

(declare-prog (|C74-axextend-one| |Word|) ((|e1| |Env|)))

(declare-prog
  (|C75-axextend-+| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C76-axextend-*| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C77-axextend--| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C78-axextend-=| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C79-axextend-<| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C80-axextend->| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C81-axextend-<=| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C82-axextend->=| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C83-axextend-quo| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C84-axextend-rem| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C85-axextend-mod| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C86-axextend-extend0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C87-axextend-List| |Word|)
  ((p0-s |Word|) (|e1| |Env|)))

(declare-prog
  (|C88-axextend-addLevel0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C89-axextend-addLevel1| |Word|)
  ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))

(declare-prog
  (|C90-axextend-rec| |Record|)
  ((|P0-x| |Word|) (|e1| |Env|)))

(declare-prog
  (|C91-axextend-empty?| |Word|)
  ((|P0-l| |Word|) (|e1| |Env|)))

(declare-prog
  (|C92-axextend-#| |Word|)
  ((|P0-l| |Word|) (|e1| |Env|)))

(declare-prog (|C93-axextend-empty| |Word|) ((|e1| |Env|)))

(declare-prog
  (|C94-axextend-cons| |Word|)
  ((|P0-a| |Word|) (|P1-l| |Word|) (|e1| |Env|)))

(declare-prog
  (|C95-axextend-test| |Word|)
  ((|P0-x| |Word|) (|e1| |Env|)))

(declare-prog
  (|C96-axextend-first| |Word|)
  ((|P0-l| |Word|) (|e1| |Env|)))

(declare-prog
  (|C97-axextend-rest| |Word|)
  ((|P0-l| |Word|) (|e1| |Env|)))

(declare-prog
  (|C98-axextend-setFirst!| |Word|)
  ((|P0-l| |Word|) (|P1-a| |Word|) (|e1| |Env|)))

(declare-prog
  (|C99-axextend-setRest!| |Word|)
  ((|P0-l| |Word|) (|P1-t| |Word|) (|e1| |Env|)))

(declare-prog
  (|C100-axextend-reverse!| |Word|)
  ((|P0-x| |Word|) (|e1| |Env|)))

(declare-prog
  (|C101-axextend-#| |Word|)
  ((|P0-l| |Word|) (|e1| |Env|)))

(declare-prog
  (|C102-axextend-generator| |Clos|)
  ((|P0-l| |Word|) (|e1| |Env|)))

(declare-prog
  (|C103-axextend-generBaseFn| |Clos| |Clos| |Clos| |Clos|)
  ((|e1| |Env|)))

(declare-prog (|C104-axextend-generStepper|) ((|e1| |Env|)))

(declare-prog (|C105-axextend-generDone?| |Bool|) ((|e1| |Env|)))

(declare-prog (|C106-axextend-generValue| |Word|) ((|e1| |Env|)))

(declare-prog (|C107-axextend-generBound| |SInt|) ((|e1| |Env|)))

(declare-prog
  (|C108-axextend-bracket| |Word|)
  ((|P0-g| |Clos|) (|e1| |Env|)))

(declare-prog
  (|C109-axextend-addLevel0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C110-axextend-addLevel1| |Word|)
  ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))

(declare-prog
  (|C111-axextend-nil?| |Word|)
  ((|P0-p| |Word|) (|e1| |Env|)))

(declare-prog
  (|C112-axextend-recptr| |Word|)
  ((|P0-r| |Record|) (|e1| |Env|)))

(declare-prog
  (|C113-axextend-value| |Record|)
  ((|P0-p| |Word|) (|e1| |Env|)))

(declare-prog
  (|C114-axextend-axextend| |Word|)
  ((p0-s |Word|) (|e1| |Env|)))

(declare-prog
  (|C115-axextend-extend0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C116-axextend-Vector| |Word|)
  ((p0-s |Word|) (|e1| |Env|)))

(declare-prog
  (|C117-axextend-addLevel0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C118-axextend-addLevel1| |Word|)
  ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))

(declare-prog
  (|C119-axextend-bracket| |Word|)
  ((|P0-g| |Clos|) (|e1| |Env|)))

(declare-prog
  (|C120-axextend-bracket| |Word|)
  ((|P0-t| |Word|) (|e1| |Env|)))

(declare-prog
  (|C121-axextend-new| |Word|)
  ((|P0-n| |Word|) (|P1-x| |Word|) (|e1| |Env|)))

(declare-prog
  (|C122-axextend-generator| |Clos|)
  ((|P0-v| |Word|) (|e1| |Env|)))

(declare-prog
  (|C123-axextend-generBaseFn| |Clos| |Clos| |Clos| |Clos|)
  ((|e1| |Env|)))

(declare-prog (|C124-axextend-generStepper|) ((|e1| |Env|)))

(declare-prog (|C125-axextend-generDone?| |Bool|) ((|e1| |Env|)))

(declare-prog (|C126-axextend-generValue| |Word|) ((|e1| |Env|)))

(declare-prog (|C127-axextend-generBound| |SInt|) ((|e1| |Env|)))

(declare-prog
  (|C128-axextend-#| |Word|)
  ((|P0-v| |Word|) (|e1| |Env|)))

(declare-prog
  (|C129-axextend-apply| |Word|)
  ((|P0-x| |Word|) (|P1-i| |Word|) (|e1| |Env|)))

(declare-prog
  (|C130-axextend-set!|)
  ((|P0-x| |Word|) (|P1-n| |Word|) (|P2-v| |Word|) (|e1| |Env|)))

(declare-prog
  (|C131-axextend-axextend| |Word|)
  ((p0-s |Word|) (|e1| |Env|)))

(declare-prog
  (|C132-axextend-extend0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C133-axextend-Matrix| |Word|)
  ((p0-r |Word|) (|e1| |Env|)))

(declare-prog
  (|C134-axextend-addLevel0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C135-axextend-addLevel1| |Word|)
  ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))

(declare-prog
  (|C136-axextend-apply| |Word|)
  ((|P0-m| |Word|) (|P1-i| |Word|) (|P2-j| |Word|) (|e1| |Env|)))

(declare-prog
  (|C137-axextend-set!| |Word|)
  ((|P0-m| |Word|)
    (|P1-i| |Word|)
    (|P2-j| |Word|)
    (|P3-v| |Word|)
    (|e1| |Env|)))

(declare-prog
  (|C138-axextend-qelt| |Word|)
  ((|P0-m| |Word|) (|P1-i| |Word|) (|P2-j| |Word|) (|e1| |Env|)))

(declare-prog
  (|C139-axextend-qsetelt!| |Word|)
  ((|P0-m| |Word|)
    (|P1-i| |Word|)
    (|P2-j| |Word|)
    (|P3-v| |Word|)
    (|e1| |Env|)))

(declare-prog
  (|C140-axextend-axextend| |Word|)
  ((p0-r |Word|) (|e1| |Env|)))

(declare-prog
  (|C141-axextend-extend0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C142-axextend-GeneratorCategory| |Word|)
  ((p0-s |Word|) (|e1| |Env|)))

(declare-prog (|C143-axextend-defhash0| |SInt|) ((|e1| |Env|)))

(declare-prog
  (|C144-axextend-GeneratorCategory|)
  ((|P0-self| |Word|) (|P1-dom| |Word|) (|e1| |Env|)))

(declare-prog
  (|C145-axextend-Segment| |Word|)
  ((p0-s |Word|) (|e1| |Env|)))

(declare-prog
  (|C146-axextend-addLevel0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C147-axextend-addLevel1| |Word|)
  ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))

(declare-prog (|C148-axextend-defhash0| |SInt|) ((|e1| |Env|)))

(declare-prog
  (|C149-axextend-Segment|)
  ((|P0-self| |Word|) (|P1-dom| |Word|) (|e1| |Env|)))

(declare-prog
  (|C150-axextend-by| |Word|)
  ((|P0-s| |Word|) (|P1-n| |Word|) (|e1| |Env|)))

(declare-prog
  (|C151-axextend-low| |Word|)
  ((|P0-x| |Word|) (|e1| |Env|)))

(declare-prog
  (|C152-axextend-high| |Word|)
  ((|P0-x| |Word|) (|e1| |Env|)))

(declare-prog
  (|C153-axextend-incrx| |Word|)
  ((|P0-x| |Word|) (|e1| |Env|)))

(declare-prog
  (|C154-axextend-..| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C155-axextend-generator| |Clos|)
  ((|P0-x| |Word|) (|e1| |Env|)))

(declare-prog
  (|C156-axextend-generBaseFn| |Clos| |Clos| |Clos| |Clos|)
  ((|e1| |Env|)))

(declare-prog (|C157-axextend-generStepper|) ((|e1| |Env|)))

(declare-prog (|C158-axextend-generDone?| |Bool|) ((|e1| |Env|)))

(declare-prog (|C159-axextend-generValue| |Word|) ((|e1| |Env|)))

(declare-prog (|C160-axextend-generBound| |SInt|) ((|e1| |Env|)))

(declare-prog
  (|C161-axextend-axextend| |Word|)
  ((p0-s |Word|) (|e1| |Env|)))

(declare-prog
  (|C162-axextend-extend0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C163-axextend-UniversalSegment| |Word|)
  ((p0-s |Word|) (|e1| |Env|)))

(declare-prog
  (|C164-axextend-addLevel0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C165-axextend-addLevel1| |Word|)
  ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))

(declare-prog (|C166-axextend-defhash0| |SInt|) ((|e1| |Env|)))

(declare-prog
  (|C167-axextend-UniversalSegment|)
  ((|P0-self| |Word|) (|P1-dom| |Word|) (|e1| |Env|)))

(declare-prog
  (|C168-axextend-..| |Word|)
  ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))

(declare-prog
  (|C169-axextend-..| |Word|)
  ((|P0-a| |Word|) (|e1| |Env|)))

(declare-prog
  (|C170-axextend-hasHi| |Word|)
  ((|P0-x| |Word|) (|e1| |Env|)))

(declare-prog
  (|C171-axextend-low| |Word|)
  ((|P0-x| |Word|) (|e1| |Env|)))

(declare-prog
  (|C172-axextend-high| |Word|)
  ((|P0-x| |Word|) (|e1| |Env|)))

(declare-prog
  (|C173-axextend-incr| |Word|)
  ((|P0-x| |Word|) (|e1| |Env|)))

(declare-prog
  (|C174-axextend-by| |Word|)
  ((|P0-x| |Word|) (|P1-s| |Word|) (|e1| |Env|)))

(declare-prog
  (|C175-axextend-generator| |Clos|)
  ((|P0-x| |Word|) (|e1| |Env|)))

(declare-prog
  (|C176-axextend-generBaseFn| |Clos| |Clos| |Clos| |Clos|)
  ((|e1| |Env|)))

(declare-prog (|C177-axextend-generStepper|) ((|e1| |Env|)))

(declare-prog (|C178-axextend-generDone?| |Bool|) ((|e1| |Env|)))

(declare-prog (|C179-axextend-generValue| |Word|) ((|e1| |Env|)))

(declare-prog (|C180-axextend-generBound| |SInt|) ((|e1| |Env|)))

(declare-prog
  (|C181-axextend-axextend| |Word|)
  ((p0-s |Word|) (|e1| |Env|)))

(declare-prog
  (|C182-axextend-extend0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C183-axextend-lazyFnGetter| |Clos|)
  ((|P0-init| |Word|) (|e1| |Env|)))

(declare-prog
  (|C184-axextend-lazyGetter| |Clos|)
  ((|P0-a| |Word|) (|e1| |Env|)))

(declare-prog (|C185-axextend-lazyGetter2|) ((|e1| |Env|)))

(declare-prog
  (|C186-axextend-axiom-init| |Word|)
  ((|P0-idx| |SInt|) (|e1| |Env|)))

(declare-prog
  (|C187-axextend-axlit-init| |Word|)
  ((|P0-idx| |SInt|) (|e1| |Env|)))

(declare-type |G-axextend| |Clos|)

(declare-type |G-axextend_Symbol_636926304| |Word|)

(declare-type |G-axextend_Symbol_209526317| |Word|)

(declare-type |G-axextend_SingleInteger_302027834| |Word|)

(declare-type |G-axextend_SingleInteger_499971776| |Word|)

(declare-type |G-axextend_Integer_465677675| |Word|)

(declare-type |G-axextend_Integer_437506685| |Word|)

(declare-type |G-axextend_NonNegativeInteger_029131062| |Word|)

(declare-type |G-axextend_NonNegativeInteger_682440215| |Word|)

(declare-type |G-axextend_PositiveInteger_619949646| |Word|)

(declare-type |G-axextend_PositiveInteger_418138371| |Word|)

(declare-type |G-axextend_List_412811383| |Clos|)

(declare-type |G-axextend_List_134950155| |Clos|)

(declare-type |G-axextend_Vector_075828558| |Clos|)

(declare-type |G-axextend_Vector_052715942| |Clos|)

(declare-type |G-axextend_Matrix_057561278| |Clos|)

(declare-type |G-axextend_Matrix_855611627| |Clos|)

(declare-type |G-axextend_GeneratorCategory_073559903| |Clos|)

(declare-type |G-axextend_Segment_249071355| |Clos|)

(declare-type |G-axextend_Segment_557651354| |Clos|)

(declare-type |G-axextend_UniversalSegment_550108180| |Clos|)

(declare-type |G-axextend_UniversalSegment_408232398| |Clos|)

(defspecials
  |G-axextend_UniversalSegment_408232398|
  |G-axextend_UniversalSegment_550108180|
  |G-axextend_Segment_557651354|
  |G-axextend_Segment_249071355|
  |G-axextend_GeneratorCategory_073559903|
  |G-axextend_Matrix_855611627|
  |G-axextend_Matrix_057561278|
  |G-axextend_Vector_052715942|
  |G-axextend_Vector_075828558|
  |G-axextend_List_134950155|
  |G-axextend_List_412811383|
  |G-axextend_PositiveInteger_418138371|
  |G-axextend_PositiveInteger_619949646|
  |G-axextend_NonNegativeInteger_682440215|
  |G-axextend_NonNegativeInteger_029131062|
  |G-axextend_Integer_437506685|
  |G-axextend_Integer_465677675|
  |G-axextend_SingleInteger_499971776|
  |G-axextend_SingleInteger_302027834|
  |G-axextend_Symbol_209526317|
  |G-axextend_Symbol_636926304|)

(|DDecl|
  |Struct-axextend-5|
  (|size-0| |SInt|)
  (|nsize-1| |SInt|)
  (|values-2| |Word|))

(|DDecl|
  |Struct-axextend-6|
  (|string-0| |Clos|)
  (|coerce-1| |Clos|)
  (\-2 |SInt|))

(|DDecl|
  |Struct-axextend-7|
  (|coerce-0| |Clos|)
  (|zero?-1| |Clos|)
  (|zero-2| |Clos|)
  (|one-3| |Clos|)
  (>=-4 |Clos|)
  (>-5 |Clos|)
  (<=-6 |Clos|)
  (<-7 |Clos|)
  (~=-8 |Clos|)
  (=-9 |Clos|)
  (*-10 |Clos|)
  (\--11 |Clos|)
  (\+-12 |Clos|)
  (|integer-13| |Clos|)
  (\-14 |SInt|))

(|DDecl|
  |Struct-axextend-8|
  (|rem-0| |Clos|)
  (|quo-1| |Clos|)
  (|zero?-2| |Clos|)
  (|zero-3| |Clos|)
  (|one-4| |Clos|)
  (|coerce-5| |Clos|)
  (|coerce-6| |Clos|)
  (|coerce-7| |Clos|)
  (|coerce-8| |Clos|)
  (>=-9 |Clos|)
  (>-10 |Clos|)
  (<=-11 |Clos|)
  (<-12 |Clos|)
  (~=-13 |Clos|)
  (=-14 |Clos|)
  (*-15 |Clos|)
  (\+-16 |Clos|)
  (\--17 |Clos|)
  (\--18 |Clos|)
  (|integer-19| |Clos|)
  (\-20 |SInt|))

(|DDecl|
  |Struct-axextend-9|
  (|mod-0| |Clos|)
  (|rem-1| |Clos|)
  (|quo-2| |Clos|)
  (>=-3 |Clos|)
  (<=-4 |Clos|)
  (>-5 |Clos|)
  (<-6 |Clos|)
  (=-7 |Clos|)
  (\--8 |Clos|)
  (*-9 |Clos|)
  (\+-10 |Clos|)
  (|zero?-11| |Clos|)
  (|zero-12| |Clos|)
  (|one-13| |Clos|)
  (|coerce-14| |Clos|)
  (|coerce-15| |Clos|)
  (|coerce-16| |Clos|)
  (|coerce-17| |Clos|)
  (\-18 |SInt|)
  (|coerce-19| |Clos|)
  (|dom-20| |Word|))

(|DDecl|
  |Struct-axextend-10|
  (|mod-0| |Clos|)
  (|rem-1| |Clos|)
  (|quo-2| |Clos|)
  (>=-3 |Clos|)
  (<=-4 |Clos|)
  (>-5 |Clos|)
  (<-6 |Clos|)
  (=-7 |Clos|)
  (\--8 |Clos|)
  (*-9 |Clos|)
  (\+-10 |Clos|)
  (|one-11| |Clos|)
  (|coerce-12| |Clos|)
  (|coerce-13| |Clos|)
  (|coerce-14| |Clos|)
  (|coerce-15| |Clos|)
  (|coerce-16| |Clos|)
  (|coerce-17| |Clos|)
  (\-18 |SInt|)
  (|coerce-19| |Clos|)
  (|dom-20| |Word|))

(|DDecl| |Struct-axextend-11| (|size-0| |SInt|) (|values-1| |Arr|))

(|DDecl| |Struct-axextend-12| (|found-0| |Word|) (|value-1| |Word|))

(|DDecl| |Struct-axextend-13| (|first-0| |Word|) (|rest-1| |Word|))

(|DDecl|
  |Struct-axextend-14|
  (|done?-0| |Clos|)
  (|step!-1| |Clos|)
  (|value-2| |Clos|)
  (|bound-3| |Clos|))

(|DDecl|
  |Struct-axextend-15|
  (|l-0| |Word|)
  (\-1 |Bool|)
  (\-2 |SInt|)
  (\-3 |Word|))

(|DDecl|
  |Struct-axextend-16|
  (|value-0| |Clos|)
  (|recptr-1| |Clos|)
  (|nil?-2| |Clos|)
  (\-3 |SInt|))

(|DDecl|
  |Struct-axextend-17|
  (|bracket-0| |Clos|)
  (|generator-1| |Clos|)
  (|reverse!-2| |Clos|)
  (|setRest!-3| |Clos|)
  (|setFirst!-4| |Clos|)
  (|rest-5| |Clos|)
  (|first-6| |Clos|)
  (|test-7| |Clos|)
  (|cons-8| |Clos|)
  (|empty-9| |Clos|)
  (|#-10| |Clos|)
  (|#-11| |Clos|)
  (|empty?-12| |Clos|)
  (|rec-13| |Clos|)
  (p-14 |Word|)
  (\-15 |SInt|))

(|DDecl| |Struct-axextend-18| (s-0 |Word|))

(|DDecl| |Struct-axextend-19| (s-0 |Word|))

(|DDecl|
  |Struct-axextend-20|
  (|v-0| |Word|)
  (|i-1| |Word|)
  (|n-2| |Word|)
  (\-3 |Bool|)
  (\-4 |SInt|)
  (\-5 |Word|))

(|DDecl|
  |Struct-axextend-22|
  (|set!-0| |Clos|)
  (|apply-1| |Clos|)
  (|#-2| |Clos|)
  (|generator-3| |Clos|)
  (|new-4| |Clos|)
  (|bracket-5| |Clos|)
  (|bracket-6| |Clos|)
  (\-7 |SInt|)
  (|first-8| |Clos|)
  (|rest-9| |Clos|)
  (|empty-10| |Clos|)
  (|cons-11| |Clos|)
  (|test-12| |Clos|)
  (|dom-13| |Word|))

(|DDecl| |Struct-axextend-23| (s-0 |Word|))

(|DDecl| |Struct-axextend-24| (s-0 |Word|))

(|DDecl|
  |Struct-axextend-25|
  (|qsetelt!-0| |Clos|)
  (|qelt-1| |Clos|)
  (|set!-2| |Clos|)
  (|apply-3| |Clos|)
  (\-4 |SInt|))

(|DDecl| |Struct-axextend-26| (r-0 |Word|))

(|DDecl| |Struct-axextend-27| (r-0 |Word|))

(|DDecl| |Struct-axextend-29| (s-0 |Word|))

(|DDecl|
  |Struct-axextend-31|
  (|low-0| |Word|)
  (|high-1| |Word|)
  (|incrz-2| |Word|))

(|DDecl|
  |Struct-axextend-32|
  (|x-0| |Word|)
  (|inc-1| |Word|)
  (|h-2| |Word|)
  (|l-3| |Word|)
  (\-4 |Bool|)
  (\-5 |SInt|)
  (\-6 |Word|))

(|DDecl|
  |Struct-axextend-33|
  (|generator-0| |Clos|)
  (\..-1 |Clos|)
  (|incrx-2| |Clos|)
  (|high-3| |Clos|)
  (|low-4| |Clos|)
  (|by-5| |Clos|)
  (|coerce-6| |Clos|)
  (\+-7 |Clos|)
  (>=-8 |Clos|)
  (<=-9 |Clos|)
  (\-10 |SInt|)
  (\-11 |SInt|)
  (|dom-12| |Word|))

(|DDecl| |Struct-axextend-34| (s-0 |Word|))

(|DDecl| |Struct-axextend-35| (s-0 |Word|))

(|DDecl|
  |Struct-axextend-37|
  (|low-0| |Word|)
  (|high-1| |Word|)
  (|incr-2| |Word|))

(|DDecl| |Struct-axextend-38| (|tag-0| |SInt|) (|value-1| |Word|))

(|DDecl| |Struct-axextend-39| (|low-0| |Word|) (|incr-1| |Word|))

(|DDecl|
  |Struct-axextend-40|
  (|x-0| |Word|)
  (|h-1| |Word|)
  (|inc-2| |Word|)
  (|l-3| |Word|)
  (\-4 |Bool|)
  (\-5 |SInt|)
  (\-6 |Word|))

(|DDecl|
  |Struct-axextend-41|
  (|generator-0| |Clos|)
  (|by-1| |Clos|)
  (|incr-2| |Clos|)
  (|high-3| |Clos|)
  (|low-4| |Clos|)
  (|hasHi-5| |Clos|)
  (\..-6 |Clos|)
  (\..-7 |Clos|)
  (|coerce-8| |Clos|)
  (\+-9 |Clos|)
  (>=-10 |Clos|)
  (<=-11 |Clos|)
  (<-12 |Clos|)
  (>=-13 |Clos|)
  (\-14 |SInt|)
  (\-15 |SInt|)
  (|dom-16| |Word|)
  (|dom-17| |Word|))

(|DDecl| |Struct-axextend-42| (s-0 |Word|))

(|DDecl| |Struct-axextend-43| (s-0 |Word|))

(|DDecl|
  |Struct-axextend-44|
  (|getter-0| |Clos|)
  (|flag-1| |Bool|)
  (|self-2| |Clos|))

(|DDecl|
  |Struct-axextend-45|
  (|Segment-0| |Clos|)
  (|Matrix-1| |Clos|)
  (|Vector-2| |Clos|)
  (|List-3| |Clos|)
  (|PositiveInteger-4| |Word|)
  (|NonNegativeInteger-5| |Word|)
  (|UniversalSegment-6| |Clos|)
  (|Integer-7| |Word|)
  (|SingleInteger-8| |Word|)
  (|Symbol-9| |Word|)
  (\-10 |Word|)
  (\-11 |Word|)
  (\-12 |Word|)
  (\-13 |Word|)
  (\-14 |Word|)
  (\-15 |Word|)
  (\-16 |Word|)
  (\-17 |Word|)
  (\-18 |Word|)
  (\-19 |Word|)
  (\-20 |Word|)
  (\-21 |Bool|)
  (\-22 |Bool|))

(|DDecl| |Struct-axextend-46| (|sz-0| |Word|) (|values-1| |Word|))

(defprog
  ((|C0-axextend-axextend|) ((|e1| |Env|)))
  ((t0 |Clos|)
    (t1 |Clos|)
    (t2 |Arr|)
    (t3 |Arr|)
    (t4 |Record|)
    (t5 |Record|)
    (|l0| |Level|)
    (|e0| |Env|))
  (setq
    |l0|
    (|MakeLevel| |MAKE-Struct-axextend-45| |Struct-axextend-45|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|CCall| |G-runtime|)
  (setq |G-axextend| |G-noOperation|)
  (setq t0 (|Clos| |e0| |C187-axextend-axlit-init|))
  (setq
    |G-axextend_Symbol_636926304|
    (|CCall| |G-domainMake| (|Clos| |e0| |C1-axextend-addLevel0|)))
  (setq
    |G-axextend_Symbol_209526317|
    (|CCall| |G-extendMake| (|Clos| |e0| |C4-axextend-extend0|)))
  (setq t1 (|Clos| |e0| |C186-axextend-axiom-init|))
  (setq
    |G-axextend_SingleInteger_302027834|
    (|CCall| |G-domainMake| (|Clos| |e0| |C5-axextend-addLevel0|)))
  (setq
    |G-axextend_SingleInteger_499971776|
    (|CCall| |G-extendMake| (|Clos| |e0| |C21-axextend-extend0|)))
  (setq
    |G-axextend_Integer_465677675|
    (|CCall| |G-domainMake| (|Clos| |e0| |C22-axextend-addLevel0|)))
  (setq
    |G-axextend_Integer_437506685|
    (|CCall| |G-extendMake| (|Clos| |e0| |C44-axextend-extend0|)))
  (setq
    |G-axextend_NonNegativeInteger_029131062|
    (|CCall| |G-domainMake| (|Clos| |e0| |C45-axextend-addLevel0|)))
  (setq
    |G-axextend_NonNegativeInteger_682440215|
    (|CCall| |G-extendMake| (|Clos| |e0| |C65-axextend-extend0|)))
  (setq
    |G-axextend_PositiveInteger_619949646|
    (|CCall| |G-domainMake| (|Clos| |e0| |C66-axextend-addLevel0|)))
  (setq
    |G-axextend_PositiveInteger_418138371|
    (|CCall| |G-extendMake| (|Clos| |e0| |C86-axextend-extend0|)))
  (|SetLex| |Struct-axextend-45--10| 10 |l0| nil)
  (setq |G-axextend_List_412811383| (|Clos| |e0| |C87-axextend-List|))
  (|SetLex| |Struct-axextend-45--11| 11 |l0| nil)
  (setq
    |G-axextend_List_134950155|
    (|Clos| |e0| |C114-axextend-axextend|))
  (|SetLex| |Struct-axextend-45--12| 12 |l0| nil)
  (setq
    |G-axextend_Vector_075828558|
    (|Clos| |e0| |C116-axextend-Vector|))
  (|SetLex| |Struct-axextend-45--13| 13 |l0| nil)
  (setq
    |G-axextend_Vector_052715942|
    (|Clos| |e0| |C131-axextend-axextend|))
  (|SetLex| |Struct-axextend-45--14| 14 |l0| nil)
  (setq
    |G-axextend_Matrix_057561278|
    (|Clos| |e0| |C133-axextend-Matrix|))
  (|SetLex| |Struct-axextend-45--15| 15 |l0| nil)
  (setq
    |G-axextend_Matrix_855611627|
    (|Clos| |e0| |C140-axextend-axextend|))
  (|SetLex| |Struct-axextend-45--16| 16 |l0| nil)
  (setq
    |G-axextend_GeneratorCategory_073559903|
    (|Clos| |e0| |C142-axextend-GeneratorCategory|))
  (|SetLex| |Struct-axextend-45--17| 17 |l0| nil)
  (setq
    |G-axextend_Segment_249071355|
    (|Clos| |e0| |C145-axextend-Segment|))
  (|SetLex| |Struct-axextend-45--18| 18 |l0| nil)
  (setq
    |G-axextend_Segment_557651354|
    (|Clos| |e0| |C161-axextend-axextend|))
  (|SetLex| |Struct-axextend-45--19| 19 |l0| nil)
  (setq
    |G-axextend_UniversalSegment_550108180|
    (|Clos| |e0| |C163-axextend-UniversalSegment|))
  (|SetLex| |Struct-axextend-45--20| 20 |l0| nil)
  (setq
    |G-axextend_UniversalSegment_408232398|
    (|Clos| |e0| |C181-axextend-axextend|))
  (|SetLex| |Struct-axextend-45--21| 21 |l0| (the |Bool| nil))
  (|SetLex| |Struct-axextend-45--22| 22 |l0| (the |Bool| nil))
  (setq t2 (|ANew| |Word| (the |SInt| 51)))
  (setq t3 (|ANew| |Word| (the |SInt| 51)))
  (|SetAElt| t2 (the |SInt| 0) (the |SInt| 51488814))
  (|SetAElt| t3 (the |SInt| 0) (|MakeLit| ".."))
  (|SetAElt| t2 (the |SInt| 1) (the |SInt| 495481649))
  (|SetAElt| t3 (the |SInt| 1) (|MakeLit| "incrx"))
  (|SetAElt| t2 (the |SInt| 2) (the |SInt| 581887332))
  (|SetAElt| t3 (the |SInt| 2) (|MakeLit| "zero"))
  (|SetAElt| t2 (the |SInt| 3) (the |SInt| 200083))
  (|SetAElt| t3 (the |SInt| 3) (|MakeLit| "*"))
  (|SetAElt| t2 (the |SInt| 4) (the |SInt| 200084))
  (|SetAElt| t3 (the |SInt| 4) (|MakeLit| "+"))
  (|SetAElt| t2 (the |SInt| 5) (the |SInt| 783695654))
  (|SetAElt| t3 (the |SInt| 5) (|MakeLit| "nil?"))
  (|SetAElt| t2 (the |SInt| 6) (the |SInt| 632239194))
  (|SetAElt| t3 (the |SInt| 6) (|MakeLit| "qelt"))
  (|SetAElt| t2 (the |SInt| 7) (the |SInt| 9730346))
  (|SetAElt| t3 (the |SInt| 7) (|MakeLit| "value"))
  (|SetAElt| t2 (the |SInt| 8) (the |SInt| 51500205))
  (|SetAElt| t3 (the |SInt| 8) (|MakeLit| "by"))
  (|SetAElt| t2 (the |SInt| 9) (the |SInt| 200086))
  (|SetAElt| t3 (the |SInt| 9) (|MakeLit| "-"))
  (|SetAElt| t2 (the |SInt| 10) (the |SInt| 76356179))
  (|SetAElt| t3 (the |SInt| 10) (|MakeLit| "setRest!"))
  (|SetAElt| t2 (the |SInt| 11) (the |SInt| 287357190))
  (|SetAElt| t3 (the |SInt| 11) (|MakeLit| "recptr"))
  (|SetAElt| t2 (the |SInt| 12) (the |SInt| 506619364))
  (|SetAElt| t3 (the |SInt| 12) (|MakeLit| "empty?"))
  (|SetAElt| t2 (the |SInt| 13) (the |SInt| 44638651))
  (|SetAElt| t3 (the |SInt| 13) (|MakeLit| "bracket"))
  (|SetAElt| t2 (the |SInt| 14) (the |SInt| 200101))
  (|SetAElt| t3 (the |SInt| 14) (|MakeLit| "<"))
  (|SetAElt| t2 (the |SInt| 15) (the |SInt| 318266239))
  (|SetAElt| t3 (the |SInt| 15) (|MakeLit| "rem"))
  (|SetAElt| t2 (the |SInt| 16) (the |SInt| 770345191))
  (|SetAElt| t3 (the |SInt| 16) (|MakeLit| "coerce"))
  (|SetAElt| t2 (the |SInt| 17) (the |SInt| 25941349))
  (|SetAElt| t3 (the |SInt| 17) (|MakeLit| "reverse!"))
  (|SetAElt| t2 (the |SInt| 18) (the |SInt| 200076))
  (|SetAElt| t3 (the |SInt| 18) (|MakeLit| "#"))
  (|SetAElt| t2 (the |SInt| 19) (the |SInt| 352145423))
  (|SetAElt| t3 (the |SInt| 19) (|MakeLit| "nilptr"))
  (|SetAElt| t2 (the |SInt| 20) (the |SInt| 682776373))
  (|SetAElt| t3 (the |SInt| 20) (|MakeLit| "first"))
  (|SetAElt| t2 (the |SInt| 21) (the |SInt| 51492941))
  (|SetAElt| t3 (the |SInt| 21) (|MakeLit| ">="))
  (|SetAElt| t2 (the |SInt| 22) (the |SInt| 715582562))
  (|SetAElt| t3 (the |SInt| 22) (|MakeLit| "rest"))
  (|SetAElt| t2 (the |SInt| 23) (the |SInt| 143562022))
  (|SetAElt| t3 (the |SInt| 23) (|MakeLit| "setFirst!"))
  (|SetAElt| t2 (the |SInt| 24) (the |SInt| 200089))
  (|SetAElt| t3 (the |SInt| 24) (|MakeLit| "0"))
  (|SetAElt| t2 (the |SInt| 25) (the |SInt| 865800279))
  (|SetAElt| t3 (the |SInt| 25) (|MakeLit| "cons"))
  (|SetAElt| t2 (the |SInt| 26) (the |SInt| 200102))
  (|SetAElt| t3 (the |SInt| 26) (|MakeLit| "="))
  (|SetAElt| t2 (the |SInt| 27) (the |SInt| 318396813))
  (|SetAElt| t3 (the |SInt| 27) (|MakeLit| "low"))
  (|SetAElt| t2 (the |SInt| 28) (the |SInt| 318204816))
  (|SetAElt| t3 (the |SInt| 28) (|MakeLit| "quo"))
  (|SetAElt| t2 (the |SInt| 29) (the |SInt| 5509732))
  (|SetAElt| t3 (the |SInt| 29) (|MakeLit| "test"))
  (|SetAElt| t2 (the |SInt| 30) (the |SInt| 200090))
  (|SetAElt| t3 (the |SInt| 30) (|MakeLit| "1"))
  (|SetAElt| t2 (the |SInt| 31) (the |SInt| 200103))
  (|SetAElt| t3 (the |SInt| 31) (|MakeLit| ">"))
  (|SetAElt| t2 (the |SInt| 32) (the |SInt| 680872954))
  (|SetAElt| t3 (the |SInt| 32) (|MakeLit| "hasHi"))
  (|SetAElt| t2 (the |SInt| 33) (the |SInt| 55906833))
  (|SetAElt| t3 (the |SInt| 33) (|MakeLit| "set!"))
  (|SetAElt| t2 (the |SInt| 34) (the |SInt| 318461307))
  (|SetAElt| t3 (the |SInt| 34) (|MakeLit| "mod"))
  (|SetAElt| t2 (the |SInt| 35) (the |SInt| 318266229))
  (|SetAElt| t3 (the |SInt| 35) (|MakeLit| "rec"))
  (|SetAElt| t2 (the |SInt| 36) (the |SInt| 477900237))
  (|SetAElt| t3 (the |SInt| 36) (|MakeLit| "integer"))
  (|SetAElt| t2 (the |SInt| 37) (the |SInt| 51509389))
  (|SetAElt| t3 (the |SInt| 37) (|MakeLit| "~="))
  (|SetAElt| t2 (the |SInt| 38) (the |SInt| 113320568))
  (|SetAElt| t3 (the |SInt| 38) (|MakeLit| "generator"))
  (|SetAElt| t2 (the |SInt| 39) (the |SInt| 318528389))
  (|SetAElt| t3 (the |SInt| 39) (|MakeLit| "new"))
  (|SetAElt| t2 (the |SInt| 40) (the |SInt| 357262396))
  (|SetAElt| t3 (the |SInt| 40) (|MakeLit| "empty"))
  (|SetAElt| t2 (the |SInt| 41) (the |SInt| 301553003))
  (|SetAElt| t3 (the |SInt| 41) (|MakeLit| "qsetelt!"))
  (|SetAElt| t2 (the |SInt| 42) (the |SInt| 318069373))
  (|SetAElt| t3 (the |SInt| 42) (|MakeLit| "one"))
  (|SetAElt| t2 (the |SInt| 43) (the |SInt| 206475020))
  (|SetAElt| t3 (the |SInt| 43) (|MakeLit| "zero?"))
  (|SetAElt| t2 (the |SInt| 44) (the |SInt| 585283853))
  (|SetAElt| t3 (the |SInt| 44) (|MakeLit| "string"))
  (|SetAElt| t2 (the |SInt| 45) (the |SInt| 766522704))
  (|SetAElt| t3 (the |SInt| 45) (|MakeLit| "incr"))
  (|SetAElt| t2 (the |SInt| 46) (the |SInt| 749482564))
  (|SetAElt| t3 (the |SInt| 46) (|MakeLit| "high"))
  (|SetAElt| t2 (the |SInt| 47) (the |SInt| 306472243))
  (|SetAElt| t3 (the |SInt| 47) (|MakeLit| "apply"))
  (|SetAElt| t2 (the |SInt| 48) (the |SInt| 318525310))
  (|SetAElt| t3 (the |SInt| 48) (|MakeLit| "nil"))
  (|SetAElt| t2 (the |SInt| 49) (the |SInt| 200121))
  (|SetAElt| t3 (the |SInt| 49) (|MakeLit| "P"))
  (|SetAElt| t2 (the |SInt| 50) (the |SInt| 51492427))
  (|SetAElt| t3 (the |SInt| 50) (|MakeLit| "<="))
  (setq t4 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t4 (the |SInt| 51))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t4 (the |SInt| 51))
  (|SetRElt| |Struct-axextend-5| |values| 2 t4 t2)
  (setq t5 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t5 (the |SInt| 51))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t5 (the |SInt| 51))
  (|SetRElt| |Struct-axextend-5| |values| 2 t5 t3)
  (|CCall| |G-rtAddStrings| t4 t5)
  (|SetLex|
    |Struct-axextend-45-Symbol-9|
    9
    |l0|
    (|CCall| |G-rtLazyDomFrInit| t0 (the |SInt| 1)))
  (|SetLex|
    |Struct-axextend-45-SingleInteger-8|
    8
    |l0|
    (|CCall| |G-rtLazyDomFrInit| t0 (the |SInt| 2)))
  (|SetLex|
    |Struct-axextend-45-Integer-7|
    7
    |l0|
    (|CCall| |G-rtLazyDomFrInit| t0 (the |SInt| 4)))
  (|SetLex|
    |Struct-axextend-45-NonNegativeInteger-5|
    5
    |l0|
    (|CCall| |G-rtLazyDomFrInit| t0 (the |SInt| 5)))
  (|SetLex|
    |Struct-axextend-45-PositiveInteger-4|
    4
    |l0|
    (|CCall| |G-rtLazyDomFrInit| t0 (the |SInt| 6)))
  (|SetProgHashCode|
    (|ClosFun| (|Clos| |e0| |C87-axextend-List|))
    (the |SInt| 144194112))
  (|SetLex|
    |Struct-axextend-45-List-3|
    3
    |l0|
    (|CCall|
      |G-stdGetWordRetWord0|
      (|CCall| |G-rtDelayedInit!| t0 (the |SInt| 7))))
  (|SetProgHashCode|
    (|ClosFun| (|Clos| |e0| |C114-axextend-axextend|))
    (the |SInt| 144194112))
  (|SetProgHashCode|
    (|ClosFun| (|Clos| |e0| |C116-axextend-Vector|))
    (the |SInt| 297027561))
  (|SetLex|
    |Struct-axextend-45-Vector-2|
    2
    |l0|
    (|CCall|
      |G-stdGetWordRetWord0|
      (|CCall| |G-rtDelayedInit!| t1 (the |SInt| 1))))
  (|SetProgHashCode|
    (|ClosFun| (|Clos| |e0| |C131-axextend-axextend|))
    (the |SInt| 297027561))
  (|SetProgHashCode|
    (|ClosFun| (|Clos| |e0| |C133-axextend-Matrix|))
    (the |SInt| 481767915))
  (|SetLex|
    |Struct-axextend-45-Matrix-1|
    1
    |l0|
    (|CCall|
      |G-stdGetWordRetWord0|
      (|CCall| |G-rtDelayedInit!| t1 (the |SInt| 2))))
  (|SetProgHashCode|
    (|ClosFun| (|Clos| |e0| |C140-axextend-axextend|))
    (the |SInt| 481767915))
  (|SetProgHashCode|
    (|ClosFun| (|Clos| |e0| |C142-axextend-GeneratorCategory|))
    (the |SInt| 780835038))
  (|SetLex|
    |Struct-axextend-45-Segment-0|
    0
    |l0|
    (|CCall|
      |G-stdGetWordRetWord0|
      (|CCall| |G-rtDelayedInit!| t1 (the |SInt| 5))))
  (|SetLex|
    |Struct-axextend-45-UniversalSegment-6|
    6
    |l0|
    (|CCall|
      |G-stdGetWordRetWord0|
      (|CCall| |G-rtDelayedInit!| t1 (the |SInt| 6))))
  (|SetProgHashCode|
    (|ClosFun| (|Clos| |e0| |C145-axextend-Segment|))
    (the |SInt| 924797874))
  (|SetProgHashCode|
    (|ClosFun| (|Clos| |e0| |C161-axextend-axextend|))
    (the |SInt| 924797874))
  (|SetProgHashCode|
    (|ClosFun| (|Clos| |e0| |C163-axextend-UniversalSegment|))
    (the |SInt| 956688668))
  (|SetProgHashCode|
    (|ClosFun| (|Clos| |e0| |C181-axextend-axextend|))
    (the |SInt| 956688668))
  (block-return |C0-axextend-axextend| ()))

(defprog
  ((|C1-axextend-addLevel0| |Clos|) ((|P0-domain| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| nil)
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|CCall|
    |G-domainAddNameFn!|
    |P0-domain|
    (|CCall| |G-rtConstNameFn| (|MakeLit| "Symbol")))
  (|CCall| |G-domainAddHash!| |P0-domain| (the |SInt| 162693356))
  (block-return
    |C1-axextend-addLevel0|
    (|Clos| |e0| |C2-axextend-addLevel1|)))

(defprog
  ((|C2-axextend-addLevel1| |Word|)
    ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Arr|)
    (t2 |Arr|)
    (t3 |Record|)
    (t4 |Record|)
    (t5 |Record|)
    (t6 |Word|)
    (t7 |SInt|)
    (t8 |SInt|)
    (|l0| |Level|)
    (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-axextend-6| |Struct-axextend-6|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq t0 (|ANew| |SInt| (the |SInt| 1)))
  (setq t1 (|ANew| |SInt| (the |SInt| 1)))
  (setq t2 (|ANew| |Word| (the |SInt| 1)))
  (setq t6 (|CCall| |G-domainMakeDispatch| |P0-domain|))
  (|SetLex| |Struct-axextend-6--2| 2 |l0| |P1-hashcode|)
  (|SetLex|
    |Struct-axextend-6-string-0|
    0
    |l0|
    (|Clos| |e0| |C3-axextend-string|))
  (setq
    t7
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-6--2| 2 |l0|)
      (the |SInt| 332724992)
      (the |SInt| 1073741789)))
  (setq
    t8
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-6--2| 2 |l0|)
      (the |SInt| 320473920)
      (the |SInt| 1073741789)))
  (setq t3 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t3 (the |SInt| 1))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t3 (the |SInt| 1))
  (|SetRElt| |Struct-axextend-5| |values| 2 t3 t0)
  (setq t4 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t4 (the |SInt| 1))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t4 (the |SInt| 1))
  (|SetRElt| |Struct-axextend-5| |values| 2 t4 t1)
  (setq t5 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t5 (the |SInt| 1))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t5 (the |SInt| 1))
  (|SetRElt| |Struct-axextend-5| |values| 2 t5 t2)
  (|CCall| |G-domainAddExports!| |P0-domain| t3 t4 t5)
  (|SetAElt| t0 (the |SInt| 0) (the |SInt| 585283853))
  (|SetAElt| t1 (the |SInt| 0) t7)
  (|SetAElt|
    t2
    (the |SInt| 0)
    (|Lex| |Struct-axextend-6-string-0| 0 |l0|))
  (|SetLex|
    |Struct-axextend-6-coerce-1|
    1
    |l0|
    (|CCall|
      |G-stdGetWordRetWord0|
      (|CCall| |G-rtDelayedGetExport!| t6 (the |SInt| 770345191) t8)))
  (block-return |C2-axextend-addLevel1| |P0-domain|))

(defprog
  ((|C3-axextend-string| |Word|) ((|P0-l| |Word|) (|e1| |Env|)))
  ((|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (block-return
    |C3-axextend-string|
    (|CCall|
      (|Lex| |Struct-axextend-6-coerce-1| 1 |l1|)
      (|AXL-LiteralToString| |P0-l|))))

(defprog
  ((|C4-axextend-extend0| |Clos|) ((|P0-domain| |Word|) (|e1| |Env|)))
  ((t0 |Arr|) (t1 |Record|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (setq t0 (|ANew| |Word| (the |SInt| 2)))
  (|SetAElt|
    t0
    (the |SInt| 1)
    (|Lex| |Struct-axextend-45-Symbol-9| 9 |l1|))
  (|SetAElt| t0 (the |SInt| 0) |G-axextend_Symbol_636926304|)
  (setq t1 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axextend-5| |values| 2 t1 t0)
  (|CCall| |G-extendFill!| |P0-domain| t1)
  (block-return |C4-axextend-extend0| |P0-domain|))

(defprog
  ((|C5-axextend-addLevel0| |Clos|) ((|P0-domain| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| nil)
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|CCall|
    |G-domainAddNameFn!|
    |P0-domain|
    (|CCall| |G-rtConstNameFn| (|MakeLit| "SingleInteger")))
  (|CCall| |G-domainAddHash!| |P0-domain| (the |SInt| 142471813))
  (block-return
    |C5-axextend-addLevel0|
    (|Clos| |e0| |C6-axextend-addLevel1|)))

(defprog
  ((|C6-axextend-addLevel1| |Word|)
    ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Arr|)
    (t2 |Arr|)
    (t3 |Record|)
    (t4 |Record|)
    (t5 |Record|)
    (t6 |SInt|)
    (t7 |SInt|)
    (t8 |SInt|)
    (t9 |SInt|)
    (t10 |SInt|)
    (t11 |SInt|)
    (t12 |SInt|)
    (t13 |SInt|)
    (t14 |SInt|)
    (t15 |SInt|)
    (t16 |SInt|)
    (|l0| |Level|)
    (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-axextend-7| |Struct-axextend-7|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq t0 (|ANew| |SInt| (the |SInt| 16)))
  (setq t1 (|ANew| |SInt| (the |SInt| 16)))
  (setq t2 (|ANew| |Word| (the |SInt| 16)))
  (|SetLex| |Struct-axextend-7--14| 14 |l0| |P1-hashcode|)
  (|SetLex|
    |Struct-axextend-7-integer-13|
    13
    |l0|
    (|Clos| |e0| |C7-axextend-integer|))
  (|SetLex|
    |Struct-axextend-7-+-12|
    12
    |l0|
    (|Clos| |e0| |C8-axextend-+|))
  (|SetLex|
    |Struct-axextend-7---11|
    11
    |l0|
    (|Clos| |e0| |C9-axextend--|))
  (|SetLex|
    |Struct-axextend-7-*-10|
    10
    |l0|
    (|Clos| |e0| |C10-axextend-*|))
  (|SetLex|
    |Struct-axextend-7-=-9|
    9
    |l0|
    (|Clos| |e0| |C11-axextend-=|))
  (|SetLex|
    |Struct-axextend-7-~=-8|
    8
    |l0|
    (|Clos| |e0| |C12-axextend-~=|))
  (|SetLex|
    |Struct-axextend-7-<-7|
    7
    |l0|
    (|Clos| |e0| |C13-axextend-<|))
  (|SetLex|
    |Struct-axextend-7-<=-6|
    6
    |l0|
    (|Clos| |e0| |C14-axextend-<=|))
  (|SetLex|
    |Struct-axextend-7->-5|
    5
    |l0|
    (|Clos| |e0| |C15-axextend->|))
  (|SetLex|
    |Struct-axextend-7->=-4|
    4
    |l0|
    (|Clos| |e0| |C16-axextend->=|))
  (|SetLex|
    |Struct-axextend-7-one-3|
    3
    |l0|
    (|Clos| |e0| |C17-axextend-one|))
  (|SetLex|
    |Struct-axextend-7-zero-2|
    2
    |l0|
    (|Clos| |e0| |C18-axextend-zero|))
  (|SetLex|
    |Struct-axextend-7-zero?-1|
    1
    |l0|
    (|Clos| |e0| |C19-axextend-zero?|))
  (|SetLex|
    |Struct-axextend-7-coerce-0|
    0
    |l0|
    (|Clos| |e0| |C20-axextend-coerce|))
  (setq
    t6
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-7--14| 14 |l0|)
      (the |SInt| 332724992)
      (the |SInt| 1073741789)))
  (setq
    t11
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-7--14| 14 |l0|)
      (the |SInt| 74075968)
      (the |SInt| 1073741789)))
  (setq t12 (|SIntAnd| t11 (the |SInt| 16777215)))
  (setq t13 (|SIntShiftUp| t12 (the |SInt| 6)))
  (setq
    t14
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-7--14| 14 |l0|)
      t13
      (the |SInt| 1073741789)))
  (setq t15 (|SIntAnd| t14 (the |SInt| 16777215)))
  (setq t16 (|SIntShiftUp| t15 (the |SInt| 6)))
  (setq
    t7
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-7--14| 14 |l0|)
      t16
      (the |SInt| 1073741789)))
  (setq
    t8
    (|SIntPlusMod| (the |SInt| 740244383) t16 (the |SInt| 1073741789)))
  (setq
    t9
    (|SIntPlusMod| (the |SInt| 740244383) t13 (the |SInt| 1073741789)))
  (setq t10 (|Lex| |Struct-axextend-7--14| 14 |l0|))
  (setq t3 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t3 (the |SInt| 16))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t3 (the |SInt| 16))
  (|SetRElt| |Struct-axextend-5| |values| 2 t3 t0)
  (setq t4 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t4 (the |SInt| 16))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t4 (the |SInt| 16))
  (|SetRElt| |Struct-axextend-5| |values| 2 t4 t1)
  (setq t5 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t5 (the |SInt| 16))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t5 (the |SInt| 16))
  (|SetRElt| |Struct-axextend-5| |values| 2 t5 t2)
  (|CCall| |G-domainAddExports!| |P0-domain| t3 t4 t5)
  (|SetAElt| t0 (the |SInt| 0) (the |SInt| 477900237))
  (|SetAElt| t1 (the |SInt| 0) t6)
  (|SetAElt|
    t2
    (the |SInt| 0)
    (|Lex| |Struct-axextend-7-integer-13| 13 |l0|))
  (|SetAElt| t0 (the |SInt| 1) (the |SInt| 200084))
  (|SetAElt| t1 (the |SInt| 1) t7)
  (|SetAElt|
    t2
    (the |SInt| 1)
    (|Lex| |Struct-axextend-7-+-12| 12 |l0|))
  (|SetAElt| t0 (the |SInt| 2) (the |SInt| 200086))
  (|SetAElt| t1 (the |SInt| 2) t7)
  (|SetAElt|
    t2
    (the |SInt| 2)
    (|Lex| |Struct-axextend-7---11| 11 |l0|))
  (|SetAElt| t0 (the |SInt| 3) (the |SInt| 200083))
  (|SetAElt| t1 (the |SInt| 3) t7)
  (|SetAElt|
    t2
    (the |SInt| 3)
    (|Lex| |Struct-axextend-7-*-10| 10 |l0|))
  (|SetAElt| t0 (the |SInt| 4) (the |SInt| 200102))
  (|SetAElt| t1 (the |SInt| 4) t8)
  (|SetAElt|
    t2
    (the |SInt| 4)
    (|Lex| |Struct-axextend-7-=-9| 9 |l0|))
  (|SetAElt| t0 (the |SInt| 5) (the |SInt| 51509389))
  (|SetAElt| t1 (the |SInt| 5) t8)
  (|SetAElt|
    t2
    (the |SInt| 5)
    (|Lex| |Struct-axextend-7-~=-8| 8 |l0|))
  (|SetAElt| t0 (the |SInt| 6) (the |SInt| 200101))
  (|SetAElt| t1 (the |SInt| 6) t8)
  (|SetAElt|
    t2
    (the |SInt| 6)
    (|Lex| |Struct-axextend-7-<-7| 7 |l0|))
  (|SetAElt| t0 (the |SInt| 7) (the |SInt| 51492427))
  (|SetAElt| t1 (the |SInt| 7) t8)
  (|SetAElt|
    t2
    (the |SInt| 7)
    (|Lex| |Struct-axextend-7-<=-6| 6 |l0|))
  (|SetAElt| t0 (the |SInt| 8) (the |SInt| 200103))
  (|SetAElt| t1 (the |SInt| 8) t8)
  (|SetAElt|
    t2
    (the |SInt| 8)
    (|Lex| |Struct-axextend-7->-5| 5 |l0|))
  (|SetAElt| t0 (the |SInt| 9) (the |SInt| 51492941))
  (|SetAElt| t1 (the |SInt| 9) t8)
  (|SetAElt|
    t2
    (the |SInt| 9)
    (|Lex| |Struct-axextend-7->=-4| 4 |l0|))
  (|SetAElt| t0 (the |SInt| 10) (the |SInt| 318069373))
  (|SetAElt| t1 (the |SInt| 10) t11)
  (|SetAElt|
    t2
    (the |SInt| 10)
    (|Lex| |Struct-axextend-7-one-3| 3 |l0|))
  (|SetAElt| t0 (the |SInt| 11) (the |SInt| 581887332))
  (|SetAElt| t1 (the |SInt| 11) t11)
  (|SetAElt|
    t2
    (the |SInt| 11)
    (|Lex| |Struct-axextend-7-zero-2| 2 |l0|))
  (|SetAElt| t0 (the |SInt| 12) (the |SInt| 206475020))
  (|SetAElt| t1 (the |SInt| 12) t9)
  (|SetAElt|
    t2
    (the |SInt| 12)
    (|Lex| |Struct-axextend-7-zero?-1| 1 |l0|))
  (|SetAElt| t0 (the |SInt| 13) (the |SInt| 770345191))
  (|SetAElt|
    t1
    (the |SInt| 13)
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-7--14| 14 |l0|)
      (the |SInt| 296696640)
      (the |SInt| 1073741789)))
  (|SetAElt|
    t2
    (the |SInt| 13)
    (|Lex| |Struct-axextend-7-coerce-0| 0 |l0|))
  (|SetAElt| t0 (the |SInt| 14) (the |SInt| 200090))
  (|SetAElt| t1 (the |SInt| 14) t10)
  (|SetAElt| t2 (the |SInt| 14) (the |SInt| 1))
  (|SetAElt| t0 (the |SInt| 15) (the |SInt| 200089))
  (|SetAElt| t1 (the |SInt| 15) t10)
  (|SetAElt| t2 (the |SInt| 15) (the |SInt| 0))
  (block-return |C6-axextend-addLevel1| |P0-domain|))

(defprog
  ((|C7-axextend-integer| |Word|) ((|P0-l| |Word|) (|e1| |Env|)))
  ()
  (block-return |C7-axextend-integer| (|ArrToSInt| |P0-l|)))

(defprog
  ((|C8-axextend-+| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C8-axextend-+| (|SIntPlus| |P0-a| |P1-b|)))

(defprog
  ((|C9-axextend--| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C9-axextend--| (|SIntMinus| |P0-a| |P1-b|)))

(defprog
  ((|C10-axextend-*| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C10-axextend-*| (|SIntTimes| |P0-a| |P1-b|)))

(defprog
  ((|C11-axextend-=| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C11-axextend-=| (|SIntEQ| |P0-a| |P1-b|)))

(defprog
  ((|C12-axextend-~=| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C12-axextend-~=| (|SIntNE| |P0-a| |P1-b|)))

(defprog
  ((|C13-axextend-<| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C13-axextend-<| (|SIntLT| |P0-a| |P1-b|)))

(defprog
  ((|C14-axextend-<=| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C14-axextend-<=| (|SIntLE| |P0-a| |P1-b|)))

(defprog
  ((|C15-axextend->| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C15-axextend->| (|SIntLT| |P1-b| |P0-a|)))

(defprog
  ((|C16-axextend->=| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C16-axextend->=| (|BoolNot| (|SIntLT| |P0-a| |P1-b|))))

(defprog
  ((|C17-axextend-one| |Word|) ((|e1| |Env|)))
  ()
  (block-return |C17-axextend-one| (the |SInt| 1)))

(defprog
  ((|C18-axextend-zero| |Word|) ((|e1| |Env|)))
  ()
  (block-return |C18-axextend-zero| (the |SInt| 0)))

(defprog
  ((|C19-axextend-zero?| |Word|) ((|P0-n| |Word|) (|e1| |Env|)))
  ()
  (block-return |C19-axextend-zero?| (|SIntIsZero| |P0-n|)))

(defprog
  ((|C20-axextend-coerce| |Word|) ((|P0-n| |Word|) (|e1| |Env|)))
  ((t0 |SInt|) (t1 |Word|))
  (tagbody
    (when (|BIntLT| (|SIntToBInt| (|SIntMax|)) |P0-n|) (go |Lab1|))
    (when (|BIntLT| |P0-n| (|SIntToBInt| (|SIntMin|))) (go |Lab1|))
    (setq t0 (|BIntToSInt| |P0-n|))
    |Lab0|
    (block-return |C20-axextend-coerce| t0)
    |Lab1|
    (setq
      t1
      (|AXL-LiteralToString|
        (|MakeLit| "Integer too big to fit in a SingleInteger")))
    (|AXL-error| t1)
    (go |Lab0|)))

(defprog
  ((|C21-axextend-extend0| |Clos|) ((|P0-domain| |Word|) (|e1| |Env|)))
  ((t0 |Arr|) (t1 |Record|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (setq t0 (|ANew| |Word| (the |SInt| 2)))
  (|SetAElt|
    t0
    (the |SInt| 1)
    (|Lex| |Struct-axextend-45-SingleInteger-8| 8 |l1|))
  (|SetAElt| t0 (the |SInt| 0) |G-axextend_SingleInteger_302027834|)
  (setq t1 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axextend-5| |values| 2 t1 t0)
  (|CCall| |G-extendFill!| |P0-domain| t1)
  (block-return |C21-axextend-extend0| |P0-domain|))

(defprog
  ((|C22-axextend-addLevel0| |Clos|)
    ((|P0-domain| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| nil)
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|CCall|
    |G-domainAddNameFn!|
    |P0-domain|
    (|CCall| |G-rtConstNameFn| (|MakeLit| "Integer")))
  (|CCall| |G-domainAddHash!| |P0-domain| (the |SInt| 484208045))
  (block-return
    |C22-axextend-addLevel0|
    (|Clos| |e0| |C23-axextend-addLevel1|)))

(defprog
  ((|C23-axextend-addLevel1| |Word|)
    ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Arr|)
    (t2 |Arr|)
    (t3 |Record|)
    (t4 |Record|)
    (t5 |Record|)
    (t6 |SInt|)
    (t7 |SInt|)
    (t8 |SInt|)
    (t9 |SInt|)
    (t10 |SInt|)
    (t11 |SInt|)
    (t12 |SInt|)
    (t13 |SInt|)
    (t14 |SInt|)
    (t15 |SInt|)
    (t16 |SInt|)
    (|l0| |Level|)
    (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-axextend-8| |Struct-axextend-8|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq t0 (|ANew| |SInt| (the |SInt| 22)))
  (setq t1 (|ANew| |SInt| (the |SInt| 22)))
  (setq t2 (|ANew| |Word| (the |SInt| 22)))
  (|SetLex| |Struct-axextend-8--20| 20 |l0| |P1-hashcode|)
  (|SetLex|
    |Struct-axextend-8-integer-19|
    19
    |l0|
    (|Clos| |e0| |C24-axextend-integer|))
  (|SetLex|
    |Struct-axextend-8---17|
    17
    |l0|
    (|Clos| |e0| |C25-axextend--|))
  (|SetLex|
    |Struct-axextend-8-+-16|
    16
    |l0|
    (|Clos| |e0| |C26-axextend-+|))
  (|SetLex|
    |Struct-axextend-8---18|
    18
    |l0|
    (|Clos| |e0| |C27-axextend--|))
  (|SetLex|
    |Struct-axextend-8-*-15|
    15
    |l0|
    (|Clos| |e0| |C28-axextend-*|))
  (|SetLex|
    |Struct-axextend-8-=-14|
    14
    |l0|
    (|Clos| |e0| |C29-axextend-=|))
  (|SetLex|
    |Struct-axextend-8-~=-13|
    13
    |l0|
    (|Clos| |e0| |C30-axextend-~=|))
  (|SetLex|
    |Struct-axextend-8-<-12|
    12
    |l0|
    (|Clos| |e0| |C31-axextend-<|))
  (|SetLex|
    |Struct-axextend-8-<=-11|
    11
    |l0|
    (|Clos| |e0| |C32-axextend-<=|))
  (|SetLex|
    |Struct-axextend-8->-10|
    10
    |l0|
    (|Clos| |e0| |C33-axextend->|))
  (|SetLex|
    |Struct-axextend-8->=-9|
    9
    |l0|
    (|Clos| |e0| |C34-axextend->=|))
  (|SetLex|
    |Struct-axextend-8-coerce-5|
    5
    |l0|
    (|Clos| |e0| |C35-axextend-coerce|))
  (|SetLex|
    |Struct-axextend-8-coerce-6|
    6
    |l0|
    (|Clos| |e0| |C36-axextend-coerce|))
  (|SetLex|
    |Struct-axextend-8-coerce-7|
    7
    |l0|
    (|Clos| |e0| |C37-axextend-coerce|))
  (|SetLex|
    |Struct-axextend-8-coerce-8|
    8
    |l0|
    (|Clos| |e0| |C38-axextend-coerce|))
  (|SetLex|
    |Struct-axextend-8-one-4|
    4
    |l0|
    (|Clos| |e0| |C39-axextend-one|))
  (|SetLex|
    |Struct-axextend-8-zero-3|
    3
    |l0|
    (|Clos| |e0| |C40-axextend-zero|))
  (|SetLex|
    |Struct-axextend-8-zero?-2|
    2
    |l0|
    (|Clos| |e0| |C41-axextend-zero?|))
  (|SetLex|
    |Struct-axextend-8-quo-1|
    1
    |l0|
    (|Clos| |e0| |C42-axextend-quo|))
  (|SetLex|
    |Struct-axextend-8-rem-0|
    0
    |l0|
    (|Clos| |e0| |C43-axextend-rem|))
  (setq
    t6
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-8--20| 20 |l0|)
      (the |SInt| 332724992)
      (the |SInt| 1073741789)))
  (setq
    t11
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-8--20| 20 |l0|)
      (the |SInt| 74075968)
      (the |SInt| 1073741789)))
  (setq t12 (|SIntAnd| t11 (the |SInt| 16777215)))
  (setq t13 (|SIntShiftUp| t12 (the |SInt| 6)))
  (setq
    t14
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-8--20| 20 |l0|)
      t13
      (the |SInt| 1073741789)))
  (setq t15 (|SIntAnd| t14 (the |SInt| 16777215)))
  (setq t16 (|SIntShiftUp| t15 (the |SInt| 6)))
  (setq
    t7
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-8--20| 20 |l0|)
      t16
      (the |SInt| 1073741789)))
  (setq
    t8
    (|SIntPlusMod| (the |SInt| 740244383) t16 (the |SInt| 1073741789)))
  (setq
    t9
    (|SIntPlusMod| (the |SInt| 740244383) t13 (the |SInt| 1073741789)))
  (setq t10 (|Lex| |Struct-axextend-8--20| 20 |l0|))
  (setq t3 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t3 (the |SInt| 22))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t3 (the |SInt| 22))
  (|SetRElt| |Struct-axextend-5| |values| 2 t3 t0)
  (setq t4 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t4 (the |SInt| 22))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t4 (the |SInt| 22))
  (|SetRElt| |Struct-axextend-5| |values| 2 t4 t1)
  (setq t5 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t5 (the |SInt| 22))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t5 (the |SInt| 22))
  (|SetRElt| |Struct-axextend-5| |values| 2 t5 t2)
  (|CCall| |G-domainAddExports!| |P0-domain| t3 t4 t5)
  (|SetAElt| t0 (the |SInt| 0) (the |SInt| 477900237))
  (|SetAElt| t1 (the |SInt| 0) t6)
  (|SetAElt|
    t2
    (the |SInt| 0)
    (|Lex| |Struct-axextend-8-integer-19| 19 |l0|))
  (|SetAElt| t0 (the |SInt| 1) (the |SInt| 200086))
  (|SetAElt| t1 (the |SInt| 1) t14)
  (|SetAElt|
    t2
    (the |SInt| 1)
    (|Lex| |Struct-axextend-8---17| 17 |l0|))
  (|SetAElt| t0 (the |SInt| 2) (the |SInt| 200084))
  (|SetAElt| t1 (the |SInt| 2) t7)
  (|SetAElt|
    t2
    (the |SInt| 2)
    (|Lex| |Struct-axextend-8-+-16| 16 |l0|))
  (|SetAElt| t0 (the |SInt| 3) (the |SInt| 200086))
  (|SetAElt| t1 (the |SInt| 3) t7)
  (|SetAElt|
    t2
    (the |SInt| 3)
    (|Lex| |Struct-axextend-8---18| 18 |l0|))
  (|SetAElt| t0 (the |SInt| 4) (the |SInt| 200083))
  (|SetAElt| t1 (the |SInt| 4) t7)
  (|SetAElt|
    t2
    (the |SInt| 4)
    (|Lex| |Struct-axextend-8-*-15| 15 |l0|))
  (|SetAElt| t0 (the |SInt| 5) (the |SInt| 200102))
  (|SetAElt| t1 (the |SInt| 5) t8)
  (|SetAElt|
    t2
    (the |SInt| 5)
    (|Lex| |Struct-axextend-8-=-14| 14 |l0|))
  (|SetAElt| t0 (the |SInt| 6) (the |SInt| 51509389))
  (|SetAElt| t1 (the |SInt| 6) t8)
  (|SetAElt|
    t2
    (the |SInt| 6)
    (|Lex| |Struct-axextend-8-~=-13| 13 |l0|))
  (|SetAElt| t0 (the |SInt| 7) (the |SInt| 200101))
  (|SetAElt| t1 (the |SInt| 7) t8)
  (|SetAElt|
    t2
    (the |SInt| 7)
    (|Lex| |Struct-axextend-8-<-12| 12 |l0|))
  (|SetAElt| t0 (the |SInt| 8) (the |SInt| 51492427))
  (|SetAElt| t1 (the |SInt| 8) t8)
  (|SetAElt|
    t2
    (the |SInt| 8)
    (|Lex| |Struct-axextend-8-<=-11| 11 |l0|))
  (|SetAElt| t0 (the |SInt| 9) (the |SInt| 200103))
  (|SetAElt| t1 (the |SInt| 9) t8)
  (|SetAElt|
    t2
    (the |SInt| 9)
    (|Lex| |Struct-axextend-8->-10| 10 |l0|))
  (|SetAElt| t0 (the |SInt| 10) (the |SInt| 51492941))
  (|SetAElt| t1 (the |SInt| 10) t8)
  (|SetAElt|
    t2
    (the |SInt| 10)
    (|Lex| |Struct-axextend-8->=-9| 9 |l0|))
  (|SetAElt| t0 (the |SInt| 11) (the |SInt| 770345191))
  (|SetAElt|
    t1
    (the |SInt| 11)
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-8--20| 20 |l0|)
      (the |SInt| 974156096)
      (the |SInt| 1073741789)))
  (|SetAElt|
    t2
    (the |SInt| 11)
    (|Lex| |Struct-axextend-8-coerce-5| 5 |l0|))
  (|SetAElt| t0 (the |SInt| 12) (the |SInt| 770345191))
  (|SetAElt| t1 (the |SInt| 12) t14)
  (|SetAElt|
    t2
    (the |SInt| 12)
    (|Lex| |Struct-axextend-8-coerce-6| 6 |l0|))
  (|SetAElt| t0 (the |SInt| 13) (the |SInt| 770345191))
  (|SetAElt| t1 (the |SInt| 13) t14)
  (|SetAElt|
    t2
    (the |SInt| 13)
    (|Lex| |Struct-axextend-8-coerce-7| 7 |l0|))
  (|SetAElt| t0 (the |SInt| 14) (the |SInt| 770345191))
  (|SetAElt| t1 (the |SInt| 14) t14)
  (|SetAElt|
    t2
    (the |SInt| 14)
    (|Lex| |Struct-axextend-8-coerce-8| 8 |l0|))
  (|SetAElt| t0 (the |SInt| 15) (the |SInt| 318069373))
  (|SetAElt| t1 (the |SInt| 15) t11)
  (|SetAElt|
    t2
    (the |SInt| 15)
    (|Lex| |Struct-axextend-8-one-4| 4 |l0|))
  (|SetAElt| t0 (the |SInt| 16) (the |SInt| 581887332))
  (|SetAElt| t1 (the |SInt| 16) t11)
  (|SetAElt|
    t2
    (the |SInt| 16)
    (|Lex| |Struct-axextend-8-zero-3| 3 |l0|))
  (|SetAElt| t0 (the |SInt| 17) (the |SInt| 206475020))
  (|SetAElt| t1 (the |SInt| 17) t9)
  (|SetAElt|
    t2
    (the |SInt| 17)
    (|Lex| |Struct-axextend-8-zero?-2| 2 |l0|))
  (|SetAElt| t0 (the |SInt| 18) (the |SInt| 318204816))
  (|SetAElt| t1 (the |SInt| 18) t7)
  (|SetAElt|
    t2
    (the |SInt| 18)
    (|Lex| |Struct-axextend-8-quo-1| 1 |l0|))
  (|SetAElt| t0 (the |SInt| 19) (the |SInt| 318266239))
  (|SetAElt| t1 (the |SInt| 19) t7)
  (|SetAElt|
    t2
    (the |SInt| 19)
    (|Lex| |Struct-axextend-8-rem-0| 0 |l0|))
  (|SetAElt| t0 (the |SInt| 20) (the |SInt| 200090))
  (|SetAElt| t1 (the |SInt| 20) t10)
  (|SetAElt| t2 (the |SInt| 20) (the |BInt| 1))
  (|SetAElt| t0 (the |SInt| 21) (the |SInt| 200089))
  (|SetAElt| t1 (the |SInt| 21) t10)
  (|SetAElt| t2 (the |SInt| 21) (the |BInt| 0))
  (block-return |C23-axextend-addLevel1| |P0-domain|))

(defprog
  ((|C24-axextend-integer| |Word|) ((|P0-l| |Word|) (|e1| |Env|)))
  ()
  (block-return |C24-axextend-integer| (|ArrToBInt| |P0-l|)))

(defprog
  ((|C25-axextend--| |Word|) ((|P0-a| |Word|) (|e1| |Env|)))
  ()
  (block-return |C25-axextend--| (|BIntNegate| |P0-a|)))

(defprog
  ((|C26-axextend-+| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C26-axextend-+| (|BIntPlus| |P0-a| |P1-b|)))

(defprog
  ((|C27-axextend--| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C27-axextend--| (|BIntMinus| |P0-a| |P1-b|)))

(defprog
  ((|C28-axextend-*| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C28-axextend-*| (|BIntTimes| |P0-a| |P1-b|)))

(defprog
  ((|C29-axextend-=| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C29-axextend-=| (|BIntEQ| |P0-a| |P1-b|)))

(defprog
  ((|C30-axextend-~=| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C30-axextend-~=| (|BIntNE| |P0-a| |P1-b|)))

(defprog
  ((|C31-axextend-<| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C31-axextend-<| (|BIntLT| |P0-a| |P1-b|)))

(defprog
  ((|C32-axextend-<=| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C32-axextend-<=| (|BIntLE| |P0-a| |P1-b|)))

(defprog
  ((|C33-axextend->| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C33-axextend->| (|BIntLT| |P1-b| |P0-a|)))

(defprog
  ((|C34-axextend->=| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C34-axextend->=| (|BoolNot| (|BIntLT| |P0-a| |P1-b|))))

(defprog
  ((|C35-axextend-coerce| |Word|) ((|P0-n| |Word|) (|e1| |Env|)))
  ()
  (block-return |C35-axextend-coerce| (|SIntToBInt| |P0-n|)))

(defprog
  ((|C36-axextend-coerce| |Word|) ((|P0-i| |Word|) (|e1| |Env|)))
  ()
  (block-return |C36-axextend-coerce| |P0-i|))

(defprog
  ((|C37-axextend-coerce| |Word|) ((|P0-i| |Word|) (|e1| |Env|)))
  ()
  (block-return |C37-axextend-coerce| |P0-i|))

(defprog
  ((|C38-axextend-coerce| |Word|) ((|P0-i| |Word|) (|e1| |Env|)))
  ()
  (block-return |C38-axextend-coerce| |P0-i|))

(defprog
  ((|C39-axextend-one| |Word|) ((|e1| |Env|)))
  ()
  (block-return |C39-axextend-one| (the |BInt| 1)))

(defprog
  ((|C40-axextend-zero| |Word|) ((|e1| |Env|)))
  ()
  (block-return |C40-axextend-zero| (the |BInt| 0)))

(defprog
  ((|C41-axextend-zero?| |Word|) ((|P0-x| |Word|) (|e1| |Env|)))
  ()
  (block-return |C41-axextend-zero?| (|BIntIsZero| |P0-x|)))

(defprog
  ((|C42-axextend-quo| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C42-axextend-quo| (|BIntQuo| |P0-a| |P1-b|)))

(defprog
  ((|C43-axextend-rem| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C43-axextend-rem| (|BIntRem| |P0-a| |P1-b|)))

(defprog
  ((|C44-axextend-extend0| |Clos|) ((|P0-domain| |Word|) (|e1| |Env|)))
  ((t0 |Arr|) (t1 |Record|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (setq t0 (|ANew| |Word| (the |SInt| 2)))
  (|SetAElt|
    t0
    (the |SInt| 1)
    (|Lex| |Struct-axextend-45-Integer-7| 7 |l1|))
  (|SetAElt| t0 (the |SInt| 0) |G-axextend_Integer_465677675|)
  (setq t1 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axextend-5| |values| 2 t1 t0)
  (|CCall| |G-extendFill!| |P0-domain| t1)
  (block-return |C44-axextend-extend0| |P0-domain|))

(defprog
  ((|C45-axextend-addLevel0| |Clos|)
    ((|P0-domain| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| nil)
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|CCall|
    |G-domainAddNameFn!|
    |P0-domain|
    (|CCall| |G-rtConstNameFn| (|MakeLit| "NonNegativeInteger")))
  (|CCall| |G-domainAddHash!| |P0-domain| (the |SInt| 172927374))
  (block-return
    |C45-axextend-addLevel0|
    (|Clos| |e0| |C46-axextend-addLevel1|)))

(defprog
  ((|C46-axextend-addLevel1| |Word|)
    ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Arr|)
    (t2 |Arr|)
    (t3 |Record|)
    (t4 |Record|)
    (t5 |Record|)
    (t6 |SInt|)
    (t7 |SInt|)
    (t8 |SInt|)
    (t9 |SInt|)
    (t10 |SInt|)
    (t11 |SInt|)
    (t12 |SInt|)
    (t13 |SInt|)
    (t14 |SInt|)
    (t15 |SInt|)
    (t16 |SInt|)
    (t17 |SInt|)
    (t18 |SInt|)
    (|l0| |Level|)
    (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-axextend-9| |Struct-axextend-9|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq t0 (|ANew| |SInt| (the |SInt| 20)))
  (setq t1 (|ANew| |SInt| (the |SInt| 20)))
  (setq t2 (|ANew| |Word| (the |SInt| 20)))
  (|SetLex| |Struct-axextend-9--18| 18 |l0| |P1-hashcode|)
  (|SetLex|
    |Struct-axextend-9-coerce-14|
    14
    |l0|
    (|Clos| |e0| |C47-axextend-coerce|))
  (|SetLex|
    |Struct-axextend-9-coerce-15|
    15
    |l0|
    (|Clos| |e0| |C48-axextend-coerce|))
  (|SetLex|
    |Struct-axextend-9-coerce-16|
    16
    |l0|
    (|Clos| |e0| |C49-axextend-coerce|))
  (|SetLex|
    |Struct-axextend-9-coerce-17|
    17
    |l0|
    (|Clos| |e0| |C50-axextend-coerce|))
  (|SetLex|
    |Struct-axextend-9-one-13|
    13
    |l0|
    (|Clos| |e0| |C51-axextend-one|))
  (|SetLex|
    |Struct-axextend-9-zero-12|
    12
    |l0|
    (|Clos| |e0| |C52-axextend-zero|))
  (|SetLex|
    |Struct-axextend-9-zero?-11|
    11
    |l0|
    (|Clos| |e0| |C53-axextend-zero?|))
  (|SetLex|
    |Struct-axextend-9-+-10|
    10
    |l0|
    (|Clos| |e0| |C54-axextend-+|))
  (|SetLex|
    |Struct-axextend-9-*-9|
    9
    |l0|
    (|Clos| |e0| |C55-axextend-*|))
  (|SetLex|
    |Struct-axextend-9---8|
    8
    |l0|
    (|Clos| |e0| |C56-axextend--|))
  (|SetLex|
    |Struct-axextend-9-=-7|
    7
    |l0|
    (|Clos| |e0| |C57-axextend-=|))
  (|SetLex|
    |Struct-axextend-9-<-6|
    6
    |l0|
    (|Clos| |e0| |C58-axextend-<|))
  (|SetLex|
    |Struct-axextend-9->-5|
    5
    |l0|
    (|Clos| |e0| |C59-axextend->|))
  (|SetLex|
    |Struct-axextend-9-<=-4|
    4
    |l0|
    (|Clos| |e0| |C60-axextend-<=|))
  (|SetLex|
    |Struct-axextend-9->=-3|
    3
    |l0|
    (|Clos| |e0| |C61-axextend->=|))
  (|SetLex|
    |Struct-axextend-9-quo-2|
    2
    |l0|
    (|Clos| |e0| |C62-axextend-quo|))
  (|SetLex|
    |Struct-axextend-9-rem-1|
    1
    |l0|
    (|Clos| |e0| |C63-axextend-rem|))
  (|SetLex|
    |Struct-axextend-9-mod-0|
    0
    |l0|
    (|Clos| |e0| |C64-axextend-mod|))
  (setq
    t10
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-9--18| 18 |l0|)
      (the |SInt| 74075968)
      (the |SInt| 1073741789)))
  (setq t11 (|SIntAnd| t10 (the |SInt| 16777215)))
  (setq t12 (|SIntShiftUp| t11 (the |SInt| 6)))
  (setq
    t6
    (|SIntPlusMod| (the |SInt| 740244383) t12 (the |SInt| 1073741789)))
  (setq
    t13
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-9--18| 18 |l0|)
      t12
      (the |SInt| 1073741789)))
  (setq t14 (|SIntAnd| t13 (the |SInt| 16777215)))
  (setq t15 (|SIntShiftUp| t14 (the |SInt| 6)))
  (setq
    t7
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-9--18| 18 |l0|)
      t15
      (the |SInt| 1073741789)))
  (setq
    t8
    (|SIntPlusMod| (the |SInt| 740244383) t15 (the |SInt| 1073741789)))
  (setq t9 (|Lex| |Struct-axextend-9--18| 18 |l0|))
  (setq t3 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t3 (the |SInt| 20))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t3 (the |SInt| 20))
  (|SetRElt| |Struct-axextend-5| |values| 2 t3 t0)
  (setq t4 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t4 (the |SInt| 20))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t4 (the |SInt| 20))
  (|SetRElt| |Struct-axextend-5| |values| 2 t4 t1)
  (setq t5 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t5 (the |SInt| 20))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t5 (the |SInt| 20))
  (|SetRElt| |Struct-axextend-5| |values| 2 t5 t2)
  (|CCall| |G-domainAddExports!| |P0-domain| t3 t4 t5)
  (|SetLex|
    |Struct-axextend-9-dom-20|
    20
    |l0|
    |G-axextend_SingleInteger_499971776|)
  (|SetLex|
    |Struct-axextend-9-coerce-19|
    19
    |l0|
    (|CCall|
      |G-stdGetWordRetWord0|
      (|CCall|
        |G-rtDelayedGetExport!|
        (|Lex| |Struct-axextend-9-dom-20| 20 |l0|)
        (the |SInt| 770345191)
        (the |SInt| 439168453))))
  (|SetAElt| t0 (the |SInt| 0) (the |SInt| 770345191))
  (setq
    t16
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-9--18| 18 |l0|)
      (the |SInt| 74075968)
      (the |SInt| 1073741789)))
  (setq t17 (|SIntAnd| t16 (the |SInt| 16777215)))
  (setq t18 (|SIntShiftUp| t17 (the |SInt| 6)))
  (|SetAElt|
    t1
    (the |SInt| 0)
    (|SIntPlusMod| (the |SInt| 142471813) t18 (the |SInt| 1073741789)))
  (|SetAElt|
    t2
    (the |SInt| 0)
    (|Lex| |Struct-axextend-9-coerce-14| 14 |l0|))
  (|SetAElt| t0 (the |SInt| 1) (the |SInt| 770345191))
  (|SetAElt|
    t1
    (the |SInt| 1)
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-9--18| 18 |l0|)
      (the |SInt| 974156096)
      (the |SInt| 1073741789)))
  (|SetAElt|
    t2
    (the |SInt| 1)
    (|Lex| |Struct-axextend-9-coerce-15| 15 |l0|))
  (|SetAElt| t0 (the |SInt| 2) (the |SInt| 770345191))
  (|SetAElt|
    t1
    (the |SInt| 2)
    (|SIntPlusMod| (the |SInt| 484208045) t18 (the |SInt| 1073741789)))
  (|SetAElt|
    t2
    (the |SInt| 2)
    (|Lex| |Struct-axextend-9-coerce-16| 16 |l0|))
  (|SetAElt| t0 (the |SInt| 3) (the |SInt| 770345191))
  (|SetAElt|
    t1
    (the |SInt| 3)
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-9--18| 18 |l0|)
      (the |SInt| 296696640)
      (the |SInt| 1073741789)))
  (|SetAElt|
    t2
    (the |SInt| 3)
    (|Lex| |Struct-axextend-9-coerce-17| 17 |l0|))
  (|SetAElt| t0 (the |SInt| 4) (the |SInt| 318069373))
  (|SetAElt| t1 (the |SInt| 4) t10)
  (|SetAElt|
    t2
    (the |SInt| 4)
    (|Lex| |Struct-axextend-9-one-13| 13 |l0|))
  (|SetAElt| t0 (the |SInt| 5) (the |SInt| 581887332))
  (|SetAElt| t1 (the |SInt| 5) t10)
  (|SetAElt|
    t2
    (the |SInt| 5)
    (|Lex| |Struct-axextend-9-zero-12| 12 |l0|))
  (|SetAElt| t0 (the |SInt| 6) (the |SInt| 206475020))
  (|SetAElt| t1 (the |SInt| 6) t6)
  (|SetAElt|
    t2
    (the |SInt| 6)
    (|Lex| |Struct-axextend-9-zero?-11| 11 |l0|))
  (|SetAElt| t0 (the |SInt| 7) (the |SInt| 200084))
  (|SetAElt| t1 (the |SInt| 7) t7)
  (|SetAElt|
    t2
    (the |SInt| 7)
    (|Lex| |Struct-axextend-9-+-10| 10 |l0|))
  (|SetAElt| t0 (the |SInt| 8) (the |SInt| 200083))
  (|SetAElt| t1 (the |SInt| 8) t7)
  (|SetAElt|
    t2
    (the |SInt| 8)
    (|Lex| |Struct-axextend-9-*-9| 9 |l0|))
  (|SetAElt| t0 (the |SInt| 9) (the |SInt| 200086))
  (|SetAElt| t1 (the |SInt| 9) t7)
  (|SetAElt|
    t2
    (the |SInt| 9)
    (|Lex| |Struct-axextend-9---8| 8 |l0|))
  (|SetAElt| t0 (the |SInt| 10) (the |SInt| 200102))
  (|SetAElt| t1 (the |SInt| 10) t8)
  (|SetAElt|
    t2
    (the |SInt| 10)
    (|Lex| |Struct-axextend-9-=-7| 7 |l0|))
  (|SetAElt| t0 (the |SInt| 11) (the |SInt| 200101))
  (|SetAElt| t1 (the |SInt| 11) t8)
  (|SetAElt|
    t2
    (the |SInt| 11)
    (|Lex| |Struct-axextend-9-<-6| 6 |l0|))
  (|SetAElt| t0 (the |SInt| 12) (the |SInt| 200103))
  (|SetAElt| t1 (the |SInt| 12) t8)
  (|SetAElt|
    t2
    (the |SInt| 12)
    (|Lex| |Struct-axextend-9->-5| 5 |l0|))
  (|SetAElt| t0 (the |SInt| 13) (the |SInt| 51492427))
  (|SetAElt| t1 (the |SInt| 13) t8)
  (|SetAElt|
    t2
    (the |SInt| 13)
    (|Lex| |Struct-axextend-9-<=-4| 4 |l0|))
  (|SetAElt| t0 (the |SInt| 14) (the |SInt| 51492941))
  (|SetAElt| t1 (the |SInt| 14) t8)
  (|SetAElt|
    t2
    (the |SInt| 14)
    (|Lex| |Struct-axextend-9->=-3| 3 |l0|))
  (|SetAElt| t0 (the |SInt| 15) (the |SInt| 318204816))
  (|SetAElt| t1 (the |SInt| 15) t7)
  (|SetAElt|
    t2
    (the |SInt| 15)
    (|Lex| |Struct-axextend-9-quo-2| 2 |l0|))
  (|SetAElt| t0 (the |SInt| 16) (the |SInt| 318266239))
  (|SetAElt| t1 (the |SInt| 16) t7)
  (|SetAElt|
    t2
    (the |SInt| 16)
    (|Lex| |Struct-axextend-9-rem-1| 1 |l0|))
  (|SetAElt| t0 (the |SInt| 17) (the |SInt| 318461307))
  (|SetAElt| t1 (the |SInt| 17) t7)
  (|SetAElt|
    t2
    (the |SInt| 17)
    (|Lex| |Struct-axextend-9-mod-0| 0 |l0|))
  (|SetAElt| t0 (the |SInt| 18) (the |SInt| 200090))
  (|SetAElt| t1 (the |SInt| 18) t9)
  (|SetAElt| t2 (the |SInt| 18) (the |BInt| 1))
  (|SetAElt| t0 (the |SInt| 19) (the |SInt| 200089))
  (|SetAElt| t1 (the |SInt| 19) t9)
  (|SetAElt| t2 (the |SInt| 19) (the |BInt| 0))
  (block-return |C46-axextend-addLevel1| |P0-domain|))

(defprog
  ((|C47-axextend-coerce| |Word|) ((|P0-n| |Word|) (|e1| |Env|)))
  ((|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (block-return
    |C47-axextend-coerce|
    (|CCall| (|Lex| |Struct-axextend-9-coerce-19| 19 |l1|) |P0-n|)))

(defprog
  ((|C48-axextend-coerce| |Word|) ((|P0-n| |Word|) (|e1| |Env|)))
  ((t0 |BInt|) (t1 |Word|) (t2 |BInt|))
  (tagbody
    (setq t2 (|SIntToBInt| |P0-n|))
    (when (|AXL-IntegerIsNonNegative| t2) (go |Lab0|))
    (setq
      t1
      (|AXL-LiteralToString| (|MakeLit| "Need a non-negative integer")))
    (|AXL-error| t1)
    |Lab1|
    (block-return |C48-axextend-coerce| t0)
    |Lab0|
    (setq t0 t2)
    (go |Lab1|)))

(defprog
  ((|C49-axextend-coerce| |Word|) ((|P0-n| |Word|) (|e1| |Env|)))
  ()
  (block-return |C49-axextend-coerce| |P0-n|))

(defprog
  ((|C50-axextend-coerce| |Word|) ((|P0-i| |Word|) (|e1| |Env|)))
  ((t0 |Word|) (t1 |Word|))
  (tagbody
    (when (|AXL-IntegerIsNonNegative| |P0-i|) (go |Lab0|))
    (setq
      t1
      (|AXL-LiteralToString| (|MakeLit| "Need a non-negative integer")))
    (|AXL-error| t1)
    |Lab1|
    (block-return |C50-axextend-coerce| t0)
    |Lab0|
    (setq t0 |P0-i|)
    (go |Lab1|)))

(defprog
  ((|C51-axextend-one| |Word|) ((|e1| |Env|)))
  ()
  (block-return |C51-axextend-one| (the |BInt| 1)))

(defprog
  ((|C52-axextend-zero| |Word|) ((|e1| |Env|)))
  ()
  (block-return |C52-axextend-zero| (the |BInt| 0)))

(defprog
  ((|C53-axextend-zero?| |Word|) ((|P0-n| |Word|) (|e1| |Env|)))
  ()
  (block-return |C53-axextend-zero?| (|BIntIsZero| |P0-n|)))

(defprog
  ((|C54-axextend-+| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C54-axextend-+| (|BIntPlus| |P0-a| |P1-b|)))

(defprog
  ((|C55-axextend-*| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C55-axextend-*| (|BIntTimes| |P0-a| |P1-b|)))

(defprog
  ((|C56-axextend--| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ((t0 |BInt|) (t1 |Word|) (t2 |BInt|))
  (tagbody
    (setq t2 (|BIntMinus| |P0-a| |P1-b|))
    (when (|AXL-IntegerIsNonNegative| t2) (go |Lab0|))
    (setq
      t1
      (|AXL-LiteralToString| (|MakeLit| "Need a non-negative integer")))
    (|AXL-error| t1)
    |Lab1|
    (block-return |C56-axextend--| t0)
    |Lab0|
    (setq t0 t2)
    (go |Lab1|)))

(defprog
  ((|C57-axextend-=| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C57-axextend-=| (|BIntEQ| |P0-a| |P1-b|)))

(defprog
  ((|C58-axextend-<| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C58-axextend-<| (|BIntLT| |P0-a| |P1-b|)))

(defprog
  ((|C59-axextend->| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C59-axextend->| (|BIntLT| |P1-b| |P0-a|)))

(defprog
  ((|C60-axextend-<=| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C60-axextend-<=| (|BIntLE| |P0-a| |P1-b|)))

(defprog
  ((|C61-axextend->=| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C61-axextend->=| (|BoolNot| (|BIntLT| |P0-a| |P1-b|))))

(defprog
  ((|C62-axextend-quo| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C62-axextend-quo| (|BIntQuo| |P0-a| |P1-b|)))

(defprog
  ((|C63-axextend-rem| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C63-axextend-rem| (|BIntRem| |P0-a| |P1-b|)))

(defprog
  ((|C64-axextend-mod| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C64-axextend-mod| (|BIntRem| |P0-a| |P1-b|)))

(defprog
  ((|C65-axextend-extend0| |Clos|) ((|P0-domain| |Word|) (|e1| |Env|)))
  ((t0 |Arr|) (t1 |Record|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (setq t0 (|ANew| |Word| (the |SInt| 2)))
  (|SetAElt|
    t0
    (the |SInt| 1)
    (|Lex| |Struct-axextend-45-NonNegativeInteger-5| 5 |l1|))
  (|SetAElt|
    t0
    (the |SInt| 0)
    |G-axextend_NonNegativeInteger_029131062|)
  (setq t1 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axextend-5| |values| 2 t1 t0)
  (|CCall| |G-extendFill!| |P0-domain| t1)
  (block-return |C65-axextend-extend0| |P0-domain|))

(defprog
  ((|C66-axextend-addLevel0| |Clos|)
    ((|P0-domain| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| nil)
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|CCall|
    |G-domainAddNameFn!|
    |P0-domain|
    (|CCall| |G-rtConstNameFn| (|MakeLit| "PositiveInteger")))
  (|CCall| |G-domainAddHash!| |P0-domain| (the |SInt| 965468232))
  (block-return
    |C66-axextend-addLevel0|
    (|Clos| |e0| |C67-axextend-addLevel1|)))

(defprog
  ((|C67-axextend-addLevel1| |Word|)
    ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Arr|)
    (t2 |Arr|)
    (t3 |Record|)
    (t4 |Record|)
    (t5 |Record|)
    (t6 |SInt|)
    (t7 |SInt|)
    (t8 |SInt|)
    (t9 |SInt|)
    (t10 |SInt|)
    (t11 |SInt|)
    (t12 |SInt|)
    (t13 |SInt|)
    (t14 |SInt|)
    (t15 |SInt|)
    (t16 |SInt|)
    (t17 |SInt|)
    (|l0| |Level|)
    (|e0| |Env|))
  (setq
    |l0|
    (|MakeLevel| |MAKE-Struct-axextend-10| |Struct-axextend-10|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq t0 (|ANew| |SInt| (the |SInt| 19)))
  (setq t1 (|ANew| |SInt| (the |SInt| 19)))
  (setq t2 (|ANew| |Word| (the |SInt| 19)))
  (|SetLex| |Struct-axextend-10--18| 18 |l0| |P1-hashcode|)
  (|SetLex|
    |Struct-axextend-10-coerce-12|
    12
    |l0|
    (|Clos| |e0| |C68-axextend-coerce|))
  (|SetLex|
    |Struct-axextend-10-coerce-13|
    13
    |l0|
    (|Clos| |e0| |C69-axextend-coerce|))
  (|SetLex|
    |Struct-axextend-10-coerce-14|
    14
    |l0|
    (|Clos| |e0| |C70-axextend-coerce|))
  (|SetLex|
    |Struct-axextend-10-coerce-15|
    15
    |l0|
    (|Clos| |e0| |C71-axextend-coerce|))
  (|SetLex|
    |Struct-axextend-10-coerce-16|
    16
    |l0|
    (|Clos| |e0| |C72-axextend-coerce|))
  (|SetLex|
    |Struct-axextend-10-coerce-17|
    17
    |l0|
    (|Clos| |e0| |C73-axextend-coerce|))
  (|SetLex|
    |Struct-axextend-10-one-11|
    11
    |l0|
    (|Clos| |e0| |C74-axextend-one|))
  (|SetLex|
    |Struct-axextend-10-+-10|
    10
    |l0|
    (|Clos| |e0| |C75-axextend-+|))
  (|SetLex|
    |Struct-axextend-10-*-9|
    9
    |l0|
    (|Clos| |e0| |C76-axextend-*|))
  (|SetLex|
    |Struct-axextend-10---8|
    8
    |l0|
    (|Clos| |e0| |C77-axextend--|))
  (|SetLex|
    |Struct-axextend-10-=-7|
    7
    |l0|
    (|Clos| |e0| |C78-axextend-=|))
  (|SetLex|
    |Struct-axextend-10-<-6|
    6
    |l0|
    (|Clos| |e0| |C79-axextend-<|))
  (|SetLex|
    |Struct-axextend-10->-5|
    5
    |l0|
    (|Clos| |e0| |C80-axextend->|))
  (|SetLex|
    |Struct-axextend-10-<=-4|
    4
    |l0|
    (|Clos| |e0| |C81-axextend-<=|))
  (|SetLex|
    |Struct-axextend-10->=-3|
    3
    |l0|
    (|Clos| |e0| |C82-axextend->=|))
  (|SetLex|
    |Struct-axextend-10-quo-2|
    2
    |l0|
    (|Clos| |e0| |C83-axextend-quo|))
  (|SetLex|
    |Struct-axextend-10-rem-1|
    1
    |l0|
    (|Clos| |e0| |C84-axextend-rem|))
  (|SetLex|
    |Struct-axextend-10-mod-0|
    0
    |l0|
    (|Clos| |e0| |C85-axextend-mod|))
  (setq
    t9
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-10--18| 18 |l0|)
      (the |SInt| 74075968)
      (the |SInt| 1073741789)))
  (setq t10 (|SIntAnd| t9 (the |SInt| 16777215)))
  (setq t11 (|SIntShiftUp| t10 (the |SInt| 6)))
  (setq
    t12
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-10--18| 18 |l0|)
      t11
      (the |SInt| 1073741789)))
  (setq t13 (|SIntAnd| t12 (the |SInt| 16777215)))
  (setq t14 (|SIntShiftUp| t13 (the |SInt| 6)))
  (setq
    t6
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-10--18| 18 |l0|)
      t14
      (the |SInt| 1073741789)))
  (setq
    t7
    (|SIntPlusMod| (the |SInt| 740244383) t14 (the |SInt| 1073741789)))
  (setq t8 (|Lex| |Struct-axextend-10--18| 18 |l0|))
  (setq t3 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t3 (the |SInt| 19))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t3 (the |SInt| 19))
  (|SetRElt| |Struct-axextend-5| |values| 2 t3 t0)
  (setq t4 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t4 (the |SInt| 19))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t4 (the |SInt| 19))
  (|SetRElt| |Struct-axextend-5| |values| 2 t4 t1)
  (setq t5 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t5 (the |SInt| 19))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t5 (the |SInt| 19))
  (|SetRElt| |Struct-axextend-5| |values| 2 t5 t2)
  (|CCall| |G-domainAddExports!| |P0-domain| t3 t4 t5)
  (|SetLex|
    |Struct-axextend-10-dom-20|
    20
    |l0|
    |G-axextend_SingleInteger_499971776|)
  (|SetLex|
    |Struct-axextend-10-coerce-19|
    19
    |l0|
    (|CCall|
      |G-stdGetWordRetWord0|
      (|CCall|
        |G-rtDelayedGetExport!|
        (|Lex| |Struct-axextend-10-dom-20| 20 |l0|)
        (the |SInt| 770345191)
        (the |SInt| 439168453))))
  (|SetAElt| t0 (the |SInt| 0) (the |SInt| 770345191))
  (setq
    t15
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-10--18| 18 |l0|)
      (the |SInt| 74075968)
      (the |SInt| 1073741789)))
  (setq t16 (|SIntAnd| t15 (the |SInt| 16777215)))
  (setq t17 (|SIntShiftUp| t16 (the |SInt| 6)))
  (|SetAElt|
    t1
    (the |SInt| 0)
    (|SIntPlusMod| (the |SInt| 142471813) t17 (the |SInt| 1073741789)))
  (|SetAElt|
    t2
    (the |SInt| 0)
    (|Lex| |Struct-axextend-10-coerce-12| 12 |l0|))
  (|SetAElt| t0 (the |SInt| 1) (the |SInt| 770345191))
  (|SetAElt|
    t1
    (the |SInt| 1)
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-10--18| 18 |l0|)
      (the |SInt| 974156096)
      (the |SInt| 1073741789)))
  (|SetAElt|
    t2
    (the |SInt| 1)
    (|Lex| |Struct-axextend-10-coerce-13| 13 |l0|))
  (|SetAElt| t0 (the |SInt| 2) (the |SInt| 770345191))
  (|SetAElt|
    t1
    (the |SInt| 2)
    (|SIntPlusMod| (the |SInt| 484208045) t17 (the |SInt| 1073741789)))
  (|SetAElt|
    t2
    (the |SInt| 2)
    (|Lex| |Struct-axextend-10-coerce-14| 14 |l0|))
  (|SetAElt| t0 (the |SInt| 3) (the |SInt| 770345191))
  (|SetAElt|
    t1
    (the |SInt| 3)
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-10--18| 18 |l0|)
      (the |SInt| 296696640)
      (the |SInt| 1073741789)))
  (|SetAElt|
    t2
    (the |SInt| 3)
    (|Lex| |Struct-axextend-10-coerce-15| 15 |l0|))
  (|SetAElt| t0 (the |SInt| 4) (the |SInt| 770345191))
  (|SetAElt|
    t1
    (the |SInt| 4)
    (|SIntPlusMod| (the |SInt| 172927374) t17 (the |SInt| 1073741789)))
  (|SetAElt|
    t2
    (the |SInt| 4)
    (|Lex| |Struct-axextend-10-coerce-16| 16 |l0|))
  (|SetAElt| t0 (the |SInt| 5) (the |SInt| 770345191))
  (|SetAElt|
    t1
    (the |SInt| 5)
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-10--18| 18 |l0|)
      (the |SInt| 775828352)
      (the |SInt| 1073741789)))
  (|SetAElt|
    t2
    (the |SInt| 5)
    (|Lex| |Struct-axextend-10-coerce-17| 17 |l0|))
  (|SetAElt| t0 (the |SInt| 6) (the |SInt| 318069373))
  (|SetAElt| t1 (the |SInt| 6) t9)
  (|SetAElt|
    t2
    (the |SInt| 6)
    (|Lex| |Struct-axextend-10-one-11| 11 |l0|))
  (|SetAElt| t0 (the |SInt| 7) (the |SInt| 200084))
  (|SetAElt| t1 (the |SInt| 7) t6)
  (|SetAElt|
    t2
    (the |SInt| 7)
    (|Lex| |Struct-axextend-10-+-10| 10 |l0|))
  (|SetAElt| t0 (the |SInt| 8) (the |SInt| 200083))
  (|SetAElt| t1 (the |SInt| 8) t6)
  (|SetAElt|
    t2
    (the |SInt| 8)
    (|Lex| |Struct-axextend-10-*-9| 9 |l0|))
  (|SetAElt| t0 (the |SInt| 9) (the |SInt| 200086))
  (|SetAElt| t1 (the |SInt| 9) t6)
  (|SetAElt|
    t2
    (the |SInt| 9)
    (|Lex| |Struct-axextend-10---8| 8 |l0|))
  (|SetAElt| t0 (the |SInt| 10) (the |SInt| 200102))
  (|SetAElt| t1 (the |SInt| 10) t7)
  (|SetAElt|
    t2
    (the |SInt| 10)
    (|Lex| |Struct-axextend-10-=-7| 7 |l0|))
  (|SetAElt| t0 (the |SInt| 11) (the |SInt| 200101))
  (|SetAElt| t1 (the |SInt| 11) t7)
  (|SetAElt|
    t2
    (the |SInt| 11)
    (|Lex| |Struct-axextend-10-<-6| 6 |l0|))
  (|SetAElt| t0 (the |SInt| 12) (the |SInt| 200103))
  (|SetAElt| t1 (the |SInt| 12) t7)
  (|SetAElt|
    t2
    (the |SInt| 12)
    (|Lex| |Struct-axextend-10->-5| 5 |l0|))
  (|SetAElt| t0 (the |SInt| 13) (the |SInt| 51492427))
  (|SetAElt| t1 (the |SInt| 13) t7)
  (|SetAElt|
    t2
    (the |SInt| 13)
    (|Lex| |Struct-axextend-10-<=-4| 4 |l0|))
  (|SetAElt| t0 (the |SInt| 14) (the |SInt| 51492941))
  (|SetAElt| t1 (the |SInt| 14) t7)
  (|SetAElt|
    t2
    (the |SInt| 14)
    (|Lex| |Struct-axextend-10->=-3| 3 |l0|))
  (|SetAElt| t0 (the |SInt| 15) (the |SInt| 318204816))
  (|SetAElt| t1 (the |SInt| 15) t6)
  (|SetAElt|
    t2
    (the |SInt| 15)
    (|Lex| |Struct-axextend-10-quo-2| 2 |l0|))
  (|SetAElt| t0 (the |SInt| 16) (the |SInt| 318266239))
  (|SetAElt| t1 (the |SInt| 16) t6)
  (|SetAElt|
    t2
    (the |SInt| 16)
    (|Lex| |Struct-axextend-10-rem-1| 1 |l0|))
  (|SetAElt| t0 (the |SInt| 17) (the |SInt| 318461307))
  (|SetAElt| t1 (the |SInt| 17) t6)
  (|SetAElt|
    t2
    (the |SInt| 17)
    (|Lex| |Struct-axextend-10-mod-0| 0 |l0|))
  (|SetAElt| t0 (the |SInt| 18) (the |SInt| 200090))
  (|SetAElt| t1 (the |SInt| 18) t8)
  (|SetAElt| t2 (the |SInt| 18) (the |BInt| 1))
  (block-return |C67-axextend-addLevel1| |P0-domain|))

(defprog
  ((|C68-axextend-coerce| |Word|) ((|P0-n| |Word|) (|e1| |Env|)))
  ((|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (block-return
    |C68-axextend-coerce|
    (|CCall| (|Lex| |Struct-axextend-10-coerce-19| 19 |l1|) |P0-n|)))

(defprog
  ((|C69-axextend-coerce| |Word|) ((|P0-n| |Word|) (|e1| |Env|)))
  ((t0 |BInt|) (t1 |Word|) (t2 |BInt|))
  (tagbody
    (setq t2 (|SIntToBInt| |P0-n|))
    (when (|AXL-IntegerIsPositive| t2) (go |Lab0|))
    (setq
      t1
      (|AXL-LiteralToString| (|MakeLit| "Need a positive integer")))
    (|AXL-error| t1)
    |Lab1|
    (block-return |C69-axextend-coerce| t0)
    |Lab0|
    (setq t0 t2)
    (go |Lab1|)))

(defprog
  ((|C70-axextend-coerce| |Word|) ((|P0-n| |Word|) (|e1| |Env|)))
  ()
  (block-return |C70-axextend-coerce| |P0-n|))

(defprog
  ((|C71-axextend-coerce| |Word|) ((|P0-i| |Word|) (|e1| |Env|)))
  ((t0 |Word|) (t1 |Word|))
  (tagbody
    (when (|AXL-IntegerIsPositive| |P0-i|) (go |Lab0|))
    (setq
      t1
      (|AXL-LiteralToString| (|MakeLit| "Need a positive integer")))
    (|AXL-error| t1)
    |Lab1|
    (block-return |C71-axextend-coerce| t0)
    |Lab0|
    (setq t0 |P0-i|)
    (go |Lab1|)))

(defprog
  ((|C72-axextend-coerce| |Word|) ((|P0-n| |Word|) (|e1| |Env|)))
  ((t0 |Word|) (t1 |Word|))
  (tagbody
    (when (|AXL-IntegerIsNonNegative| |P0-n|) (go |Lab0|))
    (setq
      t1
      (|AXL-LiteralToString| (|MakeLit| "Need a non-negative integer")))
    (|AXL-error| t1)
    |Lab1|
    (block-return |C72-axextend-coerce| t0)
    |Lab0|
    (setq t0 |P0-n|)
    (go |Lab1|)))

(defprog
  ((|C73-axextend-coerce| |Word|) ((|P0-i| |Word|) (|e1| |Env|)))
  ((t0 |Word|) (t1 |Word|))
  (tagbody
    (when (|AXL-IntegerIsPositive| |P0-i|) (go |Lab0|))
    (setq
      t1
      (|AXL-LiteralToString| (|MakeLit| "Need a positive integer")))
    (|AXL-error| t1)
    |Lab1|
    (block-return |C73-axextend-coerce| t0)
    |Lab0|
    (setq t0 |P0-i|)
    (go |Lab1|)))

(defprog
  ((|C74-axextend-one| |Word|) ((|e1| |Env|)))
  ()
  (block-return |C74-axextend-one| (the |BInt| 1)))

(defprog
  ((|C75-axextend-+| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C75-axextend-+| (|BIntPlus| |P0-a| |P1-b|)))

(defprog
  ((|C76-axextend-*| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C76-axextend-*| (|BIntTimes| |P0-a| |P1-b|)))

(defprog
  ((|C77-axextend--| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ((t0 |BInt|) (t1 |Word|) (t2 |BInt|))
  (tagbody
    (setq t2 (|BIntMinus| |P0-a| |P1-b|))
    (when (|AXL-IntegerIsPositive| t2) (go |Lab0|))
    (setq
      t1
      (|AXL-LiteralToString| (|MakeLit| "Need a positive integer")))
    (|AXL-error| t1)
    |Lab1|
    (block-return |C77-axextend--| t0)
    |Lab0|
    (setq t0 t2)
    (go |Lab1|)))

(defprog
  ((|C78-axextend-=| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C78-axextend-=| (|BIntEQ| |P0-a| |P1-b|)))

(defprog
  ((|C79-axextend-<| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C79-axextend-<| (|BIntLT| |P0-a| |P1-b|)))

(defprog
  ((|C80-axextend->| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C80-axextend->| (|BIntLT| |P1-b| |P0-a|)))

(defprog
  ((|C81-axextend-<=| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C81-axextend-<=| (|BIntLE| |P0-a| |P1-b|)))

(defprog
  ((|C82-axextend->=| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C82-axextend->=| (|BoolNot| (|BIntLT| |P0-a| |P1-b|))))

(defprog
  ((|C83-axextend-quo| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C83-axextend-quo| (|BIntQuo| |P0-a| |P1-b|)))

(defprog
  ((|C84-axextend-rem| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C84-axextend-rem| (|BIntRem| |P0-a| |P1-b|)))

(defprog
  ((|C85-axextend-mod| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ()
  (block-return |C85-axextend-mod| (|BIntRem| |P0-a| |P1-b|)))

(defprog
  ((|C86-axextend-extend0| |Clos|) ((|P0-domain| |Word|) (|e1| |Env|)))
  ((t0 |Arr|) (t1 |Record|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (setq t0 (|ANew| |Word| (the |SInt| 2)))
  (|SetAElt|
    t0
    (the |SInt| 1)
    (|Lex| |Struct-axextend-45-PositiveInteger-4| 4 |l1|))
  (|SetAElt| t0 (the |SInt| 0) |G-axextend_PositiveInteger_619949646|)
  (setq t1 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axextend-5| |values| 2 t1 t0)
  (|CCall| |G-extendFill!| |P0-domain| t1)
  (block-return |C86-axextend-extend0| |P0-domain|))

(defprog
  ((|C87-axextend-List| |Word|) ((p0-s |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Record|)
    (t2 |Word|)
    (t3 |Word|)
    (|l0| |Level|)
    (|e0| |Env|)
    (|l1| |Level|))
  (setq
    |l0|
    (|MakeLevel| |MAKE-Struct-axextend-18| |Struct-axextend-18|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (|SetLex| |Struct-axextend-18-S-0| 0 |l0| p0-s)
    (setq t0 (|ANew| |Word| (the |SInt| 1)))
    (setq t1 (|RNew| |Struct-axextend-11|))
    (|SetRElt| |Struct-axextend-11| |size| 0 t1 (the |SInt| 1))
    (|SetRElt| |Struct-axextend-11| |values| 1 t1 t0)
    (when
      (|PtrIsNil| (|Lex| |Struct-axextend-45--10| 10 |l1|))
      (go |Lab3|))
    |Lab1|
    (|SetAElt|
      t0
      (the |SInt| 0)
      (|Lex| |Struct-axextend-18-S-0| 0 |l0|))
    (multiple-value-setq
      (t2 t3)
      (|CCall|
        |G-rtCacheCheck|
        (|Lex| |Struct-axextend-45--10| 10 |l1|)
        t1))
    (when t3 (go |Lab0|))
    (setq
      t2
      (|CCall| |G-domainMake| (|Clos| |e0| |C88-axextend-addLevel0|)))
    (setq
      t2
      (|CCall|
        |G-rtCacheAdd|
        (|Lex| |Struct-axextend-45--10| 10 |l1|)
        t1
        t2))
    |Lab0|
    (block-return |C87-axextend-List| t2)
    |Lab3|
    (|SetLex|
      |Struct-axextend-45--10|
      10
      |l1|
      (|CCall| |G-rtCacheExplicitMake| (the |SInt| 15)))
    (go |Lab1|)))

(defprog
  ((|C88-axextend-addLevel0| |Clos|)
    ((|P0-domain| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|) (|l1| |Level|))
  (setq |l0| nil)
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |l1| (|EnvLevel| |e1|))
  (|CCall|
    |G-domainAddNameFn!|
    |P0-domain|
    (|CCall|
      |G-rtSingleParamNameFn|
      (|MakeLit| "List")
      (|Lex| |Struct-axextend-18-S-0| 0 |l1|)))
  (|CCall|
    |G-domainAddHash!|
    |P0-domain|
    (|SIntPlusMod|
      (|CCall| |G-domainHash!| (|Lex| |Struct-axextend-18-S-0| 0 |l1|))
      (the |SInt| 638488576)
      (the |SInt| 1073741789)))
  (block-return
    |C88-axextend-addLevel0|
    (|Clos| |e0| |C89-axextend-addLevel1|)))

(defprog
  ((|C89-axextend-addLevel1| |Word|)
    ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Arr|)
    (t2 |Arr|)
    (t3 |Record|)
    (t4 |Record|)
    (t5 |Record|)
    (t6 |SInt|)
    (t7 |SInt|)
    (t8 |SInt|)
    (t9 |SInt|)
    (t10 |SInt|)
    (t11 |SInt|)
    (t12 |SInt|)
    (t13 |SInt|)
    (t14 |SInt|)
    (t15 |SInt|)
    (t16 |SInt|)
    (t17 |SInt|)
    (t18 |SInt|)
    (t19 |SInt|)
    (t20 |SInt|)
    (t21 |SInt|)
    (t22 |SInt|)
    (|l0| |Level|)
    (|e0| |Env|)
    (|e2| |Env|)
    (|l2| |Level|))
  (setq
    |l0|
    (|MakeLevel| |MAKE-Struct-axextend-17| |Struct-axextend-17|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |e2| (|EnvNext| |e1|))
  (setq |l2| (|EnvLevel| |e2|))
  (setq t0 (|ANew| |SInt| (the |SInt| 16)))
  (setq t1 (|ANew| |SInt| (the |SInt| 16)))
  (setq t2 (|ANew| |Word| (the |SInt| 16)))
  (|SetLex| |Struct-axextend-17--15| 15 |l0| |P1-hashcode|)
  (|SetLex|
    |Struct-axextend-17-rec-13|
    13
    |l0|
    (|Clos| |e0| |C90-axextend-rec|))
  (|SetLex|
    |Struct-axextend-17-empty?-12|
    12
    |l0|
    (|Clos| |e0| |C91-axextend-empty?|))
  (|SetLex|
    |Struct-axextend-17-#-10|
    10
    |l0|
    (|Clos| |e0| |C92-axextend-#|))
  (|SetLex|
    |Struct-axextend-17-empty-9|
    9
    |l0|
    (|Clos| |e0| |C93-axextend-empty|))
  (|SetLex|
    |Struct-axextend-17-cons-8|
    8
    |l0|
    (|Clos| |e0| |C94-axextend-cons|))
  (|SetLex|
    |Struct-axextend-17-test-7|
    7
    |l0|
    (|Clos| |e0| |C95-axextend-test|))
  (|SetLex|
    |Struct-axextend-17-first-6|
    6
    |l0|
    (|Clos| |e0| |C96-axextend-first|))
  (|SetLex|
    |Struct-axextend-17-rest-5|
    5
    |l0|
    (|Clos| |e0| |C97-axextend-rest|))
  (|SetLex|
    |Struct-axextend-17-setFirst!-4|
    4
    |l0|
    (|Clos| |e0| |C98-axextend-setFirst!|))
  (|SetLex|
    |Struct-axextend-17-setRest!-3|
    3
    |l0|
    (|Clos| |e0| |C99-axextend-setRest!|))
  (|SetLex|
    |Struct-axextend-17-reverse!-2|
    2
    |l0|
    (|Clos| |e0| |C100-axextend-reverse!|))
  (|SetLex|
    |Struct-axextend-17-#-11|
    11
    |l0|
    (|Clos| |e0| |C101-axextend-#|))
  (|SetLex|
    |Struct-axextend-17-generator-1|
    1
    |l0|
    (|Clos| |e0| |C102-axextend-generator|))
  (|SetLex|
    |Struct-axextend-17-bracket-0|
    0
    |l0|
    (|Clos| |e0| |C108-axextend-bracket|))
  (|SetLex|
    |Struct-axextend-17-P-14|
    14
    |l0|
    (|CCall| |G-domainMake| (|Clos| |e0| |C109-axextend-addLevel0|)))
  (setq
    t16
    (|CCall| |G-domainHash!| (|Lex| |Struct-axextend-18-S-0| 0 |l2|)))
  (setq
    t6
    (|CCall| |G-domainHash!| (|Lex| |Struct-axextend-18-S-0| 0 |l2|)))
  (setq
    t17
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-17--15| 15 |l0|)
      (the |SInt| 74075968)
      (the |SInt| 1073741789)))
  (setq t18 (|SIntAnd| t17 (the |SInt| 16777215)))
  (setq t19 (|SIntShiftUp| t18 (the |SInt| 6)))
  (setq
    t7
    (|SIntPlusMod| (the |SInt| 740244383) t19 (the |SInt| 1073741789)))
  (setq
    t8
    (|SIntPlusMod| (the |SInt| 142471813) t19 (the |SInt| 1073741789)))
  (setq
    t9
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-17--15| 15 |l0|)
      (|SIntShiftUp|
        (|SIntAnd|
          (|SIntPlusMod|
            (|Lex| |Struct-axextend-17--15| 15 |l0|)
            (|SIntShiftUp|
              (|SIntAnd|
                (|SIntPlusMod| t16 (the |SInt| 74075968) (the |SInt| 1073741789))
                (the |SInt| 16777215))
              (the |SInt| 6))
            (the |SInt| 1073741789))
          (the |SInt| 16777215))
        (the |SInt| 6))
      (the |SInt| 1073741789)))
  (setq t20 (|SIntPlusMod| t16 t19 (the |SInt| 1073741789)))
  (setq
    t21
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-17--15| 15 |l0|)
      t19
      (the |SInt| 1073741789)))
  (setq
    t10
    (|SIntPlusMod|
      t16
      (|SIntShiftUp| (|SIntAnd| t20 (the |SInt| 16777215)) (the |SInt| 6))
      (the |SInt| 1073741789)))
  (setq
    t11
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-17--15| 15 |l0|)
      (|SIntShiftUp| (|SIntAnd| t21 (the |SInt| 16777215)) (the |SInt| 6))
      (the |SInt| 1073741789)))
  (setq
    t12
    (|SIntPlusMod| (the |SInt| 172927374) t19 (the |SInt| 1073741789)))
  (setq
    t22
    (|SIntPlusMod| t16 (the |SInt| 5805568) (the |SInt| 1073741789)))
  (setq t13 (|SIntPlusMod| t22 t19 (the |SInt| 1073741789)))
  (setq
    t14
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-17--15| 15 |l0|)
      (|SIntShiftUp|
        (|SIntAnd|
          (|SIntPlusMod| t22 (the |SInt| 74075968) (the |SInt| 1073741789))
          (the |SInt| 16777215))
        (the |SInt| 6))
      (the |SInt| 1073741789)))
  (setq t15 (|Lex| |Struct-axextend-17--15| 15 |l0|))
  (setq t3 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t3 (the |SInt| 16))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t3 (the |SInt| 16))
  (|SetRElt| |Struct-axextend-5| |values| 2 t3 t0)
  (setq t4 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t4 (the |SInt| 16))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t4 (the |SInt| 16))
  (|SetRElt| |Struct-axextend-5| |values| 2 t4 t1)
  (setq t5 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t5 (the |SInt| 16))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t5 (the |SInt| 16))
  (|SetRElt| |Struct-axextend-5| |values| 2 t5 t2)
  (|CCall| |G-domainAddExports!| |P0-domain| t3 t4 t5)
  (|SetAElt| t0 (the |SInt| 0) (the |SInt| 318266229))
  (|SetAElt|
    t1
    (the |SInt| 0)
    (|SIntPlusMod|
      (|SIntPlusMod|
        (the |SInt| 200121)
        (|SIntShiftUp|
          (|SIntAnd|
            (|SIntPlusMod| t6 (the |SInt| 693187904) (the |SInt| 1073741789))
            (the |SInt| 16777215))
          (the |SInt| 6))
        (the |SInt| 1073741789))
      (|SIntShiftUp|
        (|SIntAnd|
          (|SIntPlusMod|
            (|Lex| |Struct-axextend-17--15| 15 |l0|)
            (the |SInt| 74075968)
            (the |SInt| 1073741789))
          (the |SInt| 16777215))
        (the |SInt| 6))
      (the |SInt| 1073741789)))
  (|SetAElt|
    t2
    (the |SInt| 0)
    (|Lex| |Struct-axextend-17-rec-13| 13 |l0|))
  (|SetAElt| t0 (the |SInt| 1) (the |SInt| 506619364))
  (|SetAElt| t1 (the |SInt| 1) t7)
  (|SetAElt|
    t2
    (the |SInt| 1)
    (|Lex| |Struct-axextend-17-empty?-12| 12 |l0|))
  (|SetAElt| t0 (the |SInt| 2) (the |SInt| 200076))
  (|SetAElt| t1 (the |SInt| 2) t8)
  (|SetAElt|
    t2
    (the |SInt| 2)
    (|Lex| |Struct-axextend-17-#-10| 10 |l0|))
  (|SetAElt| t0 (the |SInt| 3) (the |SInt| 357262396))
  (|SetAElt| t1 (the |SInt| 3) t17)
  (|SetAElt|
    t2
    (the |SInt| 3)
    (|Lex| |Struct-axextend-17-empty-9| 9 |l0|))
  (|SetAElt| t0 (the |SInt| 4) (the |SInt| 865800279))
  (|SetAElt| t1 (the |SInt| 4) t9)
  (|SetAElt|
    t2
    (the |SInt| 4)
    (|Lex| |Struct-axextend-17-cons-8| 8 |l0|))
  (|SetAElt| t0 (the |SInt| 5) (the |SInt| 5509732))
  (|SetAElt| t1 (the |SInt| 5) t7)
  (|SetAElt|
    t2
    (the |SInt| 5)
    (|Lex| |Struct-axextend-17-test-7| 7 |l0|))
  (|SetAElt| t0 (the |SInt| 6) (the |SInt| 682776373))
  (|SetAElt| t1 (the |SInt| 6) t20)
  (|SetAElt|
    t2
    (the |SInt| 6)
    (|Lex| |Struct-axextend-17-first-6| 6 |l0|))
  (|SetAElt| t0 (the |SInt| 7) (the |SInt| 715582562))
  (|SetAElt| t1 (the |SInt| 7) t21)
  (|SetAElt|
    t2
    (the |SInt| 7)
    (|Lex| |Struct-axextend-17-rest-5| 5 |l0|))
  (|SetAElt| t0 (the |SInt| 8) (the |SInt| 143562022))
  (|SetAElt| t1 (the |SInt| 8) t10)
  (|SetAElt|
    t2
    (the |SInt| 8)
    (|Lex| |Struct-axextend-17-setFirst!-4| 4 |l0|))
  (|SetAElt| t0 (the |SInt| 9) (the |SInt| 76356179))
  (|SetAElt| t1 (the |SInt| 9) t11)
  (|SetAElt|
    t2
    (the |SInt| 9)
    (|Lex| |Struct-axextend-17-setRest!-3| 3 |l0|))
  (|SetAElt| t0 (the |SInt| 10) (the |SInt| 25941349))
  (|SetAElt| t1 (the |SInt| 10) t21)
  (|SetAElt|
    t2
    (the |SInt| 10)
    (|Lex| |Struct-axextend-17-reverse!-2| 2 |l0|))
  (|SetAElt| t0 (the |SInt| 11) (the |SInt| 200076))
  (|SetAElt| t1 (the |SInt| 11) t12)
  (|SetAElt|
    t2
    (the |SInt| 11)
    (|Lex| |Struct-axextend-17-#-11| 11 |l0|))
  (|SetAElt| t0 (the |SInt| 12) (the |SInt| 113320568))
  (|SetAElt| t1 (the |SInt| 12) t13)
  (|SetAElt|
    t2
    (the |SInt| 12)
    (|Lex| |Struct-axextend-17-generator-1| 1 |l0|))
  (|SetAElt| t0 (the |SInt| 13) (the |SInt| 44638651))
  (|SetAElt| t1 (the |SInt| 13) t14)
  (|SetAElt|
    t2
    (the |SInt| 13)
    (|Lex| |Struct-axextend-17-bracket-0| 0 |l0|))
  (|SetAElt| t0 (the |SInt| 14) (the |SInt| 200121))
  (|SetAElt| t1 (the |SInt| 14) (the |SInt| 0))
  (|SetAElt|
    t2
    (the |SInt| 14)
    (|Lex| |Struct-axextend-17-P-14| 14 |l0|))
  (|SetAElt| t0 (the |SInt| 15) (the |SInt| 318525310))
  (|SetAElt| t1 (the |SInt| 15) t15)
  (|SetAElt| t2 (the |SInt| 15) nil)
  (block-return |C89-axextend-addLevel1| |P0-domain|))

(defprog
  ((|C90-axextend-rec| |Record|) ((|P0-x| |Word|) (|e1| |Env|)))
  ()
  (block-return |C90-axextend-rec| |P0-x|))

(defprog
  ((|C91-axextend-empty?| |Word|) ((|P0-l| |Word|) (|e1| |Env|)))
  ()
  (block-return |C91-axextend-empty?| (|PtrIsNil| |P0-l|)))

(defprog
  ((|C92-axextend-#| |Word|) ((|P0-l| |Word|) (|e1| |Env|)))
  ((|T0-n| |SInt|)
    (t1 |Word|)
    (|T2-l| |Word|)
    (t3 |Bool|)
    (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (setq |T0-n| (the |SInt| 0))
    (setq |T2-l| |P0-l|)
    |Lab0|
    (|FoamEnvEnsure|
      (|ClosEnv|
        (|EElt|
          |Struct-axextend-17-test-7|
          7
          (|EnvLevel|
            (|ClosEnv| (|Lex| |Struct-axextend-17-generator-1| 1 |l1|))))))
    (setq t3 (|PtrIsNil| |T2-l|))
    (when t3 (go |Lab1|))
    (setq |T0-n| (|SIntNext| |T0-n|))
    (when (|PtrIsNil| |T2-l|) (go |Lab2|))
    (setq t1 (|RElt| |Struct-axextend-13| |rest| 1 |T2-l|))
    |Lab3|
    (setq |T2-l| t1)
    (go |Lab0|)
    |Lab2|
    (setq t1 |T2-l|)
    (go |Lab3|)
    |Lab1|
    (block-return |C92-axextend-#| |T0-n|)))

(defprog
  ((|C93-axextend-empty| |Word|) ((|e1| |Env|)))
  ()
  (block-return |C93-axextend-empty| nil))

(defprog
  ((|C94-axextend-cons| |Word|)
    ((|P0-a| |Word|) (|P1-l| |Word|) (|e1| |Env|)))
  ((t0 |Record|))
  (setq t0 (|RNew| |Struct-axextend-13|))
  (|SetRElt| |Struct-axextend-13| |first| 0 t0 |P0-a|)
  (|SetRElt| |Struct-axextend-13| |rest| 1 t0 |P1-l|)
  (block-return |C94-axextend-cons| t0))

(defprog
  ((|C95-axextend-test| |Word|) ((|P0-x| |Word|) (|e1| |Env|)))
  ()
  (block-return |C95-axextend-test| (|BoolNot| (|PtrIsNil| |P0-x|))))

(defprog
  ((|C96-axextend-first| |Word|) ((|P0-l| |Word|) (|e1| |Env|)))
  ((t0 |Word|) (t1 |Word|))
  (tagbody
    (when (|PtrIsNil| |P0-l|) (go |Lab0|))
    (setq t0 (|RElt| |Struct-axextend-13| |first| 0 |P0-l|))
    |Lab1|
    (block-return |C96-axextend-first| t0)
    |Lab0|
    (setq
      t1
      (|AXL-LiteralToString|
        (|MakeLit| "Cannot select `first' of empty list.")))
    (|AXL-error| t1)
    (go |Lab1|)))

(defprog
  ((|C97-axextend-rest| |Word|) ((|P0-l| |Word|) (|e1| |Env|)))
  ((t0 |Word|))
  (tagbody
    (when (|PtrIsNil| |P0-l|) (go |Lab0|))
    (setq t0 (|RElt| |Struct-axextend-13| |rest| 1 |P0-l|))
    |Lab1|
    (block-return |C97-axextend-rest| t0)
    |Lab0|
    (setq t0 |P0-l|)
    (go |Lab1|)))

(defprog
  ((|C98-axextend-setFirst!| |Word|)
    ((|P0-l| |Word|) (|P1-a| |Word|) (|e1| |Env|)))
  ((t0 |Word|) (t1 |Word|))
  (tagbody
    (when (|PtrIsNil| |P0-l|) (go |Lab0|))
    (|SetRElt| |Struct-axextend-13| |first| 0 |P0-l| |P1-a|)
    (setq t0 (|RElt| |Struct-axextend-13| |first| 0 |P0-l|))
    |Lab1|
    (block-return |C98-axextend-setFirst!| t0)
    |Lab0|
    (setq
      t1
      (|AXL-LiteralToString|
        (|MakeLit| "Cannot set `first' of empty list.")))
    (|AXL-error| t1)
    (go |Lab1|)))

(defprog
  ((|C99-axextend-setRest!| |Word|)
    ((|P0-l| |Word|) (|P1-t| |Word|) (|e1| |Env|)))
  ((t0 |Word|) (t1 |Word|))
  (tagbody
    (when (|PtrIsNil| |P0-l|) (go |Lab0|))
    (|SetRElt| |Struct-axextend-13| |rest| 1 |P0-l| |P1-t|)
    (setq t0 (|RElt| |Struct-axextend-13| |rest| 1 |P0-l|))
    |Lab1|
    (block-return |C99-axextend-setRest!| t0)
    |Lab0|
    (setq
      t1
      (|AXL-LiteralToString| (|MakeLit| "Cannot set `rest' of empty list.")))
    (|AXL-error| t1)
    (go |Lab1|)))

(defprog
  ((|C100-axextend-reverse!| |Word|) ((|P0-x| |Word|) (|e1| |Env|)))
  ((|T0-y| |Word|)
    (t1 |Word|)
    (t2 |Word|)
    (t3 |Word|)
    (t4 |Word|)
    (t5 |Bool|)
    (t6 |Bool|))
  (tagbody
    (setq t5 (|PtrIsNil| |P0-x|))
    (when t5 (go |Lab0|))
    (setq t4 (|RElt| |Struct-axextend-13| |rest| 1 |P0-x|))
    (setq |T0-y| t4)
    (when (|PtrIsNil| t4) (go |Lab2|))
    (|AXL-rplacd| |P0-x| nil)
    |Lab4|
    (setq t6 (|PtrIsNil| |T0-y|))
    (when t6 (go |Lab5|))
    (setq t3 (|RElt| |Struct-axextend-13| |rest| 1 |T0-y|))
    (|AXL-rplacd| |T0-y| |P0-x|)
    (setq |P0-x| |T0-y|)
    (setq |T0-y| t3)
    (go |Lab4|)
    |Lab5|
    (setq t2 |P0-x|)
    |Lab3|
    (setq t1 t2)
    |Lab1|
    (block-return |C100-axextend-reverse!| t1)
    |Lab2|
    (setq t2 |P0-x|)
    (go |Lab3|)
    |Lab0|
    (setq t1 |P0-x|)
    (go |Lab1|)))

(defprog
  ((|C101-axextend-#| |Word|) ((|P0-l| |Word|) (|e1| |Env|)))
  ((|T0-k| |BInt|)
    (t1 |Word|)
    (|T2-l| |Word|)
    (t3 |Bool|)
    (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (setq |T0-k| (the |BInt| 0))
    (setq |T2-l| |P0-l|)
    |Lab0|
    (|FoamEnvEnsure|
      (|ClosEnv|
        (|EElt|
          |Struct-axextend-17-test-7|
          7
          (|EnvLevel|
            (|ClosEnv| (|Lex| |Struct-axextend-17-generator-1| 1 |l1|))))))
    (setq t3 (|PtrIsNil| |T2-l|))
    (when t3 (go |Lab1|))
    (setq |T0-k| (|BIntNext| |T0-k|))
    (when (|PtrIsNil| |T2-l|) (go |Lab2|))
    (setq t1 (|RElt| |Struct-axextend-13| |rest| 1 |T2-l|))
    |Lab3|
    (setq |T2-l| t1)
    (go |Lab0|)
    |Lab2|
    (setq t1 |T2-l|)
    (go |Lab3|)
    |Lab1|
    (block-return |C101-axextend-#| |T0-k|)))

(defprog
  ((|C102-axextend-generator| |Clos|) ((|P0-l| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq
    |l0|
    (|MakeLevel| |MAKE-Struct-axextend-15| |Struct-axextend-15|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|SetLex| |Struct-axextend-15-l-0| 0 |l0| |P0-l|)
  (|SetLex| |Struct-axextend-15--2| 2 |l0| (the |SInt| 0))
  (block-return
    |C102-axextend-generator|
    (|Clos| |e0| |C103-axextend-generBaseFn|)))

(defprog
  ((|C103-axextend-generBaseFn| |Clos| |Clos| |Clos| |Clos|)
    ((|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| nil)
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (block-return
    |C103-axextend-generBaseFn|
    (values
      (|Clos| |e0| |C105-axextend-generDone?|)
      (|Clos| |e0| |C104-axextend-generStepper|)
      (|Clos| |e0| |C106-axextend-generValue|)
      (|Clos| |e0| |C107-axextend-generBound|))))

(defprog
  ((|C104-axextend-generStepper|) ((|e1| |Env|)))
  ((t0 |Word|)
    (t1 |Word|)
    (t2 |Word|)
    (t3 |Word|)
    (t4 |Word|)
    (t5 |Word|)
    (|e2| |Env|)
    (|l2| |Level|)
    (|e3| |Env|)
    (|l3| |Level|))
  (setq |e2| (|EnvNext| |e1|))
  (setq |l2| (|EnvLevel| |e2|))
  (setq |e3| (|EnvNext| |e2|))
  (setq |l3| (|EnvLevel| |e3|))
  (tagbody
    (cases
      (|Lex| |Struct-axextend-15--2| 2 |l2|)
      (1 (go |Lab3|))
      (0 (go |Lab0|)))
    |Lab0|
    (|SetLex| |Struct-axextend-15--1| 1 |l2| (the |Bool| nil))
    |Lab1|
    (|FoamEnvEnsure|
      (|ClosEnv| (|Lex| |Struct-axextend-17-test-7| 7 |l3|)))
    (setq t0 (|Lex| |Struct-axextend-15-l-0| 0 |l2|))
    (when (|PtrIsNil| t0) (go |Lab2|))
    (|SetLex| |Struct-axextend-15--2| 2 |l2| (the |SInt| 1))
    (setq t5 (|Lex| |Struct-axextend-15-l-0| 0 |l2|))
    (when (|PtrIsNil| t5) (go |Lab6|))
    (setq t3 (|RElt| |Struct-axextend-13| |first| 0 t5))
    |Lab7|
    (|SetLex| |Struct-axextend-15--3| 3 |l2| t3)
    (block-return |C104-axextend-generStepper| ())
    |Lab6|
    (setq
      t4
      (|AXL-LiteralToString|
        (|MakeLit| "Cannot select `first' of empty list.")))
    (|AXL-error| t4)
    (go |Lab7|)
    |Lab2|
    (|SetLex| |Struct-axextend-15--1| 1 |l2| (the |Bool| t))
    (block-return |C104-axextend-generStepper| ())
    |Lab3|
    (setq t2 (|Lex| |Struct-axextend-15-l-0| 0 |l2|))
    (when (|PtrIsNil| t2) (go |Lab4|))
    (setq t1 (|RElt| |Struct-axextend-13| |rest| 1 t2))
    |Lab5|
    (|SetLex| |Struct-axextend-15-l-0| 0 |l2| t1)
    (go |Lab1|)
    |Lab4|
    (setq t1 t2)
    (go |Lab5|)))

(defprog
  ((|C105-axextend-generDone?| |Bool|) ((|e1| |Env|)))
  ((|e2| |Env|) (|l2| |Level|))
  (setq |e2| (|EnvNext| |e1|))
  (setq |l2| (|EnvLevel| |e2|))
  (block-return
    |C105-axextend-generDone?|
    (|Lex| |Struct-axextend-15--1| 1 |l2|)))

(defprog
  ((|C106-axextend-generValue| |Word|) ((|e1| |Env|)))
  ((|e2| |Env|) (|l2| |Level|))
  (setq |e2| (|EnvNext| |e1|))
  (setq |l2| (|EnvLevel| |e2|))
  (block-return
    |C106-axextend-generValue|
    (|Lex| |Struct-axextend-15--3| 3 |l2|)))

(defprog
  ((|C107-axextend-generBound| |SInt|) ((|e1| |Env|)))
  ()
  (block-return |C107-axextend-generBound| (the |SInt| -1)))

(defprog
  ((|C108-axextend-bracket| |Word|) ((|P0-g| |Clos|) (|e1| |Env|)))
  ((|T0-t| |Word|)
    (|T1-l| |Word|)
    (|T2-h| |Word|)
    (|T3-a| |Word|)
    (t4 |Clos|)
    (t5 |Clos|)
    (t6 |Clos|)
    (t7 |Clos|)
    (t8 |Record|))
  (tagbody
    (setq |T1-l| nil)
    (setq |T2-h| nil)
    (multiple-value-setq (t4 t5 t6 t7) (|CCall| |P0-g|))
    |Lab0|
    (|CCall| t5)
    (when (|CCall| t4) (go |Lab1|))
    (setq |T3-a| (|CCall| t6))
    (setq |T0-t| |T1-l|)
    (setq t8 (|RNew| |Struct-axextend-13|))
    (|SetRElt| |Struct-axextend-13| |first| 0 t8 |T3-a|)
    (|SetRElt| |Struct-axextend-13| |rest| 1 t8 nil)
    (setq |T1-l| t8)
    (when (|PtrIsNil| |T0-t|) (go |Lab2|))
    (|AXL-rplacd| |T0-t| t8)
    (go |Lab0|)
    |Lab2|
    (setq |T2-h| t8)
    (go |Lab0|)
    |Lab1|
    (block-return |C108-axextend-bracket| |T2-h|)))

(defprog
  ((|C109-axextend-addLevel0| |Clos|)
    ((|P0-domain| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| nil)
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|CCall|
    |G-domainAddNameFn!|
    |P0-domain|
    (|CCall| |G-rtConstNameFn| (|MakeLit| "P")))
  (|CCall| |G-domainAddHash!| |P0-domain| (the |SInt| 200121))
  (block-return
    |C109-axextend-addLevel0|
    (|Clos| |e0| |C110-axextend-addLevel1|)))

(defprog
  ((|C110-axextend-addLevel1| |Word|)
    ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Arr|)
    (t2 |Arr|)
    (t3 |Record|)
    (t4 |Record|)
    (t5 |Record|)
    (t6 |SInt|)
    (t7 |SInt|)
    (t8 |SInt|)
    (t9 |SInt|)
    (t10 |SInt|)
    (t11 |SInt|)
    (t12 |SInt|)
    (t13 |SInt|)
    (t14 |SInt|)
    (t15 |SInt|)
    (t16 |SInt|)
    (t17 |SInt|)
    (|l0| |Level|)
    (|e0| |Env|)
    (|e4| |Env|)
    (|l4| |Level|))
  (setq
    |l0|
    (|MakeLevel| |MAKE-Struct-axextend-16| |Struct-axextend-16|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |e4| (|EnvNext| (|EnvNext| (|EnvNext| |e1|))))
  (setq |l4| (|EnvLevel| |e4|))
  (setq t0 (|ANew| |SInt| (the |SInt| 4)))
  (setq t1 (|ANew| |SInt| (the |SInt| 4)))
  (setq t2 (|ANew| |Word| (the |SInt| 4)))
  (|SetLex| |Struct-axextend-16--3| 3 |l0| |P1-hashcode|)
  (|SetLex|
    |Struct-axextend-16-nil?-2|
    2
    |l0|
    (|Clos| |e0| |C111-axextend-nil?|))
  (|SetLex|
    |Struct-axextend-16-recptr-1|
    1
    |l0|
    (|Clos| |e0| |C112-axextend-recptr|))
  (|SetLex|
    |Struct-axextend-16-value-0|
    0
    |l0|
    (|Clos| |e0| |C113-axextend-value|))
  (setq
    t10
    (|CCall| |G-domainHash!| (|Lex| |Struct-axextend-18-S-0| 0 |l4|)))
  (setq
    t15
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-16--3| 3 |l0|)
      (the |SInt| 74075968)
      (the |SInt| 1073741789)))
  (setq t16 (|SIntAnd| t15 (the |SInt| 16777215)))
  (setq t17 (|SIntShiftUp| t16 (the |SInt| 6)))
  (setq
    t6
    (|SIntPlusMod| (the |SInt| 740244383) t17 (the |SInt| 1073741789)))
  (setq
    t11
    (|SIntPlusMod| t10 (the |SInt| 693187904) (the |SInt| 1073741789)))
  (setq t12 (|SIntAnd| t11 (the |SInt| 16777215)))
  (setq t13 (|SIntShiftUp| t12 (the |SInt| 6)))
  (setq
    t14
    (|SIntPlusMod| (the |SInt| 200121) t13 (the |SInt| 1073741789)))
  (setq
    t7
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-16--3| 3 |l0|)
      (|SIntShiftUp|
        (|SIntAnd|
          (|SIntPlusMod| t14 (the |SInt| 74075968) (the |SInt| 1073741789))
          (the |SInt| 16777215))
        (the |SInt| 6))
      (the |SInt| 1073741789)))
  (setq t8 (|SIntPlusMod| t14 t17 (the |SInt| 1073741789)))
  (setq t9 (|Lex| |Struct-axextend-16--3| 3 |l0|))
  (setq t3 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t3 (the |SInt| 4))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t3 (the |SInt| 4))
  (|SetRElt| |Struct-axextend-5| |values| 2 t3 t0)
  (setq t4 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t4 (the |SInt| 4))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t4 (the |SInt| 4))
  (|SetRElt| |Struct-axextend-5| |values| 2 t4 t1)
  (setq t5 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t5 (the |SInt| 4))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t5 (the |SInt| 4))
  (|SetRElt| |Struct-axextend-5| |values| 2 t5 t2)
  (|CCall| |G-domainAddExports!| |P0-domain| t3 t4 t5)
  (|SetAElt| t0 (the |SInt| 0) (the |SInt| 783695654))
  (|SetAElt| t1 (the |SInt| 0) t6)
  (|SetAElt|
    t2
    (the |SInt| 0)
    (|Lex| |Struct-axextend-16-nil?-2| 2 |l0|))
  (|SetAElt| t0 (the |SInt| 1) (the |SInt| 287357190))
  (|SetAElt| t1 (the |SInt| 1) t7)
  (|SetAElt|
    t2
    (the |SInt| 1)
    (|Lex| |Struct-axextend-16-recptr-1| 1 |l0|))
  (|SetAElt| t0 (the |SInt| 2) (the |SInt| 9730346))
  (|SetAElt| t1 (the |SInt| 2) t8)
  (|SetAElt|
    t2
    (the |SInt| 2)
    (|Lex| |Struct-axextend-16-value-0| 0 |l0|))
  (|SetAElt| t0 (the |SInt| 3) (the |SInt| 352145423))
  (|SetAElt| t1 (the |SInt| 3) t9)
  (|SetAElt| t2 (the |SInt| 3) nil)
  (block-return |C110-axextend-addLevel1| |P0-domain|))

(defprog
  ((|C111-axextend-nil?| |Word|) ((|P0-p| |Word|) (|e1| |Env|)))
  ()
  (block-return |C111-axextend-nil?| (|PtrIsNil| |P0-p|)))

(defprog
  ((|C112-axextend-recptr| |Word|) ((|P0-r| |Record|) (|e1| |Env|)))
  ()
  (block-return |C112-axextend-recptr| |P0-r|))

(defprog
  ((|C113-axextend-value| |Record|) ((|P0-p| |Word|) (|e1| |Env|)))
  ()
  (block-return |C113-axextend-value| |P0-p|))

(defprog
  ((|C114-axextend-axextend| |Word|) ((p0-s |Word|) (|e1| |Env|)))
  ((t0 |Word|)
    (t1 |Arr|)
    (t2 |Record|)
    (t3 |Word|)
    (t4 |Word|)
    (|l0| |Level|)
    (|e0| |Env|)
    (|l1| |Level|))
  (setq
    |l0|
    (|MakeLevel| |MAKE-Struct-axextend-19| |Struct-axextend-19|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (|SetLex| |Struct-axextend-19-S-0| 0 |l0| p0-s)
    (setq t1 (|ANew| |Word| (the |SInt| 1)))
    (setq t2 (|RNew| |Struct-axextend-11|))
    (|SetRElt| |Struct-axextend-11| |size| 0 t2 (the |SInt| 1))
    (|SetRElt| |Struct-axextend-11| |values| 1 t2 t1)
    (when
      (|PtrIsNil| (|Lex| |Struct-axextend-45--11| 11 |l1|))
      (go |Lab3|))
    |Lab1|
    (|SetAElt|
      t1
      (the |SInt| 0)
      (|Lex| |Struct-axextend-19-S-0| 0 |l0|))
    (multiple-value-setq
      (t3 t4)
      (|CCall|
        |G-rtCacheCheck|
        (|Lex| |Struct-axextend-45--11| 11 |l1|)
        t2))
    (when t4 (go |Lab0|))
    (setq
      t0
      (|CCall| |G-extendMake| (|Clos| |e0| |C115-axextend-extend0|)))
    (setq
      t3
      (|CCall|
        |G-rtCacheAdd|
        (|Lex| |Struct-axextend-45--11| 11 |l1|)
        t2
        t0))
    |Lab0|
    (block-return |C114-axextend-axextend| t3)
    |Lab3|
    (|SetLex|
      |Struct-axextend-45--11|
      11
      |l1|
      (|CCall| |G-rtCacheExplicitMake| (the |SInt| 15)))
    (go |Lab1|)))

(defprog
  ((|C115-axextend-extend0| |Clos|) ((|P0-domain| |Word|) (|e1| |Env|)))
  ((t0 |Arr|) (t1 |Record|) (|l1| |Level|) (|e2| |Env|) (|l2| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (setq |e2| (|EnvNext| |e1|))
  (setq |l2| (|EnvLevel| |e2|))
  (setq t0 (|ANew| |Word| (the |SInt| 2)))
  (|SetAElt|
    t0
    (the |SInt| 1)
    (|CCall|
      (|Lex| |Struct-axextend-45-List-3| 3 |l2|)
      (|Lex| |Struct-axextend-19-S-0| 0 |l1|)))
  (|SetAElt|
    t0
    (the |SInt| 0)
    (|CCall|
      |G-axextend_List_412811383|
      (|Lex| |Struct-axextend-19-S-0| 0 |l1|)))
  (setq t1 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axextend-5| |values| 2 t1 t0)
  (|CCall| |G-extendFill!| |P0-domain| t1)
  (block-return |C115-axextend-extend0| |P0-domain|))

(defprog
  ((|C116-axextend-Vector| |Word|) ((p0-s |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Record|)
    (t2 |Word|)
    (t3 |Word|)
    (|l0| |Level|)
    (|e0| |Env|)
    (|l1| |Level|))
  (setq
    |l0|
    (|MakeLevel| |MAKE-Struct-axextend-23| |Struct-axextend-23|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (|SetLex| |Struct-axextend-23-S-0| 0 |l0| p0-s)
    (setq t0 (|ANew| |Word| (the |SInt| 1)))
    (setq t1 (|RNew| |Struct-axextend-11|))
    (|SetRElt| |Struct-axextend-11| |size| 0 t1 (the |SInt| 1))
    (|SetRElt| |Struct-axextend-11| |values| 1 t1 t0)
    (when
      (|PtrIsNil| (|Lex| |Struct-axextend-45--12| 12 |l1|))
      (go |Lab3|))
    |Lab1|
    (|SetAElt|
      t0
      (the |SInt| 0)
      (|Lex| |Struct-axextend-23-S-0| 0 |l0|))
    (multiple-value-setq
      (t2 t3)
      (|CCall|
        |G-rtCacheCheck|
        (|Lex| |Struct-axextend-45--12| 12 |l1|)
        t1))
    (when t3 (go |Lab0|))
    (setq
      t2
      (|CCall| |G-domainMake| (|Clos| |e0| |C117-axextend-addLevel0|)))
    (setq
      t2
      (|CCall|
        |G-rtCacheAdd|
        (|Lex| |Struct-axextend-45--12| 12 |l1|)
        t1
        t2))
    |Lab0|
    (block-return |C116-axextend-Vector| t2)
    |Lab3|
    (|SetLex|
      |Struct-axextend-45--12|
      12
      |l1|
      (|CCall| |G-rtCacheExplicitMake| (the |SInt| 15)))
    (go |Lab1|)))

(defprog
  ((|C117-axextend-addLevel0| |Clos|)
    ((|P0-domain| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|) (|l1| |Level|))
  (setq |l0| nil)
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |l1| (|EnvLevel| |e1|))
  (|CCall|
    |G-domainAddNameFn!|
    |P0-domain|
    (|CCall|
      |G-rtSingleParamNameFn|
      (|MakeLit| "Vector")
      (|Lex| |Struct-axextend-23-S-0| 0 |l1|)))
  (|CCall|
    |G-domainAddHash!|
    |P0-domain|
    (|SIntPlusMod|
      (|CCall| |G-domainHash!| (|Lex| |Struct-axextend-23-S-0| 0 |l1|))
      (the |SInt| 756152896)
      (the |SInt| 1073741789)))
  (block-return
    |C117-axextend-addLevel0|
    (|Clos| |e0| |C118-axextend-addLevel1|)))

(defprog
  ((|C118-axextend-addLevel1| |Word|)
    ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Arr|)
    (t2 |Arr|)
    (t3 |Record|)
    (t4 |Record|)
    (t5 |Record|)
    (t6 |SInt|)
    (t7 |SInt|)
    (t8 |SInt|)
    (t9 |SInt|)
    (t10 |SInt|)
    (t11 |SInt|)
    (t12 |SInt|)
    (t13 |SInt|)
    (t14 |SInt|)
    (t15 |SInt|)
    (t16 |SInt|)
    (t17 |SInt|)
    (t18 |SInt|)
    (t19 |SInt|)
    (t20 |SInt|)
    (t21 |SInt|)
    (t22 |SInt|)
    (t23 |SInt|)
    (t24 |SInt|)
    (t25 |SInt|)
    (t26 |SInt|)
    (|l0| |Level|)
    (|e0| |Env|)
    (|e2| |Env|)
    (|l2| |Level|))
  (setq
    |l0|
    (|MakeLevel| |MAKE-Struct-axextend-22| |Struct-axextend-22|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |e2| (|EnvNext| |e1|))
  (setq |l2| (|EnvLevel| |e2|))
  (setq t0 (|ANew| |SInt| (the |SInt| 7)))
  (setq t1 (|ANew| |SInt| (the |SInt| 7)))
  (setq t2 (|ANew| |Word| (the |SInt| 7)))
  (|SetLex| |Struct-axextend-22--7| 7 |l0| |P1-hashcode|)
  (|SetLex|
    |Struct-axextend-22-bracket-5|
    5
    |l0|
    (|Clos| |e0| |C119-axextend-bracket|))
  (|SetLex|
    |Struct-axextend-22-bracket-6|
    6
    |l0|
    (|Clos| |e0| |C120-axextend-bracket|))
  (|SetLex|
    |Struct-axextend-22-new-4|
    4
    |l0|
    (|Clos| |e0| |C121-axextend-new|))
  (|SetLex|
    |Struct-axextend-22-generator-3|
    3
    |l0|
    (|Clos| |e0| |C122-axextend-generator|))
  (|SetLex|
    |Struct-axextend-22-#-2|
    2
    |l0|
    (|Clos| |e0| |C128-axextend-#|))
  (|SetLex|
    |Struct-axextend-22-apply-1|
    1
    |l0|
    (|Clos| |e0| |C129-axextend-apply|))
  (|SetLex|
    |Struct-axextend-22-set!-0|
    0
    |l0|
    (|Clos| |e0| |C130-axextend-set!|))
  (setq
    t14
    (|CCall| |G-domainHash!| (|Lex| |Struct-axextend-23-S-0| 0 |l2|)))
  (|FoamEnvEnsure| (|ClosEnv| |G-axextend_List_134950155|))
  (setq
    t15
    (|SIntPlusMod| t14 (the |SInt| 638488576) (the |SInt| 1073741789)))
  (setq
    t24
    (|SIntPlusMod| t15 (the |SInt| 74075968) (the |SInt| 1073741789)))
  (|FoamEnvEnsure| (|ClosEnv| |G-axextend_List_134950155|))
  (|FoamEnvEnsure| (|ClosEnv| |G-axextend_List_134950155|))
  (setq
    t6
    (|SIntPlusMod|
      t15
      (|SIntShiftUp|
        (|SIntAnd|
          (|SIntPlusMod|
            t15
            (|SIntShiftUp|
              (|SIntAnd|
                (|SIntPlusMod| t14 (the |SInt| 74075968) (the |SInt| 1073741789))
                (the |SInt| 16777215))
              (the |SInt| 6))
            (the |SInt| 1073741789))
          (the |SInt| 16777215))
        (the |SInt| 6))
      (the |SInt| 1073741789)))
  (|FoamEnvEnsure| (|ClosEnv| |G-axextend_List_134950155|))
  (setq t25 (|SIntAnd| t24 (the |SInt| 16777215)))
  (setq t26 (|SIntShiftUp| t25 (the |SInt| 6)))
  (setq
    t7
    (|SIntPlusMod| (the |SInt| 740244383) t26 (the |SInt| 1073741789)))
  (|FoamEnvEnsure| (|ClosEnv| |G-axextend_List_134950155|))
  (setq t8 (|SIntPlusMod| t14 t26 (the |SInt| 1073741789)))
  (|FoamEnvEnsure| (|ClosEnv| |G-axextend_List_134950155|))
  (|FoamEnvEnsure| (|ClosEnv| |G-axextend_List_134950155|))
  (setq t9 (|SIntPlusMod| t15 t26 (the |SInt| 1073741789)))
  (setq
    t16
    (|SIntPlusMod| t14 (the |SInt| 5805568) (the |SInt| 1073741789)))
  (setq
    t10
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-22--7| 7 |l0|)
      (|SIntShiftUp|
        (|SIntAnd|
          (|SIntPlusMod| t16 (the |SInt| 74075968) (the |SInt| 1073741789))
          (the |SInt| 16777215))
        (the |SInt| 6))
      (the |SInt| 1073741789)))
  (setq
    t11
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-22--7| 7 |l0|)
      (|SIntShiftUp|
        (|SIntAnd|
          (|SIntPlusMod|
            (|SIntPlusMod| t14 (the |SInt| 889882048) (the |SInt| 1073741789))
            (the |SInt| 74075968)
            (the |SInt| 1073741789))
          (the |SInt| 16777215))
        (the |SInt| 6))
      (the |SInt| 1073741789)))
  (setq
    t12
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-22--7| 7 |l0|)
      (|SIntShiftUp|
        (|SIntAnd|
          (|SIntPlusMod| t14 (the |SInt| 974156096) (the |SInt| 1073741789))
          (the |SInt| 16777215))
        (the |SInt| 6))
      (the |SInt| 1073741789)))
  (setq
    t17
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-22--7| 7 |l0|)
      (the |SInt| 74075968)
      (the |SInt| 1073741789)))
  (setq t18 (|SIntAnd| t17 (the |SInt| 16777215)))
  (setq t19 (|SIntShiftUp| t18 (the |SInt| 6)))
  (setq t13 (|SIntPlusMod| t16 t19 (the |SInt| 1073741789)))
  (setq
    t20
    (|SIntPlusMod| (the |SInt| 142471813) t19 (the |SInt| 1073741789)))
  (setq t21 (|SIntAnd| t20 (the |SInt| 16777215)))
  (setq t22 (|SIntShiftUp| t21 (the |SInt| 6)))
  (setq t23 (|SIntPlusMod| t14 t22 (the |SInt| 1073741789)))
  (setq t3 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t3 (the |SInt| 7))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t3 (the |SInt| 7))
  (|SetRElt| |Struct-axextend-5| |values| 2 t3 t0)
  (setq t4 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t4 (the |SInt| 7))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t4 (the |SInt| 7))
  (|SetRElt| |Struct-axextend-5| |values| 2 t4 t1)
  (setq t5 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t5 (the |SInt| 7))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t5 (the |SInt| 7))
  (|SetRElt| |Struct-axextend-5| |values| 2 t5 t2)
  (|CCall| |G-domainAddExports!| |P0-domain| t3 t4 t5)
  (|SetLex|
    |Struct-axextend-22-dom-13|
    13
    |l0|
    (|CCall|
      |G-axextend_List_134950155|
      (|Lex| |Struct-axextend-23-S-0| 0 |l2|)))
  (|SetLex|
    |Struct-axextend-22-empty-10|
    10
    |l0|
    (|CCall|
      |G-stdGetRetWord0|
      (|CCall|
        |G-rtDelayedGetExport!|
        (|Lex| |Struct-axextend-22-dom-13| 13 |l0|)
        (the |SInt| 357262396)
        t24)))
  (|SetLex|
    |Struct-axextend-22-cons-11|
    11
    |l0|
    (|CCall|
      |G-stdGetWordWordRetWord0|
      (|CCall|
        |G-rtDelayedGetExport!|
        (|Lex| |Struct-axextend-22-dom-13| 13 |l0|)
        (the |SInt| 865800279)
        t6)))
  (|SetLex|
    |Struct-axextend-22-test-12|
    12
    |l0|
    (|CCall|
      |G-stdGetWordRetWord0|
      (|CCall|
        |G-rtDelayedGetExport!|
        (|Lex| |Struct-axextend-22-dom-13| 13 |l0|)
        (the |SInt| 5509732)
        t7)))
  (|SetLex|
    |Struct-axextend-22-first-8|
    8
    |l0|
    (|CCall|
      |G-stdGetWordRetWord0|
      (|CCall|
        |G-rtDelayedGetExport!|
        (|Lex| |Struct-axextend-22-dom-13| 13 |l0|)
        (the |SInt| 682776373)
        t8)))
  (|SetLex|
    |Struct-axextend-22-rest-9|
    9
    |l0|
    (|CCall|
      |G-stdGetWordRetWord0|
      (|CCall|
        |G-rtDelayedGetExport!|
        (|Lex| |Struct-axextend-22-dom-13| 13 |l0|)
        (the |SInt| 715582562)
        t9)))
  (|SetAElt| t0 (the |SInt| 0) (the |SInt| 44638651))
  (|SetAElt| t1 (the |SInt| 0) t10)
  (|SetAElt|
    t2
    (the |SInt| 0)
    (|Lex| |Struct-axextend-22-bracket-5| 5 |l0|))
  (|SetAElt| t0 (the |SInt| 1) (the |SInt| 44638651))
  (|SetAElt| t1 (the |SInt| 1) t11)
  (|SetAElt|
    t2
    (the |SInt| 1)
    (|Lex| |Struct-axextend-22-bracket-6| 6 |l0|))
  (|SetAElt| t0 (the |SInt| 2) (the |SInt| 318528389))
  (|SetAElt| t1 (the |SInt| 2) t12)
  (|SetAElt|
    t2
    (the |SInt| 2)
    (|Lex| |Struct-axextend-22-new-4| 4 |l0|))
  (|SetAElt| t0 (the |SInt| 3) (the |SInt| 113320568))
  (|SetAElt| t1 (the |SInt| 3) t13)
  (|SetAElt|
    t2
    (the |SInt| 3)
    (|Lex| |Struct-axextend-22-generator-3| 3 |l0|))
  (|SetAElt| t0 (the |SInt| 4) (the |SInt| 200076))
  (|SetAElt| t1 (the |SInt| 4) t20)
  (|SetAElt|
    t2
    (the |SInt| 4)
    (|Lex| |Struct-axextend-22-#-2| 2 |l0|))
  (|SetAElt| t0 (the |SInt| 5) (the |SInt| 306472243))
  (|SetAElt| t1 (the |SInt| 5) t23)
  (|SetAElt|
    t2
    (the |SInt| 5)
    (|Lex| |Struct-axextend-22-apply-1| 1 |l0|))
  (|SetAElt| t0 (the |SInt| 6) (the |SInt| 55906833))
  (|SetAElt| t1 (the |SInt| 6) t23)
  (|SetAElt|
    t2
    (the |SInt| 6)
    (|Lex| |Struct-axextend-22-set!-0| 0 |l0|))
  (block-return |C118-axextend-addLevel1| |P0-domain|))

(defprog
  ((|C119-axextend-bracket| |Word|) ((|P0-g| |Clos|) (|e1| |Env|)))
  ((|T0-v| |Word|)
    (|T1-n| |Word|)
    (|T2-l| |Word|)
    (|T3-e| |Word|)
    (t4 |Clos|)
    (t5 |Clos|)
    (t6 |Clos|)
    (t7 |Clos|)
    (t8 |Word|)
    (t9 |Word|)
    (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (setq |T2-l| (|CCall| (|Lex| |Struct-axextend-22-empty-10| 10 |l1|)))
    (setq |T1-n| (the |SInt| 0))
    (multiple-value-setq (t4 t5 t6 t7) (|CCall| |P0-g|))
    |Lab0|
    (|CCall| t5)
    (when (|CCall| t4) (go |Lab1|))
    (setq |T3-e| (|CCall| t6))
    (setq
      |T2-l|
      (|CCall| (|Lex| |Struct-axextend-22-cons-11| 11 |l1|) |T3-e| |T2-l|))
    (setq |T1-n| (|AXL-incSingleInteger| |T1-n|))
    (go |Lab0|)
    |Lab1|
    (setq |T0-v| (|AXL-arrayNew| |T1-n|))
    |Lab2|
    (when
      (|CCall| (|Lex| |Struct-axextend-22-test-12| 12 |l1|) |T2-l|)
      (go |Lab6|))
    (block-return |C119-axextend-bracket| |T0-v|)
    |Lab6|
    (setq
      t9
      (|CCall| (|Lex| |Struct-axextend-22-first-8| 8 |l1|) |T2-l|))
    (setq t8 (|AXL-decSingleInteger| |T1-n|))
    (|AXL-arraySet| |T0-v| t8 t9)
    (setq
      |T2-l|
      (|CCall| (|Lex| |Struct-axextend-22-rest-9| 9 |l1|) |T2-l|))
    (setq |T1-n| (|AXL-decSingleInteger| |T1-n|))
    (go |Lab2|)))

(defprog
  ((|C120-axextend-bracket| |Word|) ((|P0-t| |Word|) (|e1| |Env|)))
  ((|T0-v| |Word|) (|T1-n| |Word|) (t2 |Word|) (t3 |Word|) (t4 |Word|))
  (tagbody
    (setq |T1-n| (|RElt| |Struct-axextend-46| |sz| 0 |P0-t|))
    (setq |T0-v| (|AXL-arrayNew| |T1-n|))
    |Lab0|
    (when (|AXL-leSingleInteger| (the |SInt| 1) |T1-n|) (go |Lab3|))
    (block-return |C120-axextend-bracket| |T0-v|)
    |Lab3|
    (setq t2 (|AXL-decSingleInteger| |T1-n|))
    (setq
      t4
      (|AXL-arrayRef| (|RElt| |Struct-axextend-46| |values| 1 |P0-t|) t2))
    (setq t3 (|AXL-decSingleInteger| |T1-n|))
    (|AXL-arraySet| |T0-v| t3 t4)
    (setq |T1-n| (|AXL-decSingleInteger| |T1-n|))
    (go |Lab0|)))

(defprog
  ((|C121-axextend-new| |Word|)
    ((|P0-n| |Word|) (|P1-x| |Word|) (|e1| |Env|)))
  ((|T0-v| |Word|) (t1 |Word|))
  (tagbody
    (setq |T0-v| (|AXL-arrayNew| |P0-n|))
    |Lab0|
    (when (|AXL-leSingleInteger| (the |SInt| 1) |P0-n|) (go |Lab3|))
    (block-return |C121-axextend-new| |T0-v|)
    |Lab3|
    (setq t1 (|AXL-decSingleInteger| |P0-n|))
    (|AXL-arraySet| |T0-v| t1 |P1-x|)
    (setq |P0-n| (|AXL-decSingleInteger| |P0-n|))
    (go |Lab0|)))

(defprog
  ((|C122-axextend-generator| |Clos|) ((|P0-v| |Word|) (|e1| |Env|)))
  ((t0 |Word|) (|l0| |Level|) (|e0| |Env|))
  (setq
    |l0|
    (|MakeLevel| |MAKE-Struct-axextend-20| |Struct-axextend-20|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|SetLex| |Struct-axextend-20-v-0| 0 |l0| |P0-v|)
  (setq t0 (|Lex| |Struct-axextend-20-v-0| 0 |l0|))
  (|SetLex| |Struct-axextend-20-n-2| 2 |l0| (|AXL-arraySize| t0))
  (|SetLex| |Struct-axextend-20-i-1| 1 |l0| (the |SInt| 1))
  (|SetLex| |Struct-axextend-20--4| 4 |l0| (the |SInt| 0))
  (block-return
    |C122-axextend-generator|
    (|Clos| |e0| |C123-axextend-generBaseFn|)))

(defprog
  ((|C123-axextend-generBaseFn| |Clos| |Clos| |Clos| |Clos|)
    ((|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| nil)
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (block-return
    |C123-axextend-generBaseFn|
    (values
      (|Clos| |e0| |C125-axextend-generDone?|)
      (|Clos| |e0| |C124-axextend-generStepper|)
      (|Clos| |e0| |C126-axextend-generValue|)
      (|Clos| |e0| |C127-axextend-generBound|))))

(defprog
  ((|C124-axextend-generStepper|) ((|e1| |Env|)))
  ((t0 |Word|)
    (t1 |Word|)
    (t2 |Word|)
    (t3 |Word|)
    (t4 |Word|)
    (t5 |Word|)
    (t6 |Word|)
    (|e2| |Env|)
    (|l2| |Level|)
    (|e3| |Env|)
    (|l3| |Level|))
  (setq |e2| (|EnvNext| |e1|))
  (setq |l2| (|EnvLevel| |e2|))
  (setq |e3| (|EnvNext| |e2|))
  (setq |l3| (|EnvLevel| |e3|))
  (tagbody
    (cases
      (|Lex| |Struct-axextend-20--4| 4 |l2|)
      (1 (go |Lab3|))
      (0 (go |Lab0|)))
    |Lab0|
    (|SetLex| |Struct-axextend-20--3| 3 |l2| (the |Bool| nil))
    |Lab1|
    (setq t2 (|Lex| |Struct-axextend-20-i-1| 1 |l2|))
    (setq t3 (|Lex| |Struct-axextend-20-n-2| 2 |l2|))
    (when (|AXL-leSingleInteger| t2 t3) (go |Lab5|))
    (|SetLex| |Struct-axextend-20--3| 3 |l2| (the |Bool| t))
    (block-return |C124-axextend-generStepper| ())
    |Lab5|
    (|SetLex| |Struct-axextend-20--4| 4 |l2| (the |SInt| 1))
    (|FoamEnvEnsure|
      (|ClosEnv| (|Lex| |Struct-axextend-22-apply-1| 1 |l3|)))
    (setq t5 (|Lex| |Struct-axextend-20-v-0| 0 |l2|))
    (setq t6 (|Lex| |Struct-axextend-20-i-1| 1 |l2|))
    (setq t4 (|AXL-decSingleInteger| t6))
    (setq t0 (|AXL-arrayRef| t5 t4))
    (|SetLex| |Struct-axextend-20--5| 5 |l2| t0)
    (block-return |C124-axextend-generStepper| ())
    |Lab3|
    (setq t1 (|Lex| |Struct-axextend-20-i-1| 1 |l2|))
    (|SetLex|
      |Struct-axextend-20-i-1|
      1
      |l2|
      (|AXL-incSingleInteger| t1))
    (go |Lab1|)))

(defprog
  ((|C125-axextend-generDone?| |Bool|) ((|e1| |Env|)))
  ((|e2| |Env|) (|l2| |Level|))
  (setq |e2| (|EnvNext| |e1|))
  (setq |l2| (|EnvLevel| |e2|))
  (block-return
    |C125-axextend-generDone?|
    (|Lex| |Struct-axextend-20--3| 3 |l2|)))

(defprog
  ((|C126-axextend-generValue| |Word|) ((|e1| |Env|)))
  ((|e2| |Env|) (|l2| |Level|))
  (setq |e2| (|EnvNext| |e1|))
  (setq |l2| (|EnvLevel| |e2|))
  (block-return
    |C126-axextend-generValue|
    (|Lex| |Struct-axextend-20--5| 5 |l2|)))

(defprog
  ((|C127-axextend-generBound| |SInt|) ((|e1| |Env|)))
  ()
  (block-return |C127-axextend-generBound| (the |SInt| -1)))

(defprog
  ((|C128-axextend-#| |Word|) ((|P0-v| |Word|) (|e1| |Env|)))
  ()
  (block-return |C128-axextend-#| (|AXL-arraySize| |P0-v|)))

(defprog
  ((|C129-axextend-apply| |Word|)
    ((|P0-x| |Word|) (|P1-i| |Word|) (|e1| |Env|)))
  ((t0 |Word|))
  (setq t0 (|AXL-decSingleInteger| |P1-i|))
  (block-return |C129-axextend-apply| (|AXL-arrayRef| |P0-x| t0)))

(defprog
  ((|C130-axextend-set!|)
    ((|P0-x| |Word|) (|P1-n| |Word|) (|P2-v| |Word|) (|e1| |Env|)))
  ((t0 |Word|))
  (setq t0 (|AXL-decSingleInteger| |P1-n|))
  (|AXL-arraySet| |P0-x| t0 |P2-v|)
  (block-return |C130-axextend-set!| ()))

(defprog
  ((|C131-axextend-axextend| |Word|) ((p0-s |Word|) (|e1| |Env|)))
  ((t0 |Word|)
    (t1 |Arr|)
    (t2 |Record|)
    (t3 |Word|)
    (t4 |Word|)
    (|l0| |Level|)
    (|e0| |Env|)
    (|l1| |Level|))
  (setq
    |l0|
    (|MakeLevel| |MAKE-Struct-axextend-24| |Struct-axextend-24|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (|SetLex| |Struct-axextend-24-S-0| 0 |l0| p0-s)
    (setq t1 (|ANew| |Word| (the |SInt| 1)))
    (setq t2 (|RNew| |Struct-axextend-11|))
    (|SetRElt| |Struct-axextend-11| |size| 0 t2 (the |SInt| 1))
    (|SetRElt| |Struct-axextend-11| |values| 1 t2 t1)
    (when
      (|PtrIsNil| (|Lex| |Struct-axextend-45--13| 13 |l1|))
      (go |Lab3|))
    |Lab1|
    (|SetAElt|
      t1
      (the |SInt| 0)
      (|Lex| |Struct-axextend-24-S-0| 0 |l0|))
    (multiple-value-setq
      (t3 t4)
      (|CCall|
        |G-rtCacheCheck|
        (|Lex| |Struct-axextend-45--13| 13 |l1|)
        t2))
    (when t4 (go |Lab0|))
    (setq
      t0
      (|CCall| |G-extendMake| (|Clos| |e0| |C132-axextend-extend0|)))
    (setq
      t3
      (|CCall|
        |G-rtCacheAdd|
        (|Lex| |Struct-axextend-45--13| 13 |l1|)
        t2
        t0))
    |Lab0|
    (block-return |C131-axextend-axextend| t3)
    |Lab3|
    (|SetLex|
      |Struct-axextend-45--13|
      13
      |l1|
      (|CCall| |G-rtCacheExplicitMake| (the |SInt| 15)))
    (go |Lab1|)))

(defprog
  ((|C132-axextend-extend0| |Clos|) ((|P0-domain| |Word|) (|e1| |Env|)))
  ((t0 |Arr|) (t1 |Record|) (|l1| |Level|) (|e2| |Env|) (|l2| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (setq |e2| (|EnvNext| |e1|))
  (setq |l2| (|EnvLevel| |e2|))
  (setq t0 (|ANew| |Word| (the |SInt| 2)))
  (|SetAElt|
    t0
    (the |SInt| 1)
    (|CCall|
      (|Lex| |Struct-axextend-45-Vector-2| 2 |l2|)
      (|Lex| |Struct-axextend-24-S-0| 0 |l1|)))
  (|SetAElt|
    t0
    (the |SInt| 0)
    (|CCall|
      |G-axextend_Vector_075828558|
      (|Lex| |Struct-axextend-24-S-0| 0 |l1|)))
  (setq t1 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axextend-5| |values| 2 t1 t0)
  (|CCall| |G-extendFill!| |P0-domain| t1)
  (block-return |C132-axextend-extend0| |P0-domain|))

(defprog
  ((|C133-axextend-Matrix| |Word|) ((p0-r |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Record|)
    (t2 |Word|)
    (t3 |Word|)
    (|l0| |Level|)
    (|e0| |Env|)
    (|l1| |Level|))
  (setq
    |l0|
    (|MakeLevel| |MAKE-Struct-axextend-26| |Struct-axextend-26|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (|SetLex| |Struct-axextend-26-R-0| 0 |l0| p0-r)
    (setq t0 (|ANew| |Word| (the |SInt| 1)))
    (setq t1 (|RNew| |Struct-axextend-11|))
    (|SetRElt| |Struct-axextend-11| |size| 0 t1 (the |SInt| 1))
    (|SetRElt| |Struct-axextend-11| |values| 1 t1 t0)
    (when
      (|PtrIsNil| (|Lex| |Struct-axextend-45--14| 14 |l1|))
      (go |Lab3|))
    |Lab1|
    (|SetAElt|
      t0
      (the |SInt| 0)
      (|Lex| |Struct-axextend-26-R-0| 0 |l0|))
    (multiple-value-setq
      (t2 t3)
      (|CCall|
        |G-rtCacheCheck|
        (|Lex| |Struct-axextend-45--14| 14 |l1|)
        t1))
    (when t3 (go |Lab0|))
    (setq
      t2
      (|CCall| |G-domainMake| (|Clos| |e0| |C134-axextend-addLevel0|)))
    (setq
      t2
      (|CCall|
        |G-rtCacheAdd|
        (|Lex| |Struct-axextend-45--14| 14 |l1|)
        t1
        t2))
    |Lab0|
    (block-return |C133-axextend-Matrix| t2)
    |Lab3|
    (|SetLex|
      |Struct-axextend-45--14|
      14
      |l1|
      (|CCall| |G-rtCacheExplicitMake| (the |SInt| 15)))
    (go |Lab1|)))

(defprog
  ((|C134-axextend-addLevel0| |Clos|)
    ((|P0-domain| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|) (|l1| |Level|))
  (setq |l0| nil)
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |l1| (|EnvLevel| |e1|))
  (|CCall|
    |G-domainAddNameFn!|
    |P0-domain|
    (|CCall|
      |G-rtSingleParamNameFn|
      (|MakeLit| "Matrix")
      (|Lex| |Struct-axextend-26-R-0| 0 |l1|)))
  (|CCall|
    |G-domainAddHash!|
    |P0-domain|
    (|SIntPlusMod|
      (|CCall| |G-domainHash!| (|Lex| |Struct-axextend-26-R-0| 0 |l1|))
      (the |SInt| 768375488)
      (the |SInt| 1073741789)))
  (block-return
    |C134-axextend-addLevel0|
    (|Clos| |e0| |C135-axextend-addLevel1|)))

(defprog
  ((|C135-axextend-addLevel1| |Word|)
    ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Arr|)
    (t2 |Arr|)
    (t3 |Record|)
    (t4 |Record|)
    (t5 |Record|)
    (t6 |SInt|)
    (t7 |SInt|)
    (t8 |SInt|)
    (t9 |SInt|)
    (t10 |SInt|)
    (t11 |SInt|)
    (t12 |SInt|)
    (t13 |SInt|)
    (t14 |SInt|)
    (t15 |SInt|)
    (t16 |SInt|)
    (t17 |SInt|)
    (|l0| |Level|)
    (|e0| |Env|)
    (|e2| |Env|)
    (|l2| |Level|))
  (setq
    |l0|
    (|MakeLevel| |MAKE-Struct-axextend-25| |Struct-axextend-25|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |e2| (|EnvNext| |e1|))
  (setq |l2| (|EnvLevel| |e2|))
  (setq t0 (|ANew| |SInt| (the |SInt| 4)))
  (setq t1 (|ANew| |SInt| (the |SInt| 4)))
  (setq t2 (|ANew| |Word| (the |SInt| 4)))
  (|SetLex| |Struct-axextend-25--4| 4 |l0| |P1-hashcode|)
  (|SetLex|
    |Struct-axextend-25-apply-3|
    3
    |l0|
    (|Clos| |e0| |C136-axextend-apply|))
  (|SetLex|
    |Struct-axextend-25-set!-2|
    2
    |l0|
    (|Clos| |e0| |C137-axextend-set!|))
  (|SetLex|
    |Struct-axextend-25-qelt-1|
    1
    |l0|
    (|Clos| |e0| |C138-axextend-qelt|))
  (|SetLex|
    |Struct-axextend-25-qsetelt!-0|
    0
    |l0|
    (|Clos| |e0| |C139-axextend-qsetelt!|))
  (setq
    t7
    (|CCall| |G-domainHash!| (|Lex| |Struct-axextend-26-R-0| 0 |l2|)))
  (setq
    t8
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-25--4| 4 |l0|)
      (the |SInt| 74075968)
      (the |SInt| 1073741789)))
  (setq t9 (|SIntAnd| t8 (the |SInt| 16777215)))
  (setq t10 (|SIntShiftUp| t9 (the |SInt| 6)))
  (setq
    t11
    (|SIntPlusMod| (the |SInt| 484208045) t10 (the |SInt| 1073741789)))
  (setq t12 (|SIntAnd| t11 (the |SInt| 16777215)))
  (setq t13 (|SIntShiftUp| t12 (the |SInt| 6)))
  (setq
    t14
    (|SIntPlusMod| (the |SInt| 484208045) t13 (the |SInt| 1073741789)))
  (setq t15 (|SIntAnd| t14 (the |SInt| 16777215)))
  (setq t16 (|SIntShiftUp| t15 (the |SInt| 6)))
  (setq t17 (|SIntPlusMod| t7 t16 (the |SInt| 1073741789)))
  (setq
    t6
    (|SIntPlusMod|
      t7
      (|SIntShiftUp| (|SIntAnd| t17 (the |SInt| 16777215)) (the |SInt| 6))
      (the |SInt| 1073741789)))
  (setq t3 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t3 (the |SInt| 4))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t3 (the |SInt| 4))
  (|SetRElt| |Struct-axextend-5| |values| 2 t3 t0)
  (setq t4 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t4 (the |SInt| 4))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t4 (the |SInt| 4))
  (|SetRElt| |Struct-axextend-5| |values| 2 t4 t1)
  (setq t5 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t5 (the |SInt| 4))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t5 (the |SInt| 4))
  (|SetRElt| |Struct-axextend-5| |values| 2 t5 t2)
  (|CCall| |G-domainAddExports!| |P0-domain| t3 t4 t5)
  (|SetAElt| t0 (the |SInt| 0) (the |SInt| 306472243))
  (|SetAElt| t1 (the |SInt| 0) t17)
  (|SetAElt|
    t2
    (the |SInt| 0)
    (|Lex| |Struct-axextend-25-apply-3| 3 |l0|))
  (|SetAElt| t0 (the |SInt| 1) (the |SInt| 55906833))
  (|SetAElt| t1 (the |SInt| 1) t6)
  (|SetAElt|
    t2
    (the |SInt| 1)
    (|Lex| |Struct-axextend-25-set!-2| 2 |l0|))
  (|SetAElt| t0 (the |SInt| 2) (the |SInt| 632239194))
  (|SetAElt| t1 (the |SInt| 2) t17)
  (|SetAElt|
    t2
    (the |SInt| 2)
    (|Lex| |Struct-axextend-25-qelt-1| 1 |l0|))
  (|SetAElt| t0 (the |SInt| 3) (the |SInt| 301553003))
  (|SetAElt| t1 (the |SInt| 3) t6)
  (|SetAElt|
    t2
    (the |SInt| 3)
    (|Lex| |Struct-axextend-25-qsetelt!-0| 0 |l0|))
  (block-return |C135-axextend-addLevel1| |P0-domain|))

(defprog
  ((|C136-axextend-apply| |Word|)
    ((|P0-m| |Word|) (|P1-i| |Word|) (|P2-j| |Word|) (|e1| |Env|)))
  ((t0 |Word|) (t1 |BInt|) (t2 |BInt|))
  (setq t2 (|BIntPrev| |P1-i|))
  (setq t0 (|AXL-arrayRef| |P0-m| t2))
  (setq t1 (|BIntPrev| |P2-j|))
  (block-return |C136-axextend-apply| (|AXL-arrayRef| t0 t1)))

(defprog
  ((|C137-axextend-set!| |Word|)
    ((|P0-m| |Word|)
      (|P1-i| |Word|)
      (|P2-j| |Word|)
      (|P3-v| |Word|)
      (|e1| |Env|)))
  ((t0 |Word|) (t1 |BInt|) (t2 |BInt|))
  (setq t2 (|BIntPrev| |P1-i|))
  (setq t0 (|AXL-arrayRef| |P0-m| t2))
  (setq t1 (|BIntPrev| |P2-j|))
  (|AXL-arraySet| t0 t1 |P3-v|)
  (block-return |C137-axextend-set!| |P3-v|))

(defprog
  ((|C138-axextend-qelt| |Word|)
    ((|P0-m| |Word|) (|P1-i| |Word|) (|P2-j| |Word|) (|e1| |Env|)))
  ((t0 |Word|) (t1 |BInt|) (t2 |BInt|))
  (setq t2 (|BIntPrev| |P1-i|))
  (setq t0 (|AXL-arrayRef| |P0-m| t2))
  (setq t1 (|BIntPrev| |P2-j|))
  (block-return |C138-axextend-qelt| (|AXL-arrayRef| t0 t1)))

(defprog
  ((|C139-axextend-qsetelt!| |Word|)
    ((|P0-m| |Word|)
      (|P1-i| |Word|)
      (|P2-j| |Word|)
      (|P3-v| |Word|)
      (|e1| |Env|)))
  ((t0 |Word|) (t1 |BInt|) (t2 |BInt|))
  (setq t2 (|BIntPrev| |P1-i|))
  (setq t0 (|AXL-arrayRef| |P0-m| t2))
  (setq t1 (|BIntPrev| |P2-j|))
  (|AXL-arraySet| t0 t1 |P3-v|)
  (block-return |C139-axextend-qsetelt!| |P3-v|))

(defprog
  ((|C140-axextend-axextend| |Word|) ((p0-r |Word|) (|e1| |Env|)))
  ((t0 |Word|)
    (t1 |Arr|)
    (t2 |Record|)
    (t3 |Word|)
    (t4 |Word|)
    (|l0| |Level|)
    (|e0| |Env|)
    (|l1| |Level|))
  (setq
    |l0|
    (|MakeLevel| |MAKE-Struct-axextend-27| |Struct-axextend-27|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (|SetLex| |Struct-axextend-27-R-0| 0 |l0| p0-r)
    (setq t1 (|ANew| |Word| (the |SInt| 1)))
    (setq t2 (|RNew| |Struct-axextend-11|))
    (|SetRElt| |Struct-axextend-11| |size| 0 t2 (the |SInt| 1))
    (|SetRElt| |Struct-axextend-11| |values| 1 t2 t1)
    (when
      (|PtrIsNil| (|Lex| |Struct-axextend-45--15| 15 |l1|))
      (go |Lab3|))
    |Lab1|
    (|SetAElt|
      t1
      (the |SInt| 0)
      (|Lex| |Struct-axextend-27-R-0| 0 |l0|))
    (multiple-value-setq
      (t3 t4)
      (|CCall|
        |G-rtCacheCheck|
        (|Lex| |Struct-axextend-45--15| 15 |l1|)
        t2))
    (when t4 (go |Lab0|))
    (setq
      t0
      (|CCall| |G-extendMake| (|Clos| |e0| |C141-axextend-extend0|)))
    (setq
      t3
      (|CCall|
        |G-rtCacheAdd|
        (|Lex| |Struct-axextend-45--15| 15 |l1|)
        t2
        t0))
    |Lab0|
    (block-return |C140-axextend-axextend| t3)
    |Lab3|
    (|SetLex|
      |Struct-axextend-45--15|
      15
      |l1|
      (|CCall| |G-rtCacheExplicitMake| (the |SInt| 15)))
    (go |Lab1|)))

(defprog
  ((|C141-axextend-extend0| |Clos|) ((|P0-domain| |Word|) (|e1| |Env|)))
  ((t0 |Arr|) (t1 |Record|) (|l1| |Level|) (|e2| |Env|) (|l2| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (setq |e2| (|EnvNext| |e1|))
  (setq |l2| (|EnvLevel| |e2|))
  (setq t0 (|ANew| |Word| (the |SInt| 2)))
  (|SetAElt|
    t0
    (the |SInt| 1)
    (|CCall|
      (|Lex| |Struct-axextend-45-Matrix-1| 1 |l2|)
      (|Lex| |Struct-axextend-27-R-0| 0 |l1|)))
  (|SetAElt|
    t0
    (the |SInt| 0)
    (|CCall|
      |G-axextend_Matrix_057561278|
      (|Lex| |Struct-axextend-27-R-0| 0 |l1|)))
  (setq t1 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axextend-5| |values| 2 t1 t0)
  (|CCall| |G-extendFill!| |P0-domain| t1)
  (block-return |C141-axextend-extend0| |P0-domain|))

(defprog
  ((|C142-axextend-GeneratorCategory| |Word|)
    ((p0-s |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Record|)
    (t2 |Word|)
    (t3 |Word|)
    (|l0| |Level|)
    (|e0| |Env|)
    (|l1| |Level|))
  (setq
    |l0|
    (|MakeLevel| |MAKE-Struct-axextend-29| |Struct-axextend-29|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (|SetLex| |Struct-axextend-29-S-0| 0 |l0| p0-s)
    (setq t0 (|ANew| |Word| (the |SInt| 1)))
    (setq t1 (|RNew| |Struct-axextend-11|))
    (|SetRElt| |Struct-axextend-11| |size| 0 t1 (the |SInt| 1))
    (|SetRElt| |Struct-axextend-11| |values| 1 t1 t0)
    (when
      (|PtrIsNil| (|Lex| |Struct-axextend-45--16| 16 |l1|))
      (go |Lab3|))
    |Lab1|
    (|SetAElt|
      t0
      (the |SInt| 0)
      (|Lex| |Struct-axextend-29-S-0| 0 |l0|))
    (multiple-value-setq
      (t2 t3)
      (|CCall|
        |G-rtCacheCheck|
        (|Lex| |Struct-axextend-45--16| 16 |l1|)
        t1))
    (when t3 (go |Lab0|))
    (setq
      t2
      (|CCall|
        |G-categoryMake|
        (|Clos| |e0| |C144-axextend-GeneratorCategory|)
        (|Clos| |e0| |C143-axextend-defhash0|)
        (|CCall|
          |G-rtSingleParamNameFn|
          (|MakeLit| "GeneratorCategory")
          (|Lex| |Struct-axextend-29-S-0| 0 |l0|))))
    (setq
      t2
      (|CCall|
        |G-rtCacheAdd|
        (|Lex| |Struct-axextend-45--16| 16 |l1|)
        t1
        t2))
    |Lab0|
    (block-return |C142-axextend-GeneratorCategory| t2)
    |Lab3|
    (|SetLex|
      |Struct-axextend-45--16|
      16
      |l1|
      (|CCall| |G-rtCacheExplicitMake| (the |SInt| 15)))
    (go |Lab1|)))

(defprog
  ((|C143-axextend-defhash0| |SInt|) ((|e1| |Env|)))
  ((|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (block-return
    |C143-axextend-defhash0|
    (|SIntPlusMod|
      (|CCall| |G-domainHash!| (|Lex| |Struct-axextend-29-S-0| 0 |l1|))
      (the |SInt| 581318528)
      (the |SInt| 1073741789))))

(defprog
  ((|C144-axextend-GeneratorCategory|)
    ((|P0-self| |Word|) (|P1-dom| |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Arr|)
    (t2 |Arr|)
    (t3 |Record|)
    (t4 |Record|)
    (t5 |Record|)
    (t6 |SInt|)
    (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (setq t0 (|ANew| |SInt| (the |SInt| 1)))
  (setq t1 (|ANew| |SInt| (the |SInt| 1)))
  (setq t2 (|ANew| |Word| (the |SInt| 1)))
  (setq
    t6
    (|CCall| |G-domainHash!| (|Lex| |Struct-axextend-29-S-0| 0 |l1|)))
  (setq t3 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t3 (the |SInt| 1))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t3 (the |SInt| 1))
  (|SetRElt| |Struct-axextend-5| |values| 2 t3 t0)
  (setq t4 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t4 (the |SInt| 1))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t4 (the |SInt| 1))
  (|SetRElt| |Struct-axextend-5| |values| 2 t4 t1)
  (setq t5 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t5 (the |SInt| 1))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t5 (the |SInt| 1))
  (|SetRElt| |Struct-axextend-5| |values| 2 t5 t2)
  (|CCall| |G-categoryAddExports!| |P0-self| t3 t4 t5)
  (|SetAElt| t0 (the |SInt| 0) (the |SInt| 51482908))
  (|SetAElt|
    t1
    (the |SInt| 0)
    (|SIntPlusMod| t6 (the |SInt| 581318528) (the |SInt| 1073741789)))
  (|SetAElt| t2 (the |SInt| 0) |P1-dom|)
  (block-return |C144-axextend-GeneratorCategory| ()))

(defprog
  ((|C145-axextend-Segment| |Word|) ((p0-s |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Record|)
    (t2 |Word|)
    (t3 |Word|)
    (|l0| |Level|)
    (|e0| |Env|)
    (|l1| |Level|))
  (setq
    |l0|
    (|MakeLevel| |MAKE-Struct-axextend-34| |Struct-axextend-34|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (|SetLex| |Struct-axextend-34-S-0| 0 |l0| p0-s)
    (setq t0 (|ANew| |Word| (the |SInt| 1)))
    (setq t1 (|RNew| |Struct-axextend-11|))
    (|SetRElt| |Struct-axextend-11| |size| 0 t1 (the |SInt| 1))
    (|SetRElt| |Struct-axextend-11| |values| 1 t1 t0)
    (when
      (|PtrIsNil| (|Lex| |Struct-axextend-45--17| 17 |l1|))
      (go |Lab3|))
    |Lab1|
    (|SetAElt|
      t0
      (the |SInt| 0)
      (|Lex| |Struct-axextend-34-S-0| 0 |l0|))
    (multiple-value-setq
      (t2 t3)
      (|CCall|
        |G-rtCacheCheck|
        (|Lex| |Struct-axextend-45--17| 17 |l1|)
        t1))
    (when t3 (go |Lab0|))
    (setq
      t2
      (|CCall| |G-domainMake| (|Clos| |e0| |C146-axextend-addLevel0|)))
    (setq
      t2
      (|CCall|
        |G-rtCacheAdd|
        (|Lex| |Struct-axextend-45--17| 17 |l1|)
        t1
        t2))
    |Lab0|
    (block-return |C145-axextend-Segment| t2)
    |Lab3|
    (|SetLex|
      |Struct-axextend-45--17|
      17
      |l1|
      (|CCall| |G-rtCacheExplicitMake| (the |SInt| 15)))
    (go |Lab1|)))

(defprog
  ((|C146-axextend-addLevel0| |Clos|)
    ((|P0-domain| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|) (|l1| |Level|))
  (setq |l0| nil)
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |l1| (|EnvLevel| |e1|))
  (|CCall|
    |G-domainAddNameFn!|
    |P0-domain|
    (|CCall|
      |G-rtSingleParamNameFn|
      (|MakeLit| "Segment")
      (|Lex| |Struct-axextend-34-S-0| 0 |l1|)))
  (|CCall|
    |G-domainAddHash!|
    |P0-domain|
    (|SIntPlusMod|
      (|CCall| |G-domainHash!| (|Lex| |Struct-axextend-34-S-0| 0 |l1|))
      (the |SInt| 131263616)
      (the |SInt| 1073741789)))
  (block-return
    |C146-axextend-addLevel0|
    (|Clos| |e0| |C147-axextend-addLevel1|)))

(defprog
  ((|C147-axextend-addLevel1| |Word|)
    ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Arr|)
    (t2 |Arr|)
    (t3 |Record|)
    (t4 |Record|)
    (t5 |Record|)
    (t6 |Word|)
    (t7 |Word|)
    (t8 |Word|)
    (t9 |Word|)
    (t10 |SInt|)
    (t11 |Clos|)
    (t12 |SInt|)
    (t13 |Clos|)
    (t14 |SInt|)
    (t15 |Clos|)
    (t16 |Clos|)
    (t17 |Clos|)
    (t18 |SInt|)
    (t19 |SInt|)
    (t20 |SInt|)
    (t21 |Clos|)
    (t22 |SInt|)
    (t23 |SInt|)
    (t24 |SInt|)
    (t25 |SInt|)
    (t26 |SInt|)
    (t27 |SInt|)
    (t28 |SInt|)
    (t29 |SInt|)
    (t30 |SInt|)
    (t31 |SInt|)
    (t32 |SInt|)
    (t33 |SInt|)
    (|l0| |Level|)
    (|e0| |Env|)
    (|e2| |Env|)
    (|l2| |Level|)
    (|e3| |Env|))
  (setq
    |l0|
    (|MakeLevel| |MAKE-Struct-axextend-33| |Struct-axextend-33|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |e2| (|EnvNext| |e1|))
  (setq |l2| (|EnvLevel| |e2|))
  (setq |e3| (|EnvNext| |e2|))
  (tagbody
    (setq t0 (|ANew| |SInt| (the |SInt| 6)))
    (setq t1 (|ANew| |SInt| (the |SInt| 6)))
    (setq t2 (|ANew| |Word| (the |SInt| 6)))
    (setq t6 (|CCall| |G-domainMakeDispatch| |P0-domain|))
    (|SetLex| |Struct-axextend-33--10| 10 |l0| |P1-hashcode|)
    (setq t11 (|Clos| |e0| |C150-axextend-by|))
    (setq t13 (|Clos| |e0| |C151-axextend-low|))
    (setq t15 (|Clos| |e0| |C152-axextend-high|))
    (setq t16 (|Clos| |e0| |C153-axextend-incrx|))
    (setq t17 (|Clos| |e0| |C154-axextend-..|))
    (setq t21 (|Clos| |e0| |C155-axextend-generator|))
    (setq
      t23
      (|CCall| |G-domainHash!| (|Lex| |Struct-axextend-34-S-0| 0 |l2|)))
    (setq
      t10
      (|SIntPlusMod| t23 (the |SInt| 296696640) (the |SInt| 1073741789)))
    (setq
      t24
      (|SIntPlusMod|
        (|Lex| |Struct-axextend-33--10| 10 |l0|)
        (the |SInt| 74075968)
        (the |SInt| 1073741789)))
    (setq t25 (|SIntAnd| t24 (the |SInt| 16777215)))
    (setq t26 (|SIntShiftUp| t25 (the |SInt| 6)))
    (setq
      t27
      (|SIntPlusMod| (the |SInt| 484208045) t26 (the |SInt| 1073741789)))
    (setq
      t12
      (|SIntPlusMod|
        (|Lex| |Struct-axextend-33--10| 10 |l0|)
        (|SIntShiftUp| (|SIntAnd| t27 (the |SInt| 16777215)) (the |SInt| 6))
        (the |SInt| 1073741789)))
    (setq t14 (|SIntPlusMod| t23 t26 (the |SInt| 1073741789)))
    (setq
      t28
      (|SIntPlusMod| t23 (the |SInt| 74075968) (the |SInt| 1073741789)))
    (setq t29 (|SIntAnd| t28 (the |SInt| 16777215)))
    (setq t30 (|SIntShiftUp| t29 (the |SInt| 6)))
    (setq t31 (|SIntPlusMod| t23 t30 (the |SInt| 1073741789)))
    (setq t32 (|SIntAnd| t31 (the |SInt| 16777215)))
    (setq t33 (|SIntShiftUp| t32 (the |SInt| 6)))
    (setq
      t18
      (|SIntPlusMod|
        (|Lex| |Struct-axextend-33--10| 10 |l0|)
        t33
        (the |SInt| 1073741789)))
    (setq
      t19
      (|SIntPlusMod| (the |SInt| 740244383) t33 (the |SInt| 1073741789)))
    (setq t20 (|SIntPlusMod| t23 t33 (the |SInt| 1073741789)))
    (setq
      t22
      (|SIntPlusMod|
        (|SIntPlusMod| t23 (the |SInt| 5805568) (the |SInt| 1073741789))
        t26
        (the |SInt| 1073741789)))
    (setq t3 (|RNew| |Struct-axextend-5|))
    (|SetRElt| |Struct-axextend-5| |size| 0 t3 (the |SInt| 6))
    (|SetRElt| |Struct-axextend-5| |nsize| 1 t3 (the |SInt| 6))
    (|SetRElt| |Struct-axextend-5| |values| 2 t3 t0)
    (setq t4 (|RNew| |Struct-axextend-5|))
    (|SetRElt| |Struct-axextend-5| |size| 0 t4 (the |SInt| 6))
    (|SetRElt| |Struct-axextend-5| |nsize| 1 t4 (the |SInt| 6))
    (|SetRElt| |Struct-axextend-5| |values| 2 t4 t1)
    (setq t5 (|RNew| |Struct-axextend-5|))
    (|SetRElt| |Struct-axextend-5| |size| 0 t5 (the |SInt| 6))
    (|SetRElt| |Struct-axextend-5| |nsize| 1 t5 (the |SInt| 6))
    (|SetRElt| |Struct-axextend-5| |values| 2 t5 t2)
    (|CCall| |G-domainAddExports!| |P0-domain| t3 t4 t5)
    (|CCall|
      |G-domainAddDefaults!|
      |P0-domain|
      (|CCall|
        |G-categoryMake|
        (|Clos| |e0| |C149-axextend-Segment|)
        (|Clos| |e0| |C148-axextend-defhash0|)
        (|CCall|
          |G-rtSingleParamNameFn|
          (|MakeLit| "Segment")
          (|Lex| |Struct-axextend-34-S-0| 0 |l2|)))
      t6)
    (|SetLex|
      |Struct-axextend-33-dom-12|
      12
      |l0|
      (|Lex| |Struct-axextend-34-S-0| 0 |l2|))
    (|SetLex|
      |Struct-axextend-33-coerce-6|
      6
      |l0|
      (|CCall|
        |G-stdGetWordRetWord0|
        (|CCall|
          |G-rtDelayedGetExport!|
          (|Lex| |Struct-axextend-33-dom-12| 12 |l0|)
          (the |SInt| 770345191)
          t10)))
    (|SetLex|
      |Struct-axextend-33->=-8|
      8
      |l0|
      (|CCall|
        |G-stdGetWordWordRetWord0|
        (|CCall|
          |G-rtDelayedGetExport!|
          (|Lex| |Struct-axextend-33-dom-12| 12 |l0|)
          (the |SInt| 51492941)
          t19)))
    (|SetLex|
      |Struct-axextend-33-+-7|
      7
      |l0|
      (|CCall|
        |G-stdGetWordWordRetWord0|
        (|CCall|
          |G-rtDelayedGetExport!|
          (|Lex| |Struct-axextend-33-dom-12| 12 |l0|)
          (the |SInt| 200084)
          t20)))
    (|SetLex|
      |Struct-axextend-33-<=-9|
      9
      |l0|
      (|CCall|
        |G-stdGetWordWordRetWord0|
        (|CCall|
          |G-rtDelayedGetExport!|
          (|Lex| |Struct-axextend-33-dom-12| 12 |l0|)
          (the |SInt| 51492427)
          t19)))
    (setq t7 (|Lex| |Struct-axextend-34-S-0| 0 |l2|))
    (when
      (|CCall|
        |G-domainTestExport!|
        t7
        (the |SInt| 51482908)
        (the |SInt| 962357003))
      (go |Lab4|))
    |Lab1|
    |Lab0|
    (|SetLex|
      |Struct-axextend-33-generator-0|
      0
      |l0|
      (|C183-axextend-lazyFnGetter|
        (|CCall| |G-rtDelayedGetExport!| t6 (the |SInt| 113320568) t22)
        |e3|))
    (|SetLex|
      |Struct-axextend-33-..-1|
      1
      |l0|
      (|CCall|
        |G-stdGetWordWordRetWord0|
        (|CCall| |G-rtDelayedGetExport!| t6 (the |SInt| 51488814) t18)))
    (|SetLex|
      |Struct-axextend-33-incrx-2|
      2
      |l0|
      (|CCall|
        |G-stdGetWordRetWord0|
        (|CCall| |G-rtDelayedGetExport!| t6 (the |SInt| 495481649) t27)))
    (|SetLex|
      |Struct-axextend-33-high-3|
      3
      |l0|
      (|CCall|
        |G-stdGetWordRetWord0|
        (|CCall| |G-rtDelayedGetExport!| t6 (the |SInt| 749482564) t14)))
    (|SetLex|
      |Struct-axextend-33-low-4|
      4
      |l0|
      (|CCall|
        |G-stdGetWordRetWord0|
        (|CCall| |G-rtDelayedGetExport!| t6 (the |SInt| 318396813) t14)))
    (|SetLex|
      |Struct-axextend-33-by-5|
      5
      |l0|
      (|CCall|
        |G-stdGetWordWordRetWord0|
        (|CCall| |G-rtDelayedGetExport!| t6 (the |SInt| 51500205) t12)))
    |Lab3|
    (block-return |C147-axextend-addLevel1| |P0-domain|)
    |Lab4|
    (setq t8 (|Lex| |Struct-axextend-34-S-0| 0 |l2|))
    (when
      (|CCall|
        |G-domainTestExport!|
        t8
        (the |SInt| 51482908)
        (the |SInt| 683498711))
      (go |Lab5|))
    (go |Lab1|)
    |Lab5|
    (setq t9 (|Lex| |Struct-axextend-34-S-0| 0 |l2|))
    (when
      (|CCall| |G-domainTestExport!| t9 (the |SInt| 770345191) t10)
      (go |Lab2|))
    (go |Lab0|)
    |Lab2|
    (|SetLex| |Struct-axextend-33-by-5| 5 |l0| t11)
    (|SetAElt| t0 (the |SInt| 0) (the |SInt| 51500205))
    (|SetAElt| t1 (the |SInt| 0) t12)
    (|SetAElt|
      t2
      (the |SInt| 0)
      (|Lex| |Struct-axextend-33-by-5| 5 |l0|))
    (|SetLex| |Struct-axextend-33-low-4| 4 |l0| t13)
    (|SetAElt| t0 (the |SInt| 1) (the |SInt| 318396813))
    (|SetAElt| t1 (the |SInt| 1) t14)
    (|SetAElt|
      t2
      (the |SInt| 1)
      (|Lex| |Struct-axextend-33-low-4| 4 |l0|))
    (|SetLex| |Struct-axextend-33-high-3| 3 |l0| t15)
    (|SetAElt| t0 (the |SInt| 2) (the |SInt| 749482564))
    (|SetAElt| t1 (the |SInt| 2) t14)
    (|SetAElt|
      t2
      (the |SInt| 2)
      (|Lex| |Struct-axextend-33-high-3| 3 |l0|))
    (|SetLex| |Struct-axextend-33-incrx-2| 2 |l0| t16)
    (|SetAElt| t0 (the |SInt| 3) (the |SInt| 495481649))
    (|SetAElt| t1 (the |SInt| 3) t27)
    (|SetAElt|
      t2
      (the |SInt| 3)
      (|Lex| |Struct-axextend-33-incrx-2| 2 |l0|))
    (|SetLex| |Struct-axextend-33-..-1| 1 |l0| t17)
    (|SetAElt| t0 (the |SInt| 4) (the |SInt| 51488814))
    (|SetAElt| t1 (the |SInt| 4) t18)
    (|SetAElt|
      t2
      (the |SInt| 4)
      (|Lex| |Struct-axextend-33-..-1| 1 |l0|))
    (|SetLex| |Struct-axextend-33-generator-0| 0 |l0| t21)
    (|SetAElt| t0 (the |SInt| 5) (the |SInt| 113320568))
    (|SetAElt| t1 (the |SInt| 5) t22)
    (|SetAElt|
      t2
      (the |SInt| 5)
      (|Lex| |Struct-axextend-33-generator-0| 0 |l0|))
    (go |Lab3|)))

(defprog
  ((|C148-axextend-defhash0| |SInt|) ((|e1| |Env|)))
  ((|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (block-return
    |C148-axextend-defhash0|
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-33--11| 11 |l1|)
      (the |SInt| 131263616)
      (the |SInt| 1073741789))))

(defprog
  ((|C149-axextend-Segment|)
    ((|P0-self| |Word|) (|P1-dom| |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Arr|)
    (t2 |Arr|)
    (t3 |Record|)
    (t4 |Record|)
    (t5 |Record|)
    (t6 |Arr|)
    (t7 |SInt|)
    (t8 |Bool|)
    (t9 |Word|)
    (t10 |Word|)
    (t11 |Word|)
    (t12 |Bool|)
    (t13 |SInt|)
    (t14 |Record|)
    (t15 |SInt|)
    (|e3| |Env|)
    (|l3| |Level|))
  (setq |e3| (|EnvNext| (|EnvNext| |e1|)))
  (setq |l3| (|EnvLevel| |e3|))
  (tagbody
    (setq t0 (|ANew| |SInt| (the |SInt| 0)))
    (setq t1 (|ANew| |SInt| (the |SInt| 0)))
    (setq t2 (|ANew| |Word| (the |SInt| 0)))
    (setq t6 (|ANew| |Word| (the |SInt| 1)))
    (setq
      t15
      (|CCall| |G-domainHash!| (|Lex| |Struct-axextend-34-S-0| 0 |l3|)))
    (setq
      t13
      (|SIntPlusMod| t15 (the |SInt| 296696640) (the |SInt| 1073741789)))
    (setq t3 (|RNew| |Struct-axextend-5|))
    (|SetRElt| |Struct-axextend-5| |size| 0 t3 (the |SInt| 0))
    (|SetRElt| |Struct-axextend-5| |nsize| 1 t3 (the |SInt| 0))
    (|SetRElt| |Struct-axextend-5| |values| 2 t3 t0)
    (setq t4 (|RNew| |Struct-axextend-5|))
    (|SetRElt| |Struct-axextend-5| |size| 0 t4 (the |SInt| 0))
    (|SetRElt| |Struct-axextend-5| |nsize| 1 t4 (the |SInt| 0))
    (|SetRElt| |Struct-axextend-5| |values| 2 t4 t1)
    (setq t5 (|RNew| |Struct-axextend-5|))
    (|SetRElt| |Struct-axextend-5| |size| 0 t5 (the |SInt| 0))
    (|SetRElt| |Struct-axextend-5| |nsize| 1 t5 (the |SInt| 0))
    (|SetRElt| |Struct-axextend-5| |values| 2 t5 t2)
    (|CCall| |G-categoryAddExports!| |P0-self| t3 t4 t5)
    (setq t8 (the |Bool| t))
    (setq t9 (|Lex| |Struct-axextend-34-S-0| 0 |l3|))
    (when
      (|CCall|
        |G-domainTestExport!|
        t9
        (the |SInt| 51482908)
        (the |SInt| 962357003))
      (go |Lab9|))
    |Lab4|
    (setq t8 (the |Bool| nil))
    |Lab5|
    (when t8 (go |Lab10|))
    |Lab3|
    (setq t7 (the |SInt| 0))
    |Lab1|
    (when (|SIntEQ| (the |SInt| 1) t7) (go |Lab2|))
    (|SetAElt| t6 t7 nil)
    (setq t7 (|SIntNext| t7))
    (go |Lab1|)
    |Lab2|
    (setq t14 (|RNew| |Struct-axextend-5|))
    (|SetRElt| |Struct-axextend-5| |size| 0 t14 (the |SInt| 1))
    (|SetRElt| |Struct-axextend-5| |nsize| 1 t14 (the |SInt| 1))
    (|SetRElt| |Struct-axextend-5| |values| 2 t14 t6)
    (|CCall| |G-categoryAddParents!| |P0-self| t14 |P1-dom|)
    (block-return |C149-axextend-Segment| ())
    |Lab10|
    (setq t11 (|Lex| |Struct-axextend-34-S-0| 0 |l3|))
    (when
      (|CCall| |G-domainTestExport!| t11 (the |SInt| 770345191) t13)
      (go |Lab7|))
    (setq t12 (the |Bool| nil))
    |Lab6|
    (when t12 (go |Lab0|))
    (go |Lab3|)
    |Lab0|
    (|SetAElt|
      t6
      (the |SInt| 0)
      (|CCall|
        |G-axextend_GeneratorCategory_073559903|
        (|Lex| |Struct-axextend-34-S-0| 0 |l3|)))
    (setq t7 (the |SInt| 1))
    (go |Lab1|)
    |Lab7|
    (setq t12 (the |Bool| t))
    (go |Lab6|)
    |Lab9|
    (setq t10 (|Lex| |Struct-axextend-34-S-0| 0 |l3|))
    (when
      (|CCall|
        |G-domainTestExport!|
        t10
        (the |SInt| 51482908)
        (the |SInt| 683498711))
      (go |Lab5|))
    (go |Lab4|)))

(defprog
  ((|C150-axextend-by| |Word|)
    ((|P0-s| |Word|) (|P1-n| |Word|) (|e1| |Env|)))
  ()
  (|SetRElt| |Struct-axextend-31| |incrz| 2 |P0-s| |P1-n|)
  (block-return |C150-axextend-by| |P0-s|))

(defprog
  ((|C151-axextend-low| |Word|) ((|P0-x| |Word|) (|e1| |Env|)))
  ()
  (block-return
    |C151-axextend-low|
    (|RElt| |Struct-axextend-31| |low| 0 |P0-x|)))

(defprog
  ((|C152-axextend-high| |Word|) ((|P0-x| |Word|) (|e1| |Env|)))
  ()
  (block-return
    |C152-axextend-high|
    (|RElt| |Struct-axextend-31| |high| 1 |P0-x|)))

(defprog
  ((|C153-axextend-incrx| |Word|) ((|P0-x| |Word|) (|e1| |Env|)))
  ()
  (block-return
    |C153-axextend-incrx|
    (|RElt| |Struct-axextend-31| |incrz| 2 |P0-x|)))

(defprog
  ((|C154-axextend-..| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ((t0 |Record|))
  (setq t0 (|RNew| |Struct-axextend-31|))
  (|SetRElt| |Struct-axextend-31| |low| 0 t0 |P0-a|)
  (|SetRElt| |Struct-axextend-31| |high| 1 t0 |P1-b|)
  (|SetRElt| |Struct-axextend-31| |incrz| 2 t0 (the |BInt| 1))
  (block-return |C154-axextend-..| t0))

(defprog
  ((|C155-axextend-generator| |Clos|) ((|P0-x| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq
    |l0|
    (|MakeLevel| |MAKE-Struct-axextend-32| |Struct-axextend-32|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|SetLex| |Struct-axextend-32-x-0| 0 |l0| |P0-x|)
  (|SetLex| |Struct-axextend-32--5| 5 |l0| (the |SInt| 0))
  (block-return
    |C155-axextend-generator|
    (|Clos| |e0| |C156-axextend-generBaseFn|)))

(defprog
  ((|C156-axextend-generBaseFn| |Clos| |Clos| |Clos| |Clos|)
    ((|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| nil)
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (block-return
    |C156-axextend-generBaseFn|
    (values
      (|Clos| |e0| |C158-axextend-generDone?|)
      (|Clos| |e0| |C157-axextend-generStepper|)
      (|Clos| |e0| |C159-axextend-generValue|)
      (|Clos| |e0| |C160-axextend-generBound|))))

(defprog
  ((|C157-axextend-generStepper|) ((|e1| |Env|)))
  ((t0 |Word|)
    (t1 |Word|)
    (t2 |Word|)
    (t3 |Word|)
    (t4 |Word|)
    (t5 |Word|)
    (|e2| |Env|)
    (|l2| |Level|)
    (|e3| |Env|)
    (|l3| |Level|))
  (setq |e2| (|EnvNext| |e1|))
  (setq |l2| (|EnvLevel| |e2|))
  (setq |e3| (|EnvNext| |e2|))
  (setq |l3| (|EnvLevel| |e3|))
  (tagbody
    (cases
      (|Lex| |Struct-axextend-32--5| 5 |l2|)
      (2 (go |Lab6|))
      (1 (go |Lab4|))
      (0 (go |Lab0|)))
    |Lab0|
    (|SetLex| |Struct-axextend-32--4| 4 |l2| (the |Bool| nil))
    (setq t5 (|Lex| |Struct-axextend-32-x-0| 0 |l2|))
    (|SetLex|
      |Struct-axextend-32-l-3|
      3
      |l2|
      (|RElt| |Struct-axextend-31| |low| 0 t5))
    (setq t3 (|Lex| |Struct-axextend-32-x-0| 0 |l2|))
    (|SetLex|
      |Struct-axextend-32-h-2|
      2
      |l2|
      (|RElt| |Struct-axextend-31| |high| 1 t3))
    (setq t4 (|Lex| |Struct-axextend-32-x-0| 0 |l2|))
    (|SetLex|
      |Struct-axextend-32-inc-1|
      1
      |l2|
      (|CCall|
        (|Lex| |Struct-axextend-33-coerce-6| 6 |l3|)
        (|RElt| |Struct-axextend-31| |incrz| 2 t4)))
    (setq t2 (|Lex| |Struct-axextend-32-x-0| 0 |l2|))
    (when
      (|BIntIsNeg| (|RElt| |Struct-axextend-31| |incrz| 2 t2))
      (go |Lab8|))
    |Lab5|
    (when
      (|CCall|
        (|Lex| |Struct-axextend-33-<=-9| 9 |l3|)
        (|Lex| |Struct-axextend-32-l-3| 3 |l2|)
        (|Lex| |Struct-axextend-32-h-2| 2 |l2|))
      (go |Lab10|))
    |Lab2|
    (|SetLex| |Struct-axextend-32--4| 4 |l2| (the |Bool| t))
    (block-return |C157-axextend-generStepper| ())
    |Lab10|
    (|SetLex| |Struct-axextend-32--5| 5 |l2| (the |SInt| 2))
    (setq t0 (|Lex| |Struct-axextend-32-l-3| 3 |l2|))
    |Lab1|
    (|SetLex| |Struct-axextend-32--6| 6 |l2| t0)
    (block-return |C157-axextend-generStepper| ())
    |Lab8|
    (setq t1 (|Lex| |Struct-axextend-32-x-0| 0 |l2|))
    (when
      (|BIntIsNeg| (|RElt| |Struct-axextend-31| |incrz| 2 t1))
      (go |Lab3|))
    (go |Lab2|)
    |Lab3|
    (when
      (|CCall|
        (|Lex| |Struct-axextend-33->=-8| 8 |l3|)
        (|Lex| |Struct-axextend-32-l-3| 3 |l2|)
        (|Lex| |Struct-axextend-32-h-2| 2 |l2|))
      (go |Lab9|))
    (go |Lab2|)
    |Lab9|
    (|SetLex| |Struct-axextend-32--5| 5 |l2| (the |SInt| 1))
    (setq t0 (|Lex| |Struct-axextend-32-l-3| 3 |l2|))
    (go |Lab1|)
    |Lab4|
    (|SetLex|
      |Struct-axextend-32-l-3|
      3
      |l2|
      (|CCall|
        (|Lex| |Struct-axextend-33-+-7| 7 |l3|)
        (|Lex| |Struct-axextend-32-l-3| 3 |l2|)
        (|Lex| |Struct-axextend-32-inc-1| 1 |l2|)))
    (go |Lab3|)
    |Lab6|
    (|SetLex|
      |Struct-axextend-32-l-3|
      3
      |l2|
      (|CCall|
        (|Lex| |Struct-axextend-33-+-7| 7 |l3|)
        (|Lex| |Struct-axextend-32-l-3| 3 |l2|)
        (|Lex| |Struct-axextend-32-inc-1| 1 |l2|)))
    (go |Lab5|)))

(defprog
  ((|C158-axextend-generDone?| |Bool|) ((|e1| |Env|)))
  ((|e2| |Env|) (|l2| |Level|))
  (setq |e2| (|EnvNext| |e1|))
  (setq |l2| (|EnvLevel| |e2|))
  (block-return
    |C158-axextend-generDone?|
    (|Lex| |Struct-axextend-32--4| 4 |l2|)))

(defprog
  ((|C159-axextend-generValue| |Word|) ((|e1| |Env|)))
  ((|e2| |Env|) (|l2| |Level|))
  (setq |e2| (|EnvNext| |e1|))
  (setq |l2| (|EnvLevel| |e2|))
  (block-return
    |C159-axextend-generValue|
    (|Lex| |Struct-axextend-32--6| 6 |l2|)))

(defprog
  ((|C160-axextend-generBound| |SInt|) ((|e1| |Env|)))
  ()
  (block-return |C160-axextend-generBound| (the |SInt| -1)))

(defprog
  ((|C161-axextend-axextend| |Word|) ((p0-s |Word|) (|e1| |Env|)))
  ((t0 |Word|)
    (t1 |Arr|)
    (t2 |Record|)
    (t3 |Word|)
    (t4 |Word|)
    (|l0| |Level|)
    (|e0| |Env|)
    (|l1| |Level|))
  (setq
    |l0|
    (|MakeLevel| |MAKE-Struct-axextend-35| |Struct-axextend-35|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (|SetLex| |Struct-axextend-35-S-0| 0 |l0| p0-s)
    (setq t1 (|ANew| |Word| (the |SInt| 1)))
    (setq t2 (|RNew| |Struct-axextend-11|))
    (|SetRElt| |Struct-axextend-11| |size| 0 t2 (the |SInt| 1))
    (|SetRElt| |Struct-axextend-11| |values| 1 t2 t1)
    (when
      (|PtrIsNil| (|Lex| |Struct-axextend-45--18| 18 |l1|))
      (go |Lab3|))
    |Lab1|
    (|SetAElt|
      t1
      (the |SInt| 0)
      (|Lex| |Struct-axextend-35-S-0| 0 |l0|))
    (multiple-value-setq
      (t3 t4)
      (|CCall|
        |G-rtCacheCheck|
        (|Lex| |Struct-axextend-45--18| 18 |l1|)
        t2))
    (when t4 (go |Lab0|))
    (setq
      t0
      (|CCall| |G-extendMake| (|Clos| |e0| |C162-axextend-extend0|)))
    (setq
      t3
      (|CCall|
        |G-rtCacheAdd|
        (|Lex| |Struct-axextend-45--18| 18 |l1|)
        t2
        t0))
    |Lab0|
    (block-return |C161-axextend-axextend| t3)
    |Lab3|
    (|SetLex|
      |Struct-axextend-45--18|
      18
      |l1|
      (|CCall| |G-rtCacheExplicitMake| (the |SInt| 15)))
    (go |Lab1|)))

(defprog
  ((|C162-axextend-extend0| |Clos|) ((|P0-domain| |Word|) (|e1| |Env|)))
  ((t0 |Arr|) (t1 |Record|) (|l1| |Level|) (|e2| |Env|) (|l2| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (setq |e2| (|EnvNext| |e1|))
  (setq |l2| (|EnvLevel| |e2|))
  (setq t0 (|ANew| |Word| (the |SInt| 2)))
  (|SetAElt|
    t0
    (the |SInt| 1)
    (|CCall|
      (|Lex| |Struct-axextend-45-Segment-0| 0 |l2|)
      (|Lex| |Struct-axextend-35-S-0| 0 |l1|)))
  (|SetAElt|
    t0
    (the |SInt| 0)
    (|CCall|
      |G-axextend_Segment_249071355|
      (|Lex| |Struct-axextend-35-S-0| 0 |l1|)))
  (setq t1 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axextend-5| |values| 2 t1 t0)
  (|CCall| |G-extendFill!| |P0-domain| t1)
  (block-return |C162-axextend-extend0| |P0-domain|))

(defprog
  ((|C163-axextend-UniversalSegment| |Word|)
    ((p0-s |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Record|)
    (t2 |Word|)
    (t3 |Word|)
    (|l0| |Level|)
    (|e0| |Env|)
    (|l1| |Level|))
  (setq
    |l0|
    (|MakeLevel| |MAKE-Struct-axextend-42| |Struct-axextend-42|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (|SetLex| |Struct-axextend-42-S-0| 0 |l0| p0-s)
    (setq t0 (|ANew| |Word| (the |SInt| 1)))
    (setq t1 (|RNew| |Struct-axextend-11|))
    (|SetRElt| |Struct-axextend-11| |size| 0 t1 (the |SInt| 1))
    (|SetRElt| |Struct-axextend-11| |values| 1 t1 t0)
    (when
      (|PtrIsNil| (|Lex| |Struct-axextend-45--19| 19 |l1|))
      (go |Lab3|))
    |Lab1|
    (|SetAElt|
      t0
      (the |SInt| 0)
      (|Lex| |Struct-axextend-42-S-0| 0 |l0|))
    (multiple-value-setq
      (t2 t3)
      (|CCall|
        |G-rtCacheCheck|
        (|Lex| |Struct-axextend-45--19| 19 |l1|)
        t1))
    (when t3 (go |Lab0|))
    (setq
      t2
      (|CCall| |G-domainMake| (|Clos| |e0| |C164-axextend-addLevel0|)))
    (setq
      t2
      (|CCall|
        |G-rtCacheAdd|
        (|Lex| |Struct-axextend-45--19| 19 |l1|)
        t1
        t2))
    |Lab0|
    (block-return |C163-axextend-UniversalSegment| t2)
    |Lab3|
    (|SetLex|
      |Struct-axextend-45--19|
      19
      |l1|
      (|CCall| |G-rtCacheExplicitMake| (the |SInt| 15)))
    (go |Lab1|)))

(defprog
  ((|C164-axextend-addLevel0| |Clos|)
    ((|P0-domain| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|) (|l1| |Level|))
  (setq |l0| nil)
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |l1| (|EnvLevel| |e1|))
  (|CCall|
    |G-domainAddNameFn!|
    |P0-domain|
    (|CCall|
      |G-rtSingleParamNameFn|
      (|MakeLit| "UniversalSegment")
      (|Lex| |Struct-axextend-42-S-0| 0 |l1|)))
  (|CCall|
    |G-domainAddHash!|
    |P0-domain|
    (|SIntPlusMod|
      (|CCall| |G-domainHash!| (|Lex| |Struct-axextend-42-S-0| 0 |l1|))
      (the |SInt| 24790784)
      (the |SInt| 1073741789)))
  (block-return
    |C164-axextend-addLevel0|
    (|Clos| |e0| |C165-axextend-addLevel1|)))

(defprog
  ((|C165-axextend-addLevel1| |Word|)
    ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Arr|)
    (t2 |Arr|)
    (t3 |Record|)
    (t4 |Record|)
    (t5 |Record|)
    (t6 |Word|)
    (t7 |Word|)
    (t8 |Word|)
    (t9 |Word|)
    (t10 |SInt|)
    (t11 |Clos|)
    (t12 |SInt|)
    (t13 |Clos|)
    (t14 |SInt|)
    (t15 |Clos|)
    (t16 |SInt|)
    (t17 |Clos|)
    (t18 |SInt|)
    (t19 |Clos|)
    (t20 |Clos|)
    (t21 |Clos|)
    (t22 |SInt|)
    (t23 |SInt|)
    (t24 |SInt|)
    (t25 |Clos|)
    (t26 |SInt|)
    (t27 |SInt|)
    (t28 |SInt|)
    (t29 |SInt|)
    (t30 |SInt|)
    (t31 |SInt|)
    (t32 |SInt|)
    (t33 |SInt|)
    (t34 |SInt|)
    (t35 |SInt|)
    (t36 |SInt|)
    (t37 |SInt|)
    (|l0| |Level|)
    (|e0| |Env|)
    (|e2| |Env|)
    (|l2| |Level|)
    (|e3| |Env|))
  (setq
    |l0|
    (|MakeLevel| |MAKE-Struct-axextend-41| |Struct-axextend-41|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |e2| (|EnvNext| |e1|))
  (setq |l2| (|EnvLevel| |e2|))
  (setq |e3| (|EnvNext| |e2|))
  (tagbody
    (setq t0 (|ANew| |SInt| (the |SInt| 8)))
    (setq t1 (|ANew| |SInt| (the |SInt| 8)))
    (setq t2 (|ANew| |Word| (the |SInt| 8)))
    (setq t6 (|CCall| |G-domainMakeDispatch| |P0-domain|))
    (|SetLex| |Struct-axextend-41--14| 14 |l0| |P1-hashcode|)
    (setq t11 (|Clos| |e0| |C168-axextend-..|))
    (setq t13 (|Clos| |e0| |C169-axextend-..|))
    (setq t15 (|Clos| |e0| |C170-axextend-hasHi|))
    (setq t17 (|Clos| |e0| |C171-axextend-low|))
    (setq t19 (|Clos| |e0| |C172-axextend-high|))
    (setq t20 (|Clos| |e0| |C173-axextend-incr|))
    (setq t21 (|Clos| |e0| |C174-axextend-by|))
    (setq t25 (|Clos| |e0| |C175-axextend-generator|))
    (setq
      t27
      (|CCall| |G-domainHash!| (|Lex| |Struct-axextend-42-S-0| 0 |l2|)))
    (setq
      t10
      (|SIntPlusMod| t27 (the |SInt| 296696640) (the |SInt| 1073741789)))
    (setq
      t28
      (|SIntPlusMod| t27 (the |SInt| 74075968) (the |SInt| 1073741789)))
    (setq t29 (|SIntAnd| t28 (the |SInt| 16777215)))
    (setq t30 (|SIntShiftUp| t29 (the |SInt| 6)))
    (setq t35 (|SIntPlusMod| t27 t30 (the |SInt| 1073741789)))
    (setq t36 (|SIntAnd| t35 (the |SInt| 16777215)))
    (setq t37 (|SIntShiftUp| t36 (the |SInt| 6)))
    (setq
      t12
      (|SIntPlusMod|
        (|Lex| |Struct-axextend-41--14| 14 |l0|)
        t37
        (the |SInt| 1073741789)))
    (setq
      t14
      (|SIntPlusMod|
        (|Lex| |Struct-axextend-41--14| 14 |l0|)
        t30
        (the |SInt| 1073741789)))
    (setq
      t31
      (|SIntPlusMod|
        (|Lex| |Struct-axextend-41--14| 14 |l0|)
        (the |SInt| 74075968)
        (the |SInt| 1073741789)))
    (setq t32 (|SIntAnd| t31 (the |SInt| 16777215)))
    (setq t33 (|SIntShiftUp| t32 (the |SInt| 6)))
    (setq
      t16
      (|SIntPlusMod| (the |SInt| 740244383) t33 (the |SInt| 1073741789)))
    (setq t18 (|SIntPlusMod| t27 t33 (the |SInt| 1073741789)))
    (setq
      t34
      (|SIntPlusMod| (the |SInt| 484208045) t33 (the |SInt| 1073741789)))
    (setq
      t22
      (|SIntPlusMod|
        (|Lex| |Struct-axextend-41--14| 14 |l0|)
        (|SIntShiftUp| (|SIntAnd| t34 (the |SInt| 16777215)) (the |SInt| 6))
        (the |SInt| 1073741789)))
    (setq
      t23
      (|SIntPlusMod| (the |SInt| 740244383) t37 (the |SInt| 1073741789)))
    (setq t24 (|SIntPlusMod| t27 t37 (the |SInt| 1073741789)))
    (setq
      t26
      (|SIntPlusMod|
        (|SIntPlusMod| t27 (the |SInt| 5805568) (the |SInt| 1073741789))
        t33
        (the |SInt| 1073741789)))
    (setq t3 (|RNew| |Struct-axextend-5|))
    (|SetRElt| |Struct-axextend-5| |size| 0 t3 (the |SInt| 8))
    (|SetRElt| |Struct-axextend-5| |nsize| 1 t3 (the |SInt| 8))
    (|SetRElt| |Struct-axextend-5| |values| 2 t3 t0)
    (setq t4 (|RNew| |Struct-axextend-5|))
    (|SetRElt| |Struct-axextend-5| |size| 0 t4 (the |SInt| 8))
    (|SetRElt| |Struct-axextend-5| |nsize| 1 t4 (the |SInt| 8))
    (|SetRElt| |Struct-axextend-5| |values| 2 t4 t1)
    (setq t5 (|RNew| |Struct-axextend-5|))
    (|SetRElt| |Struct-axextend-5| |size| 0 t5 (the |SInt| 8))
    (|SetRElt| |Struct-axextend-5| |nsize| 1 t5 (the |SInt| 8))
    (|SetRElt| |Struct-axextend-5| |values| 2 t5 t2)
    (|CCall| |G-domainAddExports!| |P0-domain| t3 t4 t5)
    (|CCall|
      |G-domainAddDefaults!|
      |P0-domain|
      (|CCall|
        |G-categoryMake|
        (|Clos| |e0| |C167-axextend-UniversalSegment|)
        (|Clos| |e0| |C166-axextend-defhash0|)
        (|CCall|
          |G-rtSingleParamNameFn|
          (|MakeLit| "UniversalSegment")
          (|Lex| |Struct-axextend-42-S-0| 0 |l2|)))
      t6)
    (|SetLex|
      |Struct-axextend-41-dom-16|
      16
      |l0|
      (|Lex| |Struct-axextend-42-S-0| 0 |l2|))
    (|SetLex|
      |Struct-axextend-41-coerce-8|
      8
      |l0|
      (|CCall|
        |G-stdGetWordRetWord0|
        (|CCall|
          |G-rtDelayedGetExport!|
          (|Lex| |Struct-axextend-41-dom-16| 16 |l0|)
          (the |SInt| 770345191)
          t10)))
    (|SetLex|
      |Struct-axextend-41-dom-17|
      17
      |l0|
      |G-axextend_Integer_437506685|)
    (|SetLex|
      |Struct-axextend-41->=-13|
      13
      |l0|
      (|CCall|
        |G-stdGetWordWordRetWord0|
        (|CCall|
          |G-rtDelayedGetExport!|
          (|Lex| |Struct-axextend-41-dom-17| 17 |l0|)
          (the |SInt| 51492941)
          (the |SInt| 252278530))))
    (|SetLex|
      |Struct-axextend-41-<-12|
      12
      |l0|
      (|CCall|
        |G-stdGetWordWordRetWord0|
        (|CCall|
          |G-rtDelayedGetExport!|
          (|Lex| |Struct-axextend-41-dom-17| 17 |l0|)
          (the |SInt| 200101)
          (the |SInt| 252278530))))
    (|SetLex|
      |Struct-axextend-41->=-10|
      10
      |l0|
      (|CCall|
        |G-stdGetWordWordRetWord0|
        (|CCall|
          |G-rtDelayedGetExport!|
          (|Lex| |Struct-axextend-41-dom-16| 16 |l0|)
          (the |SInt| 51492941)
          t23)))
    (|SetLex|
      |Struct-axextend-41-+-9|
      9
      |l0|
      (|CCall|
        |G-stdGetWordWordRetWord0|
        (|CCall|
          |G-rtDelayedGetExport!|
          (|Lex| |Struct-axextend-41-dom-16| 16 |l0|)
          (the |SInt| 200084)
          t24)))
    (|SetLex|
      |Struct-axextend-41-<=-11|
      11
      |l0|
      (|CCall|
        |G-stdGetWordWordRetWord0|
        (|CCall|
          |G-rtDelayedGetExport!|
          (|Lex| |Struct-axextend-41-dom-16| 16 |l0|)
          (the |SInt| 51492427)
          t23)))
    (setq t7 (|Lex| |Struct-axextend-42-S-0| 0 |l2|))
    (when
      (|CCall|
        |G-domainTestExport!|
        t7
        (the |SInt| 51482908)
        (the |SInt| 962357003))
      (go |Lab4|))
    |Lab1|
    |Lab0|
    (|SetLex|
      |Struct-axextend-41-generator-0|
      0
      |l0|
      (|C183-axextend-lazyFnGetter|
        (|CCall| |G-rtDelayedGetExport!| t6 (the |SInt| 113320568) t26)
        |e3|))
    (|SetLex|
      |Struct-axextend-41-by-1|
      1
      |l0|
      (|CCall|
        |G-stdGetWordWordRetWord0|
        (|CCall| |G-rtDelayedGetExport!| t6 (the |SInt| 51500205) t22)))
    (|SetLex|
      |Struct-axextend-41-incr-2|
      2
      |l0|
      (|CCall|
        |G-stdGetWordRetWord0|
        (|CCall| |G-rtDelayedGetExport!| t6 (the |SInt| 766522704) t34)))
    (|SetLex|
      |Struct-axextend-41-high-3|
      3
      |l0|
      (|CCall|
        |G-stdGetWordRetWord0|
        (|CCall| |G-rtDelayedGetExport!| t6 (the |SInt| 749482564) t18)))
    (|SetLex|
      |Struct-axextend-41-low-4|
      4
      |l0|
      (|CCall|
        |G-stdGetWordRetWord0|
        (|CCall| |G-rtDelayedGetExport!| t6 (the |SInt| 318396813) t18)))
    (|SetLex|
      |Struct-axextend-41-hasHi-5|
      5
      |l0|
      (|CCall|
        |G-stdGetWordRetWord0|
        (|CCall| |G-rtDelayedGetExport!| t6 (the |SInt| 680872954) t16)))
    (|SetLex|
      |Struct-axextend-41-..-6|
      6
      |l0|
      (|CCall|
        |G-stdGetWordWordRetWord0|
        (|CCall| |G-rtDelayedGetExport!| t6 (the |SInt| 51488814) t12)))
    (|SetLex|
      |Struct-axextend-41-..-7|
      7
      |l0|
      (|CCall|
        |G-stdGetWordRetWord0|
        (|CCall| |G-rtDelayedGetExport!| t6 (the |SInt| 51488814) t14)))
    |Lab3|
    (block-return |C165-axextend-addLevel1| |P0-domain|)
    |Lab4|
    (setq t8 (|Lex| |Struct-axextend-42-S-0| 0 |l2|))
    (when
      (|CCall|
        |G-domainTestExport!|
        t8
        (the |SInt| 51482908)
        (the |SInt| 683498711))
      (go |Lab5|))
    (go |Lab1|)
    |Lab5|
    (setq t9 (|Lex| |Struct-axextend-42-S-0| 0 |l2|))
    (when
      (|CCall| |G-domainTestExport!| t9 (the |SInt| 770345191) t10)
      (go |Lab2|))
    (go |Lab0|)
    |Lab2|
    (|SetLex| |Struct-axextend-41-..-6| 6 |l0| t11)
    (|SetAElt| t0 (the |SInt| 0) (the |SInt| 51488814))
    (|SetAElt| t1 (the |SInt| 0) t12)
    (|SetAElt|
      t2
      (the |SInt| 0)
      (|Lex| |Struct-axextend-41-..-6| 6 |l0|))
    (|SetLex| |Struct-axextend-41-..-7| 7 |l0| t13)
    (|SetAElt| t0 (the |SInt| 1) (the |SInt| 51488814))
    (|SetAElt| t1 (the |SInt| 1) t14)
    (|SetAElt|
      t2
      (the |SInt| 1)
      (|Lex| |Struct-axextend-41-..-7| 7 |l0|))
    (|SetLex| |Struct-axextend-41-hasHi-5| 5 |l0| t15)
    (|SetAElt| t0 (the |SInt| 2) (the |SInt| 680872954))
    (|SetAElt| t1 (the |SInt| 2) t16)
    (|SetAElt|
      t2
      (the |SInt| 2)
      (|Lex| |Struct-axextend-41-hasHi-5| 5 |l0|))
    (|SetLex| |Struct-axextend-41-low-4| 4 |l0| t17)
    (|SetAElt| t0 (the |SInt| 3) (the |SInt| 318396813))
    (|SetAElt| t1 (the |SInt| 3) t18)
    (|SetAElt|
      t2
      (the |SInt| 3)
      (|Lex| |Struct-axextend-41-low-4| 4 |l0|))
    (|SetLex| |Struct-axextend-41-high-3| 3 |l0| t19)
    (|SetAElt| t0 (the |SInt| 4) (the |SInt| 749482564))
    (|SetAElt| t1 (the |SInt| 4) t18)
    (|SetAElt|
      t2
      (the |SInt| 4)
      (|Lex| |Struct-axextend-41-high-3| 3 |l0|))
    (|SetLex| |Struct-axextend-41-incr-2| 2 |l0| t20)
    (|SetAElt| t0 (the |SInt| 5) (the |SInt| 766522704))
    (|SetAElt| t1 (the |SInt| 5) t34)
    (|SetAElt|
      t2
      (the |SInt| 5)
      (|Lex| |Struct-axextend-41-incr-2| 2 |l0|))
    (|SetLex| |Struct-axextend-41-by-1| 1 |l0| t21)
    (|SetAElt| t0 (the |SInt| 6) (the |SInt| 51500205))
    (|SetAElt| t1 (the |SInt| 6) t22)
    (|SetAElt|
      t2
      (the |SInt| 6)
      (|Lex| |Struct-axextend-41-by-1| 1 |l0|))
    (|SetLex| |Struct-axextend-41-generator-0| 0 |l0| t25)
    (|SetAElt| t0 (the |SInt| 7) (the |SInt| 113320568))
    (|SetAElt| t1 (the |SInt| 7) t26)
    (|SetAElt|
      t2
      (the |SInt| 7)
      (|Lex| |Struct-axextend-41-generator-0| 0 |l0|))
    (go |Lab3|)))

(defprog
  ((|C166-axextend-defhash0| |SInt|) ((|e1| |Env|)))
  ((|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (block-return
    |C166-axextend-defhash0|
    (|SIntPlusMod|
      (|Lex| |Struct-axextend-41--15| 15 |l1|)
      (the |SInt| 24790784)
      (the |SInt| 1073741789))))

(defprog
  ((|C167-axextend-UniversalSegment|)
    ((|P0-self| |Word|) (|P1-dom| |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Arr|)
    (t2 |Arr|)
    (t3 |Record|)
    (t4 |Record|)
    (t5 |Record|)
    (t6 |Arr|)
    (t7 |SInt|)
    (t8 |Bool|)
    (t9 |Word|)
    (t10 |Word|)
    (t11 |Word|)
    (t12 |Bool|)
    (t13 |SInt|)
    (t14 |Record|)
    (t15 |SInt|)
    (|e3| |Env|)
    (|l3| |Level|))
  (setq |e3| (|EnvNext| (|EnvNext| |e1|)))
  (setq |l3| (|EnvLevel| |e3|))
  (tagbody
    (setq t0 (|ANew| |SInt| (the |SInt| 0)))
    (setq t1 (|ANew| |SInt| (the |SInt| 0)))
    (setq t2 (|ANew| |Word| (the |SInt| 0)))
    (setq t6 (|ANew| |Word| (the |SInt| 1)))
    (setq
      t15
      (|CCall| |G-domainHash!| (|Lex| |Struct-axextend-42-S-0| 0 |l3|)))
    (setq
      t13
      (|SIntPlusMod| t15 (the |SInt| 296696640) (the |SInt| 1073741789)))
    (setq t3 (|RNew| |Struct-axextend-5|))
    (|SetRElt| |Struct-axextend-5| |size| 0 t3 (the |SInt| 0))
    (|SetRElt| |Struct-axextend-5| |nsize| 1 t3 (the |SInt| 0))
    (|SetRElt| |Struct-axextend-5| |values| 2 t3 t0)
    (setq t4 (|RNew| |Struct-axextend-5|))
    (|SetRElt| |Struct-axextend-5| |size| 0 t4 (the |SInt| 0))
    (|SetRElt| |Struct-axextend-5| |nsize| 1 t4 (the |SInt| 0))
    (|SetRElt| |Struct-axextend-5| |values| 2 t4 t1)
    (setq t5 (|RNew| |Struct-axextend-5|))
    (|SetRElt| |Struct-axextend-5| |size| 0 t5 (the |SInt| 0))
    (|SetRElt| |Struct-axextend-5| |nsize| 1 t5 (the |SInt| 0))
    (|SetRElt| |Struct-axextend-5| |values| 2 t5 t2)
    (|CCall| |G-categoryAddExports!| |P0-self| t3 t4 t5)
    (setq t8 (the |Bool| t))
    (setq t9 (|Lex| |Struct-axextend-42-S-0| 0 |l3|))
    (when
      (|CCall|
        |G-domainTestExport!|
        t9
        (the |SInt| 51482908)
        (the |SInt| 962357003))
      (go |Lab9|))
    |Lab4|
    (setq t8 (the |Bool| nil))
    |Lab5|
    (when t8 (go |Lab10|))
    |Lab3|
    (setq t7 (the |SInt| 0))
    |Lab1|
    (when (|SIntEQ| (the |SInt| 1) t7) (go |Lab2|))
    (|SetAElt| t6 t7 nil)
    (setq t7 (|SIntNext| t7))
    (go |Lab1|)
    |Lab2|
    (setq t14 (|RNew| |Struct-axextend-5|))
    (|SetRElt| |Struct-axextend-5| |size| 0 t14 (the |SInt| 1))
    (|SetRElt| |Struct-axextend-5| |nsize| 1 t14 (the |SInt| 1))
    (|SetRElt| |Struct-axextend-5| |values| 2 t14 t6)
    (|CCall| |G-categoryAddParents!| |P0-self| t14 |P1-dom|)
    (block-return |C167-axextend-UniversalSegment| ())
    |Lab10|
    (setq t11 (|Lex| |Struct-axextend-42-S-0| 0 |l3|))
    (when
      (|CCall| |G-domainTestExport!| t11 (the |SInt| 770345191) t13)
      (go |Lab7|))
    (setq t12 (the |Bool| nil))
    |Lab6|
    (when t12 (go |Lab0|))
    (go |Lab3|)
    |Lab0|
    (|SetAElt|
      t6
      (the |SInt| 0)
      (|CCall|
        |G-axextend_GeneratorCategory_073559903|
        (|Lex| |Struct-axextend-42-S-0| 0 |l3|)))
    (setq t7 (the |SInt| 1))
    (go |Lab1|)
    |Lab7|
    (setq t12 (the |Bool| t))
    (go |Lab6|)
    |Lab9|
    (setq t10 (|Lex| |Struct-axextend-42-S-0| 0 |l3|))
    (when
      (|CCall|
        |G-domainTestExport!|
        t10
        (the |SInt| 51482908)
        (the |SInt| 683498711))
      (go |Lab5|))
    (go |Lab4|)))

(defprog
  ((|C168-axextend-..| |Word|)
    ((|P0-a| |Word|) (|P1-b| |Word|) (|e1| |Env|)))
  ((t0 |Record|) (t1 |Record|))
  (setq t0 (|RNew| |Struct-axextend-37|))
  (|SetRElt| |Struct-axextend-37| |low| 0 t0 |P0-a|)
  (|SetRElt| |Struct-axextend-37| |high| 1 t0 |P1-b|)
  (|SetRElt| |Struct-axextend-37| |incr| 2 t0 (the |BInt| 1))
  (setq t1 (|RNew| |Struct-axextend-38|))
  (|SetRElt| |Struct-axextend-38| |tag| 0 t1 (the |SInt| 1))
  (|SetRElt| |Struct-axextend-38| |value| 1 t1 t0)
  (block-return |C168-axextend-..| t1))

(defprog
  ((|C169-axextend-..| |Word|) ((|P0-a| |Word|) (|e1| |Env|)))
  ((t0 |Record|) (t1 |Record|))
  (setq t0 (|RNew| |Struct-axextend-39|))
  (|SetRElt| |Struct-axextend-39| |low| 0 t0 |P0-a|)
  (|SetRElt| |Struct-axextend-39| |incr| 1 t0 (the |BInt| 1))
  (setq t1 (|RNew| |Struct-axextend-38|))
  (|SetRElt| |Struct-axextend-38| |tag| 0 t1 (the |SInt| 0))
  (|SetRElt| |Struct-axextend-38| |value| 1 t1 t0)
  (block-return |C169-axextend-..| t1))

(defprog
  ((|C170-axextend-hasHi| |Word|) ((|P0-x| |Word|) (|e1| |Env|)))
  ()
  (block-return
    |C170-axextend-hasHi|
    (|SIntEQ|
      (|RElt| |Struct-axextend-38| |tag| 0 |P0-x|)
      (the |SInt| 1))))

(defprog
  ((|C171-axextend-low| |Word|) ((|P0-x| |Word|) (|e1| |Env|)))
  ((t0 |Word|))
  (tagbody
    (when
      (|SIntEQ|
        (|RElt| |Struct-axextend-38| |tag| 0 |P0-x|)
        (the |SInt| 1))
      (go |Lab0|))
    (when
      (|SIntIsZero| (|RElt| |Struct-axextend-38| |tag| 0 |P0-x|))
      (go |Lab2|))
    (|Halt| (the |SInt| 103))
    |Lab2|
    (setq
      t0
      (|RElt|
        |Struct-axextend-39|
        |low|
        0
        (|RElt| |Struct-axextend-38| |value| 1 |P0-x|)))
    |Lab1|
    (block-return |C171-axextend-low| t0)
    |Lab0|
    (when
      (|SIntEQ|
        (|RElt| |Struct-axextend-38| |tag| 0 |P0-x|)
        (the |SInt| 1))
      (go |Lab3|))
    (|Halt| (the |SInt| 103))
    |Lab3|
    (setq
      t0
      (|RElt|
        |Struct-axextend-37|
        |low|
        0
        (|RElt| |Struct-axextend-38| |value| 1 |P0-x|)))
    (go |Lab1|)))

(defprog
  ((|C172-axextend-high| |Word|) ((|P0-x| |Word|) (|e1| |Env|)))
  ()
  (tagbody
    (when
      (|SIntEQ|
        (|RElt| |Struct-axextend-38| |tag| 0 |P0-x|)
        (the |SInt| 1))
      (go |Lab0|))
    (|Halt| (the |SInt| 103))
    |Lab0|
    (block-return
      |C172-axextend-high|
      (|RElt|
        |Struct-axextend-37|
        |high|
        1
        (|RElt| |Struct-axextend-38| |value| 1 |P0-x|)))))

(defprog
  ((|C173-axextend-incr| |Word|) ((|P0-x| |Word|) (|e1| |Env|)))
  ((t0 |Word|))
  (tagbody
    (when
      (|SIntEQ|
        (|RElt| |Struct-axextend-38| |tag| 0 |P0-x|)
        (the |SInt| 1))
      (go |Lab0|))
    (when
      (|SIntIsZero| (|RElt| |Struct-axextend-38| |tag| 0 |P0-x|))
      (go |Lab2|))
    (|Halt| (the |SInt| 103))
    |Lab2|
    (setq
      t0
      (|RElt|
        |Struct-axextend-39|
        |incr|
        1
        (|RElt| |Struct-axextend-38| |value| 1 |P0-x|)))
    |Lab1|
    (block-return |C173-axextend-incr| t0)
    |Lab0|
    (when
      (|SIntEQ|
        (|RElt| |Struct-axextend-38| |tag| 0 |P0-x|)
        (the |SInt| 1))
      (go |Lab3|))
    (|Halt| (the |SInt| 103))
    |Lab3|
    (setq
      t0
      (|RElt|
        |Struct-axextend-37|
        |incr|
        2
        (|RElt| |Struct-axextend-38| |value| 1 |P0-x|)))
    (go |Lab1|)))

(defprog
  ((|C174-axextend-by| |Word|)
    ((|P0-x| |Word|) (|P1-s| |Word|) (|e1| |Env|)))
  ((t0 |Word|))
  (tagbody
    (when
      (|SIntEQ|
        (|RElt| |Struct-axextend-38| |tag| 0 |P0-x|)
        (the |SInt| 1))
      (go |Lab0|))
    (when
      (|SIntIsZero| (|RElt| |Struct-axextend-38| |tag| 0 |P0-x|))
      (go |Lab2|))
    (|Halt| (the |SInt| 103))
    |Lab2|
    (|SetRElt|
      |Struct-axextend-39|
      |incr|
      1
      (|RElt| |Struct-axextend-38| |value| 1 |P0-x|)
      |P1-s|)
    (setq t0 |P0-x|)
    |Lab1|
    (block-return |C174-axextend-by| t0)
    |Lab0|
    (when
      (|SIntEQ|
        (|RElt| |Struct-axextend-38| |tag| 0 |P0-x|)
        (the |SInt| 1))
      (go |Lab3|))
    (|Halt| (the |SInt| 103))
    |Lab3|
    (|SetRElt|
      |Struct-axextend-37|
      |incr|
      2
      (|RElt| |Struct-axextend-38| |value| 1 |P0-x|)
      |P1-s|)
    (setq t0 |P0-x|)
    (go |Lab1|)))

(defprog
  ((|C175-axextend-generator| |Clos|) ((|P0-x| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq
    |l0|
    (|MakeLevel| |MAKE-Struct-axextend-40| |Struct-axextend-40|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|SetLex| |Struct-axextend-40-x-0| 0 |l0| |P0-x|)
  (|SetLex| |Struct-axextend-40--5| 5 |l0| (the |SInt| 0))
  (block-return
    |C175-axextend-generator|
    (|Clos| |e0| |C176-axextend-generBaseFn|)))

(defprog
  ((|C176-axextend-generBaseFn| |Clos| |Clos| |Clos| |Clos|)
    ((|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| nil)
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (block-return
    |C176-axextend-generBaseFn|
    (values
      (|Clos| |e0| |C178-axextend-generDone?|)
      (|Clos| |e0| |C177-axextend-generStepper|)
      (|Clos| |e0| |C179-axextend-generValue|)
      (|Clos| |e0| |C180-axextend-generBound|))))

(defprog
  ((|C177-axextend-generStepper|) ((|e1| |Env|)))
  ((t0 |Word|)
    (t1 |Word|)
    (t2 |Word|)
    (t3 |Word|)
    (t4 |Word|)
    (|e2| |Env|)
    (|l2| |Level|)
    (|e3| |Env|)
    (|l3| |Level|))
  (setq |e2| (|EnvNext| |e1|))
  (setq |l2| (|EnvLevel| |e2|))
  (setq |e3| (|EnvNext| |e2|))
  (setq |l3| (|EnvLevel| |e3|))
  (tagbody
    (cases
      (|Lex| |Struct-axextend-40--5| 5 |l2|)
      (3 (go |Lab14|))
      (2 (go |Lab10|))
      (1 (go |Lab8|))
      (0 (go |Lab0|)))
    |Lab0|
    (|SetLex| |Struct-axextend-40--4| 4 |l2| (the |Bool| nil))
    (when
      (|SIntIsZero|
        (|RElt|
          |Struct-axextend-38|
          |tag|
          0
          (|Lex| |Struct-axextend-40-x-0| 0 |l2|)))
      (go |Lab2|))
    (when
      (|SIntEQ|
        (|RElt|
          |Struct-axextend-38|
          |tag|
          0
          (|Lex| |Struct-axextend-40-x-0| 0 |l2|))
        (the |SInt| 1))
      (go |Lab3|))
    (|Halt| (the |SInt| 103))
    |Lab3|
    (|SetLex|
      |Struct-axextend-40-h-1|
      1
      |l2|
      (|RElt|
        |Struct-axextend-37|
        |high|
        1
        (|RElt|
          |Struct-axextend-38|
          |value|
          1
          (|Lex| |Struct-axextend-40-x-0| 0 |l2|))))
    (when
      (|SIntEQ|
        (|RElt|
          |Struct-axextend-38|
          |tag|
          0
          (|Lex| |Struct-axextend-40-x-0| 0 |l2|))
        (the |SInt| 1))
      (go |Lab4|))
    (|Halt| (the |SInt| 103))
    |Lab4|
    (|SetLex|
      |Struct-axextend-40-l-3|
      3
      |l2|
      (|RElt|
        |Struct-axextend-37|
        |low|
        0
        (|RElt|
          |Struct-axextend-38|
          |value|
          1
          (|Lex| |Struct-axextend-40-x-0| 0 |l2|))))
    (when
      (|SIntEQ|
        (|RElt|
          |Struct-axextend-38|
          |tag|
          0
          (|Lex| |Struct-axextend-40-x-0| 0 |l2|))
        (the |SInt| 1))
      (go |Lab5|))
    (|Halt| (the |SInt| 103))
    |Lab5|
    (|SetLex|
      |Struct-axextend-40-inc-2|
      2
      |l2|
      (|CCall|
        (|Lex| |Struct-axextend-41-coerce-8| 8 |l3|)
        (|RElt|
          |Struct-axextend-37|
          |incr|
          2
          (|RElt|
            |Struct-axextend-38|
            |value|
            1
            (|Lex| |Struct-axextend-40-x-0| 0 |l2|)))))
    (setq t4 (|Lex| |Struct-axextend-40-x-0| 0 |l2|))
    (when
      (|SIntEQ| (|RElt| |Struct-axextend-38| |tag| 0 t4) (the |SInt| 1))
      (go |Lab19|))
    (when
      (|SIntIsZero| (|RElt| |Struct-axextend-38| |tag| 0 t4))
      (go |Lab21|))
    (|Halt| (the |SInt| 103))
    |Lab21|
    (setq
      t3
      (|RElt|
        |Struct-axextend-39|
        |incr|
        1
        (|RElt| |Struct-axextend-38| |value| 1 t4)))
    |Lab20|
    (when
      (|CCall|
        (|Lex| |Struct-axextend-41->=-13| 13 |l3|)
        t3
        (the |BInt| 1))
      (go |Lab9|))
    (setq t2 (|Lex| |Struct-axextend-40-x-0| 0 |l2|))
    (when
      (|SIntEQ| (|RElt| |Struct-axextend-38| |tag| 0 t2) (the |SInt| 1))
      (go |Lab15|))
    (when
      (|SIntIsZero| (|RElt| |Struct-axextend-38| |tag| 0 t2))
      (go |Lab17|))
    (|Halt| (the |SInt| 103))
    |Lab17|
    (setq
      t1
      (|RElt|
        |Struct-axextend-39|
        |incr|
        1
        (|RElt| |Struct-axextend-38| |value| 1 t2)))
    |Lab16|
    (when
      (|CCall| (|Lex| |Struct-axextend-41-<-12| 12 |l3|) t1 (the |BInt| 1))
      (go |Lab7|))
    |Lab6|
    (|SetLex| |Struct-axextend-40--4| 4 |l2| (the |Bool| t))
    (block-return |C177-axextend-generStepper| ())
    |Lab7|
    (when
      (|CCall|
        (|Lex| |Struct-axextend-41->=-10| 10 |l3|)
        (|Lex| |Struct-axextend-40-l-3| 3 |l2|)
        (|Lex| |Struct-axextend-40-h-1| 1 |l2|))
      (go |Lab33|))
    (go |Lab6|)
    |Lab33|
    (|SetLex| |Struct-axextend-40--5| 5 |l2| (the |SInt| 1))
    (setq t0 (|Lex| |Struct-axextend-40-l-3| 3 |l2|))
    |Lab1|
    (|SetLex| |Struct-axextend-40--6| 6 |l2| t0)
    (block-return |C177-axextend-generStepper| ())
    |Lab15|
    (when
      (|SIntEQ| (|RElt| |Struct-axextend-38| |tag| 0 t2) (the |SInt| 1))
      (go |Lab18|))
    (|Halt| (the |SInt| 103))
    |Lab18|
    (setq
      t1
      (|RElt|
        |Struct-axextend-37|
        |incr|
        2
        (|RElt| |Struct-axextend-38| |value| 1 t2)))
    (go |Lab16|)
    |Lab9|
    (when
      (|CCall|
        (|Lex| |Struct-axextend-41-<=-11| 11 |l3|)
        (|Lex| |Struct-axextend-40-l-3| 3 |l2|)
        (|Lex| |Struct-axextend-40-h-1| 1 |l2|))
      (go |Lab35|))
    (go |Lab6|)
    |Lab35|
    (|SetLex| |Struct-axextend-40--5| 5 |l2| (the |SInt| 2))
    (setq t0 (|Lex| |Struct-axextend-40-l-3| 3 |l2|))
    (go |Lab1|)
    |Lab19|
    (when
      (|SIntEQ| (|RElt| |Struct-axextend-38| |tag| 0 t4) (the |SInt| 1))
      (go |Lab22|))
    (|Halt| (the |SInt| 103))
    |Lab22|
    (setq
      t3
      (|RElt|
        |Struct-axextend-37|
        |incr|
        2
        (|RElt| |Struct-axextend-38| |value| 1 t4)))
    (go |Lab20|)
    |Lab2|
    (when
      (|SIntIsZero|
        (|RElt|
          |Struct-axextend-38|
          |tag|
          0
          (|Lex| |Struct-axextend-40-x-0| 0 |l2|)))
      (go |Lab11|))
    (|Halt| (the |SInt| 103))
    |Lab11|
    (|SetLex|
      |Struct-axextend-40-l-3|
      3
      |l2|
      (|RElt|
        |Struct-axextend-39|
        |low|
        0
        (|RElt|
          |Struct-axextend-38|
          |value|
          1
          (|Lex| |Struct-axextend-40-x-0| 0 |l2|))))
    (when
      (|SIntIsZero|
        (|RElt|
          |Struct-axextend-38|
          |tag|
          0
          (|Lex| |Struct-axextend-40-x-0| 0 |l2|)))
      (go |Lab12|))
    (|Halt| (the |SInt| 103))
    |Lab12|
    (|SetLex|
      |Struct-axextend-40-inc-2|
      2
      |l2|
      (|CCall|
        (|Lex| |Struct-axextend-41-coerce-8| 8 |l3|)
        (|RElt|
          |Struct-axextend-39|
          |incr|
          1
          (|RElt|
            |Struct-axextend-38|
            |value|
            1
            (|Lex| |Struct-axextend-40-x-0| 0 |l2|)))))
    |Lab13|
    (|SetLex| |Struct-axextend-40--5| 5 |l2| (the |SInt| 3))
    (setq t0 (|Lex| |Struct-axextend-40-l-3| 3 |l2|))
    (go |Lab1|)
    |Lab8|
    (|SetLex|
      |Struct-axextend-40-l-3|
      3
      |l2|
      (|CCall|
        (|Lex| |Struct-axextend-41-+-9| 9 |l3|)
        (|Lex| |Struct-axextend-40-l-3| 3 |l2|)
        (|Lex| |Struct-axextend-40-inc-2| 2 |l2|)))
    (go |Lab7|)
    |Lab10|
    (|SetLex|
      |Struct-axextend-40-l-3|
      3
      |l2|
      (|CCall|
        (|Lex| |Struct-axextend-41-+-9| 9 |l3|)
        (|Lex| |Struct-axextend-40-l-3| 3 |l2|)
        (|Lex| |Struct-axextend-40-inc-2| 2 |l2|)))
    (go |Lab9|)
    |Lab14|
    (|SetLex|
      |Struct-axextend-40-l-3|
      3
      |l2|
      (|CCall|
        (|Lex| |Struct-axextend-41-+-9| 9 |l3|)
        (|Lex| |Struct-axextend-40-l-3| 3 |l2|)
        (|Lex| |Struct-axextend-40-inc-2| 2 |l2|)))
    (go |Lab13|)))

(defprog
  ((|C178-axextend-generDone?| |Bool|) ((|e1| |Env|)))
  ((|e2| |Env|) (|l2| |Level|))
  (setq |e2| (|EnvNext| |e1|))
  (setq |l2| (|EnvLevel| |e2|))
  (block-return
    |C178-axextend-generDone?|
    (|Lex| |Struct-axextend-40--4| 4 |l2|)))

(defprog
  ((|C179-axextend-generValue| |Word|) ((|e1| |Env|)))
  ((|e2| |Env|) (|l2| |Level|))
  (setq |e2| (|EnvNext| |e1|))
  (setq |l2| (|EnvLevel| |e2|))
  (block-return
    |C179-axextend-generValue|
    (|Lex| |Struct-axextend-40--6| 6 |l2|)))

(defprog
  ((|C180-axextend-generBound| |SInt|) ((|e1| |Env|)))
  ()
  (block-return |C180-axextend-generBound| (the |SInt| -1)))

(defprog
  ((|C181-axextend-axextend| |Word|) ((p0-s |Word|) (|e1| |Env|)))
  ((t0 |Word|)
    (t1 |Arr|)
    (t2 |Record|)
    (t3 |Word|)
    (t4 |Word|)
    (|l0| |Level|)
    (|e0| |Env|)
    (|l1| |Level|))
  (setq
    |l0|
    (|MakeLevel| |MAKE-Struct-axextend-43| |Struct-axextend-43|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (|SetLex| |Struct-axextend-43-S-0| 0 |l0| p0-s)
    (setq t1 (|ANew| |Word| (the |SInt| 1)))
    (setq t2 (|RNew| |Struct-axextend-11|))
    (|SetRElt| |Struct-axextend-11| |size| 0 t2 (the |SInt| 1))
    (|SetRElt| |Struct-axextend-11| |values| 1 t2 t1)
    (when
      (|PtrIsNil| (|Lex| |Struct-axextend-45--20| 20 |l1|))
      (go |Lab3|))
    |Lab1|
    (|SetAElt|
      t1
      (the |SInt| 0)
      (|Lex| |Struct-axextend-43-S-0| 0 |l0|))
    (multiple-value-setq
      (t3 t4)
      (|CCall|
        |G-rtCacheCheck|
        (|Lex| |Struct-axextend-45--20| 20 |l1|)
        t2))
    (when t4 (go |Lab0|))
    (setq
      t0
      (|CCall| |G-extendMake| (|Clos| |e0| |C182-axextend-extend0|)))
    (setq
      t3
      (|CCall|
        |G-rtCacheAdd|
        (|Lex| |Struct-axextend-45--20| 20 |l1|)
        t2
        t0))
    |Lab0|
    (block-return |C181-axextend-axextend| t3)
    |Lab3|
    (|SetLex|
      |Struct-axextend-45--20|
      20
      |l1|
      (|CCall| |G-rtCacheExplicitMake| (the |SInt| 15)))
    (go |Lab1|)))

(defprog
  ((|C182-axextend-extend0| |Clos|) ((|P0-domain| |Word|) (|e1| |Env|)))
  ((t0 |Arr|) (t1 |Record|) (|l1| |Level|) (|e2| |Env|) (|l2| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (setq |e2| (|EnvNext| |e1|))
  (setq |l2| (|EnvLevel| |e2|))
  (setq t0 (|ANew| |Word| (the |SInt| 2)))
  (|SetAElt|
    t0
    (the |SInt| 1)
    (|CCall|
      (|Lex| |Struct-axextend-45-UniversalSegment-6| 6 |l2|)
      (|Lex| |Struct-axextend-43-S-0| 0 |l1|)))
  (|SetAElt|
    t0
    (the |SInt| 0)
    (|CCall|
      |G-axextend_UniversalSegment_550108180|
      (|Lex| |Struct-axextend-43-S-0| 0 |l1|)))
  (setq t1 (|RNew| |Struct-axextend-5|))
  (|SetRElt| |Struct-axextend-5| |size| 0 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axextend-5| |nsize| 1 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axextend-5| |values| 2 t1 t0)
  (|CCall| |G-extendFill!| |P0-domain| t1)
  (block-return |C182-axextend-extend0| |P0-domain|))

(defprog
  ((|C183-axextend-lazyFnGetter| |Clos|)
    ((|P0-init| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq
    |l0|
    (|MakeLevel| |MAKE-Struct-axextend-44| |Struct-axextend-44|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|SetLex| |Struct-axextend-44-getter-0| 0 |l0| |P0-init|)
  (|SetLex| |Struct-axextend-44-flag-1| 1 |l0| (the |Bool| nil))
  (|SetLex|
    |Struct-axextend-44-self-2|
    2
    |l0|
    (|Clos| |e0| |C184-axextend-lazyGetter|))
  (|SetEnvInfo| |e0| (|Clos| |e0| |C185-axextend-lazyGetter2|))
  (block-return
    |C183-axextend-lazyFnGetter|
    (|Lex| |Struct-axextend-44-self-2| 2 |l0|)))

(defprog
  ((|C184-axextend-lazyGetter| |Clos|) ((|P0-a| |Word|) (|e1| |Env|)))
  ((t0 |Clos|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-axextend-44-flag-1| 1 |l1|) (go |Lab0|))
    (setq t0 (|CCall| (|Lex| |Struct-axextend-44-getter-0| 0 |l1|)))
    (|SetClosEnv|
      (|Lex| |Struct-axextend-44-self-2| 2 |l1|)
      (|ClosEnv| t0))
    (|SetClosFun|
      (|Lex| |Struct-axextend-44-self-2| 2 |l1|)
      (|ClosFun| t0))
    (|SetLex| |Struct-axextend-44-flag-1| 1 |l1| (the |Bool| t))
    |Lab0|
    (block-return
      |C184-axextend-lazyGetter|
      (|CCall| (|Lex| |Struct-axextend-44-self-2| 2 |l1|) |P0-a|))))

(defprog
  ((|C185-axextend-lazyGetter2|) ((|e1| |Env|)))
  ((t0 |Clos|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-axextend-44-flag-1| 1 |l1|) (go |Lab0|))
    (setq t0 (|CCall| (|Lex| |Struct-axextend-44-getter-0| 0 |l1|)))
    (|SetLex| |Struct-axextend-44-flag-1| 1 |l1| (the |Bool| t))
    (|SetClosEnv|
      (|Lex| |Struct-axextend-44-self-2| 2 |l1|)
      (|ClosEnv| t0))
    (|SetClosFun|
      (|Lex| |Struct-axextend-44-self-2| 2 |l1|)
      (|ClosFun| t0))
    (|SetEnvInfo| |e1| nil)
    |Lab0|
    (block-return |C185-axextend-lazyGetter2| ())))

(defprog
  ((|C186-axextend-axiom-init| |Word|) ((|P0-idx| |SInt|) (|e1| |Env|)))
  ((|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-axextend-45--21| 21 |l1|) (go |Lab0|))
    (|SetLex| |Struct-axextend-45--21| 21 |l1| (the |Bool| t))
    (|CCall| |G-axiom|)
    |Lab0|
    (when (|SIntNE| |P0-idx| (the |SInt| 6)) (go |Lab1|))
    (block-return
      |C186-axextend-axiom-init|
      |G-axiom_UniversalSegment_339036324|)
    |Lab1|
    (when (|SIntNE| |P0-idx| (the |SInt| 5)) (go |Lab2|))
    (block-return |C186-axextend-axiom-init| |G-axiom_Segment_199524315|)
    |Lab2|
    (when (|SIntNE| |P0-idx| (the |SInt| 4)) (go |Lab3|))
    (block-return
      |C186-axextend-axiom-init|
      |G-axiom_AbelianSemiGroup_617599533|)
    |Lab3|
    (when (|SIntNE| |P0-idx| (the |SInt| 3)) (go |Lab4|))
    (block-return
      |C186-axextend-axiom-init|
      |G-axiom_OrderedSet_442618075|)
    |Lab4|
    (when (|SIntNE| |P0-idx| (the |SInt| 2)) (go |Lab5|))
    (block-return |C186-axextend-axiom-init| |G-axiom_Matrix_941869819|)
    |Lab5|
    (when (|SIntNE| |P0-idx| (the |SInt| 1)) (go |Lab6|))
    (block-return |C186-axextend-axiom-init| |G-axiom_Vector_1031808574|)
    |Lab6|
    (block-return |C186-axextend-axiom-init| |G-axiom_Boolean_767845329|)))

(defprog
  ((|C187-axextend-axlit-init| |Word|) ((|P0-idx| |SInt|) (|e1| |Env|)))
  ((|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-axextend-45--22| 22 |l1|) (go |Lab0|))
    (|SetLex| |Struct-axextend-45--22| 22 |l1| (the |Bool| t))
    (|CCall| |G-axlit|)
    |Lab0|
    (when (|SIntNE| |P0-idx| (the |SInt| 10)) (go |Lab1|))
    (block-return
      |C187-axextend-axlit-init|
      |G-axlit_BuiltinValue_091505407|)
    |Lab1|
    (when (|SIntNE| |P0-idx| (the |SInt| 9)) (go |Lab2|))
    (block-return |C187-axextend-axlit-init| |G-axlit_Tuple_310792372|)
    |Lab2|
    (when (|SIntNE| |P0-idx| (the |SInt| 8)) (go |Lab3|))
    (block-return
      |C187-axextend-axlit-init|
      |G-axlit_BuiltinArray_589498848|)
    |Lab3|
    (when (|SIntNE| |P0-idx| (the |SInt| 7)) (go |Lab4|))
    (block-return |C187-axextend-axlit-init| |G-axlit_List_927796144|)
    |Lab4|
    (when (|SIntNE| |P0-idx| (the |SInt| 6)) (go |Lab5|))
    (block-return
      |C187-axextend-axlit-init|
      |G-axlit_PositiveInteger_1048974412|)
    |Lab5|
    (when (|SIntNE| |P0-idx| (the |SInt| 5)) (go |Lab6|))
    (block-return
      |C187-axextend-axlit-init|
      |G-axlit_NonNegativeInteger_858745464|)
    |Lab6|
    (when (|SIntNE| |P0-idx| (the |SInt| 4)) (go |Lab7|))
    (block-return |C187-axextend-axlit-init| |G-axlit_Integer_273754537|)
    |Lab7|
    (when (|SIntNE| |P0-idx| (the |SInt| 3)) (go |Lab8|))
    (block-return |C187-axextend-axlit-init| |G-axlit_error_011667951|)
    |Lab8|
    (when (|SIntNE| |P0-idx| (the |SInt| 2)) (go |Lab9|))
    (block-return
      |C187-axextend-axlit-init|
      |G-axlit_SingleInteger_1058045725|)
    |Lab9|
    (when (|SIntNE| |P0-idx| (the |SInt| 1)) (go |Lab10|))
    (block-return |C187-axextend-axlit-init| |G-axlit_Symbol_738567780|)
    |Lab10|
    (block-return |C187-axextend-axlit-init| |G-axlit_String_050790629|)))

(setq |G-axextend| (|Clos| nil |C0-axextend-axextend|))

(setq |G-axextend_Segment_249071355| nil)

(setq |G-axextend_Matrix_057561278| nil)

(setq |G-axextend_Vector_075828558| nil)

(setq |G-axextend_List_412811383| nil)

(setq |G-axextend_PositiveInteger_619949646| nil)

(setq |G-axextend_NonNegativeInteger_029131062| nil)

(setq |G-axextend_UniversalSegment_550108180| nil)

(setq |G-axextend_Integer_465677675| nil)

(setq |G-axextend_SingleInteger_302027834| nil)

(setq |G-axextend_Symbol_636926304| nil)

(setq |G-axextend_GeneratorCategory_073559903| nil)

(setq |G-axextend_Symbol_209526317| nil)

(setq |G-axextend_SingleInteger_499971776| nil)

(setq |G-axextend_Integer_437506685| nil)

(setq |G-axextend_UniversalSegment_408232398| nil)

(setq |G-axextend_NonNegativeInteger_682440215| nil)

(setq |G-axextend_PositiveInteger_418138371| nil)

(setq |G-axextend_List_134950155| nil)

(setq |G-axextend_Vector_052715942| nil)

(setq |G-axextend_Matrix_855611627| nil)

(setq |G-axextend_Segment_557651354| nil)

(setq |C188-axextend-1| (the |SInt| 1))

(setq |C189-axextend-0| (the |SInt| 0))

(setq |C190-axextend-1| (the |BInt| 1))

(setq |C191-axextend-0| (the |BInt| 0))

(setq |C192-axextend-nilptr| nil)

(setq |C193-axextend-1| (the |BInt| 1))

(setq |C194-axextend-0| (the |BInt| 0))

(setq |C195-axextend-1| (the |BInt| 1))

(setq |C196-axextend-nil| nil)

(file-imports
  '((|G-axlit| "axlit" |initializer| "")
      (|G-axiom| "axiom" |initializer| "")
      (|G-rtAddStrings| "rtAddStrings" 0 "")
      (|G-axiom_UniversalSegment_339036324|
        "UniversalSegment"
        339036324
        "axiom")
      (|G-axiom_Segment_199524315| "Segment" 199524315 "axiom")
      (|G-domainAddDefaults!| "domainAddDefaults!" 0 "")
      (|G-axiom_AbelianSemiGroup_617599533|
        "AbelianSemiGroup"
        617599533
        "axiom")
      (|G-axiom_OrderedSet_442618075| "OrderedSet" 442618075 "axiom")
      (|G-categoryAddParents!| "categoryAddParents!" 0 "")
      (|G-domainTestExport!| "domainTestExport!" 0 "")
      (|G-categoryMake| "categoryMake" 0 "")
      (|G-categoryAddExports!| "categoryAddExports!" 0 "")
      (|G-axiom_Matrix_941869819| "Matrix" 941869819 "axiom")
      (|G-axiom_Vector_1031808574| "Vector" 1031808574 "axiom")
      (|G-axlit_BuiltinValue_091505407| "BuiltinValue" 91505407 "axlit")
      (|G-axlit_Tuple_310792372| "Tuple" 310792372 "axlit")
      (|G-axlit_BuiltinArray_589498848| "BuiltinArray" 589498848 "axlit")
      (|G-axlit_List_927796144| "List" 927796144 "axlit")
      (|G-rtCacheAdd| "rtCacheAdd" 0 "")
      (|G-rtSingleParamNameFn| "rtSingleParamNameFn" 0 "")
      (|G-rtCacheCheck| "rtCacheCheck" 0 "")
      (|G-rtCacheExplicitMake| "rtCacheExplicitMake" 0 "")
      (|G-axlit_PositiveInteger_1048974412|
        "PositiveInteger"
        1048974412
        "axlit")
      (|G-axlit_NonNegativeInteger_858745464|
        "NonNegativeInteger"
        858745464
        "axlit")
      (|G-stdGetRetWord0| "stdGetRetWord0" 0 "")
      (|G-axlit_Integer_273754537| "Integer" 273754537 "axlit")
      (|G-rtDelayedInit!| "rtDelayedInit!" 0 "")
      (|G-axlit_error_011667951| "error" 11667951 "axlit")
      (|G-stdGetWordWordRetWord0| "stdGetWordWordRetWord0" 0 "")
      (|G-axiom_Boolean_767845329| "Boolean" 767845329 "axiom")
      (|G-axlit_SingleInteger_1058045725|
        "SingleInteger"
        1058045725
        "axlit")
      (|G-extendMake| "extendMake" 0 "")
      (|G-extendFill!| "extendFill!" 0 "")
      (|G-axlit_Symbol_738567780| "Symbol" 738567780 "axlit")
      (|G-domainMake| "domainMake" 0 "")
      (|G-stdGetWordRetWord0| "stdGetWordRetWord0" 0 "")
      (|G-rtDelayedGetExport!| "rtDelayedGetExport!" 0 "")
      (|G-domainHash!| "domainHash!" 0 "")
      (|G-rtLazyDomFrInit| "rtLazyDomFrInit" 0 "")
      (|G-axlit_String_050790629| "String" 50790629 "axlit")
      (|G-domainMakeDispatch| "domainMakeDispatch" 0 "")
      (|G-domainAddExports!| "domainAddExports!" 0 "")
      (|G-domainAddHash!| "domainAddHash!" 0 "")
      (|G-domainAddNameFn!| "domainAddNameFn!" 0 "")
      (|G-rtConstNameFn| "rtConstNameFn" 0 "")
      (|G-runtime| "runtime" |initializer| "")
      (|G-noOperation| "noOperation" 0 "")))

(file-exports
  '((|G-axextend_Segment_557651354| "Segment" 557651354 "axextend")
      (|G-axextend_Matrix_855611627| "Matrix" 855611627 "axextend")
      (|G-axextend_Vector_052715942| "Vector" 52715942 "axextend")
      (|G-axextend_List_134950155| "List" 134950155 "axextend")
      (|G-axextend_PositiveInteger_418138371|
        "PositiveInteger"
        418138371
        "axextend")
      (|G-axextend_NonNegativeInteger_682440215|
        "NonNegativeInteger"
        682440215
        "axextend")
      (|G-axextend_UniversalSegment_408232398|
        "UniversalSegment"
        408232398
        "axextend")
      (|G-axextend_Integer_437506685| "Integer" 437506685 "axextend")
      (|G-axextend_SingleInteger_499971776|
        "SingleInteger"
        499971776
        "axextend")
      (|G-axextend_Symbol_209526317| "Symbol" 209526317 "axextend")
      (|G-axextend_GeneratorCategory_073559903|
        "GeneratorCategory"
        73559903
        "axextend")
      (|G-axextend_Symbol_636926304| "Symbol" 636926304 "axextend")
      (|G-axextend_SingleInteger_302027834|
        "SingleInteger"
        302027834
        "axextend")
      (|G-axextend_Integer_465677675| "Integer" 465677675 "axextend")
      (|G-axextend_UniversalSegment_550108180|
        "UniversalSegment"
        550108180
        "axextend")
      (|G-axextend_NonNegativeInteger_029131062|
        "NonNegativeInteger"
        29131062
        "axextend")
      (|G-axextend_PositiveInteger_619949646|
        "PositiveInteger"
        619949646
        "axextend")
      (|G-axextend_List_412811383| "List" 412811383 "axextend")
      (|G-axextend_Vector_075828558| "Vector" 75828558 "axextend")
      (|G-axextend_Matrix_057561278| "Matrix" 57561278 "axextend")
      (|G-axextend_Segment_249071355| "Segment" 249071355 "axextend")
      (|G-axextend| "axextend" |initializer| "")))
@
\eject
\begin{thebibliography}{99}
\bibitem{1} nothing
\end{thebibliography}
\end{document}
