# -*- coding: utf-8 -*-
# Balazar in the Rancid Skull Dungeon
# Copyright (C) 2008 Jean-Baptiste LAMY
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os, os.path

from balazar3.rooms import *

room_names = []#str(i) for i in range(1, 3)]
for file in os.listdir("./balazar3/rooms/"):
  i = file[5:-3]
  try: i = int(i)
  except: continue
  room_names.append(str(i))


left_open_rooms = []
for i in room_names:
  room = Room.get(i)
  if room.blocs[0][3] == 2: left_open_rooms.append(room.name)

right_open_rooms = []
for i in room_names:
  room = Room.get(i)
  if room.blocs[6][3] == 2: right_open_rooms.append(room.name)

up_open_rooms = []
for i in room_names:
  room = Room.get(i)
  if room.blocs[3][6] == 2: up_open_rooms.append(room.name)

down_open_rooms = []
for i in room_names:
  room = Room.get(i)
  if room.blocs[3][0] == 2: down_open_rooms.append(room.name)

f = open("./balazar3/rooms/rooms_defs.py", "w")

f.write("""
all_rooms          = set(%s)
left_open_rooms    = set(%s)
right_open_rooms   = set(%s)
up_open_rooms      = set(%s)
down_open_rooms    = set(%s)

""" % (repr(room_names),
       repr(left_open_rooms ),
       repr(right_open_rooms),
       repr(up_open_rooms   ),
       repr(down_open_rooms ),
       ))

