# -*- coding: utf-8 -*-

# Balazar in the Rancid Skull Dungeon
# Copyright (C) 2001-2008 Jean-Baptiste LAMY -- jibalamy@free.fr
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Locale Extract

Usage :

  localeextract TRANSLATE_TO [TRANSLATE_FROM]

where TRANSLATE_TO is the language two-letter code (e.g.: fr, nb, en,...),
and TRANSLATE_FROM is the language from whuch you are translating (defaults to en)

Extract all the new GetText key to translate.
"""

import sys, os, os.path, gettext, re

HERE = os.path.dirname(sys.argv[0])

if (len(sys.argv) <= 1) or (sys.argv[1] in ("--help", "-h")):
  print __doc__
  sys.exit()
  
translate_to = sys.argv[1]
if len(sys.argv) >= 3: translate_from = sys.argv[2]
else:                  translate_from = "en"


gettext_pattern = re.compile(r'msgid\s*"(.*?)"\s*msgstr\s*"(.*?)"', re.DOTALL)


# The original version is the French one.
french_list = gettext_pattern.findall(open(os.path.join(HERE, "..", "locale", "fr", "LC_MESSAGES", "balazar3.po")).read())
french = dict(french_list)

english       = dict(gettext_pattern.findall(open(os.path.join(HERE, "..", "locale", "en", "LC_MESSAGES", "balazar3.po")).read()))
sources       = dict(gettext_pattern.findall(open(os.path.join(HERE, "..", "locale", translate_from, "LC_MESSAGES", "balazar3.po")).read()))
try: previous = dict(gettext_pattern.findall(open(os.path.join(HERE, "..", "locale", translate_to, "LC_MESSAGES", "balazar3.po")).read()))
except: previous = {}
translations = []



for key, string in french_list: # Keept the translation order, e.g. to keep together all the discussion of the same mission.
  if key:
    if not key in previous.keys():
      if key[:2] == "__":
        translations.append((key, sources.get(key) or english.get(key) or french.get(key) or key))
        
      elif (translate_to != "en"): # Key not strating by "__" are the english translation itself.
        translations.append((key, sources.get(key) or key))
        
for key, string in translations:
  print 'msgid  "%s"' % key
  print 'msgstr "%s"' % string
  print



