/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 * @authors Andrew Dinn
 */
package org.jboss.byteman.tests.check;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.jboss.byteman.check.RuleCheck;
import org.jboss.byteman.check.RuleCheckResult;
import org.jboss.byteman.tests.Test;

public class TestRuleCheck extends Test
{

    public TestRuleCheck()
    {
        super(TestRuleCheck.class.getCanonicalName());
    }

    public void test()
    {
        RuleCheck checker = new RuleCheck();
        // don't include access tests as they will fail
        // when we don't have the jigsaw access enabler
        List<String> bugfixRejects = new ArrayList<String>();
        // exclude this bugfix script as it is expected not to type check for some triggers
        bugfixRejects.add("TestAsTarget.btm");
        addBtmScript(checker, new File("src/test/resources/scripts/bugfixes"), bugfixRejects);
        addBtmScript(checker, new File("src/test/resources/scripts/helpertests"));
        addBtmScript(checker, new File("src/test/resources/scripts/javaops"));
        addBtmScript(checker, new File("src/test/resources/scripts/location"));
        addBtmScript(checker, new File("src/test/resources/scripts/misc"));
        checker.addPackage("org.jboss.byteman.tests.auxiliary");
        checker.addPackage("org.jboss.byteman.tests.location");
        checker.addPackage("org.jboss.byteman.tests.bugfixes");
        checker.addPackage("org.jboss.byteman.tests.javaops");
        checker.addPackage("org.jboss.byteman.tests.helpertests");
        checker.checkRules();
        RuleCheckResult result= checker.getResult();
        if(result.hasError() || result.hasWarning()) {
            List<String> errors = result.getErrorMessages();
            for(String error : errors) {
                System.out.println(error);
            }
            errors = result.getParseErrorMessages();
            for(String error : errors) {
                System.out.println(error);
            }
            errors = result.getTypeErrorMessages();
            for(String error : errors) {
                System.out.println(error);
            }
            errors = result.getWarningMessages();
            for(String error : errors) {
                System.out.println(error);
            }
            errors = result.getTypeWarningMessages();
            for(String error : errors) {
                System.out.println(error);
            }
        }
        assertTrue(!result.hasError());
    }
    
    private void addBtmScript(RuleCheck checker, File dir) {
        addBtmScript(checker, dir, null);
    }

    private void addBtmScript(RuleCheck checker, File dir, List<String> rejects) {
        if(dir.isDirectory()) {
            String[] files = dir.list();
            for(String name : files) {
                if(!reject(name, rejects)) {
                    File file = new File(dir + "/" + name);
                    if (file.isDirectory()) {
                        addBtmScript(checker, file, rejects);
                    } else {
                        checker.addRuleFile(dir + "/" + name);
                    }
                }
            }
        }
    }

    private boolean reject(String name, List<String> rejects) {
        if(rejects != null) {
            for (String reject : rejects) {
                if(name.matches(reject)) {
                    return true;
                }
            }
        }
        return false;
    }
}
