/**
 *    Copyright 2023 Sivasuriyan
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package org.xmlcml.cml.element.main;

import nu.xom.Element;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.element.CMLGradient;

public class CMLGradientTest {

    CMLGradient cmlGradient;

    @Before
    public void setup(){
        cmlGradient = new CMLGradient();
    }

    @Test
    public void testCMLGradientCopy() {
        Element copyElement = cmlGradient.copy();
        Assert.assertEquals(copyElement.getClass(), CMLGradient.class);
    }

    @Test
    public void testMakeElementInContext() {
        Element element = new CMLGradient();
        CMLElement actual = cmlGradient.makeElementInContext(element);
        Assert.assertEquals(CMLGradient.class, actual.getClass());
    }

    @Test
    public void testCMLGradient() {
        CMLGradient cmlGradientOld = new CMLGradient();
        CMLGradient cmlGradient = new CMLGradient(cmlGradientOld);
        Assert.assertEquals(cmlGradient.getClass(), CMLGradient.class);
    }
}