/*
 * CRRCsim - the Charles River Radio Control Club Flight Simulator Project
 * 
 * Copyright (C) 2010 Jens Wilhelm Wulf (original author)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
  


#ifndef CRRC_SETRECORDNAME_H
#define CRRC_SETRECORDNAME_H

#include <plib/pu.h>
#include <plib/puAux.h>
#include <vector>

#include "crrc_dialog.h"
#include "puaFileBox.h"


class CGUISetRecordNameDialog;

/** \brief Set filename and description for current flight
 *
 */
class CGUISetRecordNameDialog : public CRRCDialog
{
public:
  CGUISetRecordNameDialog();
  ~CGUISetRecordNameDialog();
  
  puInput*  filename;
  puaLargeInput* description;
};

#endif // CRRC_SETRECORDNAME_H
