/* See "licence DDRace.txt" and the readme.txt in the root of the distribution for more information. */
#ifndef GAME_SERVER_ENTITIES_DRAGGER_BEAM_H
#define GAME_SERVER_ENTITIES_DRAGGER_BEAM_H

#include <game/server/entity.h>

class CDragger;
class CGameWorld;

/**
 * Dragger beams pull a selected player towards their center
 * 
 * Dragger beams are generated by a particular dragger for the player closest to it and for whom certain criteria are
 * met. Dragger beams exist until these criteria are no longer met. Dragger beams dissolve and automatically
 * de-register from their dragger source as soon as the player for whom they were created:
 * - is no longer alive
 * - is no longer in range (sv_dragger_range)
 * - can no longer be dragged because the beam is intercepted by a laser stopper (or if !IgnoreWalls by solid blocks)
 * 
 * Dragger beams accelerate the selected player every tick towards their center. The length of the speed vector, which
 * is added to that of the player, depends only on the strength of the dragger and is between 1 and 3 units long. If
 * the player is in the center of the dragger, it will not accelerate.
 */
class CDraggerBeam : public CEntity
{
	CDragger *m_pDragger;
	float m_Strength;
	bool m_IgnoreWalls;
	int m_ForClientId;
	int m_EvalTick;
	bool m_Active;

public:
	CDraggerBeam(CGameWorld *pGameWorld, CDragger *pDragger, vec2 Pos, float Strength, bool IgnoreWalls, int ForClientId, int Layer, int Number);

	void SetPos(vec2 Pos);

	void Reset() override;
	void Tick() override;
	void Snap(int SnappingClient) override;
	void SwapClients(int Client1, int Client2) override;
	ESaveResult BlocksSave(int ClientId) override;
};

#endif // GAME_SERVER_ENTITIES_DRAGGER_BEAM_H
