/*
 * Decompiled with CFR 0.152.
 */
package org.python.antlr;

import java.math.BigInteger;
import java.util.ArrayList;
import org.python.antlr.ErrorHandler;
import org.python.antlr.PythonParser;
import org.python.antlr.PythonTree;
import org.python.antlr.ast.Attribute;
import org.python.antlr.ast.BinOp;
import org.python.antlr.ast.BoolOp;
import org.python.antlr.ast.Call;
import org.python.antlr.ast.Context;
import org.python.antlr.ast.ExtSlice;
import org.python.antlr.ast.For;
import org.python.antlr.ast.FunctionDef;
import org.python.antlr.ast.GeneratorExp;
import org.python.antlr.ast.IfExp;
import org.python.antlr.ast.Index;
import org.python.antlr.ast.Lambda;
import org.python.antlr.ast.List;
import org.python.antlr.ast.ListComp;
import org.python.antlr.ast.Name;
import org.python.antlr.ast.Num;
import org.python.antlr.ast.Repr;
import org.python.antlr.ast.Slice;
import org.python.antlr.ast.Str;
import org.python.antlr.ast.TryExcept;
import org.python.antlr.ast.TryFinally;
import org.python.antlr.ast.Tuple;
import org.python.antlr.ast.UnaryOp;
import org.python.antlr.ast.While;
import org.python.antlr.ast.Yield;
import org.python.antlr.ast.alias;
import org.python.antlr.ast.arguments;
import org.python.antlr.ast.boolopType;
import org.python.antlr.ast.cmpopType;
import org.python.antlr.ast.expr_contextType;
import org.python.antlr.ast.keyword;
import org.python.antlr.ast.operatorType;
import org.python.antlr.ast.unaryopType;
import org.python.antlr.base.excepthandler;
import org.python.antlr.base.expr;
import org.python.antlr.base.slice;
import org.python.antlr.base.stmt;
import org.python.antlr.runtime.Token;
import org.python.core.Py;
import org.python.core.PyComplex;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyString;
import org.python.core.PyUnicode;
import org.python.core.codecs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrammarActions {
    private ErrorHandler errorHandler = null;

    public void setErrorHandler(ErrorHandler eh) {
        this.errorHandler = eh;
    }

    String makeFromText(java.util.List dots, java.util.List<Name> names) {
        StringBuilder d = new StringBuilder();
        d.append(PythonTree.dottedNameListToString(names));
        return d.toString();
    }

    java.util.List<Name> makeModuleNameNode(java.util.List dots, java.util.List<Name> names) {
        ArrayList<Name> result = new ArrayList<Name>();
        if (dots != null) {
            for (Object o : dots) {
                Token tok = (Token)o;
                result.add(new Name(tok, tok.getText(), expr_contextType.Load));
            }
        }
        if (null != names) {
            result.addAll(names);
        }
        return result;
    }

    java.util.List<Name> makeDottedName(Token top, java.util.List<PythonTree> attrs) {
        ArrayList<Name> result = new ArrayList<Name>();
        result.add(new Name(top, top.getText(), expr_contextType.Load));
        if (attrs != null) {
            for (PythonTree attr : attrs) {
                Token token = attr.getToken();
                result.add(new Name(token, token.getText(), expr_contextType.Load));
            }
        }
        return result;
    }

    int makeLevel(java.util.List lev) {
        if (lev == null) {
            return 0;
        }
        return lev.size();
    }

    java.util.List<alias> makeStarAlias(Token t) {
        ArrayList<alias> result = new ArrayList<alias>();
        result.add(new alias(t, "*", null));
        return result;
    }

    java.util.List<alias> makeAliases(java.util.List<alias> atypes) {
        if (atypes == null) {
            return new ArrayList<alias>();
        }
        return atypes;
    }

    java.util.List<expr> makeBases(expr etype) {
        ArrayList<expr> result = new ArrayList<expr>();
        if (etype != null) {
            if (etype instanceof Tuple) {
                return ((Tuple)etype).getInternalElts();
            }
            result.add(etype);
        }
        return result;
    }

    java.util.List<String> makeNames(java.util.List names) {
        ArrayList<String> s = new ArrayList<String>();
        for (int i = 0; i < names.size(); ++i) {
            s.add(((Token)names.get(i)).getText());
        }
        return s;
    }

    Name makeNameNode(Token t) {
        if (t == null) {
            return null;
        }
        return new Name(t, t.getText(), expr_contextType.Load);
    }

    java.util.List<Name> makeNameNodes(java.util.List<Token> names) {
        ArrayList<Name> s = new ArrayList<Name>();
        for (int i = 0; i < names.size(); ++i) {
            s.add(this.makeNameNode(names.get(i)));
        }
        return s;
    }

    void errorGenExpNotSoleArg(PythonTree t) {
        this.errorHandler.error("Generator expression must be parenthesized if not sole argument", t);
    }

    expr castExpr(Object o) {
        if (o instanceof expr) {
            return (expr)o;
        }
        if (o instanceof PythonTree) {
            return this.errorHandler.errorExpr((PythonTree)o);
        }
        return null;
    }

    java.util.List<expr> castExprs(java.util.List exprs) {
        return this.castExprs(exprs, 0);
    }

    java.util.List<expr> castExprs(java.util.List exprs, int start) {
        ArrayList<expr> result = new ArrayList<expr>();
        if (exprs != null) {
            for (int i = start; i < exprs.size(); ++i) {
                Object o = exprs.get(i);
                if (o instanceof expr) {
                    result.add((expr)o);
                    continue;
                }
                if (!(o instanceof PythonParser.test_return)) continue;
                result.add((expr)((PythonParser.test_return)o).tree);
            }
        }
        return result;
    }

    java.util.List<stmt> makeElse(java.util.List elseSuite, PythonTree elif) {
        if (elseSuite != null) {
            return this.castStmts(elseSuite);
        }
        if (elif == null) {
            return new ArrayList<stmt>();
        }
        ArrayList<stmt> s = new ArrayList<stmt>();
        s.add(this.castStmt(elif));
        return s;
    }

    stmt castStmt(Object o) {
        if (o instanceof stmt) {
            return (stmt)o;
        }
        if (o instanceof PythonParser.stmt_return) {
            return (stmt)((PythonParser.stmt_return)o).tree;
        }
        if (o instanceof PythonTree) {
            return this.errorHandler.errorStmt((PythonTree)o);
        }
        return null;
    }

    java.util.List<stmt> castStmts(PythonTree t) {
        stmt s = (stmt)t;
        ArrayList<stmt> stmts = new ArrayList<stmt>();
        stmts.add(s);
        return stmts;
    }

    java.util.List<stmt> castStmts(java.util.List stmts) {
        if (stmts != null) {
            ArrayList<stmt> result = new ArrayList<stmt>();
            for (Object o : stmts) {
                result.add(this.castStmt(o));
            }
            return result;
        }
        return new ArrayList<stmt>();
    }

    expr makeDottedAttr(Token nameToken, java.util.List attrs) {
        expr current = new Name(nameToken, nameToken.getText(), expr_contextType.Load);
        for (Object o : attrs) {
            Token t = (Token)o;
            current = new Attribute(t, current, this.cantBeNoneName(t), expr_contextType.Load);
        }
        return current;
    }

    stmt makeWhile(Token t, expr test, java.util.List body, java.util.List orelse) {
        if (test == null) {
            return this.errorHandler.errorStmt(new PythonTree(t));
        }
        java.util.List<stmt> o = this.castStmts(orelse);
        java.util.List<stmt> b = this.castStmts(body);
        return new While(t, test, b, o);
    }

    stmt makeFor(Token t, expr target, expr iter, java.util.List body, java.util.List orelse) {
        if (target == null || iter == null) {
            return this.errorHandler.errorStmt(new PythonTree(t));
        }
        this.cantBeNone(target);
        java.util.List<stmt> o = this.castStmts(orelse);
        java.util.List<stmt> b = this.castStmts(body);
        return new For(t, target, iter, b, o);
    }

    stmt makeTryExcept(Token t, java.util.List body, java.util.List<excepthandler> handlers, java.util.List orelse, java.util.List finBody) {
        java.util.List<stmt> b = this.castStmts(body);
        java.util.List<excepthandler> e = handlers;
        java.util.List<stmt> o = this.castStmts(orelse);
        TryExcept te = new TryExcept(t, b, e, o);
        if (finBody == null) {
            return te;
        }
        java.util.List<stmt> f = this.castStmts(finBody);
        ArrayList<stmt> mainBody = new ArrayList<stmt>();
        mainBody.add(te);
        return new TryFinally(t, mainBody, f);
    }

    TryFinally makeTryFinally(Token t, java.util.List body, java.util.List finBody) {
        java.util.List<stmt> b = this.castStmts(body);
        java.util.List<stmt> f = this.castStmts(finBody);
        return new TryFinally(t, b, f);
    }

    stmt makeFuncdef(Token t, Token nameToken, arguments args, java.util.List funcStatements, java.util.List decorators) {
        if (nameToken == null) {
            return this.errorHandler.errorStmt(new PythonTree(t));
        }
        Name n = this.cantBeNoneName(nameToken);
        arguments a = args != null ? args : new arguments(t, new ArrayList<expr>(), (Name)null, null, new ArrayList<expr>());
        java.util.List<stmt> s = this.castStmts(funcStatements);
        java.util.List<expr> d = this.castExprs(decorators);
        return new FunctionDef(t, n, a, s, d);
    }

    java.util.List<expr> makeAssignTargets(expr lhs, java.util.List rhs) {
        ArrayList<expr> e = new ArrayList<expr>();
        this.checkAssign(lhs);
        e.add(lhs);
        for (int i = 0; i < rhs.size() - 1; ++i) {
            expr r = this.castExpr(rhs.get(i));
            this.checkAssign(r);
            e.add(r);
        }
        return e;
    }

    expr makeAssignValue(java.util.List rhs) {
        expr value = this.castExpr(rhs.get(rhs.size() - 1));
        this.recurseSetContext(value, expr_contextType.Load);
        return value;
    }

    void recurseSetContext(PythonTree tree, expr_contextType context) {
        if (tree instanceof Context) {
            ((Context)((Object)tree)).setContext(context);
        }
        if (tree instanceof GeneratorExp) {
            GeneratorExp g = (GeneratorExp)tree;
            this.recurseSetContext(g.getInternalElt(), context);
        } else if (tree instanceof ListComp) {
            ListComp lc = (ListComp)tree;
            this.recurseSetContext(lc.getInternalElt(), context);
        } else if (!(tree instanceof ListComp)) {
            for (int i = 0; i < tree.getChildCount(); ++i) {
                this.recurseSetContext(tree.getChild(i), context);
            }
        }
    }

    arguments makeArgumentsType(Token t, java.util.List params, Token snameToken, Token knameToken, java.util.List defaults) {
        java.util.List<expr> p = this.castExprs(params);
        java.util.List<expr> d = this.castExprs(defaults);
        Name s = snameToken == null ? null : this.cantBeNoneName(snameToken);
        Name k = knameToken == null ? null : this.cantBeNoneName(knameToken);
        return new arguments(t, p, s, k, d);
    }

    java.util.List<expr> extractArgs(java.util.List args) {
        return this.castExprs(args);
    }

    java.util.List<keyword> makeKeywords(java.util.List args) {
        ArrayList<keyword> k = new ArrayList<keyword>();
        if (args != null) {
            for (int i = 0; i < args.size(); ++i) {
                java.util.List e = (java.util.List)args.get(i);
                this.checkAssign(this.castExpr(e.get(0)));
                if (e.get(0) instanceof Name) {
                    Name arg = (Name)e.get(0);
                    k.add(new keyword(arg, arg.getInternalId(), this.castExpr(e.get(1))));
                    continue;
                }
                this.errorHandler.error("keyword must be a name", (PythonTree)e.get(0));
            }
        }
        return k;
    }

    Object makeFloat(Token t) {
        return Py.newFloat(Double.valueOf(t.getText()));
    }

    Object makeComplex(Token t) {
        String s = t.getText();
        s = s.substring(0, s.length() - 1);
        return Py.newImaginary(Double.valueOf(s));
    }

    Object makeInt(Token t) {
        int i;
        String s = t.getText();
        int radix = 10;
        if (s.startsWith("0x") || s.startsWith("0X")) {
            radix = 16;
            s = s.substring(2, s.length());
        } else if (s.startsWith("0")) {
            radix = 8;
        }
        if (s.endsWith("L") || s.endsWith("l")) {
            s = s.substring(0, s.length() - 1);
            return Py.newLong(new BigInteger(s, radix));
        }
        int ndigits = s.length();
        for (i = 0; i < ndigits && s.charAt(i) == '0'; ++i) {
        }
        if (ndigits - i > 11) {
            return Py.newLong(new BigInteger(s, radix));
        }
        long l = Long.valueOf(s, radix);
        if (l > 0xFFFFFFFFL || l > Integer.MAX_VALUE) {
            return Py.newLong(new BigInteger(s, radix));
        }
        return Py.newInteger((int)l);
    }

    PyString extractStrings(java.util.List s, String encoding) {
        boolean ustring = false;
        Token last2 = null;
        StringBuffer sb = new StringBuffer();
        for (Token last2 : s) {
            StringPair sp = this.extractString(last2, encoding);
            if (sp.isUnicode()) {
                ustring = true;
            }
            sb.append(sp.getString());
        }
        if (ustring) {
            return new PyUnicode(sb.toString());
        }
        return new PyString(sb.toString());
    }

    /*
     * WARNING - void declaration
     */
    StringPair extractString(Token t, String encoding) {
        void end;
        String string = t.getText();
        char quoteChar = string.charAt(0);
        int start = 0;
        boolean bl = false;
        if (quoteChar == 'u' || quoteChar == 'U') {
            bl = true;
            ++start;
        }
        quoteChar = string.charAt(start);
        boolean ustring = false;
        if (quoteChar == 'r' || quoteChar == 'R') {
            ustring = true;
            ++start;
        }
        int raw = 3;
        if (string.length() - start == 2) {
            raw = 1;
        }
        if (string.charAt(start) != string.charAt(start + 1)) {
            raw = 1;
        }
        start = raw + start;
        int quotes = string.length() - raw;
        if (end == false && encoding != null) {
            string = new PyUnicode(string.substring(start, quotes)).encode(encoding);
            if (!ustring) {
                string = PyString.decode_UnicodeEscape(string, 0, string.length(), "strict", (boolean)end);
            }
        } else if (ustring) {
            string = string.substring(start, quotes);
            if (end != false) {
                string = codecs.PyUnicode_DecodeRawUnicodeEscape(string, "strict");
            }
        } else {
            string = PyString.decode_UnicodeEscape(string, start, quotes, "strict", (boolean)end);
        }
        return new StringPair(string, (boolean)end);
    }

    Token extractStringToken(java.util.List s) {
        return (Token)s.get(0);
    }

    expr makeCall(Token t, expr func) {
        return this.makeCall(t, func, null, null, null, null);
    }

    expr makeCall(Token t, expr func, java.util.List args, java.util.List keywords, expr starargs, expr kwargs) {
        if (func == null) {
            return this.errorHandler.errorExpr(new PythonTree(t));
        }
        java.util.List<keyword> k = this.makeKeywords(keywords);
        java.util.List<expr> a = this.castExprs(args);
        return new Call(t, func, a, k, starargs, kwargs);
    }

    expr negate(Token t, expr o) {
        return this.negate(new PythonTree(t), o);
    }

    expr negate(PythonTree t, expr o) {
        if (o instanceof Num) {
            double d;
            Num num = (Num)o;
            if (num.getInternalN() instanceof PyInteger) {
                int v = ((PyInteger)num.getInternalN()).getValue();
                if (v >= 0) {
                    num.setN(new PyInteger(-v));
                    return num;
                }
            } else if (num.getInternalN() instanceof PyLong) {
                BigInteger v = ((PyLong)num.getInternalN()).getValue();
                if (v.compareTo(BigInteger.ZERO) == 1) {
                    num.setN(new PyLong(v.negate()));
                    return num;
                }
            } else if (num.getInternalN() instanceof PyFloat) {
                double d2 = ((PyFloat)num.getInternalN()).getValue();
                if (d2 >= 0.0) {
                    num.setN(new PyFloat(-d2));
                    return num;
                }
            } else if (num.getInternalN() instanceof PyComplex && (d = ((PyComplex)num.getInternalN()).imag) >= 0.0) {
                num.setN(new PyComplex(0.0, -d));
                return num;
            }
        }
        return new UnaryOp(t, unaryopType.USub, o);
    }

    String cantBeNone(Token t) {
        if (t == null || t.getText().equals("None")) {
            this.errorHandler.error("can't be None", new PythonTree(t));
        }
        return t.getText();
    }

    Name cantBeNoneName(Token t) {
        if (t == null || t.getText().equals("None")) {
            this.errorHandler.error("can't be None", new PythonTree(t));
        }
        return new Name(t, t.getText(), expr_contextType.Load);
    }

    void cantBeNone(PythonTree e) {
        if (e.getText().equals("None")) {
            this.errorHandler.error("can't be None", e);
        }
    }

    void checkAssign(expr e) {
        block4: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block10: {
                                        block9: {
                                            block8: {
                                                block7: {
                                                    block6: {
                                                        block5: {
                                                            block3: {
                                                                if (!(e instanceof Name) || !((Name)e).getInternalId().equals("None")) break block3;
                                                                this.errorHandler.error("assignment to None", e);
                                                                break block4;
                                                            }
                                                            if (!(e instanceof GeneratorExp)) break block5;
                                                            this.errorHandler.error("can't assign to generator expression", e);
                                                            break block4;
                                                        }
                                                        if (!(e instanceof Num)) break block6;
                                                        this.errorHandler.error("can't assign to number", e);
                                                        break block4;
                                                    }
                                                    if (!(e instanceof Str)) break block7;
                                                    this.errorHandler.error("can't assign to string", e);
                                                    break block4;
                                                }
                                                if (!(e instanceof Yield)) break block8;
                                                this.errorHandler.error("can't assign to yield expression", e);
                                                break block4;
                                            }
                                            if (!(e instanceof BinOp)) break block9;
                                            this.errorHandler.error("can't assign to operator", e);
                                            break block4;
                                        }
                                        if (!(e instanceof BoolOp)) break block10;
                                        this.errorHandler.error("can't assign to operator", e);
                                        break block4;
                                    }
                                    if (!(e instanceof Lambda)) break block11;
                                    this.errorHandler.error("can't assign to lambda", e);
                                    break block4;
                                }
                                if (!(e instanceof Call)) break block12;
                                this.errorHandler.error("can't assign to function call", e);
                                break block4;
                            }
                            if (!(e instanceof Repr)) break block13;
                            this.errorHandler.error("can't assign to repr", e);
                            break block4;
                        }
                        if (!(e instanceof IfExp)) break block14;
                        this.errorHandler.error("can't assign to conditional expression", e);
                        break block4;
                    }
                    if (!(e instanceof ListComp)) break block15;
                    this.errorHandler.error("can't assign to list comprehension", e);
                    break block4;
                }
                if (!(e instanceof Tuple)) break block16;
                java.util.List<expr> elts = ((Tuple)e).getInternalElts();
                if (elts.size() == 0) {
                    this.errorHandler.error("can't assign to ()", e);
                }
                for (int i = 0; i < elts.size(); ++i) {
                    this.checkAssign(elts.get(i));
                }
                break block4;
            }
            if (!(e instanceof List)) break block4;
            java.util.List<expr> elts = ((List)e).getInternalElts();
            for (int i = 0; i < elts.size(); ++i) {
                this.checkAssign(elts.get(i));
            }
        }
    }

    java.util.List<expr> makeDeleteList(java.util.List deletes) {
        java.util.List<expr> exprs = this.castExprs(deletes);
        for (expr e : exprs) {
            this.checkDelete(e);
        }
        return exprs;
    }

    void checkDelete(expr e) {
        block4: {
            block7: {
                block6: {
                    block5: {
                        block3: {
                            if (!(e instanceof Call)) break block3;
                            this.errorHandler.error("can't delete function call", e);
                            break block4;
                        }
                        if (!(e instanceof Num)) break block5;
                        this.errorHandler.error("can't delete number", e);
                        break block4;
                    }
                    if (!(e instanceof Str)) break block6;
                    this.errorHandler.error("can't delete string", e);
                    break block4;
                }
                if (!(e instanceof Tuple)) break block7;
                java.util.List<expr> elts = ((Tuple)e).getInternalElts();
                if (elts.size() == 0) {
                    this.errorHandler.error("can't delete ()", e);
                }
                for (int i = 0; i < elts.size(); ++i) {
                    this.checkDelete(elts.get(i));
                }
                break block4;
            }
            if (!(e instanceof List)) break block4;
            java.util.List<expr> elts = ((List)e).getInternalElts();
            for (int i = 0; i < elts.size(); ++i) {
                this.checkDelete(elts.get(i));
            }
        }
    }

    slice makeSubscript(PythonTree lower, Token colon, PythonTree upper, PythonTree sliceop) {
        boolean isSlice = false;
        expr s = null;
        expr e = null;
        expr o = null;
        if (lower != null) {
            s = this.castExpr(lower);
        }
        if (colon != null) {
            isSlice = true;
            if (upper != null) {
                e = this.castExpr(upper);
            }
        }
        if (sliceop != null) {
            isSlice = true;
            o = sliceop != null ? this.castExpr(sliceop) : new Name(sliceop, "None", expr_contextType.Load);
        }
        PythonTree tok = lower;
        if (lower == null) {
            tok = new PythonTree(colon);
        }
        if (isSlice) {
            return new Slice(tok, s, e, o);
        }
        return new Index(tok, s);
    }

    java.util.List<cmpopType> makeCmpOps(java.util.List cmps) {
        ArrayList<cmpopType> result = new ArrayList<cmpopType>();
        if (cmps != null) {
            for (Object o : cmps) {
                result.add((cmpopType)((Object)o));
            }
        }
        return result;
    }

    BoolOp makeBoolOp(Token t, PythonTree left, boolopType op, java.util.List right) {
        ArrayList<PythonTree> values = new ArrayList<PythonTree>();
        values.add(left);
        values.addAll(right);
        return new BoolOp(t, op, this.castExprs(values));
    }

    BinOp makeBinOp(Token t, PythonTree left, operatorType op, java.util.List rights) {
        BinOp current = new BinOp(t, this.castExpr(left), op, this.castExpr(rights.get(0)));
        for (int i = 1; i < rights.size(); ++i) {
            expr right = this.castExpr(rights.get(i));
            current = new BinOp(left, (expr)current, op, right);
        }
        return current;
    }

    BinOp makeBinOp(Token t, PythonTree left, java.util.List ops, java.util.List rights, java.util.List toks) {
        BinOp current = new BinOp(t, this.castExpr(left), (operatorType)((Object)ops.get(0)), this.castExpr(rights.get(0)));
        for (int i = 1; i < rights.size(); ++i) {
            expr right = this.castExpr(rights.get(i));
            operatorType op = (operatorType)((Object)ops.get(i));
            current = new BinOp((Token)toks.get(i), (expr)current, op, right);
        }
        return current;
    }

    java.util.List<slice> castSlices(java.util.List slices) {
        ArrayList<slice> result = new ArrayList<slice>();
        if (slices != null) {
            for (Object o : slices) {
                result.add(this.castSlice(o));
            }
        }
        return result;
    }

    slice castSlice(Object o) {
        if (o instanceof slice) {
            return (slice)o;
        }
        return this.errorHandler.errorSlice((PythonTree)o);
    }

    slice makeSliceType(Token begin, Token c1, Token c2, java.util.List sltypes) {
        boolean isTuple = false;
        if (c1 != null || c2 != null) {
            isTuple = true;
        }
        slice s = null;
        boolean extslice = false;
        if (isTuple) {
            ArrayList<expr> arrayList = new ArrayList<expr>();
            for (Object i$ : sltypes) {
                if (i$ instanceof Index) {
                    Index o = (Index)i$;
                    arrayList.add(o.getInternalValue());
                    continue;
                }
                extslice = true;
                break;
            }
            if (!extslice) {
                Tuple etypes = new Tuple(begin, arrayList, expr_contextType.Load);
                s = new Index(begin, (expr)etypes);
            }
        } else if (sltypes.size() == 1) {
            s = this.castSlice(sltypes.get(0));
        } else if (sltypes.size() != 0) {
            extslice = true;
        }
        if (extslice) {
            java.util.List<slice> list = this.castSlices(sltypes);
            s = new ExtSlice(begin, list);
        }
        return s;
    }

    class StringPair {
        private String s;
        private boolean unicode;

        StringPair(String s, boolean unicode) {
            this.s = s;
            this.unicode = unicode;
        }

        String getString() {
            return this.s;
        }

        boolean isUnicode() {
            return this.unicode;
        }
    }
}

