/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.model;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.model.Binding;
import com.xmlcalabash.model.EmptyBinding;
import com.xmlcalabash.model.EndPoint;
import com.xmlcalabash.model.Environment;
import com.xmlcalabash.model.Input;
import com.xmlcalabash.model.Output;
import com.xmlcalabash.model.PipeNameBinding;
import com.xmlcalabash.model.Port;
import com.xmlcalabash.model.SourceArtifact;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.model.Variable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;

public class CompoundStep
extends Step {
    private Environment inheritedEnv = null;
    private HashSet<QName> variablesSeen = new HashSet();
    private Vector<Variable> variables = new Vector();
    private boolean augmented = false;

    public CompoundStep(XProcRuntime xProcRuntime, XdmNode xdmNode, QName qName, String string) {
        super(xProcRuntime, xdmNode, qName, string);
    }

    @Override
    public boolean containsStep(String string) {
        for (Step step : this.subpipeline) {
            if (!string.equals(step.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addVariable(Variable variable) {
        if (this.variablesSeen.contains(variable.getName()) || this.getOption(variable.getName()) != null) {
            throw XProcException.staticError(4, "Duplicate variable/option name: " + variable.getName());
        }
        this.variablesSeen.add(variable.getName());
        this.variables.add(variable);
    }

    @Override
    public Collection<Variable> getVariables() {
        return this.variables;
    }

    @Override
    protected void setEnvironment(Environment environment) {
        Environment environment2 = new Environment(environment);
        for (Object object : this.subpipeline) {
            environment2.addStep((Step)object);
        }
        this.inheritedEnv = new Environment(environment2);
        this.patchEnvironment(environment2);
        super.setEnvironment(environment2);
        Object object = null;
        for (Step step : this.subpipeline) {
            Environment environment3 = new Environment(environment2);
            if (object != null) {
                environment3.setDefaultReadablePort(((Step)object).getDefaultOutput());
            }
            object = step;
            step.setEnvironment(environment3);
        }
    }

    @Override
    public void augment() {
        if (this.augmented) {
            return;
        }
        this.augmented = true;
        Vector<Step> vector = new Vector<Step>();
        for (Step sourceArtifact : this.subpipeline) {
            vector.add(sourceArtifact);
        }
        for (Step step : vector) {
            step.augment();
        }
        super.augment();
        if (!XProcConstants.p_declare_step.equals((Object)this.getType()) && (this.outputs().size() == 0 || this.outputs().size() == 1 && "#current".equals(this.outputs().get(0).getPort()))) {
            Step step = (Step)this.subpipeline.get(this.subpipeline.size() - 1);
            Output output = step.getPrimaryOutput();
            String string = "!result";
            if (XProcConstants.p_viewport.equals((Object)this.node.getNodeName())) {
                string = "result";
            }
            if (output != null) {
                Output output2 = new Output(this.runtime, this.node);
                output2.setPort(string);
                output2.setPrimary(true);
                output2.setSequence(output.getSequence() || XProcConstants.p_for_each.equals((Object)this.getType()));
                this.addOutput(output2);
                Input input = new Input(this.runtime, this.node);
                input.setPort("|" + string);
                input.setSequence(output.getSequence());
                input.setPrimary(true);
                this.addInput(input);
            }
        }
    }

    @Override
    protected void augmentOptions() {
    }

    @Override
    protected void augmentIO() {
        Port port;
        for (Output port2 : this.outputs) {
            if ("#current".equals(port2.getPort()) || (port = this.getInput("|" + port2.getPort())) != null) continue;
            port = new Input(this.runtime, port2.getNode());
            port.setPort("|" + port2.getPort());
            port.setSequence(true);
            port.setPrimary(port2.getPrimary());
            this.addInput((Input)port);
        }
        for (Input input : this.inputs()) {
            if (input.getPort().startsWith("|") || input.getPort().startsWith("#")) continue;
            port = new Output(this.runtime, input.getNode());
            port.setPort(input.getPort() + "|");
            port.setSequence(true);
            port.setPrimary(input.getPrimary());
            this.addOutput((Output)port);
        }
    }

    @Override
    public Output getOutput(String string) {
        Output output = super.getOutput(string);
        if (output != null) {
            return output;
        }
        for (Input input : this.inputs) {
            if (!string.equals(input.getPort())) continue;
            return super.getOutput(string + "|");
        }
        return null;
    }

    @Override
    public void checkVariables() {
        for (Variable variable : this.variables) {
            for (Binding binding : variable.getBinding()) {
                if (binding.getBindingType() != 1) continue;
                PipeNameBinding pipeNameBinding = (PipeNameBinding)binding;
                String string = pipeNameBinding.getStep();
                boolean bl = false;
                Step step = this;
                while (step != null && !bl) {
                    bl = string.equals(step.getName());
                    step = step.parent;
                }
                if (bl) continue;
                this.runtime.finest(null, this.node, this.getName() + " variable depends on " + pipeNameBinding.getStep());
                this.addDependency(pipeNameBinding.getStep());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean checkBinding(Input input) {
        Object object;
        SourceArtifact sourceArtifact;
        boolean bl = true;
        if (input.getBinding().size() == 0) {
            Object object2;
            Object object3 = this.inheritedEnv.getDefaultReadablePort();
            Object object4 = null;
            if (XProcConstants.p_pipeline.equals((Object)this.getType())) {
                sourceArtifact = this.declaration;
                object = ((Step)sourceArtifact).inputs().iterator();
                while (object.hasNext()) {
                    object2 = object.next();
                    if (!((Port)object2).getPort().equals(input.getPort())) continue;
                    Vector<Binding> vector = ((EndPoint)object2).getBinding();
                }
            }
            if (input.getPort().startsWith("|") && this.subpipeline.size() > 0) {
                sourceArtifact = (Step)this.subpipeline.get(this.subpipeline.size() - 1);
                object3 = ((Step)sourceArtifact).getDefaultOutput();
            }
            sourceArtifact = null;
            if (input.getPort().startsWith("|") && this.parent != null) {
                object = input.getPort().substring(1);
                sourceArtifact = this.getOutput((String)object);
            }
            if (sourceArtifact != null && ((EndPoint)sourceArtifact).getBinding().size() > 0) {
                object = ((EndPoint)sourceArtifact).getBinding().iterator();
                while (object.hasNext()) {
                    object2 = (Binding)object.next();
                    input.addBinding((Binding)object2);
                }
                ((EndPoint)sourceArtifact).clearBindings();
            } else if (object3 == null) {
                void var4_5;
                if (var4_5 != null) {
                    object = var4_5.iterator();
                    while (object.hasNext()) {
                        object2 = (Binding)object.next();
                        input.addBinding((Binding)object2);
                    }
                } else if (input.getParameterInput()) {
                    object = new EmptyBinding();
                    input.addBinding((Binding)object);
                } else {
                    bl = false;
                    this.error("Input " + input.getPort() + " unbound on " + this.getType() + " step named " + this.getName() + " and no default binding available.", XProcConstants.staticError(32));
                }
            } else {
                object = ((EndPoint)object3).getStep().getName();
                object2 = ((Port)object3).getPort();
                PipeNameBinding pipeNameBinding = new PipeNameBinding(this.runtime, this.node);
                pipeNameBinding.setStep((String)object);
                pipeNameBinding.setPort((String)object2);
                input.addBinding(pipeNameBinding);
            }
        }
        for (Binding binding : input.getBinding()) {
            if (binding.getBindingType() != 1 || (object = this.env.readablePort(((PipeNameBinding)(sourceArtifact = (PipeNameBinding)binding)).getStep(), ((PipeNameBinding)sourceArtifact).getPort())) != null) continue;
            this.error("Unreadable port: " + ((PipeNameBinding)sourceArtifact).getPort() + " on " + ((PipeNameBinding)sourceArtifact).getStep(), XProcException.err_E0001);
            bl = false;
        }
        return bl;
    }

    public void checkPrimaryIO() {
        this.checkPrimaryInput(false);
        this.checkPrimaryInput(true);
        this.checkPrimaryOutput();
        int n = 0;
        int n2 = 0;
        Output output = null;
        Port port = null;
        for (Output output2 : this.outputs()) {
            if (output2.getPort().startsWith("#")) continue;
            ++n;
            port = output2;
            if (!output2.getPrimary()) continue;
            ++n2;
            output = output2;
        }
        if (n2 > 1) {
            throw XProcException.staticError(30);
        }
        if (n == 1 && (port.getPrimary() || !port.getPrimarySet())) {
            port.setPrimary(true);
        }
    }

    private void checkPrimaryInput(boolean bl) {
        int n = 0;
        int n2 = 0;
        Port port = null;
        Input input = null;
        for (Input input2 : this.inputs()) {
            if (input2.getPort().startsWith("|")) continue;
            ++n;
            if (input2.getParameterInput() != bl) continue;
            if (input2.getPrimary()) {
                ++n2;
                if (input == null) {
                    input = input2;
                }
            }
            if (port != null || input2.getPrimarySet()) continue;
            port = input2;
        }
        if (n2 > 1) {
            throw XProcException.staticError(30);
        }
        if (n == 1 && input == null && port != null && (port.getPrimary() || !port.getPrimarySet())) {
            port.setPrimary(true);
        }
    }

    private void checkPrimaryOutput() {
        int n = 0;
        int n2 = 0;
        Port port = null;
        Output output = null;
        for (Output output2 : this.outputs()) {
            if (output2.getPort().endsWith("|")) continue;
            ++n;
            if (output2.getPrimary()) {
                ++n2;
                if (output == null) {
                    output = output2;
                }
            }
            if (port != null || output2.getPrimarySet()) continue;
            port = output2;
        }
        if (n2 > 1) {
            throw XProcException.staticError(30);
        }
        if (n == 1 && output == null && port != null && (port.getPrimary() || !port.getPrimarySet())) {
            port.setPrimary(true);
        }
    }

    @Override
    public boolean valid() {
        boolean bl = this.validParams();
        bl = bl && this.validOptions();
        boolean bl2 = bl = bl && this.validBindings();
        if (this.env.countVisibleSteps(this.getName()) > 1) {
            this.error("Duplicate step name: " + this.getName(), XProcConstants.staticError(2));
            bl = false;
        }
        for (Step step : this.subpipeline) {
            boolean bl3 = step.valid();
            bl = bl && bl3;
        }
        bl = bl && this.validOutputBinding();
        return bl;
    }

    protected boolean validOutputBinding() {
        Step step;
        Output output;
        boolean bl = true;
        if (this.subpipeline.size() > 0 && (output = (step = (Step)this.subpipeline.get(this.subpipeline.size() - 1)).getDefaultOutput()) != null) {
            bl = false;
            for (SourceArtifact sourceArtifact : this.inputs) {
                if (!((Port)sourceArtifact).getPort().startsWith("|")) continue;
                for (Binding sourceArtifact2 : ((EndPoint)sourceArtifact).getBinding()) {
                    if (sourceArtifact2.getBindingType() != 1) continue;
                    PipeNameBinding pipeNameBinding = (PipeNameBinding)sourceArtifact2;
                    bl = bl || pipeNameBinding.getStep().equals(step.getName()) && output.getPort().equals(pipeNameBinding.getPort());
                }
            }
            if (!bl) {
                for (int i = 0; i < this.subpipeline.size() - 1; ++i) {
                    SourceArtifact sourceArtifact;
                    sourceArtifact = (Step)this.subpipeline.get(i);
                    for (Input input : ((Step)sourceArtifact).inputs()) {
                        for (Binding binding : input.getBinding()) {
                            if (binding.getBindingType() != 1) continue;
                            PipeNameBinding pipeNameBinding = (PipeNameBinding)binding;
                            bl = bl || pipeNameBinding.getStep().equals(step.getName()) && output.getPort().equals(pipeNameBinding.getPort());
                        }
                    }
                }
            }
            if (!bl) {
                this.error("Unbound primary output port on last step: " + this.getName(), XProcConstants.staticError(6));
            }
        }
        return bl;
    }

    @Override
    protected boolean validBindings() {
        boolean bl = super.validBindings();
        for (Variable variable : this.getVariables()) {
            if (this.checkOptionBinding(variable, true)) continue;
            bl = false;
        }
        return bl;
    }

    @Override
    protected void checkForBindings(HashSet<Output> hashSet) {
        for (Input sourceArtifact : this.inputs()) {
            for (Binding binding : sourceArtifact.bindings) {
                PipeNameBinding pipeNameBinding;
                Output output;
                if (binding.getBindingType() != 1 || !hashSet.contains(output = this.env.readablePort((pipeNameBinding = (PipeNameBinding)binding).getStep(), pipeNameBinding.getPort()))) continue;
                hashSet.remove(output);
            }
        }
        for (Step step : this.subpipeline) {
            step.checkForBindings(hashSet);
        }
    }
}

