// -*- tab-width: 8; indent-tabs-mode: nil -*-
// vi: set ts=8 sw=2 et sts=2:
#ifndef DUNE_REFINED_P0_LOCALCOEFFICIENTS_HH
#define DUNE_REFINED_P0_LOCALCOEFFICIENTS_HH

#include <cstddef>
#include <iostream>
#include <vector>

#include <dune/localfunctions/common/localkey.hh>

namespace Dune 
{

  /**@ingroup LocalLayoutImplementation
     \brief Layout map for RefinedP0 elements

     \nosubgrouping
     \implements Dune::LocalCoefficientsVirtualImp
  */
  template<unsigned int k>
  class RefinedP0LocalCoefficients
  {
      // 2 to the k-th power
      enum {N = 1<<k};

  public:
    RefinedP0LocalCoefficients () :
      localKeys_(N)
    {
      // All functions are associated to the element
      for (int i = 0; i < N; ++i) 
        localKeys_[i] = LocalKey(0,0,i);
    }

    //! number of coefficients
    std::size_t size () const
    {
      return N;
    }

    //! get i'th index
    const LocalKey& localKey (std::size_t i) const
    {
      return localKeys_[i];
    } 

  private:
    std::vector<LocalKey> localKeys_;

  };

}

#endif
