/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.util.Platform;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Hashtable;

public class EmbmenuFrame
extends Frame
implements MouseListener {
    protected Hashtable embeddedPopup;
    protected Panel embeddedMenu;

    public EmbmenuFrame() throws HeadlessException {
    }

    public EmbmenuFrame(String title) throws HeadlessException {
        super(title);
    }

    protected boolean embedMenuIfNeeded(Panel tobeAdjusted) {
        MenuBar topMenuBar = this.getMenuBar();
        if (topMenuBar == null) {
            return false;
        }
        if (new Platform().isAMac()) {
            this.embeddedMenu = this.makeEmbeddedPopupMenu(topMenuBar, "Arial", 0, 10, true);
            this.setMenuBar(null);
            this.add((Component)this.embeddedMenu, "North");
            tobeAdjusted.setSize(this.getSize().width, this.getSize().height - 2);
            return true;
        }
        return false;
    }

    protected Panel makeEmbeddedPopupMenu(MenuBar menuBar, String fn, int fstyle, int fsz, boolean overrideFonts) {
        return this.makeEmbeddedPopupMenu(menuBar, fn, fstyle, fsz, overrideFonts, false);
    }

    protected Panel makeEmbeddedPopupMenu(MenuBar menuBar, String fn, int fstyle, int fsz, boolean overrideFonts, boolean append) {
        if (!append) {
            if (this.embeddedPopup != null) {
                this.embeddedPopup.clear();
            }
            if (this.embeddedMenu != null) {
                this.embeddedMenu.removeAll();
            }
        }
        if (this.embeddedPopup == null) {
            this.embeddedPopup = new Hashtable();
        }
        this.embeddedMenu = this.makeEmbeddedPopupMenu(menuBar, fn, fstyle, fsz, overrideFonts, this.embeddedPopup, new Panel(), this);
        return this.embeddedMenu;
    }

    protected Panel makeEmbeddedPopupMenu(MenuBar menuBar, String fn, int fstyle, int fsz, boolean overrideFonts, Hashtable embeddedPopup, Panel embeddedMenu, MouseListener clickHandler) {
        Font mbf;
        if (embeddedPopup == null) {
            throw new Error("Implementation error - embeddedPopup must be non-null");
        }
        if (overrideFonts && (mbf = menuBar.getFont()) != null) {
            fn = mbf.getName();
            fstyle = mbf.getStyle();
            fsz = mbf.getSize();
        }
        if (embeddedMenu == null) {
            embeddedMenu = new Panel();
        }
        FlowLayout flowLayout1 = new FlowLayout();
        embeddedMenu.setBackground(Color.lightGray);
        embeddedMenu.setLayout(flowLayout1);
        int nMbi = menuBar.getMenuCount();
        for (int mbi = 0; mbi < nMbi; ++mbi) {
            Menu mi = menuBar.getMenu(mbi);
            Label elab = new Label(mi.getLabel());
            elab.setFont(new Font(fn, fstyle, fsz));
            PopupMenu popup = new PopupMenu();
            int mSize = mi.getItemCount();
            for (int m = 0; m < mSize; ++m) {
                popup.add(mi.getItem(m));
                --mSize;
                --m;
            }
            embeddedPopup.put(elab, popup);
            embeddedMenu.add(elab);
            elab.addMouseListener(clickHandler);
        }
        flowLayout1.setAlignment(0);
        flowLayout1.setHgap(2);
        flowLayout1.setVgap(0);
        return embeddedMenu;
    }

    public void mousePressed(MouseEvent evt) {
        PopupMenu popup = null;
        Label source = (Label)evt.getSource();
        popup = this.getPopupMenu(source);
        if (popup != null) {
            this.embeddedMenu.add(popup);
            popup.show(this.embeddedMenu, source.getBounds().x, source.getBounds().y + source.getBounds().getSize().height);
        }
    }

    PopupMenu getPopupMenu(Label source) {
        return (PopupMenu)this.embeddedPopup.get(source);
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void destroyMenus() {
        if (this.embeddedPopup != null) {
            Enumeration e = this.embeddedPopup.keys();
            while (e.hasMoreElements()) {
                Label lb = (Label)e.nextElement();
                lb.removeMouseListener(this);
            }
            this.embeddedPopup.clear();
        }
        if (this.embeddedMenu != null) {
            this.embeddedMenu.removeAll();
        }
    }

    public void finalize() throws Throwable {
        this.destroyMenus();
        this.embeddedPopup = null;
        this.embeddedMenu = null;
        super.finalize();
    }
}

