C Copyright 1981-2012 ECMWF.
C
C This software is licensed under the terms of the Apache Licence 
C Version 2.0 which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
C
C In applying this licence, ECMWF does not waive the privileges and immunities 
C granted to it by virtue of its status as an intergovernmental organisation 
C nor does it submit to any jurisdiction.
C

      INTEGER FUNCTION IARMEM (KIMEM, KOMEM, KPR, KERR)
C
C---->
C**** *IARMEM*
C
C     PURPOSE
C     _______
C
C     This routine acquires heap space for expanded REAL fields.
C
C     INTERFACE
C     _________
C
C     IERR = IARMEM (KIMEM, KOMEM, KPR, KERR)
C
C     Input parameters
C     ________________
C
C     KIMEM      - Space required for input field.
C
C     KOMEM      - Space required for output field.
C
C     KPR        - The debug print switch.
C                  0  , No debugging output.
C                  1  , Produce debugging output.
C
C     KERR       - The error control flag.
C                  -ve, No error message. Return error code.
C                  0  , Hard failure with error message.
C                  +ve, Print error message. Return error code.
C
C     Output parameters
C     ________________
C
C     None
C
C     Return value
C     ____________
C
C     The error indicator (INTEGER).
C
C     Error and Warning Return Values
C     _______________________________
C
C     None
C
C     Common block usage
C     __________________
C
C     nifld.common - This file contains all the input field
C                    definition variables.
C
C     NINS         - Number of grid points in NS direction for input
C                    field (used in ouspace.h).
C     NIWE         - Number of grid points in WE direction for input
C                    field (used in ouspace.h).
C
C     nofld.common - This file contains all the output field
C                    definition variables.
C
C     NONS         - Number of grid points in NS direction for output
C                    field (used in ouspace.h).
C     NOWE         - Number of grid points in WE direction for output
C                    field (used in ouspace.h).
C
C     ouspace.h    - This file contains the work space array
C                    definitions for the arrays to hold the unpacked
C                    real data from GRIB fields.
C
C     NIFELD       - POINTER to array RIFELD.
C     NOFELD       - POINTER to array ROFELD.
C
C     RIFELD       - Dynamic array of length (NIWE * NINS)
C                    (see nifld.common) which holds the expanded
C                    input field.
C     ROFELD       - Dynamic array of length (NOWE * NONS)
C                    (see nofld.common) which holds the expanded
C                    output field.
C
C     EXTERNALS
C     _________
C
C     IGALLOC    - Get a heap allocation for array space.
C     INTLOG(R)    - Logs messages.
C
C     METHOD
C     ______
C
C     This routine calculates how much heap space is required. It
C     then calls IGALLOC to acquire the required space. Finally the
C     POINTERs to the arrays in ouspace.h are initialised to allow
C     the use of the dynamic arrays.
C
C     REFERENCE
C     _________
C
C     None
C
C     COMMENTS
C     ________
C
C     Program contains sections 0 to 3 and 9
C
C     AUTHOR
C     ______
C
C     K. Fielding      *ECMWF*      Apr 1994
C
C     MODIFICATIONS
C     _____________
C
C     None
C
C----<
C     _______________________________________________________
C
C
C*    Section 0. Definition of variables.
C     _______________________________________________________
C
C*    Prefix conventions for variable names
C
C     Logical      L (but not LP), global or common.
C                  O, dummy argument
C                  G, local variable
C                  LP, parameter.
C     Character    C, global or common.
C                  H, dummy argument
C                  Y (but not YP), local variable
C                  YP, parameter.
C     Integer      M and N, global or common.
C                  K, dummy argument
C                  I, local variable
C                  J (but not JP), loop control
C                  JP, parameter.
C     REAL         A to F and Q to X, global or common.
C                  P (but not PP), dummy argument
C                  Z, local variable
C                  PP, parameter.
C
C     Implicit statement to force declarations
C
      IMPLICIT NONE
C
#include "parim.h"
#include "nifld.common"
#include "nofld.common"
#include "ouspace.h"
C
C     Dummy arguments
      INTEGER KIMEM, KOMEM, KPR, KERR
C
C     Local variables
      INTEGER IBASE, IERR
      INTEGER JPROUTINE
      PARAMETER (JPROUTINE = 24100)
C
C     External functions
      INTEGER IGALLOC
C
C     _______________________________________________________
C
C*    Section 1. Initialisation
C     _______________________________________________________
C
  100 CONTINUE
C
      IF (KPR.GE.1) CALL INTLOG(JP_DEBUG,'IARMEM: Section 1.',JPQUIET)
C
      IARMEM = 0
C
      IF (KPR .GE. 1) THEN
        CALL INTLOG(JP_DEBUG,'IARMEM: Input parameters.',JPQUIET)
        CALL INTLOG(JP_DEBUG,'IARMEM: Input fld space = ',KIMEM)
        CALL INTLOG(JP_DEBUG,'IARMEM: Output fld space = ',KOMEM)
      ENDIF
C
C     _______________________________________________________
C
C*    Section 2. Calculate memory required and get heap
C     _______________________________________________________
C
  200 CONTINUE
C
      IF (KPR.GE.1) CALL INTLOG(JP_DEBUG,'IARMEM: Section 2.',JPQUIET)
C
C     Get the required memory
C
      IERR = IGALLOC (JPGRIB_SPACE, (KIMEM + KOMEM) * JPRLEN, IBASE,
     1   KPR, KERR)
C
      IF (IERR .GT. 0) THEN
         IARMEM = IERR
         GO TO 900
      ENDIF
C
C     _______________________________________________________
C
C
C*    Section 3. Initialise base addresses for POINTER arrays
C     _______________________________________________________
C
  300 CONTINUE
C
      IF (KPR.GE.1) CALL INTLOG(JP_DEBUG,'IARMEM: Section 3.',JPQUIET)
C
      NIFELD = IBASE
      NOFELD = NIFELD + KIMEM * JPRLEN
C
      IF (KPR .GE. 1) THEN
        CALL INTLOG(JP_DEBUG,'IARMEM: Output base addresses.',JPQUIET)
        CALL INTLOG(JP_DEBUG,'IARMEM: Input fld base address = ',NIFELD)
        CALL INTLOG(JP_DEBUG,'IARMEM: Output fld base address= ',NOFELD)
      ENDIF
C
C     _______________________________________________________
C
C
C*    Section 9. Return to calling routine. Format statements
C     _______________________________________________________
C
  900 CONTINUE
C
      IF (KPR.GE.1) CALL INTLOG(JP_DEBUG,'IARMEM: Section 9.',JPQUIET)
C
      RETURN
      END
