/* $Id: configuration.h,v 1.4 2003/06/13 17:17:47 sjoerd Exp $ */

#ifndef FFRENZY_CONFIG_H
#define FFRENZY_CONFIG_H

#include <stdio.h>
#include <SDL.h>

#include "vector.h"
#include "list.h"
#include "global.h"

typedef enum {
  CONFIG_ACTION_FIRST = 0,
  CONFIG_ACTION_THROW = 0,
  CONFIG_ACTION_LEFT,
  CONFIG_ACTION_RIGHT,
  CONFIG_ACTION_JUMP,
  CONFIG_NRKEYS
} Config_action;

typedef struct {
  List *players;
  char *hostname;
  Vector *resolution;
} Config;

typedef struct {
  Config_action action;
  SDLKey key;
} Config_key;

typedef struct {
  uint32_t player;
  char *name;
  List *keys;
} Config_player;

Config *new_config(char *configfile);
void del_config(Config *config);

char *config_get_pname(Config *config,uint32_t player);
List *config_get_keys(Config *config,uint32_t player);
#endif /* FFRENZY_CONFIG_H */
