/* 
 * ### Copyright (C) 2008 Michael Fuchs ###
 * ### All Rights Reserved.             ###
 *
 * Author: Michael Fuchs
 * E-Mail: michael.fuchs@dbdoclet.org
 * URL:    http://www.michael-a-fuchs.de
 */
package org.dbdoclet.trafo.html.docbook.editor;

import org.dbdoclet.trafo.html.docbook.DbtConstants;
import org.dbdoclet.trafo.tag.docbook.DocBookElement;
import org.dbdoclet.trafo.tag.docbook.DocBookTagFactory;
import org.dbdoclet.trafo.tag.html.HtmlElement;

public class StrongEditor extends Editor {

	@Override
	public EditorInstruction edit(EditorInstruction values)
			throws EditorException {

		setValues(super.edit(values));
		DocBookTagFactory dbfactory = values.getTagFactory();

		HtmlElement child = getHtmlElement();
		DocBookElement parent = getParent();

		DocBookElement candidate;

		candidate = dbfactory.createEmphasis(child.getTextContent());
		candidate.setParentNode(parent);

		candidate.setRole(DbtConstants.DEFAULT_EMPHASIS_ROLE_BOLD);

		if (candidate.validate()) {

			parent.appendChild(candidate);
			setCurrent(candidate);
		}

		traverse(false);

		return finalizeValues();
	}
}
