/*
 ==============================================================================
 This file is part of the IEM plug-in suite.
 Author: Daniel Rudrich
 Copyright (c) 2018 - Institute of Electronic Music and Acoustics (IEM)
 https://iem.at

 The IEM plug-in suite is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation,  either version 3 of the License,  or
 (at your option) any later version.

 The IEM plug-in suite is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this software.  If not,  see <http://www.gnu.org/licenses/>.
 ==============================================================================
 */

/*
 This data originates from https://matplotlib.org/examples/color/colormaps_reference.html.
 The following rgb color data is cropped and stretched.
 */

#pragma once

const float viridis_cropped[256][3] = {
    { 2.4862898999999999e-01, 2.7877509000000000e-01, 5.3455560999999996e-01 },
    { 2.4719630141176469e-01, 2.8229182541176467e-01, 5.3564756811764702e-01 },
    { 2.4575108611764707e-01, 2.8579548647058822e-01, 5.3670143882352939e-01 },
    { 2.4429415011764705e-01, 2.8928603670588232e-01, 5.3771804270588230e-01 },
    { 2.4282629788235294e-01, 2.9276343658823528e-01, 5.3869819882352943e-01 },
    { 2.4134744235294117e-01, 2.9622628823529412e-01, 5.3963923352941179e-01 },
    { 2.3985752164705881e-01, 2.9967240717647059e-01, 5.4053699223529406e-01 },
    { 2.3835995847058822e-01, 3.0310529670588238e-01, 5.4140170329411763e-01 },
    { 2.3685551741176469e-01, 3.0652496235294119e-01, 5.4223418305882354e-01 },
    { 2.3534504447058827e-01, 3.0993138505882356e-01, 5.4303528047058824e-01 },
    { 2.3382903941176469e-01, 3.1332171117647062e-01, 5.4380008941176472e-01 },
    { 2.3230902423529409e-01, 3.1669655341176473e-01, 5.4453131529411769e-01 },
    { 2.3078602517647059e-01, 3.2005830976470584e-01, 5.4523448364705884e-01 },
    { 2.2926062305882353e-01, 3.2340708235294113e-01, 5.4591031905882359e-01 },
    { 2.2773349811764704e-01, 3.2674293752941175e-01, 5.4655958341176469e-01 },
    { 2.2620540941176470e-01, 3.3006206235294117e-01, 5.4717561294117645e-01 },
    { 2.2467760823529409e-01, 3.3336774058823526e-01, 5.4776585658823529e-01 },
    { 2.2315075000000001e-01, 3.3666085600000001e-01, 5.4833259000000001e-01 },
    { 2.2162543423529410e-01, 3.3994151458823529e-01, 5.4887652035294121e-01 },
    { 2.2010237447058822e-01, 3.4320933317647057e-01, 5.4939748870588234e-01 },
    { 2.1858335235294118e-01, 3.4646103176470583e-01, 5.4989060647058818e-01 },
    { 2.1706817023529412e-01, 3.4970077741176475e-01, 5.5036371894117653e-01 },
    { 2.1555733282352940e-01, 3.5292870482352945e-01, 5.5081745505882362e-01 },
    { 2.1405132529411763e-01, 3.5614495541176472e-01, 5.5125243305882354e-01 },
    { 2.1255147117647061e-01, 3.5934807564705884e-01, 5.5166681623529412e-01 },
    { 2.1105947352941176e-01, 3.6253730411764706e-01, 5.5206047470588238e-01 },
    { 2.0957431694117648e-01, 3.6571543470588236e-01, 5.5243790470588228e-01 },
    { 2.0809622752941176e-01, 3.6888268364705884e-01, 5.5279956682352938e-01 },
    { 2.0662542988235294e-01, 3.7203926576470586e-01, 5.5314591517647060e-01 },
    { 2.0516427023529413e-01, 3.7518285847058824e-01, 5.5347404964705893e-01 },
    { 2.0371231823529412e-01, 3.7831506941176474e-01, 5.5378661588235301e-01 },
    { 2.0226887411764705e-01, 3.8143735352941177e-01, 5.5408583023529412e-01 },
    { 2.0083416635294118e-01, 3.8454990070588235e-01, 5.5437211776470596e-01 },
    { 1.9940840588235292e-01, 3.8765290752941178e-01, 5.5464589705882350e-01 },
    { 1.9799510000000001e-01, 3.9074345199999999e-01, 5.5490364999999997e-01 },
    { 1.9659145882352941e-01, 3.9382488470588239e-01, 5.5514982647058819e-01 },
    { 1.9519740199999999e-01, 3.9689758741176473e-01, 5.5538500811764702e-01 },
    { 1.9381302411764706e-01, 3.9996175670588235e-01, 5.5560951764705890e-01 },
    { 1.9243920882352941e-01, 4.0301694094117646e-01, 5.5582285352941185e-01 },
    { 1.9107803800000001e-01, 4.0606186729411764e-01, 5.5602346341176467e-01 },
    { 1.8972671235294120e-01, 4.0909910647058823e-01, 5.5621453529411768e-01 },
    { 1.8838520741176468e-01, 4.1212886223529410e-01, 5.5639629494117648e-01 },
    { 1.8705348764705881e-01, 4.1515133882352939e-01, 5.5656895529411765e-01 },
    { 1.8573327235294118e-01, 4.1816551117647061e-01, 5.5673113470588231e-01 },
    { 1.8442438411764706e-01, 4.2117176823529412e-01, 5.5688314705882347e-01 },
    { 1.8312491470588238e-01, 4.2417159705882346e-01, 5.5702674882352943e-01 },
    { 1.8183473188235294e-01, 4.2716520082352938e-01, 5.5716205788235296e-01 },
    { 1.8055369235294116e-01, 4.3015278282352942e-01, 5.5728918129411764e-01 },
    { 1.7928408176470589e-01, 4.3313299011764711e-01, 5.5740595047058827e-01 },
    { 1.7802375552941177e-01, 4.3610734870588241e-01, 5.5751409623529413e-01 },
    { 1.7677177411764705e-01, 4.3907651000000003e-01, 5.5761431882352941e-01 },
    { 1.7552791000000001e-01, 4.4204066800000003e-01, 5.5770663999999992e-01 },
    { 1.7429207529411767e-01, 4.4499993188235293e-01, 5.5779090235294115e-01 },
    { 1.7306631917647058e-01, 4.4795314705882350e-01, 5.5786449599999999e-01 },
    { 1.7184763905882353e-01, 4.5090214823529406e-01, 5.5793011247058821e-01 },
    { 1.7063600176470589e-01, 4.5384707882352937e-01, 5.5798782823529414e-01 },
    { 1.6943123776470587e-01, 4.5678810364705885e-01, 5.5803763176470578e-01 },
    { 1.6823365611764707e-01, 4.5972501317647063e-01, 5.5807834411764701e-01 },
    { 1.6704325811764706e-01, 4.6265774599999998e-01, 5.5810864341176480e-01 },
    { 1.6585824105882352e-01, 4.6558736658823530e-01, 5.5813040105882350e-01 },
    { 1.6467832411764705e-01, 4.6851404117647055e-01, 5.5814347176470580e-01 },
    { 1.6350322811764706e-01, 4.7143793305882348e-01, 5.5814769941176468e-01 },
    { 1.6233358152941177e-01, 4.7435868376470586e-01, 5.5814080235294117e-01 },
    { 1.6116854670588238e-01, 4.7727677941176472e-01, 5.5812319282352940e-01 },
    { 1.6000725211764705e-01, 4.8019273964705877e-01, 5.5809594611764701e-01 },
    { 1.5884947117647058e-01, 4.8310671058823529e-01, 5.5805884000000006e-01 },
    { 1.5769498647058824e-01, 4.8601883423529413e-01, 5.5801164717647056e-01 },
    { 1.5654447823529413e-01, 4.8892878611764706e-01, 5.5795058258823527e-01 },
    { 1.5539681999999999e-01, 4.9183723800000001e-01, 5.5787820199999993e-01 },
    { 1.5425177188235295e-01, 4.9474439235294115e-01, 5.5779465023529418e-01 },
    { 1.5310922941176472e-01, 4.9765037000000001e-01, 5.5769964294117647e-01 },
    { 1.5196924411764706e-01, 5.0055522199999991e-01, 5.5759214341176477e-01 },
    { 1.5083234588235295e-01, 5.0345893705882361e-01, 5.5746862882352943e-01 },
    { 1.4969844976470589e-01, 5.0636182494117643e-01, 5.5733271200000001e-01 },
    { 1.4856750517647058e-01, 5.0926401364705876e-01, 5.5718399505882354e-01 },
    { 1.4743942176470587e-01, 5.1216563352941180e-01, 5.5702203352941182e-01 },
    { 1.4631457058823530e-01, 5.1506675717647066e-01, 5.5684397117647066e-01 },
    { 1.4519348152941175e-01, 5.1796753376470583e-01, 5.5664855588235296e-01 },
    { 1.4407592694117646e-01, 5.2086811858823534e-01, 5.5643824647058826e-01 },
    { 1.4296228176470588e-01, 5.2376858188235287e-01, 5.5621266741176467e-01 },
    { 1.4185295941176471e-01, 5.2666899000000000e-01, 5.5597143823529405e-01 },
    { 1.4074999752941175e-01, 5.2956941999999996e-01, 5.5570971258823532e-01 },
    { 1.3965362364705883e-01, 5.3246995799999997e-01, 5.5542946176470598e-01 },
    { 1.3856404941176470e-01, 5.3537064905882348e-01, 5.5513192670588241e-01 },
    { 1.3748206070588234e-01, 5.3827153211764711e-01, 5.5481670317647069e-01 },
    { 1.3640849999999999e-01, 5.4117263999999998e-01, 5.5448339000000002e-01 },
    { 1.3534998670588236e-01, 5.4407390552941182e-01, 5.5412527105882348e-01 },
    { 1.3430315847058824e-01, 5.4697547082352937e-01, 5.5374775388235298e-01 },
    { 1.3326924435294119e-01, 5.4987735047058828e-01, 5.5335041176470590e-01 },
    { 1.3224954223529412e-01, 5.5277955294117653e-01, 5.5293281647058823e-01 },
    { 1.3124728529411764e-01, 5.5568211117647048e-01, 5.5249235058823520e-01 },
    { 1.3026817258823531e-01, 5.5858507058823526e-01, 5.5202479435294116e-01 },
    { 1.2930980494117650e-01, 5.6148832635294121e-01, 5.5153521200000000e-01 },
    { 1.2837404564705882e-01, 5.6439186388235307e-01, 5.5102317870588235e-01 },
    { 1.2746283188235294e-01, 5.6729566294117650e-01, 5.5048827141176471e-01 },
    { 1.2658447764705882e-01, 5.7019971882352938e-01, 5.4992514823529415e-01 },
    { 1.2574285823529413e-01, 5.7310386188235296e-01, 5.4933449741176477e-01 },
    { 1.2493542400000002e-01, 5.7600807988235292e-01, 5.4871938870588233e-01 },
    { 1.2416449847058825e-01, 5.7891235305882360e-01, 5.4807927270588230e-01 },
    { 1.2343255623529412e-01, 5.8181664905882358e-01, 5.4741364729411768e-01 },
    { 1.2275688882352941e-01, 5.8472085470588242e-01, 5.4671388352941175e-01 },
    { 1.2213186941176471e-01, 5.8762488905882360e-01, 5.4598568494117639e-01 },
    { 1.2155795999999999e-01, 5.9052868199999997e-01, 5.4523024399999998e-01 },
    { 1.2103831752941176e-01, 5.9343215682352946e-01, 5.4444715223529405e-01 },
    { 1.2057872905882352e-01, 5.9633521164705883e-01, 5.4363482847058819e-01 },
    { 1.2020294470588236e-01, 5.9923751705882355e-01, 5.4278458294117649e-01 },
    { 1.1989580988235295e-01, 6.0213909164705881e-01, 5.4190536317647064e-01 },
    { 1.1966047800000000e-01, 6.0503987717647056e-01, 5.4099655564705884e-01 },
    { 1.1950021329411764e-01, 6.0793980211764709e-01, 5.4005761011764708e-01 },
    { 1.1943067517647059e-01, 6.1083860047058824e-01, 5.3908367447058825e-01 },
    { 1.1946515588235296e-01, 6.1373597294117654e-01, 5.3807152235294120e-01 },
    { 1.1958929423529412e-01, 6.1663202776470594e-01, 5.3702767094117654e-01 },
    { 1.1980649811764707e-01, 6.1952664341176478e-01, 5.3595175352941182e-01 },
    { 1.2012013941176471e-01, 6.2241969376470585e-01, 5.3484341305882355e-01 },
    { 1.2055954117647058e-01, 6.2531056247058836e-01, 5.3369417388235296e-01 },
    { 1.2111802117647058e-01, 6.2819921176470594e-01, 5.3250766411764705e-01 },
    { 1.2178572752941177e-01, 6.3108574882352952e-01, 5.3128730541176472e-01 },
    { 1.2256528305882351e-01, 6.3397004270588242e-01, 5.3003268764705891e-01 },
    { 1.2345929705882354e-01, 6.3685195117647053e-01, 5.2874348282352945e-01 },
    { 1.2451233999999999e-01, 6.3973035000000000e-01, 5.2740702200000000e-01 },
    { 1.2568910647058823e-01, 6.4260583705882357e-01, 5.2603425529411763e-01 },
    { 1.2698885752941177e-01, 6.4547830870588230e-01, 5.2462560011764703e-01 },
    { 1.2841312294117646e-01, 6.4834760647058820e-01, 5.2318077717647060e-01 },
    { 1.2997371058823529e-01, 6.5121327529411766e-01, 5.2169652223529406e-01 },
    { 1.3169827611764706e-01, 6.5407428952941171e-01, 5.2016480235294116e-01 },
    { 1.3355119000000001e-01, 6.5693145588235291e-01, 5.1859565176470590e-01 },
    { 1.3553276247058824e-01, 6.5978460482352941e-01, 5.1698879611764714e-01 },
    { 1.3764316647058822e-01, 6.6263356176470589e-01, 5.1534397600000004e-01 },
    { 1.3990595352941176e-01, 6.6547727823529401e-01, 5.1365383399999998e-01 },
    { 1.4232042764705882e-01, 6.6831542670588229e-01, 5.1191790611764709e-01 },
    { 1.4486219941176470e-01, 6.7114863117647050e-01, 5.1014299588235301e-01 },
    { 1.4753041458823532e-01, 6.7397671082352939e-01, 5.0832884141176471e-01 },
    { 1.5032411317647060e-01, 6.7679948600000006e-01, 5.0647517152941179e-01 },
    { 1.5327702388235293e-01, 6.7961509400000009e-01, 5.0457021964705895e-01 },
    { 1.5636161152941178e-01, 6.8242432952941179e-01, 5.0262180776470589e-01 },
    { 1.5956626235294116e-01, 6.8522745529411755e-01, 5.0063298941176471e-01 },
    { 1.6288942400000000e-01, 6.8802427799999999e-01, 4.9860357399999999e-01 },
    { 1.6633182094117646e-01, 6.9081446541176472e-01, 4.9653254094117649e-01 },
    { 1.6992794352941179e-01, 6.9359545164705882e-01, 4.9440617658823527e-01 },
    { 1.7363544564705879e-01, 6.9636930176470591e-01, 4.9223846752941175e-01 },
    { 1.7745250882352942e-01, 6.9913581882352938e-01, 4.9002905882352943e-01 },
    { 1.8137730752941175e-01, 7.0189480023529405e-01, 4.8777769247058822e-01 },
    { 1.8542057623529407e-01, 7.0464503988235294e-01, 4.8547910376470593e-01 },
    { 1.8959158611764704e-01, 7.0738516788235306e-01, 4.8312799047058824e-01 },
    { 1.9386264294117644e-01, 7.1011686988235301e-01, 4.8073449811764712e-01 },
    { 1.9823192117647062e-01, 7.1283993588235295e-01, 4.7829850058823531e-01 },
    { 2.0269760835294115e-01, 7.1555415470588224e-01, 4.7581987388235292e-01 },
    { 2.0727838258823533e-01, 7.1825717117647070e-01, 4.7328884247058822e-01 },
    { 2.1196342882352939e-01, 7.2094935658823533e-01, 4.7070869576470586e-01 },
    { 2.1673778623529416e-01, 7.2363180552941175e-01, 4.6808501435294114e-01 },
    { 2.2159983117647059e-01, 7.2630429235294125e-01, 4.6541766470588231e-01 },
    { 2.2654791364705890e-01, 7.2896658458823538e-01, 4.6270669082352939e-01 },
    { 2.3160687082352943e-01, 7.3161491329411765e-01, 4.5993794341176469e-01 },
    { 2.3675033199999995e-01, 7.3425190799999995e-01, 4.5712372800000001e-01 },
    { 2.4197343811764707e-01, 7.3687778023529416e-01, 4.5426575776470585e-01 },
    { 2.4727476764705880e-01, 7.3949230588235293e-01, 4.5136396176470589e-01 },
    { 2.5265749247058827e-01, 7.4209452282352950e-01, 4.4841556764705881e-01 },
    { 2.5813766294117646e-01, 7.4468112376470597e-01, 4.4540970905882349e-01 },
    { 2.6369073011764710e-01, 7.4725543317647070e-01, 4.4235944835294116e-01 },
    { 2.6931565352941178e-01, 7.4981722164705888e-01, 4.3926443623529415e-01 },
    { 2.7501128941176478e-01, 7.5236625705882354e-01, 4.3612456705882352e-01 },
    { 2.8078715447058827e-01, 7.5490011035294124e-01, 4.3293313635294123e-01 },
    { 2.8664396752941168e-01, 7.5741781847058820e-01, 4.2968827247058827e-01 },
    { 2.9256662905882347e-01, 7.5992180917647056e-01, 4.2639900294117650e-01 },
    { 2.9855412305882356e-01, 7.6241185447058823e-01, 4.2306530588235292e-01 },
    { 3.0460545294117647e-01, 7.6488772647058823e-01, 4.1968716117647054e-01 },
    { 3.1073585835294115e-01, 7.6734523917647057e-01, 4.1625275694117647e-01 },
    { 3.1693352870588226e-01, 7.6978637399999994e-01, 4.1276933976470592e-01 },
    { 3.2319141411764718e-01, 7.7221235941176469e-01, 4.0924116835294111e-01 },
    { 3.2950888964705893e-01, 7.7462294952941180e-01, 4.0566791094117649e-01 },
    { 3.3588539000000001e-01, 7.7701790000000004e-01, 4.0204917000000001e-01 },
    { 3.4234002811764697e-01, 7.7939100058823529e-01, 3.9836957729411770e-01 },
    { 3.4885059541176455e-01, 7.8174776399999990e-01, 3.9464553870588243e-01 },
    { 3.5541633329411770e-01, 7.8408795682352950e-01, 3.9087708341176464e-01 },
    { 3.6203650305882357e-01, 7.8641135023529407e-01, 3.8706424823529412e-01 },
    { 3.6871574882352937e-01, 7.8871594529411759e-01, 3.8320256529411767e-01 },
    { 3.7546140752941171e-01, 7.9099850482352951e-01, 3.7928491458823532e-01 },
    { 3.8225858588235306e-01, 7.9326332305882352e-01, 3.7532311929411760e-01 },
    { 3.8910661717647066e-01, 7.9551018247058825e-01, 3.7131725058823528e-01 },
    { 3.9600484988235291e-01, 7.9773886411764705e-01, 3.6726737482352939e-01 },
    { 4.0296254764705874e-01, 7.9994529235294121e-01, 3.6316458647058825e-01 },
    { 4.0997762094117635e-01, 8.0212971188235294e-01, 3.5900931117647061e-01 },
    { 4.1704044788235300e-01, 8.0429501435294126e-01, 3.5481016811764698e-01 },
    { 4.2415019870588233e-01, 8.0644100835294119e-01, 3.5056756741176470e-01 },
    { 4.3130624317647054e-01, 8.0856748635294118e-01, 3.4628164282352947e-01 },
    { 4.3852154411764693e-01, 8.1066807823529397e-01, 3.4193943588235298e-01 },
    { 4.4578393870588251e-01, 8.1274729505882348e-01, 3.3755179317647049e-01 },
    { 4.5309002600000003e-01, 8.1480616200000000e-01, 3.3312155199999993e-01 },
    { 4.6043917670588236e-01, 8.1684448941176480e-01, 3.2864892435294119e-01 },
    { 4.6783244541176466e-01, 8.1886122882352930e-01, 3.2413243070588238e-01 },
    { 4.7528061999999988e-01, 8.2085007941176469e-01, 3.1956054176470594e-01 },
    { 4.8276920094117659e-01, 8.2281762964705885e-01, 3.1494733564705879e-01 },
    { 4.9029753223529415e-01, 8.2476372105882356e-01, 3.1029313141176468e-01 },
    { 4.9786495223529409e-01, 8.2668819682352934e-01, 3.0559826294117648e-01 },
    { 5.0547610494117634e-01, 8.2858774929411760e-01, 3.0085742176470592e-01 },
    { 5.1313284352941180e-01, 8.3046030176470587e-01, 2.9606806529411761e-01 },
    { 5.2082646470588245e-01, 8.3231051764705888e-01, 2.9123888047058821e-01 },
    { 5.2855595082352946e-01, 8.3413832376470587e-01, 2.8637077858823534e-01 },
    { 5.3632015647058817e-01, 8.3594367247058821e-01, 2.8146486352941180e-01 },
    { 5.4412628705882338e-01, 8.3772087505882353e-01, 2.7651293294117657e-01 },
    { 5.5196882764705890e-01, 8.3947253823529411e-01, 2.7152072294117646e-01 },
    { 5.5984284423529418e-01, 8.4120136541176471e-01, 2.6649356788235296e-01 },
    { 5.6774750623529413e-01, 8.4290729399999997e-01, 2.6143232482352946e-01 },
    { 5.7568196705882346e-01, 8.4459026623529410e-01, 2.5633789835294130e-01 },
    { 5.8365477000000010e-01, 8.4624223399999998e-01, 2.5120089799999995e-01 },
    { 5.9165514352941184e-01, 8.4787070176470591e-01, 2.4603353882352935e-01 },
    { 5.9968157623529406e-01, 8.4947613952941170e-01, 2.4083780964705881e-01 },
    { 6.0773311176470579e-01, 8.5105856211764708e-01, 2.3561514117647064e-01 },
    { 6.1581059235294111e-01, 8.5261613082352938e-01, 2.3036521823529421e-01 },
    { 6.2391686764705889e-01, 8.5414426741176475e-01, 2.2508649317647050e-01 },
    { 6.3204399823529411e-01, 8.5564963411764716e-01, 2.1978833647058821e-01 },
    { 6.4019089423529407e-01, 8.5713233705882352e-01, 2.1447306094117652e-01 },
    { 6.4835645094117633e-01, 8.5859249623529421e-01, 2.0914312905882360e-01 },
    { 6.5654236905882368e-01, 8.6002619376470590e-01, 2.0380002094117641e-01 },
    { 6.6474643776470599e-01, 8.6143373670588241e-01, 1.9844964576470586e-01 },
    { 6.7296427352941168e-01, 8.6281945647058822e-01, 1.9309786529411765e-01 },
    { 6.8119463599999985e-01, 8.6418358011764718e-01, 1.8774877035294124e-01 },
    { 6.8943626858823548e-01, 8.6552634623529412e-01, 1.8240671470588227e-01 },
    { 6.9768997494117657e-01, 8.6684216317647067e-01, 1.7708297352941171e-01 },
    { 7.0595158141176473e-01, 8.6813583858823540e-01, 1.7178452894117646e-01 },
    { 7.1421895588235285e-01, 8.6940942647058828e-01, 1.6651707705882357e-01 },
    { 7.2249072399999992e-01, 8.7066328800000004e-01, 1.6128797200000008e-01 },
    { 7.3076551564705894e-01, 8.7189742011764715e-01, 1.5610627870588228e-01 },
    { 7.3904119247058830e-01, 8.7310643341176475e-01, 1.5100678258823524e-01 },
    { 7.4731524505882352e-01, 8.7429750941176465e-01, 1.4598488011764710e-01 },
    { 7.5558623882352938e-01, 8.7547113235294116e-01, 1.4105282470588243e-01 },
    { 7.6385272494117662e-01, 8.7662780141176477e-01, 1.3622366411764697e-01 },
    { 7.7211217752941186e-01, 8.7776613929411762e-01, 1.3152905294117642e-01 },
    { 7.8036094435294112e-01, 8.7888525141176466e-01, 1.2701571223529412e-01 },
    { 7.8859908376470589e-01, 8.7998972929411767e-01, 1.2267358494117650e-01 },
    { 7.9682513117647047e-01, 8.8108018588235293e-01, 1.1852288764705889e-01 },
    { 8.0503762823529423e-01, 8.8215724694117648e-01, 1.1458472188235289e-01 },
    { 8.1323113705882355e-01, 8.8321897623529411e-01, 1.1094443847058821e-01 },
    { 8.2140434752941172e-01, 8.8426759494117646e-01, 1.0762614188235295e-01 },
    { 8.2955808917647045e-01, 8.8530559129411768e-01, 1.0462064094117651e-01 },
    { 8.3769099470588249e-01, 8.8633366529411761e-01, 1.0195326235294112e-01 },
    { 8.4580171388235303e-01, 8.8735252200000003e-01, 9.9649241058823501e-02 },
    { 8.5388036894117647e-01, 8.8836060400000005e-01, 9.7875451529411767e-02 },
    { 8.6193178999999986e-01, 8.8936142600000001e-01, 9.6552406000000007e-02 },
    { 8.6995577552941161e-01, 8.9035605305882348e-01, 9.5680108470588249e-02 },
    { 8.7795116117647065e-01, 8.9134522176470576e-01, 9.5272329999999988e-02 },
    { 8.8591487576470584e-01, 8.9232945964705879e-01, 9.5370016000000002e-02 },
    { 8.9383743458823517e-01, 8.9330914223529412e-01, 9.6097958941176453e-02 },
    { 9.0172701694117641e-01, 8.9428640329411757e-01, 9.7303858588235273e-02 },
    { 9.0958256858823550e-01, 8.9526202058823534e-01, 9.8978742588235330e-02 },
    { 9.1740255176470598e-01, 8.9623697588235296e-01, 1.0111137294117649e-01 },
    { 9.2517744458823536e-01, 8.9721320529411763e-01, 1.0375501164705883e-01 },
    { 9.3290720588235287e-01, 8.9819091317647048e-01, 1.0688897505882350e-01 },
    { 9.4059861199999983e-01, 8.9917073647058821e-01, 1.1040127399999994e-01 },
    { 9.4825107858823543e-01, 9.0015332729411779e-01, 1.1426930141176475e-01 },
    { 9.5586406176470584e-01, 9.0113932647058825e-01, 1.1847021352941178e-01 },
    { 9.6342624141176469e-01, 9.0213074517647063e-01, 1.2305158682352940e-01 },
    { 9.7094351211764696e-01, 9.0312790058823533e-01, 1.2792661847058817e-01 },
    { 9.7841969752941194e-01, 9.0413090529411766e-01, 1.3304486611764715e-01 },
    { 9.8585455823529422e-01, 9.0514029035294108e-01, 1.3838742552941183e-01 },
    {
        9.9324789000000002e-01,
        9.0615657000000005e-01,
        1.4393619999999999e-01,
    }
};
