/***************************************
  $Header: /cvs/src/jbofihe/cmavotab.h,v 1.4 2001/08/08 21:33:08 richard Exp $

  Definition of the record type used for the cmavo table.
  ***************************************/

/**********************************************************************
 * Copyright (C) Richard P. Curnow  1998-2001
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 * 
 *********************************************************************/

#ifndef CMAVOTAB_H
#define CMAVOTAB_H    /*+ To stop multiple inclusions. +*/

typedef enum {
  CM_UNKNOWN = -1,
  CM_A = 14,
  CM_AI = 17,
  CM_AU = 19,
  CM_AhA = 22,
  CM_AhE = 23,
  CM_AhI = 24,
  CM_AhO = 25,
  CM_AhU = 26,
  CM_E = 28,
  CM_EI = 31,
  CM_EhA = 36,
  CM_EhE = 37,
  CM_EhI = 38,
  CM_EhO = 39,
  CM_EhU = 40,
  CM_I = 42,
  CM_IA = 43,
  CM_IE = 44,
  CM_II = 45,
  CM_IO = 46,
  CM_IU = 47,
  CM_IhA = 50,
  CM_IhE = 51,
  CM_IhI = 52,
  CM_IhO = 53,
  CM_IhU = 54,
  CM_O = 56,
  CM_OI = 59,
  CM_OhA = 64,
  CM_OhE = 65,
  CM_OhI = 66,
  CM_OhO = 67,
  CM_OhU = 68,
  CM_U = 70,
  CM_UA = 71,
  CM_UE = 72,
  CM_UI = 73,
  CM_UO = 74,
  CM_UU = 75,
  CM_UhA = 78,
  CM_UhE = 79,
  CM_UhI = 80,
  CM_UhO = 81,
  CM_UhU = 82,
  CM_Y = 84,
  CM_YhY = 97,
  CM_BA = 112,
  CM_BAI = 115,
  CM_BAU = 117,
  CM_BAhA = 120,
  CM_BAhE = 121,
  CM_BAhI = 122,
  CM_BAhO = 123,
  CM_BAhU = 124,
  CM_BE = 126,
  CM_BEI = 129,
  CM_BEhA = 134,
  CM_BEhE = 135,
  CM_BEhI = 136,
  CM_BEhO = 137,
  CM_BEhU = 138,
  CM_BI = 140,
  CM_BIhE = 149,
  CM_BIhI = 150,
  CM_BIhO = 151,
  CM_BIhU = 152,
  CM_BO = 154,
  CM_BOI = 157,
  CM_BU = 168,
  CM_BUhA = 176,
  CM_BUhE = 177,
  CM_BUhI = 178,
  CM_BUhO = 179,
  CM_BUhU = 180,
  CM_BY = 182,
  CM_CA = 210,
  CM_CAI = 213,
  CM_CAU = 215,
  CM_CAhA = 218,
  CM_CAhE = 219,
  CM_CAhI = 220,
  CM_CAhO = 221,
  CM_CAhU = 222,
  CM_CE = 224,
  CM_CEI = 227,
  CM_CEhA = 232,
  CM_CEhE = 233,
  CM_CEhI = 234,
  CM_CEhO = 235,
  CM_CEhU = 236,
  CM_CI = 238,
  CM_CIhE = 247,
  CM_CIhI = 248,
  CM_CIhO = 249,
  CM_CIhU = 250,
  CM_CO = 252,
  CM_COI = 255,
  CM_COhA = 260,
  CM_COhE = 261,
  CM_COhI = 262,
  CM_COhO = 263,
  CM_COhU = 264,
  CM_CU = 266,
  CM_CUhA = 274,
  CM_CUhE = 275,
  CM_CUhI = 276,
  CM_CUhO = 277,
  CM_CUhU = 278,
  CM_CY = 280,
  CM_DA = 308,
  CM_DAI = 311,
  CM_DAU = 313,
  CM_DAhA = 316,
  CM_DAhE = 317,
  CM_DAhI = 318,
  CM_DAhO = 319,
  CM_DAhU = 320,
  CM_DE = 322,
  CM_DEI = 325,
  CM_DEhA = 330,
  CM_DEhE = 331,
  CM_DEhI = 332,
  CM_DEhO = 333,
  CM_DEhU = 334,
  CM_DI = 336,
  CM_DIhA = 344,
  CM_DIhE = 345,
  CM_DIhI = 346,
  CM_DIhO = 347,
  CM_DIhU = 348,
  CM_DO = 350,
  CM_DOI = 353,
  CM_DOhA = 358,
  CM_DOhE = 359,
  CM_DOhI = 360,
  CM_DOhO = 361,
  CM_DOhU = 362,
  CM_DU = 364,
  CM_DUhA = 372,
  CM_DUhE = 373,
  CM_DUhI = 374,
  CM_DUhO = 375,
  CM_DUhU = 376,
  CM_DY = 378,
  CM_FA = 406,
  CM_FAI = 409,
  CM_FAU = 411,
  CM_FAhA = 414,
  CM_FAhE = 415,
  CM_FAhI = 416,
  CM_FAhO = 417,
  CM_FAhU = 418,
  CM_FE = 420,
  CM_FEI = 423,
  CM_FEhA = 428,
  CM_FEhE = 429,
  CM_FEhI = 430,
  CM_FEhO = 431,
  CM_FEhU = 432,
  CM_FI = 434,
  CM_FIhA = 442,
  CM_FIhE = 443,
  CM_FIhI = 444,
  CM_FIhO = 445,
  CM_FIhU = 446,
  CM_FO = 448,
  CM_FOI = 451,
  CM_FOhA = 456,
  CM_FOhE = 457,
  CM_FOhI = 458,
  CM_FOhO = 459,
  CM_FOhU = 460,
  CM_FU = 462,
  CM_FUhA = 470,
  CM_FUhE = 471,
  CM_FUhI = 472,
  CM_FUhO = 473,
  CM_FUhU = 474,
  CM_FY = 476,
  CM_GA = 504,
  CM_GAI = 507,
  CM_GAU = 509,
  CM_GAhA = 512,
  CM_GAhE = 513,
  CM_GAhI = 514,
  CM_GAhO = 515,
  CM_GAhU = 516,
  CM_GE = 518,
  CM_GEI = 521,
  CM_GEhA = 526,
  CM_GEhE = 527,
  CM_GEhI = 528,
  CM_GEhO = 529,
  CM_GEhU = 530,
  CM_GI = 532,
  CM_GIhA = 540,
  CM_GIhE = 541,
  CM_GIhI = 542,
  CM_GIhO = 543,
  CM_GIhU = 544,
  CM_GO = 546,
  CM_GOI = 549,
  CM_GOhA = 554,
  CM_GOhE = 555,
  CM_GOhI = 556,
  CM_GOhO = 557,
  CM_GOhU = 558,
  CM_GU = 560,
  CM_GUhA = 568,
  CM_GUhE = 569,
  CM_GUhI = 570,
  CM_GUhO = 571,
  CM_GUhU = 572,
  CM_GY = 574,
  CM_JA = 602,
  CM_JAI = 605,
  CM_JAU = 607,
  CM_JAhA = 610,
  CM_JAhE = 611,
  CM_JAhI = 612,
  CM_JAhO = 613,
  CM_JE = 616,
  CM_JEI = 619,
  CM_JEhA = 624,
  CM_JEhE = 625,
  CM_JEhI = 626,
  CM_JEhO = 627,
  CM_JEhU = 628,
  CM_JI = 630,
  CM_JIhA = 638,
  CM_JIhE = 639,
  CM_JIhI = 640,
  CM_JIhO = 641,
  CM_JIhU = 642,
  CM_JO = 644,
  CM_JOI = 647,
  CM_JOhA = 652,
  CM_JOhE = 653,
  CM_JOhI = 654,
  CM_JOhO = 655,
  CM_JOhU = 656,
  CM_JU = 658,
  CM_JUhA = 666,
  CM_JUhE = 667,
  CM_JUhI = 668,
  CM_JUhO = 669,
  CM_JUhU = 670,
  CM_JY = 672,
  CM_KA = 700,
  CM_KAI = 703,
  CM_KAU = 705,
  CM_KAhA = 708,
  CM_KAhE = 709,
  CM_KAhI = 710,
  CM_KAhO = 711,
  CM_KAhU = 712,
  CM_KE = 714,
  CM_KEI = 717,
  CM_KEhA = 722,
  CM_KEhE = 723,
  CM_KEhI = 724,
  CM_KEhO = 725,
  CM_KEhU = 726,
  CM_KI = 728,
  CM_KIhA = 736,
  CM_KIhE = 737,
  CM_KIhI = 738,
  CM_KIhO = 739,
  CM_KIhU = 740,
  CM_KO = 742,
  CM_KOI = 745,
  CM_KOhA = 750,
  CM_KOhE = 751,
  CM_KOhI = 752,
  CM_KOhO = 753,
  CM_KOhU = 754,
  CM_KU = 756,
  CM_KUhA = 764,
  CM_KUhE = 765,
  CM_KUhI = 766,
  CM_KUhO = 767,
  CM_KUhU = 768,
  CM_KY = 770,
  CM_LA = 798,
  CM_LAI = 801,
  CM_LAU = 803,
  CM_LAhA = 806,
  CM_LAhE = 807,
  CM_LAhI = 808,
  CM_LAhO = 809,
  CM_LAhU = 810,
  CM_LE = 812,
  CM_LEI = 815,
  CM_LEhA = 820,
  CM_LEhE = 821,
  CM_LEhI = 822,
  CM_LEhO = 823,
  CM_LEhU = 824,
  CM_LI = 826,
  CM_LIhA = 834,
  CM_LIhE = 835,
  CM_LIhI = 836,
  CM_LIhO = 837,
  CM_LIhU = 838,
  CM_LO = 840,
  CM_LOI = 843,
  CM_LOhA = 848,
  CM_LOhE = 849,
  CM_LOhI = 850,
  CM_LOhO = 851,
  CM_LOhU = 852,
  CM_LU = 854,
  CM_LUhA = 862,
  CM_LUhE = 863,
  CM_LUhI = 864,
  CM_LUhO = 865,
  CM_LUhU = 866,
  CM_LY = 868,
  CM_MA = 896,
  CM_MAI = 899,
  CM_MAU = 901,
  CM_MAhA = 904,
  CM_MAhE = 905,
  CM_MAhI = 906,
  CM_MAhO = 907,
  CM_MAhU = 908,
  CM_ME = 910,
  CM_MEI = 913,
  CM_MEhA = 918,
  CM_MEhE = 919,
  CM_MEhI = 920,
  CM_MEhO = 921,
  CM_MEhU = 922,
  CM_MI = 924,
  CM_MIhA = 932,
  CM_MIhE = 933,
  CM_MIhI = 934,
  CM_MIhO = 935,
  CM_MIhU = 936,
  CM_MO = 938,
  CM_MOI = 941,
  CM_MOhA = 946,
  CM_MOhE = 947,
  CM_MOhI = 948,
  CM_MOhO = 949,
  CM_MOhU = 950,
  CM_MU = 952,
  CM_MUhA = 960,
  CM_MUhE = 961,
  CM_MUhI = 962,
  CM_MUhO = 963,
  CM_MUhU = 964,
  CM_MY = 966,
  CM_NA = 994,
  CM_NAI = 997,
  CM_NAU = 999,
  CM_NAhA = 1002,
  CM_NAhE = 1003,
  CM_NAhI = 1004,
  CM_NAhO = 1005,
  CM_NAhU = 1006,
  CM_NE = 1008,
  CM_NEI = 1011,
  CM_NEhA = 1016,
  CM_NEhI = 1018,
  CM_NEhO = 1019,
  CM_NEhU = 1020,
  CM_NI = 1022,
  CM_NIhA = 1030,
  CM_NIhE = 1031,
  CM_NIhI = 1032,
  CM_NIhO = 1033,
  CM_NIhU = 1034,
  CM_NO = 1036,
  CM_NOI = 1039,
  CM_NOhA = 1044,
  CM_NOhE = 1045,
  CM_NOhI = 1046,
  CM_NOhO = 1047,
  CM_NOhU = 1048,
  CM_NU = 1050,
  CM_NUhA = 1058,
  CM_NUhE = 1059,
  CM_NUhI = 1060,
  CM_NUhO = 1061,
  CM_NUhU = 1062,
  CM_NY = 1064,
  CM_PA = 1092,
  CM_PAI = 1095,
  CM_PAU = 1097,
  CM_PAhA = 1100,
  CM_PAhE = 1101,
  CM_PAhI = 1102,
  CM_PAhO = 1103,
  CM_PAhU = 1104,
  CM_PE = 1106,
  CM_PEI = 1109,
  CM_PEhA = 1114,
  CM_PEhE = 1115,
  CM_PEhI = 1116,
  CM_PEhO = 1117,
  CM_PEhU = 1118,
  CM_PI = 1120,
  CM_PIhA = 1128,
  CM_PIhE = 1129,
  CM_PIhI = 1130,
  CM_PIhO = 1131,
  CM_PIhU = 1132,
  CM_PO = 1134,
  CM_POI = 1137,
  CM_POhA = 1142,
  CM_POhE = 1143,
  CM_POhI = 1144,
  CM_POhO = 1145,
  CM_POhU = 1146,
  CM_PU = 1148,
  CM_PUhA = 1156,
  CM_PUhE = 1157,
  CM_PUhI = 1158,
  CM_PUhO = 1159,
  CM_PUhU = 1160,
  CM_PY = 1162,
  CM_RA = 1190,
  CM_RAI = 1193,
  CM_RAU = 1195,
  CM_RAhA = 1198,
  CM_RAhE = 1199,
  CM_RAhI = 1200,
  CM_RAhO = 1201,
  CM_RAhU = 1202,
  CM_RE = 1204,
  CM_REI = 1207,
  CM_REhA = 1212,
  CM_REhE = 1213,
  CM_REhI = 1214,
  CM_REhO = 1215,
  CM_REhU = 1216,
  CM_RI = 1218,
  CM_RIhA = 1226,
  CM_RIhE = 1227,
  CM_RIhI = 1228,
  CM_RIhO = 1229,
  CM_RIhU = 1230,
  CM_RO = 1232,
  CM_ROI = 1235,
  CM_ROhA = 1240,
  CM_ROhE = 1241,
  CM_ROhI = 1242,
  CM_ROhO = 1243,
  CM_ROhU = 1244,
  CM_RU = 1246,
  CM_RUhA = 1254,
  CM_RUhE = 1255,
  CM_RUhI = 1256,
  CM_RUhO = 1257,
  CM_RUhU = 1258,
  CM_RY = 1260,
  CM_SA = 1288,
  CM_SAI = 1291,
  CM_SAU = 1293,
  CM_SAhA = 1296,
  CM_SAhE = 1297,
  CM_SAhI = 1298,
  CM_SAhO = 1299,
  CM_SAhU = 1300,
  CM_SE = 1302,
  CM_SEI = 1305,
  CM_SEhA = 1310,
  CM_SEhE = 1311,
  CM_SEhI = 1312,
  CM_SEhO = 1313,
  CM_SEhU = 1314,
  CM_SI = 1316,
  CM_SIhA = 1324,
  CM_SIhE = 1325,
  CM_SIhI = 1326,
  CM_SIhO = 1327,
  CM_SIhU = 1328,
  CM_SO = 1330,
  CM_SOI = 1333,
  CM_SOhA = 1338,
  CM_SOhE = 1339,
  CM_SOhI = 1340,
  CM_SOhO = 1341,
  CM_SOhU = 1342,
  CM_SU = 1344,
  CM_SUhA = 1352,
  CM_SUhE = 1353,
  CM_SUhI = 1354,
  CM_SUhO = 1355,
  CM_SUhU = 1356,
  CM_SY = 1358,
  CM_TA = 1386,
  CM_TAI = 1389,
  CM_TAU = 1391,
  CM_TAhA = 1394,
  CM_TAhE = 1395,
  CM_TAhI = 1396,
  CM_TAhO = 1397,
  CM_TAhU = 1398,
  CM_TE = 1400,
  CM_TEI = 1403,
  CM_TEhA = 1408,
  CM_TEhE = 1409,
  CM_TEhO = 1411,
  CM_TEhU = 1412,
  CM_TI = 1414,
  CM_TIhA = 1422,
  CM_TIhE = 1423,
  CM_TIhI = 1424,
  CM_TIhO = 1425,
  CM_TIhU = 1426,
  CM_TO = 1428,
  CM_TOI = 1431,
  CM_TOhA = 1436,
  CM_TOhE = 1437,
  CM_TOhI = 1438,
  CM_TOhO = 1439,
  CM_TOhU = 1440,
  CM_TU = 1442,
  CM_TUhA = 1450,
  CM_TUhE = 1451,
  CM_TUhI = 1452,
  CM_TUhO = 1453,
  CM_TUhU = 1454,
  CM_TY = 1456,
  CM_VA = 1484,
  CM_VAI = 1487,
  CM_VAU = 1489,
  CM_VAhA = 1492,
  CM_VAhI = 1494,
  CM_VAhO = 1495,
  CM_VAhU = 1496,
  CM_VE = 1498,
  CM_VEI = 1501,
  CM_VEhA = 1506,
  CM_VEhE = 1507,
  CM_VEhI = 1508,
  CM_VEhO = 1509,
  CM_VEhU = 1510,
  CM_VI = 1512,
  CM_VIhA = 1520,
  CM_VIhE = 1521,
  CM_VIhI = 1522,
  CM_VIhO = 1523,
  CM_VIhU = 1524,
  CM_VO = 1526,
  CM_VOI = 1529,
  CM_VOhA = 1534,
  CM_VOhE = 1535,
  CM_VOhI = 1536,
  CM_VOhO = 1537,
  CM_VOhU = 1538,
  CM_VU = 1540,
  CM_VUhA = 1548,
  CM_VUhE = 1549,
  CM_VUhI = 1550,
  CM_VUhO = 1551,
  CM_VUhU = 1552,
  CM_VY = 1554,
  CM_XA = 1582,
  CM_XAhO = 1593,
  CM_XE = 1596,
  CM_XI = 1610,
  CM_XO = 1624,
  CM_XU = 1638,
  CM_XY = 1652,
  CM_ZA = 1680,
  CM_ZAI = 1683,
  CM_ZAU = 1685,
  CM_ZAhA = 1688,
  CM_ZAhE = 1689,
  CM_ZAhI = 1690,
  CM_ZAhO = 1691,
  CM_ZAhU = 1692,
  CM_ZE = 1694,
  CM_ZEI = 1697,
  CM_ZEhA = 1702,
  CM_ZEhE = 1703,
  CM_ZEhI = 1704,
  CM_ZEhO = 1705,
  CM_ZEhU = 1706,
  CM_ZI = 1708,
  CM_ZIhE = 1717,
  CM_ZIhO = 1719,
  CM_ZO = 1722,
  CM_ZOI = 1725,
  CM_ZOhA = 1730,
  CM_ZOhE = 1731,
  CM_ZOhI = 1732,
  CM_ZOhO = 1733,
  CM_ZOhU = 1734,
  CM_ZU = 1736,
  CM_ZUhA = 1744,
  CM_ZUhE = 1745,
  CM_ZUhI = 1746,
  CM_ZUhO = 1747,
  CM_ZUhU = 1748,
  CM_ZY = 1750
} __attribute__ ((packed)) CmavoCodes;

typedef enum {
  SSM_UNKNOWN = -1,
  SSM_A = 0,
  SSM_BAI = 1,
  SSM_BAhE = 2,
  SSM_BE = 3,
  SSM_BEI = 4,
  SSM_BEhO = 5,
  SSM_BIhI = 6,
  SSM_BO = 7,
  SSM_BOI = 8,
  SSM_BU = 9,
  SSM_BY1 = 10,
  SSM_BY2 = 11,
  SSM_CAI = 12,
  SSM_CAhA = 13,
  SSM_CEI = 14,
  SSM_CO = 15,
  SSM_COI = 16,
  SSM_CU = 17,
  SSM_CUhE = 18,
  SSM_DAhO = 19,
  SSM_DOI = 20,
  SSM_DOhU = 21,
  SSM_FA = 22,
  SSM_FAhA1 = 23,
  SSM_FAhA2 = 24,
  SSM_FAhA3 = 25,
  SSM_FAhA4 = 26,
  SSM_FAhO = 27,
  SSM_FEhE = 28,
  SSM_FEhU = 29,
  SSM_FIhO = 30,
  SSM_FOI = 31,
  SSM_FUhA = 32,
  SSM_FUhE = 33,
  SSM_FUhO = 34,
  SSM_GA = 35,
  SSM_GAhO = 36,
  SSM_GEhU = 37,
  SSM_GI = 38,
  SSM_GIhA = 39,
  SSM_GOI = 40,
  SSM_GOhA = 41,
  SSM_GUhA = 42,
  SSM_I = 43,
  SSM_JA = 44,
  SSM_JAI = 45,
  SSM_JOI = 46,
  SSM_JOhI = 47,
  SSM_KE = 48,
  SSM_KEI = 49,
  SSM_KEhE = 50,
  SSM_KI = 51,
  SSM_KOhA1 = 52,
  SSM_KOhA2 = 53,
  SSM_KOhA3 = 54,
  SSM_KOhA4 = 55,
  SSM_KOhA5 = 56,
  SSM_KOhA6 = 57,
  SSM_KOhA7 = 58,
  SSM_KU = 59,
  SSM_KUhE = 60,
  SSM_KUhO = 61,
  SSM_LA = 62,
  SSM_LAU = 63,
  SSM_LAhE = 64,
  SSM_LE = 65,
  SSM_LEhU = 66,
  SSM_LI = 67,
  SSM_LIhU = 68,
  SSM_LOhO = 69,
  SSM_LOhU = 70,
  SSM_LU = 71,
  SSM_LUhU = 72,
  SSM_MAI = 73,
  SSM_MAhO = 74,
  SSM_ME = 75,
  SSM_MEhU = 76,
  SSM_MOI = 77,
  SSM_MOhE = 78,
  SSM_MOhI = 79,
  SSM_NA = 80,
  SSM_NAI = 81,
  SSM_NAhE = 82,
  SSM_NAhU = 83,
  SSM_NIhE = 84,
  SSM_NIhO = 85,
  SSM_NOI = 86,
  SSM_NU = 87,
  SSM_NU1 = 88,
  SSM_NUhA = 89,
  SSM_NUhI = 90,
  SSM_NUhU = 91,
  SSM_PA1 = 92,
  SSM_PA2 = 93,
  SSM_PA3 = 94,
  SSM_PA4 = 95,
  SSM_PA5 = 96,
  SSM_PEhA = 97,
  SSM_PEhO = 98,
  SSM_POhA = 99,
  SSM_PU = 100,
  SSM_RAhO = 101,
  SSM_ROI = 102,
  SSM_SA = 103,
  SSM_SE = 104,
  SSM_SEI = 105,
  SSM_SEhU = 106,
  SSM_SI = 107,
  SSM_SOI = 108,
  SSM_SU = 109,
  SSM_TAhE = 110,
  SSM_TEI = 111,
  SSM_TEhU = 112,
  SSM_TO = 113,
  SSM_TOI = 114,
  SSM_TUhE = 115,
  SSM_TUhU = 116,
  SSM_UI1 = 117,
  SSM_UI2 = 118,
  SSM_UI3 = 119,
  SSM_UI3a = 120,
  SSM_UI3b = 121,
  SSM_UI4 = 122,
  SSM_UI5 = 123,
  SSM_UI6 = 124,
  SSM_UI7 = 125,
  SSM_VA = 126,
  SSM_VAU = 127,
  SSM_VEI = 128,
  SSM_VEhA = 129,
  SSM_VEhO = 130,
  SSM_VIhA = 131,
  SSM_VUhO = 132,
  SSM_VUhU0 = 133,
  SSM_VUhU1 = 134,
  SSM_VUhU2 = 135,
  SSM_VUhU3 = 136,
  SSM_VUhU4 = 137,
  SSM_XI = 138,
  SSM_Y = 139,
  SSM_ZAhO = 140,
  SSM_ZEI = 141,
  SSM_ZEhA = 142,
  SSM_ZI = 143,
  SSM_ZIhE = 144,
  SSM_ZO = 145,
  SSM_ZOI = 146,
  SSM_ZOhU = 147,

  /* The following ones were manually added, to fix up the missing entries from
     the cmavo file. */
  SSM_BIhE = 148,
  SSM_CEhE = 149,
  SSM_KOhA8 = 150,
  SSM_PEhE = 151

} __attribute__ ((packed)) SelmaoCodes;

typedef struct {
  char *cmavo;
  short selmao; /* as per tokens in rpc.tab.h at parse level (e.g. KOhA) */
  CmavoCodes code;
  SelmaoCodes ssm_code; /* e.g. KOhA2 */
  char *meaning;
} __attribute__ ((packed)) CmavoCell;

extern CmavoCell cmavo_table[];
extern char *selmao_names[];

#endif /* CMAVOTAB_H */
