/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * JSymphonicSettings.java
 *
 * Created on Jun 11, 2009, 9:56:38 PM
 */

package org.danizmax.jsymphonic.gui.settings;

import java.awt.BorderLayout;
import java.io.File;
import java.util.TreeMap;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/**
 *
 * @author danizmax
 */
public class SettingsDialog extends javax.swing.JDialog implements ListSelectionListener{

    private SettingsProfilePage jSProfilePage;
    private SettingsInterfacePage jSInterfacePage;
    private SettingsTransferPage jSTransferPage;
    private JScrollPane sp;
    private SettingsHandler sHandler;
    private boolean success = false;
    
    /** Creates new form JSymphonicSettings */
    public SettingsDialog(SettingsHandler sHandler, TreeMap langMap, TreeMap themeMap) {
        this.sHandler = sHandler;
        this.sHandler.loadSettings(new File(SettingsHandler.CONFIG_FILE_NAME));
        initComponents();
        this.setIconImage(new ImageIcon(getClass().getResource("/org/danizmax/jsymphonic/resources/icons/js_logo16.png")).getImage());
        settingsList.addListSelectionListener(this);
        jSProfilePage = new SettingsProfilePage(this.sHandler.getProfiles(), this.sHandler.getActiveProfile());
        jSInterfacePage = new SettingsInterfacePage(langMap, themeMap);
        jSTransferPage = new SettingsTransferPage();
        sp = new JScrollPane();
        settingContentPanel.add(sp, BorderLayout.CENTER);
        DefaultListModel dlm =  (DefaultListModel) settingsList.getModel();
        dlm.addElement("Profiles");
        dlm.addElement("Interface");
        dlm.addElement("Transfer");
        settingsList.setSelectedIndex(0);

        jSInterfacePage.setLanguage(sHandler.getLanguage());
        jSInterfacePage.setTheme(sHandler.getTheme());
        jSInterfacePage.setLogLevel(sHandler.getLogLevel());
        jSInterfacePage.setLogToFile(sHandler.isLogToFile());
        jSInterfacePage.setShowToolbarText(sHandler.isShowToolbarText());

        jSTransferPage.setBitrate(sHandler.getBitrate());
        jSTransferPage.setAlwaysTranscode(sHandler.isAlwaysTranscode());
        jSTransferPage.setReadID3Tags(!sHandler.isNeverReadTags());
        jSTransferPage.setTagFolderStructure(sHandler.getTagStructure());
    }


    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        settingContentPanel = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        settingsList = new javax.swing.JList();
        cancelButton = new javax.swing.JButton();
        okButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("JSymphonic settings");

        settingContentPanel.setLayout(new java.awt.BorderLayout());

        settingsList.setModel(new DefaultListModel());
        settingsList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        settingsList.setCellRenderer(new SettingsListCellRenderer());
        settingsList.setSelectedIndex(0);
        jScrollPane1.setViewportView(settingsList);

        cancelButton.setFont(new java.awt.Font("Dialog", 0, 12)); // NOI18N
        cancelButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/danizmax/jsymphonic/resources/icons/cancel.png"))); // NOI18N
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        okButton.setFont(new java.awt.Font("Dialog", 0, 12)); // NOI18N
        okButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/danizmax/jsymphonic/resources/icons/ok.png"))); // NOI18N
        okButton.setText("OK");
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 126, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(layout.createSequentialGroup()
                        .add(okButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(cancelButton)
                        .addContainerGap())
                    .add(settingContentPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 628, Short.MAX_VALUE)))
        );

        layout.linkSize(new java.awt.Component[] {cancelButton, okButton}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 541, Short.MAX_VALUE)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .add(settingContentPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 491, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(cancelButton)
                    .add(okButton))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        if(jSProfilePage.isProfileModified()){
            if(JOptionPane.YES_OPTION == JOptionPane.showConfirmDialog(this, "Current profile has not been saved. Do you want to discard changes?", "Discarding changed settings...", JOptionPane.YES_NO_OPTION)){
                success = false;
                this.setVisible(false);
            }
        }else{
            success = false;
            this.setVisible(false);
        }
}//GEN-LAST:event_cancelButtonActionPerformed

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
       if(jSProfilePage.isProfileModified()){
            if(JOptionPane.YES_OPTION == JOptionPane.showConfirmDialog(this, "Current profile has not been saved. Do you want to save changes?", "Saving changed settings...", JOptionPane.YES_NO_OPTION)){
                jSProfilePage.saveProfileData();
            } 
        }
        sHandler.setActiveProfile(jSProfilePage.getDefaultProfile());

        sHandler.setLanguage(jSInterfacePage.getLanguage());
        sHandler.setTheme(jSInterfacePage.getTheme());
        sHandler.setLogLevel(jSInterfacePage.getLogLevel());
        sHandler.setLogToFile(jSInterfacePage.isLogToFile());
        sHandler.setShowToolbarText(jSInterfacePage.isShowToolbarText());

        sHandler.setBitrate(String.valueOf(jSTransferPage.getBitrate()));
        sHandler.setAlwaysTranscode(jSTransferPage.isAlwaysTranscode());
        sHandler.setNeverReadTags(!jSTransferPage.isReadID3Tags());
        sHandler.setTagStructure(jSTransferPage.getTagFolderStructure());

        sHandler.saveSettings(new File(SettingsHandler.CONFIG_FILE_NAME));
        this.setVisible(false);
        success = true;
}//GEN-LAST:event_okButtonActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JButton okButton;
    private javax.swing.JPanel settingContentPanel;
    private javax.swing.JList settingsList;
    // End of variables declaration//GEN-END:variables

    public void valueChanged(ListSelectionEvent e) {
        if(e.getValueIsAdjusting() == false){
            if(settingsList.getLeadSelectionIndex() == 0){
               sp.setViewportView(jSProfilePage);
            } else if(settingsList.getLeadSelectionIndex() == 1){
                sp.setViewportView(jSInterfacePage);
            } else if(settingsList.getLeadSelectionIndex() == 2){
                sp.setViewportView(jSTransferPage);
            }
        }
    }

    /**
     * @return the success
     */
    public boolean isSuccess() {
        return success;
    }

}
