/* gsd-swap-operation.c generated by valac 0.20.1, the Vala compiler
 * generated from gsd-swap-operation.vala, do not modify */

/* 
 * 
 * Copyright (C) 2009-2011 Colomban Wendling <ban@herbesfolles.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <gsd-config.h>


#define GSD_TYPE_ASYNC_OPERATION (gsd_async_operation_get_type ())
#define GSD_ASYNC_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GSD_TYPE_ASYNC_OPERATION, GsdAsyncOperation))
#define GSD_ASYNC_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GSD_TYPE_ASYNC_OPERATION, GsdAsyncOperationClass))
#define GSD_IS_ASYNC_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GSD_TYPE_ASYNC_OPERATION))
#define GSD_IS_ASYNC_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GSD_TYPE_ASYNC_OPERATION))
#define GSD_ASYNC_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GSD_TYPE_ASYNC_OPERATION, GsdAsyncOperationClass))

typedef struct _GsdAsyncOperation GsdAsyncOperation;
typedef struct _GsdAsyncOperationClass GsdAsyncOperationClass;
typedef struct _GsdAsyncOperationPrivate GsdAsyncOperationPrivate;

#define GSD_TYPE_SECURE_DELETE_OPERATION (gsd_secure_delete_operation_get_type ())
#define GSD_SECURE_DELETE_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GSD_TYPE_SECURE_DELETE_OPERATION, GsdSecureDeleteOperation))
#define GSD_SECURE_DELETE_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GSD_TYPE_SECURE_DELETE_OPERATION, GsdSecureDeleteOperationClass))
#define GSD_IS_SECURE_DELETE_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GSD_TYPE_SECURE_DELETE_OPERATION))
#define GSD_IS_SECURE_DELETE_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GSD_TYPE_SECURE_DELETE_OPERATION))
#define GSD_SECURE_DELETE_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GSD_TYPE_SECURE_DELETE_OPERATION, GsdSecureDeleteOperationClass))

typedef struct _GsdSecureDeleteOperation GsdSecureDeleteOperation;
typedef struct _GsdSecureDeleteOperationClass GsdSecureDeleteOperationClass;
typedef struct _GsdSecureDeleteOperationPrivate GsdSecureDeleteOperationPrivate;

#define GSD_TYPE_ZEROABLE_OPERATION (gsd_zeroable_operation_get_type ())
#define GSD_ZEROABLE_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GSD_TYPE_ZEROABLE_OPERATION, GsdZeroableOperation))
#define GSD_ZEROABLE_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GSD_TYPE_ZEROABLE_OPERATION, GsdZeroableOperationClass))
#define GSD_IS_ZEROABLE_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GSD_TYPE_ZEROABLE_OPERATION))
#define GSD_IS_ZEROABLE_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GSD_TYPE_ZEROABLE_OPERATION))
#define GSD_ZEROABLE_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GSD_TYPE_ZEROABLE_OPERATION, GsdZeroableOperationClass))

typedef struct _GsdZeroableOperation GsdZeroableOperation;
typedef struct _GsdZeroableOperationClass GsdZeroableOperationClass;
typedef struct _GsdZeroableOperationPrivate GsdZeroableOperationPrivate;

#define GSD_TYPE_SWAP_OPERATION (gsd_swap_operation_get_type ())
#define GSD_SWAP_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GSD_TYPE_SWAP_OPERATION, GsdSwapOperation))
#define GSD_SWAP_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GSD_TYPE_SWAP_OPERATION, GsdSwapOperationClass))
#define GSD_IS_SWAP_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GSD_TYPE_SWAP_OPERATION))
#define GSD_IS_SWAP_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GSD_TYPE_SWAP_OPERATION))
#define GSD_SWAP_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GSD_TYPE_SWAP_OPERATION, GsdSwapOperationClass))

typedef struct _GsdSwapOperation GsdSwapOperation;
typedef struct _GsdSwapOperationClass GsdSwapOperationClass;
typedef struct _GsdSwapOperationPrivate GsdSwapOperationPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))

typedef enum  {
	GSD_ASYNC_OPERATION_ERROR_CHILD_FAILED,
	GSD_ASYNC_OPERATION_ERROR_SUBCLASS_ERROR
} GsdAsyncOperationError;
#define GSD_ASYNC_OPERATION_ERROR gsd_async_operation_error_quark ()
struct _GsdAsyncOperation {
	GObject parent_instance;
	GsdAsyncOperationPrivate * priv;
	guint n_passes;
	guint passes;
	GPid pid;
	gint fd_in;
	gint fd_out;
	gint fd_err;
};

struct _GsdAsyncOperationClass {
	GObjectClass parent_class;
	GList* (*build_args) (GsdAsyncOperation* self, GError** error);
	gchar** (*build_env) (GsdAsyncOperation* self, int* result_length1);
	void (*cleanup) (GsdAsyncOperation* self);
	guint (*get_max_progress) (GsdAsyncOperation* self);
	guint (*get_progress) (GsdAsyncOperation* self);
	gchar* (*get_subprocess_error_msg) (GsdAsyncOperation* self);
};

struct _GsdSecureDeleteOperation {
	GsdAsyncOperation parent_instance;
	GsdSecureDeleteOperationPrivate * priv;
};

struct _GsdSecureDeleteOperationClass {
	GsdAsyncOperationClass parent_class;
};

struct _GsdZeroableOperation {
	GsdSecureDeleteOperation parent_instance;
	GsdZeroableOperationPrivate * priv;
};

struct _GsdZeroableOperationClass {
	GsdSecureDeleteOperationClass parent_class;
};

struct _GsdSwapOperation {
	GsdZeroableOperation parent_instance;
	GsdSwapOperationPrivate * priv;
};

struct _GsdSwapOperationClass {
	GsdZeroableOperationClass parent_class;
};

struct _GsdSwapOperationPrivate {
	gchar* _device;
	gboolean _check_device;
};


static gpointer gsd_swap_operation_parent_class = NULL;

GType gsd_async_operation_get_type (void) G_GNUC_CONST;
GQuark gsd_async_operation_error_quark (void);
GType gsd_secure_delete_operation_get_type (void) G_GNUC_CONST;
GType gsd_zeroable_operation_get_type (void) G_GNUC_CONST;
GType gsd_swap_operation_get_type (void) G_GNUC_CONST;
#define GSD_SWAP_OPERATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GSD_TYPE_SWAP_OPERATION, GsdSwapOperationPrivate))
enum  {
	GSD_SWAP_OPERATION_DUMMY_PROPERTY,
	GSD_SWAP_OPERATION_DEVICE,
	GSD_SWAP_OPERATION_CHECK_DEVICE
};
static gboolean gsd_swap_operation_swap_is_in_use (GsdSwapOperation* self, const gchar* swapdev);
static GList* gsd_swap_operation_real_build_args (GsdAsyncOperation* base, GError** error);
const gchar* gsd_swap_operation_get_device (GsdSwapOperation* self);
gboolean gsd_swap_operation_get_check_device (GsdSwapOperation* self);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
GList* gsd_async_operation_build_args (GsdAsyncOperation* self, GError** error);
static void gsd_swap_operation_real_cleanup (GsdAsyncOperation* base);
void gsd_swap_operation_set_device (GsdSwapOperation* self, const gchar* value);
gboolean gsd_swap_operation_run (GsdSwapOperation* self, const gchar* device, GError** error);
gboolean gsd_secure_delete_operation_run (GsdSecureDeleteOperation* self, GError** error);
gboolean gsd_swap_operation_run_sync (GsdSwapOperation* self, const gchar* device, GError** error);
gboolean gsd_secure_delete_operation_run_sync (GsdSecureDeleteOperation* self, GError** error);
GsdSwapOperation* gsd_swap_operation_new (void);
GsdSwapOperation* gsd_swap_operation_construct (GType object_type);
GsdZeroableOperation* gsd_zeroable_operation_construct (GType object_type);
void gsd_swap_operation_set_check_device (GsdSwapOperation* self, gboolean value);
static GObject * gsd_swap_operation_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void gsd_async_operation_set_path (GsdAsyncOperation* self, const gchar* value);
static void gsd_swap_operation_finalize (GObject* obj);
static void _vala_gsd_swap_operation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gsd_swap_operation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gchar* g_file_stream_read_line (FILE* self) {
	gchar* result = NULL;
	gint c = 0;
	GString* ret;
	GString* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	while (TRUE) {
		gint _tmp0_ = 0;
		gint _tmp1_;
		GString* _tmp2_;
		gint _tmp4_;
		GString* _tmp5_;
		gint _tmp6_;
		_tmp0_ = fgetc (self);
		c = _tmp0_;
		_tmp1_ = c;
		if (!(_tmp1_ != EOF)) {
			break;
		}
		_tmp2_ = ret;
		if (_tmp2_ == NULL) {
			GString* _tmp3_;
			_tmp3_ = g_string_new ("");
			_g_string_free0 (ret);
			ret = _tmp3_;
		}
		_tmp4_ = c;
		if (_tmp4_ == ((gint) '\n')) {
			break;
		}
		_tmp5_ = ret;
		_tmp6_ = c;
		g_string_append_c ((GString*) _tmp5_, (gchar) _tmp6_);
	}
	_tmp7_ = ret;
	if (_tmp7_ == NULL) {
		result = NULL;
		_g_string_free0 (ret);
		return result;
	} else {
		GString* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = ret;
		_tmp9_ = ((GString*) _tmp8_)->str;
		_tmp10_ = g_strdup (_tmp9_);
		result = _tmp10_;
		_g_string_free0 (ret);
		return result;
	}
	_g_string_free0 (ret);
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean gsd_swap_operation_swap_is_in_use (GsdSwapOperation* self, const gchar* swapdev) {
	gboolean result = FALSE;
	gboolean in_use;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint swapdev_len;
	FILE* _tmp3_ = NULL;
	FILE* file;
	FILE* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (swapdev != NULL, FALSE);
	in_use = FALSE;
	_tmp0_ = swapdev;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	swapdev_len = _tmp2_;
	_tmp3_ = g_fopen ("/proc/swaps", "r");
	file = _tmp3_;
	_tmp4_ = file;
	if (_tmp4_ != NULL) {
		gchar* line;
		FILE* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		line = NULL;
		_tmp5_ = file;
		_tmp6_ = g_file_stream_read_line (_tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp7_);
		{
			gboolean _tmp8_;
			_tmp8_ = TRUE;
			while (TRUE) {
				gboolean _tmp9_;
				FILE* _tmp14_;
				gchar* _tmp15_ = NULL;
				const gchar* _tmp16_;
				_tmp9_ = _tmp8_;
				if (!_tmp9_) {
					gboolean _tmp10_ = FALSE;
					const gchar* _tmp11_;
					gboolean _tmp13_;
					_tmp11_ = line;
					if (_tmp11_ != NULL) {
						gboolean _tmp12_;
						_tmp12_ = in_use;
						_tmp10_ = !_tmp12_;
					} else {
						_tmp10_ = FALSE;
					}
					_tmp13_ = _tmp10_;
					if (!_tmp13_) {
						break;
					}
				}
				_tmp8_ = FALSE;
				_tmp14_ = file;
				_tmp15_ = g_file_stream_read_line (_tmp14_);
				_g_free0 (line);
				line = _tmp15_;
				_tmp16_ = line;
				if (_tmp16_ != NULL) {
					gboolean _tmp17_ = FALSE;
					const gchar* _tmp18_;
					const gchar* _tmp19_;
					gboolean _tmp20_ = FALSE;
					gboolean _tmp25_;
					_tmp18_ = line;
					_tmp19_ = swapdev;
					_tmp20_ = g_str_has_prefix (_tmp18_, _tmp19_);
					if (_tmp20_) {
						const gchar* _tmp21_;
						gint _tmp22_;
						gchar _tmp23_ = '\0';
						gint _tmp24_ = 0;
						_tmp21_ = line;
						_tmp22_ = swapdev_len;
						_tmp23_ = string_get (_tmp21_, (glong) _tmp22_);
						_tmp24_ = string_index_of_char (" \t", (gunichar) _tmp23_, 0);
						_tmp17_ = _tmp24_ != (-1);
					} else {
						_tmp17_ = FALSE;
					}
					_tmp25_ = _tmp17_;
					in_use = _tmp25_;
				}
			}
		}
		_g_free0 (line);
	}
	result = in_use;
	_fclose0 (file);
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static GList* gsd_swap_operation_real_build_args (GsdAsyncOperation* base, GError** error) {
	GsdSwapOperation * self;
	GList* result = NULL;
	const gchar* _tmp0_;
	GList* args;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean _tmp5_;
	GList* _tmp8_ = NULL;
	GList* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	GError * _inner_error_ = NULL;
	self = (GsdSwapOperation*) base;
	_tmp0_ = self->priv->_device;
	g_return_val_if_fail (_tmp0_ != NULL, NULL);
	args = NULL;
	_tmp2_ = self->priv->_check_device;
	if (_tmp2_) {
		const gchar* _tmp3_;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = self->priv->_device;
		_tmp4_ = gsd_swap_operation_swap_is_in_use (self, _tmp3_);
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp5_ = _tmp1_;
	if (_tmp5_) {
		const gchar* _tmp6_;
		GError* _tmp7_;
		_tmp6_ = self->priv->_device;
		_tmp7_ = g_error_new (GSD_ASYNC_OPERATION_ERROR, GSD_ASYNC_OPERATION_ERROR_SUBCLASS_ERROR, "The swap device \"%s\" is in use", _tmp6_);
		_inner_error_ = _tmp7_;
		if (_inner_error_->domain == GSD_ASYNC_OPERATION_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free__g_free0_0 (args);
			return NULL;
		} else {
			__g_list_free__g_free0_0 (args);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp8_ = GSD_ASYNC_OPERATION_CLASS (gsd_swap_operation_parent_class)->build_args ((GsdAsyncOperation*) G_TYPE_CHECK_INSTANCE_CAST (self, GSD_TYPE_ZEROABLE_OPERATION, GsdZeroableOperation), &_inner_error_);
	_tmp9_ = _tmp8_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == GSD_ASYNC_OPERATION_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free__g_free0_0 (args);
			return NULL;
		} else {
			__g_list_free__g_free0_0 (args);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	__g_list_free__g_free0_0 (args);
	args = _tmp9_;
	_tmp10_ = self->priv->_device;
	_tmp11_ = g_strdup (_tmp10_);
	args = g_list_append (args, _tmp11_);
	result = args;
	return result;
}


static void gsd_swap_operation_real_cleanup (GsdAsyncOperation* base) {
	GsdSwapOperation * self;
	self = (GsdSwapOperation*) base;
	gsd_swap_operation_set_device (self, NULL);
}


/**
     * Launches a secure wiping of a swap device asynchronously.
     * 
     * @param device the swap device to wipe. It is exactly the same as setting
     *    the SwapOperation:device property, just a convenience shortcut.
     * 
     * @return whether subprocess started successfully.
     */
gboolean gsd_swap_operation_run (GsdSwapOperation* self, const gchar* device, GError** error) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = device;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		_tmp1_ = device;
		gsd_swap_operation_set_device (self, _tmp1_);
	}
	_tmp2_ = gsd_secure_delete_operation_run ((GsdSecureDeleteOperation*) G_TYPE_CHECK_INSTANCE_CAST (self, GSD_TYPE_ZEROABLE_OPERATION, GsdZeroableOperation), &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == G_SPAWN_ERROR) || (_inner_error_->domain == GSD_ASYNC_OPERATION_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp3_;
	return result;
}


/**
     * Launches a secure wiping of a swap device synchronously.
     * 
     * @param device the swap device to wipe. It is exactly the same as setting
     *    the SwapOperation:device property, just a convenience shortcut.
     * 
     * @return whether wiping of the swap device succeed.
     */
gboolean gsd_swap_operation_run_sync (GsdSwapOperation* self, const gchar* device, GError** error) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = device;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		_tmp1_ = device;
		gsd_swap_operation_set_device (self, _tmp1_);
	}
	_tmp2_ = gsd_secure_delete_operation_run_sync ((GsdSecureDeleteOperation*) G_TYPE_CHECK_INSTANCE_CAST (self, GSD_TYPE_ZEROABLE_OPERATION, GsdZeroableOperation), &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == G_SPAWN_ERROR) || (_inner_error_->domain == GSD_ASYNC_OPERATION_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp3_;
	return result;
}


GsdSwapOperation* gsd_swap_operation_construct (GType object_type) {
	GsdSwapOperation * self = NULL;
	self = (GsdSwapOperation*) gsd_zeroable_operation_construct (object_type);
	return self;
}


GsdSwapOperation* gsd_swap_operation_new (void) {
	return gsd_swap_operation_construct (GSD_TYPE_SWAP_OPERATION);
}


const gchar* gsd_swap_operation_get_device (GsdSwapOperation* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device;
	result = _tmp0_;
	return result;
}


void gsd_swap_operation_set_device (GsdSwapOperation* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_device);
	self->priv->_device = _tmp1_;
	g_object_notify ((GObject *) self, "device");
}


gboolean gsd_swap_operation_get_check_device (GsdSwapOperation* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_check_device;
	result = _tmp0_;
	return result;
}


void gsd_swap_operation_set_check_device (GsdSwapOperation* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_check_device = _tmp0_;
	g_object_notify ((GObject *) self, "check-device");
}


static GObject * gsd_swap_operation_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GsdSwapOperation * self;
	parent_class = G_OBJECT_CLASS (gsd_swap_operation_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GSD_TYPE_SWAP_OPERATION, GsdSwapOperation);
	gsd_async_operation_set_path ((GsdAsyncOperation*) self, SSWAP_PATH);
	return obj;
}


static void gsd_swap_operation_class_init (GsdSwapOperationClass * klass) {
	gsd_swap_operation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GsdSwapOperationPrivate));
	GSD_ASYNC_OPERATION_CLASS (klass)->build_args = gsd_swap_operation_real_build_args;
	GSD_ASYNC_OPERATION_CLASS (klass)->cleanup = gsd_swap_operation_real_cleanup;
	G_OBJECT_CLASS (klass)->get_property = _vala_gsd_swap_operation_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gsd_swap_operation_set_property;
	G_OBJECT_CLASS (klass)->constructor = gsd_swap_operation_constructor;
	G_OBJECT_CLASS (klass)->finalize = gsd_swap_operation_finalize;
	/**
	     * The swap device to wipe.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GSD_SWAP_OPERATION_DEVICE, g_param_spec_string ("device", "device", "device", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Whether to throw an error if the swap is detected as being currently
	     * used.
	     * 
	     * This may be useful because doing the operation on an in-use swap device
	     * may crash the system.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GSD_SWAP_OPERATION_CHECK_DEVICE, g_param_spec_boolean ("check-device", "check-device", "check-device", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gsd_swap_operation_instance_init (GsdSwapOperation * self) {
	self->priv = GSD_SWAP_OPERATION_GET_PRIVATE (self);
	self->priv->_device = NULL;
	self->priv->_check_device = TRUE;
}


static void gsd_swap_operation_finalize (GObject* obj) {
	GsdSwapOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GSD_TYPE_SWAP_OPERATION, GsdSwapOperation);
	_g_free0 (self->priv->_device);
	G_OBJECT_CLASS (gsd_swap_operation_parent_class)->finalize (obj);
}


/**
   * Wrapper for //sswap//.
   */
GType gsd_swap_operation_get_type (void) {
	static volatile gsize gsd_swap_operation_type_id__volatile = 0;
	if (g_once_init_enter (&gsd_swap_operation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GsdSwapOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gsd_swap_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GsdSwapOperation), 0, (GInstanceInitFunc) gsd_swap_operation_instance_init, NULL };
		GType gsd_swap_operation_type_id;
		gsd_swap_operation_type_id = g_type_register_static (GSD_TYPE_ZEROABLE_OPERATION, "GsdSwapOperation", &g_define_type_info, 0);
		g_once_init_leave (&gsd_swap_operation_type_id__volatile, gsd_swap_operation_type_id);
	}
	return gsd_swap_operation_type_id__volatile;
}


static void _vala_gsd_swap_operation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GsdSwapOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GSD_TYPE_SWAP_OPERATION, GsdSwapOperation);
	switch (property_id) {
		case GSD_SWAP_OPERATION_DEVICE:
		g_value_set_string (value, gsd_swap_operation_get_device (self));
		break;
		case GSD_SWAP_OPERATION_CHECK_DEVICE:
		g_value_set_boolean (value, gsd_swap_operation_get_check_device (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gsd_swap_operation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GsdSwapOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GSD_TYPE_SWAP_OPERATION, GsdSwapOperation);
	switch (property_id) {
		case GSD_SWAP_OPERATION_DEVICE:
		gsd_swap_operation_set_device (self, g_value_get_string (value));
		break;
		case GSD_SWAP_OPERATION_CHECK_DEVICE:
		gsd_swap_operation_set_check_device (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



