/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.Fqn;

/**
 * Value object used in evicted event node queue.
 *
 * @author Ben Wang 2-2004
 * @author Daniel Huang (dhuang@jboss.org)
 * @see org.jboss.cache.Region
 */
public class EvictedEventNode implements Cloneable
{
   private Fqn fqn_;
   private NodeEventType type;
   private int elementDifference;

   private long inUseTimeout;
   private long creationTimestamp;

   public EvictedEventNode(Fqn fqn, NodeEventType type, int elementDifference)
   {
      this(fqn, type);
      setElementDifference(elementDifference);
   }

   public EvictedEventNode(Fqn fqn, NodeEventType event)
   {
      setFqn(fqn);
      setEventType(event);
      creationTimestamp = System.currentTimeMillis();
   }

   public long getCreationTimestamp()
   {
      return creationTimestamp;
   }

   public long getInUseTimeout()
   {
      return inUseTimeout;
   }

   public void setInUseTimeout(long inUseTimeout)
   {
      this.inUseTimeout = inUseTimeout;
   }

   public int getElementDifference()
   {
      return elementDifference;
   }

   public void setElementDifference(int elementDifference_)
   {
      this.elementDifference = elementDifference_;
   }

   public Fqn getFqn()
   {
      return fqn_;
   }

   public void setFqn(Fqn fqn)
   {
      this.fqn_ = fqn;
   }

   public void setEventType(NodeEventType event)
   {
      type = event;
   }

   public NodeEventType getEventType()
   {
      return type;
   }

   @Override
   public String toString()
   {
      return "EvictedEN[fqn=" + fqn_ + " event=" + type + " diff=" + elementDifference + "]";
   }

   public EvictedEventNode clone(Fqn cloneFqn)
   {
      EvictedEventNode clone = null;
      try
      {
         clone = (EvictedEventNode) super.clone();
         clone.setFqn(Fqn.fromRelativeFqn(cloneFqn, fqn_));
      }
      catch (CloneNotSupportedException e)
      {
         // should never get here
      }
      return clone;
   }
}
