/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.eviction;

import static org.testng.AssertJUnit.assertEquals;
import static org.testng.AssertJUnit.assertTrue;

import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.xml.XmlHelper;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

/**
 * Unit tests for LRUConfiguration.
 *
 * @author Daniel Huang (dhuang@jboss.org)
 * @version $Revision: 4444 $
 */
@Test(groups = {"functional"})
public class LRUConfigurationTest
{

   public void testXMLParsing() throws Exception
   {
      LRUConfiguration config = new LRUConfiguration();
      String xml =
            "<region name=\"/org/jboss/data\">\n" +
                  "<attribute name=\"maxNodes\">5000</attribute>\n" +
                  "<attribute name=\"timeToLiveSeconds\">1000</attribute>\n" +
                  "</region>";

      Element element = XmlHelper.stringToElement(xml);

      XmlConfigurationParser.parseEvictionPolicyConfig(element, config);

      assertEquals(5000, config.getMaxNodes());
      assertEquals(1000, config.getTimeToLiveSeconds());
   }

   public void testXMLParsing2() throws Exception
   {
      LRUConfiguration config = new LRUConfiguration();
      String xml = "<region name=\"/maxAgeTest/\">\n" +
            "<attribute name=\"maxNodes\">10000</attribute>\n" +
            "<attribute name=\"timeToLiveSeconds\">8</attribute>\n" +
            "<attribute name=\"maxAgeSeconds\">10</attribute>\n" +
            "</region>";
      Element element = XmlHelper.stringToElement(xml);

      XmlConfigurationParser.parseEvictionPolicyConfig(element, config);

      assertEquals(10000, config.getMaxNodes());
      assertEquals(8, config.getTimeToLiveSeconds());
      assertEquals(10, config.getMaxAgeSeconds());
   }

   public void testXMLParsing3() throws Exception
   {
      LRUConfiguration config = new LRUConfiguration();
      String xml = "<region name=\"/maxAgeTest/\">\n" +
            "<attribute name=\"maxNodes\">10000</attribute>\n" +
            "<attribute name=\"maxAgeSeconds\">10</attribute>\n" +
            "</region>";
      Element element = XmlHelper.stringToElement(xml);
      boolean caught = false;
      try
      {
         XmlConfigurationParser.parseEvictionPolicyConfig(element, config);
      }
      catch (ConfigurationException ce)
      {
         caught = true;
      }
      assertTrue("Configure exception should have been caught", caught);

      xml = "<region name=\"/maxAgeTest/\">\n" +
            "<attribute name=\"timeToLiveSeconds\">8</attribute>\n" +
            "<attribute name=\"maxAgeSeconds\">10</attribute>\n" +
            "</region>";

      element = XmlHelper.stringToElement(xml);

      XmlConfigurationParser.parseEvictionPolicyConfig(element, config);

      assertEquals(0, config.getMaxNodes());
   }
}
