/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cdc.io.j2me.datagram;

import com.sun.cdc.io.ConnectionBase;
import com.sun.cdc.io.j2me.datagram.DatagramObject;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.microedition.io.Datagram;
import javax.microedition.io.DatagramConnection;
import javax.microedition.io.UDPDatagramConnection;

public class Protocol
extends ConnectionBase
implements DatagramConnection,
UDPDatagramConnection {
    DatagramSocket endpoint;
    private String host = null;
    private int port = 0;
    private boolean open;

    public String getLocalAddress() throws IOException {
        if (!this.open) {
            throw new IOException("Connection closed");
        }
        if (this.host != null) {
            return this.host;
        }
        return InetAddress.getLocalHost().getHostAddress();
    }

    public int getLocalPort() throws IOException {
        if (!this.open) {
            throw new IOException("Connection closed");
        }
        return this.endpoint.getLocalPort();
    }

    protected static String getAddress(String string) throws IOException {
        int n = string.indexOf(58);
        if (n < 0) {
            throw new IllegalArgumentException("No ':' in protocol name " + string);
        }
        if (n == 0) {
            return null;
        }
        return Protocol.parseHostName(string, n);
    }

    protected static String parseHostName(String string, int n) {
        if (string.indexOf("[") == 0 && string.indexOf("]") > 0) {
            return Protocol.parseIPv6Address(string, n);
        }
        return Protocol.parseIPv4Address(string, n);
    }

    protected static String parseIPv4Address(String string, int n) {
        return string.substring(0, n);
    }

    protected static String parseIPv6Address(String string, int n) {
        int n2 = string.indexOf("]");
        return string.substring(0, n2 + 1);
    }

    protected static int getPort(String string) throws IOException, NumberFormatException {
        int n = string.lastIndexOf(58);
        if (n < 0) {
            throw new IllegalArgumentException("No ':' in protocol name " + string);
        }
        return Integer.parseInt(string.substring(n + 1));
    }

    protected void checkPermission(String string, int n) {
    }

    protected void outputStreamPermissionCheck() {
    }

    protected void inputStreamPermissionCheck() {
    }

    public void open(String string, int n, boolean bl) throws IOException {
        if (string.charAt(0) != '/' || string.charAt(1) != '/') {
            throw new IllegalArgumentException("Protocol must start with \"//\" " + string);
        }
        if ((string = string.substring(2)).substring(string.indexOf(58) + 1).length() != 0) {
            this.host = Protocol.getAddress(string);
            this.port = Protocol.getPort(string);
            if (this.port <= 0) {
                throw new IllegalArgumentException("Bad port number \"//\" " + string);
            }
        }
        this.checkPermission(this.host, this.port);
        this.endpoint = this.host == null ? new DatagramSocket(this.port) : new DatagramSocket();
        this.open = true;
        try {
            byte[] byArray = new byte[256];
            DatagramPacket datagramPacket = new DatagramPacket(byArray, 256);
            if (this.host != null) {
                datagramPacket.setAddress(InetAddress.getByName(this.host));
            } else {
                datagramPacket.setAddress(InetAddress.getByName("localhost"));
            }
            datagramPacket.setPort(this.port);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid datagram address " + this.host + ":" + this.port);
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalArgumentException("Unknown host " + this.host + ":" + this.port);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public String getAddress() {
        InetAddress inetAddress = this.endpoint.getLocalAddress();
        return "datagram://" + inetAddress.getHostName() + ":" + inetAddress.getHostAddress();
    }

    public int getMaximumLength() throws IOException {
        try {
            int n = this.endpoint.getReceiveBufferSize();
            int n2 = this.endpoint.getSendBufferSize();
            return n < n2 ? n : n2;
        }
        catch (SocketException socketException) {
            throw new IOException(socketException.getMessage());
        }
    }

    public int getNominalLength() throws IOException {
        return this.getMaximumLength();
    }

    public void setTimeout(int n) {
    }

    public void send(Datagram datagram) throws IOException {
        DatagramObject datagramObject = (DatagramObject)datagram;
        this.endpoint.send(datagramObject.dgram);
    }

    public void receive(Datagram datagram) throws IOException {
        DatagramObject datagramObject = (DatagramObject)datagram;
        this.endpoint.receive(datagramObject.dgram);
        int n = datagramObject.dgram.getPort();
        String string = datagramObject.dgram.getAddress().getHostName();
        if (string != null) {
            try {
                datagramObject.setAddress("datagram://" + string + ":" + n);
            }
            catch (IOException iOException) {
                throw new RuntimeException("IOException in datagram::receive");
            }
        }
        try {
            datagramObject.setAddress("datagram://:" + n);
        }
        catch (IOException iOException) {
            throw new RuntimeException("IOException in datagram::receive");
        }
        datagramObject.pointer = 0;
    }

    public void close() throws IOException {
        if (this.open) {
            this.open = false;
        }
        this.endpoint.close();
    }

    public Datagram newDatagram(int n) throws IllegalArgumentException, IOException {
        if (n < 0) {
            throw new IllegalArgumentException("Size is negative: " + n);
        }
        return this.newDatagram(new byte[n], n);
    }

    public Datagram newDatagram(int n, String string) throws IOException, IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Size is negative: " + n);
        }
        return this.newDatagram(new byte[n], n, string);
    }

    public Datagram newDatagram(byte[] byArray, int n) throws IOException, IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Size is negative: " + n);
        }
        if (n > this.getMaximumLength()) {
            throw new IllegalArgumentException("Size: " + n + " is more than max size: " + this.getMaximumLength());
        }
        if (byArray == null) {
            throw new IllegalArgumentException("buf is null");
        }
        DatagramObject datagramObject = new DatagramObject(new DatagramPacket(byArray, n));
        if (this.host != null) {
            try {
                datagramObject.setAddress("datagram://" + this.host + ":" + this.port);
            }
            catch (IOException iOException) {
                throw new RuntimeException("IOException in datagram::newDatagram");
            }
        }
        return datagramObject;
    }

    public Datagram newDatagram(byte[] byArray, int n, String string) throws IOException, IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Size is negative: " + n);
        }
        if (n > this.getMaximumLength()) {
            throw new IllegalArgumentException("Size: " + n + " is more than max size: " + this.getMaximumLength());
        }
        if (string == null) {
            throw new IllegalArgumentException("addr is null");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("buf is null");
        }
        DatagramObject datagramObject = (DatagramObject)this.newDatagram(byArray, n);
        datagramObject.setAddress(string);
        return datagramObject;
    }
}

