/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file CdfGraphAttributes.cc
    \brief Implementation of CdfGraph Attributes class.
    \author Meteorological Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Mon Apr 15 17:55:21 2013
*/    

#include "CdfGraphAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


CdfGraphAttributes::CdfGraphAttributes():
	colour_(ParameterManager::getStringArray("cdf_lines_colour_array")),
	style_(ParameterManager::getStringArray("cdf_lines_style_array")),
	thickness_(ParameterManager::getIntArray("cdf_lines_thickness_array")),
	clim_colour_(MagTranslator<string, Colour>().magics("cdf_clim_line_colour")),
	clim_thickness_(ParameterManager::getInt("cdf_clim_line_thickness")),
	clim_style_(MagTranslator<string, LineStyle>().magics("cdf_clim_line_style"))
{
} 



CdfGraphAttributes::~CdfGraphAttributes()
{
}

    
void CdfGraphAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	prefix[0] = "cdf";

	setAttribute(prefix, "cdf_lines_colour_array", colour_, params);
	setAttribute(prefix, "cdf_lines_style_array", style_, params);
	setAttribute(prefix, "cdf_lines_thickness_array", thickness_, params);
	setAttribute(prefix, "cdf_clim_line_colour", clim_colour_, params);
	setAttribute(prefix, "cdf_clim_line_thickness", clim_thickness_, params);
	setAttribute(prefix, "cdf_clim_line_style", clim_style_, params);
}

void CdfGraphAttributes::copy(const CdfGraphAttributes& other)
{
	colour_ = other.colour_;
	style_ = other.style_;
	thickness_ = other.thickness_;
	clim_colour_ = auto_ptr<Colour>(other.clim_colour_->clone());
	clim_thickness_ = other.clim_thickness_;
	clim_style_ = other.clim_style_;
} 


bool CdfGraphAttributes::accept(const string& node)
{	
	if ( magCompare(node, "cdfgraph")  )
		return true;
	return false;
}

void CdfGraphAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "cdfgraph") )
		set(node.attributes());
	else {
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
	}
}

void CdfGraphAttributes::print(ostream& out)  const
{
	out << "CdfGraphAttributes[";
	out << "colour = " << colour_;
	out << ", style = " << style_;
	out << ", thickness = " << thickness_;
	out << ", clim_colour = " << *clim_colour_;
	out << ", clim_thickness = " << clim_thickness_;
	out << ", clim_style = " << clim_style_;
	out << "]" << "\n";
}


void CdfGraphAttributes::toxml(ostream& out)  const
{
     out <<  "\"cdfgraph\"";
	 out << ", \"cdf_lines_colour_array\":";
	 niceprint(out,colour_);
	 out << ", \"cdf_lines_style_array\":";
	 niceprint(out,style_);
	 out << ", \"cdf_lines_thickness_array\":";
	 niceprint(out,thickness_);
	 out << ", \"cdf_clim_line_colour\":";
	 niceprint(out, *clim_colour_);
	 out << ", \"cdf_clim_line_thickness\":";
	 niceprint(out,clim_thickness_);
	 out << ", \"cdf_clim_line_style\":";
	 niceprint(out,clim_style_);
}
static MagicsParameter<stringarray> cdf_lines_colour_array("cdf_lines_colour_array", stringarray(), "");
static MagicsParameter<stringarray> cdf_lines_style_array("cdf_lines_style_array", stringarray(), "");
static MagicsParameter<intarray> cdf_lines_thickness_array("cdf_lines_thickness_array", intarray(), "");
static MagicsParameter<string> cdf_clim_line_colour("cdf_clim_line_colour", "black", "");
static MagicsParameter<int> cdf_clim_line_thickness("cdf_clim_line_thickness", 4, "");
static MagicsParameter<string> cdf_clim_line_style("cdf_clim_line_style", "solid", "");
