/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQProductBrowser_H
#define MvQProductBrowser_H

#include <QDialog>
#include <QListWidget>
#include <QMap>
#include <QStyledItemDelegate>
#include <QStyleOptionViewItem>

#include <vector>

class QAbstractButton;
class QCloseEvent;
class QDialogButtonBox;
class QLineEdit;
class QListView;
class QListWidget;
class QSplitter;

class Product;
class MvQProductModel;

using namespace std;

//----------------------------
// MvQProductListDelegate
//----------------------------

class MvQProductListDelegate : public QStyledItemDelegate
{
public:
    MvQProductListDelegate(MvQProductModel*, int, QWidget* parent = 0);
    void paint(QPainter* painter, const QStyleOptionViewItem& option,
               const QModelIndex& index) const;
    QSize sizeHint(const QStyleOptionViewItem& option, const QModelIndex& index) const;

private:
    MvQProductModel* prodModel_;
    int itemHeight_;
};

//----------------------------
// MvQProductModel
//----------------------------

class MvQProductModel : public QAbstractItemModel
{
public:
    MvQProductModel(int, QObject* parent = 0);
    ~MvQProductModel();

    enum CustomItemRole
    {
        FolderPbRole    = Qt::UserRole + 1,
        VisPbRole       = Qt::UserRole + 2,
        DescriptionRole = Qt::UserRole + 3,
        PathRole        = Qt::UserRole + 4
    };

    int columnCount(const QModelIndex&) const;
    int rowCount(const QModelIndex& parent = QModelIndex()) const;
    QVariant data(const QModelIndex&, int role = Qt::DisplayRole) const;
    bool setData(const QModelIndex&, QRect, int);
    QModelIndex index(int, int, const QModelIndex& parent = QModelIndex()) const;
    QModelIndex parent(const QModelIndex&) const;

    void setProduct(const vector<Product*>&);

protected:
    static QPixmap pixmap(Product*);

    static int itemHeight_;
    vector<Product*> data_;
    static QMap<Product*, QPixmap> pixmaps_;
    QMap<QModelIndex, QRect> folderPbRect_;
    QMap<QModelIndex, QRect> visPbRect_;
};

//----------------------------
// MvQProductListView
//----------------------------

class MvQProductListView : public QListView
{
    Q_OBJECT

public:
    MvQProductListView(QWidget* parent = 0);

signals:
    void openFolder(const QModelIndex&);

protected:
    void mousePressEvent(QMouseEvent* event);
};

//----------------------------
// MvQProductListWidget
//----------------------------

class MvQProductListWidget : public QListWidget
{
public:
    MvQProductListWidget(QWidget* parent = 0);

protected:
    void mousePressEvent(QMouseEvent*);
    void mouseMoveEvent(QMouseEvent*);
    void performDrag();

    QPoint startPos_;
};

//----------------------------
// MvQProductBrowser
//----------------------------


class MvQProductBrowser : public QDialog
{
    Q_OBJECT

public:
    MvQProductBrowser(QWidget* parent = 0);
    ~MvQProductBrowser();

    void writeSettings();
    void readSettings();

public slots:
    void slotItemSelected(QListWidgetItem*);
    void slotSearch(QString);
    void slotOpenFolder(const QModelIndex&);
    void slotButtonClicked(QAbstractButton*);
signals:
    void openFolderInWin(QString);

protected:
    void closeEvent(QCloseEvent*);

    QMap<QString, MvQProductListWidget*> prodLists_;
    QLineEdit* searchLine_;
    MvQProductListView* searchList_;
    MvQProductModel* model_;
    QDialogButtonBox* buttonBox_;
};

#endif
