/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <QRegExp>
#include <QStringList>

#include <iostream>
#include <fstream>
#include <sstream>
#include "MvQHighlighter.h"

using namespace std;

MvQHighlighter::MvQHighlighter(QTextDocument* parent) :
    QSyntaxHighlighter(parent)
{
    HighlightingRule rule;

    //Keywords
    QTextCharFormat keywordFormat;

    keywordFormat.setForeground(Qt::darkBlue);
    keywordFormat.setFontWeight(QFont::Bold);

    QStringList keywordPatterns;
    keywordPatterns << "service"
                    << "version"
                    << "request"
                    << "layers"
                    << "srs"
                    << "bbox"
                    << "width"
                    << "height"
                    << "format"
                    << "styles"
                    << "transparent"
                    << "bgcolor"
                    << "exceptions"
                    << "crs";

    foreach (QString pattern, keywordPatterns) {
        //rule.pattern = QRegExp(pattern,Qt::CaseInsensitive);
        QString s    = pattern + "(?==)";
        rule.pattern = QRegExp(s, Qt::CaseInsensitive);
        rule.format  = keywordFormat;
        highlightingRules.append(rule);
    }

    QTextCharFormat builtInDimFormat;

    builtInDimFormat.setForeground(QColor(224, 138, 33));
    builtInDimFormat.setFontWeight(QFont::Bold);

    QStringList builtInDimPatterns;
    builtInDimPatterns << "time"
                       << "elevation";

    foreach (QString pattern, builtInDimPatterns) {
        //rule.pattern = QRegExp(pattern,Qt::CaseInsensitive);
        QString s    = pattern + "(?==)";
        rule.pattern = QRegExp(s, Qt::CaseInsensitive);
        rule.format  = builtInDimFormat;
        highlightingRules.append(rule);
    }


    //Dimensions
    QTextCharFormat dimFormat;

    dimFormat.setForeground(QColor(224, 138, 33));
    dimFormat.setFontWeight(QFont::Bold);

    rule.pattern = QRegExp("DIM_[^=]+(?==)", Qt::CaseInsensitive);
    rule.format  = dimFormat;
    highlightingRules.append(rule);

    //Server (URL)
    /*QTextCharFormat serverFormat;

	serverFormat.setForeground(Qt::red);
     	serverFormat.setFontWeight(QFont::Bold);
 
	rule.pattern = QRegExp("\\*\?\\b");
        rule.format = serverFormat;
        highlightingRules.append(rule);*/
}

void MvQHighlighter::highlightBlock(const QString& text)
{
    foreach (HighlightingRule rule, highlightingRules) {
        QRegExp expression(rule.pattern);
        int index = text.indexOf(expression);
        while (index >= 0) {
            int length = expression.matchedLength();
            setFormat(index, length, rule.format);
            index = text.indexOf(expression, index + length);
        }
    }
    setCurrentBlockState(0);

    /* int startIndex = 0;
     if (previousBlockState() != 1)
         startIndex = text.indexOf(commentStartExpression);

     while (startIndex >= 0) 
	{
         int endIndex = text.indexOf(commentEndExpression, startIndex);
         int commentLength;
         if (endIndex == -1) 
	{
             setCurrentBlockState(1);
             commentLength = text.length() - startIndex;
         } 
	else 
	{
             commentLength = endIndex - startIndex
                             + commentEndExpression.matchedLength();
         }
         setFormat(startIndex, commentLength, multiLineCommentFormat);
         startIndex = text.indexOf(commentStartExpression,
                                                 startIndex + commentLength);
     }*/
}


MvQWmsGetCapHighlighter::MvQWmsGetCapHighlighter(QTextDocument* parent) :
    QSyntaxHighlighter(parent)
{
    HighlightingRule rule;


    // Note that the order in which these highlighting rules are given
    // DOES matter! The rules seem to be applied in the order in which
    // they are given.

    // tag names
    tagNameFormat.setForeground(Qt::darkBlue);
    rule.pattern = QRegExp("(<\\w*)|(</\\w*>)|(>)");
    rule.format  = tagNameFormat;
    highlightingRules.append(rule);


    // tag symbols
    rule.pattern = QRegExp("(<)|(</)|(>)");
    rule.format  = tagSymbolsFormat;
    highlightingRules.append(rule);


    // attribute names
    attributeNameFormat.setForeground(Qt::red);
    rule.pattern = QRegExp("(\\w+\\s*)(?==)");  // (?==) means 'true if '=', but don't match it'
    rule.format  = attributeNameFormat;
    highlightingRules.append(rule);


    // strings
    quotationFormat.setForeground(Qt::darkRed);
    rule.pattern = QRegExp("(\"[^\"]*\")|(\'[^\']*\')");
    rule.format  = quotationFormat;
    highlightingRules.append(rule);


    // multi-line comments
    commentStartExpression = QRegExp("<!--");
    commentEndExpression   = QRegExp("-->");
    multiLineCommentFormat.setFontItalic(true);
    multiLineCommentFormat.setForeground(Qt::darkGreen);
}

void MvQWmsGetCapHighlighter::highlightBlock(const QString& text)
{
    foreach (HighlightingRule rule, highlightingRules) {
        QRegExp expression(rule.pattern);
        int index = text.indexOf(expression);
        while (index >= 0) {
            int length = expression.matchedLength();
            setFormat(index, length, rule.format);
            index = text.indexOf(expression, index + length);
        }
    }


    // multi-line comments

    setCurrentBlockState(0);

    int startIndex = 0;
    if (previousBlockState() != 1)
        startIndex = text.indexOf(commentStartExpression);

    while (startIndex >= 0) {
        int endIndex = text.indexOf(commentEndExpression, startIndex);
        int commentLength;
        if (endIndex == -1) {
            setCurrentBlockState(1);
            commentLength = text.length() - startIndex;
        }
        else {
            commentLength = endIndex - startIndex + commentEndExpression.matchedLength();
        }
        setFormat(startIndex, commentLength, multiLineCommentFormat);
        startIndex = text.indexOf(commentStartExpression,
                                  startIndex + commentLength);
    }
}
