/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef GEOGRAPHYTOOL_H
#define GEOGRAPHYTOOL_H

#include <QLineEdit>

#include "uPlotBase.h"
#include "MvRequest.h"

class GeoTool : public uPlotBase
{
    Q_OBJECT

public:
    GeoTool(MvRequest&, QWidget* parent = 0);
    ~GeoTool();

    MvRequest SuperPageRequest() { return spRequest_; }

    void newRequestForDriversBegin();
    void newRequestForDriversEnd();

public slots:
    void slotOk();
    void slotCoordChanged();
    void slotAreaSelection(double, double, double, double);
    void slotAreaIsUndefined();
    void slotLineSelection(double, double, double, double);
    void slotLineIsUndefined();
    void slotPointSelection(double, double);
    void slotPointIsUndefined();
    void slotPlotWindowUpdated();
    void slotSetActiveScene(MgQSceneItem*){};

signals:
    void areaChanged(double, double, double, double);
    void lineChanged(double, double, double, double);
    void pointChanged(double, double);

private:
    void setupInputSelectionActions();

    // Initialize parameters
    QString InitializeParams(MvRequest&);

    bool setDropTarget(QPoint);
    bool setDropTargetInView(QPoint);
    int currentStep() { return 0; }
    int stepNum() { return 0; }

    // Get input coordinates
    void UpdateCoordinates(QString&);

    // Translate coordinates to/from request
    QString requestToCoord(MvRequest&, const char*);
    void coordToRequest(QString&, MvRequest&, const char*);

    void readSettings();
    void writeSettings();

    QLineEdit* coordEdit_;  // geographical coordinates area
    QString coord_;         // coordinates
    MvRequest geoRequest_;  // request to be sent out to the caller
    MvRequest spRequest_;   // superpage request
    string inputType_;      // AREA, LINE, POINT
    string inputPar_;
    bool isFirstMap_;
};

#endif
