/*
    This file is part of svmcore.
    
    This code is written by Stefano Merler, merler@fbk.it.
    (C) 2008 Fondazione Bruno Kessler - Via Santa Croce 77, 38100 Trento, ITALY.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


#include <math.h>

double l1_distance(double x[],double y[],int n)
{
  int i;
  double out = 0.0;

  for(i=0;i<n;i++)
    out += fabs(x[i] - y[i]);

  return out;
}

double euclidean_squared_distance(double x[],double y[],int n)
{
  int i;
  double out = 0.0;
  double tmp;
  

  for(i=0;i<n;i++){
    tmp = x[i] - y[i];
    out += tmp * tmp;
  }
  

  return out;
}

double euclidean_distance(double x[],double y[],int n)
{
  int i;
  double out = 0.0;
  double tmp;
  

  for(i=0;i<n;i++){
    tmp = x[i] - y[i];
    out += tmp * tmp;
  }
  

  return sqrt(out);
}

  
double scalar_product(double x[],double y[],int n)
{
  double out;
  int i;

  out=0.0;
  for(i=0;i<n;i++)
    out += x[i] * y[i];

  return out;
}

double euclidean_norm(double x[],int n)
{
  return sqrt(scalar_product(x,x,n));
}
    
